(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    482196,      11353]
NotebookOptionsPosition[    471220,      11060]
NotebookOutlinePosition[    471564,      11075]
CellTagsIndexPosition[    471521,      11072]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "This", " ", "notebook", " ", "contains", " ", "examples", " ", "for", 
     " ", "the", " ", "PET"}], "-", "functions", "\[IndentingNewLine]", "-", 
    "ActivityB", "-", "          ", 
    RowBox[{
    "calculate", " ", "the", " ", "activity", " ", "of", " ", "a", " ", 
     "phase", " ", "component", " ", 
     RowBox[{"(", 
      RowBox[{"exclusive", " ", "fluids"}], ")"}]}], "\[IndentingNewLine]", 
    "-", "GammaSymbolic", "-", "     ", 
    RowBox[{"calculate", " ", "symbolic", " ", "expressions", " ", "for", " ", 
     RowBox[{"RTln", "[", "gamma", "]"}], " ", "and", " ", "Gex"}], 
    "\[IndentingNewLine]", "-", "GammaBB", "-", "           ", 
    RowBox[{
    "calculate", " ", "a", " ", "symbolic", " ", "expression", " ", "for", 
     " ", 
     RowBox[{"RTln", "[", "gamma", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Berman", " ", "&"}], " ", "Brown", " ", 
        RowBox[{"(", "1985", ")"}]}], "-", "formalism"}], ")"}]}], 
    "\[IndentingNewLine]", "-", "MargulesB", "-", "          ", 
    RowBox[{
    "calculate", " ", "Margules", " ", "mixing", " ", "parameters", " ", 
     "for", " ", "certain", " ", "solid", " ", "solutions"}], 
    "\[IndentingNewLine]", "-", "FluidActivity", "-", "     ", 
    RowBox[{"calculate", " ", "activities", " ", "in", " ", "H2O"}], "-", 
    RowBox[{"CO2", " ", "or", " ", "H2O"}], "-", 
    RowBox[{"H2", " ", "fluids"}]}], "\[IndentingNewLine]", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"This", " ", "top"}], "-", 
    RowBox[{
    "cell", " ", "must", " ", "be", " ", "run", " ", "once", " ", "before", 
     " ", "any", " ", "example", " ", "can", " ", "be", " ", 
     RowBox[{"performed", "."}]}]}], "  ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Define", " ", "the", " ", "directory"}], ",", 
    RowBox[{
     RowBox[{"where", " ", "the", " ", "PET"}], "-", 
     RowBox[{"files", " ", "reside", " ", 
      RowBox[{"(", 
       RowBox[{"e", ".", "g", ".", " ", 
        RowBox[{"C", ":", 
         RowBox[{
          RowBox[{"\\", "Eigene"}], " ", 
          RowBox[{"Dateien", "\\", "Pet"}]}]}]}], ")"}], " ", "and", " ", 
      "load", " ", 
      RowBox[{"PET", "."}]}]}]}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{
    "$PetDirectory", "=", 
     "\"\<C:\\Dokumente und Einstellungen\\dachsedgar\\Eigene \
Dateien\\Pet\\Pet7.0\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "$PetDirectory", "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"DeclarePackage", "[", 
     RowBox[{"\"\<DEFDAT`\>\"", ",", 
      RowBox[{"{", "\"\<Dataset\>\"", "}"}]}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "->", " ", "B88"}], "]"}], ";"}], " "}]}]], "Input",
 CellChangeTimes->{
  3.42270231684375*^9, {3.4857519852556305`*^9, 3.4857519857243805`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
     "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
     "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
     "___", "\[IndentingNewLine]", "\t\t\t\t", "Examples", " ", "for", " ", 
     "use", " ", "of", " ", "the", " ", "Pet"}], "-", 
    RowBox[{"Function", ":", "\t\t", 
     RowBox[{
      RowBox[{"-", "ActivityB"}], "-", "\[IndentingNewLine]", 
      RowBox[{
      "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
       "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
       "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
       "__"}]}]}]}], "  ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Example", " ", "1"}], ":", " ", 
      RowBox[{
       RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
       "ActivityB", "-", " ", 
       RowBox[{
       "to", " ", "calculate", " ", "a", " ", "symbolic", " ", "expression", 
        " ", "for", " ", "the", " ", "ideal", " ", "activity", " ", "of", " ",
         "a", " ", "phase"}], "-", "component"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Values", " ", "of", " ", "p"}]}], ",", " ", 
    RowBox[{
    "t", " ", "and", " ", "x", " ", "are", " ", "irrelevant", " ", "in", " ", 
     "this", " ", "case"}]}], "   ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"ActivityB", "[", 
   RowBox[{"p", ",", "t", ",", "ann", ",", "\"\<\>\"", ",", 
    RowBox[{"ActivityMode", "\[Rule]", "IdealActivitySymbolic"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{3.4227025085*^9, 3.4227034170625*^9}],

Cell[BoxData["\<\"aid(ann)=XFeM^3*XKA*XOH^2\"\>"], "Output",
 CellChangeTimes->{
  3.4227015783125*^9, 3.422702342921875*^9, 3.42270247225*^9, 
   3.422702511265625*^9, 3.42270257528125*^9, 3.4227026915625*^9, 
   3.42270277453125*^9, 3.42270288871875*^9, {3.422703402296875*^9, 
   3.422703418015625*^9}, 3.4227035151875*^9, 3.42270370025*^9, 
   3.422703772640625*^9, 3.422704074671875*^9, {3.422707843140625*^9, 
   3.422707855671875*^9}, 3.422768559453125*^9, 3.46096659125*^9, 
   3.485751568676689*^9, 3.4857516390521393`*^9, {3.485752017505495*^9, 
   3.4857520401928496`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Example", " ", "2"}], ":", 
      RowBox[{
       RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", "-", 
       "ActivityB", "-", 
       RowBox[{
       "to", " ", "calculate", " ", "the", " ", "ideal", " ", "activity", " ",
         "of", " ", "a", " ", "phase"}], "-", 
       RowBox[{"component", ":", 
        RowBox[{"(", 
         RowBox[{
         "in", " ", "this", " ", "case", " ", "for", " ", "annite", " ", 
          "from", " ", "the", " ", "biotite", " ", "data", " ", "in", " ", 
          "\"\<hs78b\>\""}], ")"}]}]}]}], ";", " ", "\[IndentingNewLine]", 
     RowBox[{"Values", " ", "of", " ", "p"}]}], ",", 
    RowBox[{
    "t", " ", "and", " ", "x", " ", "are", " ", "irrelevant", " ", "in", " ", 
     "this", " ", 
     RowBox[{"case", ".", " ", "Note"}], " ", "that", " ", "you", " ", "must",
      " ", "have", " ", "used", " ", 
     RowBox[{"CalcFormula", "[", "\"\<hs78b\>\"", "]"}], " ", "before", " ", 
     "and", " ", 
     RowBox[{"Cmp", ".", "exe"}], " ", "to", " ", "create", " ", "the", " ", 
     "file", " ", 
     RowBox[{"hs78b", ".", "cmp"}], " ", 
     RowBox[{"(", 
      RowBox[{
      "if", " ", "you", " ", "got", " ", "an", " ", "error", " ", "message", 
       " ", "reload", " ", "the", " ", "kernel", " ", "and", " ", "do", " ", 
       "that", " ", "before", " ", "trying", " ", "this", " ", 
       RowBox[{"example", "."}]}], " "}]}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"ActivityB", "[", 
   RowBox[{"p", ",", "t", ",", "ann", ",", "x", ",", 
    RowBox[{"ActivityMode", "\[Rule]", "IdealActivity"}], ",", 
    RowBox[{"ActivitySampleFile", "\[Rule]", "\"\<hs78b\>\""}]}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.049564093446046405`", ",", "\<\"a(ann)=Ideal\"\>"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.4227035471875*^9, 3.422704082546875*^9, 3.422707857203125*^9, 
   3.422768561203125*^9, 3.460966593140625*^9, 3.485751568692314*^9, 
   3.485751640411523*^9, {3.485752017505495*^9, 3.485752040208474*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "3", 
     RowBox[{"a", ":", " ", 
      RowBox[{
       RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
       "ActivityB", "-", " ", 
       RowBox[{
       "to", " ", "calculate", " ", "the", " ", "activity", " ", "of", " ", 
        "a", " ", "phase"}], "-", 
       RowBox[{"component", ":", " ", "\[IndentingNewLine]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{
           "in", " ", "this", " ", "case", " ", "for", " ", "annite", " ", 
            "from", " ", "the", " ", "biotite", " ", "data", " ", "in", " ", 
            "\"\<hs78b.cmp\>\"", " ", "for", " ", "P"}], " ", "=", " ", 
           RowBox[{"5000", " ", "bar"}]}], ",", " ", 
          RowBox[{"T", " ", "=", " ", 
           RowBox[{"500", " ", "C"}]}]}], ")"}]}]}]}]}], ";", " ", 
    "\[IndentingNewLine]", 
    RowBox[{
    "Value", " ", "of", " ", "x", " ", "is", " ", "irrelevant", " ", "in", 
     " ", "this", " ", "case", " ", "because", " ", "data", " ", "are", " ", 
     "read", " ", "from", " ", "the", " ", "specified", " ", "sample", " ", 
     "file"}]}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"ActivityB", "[", 
   RowBox[{"5000", ",", 
    RowBox[{"500", "+", "273"}], ",", "ann", ",", "x", ",", 
    RowBox[{"ActivitySampleFile", "->", "\"\<hs78b\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.06173333668713169`", ",", "\<\"a(ann)=BtMcMullin\"\>"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.42270408771875*^9, 3.422707858703125*^9, 3.422768562828125*^9, 
   3.4609665953125*^9, 3.485751568707939*^9, 3.4857516421302843`*^9, {
   3.4857520175211196`*^9, 3.485752040224099*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "3", 
      RowBox[{"b", ":", " ", 
       RowBox[{
        RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
        "ActivityB", "-", " ", 
        RowBox[{
        "to", " ", "calculate", " ", "the", " ", "activity", " ", "of", " ", 
         "a", " ", "phase"}], "-", 
        RowBox[{"component", " ", "for", " ", "P"}]}]}]}], " ", "=", " ", 
     RowBox[{"5000", " ", "bar"}]}], ",", " ", 
    RowBox[{"T", " ", "=", " ", 
     RowBox[{"500", " ", "C"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Explicit", " ", "use", " ", "of", " ", "the"}], " ", "<", "x", 
     ">", " ", 
     RowBox[{"parameter", " ", 
      RowBox[{"(", 
       RowBox[{"data", " ", "copied", " ", "from", " ", 
        RowBox[{"hs78b", ".", "cmp"}]}], ")"}], " ", "representing", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "XK", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"XMgM", ",", "XFeM", ",", "XTiM", ",", "XAlM"}], "}"}], ",", 
        RowBox[{"{", "XOH", "}"}]}], "}"}], "\[IndentingNewLine]", "To", " ", 
      "see", " ", "how", " ", "the", " ", "structure", " ", "of"}], " ", "<", 
     "x", ">", " ", 
     RowBox[{"must", " ", "be"}]}], ",", " ", 
    RowBox[{"consult", " ", "the", " ", "file", " ", 
     RowBox[{"ACTIVITYBDAT", ".", "M"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "0.7618", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.3922", ",", "0.4022", ",", "0.0282", ",", "0.1747"}], 
        "}"}], ",", 
       RowBox[{"{", "1.", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"ActivityB", "[", 
    RowBox[{"5000", ",", 
     RowBox[{"500", "+", "273"}], ",", "ann", ",", "x"}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.06173333668713169`", ",", "\<\"a(ann)=BtMcMullin\"\>"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.4227040943125*^9, 3.4227078600625*^9, 3.42276856440625*^9, 
   3.460966596375*^9, 3.4857515687391896`*^9, 3.485751643630294*^9, {
   3.485752017536744*^9, 3.485752040239724*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "4"}], ":", " ", 
     RowBox[{
      RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
      "ActivityB", "-", " ", 
      RowBox[{
      "to", " ", "calculate", " ", "the", " ", "activity", " ", "coefficient",
        " ", "of", " ", "a", " ", "phase"}], "-", 
      RowBox[{"component", ":", " ", "\[IndentingNewLine]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
          "in", " ", "this", " ", "case", " ", "for", " ", "grossular", " ", 
           "from", " ", "the", " ", "garnet", " ", "data", " ", "in", " ", 
           "\"\<hs78b.cmp\>\"", " ", "for", " ", "P"}], " ", "=", " ", 
          RowBox[{"5000", " ", "bar"}]}], ",", " ", 
         RowBox[{"T", " ", "=", " ", 
          RowBox[{"500", " ", "C"}]}]}], ")"}]}]}]}], ";", " ", 
    "\[IndentingNewLine]", 
    RowBox[{
    "Value", " ", "of", " ", "x", " ", "is", " ", "irrelevant", " ", "in", 
     " ", "this", " ", "case", " ", "because", " ", "data", " ", "are", " ", 
     "read", " ", "from", " ", "specified", " ", "sample", " ", "file"}]}], 
   " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"ActivityB", "[", 
   RowBox[{"5000", ",", 
    RowBox[{"500", "+", "273"}], ",", "gr", ",", "x", ",", 
    RowBox[{"ActivitySampleFile", "->", "\"\<hs78b\>\""}], ",", 
    RowBox[{"ActivityMode", "\[Rule]", "ActivityCoefficient"}]}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.8662453775184846`", ",", "\<\"y(gr)=GrtBerman\"\>"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.42270409975*^9, 3.422707861578125*^9, 3.422768565734375*^9, 
   3.46096659796875*^9, 3.485751568754815*^9, 3.4857516460834346`*^9, {
   3.485752017552369*^9, 3.485752040255349*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Example", " ", "5"}], ":", " ", 
      RowBox[{
       RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
       "ActivityB", "-", " ", 
       RowBox[{
       "to", " ", "display", " ", "the", " ", "activity", " ", "model", " ", 
        "of", " ", "a", " ", "phase"}], "-", 
       RowBox[{"component", ":", " ", 
        RowBox[{"(", 
         RowBox[{"in", " ", "this", " ", "case", " ", "for", " ", "biotite"}],
          ")"}]}]}]}], ";", " ", "\[IndentingNewLine]", 
     RowBox[{"Values", " ", "of", " ", "p"}]}], ",", " ", 
    RowBox[{
    "t", " ", "and", " ", "x", " ", "are", " ", "irrelevant", " ", "in", " ", 
     "this", " ", "case"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"ActivityB", "[", 
   RowBox[{"p", ",", "t", ",", "phl", ",", "x", ",", 
    RowBox[{"ActivityMode", "\[Rule]", "DisplayActivityModel"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.4227041056875*^9, 3.42270410609375*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Activity-model for: \"\>", "\[InvisibleSpace]", "\<\"bt\"\>", 
   "\[InvisibleSpace]", "\<\" (one-site basis). Number \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" in data file.\"\>"}],
  SequenceForm[
  "Activity-model for: ", "bt", " (one-site basis). Number ", 2, 
   " in data file."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.485752040270974*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ideal activity: aid(\"\>", "\[InvisibleSpace]", "\<\"phl\"\>", 
   "\[InvisibleSpace]", "\<\") = \"\>", "\[InvisibleSpace]", 
   RowBox[{"XKA", " ", 
    SuperscriptBox["XMgM", "3"], " ", 
    SuperscriptBox["XOH", "2"]}]}],
  SequenceForm[
  "Ideal activity: aid(", "phl", 
   ") = ", $CellContext`XKA $CellContext`XMgM^3 $CellContext`XOH^2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.485752040270974*^9}}],

Cell[BoxData["\<\"___________________________________\"\>"], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.4857520402865987`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Activity-model \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"BtMcMullin\"\>"}],
  SequenceForm["Activity-model ", 1, ": ", "BtMcMullin"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.4857520402865987`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Site \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" {name, occupancy}: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", 
     RowBox[{"{", "\<\"K\"\>", "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" Ideal\"\>"}],
  SequenceForm["Site ", 1, " {name, occupancy}: ", {"A", {"K"}}, " Ideal"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.4857520403022237`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Site \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" {name, occupancy}: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"M\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Mg\"\>", ",", "\<\"Fe\"\>", ",", "\<\"Ti\"\>", 
       ",", "\<\"Al\"\>"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" NonIdeal\"\>"}],
  SequenceForm[
  "Site ", 2, " {name, occupancy}: ", {"M", {"Mg", "Fe", "Ti", "Al"}}, 
   " NonIdeal"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.4857520403178487`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Margules parameters displayed as square-matrix: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Mg\"\>", ",", "\<\"Fe\"\>", ",", "\<\"Ti\"\>", 
     ",", "\<\"Al\"\>"}], "}"}], "\[InvisibleSpace]", "\<\" x \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Mg\"\>", ",", "\<\"Fe\"\>", ",", "\<\"Ti\"\>", 
     ",", "\<\"Al\"\>"}], "}"}]}],
  SequenceForm[
  "Margules parameters displayed as square-matrix: ", {
   "Mg", "Fe", "Ti", "Al"}, " x ", {"Mg", "Fe", "Ti", "Al"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.4857520403178487`*^9}}],

Cell[BoxData["\<\"Each matrix-element is {WH, WS, WV} on a one-site basis. \
Units: J, bar, mol.\"\>"], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.4857520403334737`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"19621.666666666668`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"25000.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"10307.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"21240.333333333332`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"19621.666666666668`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"10307.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"25000.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"21240.333333333332`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.485752040349098*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ternary parameter(s): \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "}"}]}],
  SequenceForm["Ternary parameter(s): ", {{{1, 2, 3}, {0, 0, 0}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.485752040364723*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Site \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" {name, occupancy}: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"\"\>", ",", 
     RowBox[{"{", "\<\"OH\"\>", "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" Ideal\"\>"}],
  SequenceForm["Site ", 3, " {name, occupancy}: ", {"", {"OH"}}, " Ideal"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.485752040380348*^9}}],

Cell[BoxData["\<\"___________________________________\"\>"], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.485752040395973*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Activity-model \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"BtBenisek\"\>"}],
  SequenceForm["Activity-model ", 2, ": ", "BtBenisek"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.485752040411598*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Site \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" {name, occupancy}: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", 
     RowBox[{"{", "\<\"K\"\>", "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" Ideal\"\>"}],
  SequenceForm["Site ", 1, " {name, occupancy}: ", {"A", {"K"}}, " Ideal"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.485752040442848*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Site \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" {name, occupancy}: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"M\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Mg\"\>", ",", "\<\"Fe\"\>", ",", "\<\"Ti\"\>", 
       ",", "\<\"Al\"\>"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" NonIdeal\"\>"}],
  SequenceForm[
  "Site ", 2, " {name, occupancy}: ", {"M", {"Mg", "Fe", "Ti", "Al"}}, 
   " NonIdeal"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.4857520404584727`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Margules parameters displayed as square-matrix: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Mg\"\>", ",", "\<\"Fe\"\>", ",", "\<\"Ti\"\>", 
     ",", "\<\"Al\"\>"}], "}"}], "\[InvisibleSpace]", "\<\" x \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Mg\"\>", ",", "\<\"Fe\"\>", ",", "\<\"Ti\"\>", 
     ",", "\<\"Al\"\>"}], "}"}]}],
  SequenceForm[
  "Margules parameters displayed as square-matrix: ", {
   "Mg", "Fe", "Ti", "Al"}, " x ", {"Mg", "Fe", "Ti", "Al"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.4857520404740973`*^9}}],

Cell[BoxData["\<\"Each matrix-element is {WH, WS, WV} on a one-site basis. \
Units: J, bar, mol.\"\>"], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.4857520404897223`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"7600.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "9666.666666666666`"}]},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"7600.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "9666.666666666666`"}]},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.4857520405209723`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ternary parameter(s): \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "}"}]}],
  SequenceForm["Ternary parameter(s): ", {{{1, 2, 3}, {0, 0, 0}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.4857520405365973`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Site \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" {name, occupancy}: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"\"\>", ",", 
     RowBox[{"{", "\<\"OH\"\>", "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" Ideal\"\>"}],
  SequenceForm["Site ", 3, " {name, occupancy}: ", {"", {"OH"}}, " Ideal"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422701712328125*^9, 3.4227041083125*^9, 3.4227078633125*^9, 
   3.422768566828125*^9, 3.46096660009375*^9, 3.485751568786065*^9, 
   3.4857516481303225`*^9, {3.485752017567994*^9, 3.4857520405678473`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Example", " ", "6"}], ":", " ", 
      RowBox[{
       RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
       "ActivityB", "-", " ", 
       RowBox[{"to", " ", "plot", " ", "one"}], "-", 
       RowBox[{"site", " ", "normalized", " ", "activity"}], "-", 
       RowBox[{"coefficients", " ", "of", " ", "the", " ", "pyrope"}], "-", 
       " ", 
       RowBox[{"and", " ", "grossular", " ", "phase"}], "-", 
       RowBox[{"components", " ", "at", " ", "P"}]}]}], " ", "=", " ", 
     RowBox[{"5000", " ", "bar"}]}], ",", " ", 
    RowBox[{"T", " ", "=", " ", 
     RowBox[{"500", " ", "C"}]}], ",", "  ", 
    RowBox[{
     RowBox[{"along", " ", "the", " ", "grossular"}], " ", "-", " ", 
     RowBox[{"pyrope", " ", "join"}]}], ",", " ", 
    RowBox[{
     RowBox[{
     "comparing", " ", "the", " ", "Margules", " ", "parameters", " ", "of", 
      " ", "Ganguly", " ", 
      RowBox[{"(", "1996", ")"}], " ", "and", " ", "Berman", " ", 
      RowBox[{"(", "1990", ")"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
     "This", " ", "examples", " ", "does", " ", "not", " ", "specify", " ", 
      "a", " ", "data", " ", "file"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "but", " ", "mole", " ", "fractions", " ", "are", " ", "directly", " ", 
       "used", " ", "in", " ", "the", " ", "call", " ", "to"}], " ", "-", 
      "ActivityB", "-", " ", "instead"}], ";", "\[IndentingNewLine]", 
     RowBox[{
     "As", " ", "can", " ", "be", " ", "seen", " ", "by", " ", "inspecting", 
      " ", "the", " ", "file", " ", "\"\<hs78b.fu\>\"", " ", "or", " ", 
      "\"\<ACTIVIYBDAT.M\>\""}]}], ",", " ", 
    RowBox[{"these", " ", "must", " ", "be", " ", "of", " ", "the", " ", 
     RowBox[{"form", ":", " ", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "\"\<XCa\>\"", ",", "\"\<XMg\>\"", ",", "\"\<XFe\>\"", ",", 
           "\"\<XMn\>\""}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<XAl\>\"", ",", "\"\<XFe3\>\""}], "}"}]}], "}"}], "  ", 
       "for", " ", 
       RowBox[{"garnet", "."}]}]}]}]}], "\[IndentingNewLine]", " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "calculate", " ", "gammas", " ", "with", " ", "Ganguly", " ", 
    "parameters"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"p1", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"ActivityB", "[", 
          RowBox[{"5000", ",", "773", ",", "py", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1", "-", "x"}], ",", "x", ",", "0", ",", "0"}], "}"}],
              ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
           RowBox[{"ActivityMode", "\[Rule]", "ActivityCoefficient"}], ",", 
           RowBox[{"ActivityModelGrt", "\[Rule]", "GrtGanguly"}]}], "]"}], 
         "[", 
         RowBox[{"[", "1", "]"}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "3"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"p2", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"ActivityB", "[", 
          RowBox[{"5000", ",", "773", ",", "gr", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1", "-", "x"}], ",", "x", ",", "0", ",", "0"}], "}"}],
              ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
           RowBox[{"ActivityMode", "\[Rule]", "ActivityCoefficient"}], ",", 
           RowBox[{"ActivityModelGrt", "\[Rule]", "GrtGanguly"}]}], "]"}], 
         "[", 
         RowBox[{"[", "1", "]"}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "3"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"plot1", "=", 
     RowBox[{"Show", "[", 
      RowBox[{"p1", ",", "p2", ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculate", " ", "gammas", " ", "with", " ", "Berman", " ", 
     "parameters"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p1", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"ActivityB", "[", 
          RowBox[{"5000", ",", "773", ",", "py", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1", "-", "x"}], ",", "x", ",", "0", ",", "0"}], "}"}],
              ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
           RowBox[{"ActivityMode", "\[Rule]", "ActivityCoefficient"}], ",", 
           RowBox[{"ActivityModelGrt", "\[Rule]", "GrtBerman"}]}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "3"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"p2", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"ActivityB", "[", 
          RowBox[{"5000", ",", "773", ",", "gr", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1", "-", "x"}], ",", "x", ",", "0", ",", "0"}], "}"}],
              ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
           RowBox[{"ActivityMode", "\[Rule]", "ActivityCoefficient"}], ",", 
           RowBox[{"ActivityModelGrt", "\[Rule]", "GrtBerman"}]}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "3"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"plot2", "=", 
     RowBox[{"Show", "[", 
      RowBox[{"p1", ",", "p2", ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"display", " ", "plots", " ", "together"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"plot1", ",", "plot2"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.42270412946875*^9, 3.422704162203125*^9}, {
  3.422704225796875*^9, 3.422704236390625*^9}}],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8Fd0bAPBruUObPSVRpF6RSGWN59hKtgipVEpIKmsL3rJVVEiLJCVU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       "]]}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c41e8bB3ArSX3tZEtZFZKM+Mb9ycjop8jK+FopRUmSJAlFJZuMEtmh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       "]]}}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk4VO8XAPAxd0SyZomUJZLI8pMtybmkKFtZKiXZK1uSQpSlkiypqEi0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       "]]}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c4lV8cAHCzVGT+ZI+SFEkySur7WikjO2SUWUkIIZQRkplIVCIjOyQZ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       "]]}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.},
  PlotRange->{{0, 1}, {0, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.42270413221875*^9, 3.4227042013125*^9, 3.422704242234375*^9, 
   3.42270786746875*^9, 3.422768571859375*^9, 3.46096660384375*^9, 
   3.4857515709423285`*^9, 3.485751651895972*^9, {3.4857520189117355`*^9, 
   3.4857520416147156`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "7"}], ":", " ", 
    RowBox[{
     RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
     "ActivityB", "-", " ", 
     RowBox[{
     "to", " ", "calculate", " ", "activities", " ", "of", " ", "garnet", " ",
       "phase"}], "-", 
     RowBox[{
     "components", " ", "\[IndentingNewLine]", "for", " ", "garnet", " ", 
      "analyses", " ", "from", " ", "file", " ", 
      RowBox[{"\"\<pet2\>\"", "."}]}]}]}], " ", "*)"}], "\[IndentingNewLine]",
   "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"calculate", " ", "the", " ", "mineral", " ", "formulae"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"file", " ", "=", " ", "\"\<pet2\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "oxides", ",", "analyses", ",", "oxygens", ",", "dataset", ",", 
       "date"}], "}"}], " ", "=", " ", 
     RowBox[{"CalcFormula", "[", 
      RowBox[{"file", ",", "  ", 
       RowBox[{"CalcFormulaMode", "\[Rule]", 
        RowBox[{"{", "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "loop", " ", "through", " ", "the", " ", "mineral", " ", "analyses", 
       " ", "and", " ", "for", " ", "all", " ", "garnet", " ", "analyses", 
       " ", "calculate", " ", "the", " ", "activity", " ", "of", " ", 
       "garnet"}], "-", 
      RowBox[{
      "phase", " ", "components", " ", "for", " ", "predefined", " ", "P", 
       " ", "and", " ", 
       RowBox[{"T", ".", " ", "Data"}], " ", "are", " ", "saved", " ", "in", 
       " ", "the", " ", "variables", " ", "xxfe"}]}], ",", " ", "xxmg", ",", 
     " ", "xxca", ",", " ", "xxmn", ",", " ", "aalm", ",", " ", "apy", ",", 
     " ", 
     RowBox[{"agr", " ", "for", " ", "further", " ", 
      RowBox[{"use", "."}]}]}], " ", "*)"}], " ", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"define", " ", "P"}], ",", " ", 
     RowBox[{
     "T", " ", "and", " ", "garnet", " ", "activity", " ", "model"}]}], "  ", 
    "*)"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.42270793740625*^9, {3.42276862065625*^9, 3.4227686611875*^9}, {
   3.422768747953125*^9, 3.422768768734375*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"pet2.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "pet2.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.42276863253125*^9, 3.42276866375*^9, {3.42276876*^9, 
   3.422768770953125*^9}, 3.4609666065*^9, 3.485751571848584*^9, 
   3.4857516578335094`*^9, {3.485752019833605*^9, 3.48575204252096*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", " ", "=", " ", "7500"}], ";", " ", 
   RowBox[{"t", " ", "=", " ", 
    RowBox[{"500", "+", "273.15"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"model", " ", "=", " ", "GrtGangulySaxena"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "save", " ", "data", " ", "in", " ", "the", " ", "variables", " ", 
     "xxfe"}], ",", " ", "xxmg", ",", " ", "xxca", ",", " ", "xxmn", ",", " ",
     "aalm", ",", " ", "apy", ",", " ", "agr"}], "  ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xxfe", " ", "=", " ", 
   RowBox[{"{", "}"}]}], ";", " ", 
  RowBox[{"xxmg", " ", "=", " ", 
   RowBox[{"{", "}"}]}], ";", " ", 
  RowBox[{"xxca", " ", "=", " ", 
   RowBox[{"{", "}"}]}], ";", " ", 
  RowBox[{"xxmn", " ", "=", " ", 
   RowBox[{"{", "}"}]}], ";", " ", 
  RowBox[{"aalm", " ", "=", " ", 
   RowBox[{"{", "}"}]}], ";", " ", 
  RowBox[{"apy", " ", "=", " ", 
   RowBox[{"{", "}"}]}], ";", " ", 
  RowBox[{"agr", " ", "=", " ", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Calculating garnet activities for P = \>\"", ",", "p", ",", 
    "\"\< [bar], T = \>\"", ",", 
    RowBox[{"t", "-", "273.15"}], ",", "\"\< [C] from file: \>\"", ",", 
    "file"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Garnet activity model: \>\"", ",", "model", ",", "\"\<\\n\>\""}], 
    "]"}], ";"}], "\n", 
  RowBox[{"(*", " ", "loop", " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "<", 
    RowBox[{
     RowBox[{"Dimensions", "[", "analyses", "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ",", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ToString", "[", 
        RowBox[{"analyses", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], "]"}], "\[Equal]", " ", 
       "\"\<grt\>\""}], ",", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"xca", ",", "xmg", ",", "xfe", ",", "xmn"}], "}"}], "=", " ", 
        RowBox[{
         RowBox[{"Last", "[", 
          RowBox[{"analyses", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "2", ",", "1"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"xxfe", " ", "=", " ", 
        RowBox[{"Append", "[", 
         RowBox[{"xxfe", ",", "xfe"}], "]"}]}], ";", " ", 
       RowBox[{"xxmg", " ", "=", " ", 
        RowBox[{"Append", "[", 
         RowBox[{"xxmg", ",", "xmg"}], "]"}]}], ";", 
       RowBox[{"xxca", " ", "=", " ", 
        RowBox[{"Append", "[", 
         RowBox[{"xxca", ",", "xca"}], "]"}]}], ";", " ", 
       RowBox[{"xxmn", " ", "=", " ", 
        RowBox[{"Append", "[", 
         RowBox[{"xxmn", ",", "xmn"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"aalm", " ", "=", " ", 
        RowBox[{"Append", "[", 
         RowBox[{"aalm", ",", 
          RowBox[{
           RowBox[{"ActivityB", "[", 
            RowBox[{"p", ",", "t", ",", "alm", ",", 
             RowBox[{
              RowBox[{"Last", "[", 
               RowBox[{"analyses", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "]"}], "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", 
             RowBox[{"ActivityModelGrt", "\[Rule]", "model"}]}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"apy", " ", "=", " ", 
        RowBox[{"Append", "[", 
         RowBox[{"apy", ",", 
          RowBox[{
           RowBox[{"ActivityB", "[", 
            RowBox[{"p", ",", "t", ",", "py", ",", 
             RowBox[{
              RowBox[{"Last", "[", 
               RowBox[{"analyses", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "]"}], "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", 
             RowBox[{"ActivityModelGrt", "\[Rule]", "model"}]}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"agr", " ", "=", " ", 
        RowBox[{"Append", "[", 
         RowBox[{"agr", ",", 
          RowBox[{
           RowBox[{"ActivityB", "[", 
            RowBox[{"p", ",", "t", ",", "gr", ",", 
             RowBox[{
              RowBox[{"Last", "[", 
               RowBox[{"analyses", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "]"}], "[", 
              RowBox[{"[", 
               RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", 
             RowBox[{"ActivityModelGrt", "\[Rule]", "model"}]}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", " ", 
       RowBox[{"Print", "[", 
        RowBox[{
        "\"\<Analysis \>\"", ",", "i", ",", "\"\<: XFe = \>\"", ",", "xfe", 
         ",", "\"\<, XMg = \>\"", ",", "xmg", ",", "\"\<, XCa = \>\"", ",", 
         "xca", ",", "\"\<, XMn = \>\"", ",", "xmn"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<            a(Alm) = \>\"", ",", 
         RowBox[{"Last", "[", "aalm", "]"}], ",", "\"\<, a(Py) = \>\"", ",", 
         RowBox[{"Last", "[", "apy", "]"}], ",", "\"\<, a(Gr) = \>\"", ",", 
         RowBox[{"Last", "[", "agr", "]"}]}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "  ", "]"}], ";"}]}], "\[IndentingNewLine]", 
  "]"}]}], "Input",
 CellChangeTimes->{3.42270793740625*^9, 3.42276862065625*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating garnet activities for P = \"\>", 
   "\[InvisibleSpace]", "7500", "\[InvisibleSpace]", "\<\" [bar], T = \"\>", 
   "\[InvisibleSpace]", "500.`", 
   "\[InvisibleSpace]", "\<\" [C] from file: \"\>", 
   "\[InvisibleSpace]", "\<\"pet2\"\>"}],
  SequenceForm[
  "Calculating garnet activities for P = ", 7500, " [bar], T = ", 500., 
   " [C] from file: ", "pet2"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520425365844`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Garnet activity model: \"\>", "\[InvisibleSpace]", 
   "GrtGangulySaxena", "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm["Garnet activity model: ", ACTIVITY`GrtGangulySaxena, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520425522094`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.62989`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.11751`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.23784`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01476`"}],
  SequenceForm[
  "Analysis ", 21, ": XFe = ", 0.62989, ", XMg = ", 0.11751, ", XCa = ", 
   0.23784, ", XMn = ", 0.01476],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520425678344`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.1687114341250492`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.09763643917013491`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.037287392506788426`"}],
  SequenceForm[
  "            a(Alm) = ", 0.1687114341250492, ", a(Py) = ", 
   0.09763643917013491, ", a(Gr) = ", 0.037287392506788426`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520425678344`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "22", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.64373`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.11477`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.22777`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01373`"}],
  SequenceForm[
  "Analysis ", 22, ": XFe = ", 0.64373, ", XMg = ", 0.11477, ", XCa = ", 
   0.22777, ", XMn = ", 0.01373],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042583459*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.1819361190383044`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.09595006121874936`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.030936112220626255`"}],
  SequenceForm[
  "            a(Alm) = ", 0.1819361190383044, ", a(Py) = ", 
   0.09595006121874936, ", a(Gr) = ", 0.030936112220626255`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042583459*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "23", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.63457`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.10767`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.23852`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01925`"}],
  SequenceForm[
  "Analysis ", 23, ": XFe = ", 0.63457, ", XMg = ", 0.10767, ", XCa = ", 
   0.23852, ", XMn = ", 0.01925],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042599084*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.16951226249673573`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.08822555169809278`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.036545094642728114`"}],
  SequenceForm[
  "            a(Alm) = ", 0.16951226249673573`, ", a(Py) = ", 
   0.08822555169809278, ", a(Gr) = ", 0.036545094642728114`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042614709*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "24", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.63715`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.1029`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.24237`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01758`"}],
  SequenceForm[
  "Analysis ", 24, ": XFe = ", 0.63715, ", XMg = ", 0.1029, ", XCa = ", 
   0.24237, ", XMn = ", 0.01758],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042614709*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.16882613326793214`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.08295542695984323`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.038812116441310704`"}],
  SequenceForm[
  "            a(Alm) = ", 0.16882613326793214`, ", a(Py) = ", 
   0.08295542695984323, ", a(Gr) = ", 0.038812116441310704`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042630334*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "25", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.63195`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.0938`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.25549`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01876`"}],
  SequenceForm[
  "Analysis ", 25, ": XFe = ", 0.63195, ", XMg = ", 0.0938, ", XCa = ", 
   0.25549, ", XMn = ", 0.01876],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042645959*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.1587381588163947`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.07180512935995957`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.04762183838072236`"}],
  SequenceForm[
  "            a(Alm) = ", 0.1587381588163947, ", a(Py) = ", 
   0.07180512935995957, ", a(Gr) = ", 0.04762183838072236],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042645959*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "26", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.63609`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.08776`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.26128`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01487`"}],
  SequenceForm[
  "Analysis ", 26, ": XFe = ", 0.63609, ", XMg = ", 0.08776, ", XCa = ", 
   0.26128, ", XMn = ", 0.01487],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042661584*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.15813294213142826`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.06455400623888613`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.05232234072020845`"}],
  SequenceForm[
  "            a(Alm) = ", 0.15813294213142826`, ", a(Py) = ", 
   0.06455400623888613, ", a(Gr) = ", 0.05232234072020845],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042677209*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "27", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.6429`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.07974`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.25804`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01932`"}],
  SequenceForm[
  "Analysis ", 27, ": XFe = ", 0.6429, ", XMg = ", 0.07974, ", XCa = ", 
   0.25804, ", XMn = ", 0.01932],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042677209*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.1624494002060838`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.056095055088203526`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.04862694937431996`"}],
  SequenceForm[
  "            a(Alm) = ", 0.1624494002060838, ", a(Py) = ", 
   0.056095055088203526`, ", a(Gr) = ", 0.04862694937431996],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042692834*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "28", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.6431`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.07283`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.26026`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.02381`"}],
  SequenceForm[
  "Analysis ", 28, ": XFe = ", 0.6431, ", XMg = ", 0.07283, ", XCa = ", 
   0.26026, ", XMn = ", 0.02381],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520427084584`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.160742803447358`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.04809113156172835`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.04962679871181906`"}],
  SequenceForm[
  "            a(Alm) = ", 0.160742803447358, ", a(Py) = ", 
   0.04809113156172835, ", a(Gr) = ", 0.04962679871181906],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520427084584`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "29", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.64947`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.07403`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.25557`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.02092`"}],
  SequenceForm[
  "Analysis ", 29, ": XFe = ", 0.64947, ", XMg = ", 0.07403, ", XCa = ", 
   0.25557, ", XMn = ", 0.02092],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042724083*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.16692757111916162`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.04993274723517958`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.04611250939923287`"}],
  SequenceForm[
  "            a(Alm) = ", 0.16692757111916162`, ", a(Py) = ", 
   0.04993274723517958, ", a(Gr) = ", 0.04611250939923287],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042739708*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "30", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.64494`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.07082`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.26779`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01646`"}],
  SequenceForm[
  "Analysis ", 30, ": XFe = ", 0.64494, ", XMg = ", 0.07082, ", XCa = ", 
   0.26779, ", XMn = ", 0.01646],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042755333*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.1585652280903697`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.04518742700571102`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.05690736104773734`"}],
  SequenceForm[
  "            a(Alm) = ", 0.1585652280903697, ", a(Py) = ", 
   0.04518742700571102, ", a(Gr) = ", 0.05690736104773734],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042755333*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "31", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.65134`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.07005`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.26214`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01647`"}],
  SequenceForm[
  "Analysis ", 31, ": XFe = ", 0.65134, ", XMg = ", 0.07005, ", XCa = ", 
   0.26214, ", XMn = ", 0.01647],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042770958*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.16481974619535608`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.044923361480878735`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.05175745359296637`"}],
  SequenceForm[
  "            a(Alm) = ", 0.16481974619535608`, ", a(Py) = ", 
   0.044923361480878735`, ", a(Gr) = ", 0.05175745359296637],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042786583*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "32", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.64354`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.0712`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.26822`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01704`"}],
  SequenceForm[
  "Analysis ", 32, ": XFe = ", 0.64354, ", XMg = ", 0.0712, ", XCa = ", 
   0.26822, ", XMn = ", 0.01704],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042802208*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.1575878097935282`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.04554172141060044`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.05726526625899471`"}],
  SequenceForm[
  "            a(Alm) = ", 0.1575878097935282, ", a(Py) = ", 
   0.04554172141060044, ", a(Gr) = ", 0.05726526625899471],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042802208*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "33", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.6607`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.07533`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.24521`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01877`"}],
  SequenceForm[
  "Analysis ", 33, ": XFe = ", 0.6607, ", XMg = ", 0.07533, ", XCa = ", 
   0.24521, ", XMn = ", 0.01877],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042817833*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.17930371294409808`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.052349594337332064`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.03856561249219221`"}],
  SequenceForm[
  "            a(Alm) = ", 0.17930371294409808`, ", a(Py) = ", 
   0.052349594337332064`, ", a(Gr) = ", 0.03856561249219221],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042833458*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "34", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.64431`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.07262`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.26358`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01948`"}],
  SequenceForm[
  "Analysis ", 34, ": XFe = ", 0.64431, ", XMg = ", 0.07262, ", XCa = ", 
   0.26358, ", XMn = ", 0.01948],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520428490825`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.16012387414130635`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.04756683643638098`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.05287991362046316`"}],
  SequenceForm[
  "            a(Alm) = ", 0.16012387414130635`, ", a(Py) = ", 
   0.04756683643638098, ", a(Gr) = ", 0.05287991362046316],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520428490825`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.60269`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.06275`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.29845`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.03611`"}],
  SequenceForm[
  "Analysis ", 35, ": XFe = ", 0.60269, ", XMg = ", 0.06275, ", XCa = ", 
   0.29845, ", XMn = ", 0.03611],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520428647075`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.12400473476307228`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.03291203221485217`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.08661895311198126`"}],
  SequenceForm[
  "            a(Alm) = ", 0.12400473476307228`, ", a(Py) = ", 
   0.03291203221485217, ", a(Gr) = ", 0.08661895311198126],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520428803325`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "36", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.43975`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03686`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.38613`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.13726`"}],
  SequenceForm[
  "Analysis ", 36, ": XFe = ", 0.43975, ", XMg = ", 0.03686, ", XCa = ", 
   0.38613, ", XMn = ", 0.13726],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042895957*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.05164848957448788`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.006325268348424033`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.18214359614208359`"}],
  SequenceForm[
  "            a(Alm) = ", 0.05164848957448788, ", a(Py) = ", 
   0.006325268348424033, ", a(Gr) = ", 0.18214359614208359`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042911582*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "37", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.44842`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.04012`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.3731`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.13836`"}],
  SequenceForm[
  "Analysis ", 37, ": XFe = ", 0.44842, ", XMg = ", 0.04012, ", XCa = ", 
   0.3731, ", XMn = ", 0.13836],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042927207*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.05472773640895112`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.00836669032968038`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.16095515979522948`"}],
  SequenceForm[
  "            a(Alm) = ", 0.05472773640895112, ", a(Py) = ", 
   0.00836669032968038, ", a(Gr) = ", 0.16095515979522948`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042927207*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "38", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.43808`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03697`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.38624`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.13871`"}],
  SequenceForm[
  "Analysis ", 38, ": XFe = ", 0.43808, ", XMg = ", 0.03697, ", XCa = ", 
   0.38624, ", XMn = ", 0.13871],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042942832*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.051237997656800226`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.006359312420587523`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.18148136168251547`"}],
  SequenceForm[
  "            a(Alm) = ", 0.051237997656800226`, ", a(Py) = ", 
   0.006359312420587523, ", a(Gr) = ", 0.18148136168251547`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752042958457*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "39", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.45181`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03681`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.38044`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.13094`"}],
  SequenceForm[
  "Analysis ", 39, ": XFe = ", 0.45181, ", XMg = ", 0.03681, ", XCa = ", 
   0.38044, ", XMn = ", 0.13094],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520429740815`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.05494967014286017`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.006566617529646985`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.1769452442262467`"}],
  SequenceForm[
  "            a(Alm) = ", 0.05494967014286017, ", a(Py) = ", 
   0.006566617529646985, ", a(Gr) = ", 0.1769452442262467],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520429897065`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "40", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.45054`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.04074`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.36961`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.13911`"}],
  SequenceForm[
  "Analysis ", 40, ": XFe = ", 0.45054, ", XMg = ", 0.04074, ", XCa = ", 
   0.36961, ", XMn = ", 0.13911],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520429897065`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.0555114384573084`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.008848044375370432`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.15546207181674776`"}],
  SequenceForm[
  "            a(Alm) = ", 0.0555114384573084, ", a(Py) = ", 
   0.008848044375370432, ", a(Gr) = ", 0.15546207181674776`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520430053315`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "41", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.45437`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03815`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.37447`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.133`"}],
  SequenceForm[
  "Analysis ", 41, ": XFe = ", 0.45437, ", XMg = ", 0.03815, ", XCa = ", 
   0.37447, ", XMn = ", 0.133],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520430209565`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.056045119123413575`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.007403303532610177`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.1663927944326289`"}],
  SequenceForm[
  "            a(Alm) = ", 0.056045119123413575`, ", a(Py) = ", 
   0.007403303532610177, ", a(Gr) = ", 0.1663927944326289],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043036581*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "42", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.45906`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.04835`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.37355`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.11904`"}],
  SequenceForm[
  "Analysis ", 42, ": XFe = ", 0.45906, ", XMg = ", 0.04835, ", XCa = ", 
   0.37355, ", XMn = ", 0.11904],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043052206*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.05854045822152469`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.01287009419997715`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.16607073742467318`"}],
  SequenceForm[
  "            a(Alm) = ", 0.05854045822152469, ", a(Py) = ", 
   0.01287009419997715, ", a(Gr) = ", 0.16607073742467318`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043052206*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "43", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.48329`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.0452`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.35392`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.11759`"}],
  SequenceForm[
  "Analysis ", 43, ": XFe = ", 0.48329, ", XMg = ", 0.0452, ", XCa = ", 
   0.35392, ", XMn = ", 0.11759],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043067831*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.06638040482779023`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.012427965168310141`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.14039316459401976`"}],
  SequenceForm[
  "            a(Alm) = ", 0.06638040482779023, ", a(Py) = ", 
   0.012427965168310141`, ", a(Gr) = ", 0.14039316459401976`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043083456*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "44", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.46171`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03578`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.37148`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.13102`"}],
  SequenceForm[
  "Analysis ", 44, ": XFe = ", 0.46171, ", XMg = ", 0.03578, ", XCa = ", 
   0.37148, ", XMn = ", 0.13102],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043099081*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.0579280767948085`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.006487456464546463`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.16421699274545173`"}],
  SequenceForm[
  "            a(Alm) = ", 0.0579280767948085, ", a(Py) = ", 
   0.006487456464546463, ", a(Gr) = ", 0.16421699274545173`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043114706*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "45", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.46838`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03715`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.35602`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.13845`"}],
  SequenceForm[
  "Analysis ", 45, ": XFe = ", 0.46838, ", XMg = ", 0.03715, ", XCa = ", 
   0.35602, ", XMn = ", 0.13845],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043114706*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.06088596881914337`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.007723128181378582`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.13875259059597106`"}],
  SequenceForm[
  "            a(Alm) = ", 0.06088596881914337, ", a(Py) = ", 
   0.007723128181378582, ", a(Gr) = ", 0.13875259059597106`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043130331*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "46", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.46447`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03843`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.35305`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.14405`"}],
  SequenceForm[
  "Analysis ", 46, ": XFe = ", 0.46447, ", XMg = ", 0.03843, ", XCa = ", 
   0.35305, ", XMn = ", 0.14405],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520431459556`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.06005154010724527`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.008466621359405839`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.1323436686248001`"}],
  SequenceForm[
  "            a(Alm) = ", 0.06005154010724527, ", a(Py) = ", 
   0.008466621359405839, ", a(Gr) = ", 0.1323436686248001],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.48575204316158*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "47", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.46092`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03647`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.37735`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.12525`"}],
  SequenceForm[
  "Analysis ", 47, ": XFe = ", 0.46092, ", XMg = ", 0.03647, ", XCa = ", 
   0.37735, ", XMn = ", 0.12525],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043177205*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.057474935464071855`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.006575560580656358`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.17529527393358418`"}],
  SequenceForm[
  "            a(Alm) = ", 0.057474935464071855`, ", a(Py) = ", 
   0.006575560580656358, ", a(Gr) = ", 0.17529527393358418`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043177205*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "48", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.46353`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03789`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.37949`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.11909`"}],
  SequenceForm[
  "Analysis ", 48, ": XFe = ", 0.46353, ", XMg = ", 0.03789, ", XCa = ", 
   0.37949, ", XMn = ", 0.11909],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.48575204319283*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.05822215343024541`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.0071325809299619914`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.18078397883427558`"}],
  SequenceForm[
  "            a(Alm) = ", 0.05822215343024541, ", a(Py) = ", 
   0.0071325809299619914`, ", a(Gr) = ", 0.18078397883427558`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043208455*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "49", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.453`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03693`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.38788`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.12219`"}],
  SequenceForm[
  "Analysis ", 49, ": XFe = ", 0.453, ", XMg = ", 0.03693, ", XCa = ", 
   0.38788, ", XMn = ", 0.12219],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.48575204322408*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.0549510709230474`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.0063488690876867425`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.1928169307886287`"}],
  SequenceForm[
  "            a(Alm) = ", 0.0549510709230474, ", a(Py) = ", 
   0.0063488690876867425`, ", a(Gr) = ", 0.1928169307886287],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043239705*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "50", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.44765`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03829`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.38813`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.12594`"}],
  SequenceForm[
  "Analysis ", 50, ": XFe = ", 0.44765, ", XMg = ", 0.03829, ", XCa = ", 
   0.38813, ", XMn = ", 0.12594],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.48575204325533*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.053738082711001174`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.006886961275148471`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.19020984384945344`"}],
  SequenceForm[
  "            a(Alm) = ", 0.053738082711001174`, ", a(Py) = ", 
   0.006886961275148471, ", a(Gr) = ", 0.19020984384945344`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.48575204325533*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "51", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.45695`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03508`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.37966`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.1283`"}],
  SequenceForm[
  "Analysis ", 51, ": XFe = ", 0.45695, ", XMg = ", 0.03508, ", XCa = ", 
   0.37966, ", XMn = ", 0.1283],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043270955*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.0561441171273984`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.005893867682543384`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.17814208704949047`"}],
  SequenceForm[
  "            a(Alm) = ", 0.0561441171273984, ", a(Py) = ", 
   0.005893867682543384, ", a(Gr) = ", 0.17814208704949047`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520432865796`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "52", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.44159`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03676`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.3877`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.13395`"}],
  SequenceForm[
  "Analysis ", 52, ": XFe = ", 0.44159, ", XMg = ", 0.03676, ", XCa = ", 
   0.3877, ", XMn = ", 0.13395],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520433022046`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.05204894680837522`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.0062356930713274965`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.18628168296669337`"}],
  SequenceForm[
  "            a(Alm) = ", 0.05204894680837522, ", a(Py) = ", 
   0.0062356930713274965`, ", a(Gr) = ", 0.18628168296669337`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520433178296`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "53", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.45963`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.04338`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.34639`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.15061`"}],
  SequenceForm[
  "Analysis ", 53, ": XFe = ", 0.45963, ", XMg = ", 0.04338, ", XCa = ", 
   0.34639, ", XMn = ", 0.15061],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520433178296`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.05950569134011117`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.01154708095892767`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.12016014074578447`"}],
  SequenceForm[
  "            a(Alm) = ", 0.05950569134011117, ", a(Py) = ", 
   0.01154708095892767, ", a(Gr) = ", 0.12016014074578447`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043333454*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "54", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.44379`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.04016`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.37231`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.14374`"}],
  SequenceForm[
  "Analysis ", 54, ": XFe = ", 0.44379, ", XMg = ", 0.04016, ", XCa = ", 
   0.37231, ", XMn = ", 0.14374],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043349079*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.053527683631133985`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.008395047283607696`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.15747650437254923`"}],
  SequenceForm[
  "            a(Alm) = ", 0.053527683631133985`, ", a(Py) = ", 
   0.008395047283607696, ", a(Gr) = ", 0.15747650437254923`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043364704*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "55", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.43541`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03681`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.37093`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.15685`"}],
  SequenceForm[
  "Analysis ", 55, ": XFe = ", 0.43541, ", XMg = ", 0.03681, ", XCa = ", 
   0.37093, ", XMn = ", 0.15685],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043380329*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.051004373454596574`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.006831974023786465`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.1517729114956564`"}],
  SequenceForm[
  "            a(Alm) = ", 0.051004373454596574`, ", a(Py) = ", 
   0.006831974023786465, ", a(Gr) = ", 0.1517729114956564],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043380329*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "56", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.43517`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03779`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.36882`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.15822`"}],
  SequenceForm[
  "Analysis ", 56, ": XFe = ", 0.43517, ", XMg = ", 0.03779, ", XCa = ", 
   0.36882, ", XMn = ", 0.15822],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043395954*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.0511088097206824`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.007356355960152624`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.1479465548806073`"}],
  SequenceForm[
  "            a(Alm) = ", 0.0511088097206824, ", a(Py) = ", 
   0.007356355960152624, ", a(Gr) = ", 0.1479465548806073],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043411579*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "57", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.43395`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03868`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.36485`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.16253`"}],
  SequenceForm[
  "Analysis ", 57, ": XFe = ", 0.43395, ", XMg = ", 0.03868, ", XCa = ", 
   0.36485, ", XMn = ", 0.16253],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043427204*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.05099855722708647`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.007931025820947403`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.14074387020286072`"}],
  SequenceForm[
  "            a(Alm) = ", 0.05099855722708647, ", a(Py) = ", 
   0.007931025820947403, ", a(Gr) = ", 0.14074387020286072`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043442829*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "58", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.43523`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03781`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.37928`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.14768`"}],
  SequenceForm[
  "Analysis ", 58, ": XFe = ", 0.43523, ", XMg = ", 0.03781, ", XCa = ", 
   0.37928, ", XMn = ", 0.14768],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043442829*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.050814743218078544`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.006964740391112993`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.16661638547139448`"}],
  SequenceForm[
  "            a(Alm) = ", 0.050814743218078544`, ", a(Py) = ", 
   0.006964740391112993, ", a(Gr) = ", 0.16661638547139448`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520434584537`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "59", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.42083`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03712`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.36224`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.17981`"}],
  SequenceForm[
  "Analysis ", 59, ": XFe = ", 0.42083, ", XMg = ", 0.03712, ", XCa = ", 
   0.36224, ", XMn = ", 0.17981],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043474078*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.04745802360076135`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.007210018394045535`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.13191849083717547`"}],
  SequenceForm[
  "            a(Alm) = ", 0.04745802360076135, ", a(Py) = ", 
   0.007210018394045535, ", a(Gr) = ", 0.13191849083717547`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043489703*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "60", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.44541`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03924`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.31023`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.20512`"}],
  SequenceForm[
  "Analysis ", 60, ": XFe = ", 0.44541, ", XMg = ", 0.03924, ", XCa = ", 
   0.31023, ", XMn = ", 0.20512],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043505328*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.0566108182543139`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.010470551763072837`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.07161502700825104`"}],
  SequenceForm[
  "            a(Alm) = ", 0.0566108182543139, ", a(Py) = ", 
   0.010470551763072837`, ", a(Gr) = ", 0.07161502700825104],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043520953*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "61", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.46663`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.04222`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.30059`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.19055`"}],
  SequenceForm[
  "Analysis ", 61, ": XFe = ", 0.46663, ", XMg = ", 0.04222, ", XCa = ", 
   0.30059, ", XMn = ", 0.19055],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043520953*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.06454948156444092`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.013039140726174696`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.06524539438444833`"}],
  SequenceForm[
  "            a(Alm) = ", 0.06454948156444092, ", a(Py) = ", 
   0.013039140726174696`, ", a(Gr) = ", 0.06524539438444833],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043536578*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "62", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.45734`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.03905`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.32882`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.17479`"}],
  SequenceForm[
  "Analysis ", 62, ": XFe = ", 0.45734, ", XMg = ", 0.03905, ", XCa = ", 
   0.32882, ", XMn = ", 0.17479],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043552203*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.05936593004876076`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.00973607717475909`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.09508079069429319`"}],
  SequenceForm[
  "            a(Alm) = ", 0.05936593004876076, ", a(Py) = ", 
   0.00973607717475909, ", a(Gr) = ", 0.09508079069429319],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043567828*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "63", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.55273`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.04392`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.31567`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.08768`"}],
  SequenceForm[
  "Analysis ", 63, ": XFe = ", 0.55273, ", XMg = ", 0.04392, ", XCa = ", 
   0.31567, ", XMn = ", 0.08768],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520435834527`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.09569117727795758`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.01439848389500252`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.09865426756899616`"}],
  SequenceForm[
  "            a(Alm) = ", 0.09569117727795758, ", a(Py) = ", 
   0.01439848389500252, ", a(Gr) = ", 0.09865426756899616],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520435834527`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "64", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.59873`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.04761`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.31082`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.04283`"}],
  SequenceForm[
  "Analysis ", 64, ": XFe = ", 0.59873, ", XMg = ", 0.04761, ", XCa = ", 
   0.31082, ", XMn = ", 0.04283],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520435990777`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.11699832738344457`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.018031641829166535`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.10200339755214291`"}],
  SequenceForm[
  "            a(Alm) = ", 0.11699832738344457`, ", a(Py) = ", 
   0.018031641829166535`, ", a(Gr) = ", 0.10200339755214291`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520436147027`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "65", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.60817`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.04756`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.30993`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.03435`"}],
  SequenceForm[
  "Analysis ", 65, ": XFe = ", 0.60817, ", XMg = ", 0.04756, ", XCa = ", 
   0.30993, ", XMn = ", 0.03435],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520436303277`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.12158121093960832`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.018163334217316793`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.10272129562569093`"}],
  SequenceForm[
  "            a(Alm) = ", 0.12158121093960832`, ", a(Py) = ", 
   0.018163334217316793`, ", a(Gr) = ", 0.10272129562569093`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043645952*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "66", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.61394`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.0515`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.30941`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.02515`"}],
  SequenceForm[
  "Analysis ", 66, ": XFe = ", 0.61394, ", XMg = ", 0.0515, ", XCa = ", 
   0.30941, ", XMn = ", 0.02515],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043661577*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.12482002312709325`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.021584343470412215`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.10378125620751502`"}],
  SequenceForm[
  "            a(Alm) = ", 0.12482002312709325`, ", a(Py) = ", 
   0.021584343470412215`, ", a(Gr) = ", 0.10378125620751502`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043661577*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "67", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.63035`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.06057`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.2921`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01698`"}],
  SequenceForm[
  "Analysis ", 67, ": XFe = ", 0.63035, ", XMg = ", 0.06057, ", XCa = ", 
   0.2921, ", XMn = ", 0.01698],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043677202*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.13976591418200007`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.03178308307269815`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.08248308626679125`"}],
  SequenceForm[
  "            a(Alm) = ", 0.13976591418200007`, ", a(Py) = ", 
   0.03178308307269815, ", a(Gr) = ", 0.08248308626679125],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043692827*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "68", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.63979`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.06221`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.28373`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01427`"}],
  SequenceForm[
  "Analysis ", 68, ": XFe = ", 0.63979, ", XMg = ", 0.06221, ", XCa = ", 
   0.28373, ", XMn = ", 0.01427],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043708452*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.14819706387284234`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.03436517637075531`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.0731822661481917`"}],
  SequenceForm[
  "            a(Alm) = ", 0.14819706387284234`, ", a(Py) = ", 
   0.03436517637075531, ", a(Gr) = ", 0.0731822661481917],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520437240767`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "69", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.63813`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.06672`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.27733`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01781`"}],
  SequenceForm[
  "Analysis ", 69, ": XFe = ", 0.63813, ", XMg = ", 0.06672, ", XCa = ", 
   0.27733, ", XMn = ", 0.01781],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520437240767`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.15025423345216457`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.03969068006433731`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.06592652457325189`"}],
  SequenceForm[
  "            a(Alm) = ", 0.15025423345216457`, ", a(Py) = ", 
   0.03969068006433731, ", a(Gr) = ", 0.06592652457325189],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520437397017`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "70", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.64022`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.06912`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.27148`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01918`"}],
  SequenceForm[
  "Analysis ", 70, ": XFe = ", 0.64022, ", XMg = ", 0.06912, ", XCa = ", 
   0.27148, ", XMn = ", 0.01918],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520437553267`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.15404045028111363`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.04288989348731117`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.060014354105290116`"}],
  SequenceForm[
  "            a(Alm) = ", 0.15404045028111363`, ", a(Py) = ", 
   0.04288989348731117, ", a(Gr) = ", 0.060014354105290116`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520437709513`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "71", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.64452`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.06628`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.27139`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.0178`"}],
  SequenceForm[
  "Analysis ", 71, ": XFe = ", 0.64452, ", XMg = ", 0.06628, ", XCa = ", 
   0.27139, ", XMn = ", 0.0178],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520437865763`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.15630297663975018`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.0398587470403087`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.05995659421978365`"}],
  SequenceForm[
  "            a(Alm) = ", 0.15630297663975018`, ", a(Py) = ", 
   0.0398587470403087, ", a(Gr) = ", 0.05995659421978365],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520437865763`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "72", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.64125`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.06818`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.27097`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.0196`"}],
  SequenceForm[
  "Analysis ", 72, ": XFe = ", 0.64125, ", XMg = ", 0.06818, ", XCa = ", 
   0.27097, ", XMn = ", 0.0196],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520438022013`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.15474108459835562`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.04192393409667122`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.05943139137103866`"}],
  SequenceForm[
  "            a(Alm) = ", 0.15474108459835562`, ", a(Py) = ", 
   0.04192393409667122, ", a(Gr) = ", 0.05943139137103866],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520438178263`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "73", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.6395`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.0709`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.26924`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.02037`"}],
  SequenceForm[
  "Analysis ", 73, ": XFe = ", 0.6395, ", XMg = ", 0.0709, ", XCa = ", 
   0.26924, ", XMn = ", 0.02037],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520438334513`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.15470990242149296`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.04505731783055972`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.0578350780656777`"}],
  SequenceForm[
  "            a(Alm) = ", 0.15470990242149296`, ", a(Py) = ", 
   0.04505731783055972, ", a(Gr) = ", 0.0578350780656777],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520438490763`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "74", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.64435`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.08685`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.25312`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01569`"}],
  SequenceForm[
  "Analysis ", 74, ": XFe = ", 0.64435, ", XMg = ", 0.08685, ", XCa = ", 
   0.25312, ", XMn = ", 0.01569],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520438647013`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.16646278030708067`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.06458134060148454`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.04551009059757293`"}],
  SequenceForm[
  "            a(Alm) = ", 0.16646278030708067`, ", a(Py) = ", 
   0.06458134060148454, ", a(Gr) = ", 0.04551009059757293],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520438647013`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Analysis \"\>", "\[InvisibleSpace]", "75", 
   "\[InvisibleSpace]", "\<\": XFe = \"\>", "\[InvisibleSpace]", "0.63391`", 
   "\[InvisibleSpace]", "\<\", XMg = \"\>", "\[InvisibleSpace]", "0.09503`", 
   "\[InvisibleSpace]", "\<\", XCa = \"\>", "\[InvisibleSpace]", "0.25541`", 
   "\[InvisibleSpace]", "\<\", XMn = \"\>", "\[InvisibleSpace]", "0.01565`"}],
  SequenceForm[
  "Analysis ", 75, ": XFe = ", 0.63391, ", XMg = ", 0.09503, ", XCa = ", 
   0.25541, ", XMn = ", 0.01565],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.4857520438803263`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"            a(Alm) = \"\>", "\[InvisibleSpace]", 
   "0.16022729336667024`", "\[InvisibleSpace]", "\<\", a(Py) = \"\>", 
   "\[InvisibleSpace]", "0.07312884597675158`", 
   "\[InvisibleSpace]", "\<\", a(Gr) = \"\>", "\[InvisibleSpace]", 
   "0.04794127652880563`"}],
  SequenceForm[
  "            a(Alm) = ", 0.16022729336667024`, ", a(Py) = ", 
   0.07312884597675158, ", a(Gr) = ", 0.04794127652880563],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227078755625*^9, 3.422707939421875*^9, 3.422768578828125*^9, 
   3.422768775625*^9, 3.4609666084375*^9, 3.485751571973585*^9, 
   3.4857516610991554`*^9, {3.48575201984923*^9, 3.485752043895951*^9}}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
      "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
      "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
      "___", "\[IndentingNewLine]", "\t\t\t\t", "Example", 
      RowBox[{"(", "s", ")"}], " ", "for", " ", "use", " ", "of", " ", "the", 
      " ", "Pet"}], "-", 
     RowBox[{"Function", 
      RowBox[{"(", "s", ")"}]}]}], ":", "\t\t", 
    RowBox[{
     RowBox[{"-", "GammaSymbolic"}], "-", "\[IndentingNewLine]", 
     "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t      ", 
     RowBox[{"-", "GammaBB"}], "-", "\[IndentingNewLine]", 
     RowBox[{
     "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
      "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
      "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
      "__"}]}]}], "  ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"The", " ", "PET"}], "-", "functions", " ", "-", "GammaSymbolic",
      "-", " ", "and", " ", "-", "GammaBB", "-", " ", 
     RowBox[{"have", " ", "been", " ", "copied", " ", "from", " ", 
      RowBox[{"ActivityB", ".", "M"}], " ", "into", " ", "this", " ", "cell", 
      " ", "and", " ", "are", " ", "named"}], "\[IndentingNewLine]", "-", 
     "GammaSymbolic1", "-", " ", "and", " ", "-", "GammaBB1", "-", " ", 
     RowBox[{
     "here", " ", "and", " ", "are", " ", "used", " ", "in", " ", "some", " ",
       "examples", " ", 
      RowBox[{"below", ".", " ", "This"}], " ", "avoids", " ", "longer", " ", 
      "outputs", " ", "with", " ", "contexts", " ", "as", " ", "with", " ", 
      "use", " ", "of", " ", "the", " ", "analogous", " ", "functions", " ", 
      "in", " ", 
      RowBox[{"ActivityB", ".", "M", ".", " ", "Quit"}], " ", "and", " ", 
      "reload", " ", "the", " ", "Kernel"}]}], ",", " ", 
    RowBox[{
     RowBox[{"run", " ", "top"}], "-", 
     RowBox[{
     "cell", " ", "and", " ", "this", " ", "cell", " ", "before", " ", 
      "trying", " ", "the", " ", "examples", " ", 
      RowBox[{"below", "."}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", "  ", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"GammaSymbolic1", "[", 
     RowBox[{"c_", ",", "comp_", ",", "model_"}], "]"}], ":=", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"gex", "=", "0"}], ",", "gex1", ",", "i", ",", "j", ",", "k", 
        ",", "x", ",", "n", ",", "q", ",", "gexn", ",", "gamma", ",", "sumn", 
        ",", "w"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Off", "[", 
        RowBox[{"Part", "::", "partd"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"note", ":", 
          RowBox[{
          "model", " ", "1", " ", "and", " ", "2", " ", "are", " ", 
           "identical"}]}], ",", 
         RowBox[{"if", " ", "binary", " ", 
          RowBox[{"W", "'"}], "s", " ", "are", " ", "interchanced"}], ",", 
         RowBox[{
          RowBox[{"e", ".", "g", ".", 
           RowBox[{"w", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], "=", 
          RowBox[{"w", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "1"}], "]"}], "]"}]}], ",", 
         RowBox[{"etc", "."}], ",", 
         RowBox[{"ternary", " ", 
          RowBox[{"w", "'"}], "s", " ", "are", " ", "identical"}]}], " ", 
        "*)"}], "\[IndentingNewLine]", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"model", "\[Equal]", "1"}], ",", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"setup", " ", "expression", " ", "for", " ", 
            RowBox[{"Gex", ":", 
             RowBox[{"Berman", " ", "and", " ", "Brown"}]}]}], ",", "1984", 
           ",", 
           RowBox[{"eq", ".9"}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"i", "=", "1"}], ",", 
            RowBox[{"i", "\[LessEqual]", 
             RowBox[{"(", 
              RowBox[{"c", "-", "1"}], ")"}]}], ",", 
            RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
            RowBox[{"For", "[", 
             RowBox[{
              RowBox[{"j", "=", "i"}], ",", 
              RowBox[{"j", "\[LessEqual]", "c"}], ",", 
              RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"k", "=", "j"}], ",", 
                RowBox[{"k", "\[LessEqual]", "c"}], ",", 
                RowBox[{"k", "++"}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"k", "\[NotEqual]", "i"}], ",", 
                  RowBox[{"gex", "=", 
                   RowBox[{"gex", "+", 
                    RowBox[{
                    RowBox[{"w", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}], 
                    RowBox[{"x", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], 
                    RowBox[{"x", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], 
                    RowBox[{"x", "[", 
                    RowBox[{"[", "k", "]"}], "]"}]}]}]}]}], "]"}]}], "]"}]}], 
             "]"}]}], "]"}], ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"model", "\[Equal]", "2"}], ",", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"setup", " ", "expression", " ", "for", " ", 
            RowBox[{"Gex", ":", 
             RowBox[{
             "Wohl", " ", "equation", " ", "expanded", " ", "according", " ", 
              "to", " ", "Jackson"}]}]}], ",", "1989", ",", 
           RowBox[{"eq", ".6"}]}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"i", "=", "1"}], ",", 
            RowBox[{"i", "\[LessEqual]", 
             RowBox[{"(", 
              RowBox[{"c", "-", "1"}], ")"}]}], ",", 
            RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
            RowBox[{"For", "[", 
             RowBox[{
              RowBox[{"j", "=", "2"}], ",", 
              RowBox[{"j", "\[LessEqual]", "c"}], ",", 
              RowBox[{"j", "++"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"i", "<", "j"}], ",", 
                RowBox[{"gex", "=", 
                 RowBox[{"gex", "+", 
                  RowBox[{
                   RowBox[{"x", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], 
                   RowBox[{"x", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"x", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], 
                    RowBox[{"w", "[", 
                    RowBox[{"[", 
                    RowBox[{"j", ",", "i"}], "]"}], "]"}]}], "+", 
                    RowBox[{
                    RowBox[{"x", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], 
                    RowBox[{"w", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "j"}], "]"}], "]"}]}]}], ")"}]}]}]}]}], 
               "]"}]}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", "\t", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"i", "=", "1"}], ",", 
            RowBox[{"i", "\[LessEqual]", 
             RowBox[{"(", 
              RowBox[{"c", "-", "2"}], ")"}]}], ",", 
            RowBox[{"i", "++"}], ",", 
            RowBox[{"For", "[", 
             RowBox[{
              RowBox[{"j", "=", "2"}], ",", 
              RowBox[{"j", "\[LessEqual]", 
               RowBox[{"(", 
                RowBox[{"c", "-", "1"}], ")"}]}], ",", 
              RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", "\t", 
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"k", "=", "3"}], ",", 
                RowBox[{"k", "\[LessEqual]", "c"}], ",", 
                RowBox[{"k", "++"}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"i", "<", "j"}], "&&", 
                   RowBox[{"j", "<", "k"}]}], ",", 
                  RowBox[{"gex", "=", 
                   RowBox[{"gex", "+", 
                    RowBox[{
                    RowBox[{"x", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], 
                    RowBox[{"x", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], 
                    RowBox[{"x", "[", 
                    RowBox[{"[", "k", "]"}], "]"}], 
                    RowBox[{"q", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}]}]}]}]}], 
                 "]"}]}], "]"}]}], "]"}]}], "]"}], ";"}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"model", "\[Equal]", "3"}], ",", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"setup", " ", "expression", " ", "for", " ", 
            RowBox[{"Gex", ":", 
             RowBox[{"Meyre", " ", "et", " ", 
              RowBox[{"al", "."}]}]}]}], ",", "1997", ",", 
           RowBox[{"eq", ".3"}]}], " ", "*)"}], 
         RowBox[{
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"i", "=", "1"}], ",", 
            RowBox[{"i", "\[LessEqual]", 
             RowBox[{"(", 
              RowBox[{"c", "-", "1"}], ")"}]}], ",", 
            RowBox[{"i", "++"}], ",", 
            RowBox[{"For", "[", 
             RowBox[{
              RowBox[{"j", "=", "i"}], ",", 
              RowBox[{"j", "\[LessEqual]", "c"}], ",", 
              RowBox[{"j", "++"}], ",", 
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"k", "=", "j"}], ",", 
                RowBox[{"k", "\[LessEqual]", "c"}], ",", 
                RowBox[{"k", "++"}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"k", "\[NotEqual]", "i"}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"k", "\[Equal]", "i"}], "||", 
                    RowBox[{"k", "\[Equal]", "j"}], "||", 
                    RowBox[{"j", "\[Equal]", "i"}]}], ",", 
                    RowBox[{
                    RowBox[{"gex", "=", 
                    RowBox[{"gex", "+", 
                    RowBox[{
                    RowBox[{"w", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}], 
                    RowBox[{"x", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], 
                    RowBox[{"x", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], 
                    RowBox[{
                    RowBox[{"x", "[", 
                    RowBox[{"[", "k", "]"}], "]"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"x", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "+", 
                    RowBox[{"x", "[", 
                    RowBox[{"[", "k", "]"}], "]"}]}], ")"}]}]}]}]}], ";"}]}], 
                   "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}], ";"}]}], "]"}], 
       ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"gex1", "=", "gex"}], ";", "\[IndentingNewLine]", 
       RowBox[{"sumn", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"n", "[", 
           RowBox[{"[", "j", "]"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", "c"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"i", "=", "1"}], ",", 
         RowBox[{"i", "\[LessEqual]", "c"}], ",", 
         RowBox[{"i", "++"}], ",", 
         RowBox[{"gex", "=", 
          RowBox[{"gex", "/.", 
           RowBox[{
            RowBox[{"x", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "\[Rule]", 
            RowBox[{
             RowBox[{"n", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "/", "sumn"}]}]}]}]}], "]"}], 
       ";", 
       RowBox[{"(*", " ", 
        RowBox[{
        "replace", " ", "mole", " ", "fractions", " ", "by", " ", "moles"}], 
        " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"gexn", "=", 
        RowBox[{"gex", " ", "sumn"}]}], ";", 
       RowBox[{"(*", " ", 
        RowBox[{
        "symbolic", " ", "gex", " ", "for", " ", "all", " ", "moles"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"gamma", "=", 
        RowBox[{"D", "[", 
         RowBox[{"gexn", ",", 
          RowBox[{"n", "[", 
           RowBox[{"[", "comp", "]"}], "]"}]}], "]"}]}], ";", 
       RowBox[{"(*", " ", 
        RowBox[{"RTln", 
         RowBox[{"(", "gamma", ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"model", "\[Equal]", "1"}], "||", 
          RowBox[{"model", "\[Equal]", "2"}], "||", 
          RowBox[{"model", "\[Equal]", "3"}]}], ",", 
         RowBox[{"gamma", "=", 
          RowBox[{"gamma", "/.", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"sumn", "\[Rule]", "1"}], ",", 
             RowBox[{"n", "\[Rule]", "x"}]}], "}"}]}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{"{", 
         RowBox[{"gamma", ",", "gex1"}], "}"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"On", "[", 
        RowBox[{"Part", "::", "partd"}], "]"}], ";"}]}], "]"}]}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"GammaBB1", "[", 
     RowBox[{"m_", ",", "c_", ",", "w_", ",", "x_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"GammaBB", "[", 
      RowBox[{"m", ",", "c"}], "]"}], "=", 
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"nrtlny", "=", "0"}], ",", "i", ",", "j", ",", "k", ",", 
         "qm", ",", "x", ",", "w", ",", 
         RowBox[{"p", "=", "3"}]}], "}"}], ",", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"nsRTlny", 
            RowBox[{"(", "m", ")"}], " ", "according", " ", "to", " ", 
            "Berman"}], " ", "&"}], " ", "Brown", " ", 
          RowBox[{"(", 
           RowBox[{"1985", ",", 
            RowBox[{"eq", ".", "22"}]}], ")"}]}], ":", 
         RowBox[{"third", "-", 
          RowBox[{
          "degree", " ", "polynomial", " ", "asymmetric", " ", "excess", " ", 
           "model", " ", "for", " ", "the", " ", "m_th", " ", "out", " ", 
           "of", " ", "c", " ", "cations", " ", "on", " ", "site", " ", "s", 
           " ", "of", " ", "component", " ", 
           RowBox[{"j", ".", "Identical"}], " ", "results", " ", "are", " ", 
           "calculated", " ", "with", " ", "the", " ", "PET"}], "-", 
          "function", "-", "GammaSymbolic", "-"}]}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Off", "[", 
         RowBox[{"Part", "::", "partd"}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "\[LessEqual]", 
           RowBox[{"(", 
            RowBox[{"c", "-", "1"}], ")"}]}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"j", "=", "i"}], ",", 
            RowBox[{"j", "\[LessEqual]", "c"}], ",", 
            RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
            RowBox[{"For", "[", 
             RowBox[{
              RowBox[{"k", "=", "j"}], ",", 
              RowBox[{"k", "\[LessEqual]", "c"}], ",", 
              RowBox[{"k", "++"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"k", "\[NotEqual]", "i"}], ",", 
                RowBox[{
                 RowBox[{"qm", "=", 
                  RowBox[{
                   RowBox[{"Dimensions", "[", 
                    RowBox[{"Position", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"i", ",", "j", ",", "k"}], "}"}], ",", "m"}], 
                    "]"}], "]"}], "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ";", 
                 "\[IndentingNewLine]", 
                 RowBox[{"nrtlny", "=", 
                  RowBox[{"nrtlny", "+", 
                   RowBox[{
                    RowBox[{"w", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"qm", " ", 
                    RowBox[{"x", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], 
                    RowBox[{"x", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], 
                    RowBox[{
                    RowBox[{"x", "[", 
                    RowBox[{"[", "k", "]"}], "]"}], "/", 
                    RowBox[{"x", "[", 
                    RowBox[{"[", "m", "]"}], "]"}]}]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "p"}], ")"}], 
                    RowBox[{"x", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], 
                    RowBox[{"x", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], 
                    RowBox[{"x", "[", 
                    RowBox[{"[", "k", "]"}], "]"}]}]}], ")"}]}]}]}]}]}], 
               "]"}]}], "]"}]}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", "nrtlny", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"On", "[", 
         RowBox[{"Part", "::", "partd"}], "]"}], ";"}]}], 
      "]"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.485751692021229*^9, 3.4857516923806057`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "8"}], ":", "  ", 
    RowBox[{
     RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
     "GammaSymbolic1", "-", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"located", " ", "in", " ", "the", " ", "cell", " ", "above"}], 
       ")"}], "to", " ", "calculate", " ", "a", " ", "symbolic", " ", 
      "expression", " ", "for", " ", "RTln", 
      RowBox[{"(", "gamma", ")"}], " ", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
        "first", " ", "element", " ", "of", " ", "the", " ", "return"}], "-", 
        "list"}], ")"}], " ", "and", " ", "for", " ", "Gex", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
        "2", "nd", " ", "element", " ", "of", " ", "the", " ", "return"}], 
        "-", "list"}], ")"}], " ", "for", " ", "a", " ", "binary", " ", 
      "system", " ", "for", " ", "\[IndentingNewLine]", "component", " ", "1",
       " ", "using", " ", "the", " ", "formalism", " ", "of", " ", "Berman", 
      " ", "and", " ", "Brown", " ", 
      RowBox[{"(", "1984", ")"}], " ", "for", " ", "G", 
      RowBox[{"(", "ex", ")"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "w", "]"}], ";", 
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"gamma1", ",", "gex"}], "}"}], " ", "=", " ", 
    RowBox[{"GammaSymbolic1", "[", 
     RowBox[{"2", ",", "1", ",", "1"}], "]"}]}], 
   "\[IndentingNewLine]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"x", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], " ", 
     RowBox[{"x", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], " ", 
     RowBox[{"w", "\[LeftDoubleBracket]", 
      RowBox[{"1", ",", "1", ",", "2"}], "\[RightDoubleBracket]"}]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"x", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
      "2"], " ", 
     RowBox[{"x", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], " ", 
     RowBox[{"w", "\[LeftDoubleBracket]", 
      RowBox[{"1", ",", "1", ",", "2"}], "\[RightDoubleBracket]"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
      "2"], " ", 
     RowBox[{"w", "\[LeftDoubleBracket]", 
      RowBox[{"1", ",", "2", ",", "2"}], "\[RightDoubleBracket]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"x", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], " ", 
     SuperscriptBox[
      RowBox[{"x", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
      "2"], " ", 
     RowBox[{"w", "\[LeftDoubleBracket]", 
      RowBox[{"1", ",", "2", ",", "2"}], "\[RightDoubleBracket]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
      "2"], " ", 
     RowBox[{"x", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], " ", 
     RowBox[{"w", "\[LeftDoubleBracket]", 
      RowBox[{"1", ",", "1", ",", "2"}], "\[RightDoubleBracket]"}]}], "+", 
    RowBox[{
     RowBox[{"x", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], " ", 
     SuperscriptBox[
      RowBox[{"x", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
      "2"], " ", 
     RowBox[{"w", "\[LeftDoubleBracket]", 
      RowBox[{"1", ",", "2", ",", "2"}], "\[RightDoubleBracket]"}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.422708042671875*^9, 3.4227688243125*^9, 3.460966621359375*^9, 
   3.4857515734579697`*^9, 3.4857516991306305`*^9, {3.485752021208596*^9, 
   3.4857520439272003`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Example", " ", "9", 
    RowBox[{"a", ":", "  ", 
     RowBox[{
      RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
      "GammaBB1", "-", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"located", " ", "two", " ", "cells", " ", "above"}], ")"}], 
       "to", " ", "calculate", " ", "a"}]}]}], " ", "\[IndentingNewLine]", 
    RowBox[{"symbolic", " ", "expression", " ", "for", " ", "RTln", 
     RowBox[{"(", "gamma", ")"}], "using", " ", "the", " ", "formalism", " ", 
     "of", " ", "Berman", " ", "and", " ", "Brown", " ", 
     RowBox[{"(", "1984", ")"}], " ", "for", " ", "RTln", 
     RowBox[{"(", "gamma", ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"gamma2", " ", "=", 
    RowBox[{"GammaBB1", "[", 
     RowBox[{"1", ",", "2", ",", "w", ",", "x"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "both", " ", "results", " ", "of", " ", "Examples", " ", "1", " ", "and",
       " ", "2", " ", "are", " ", "identical"}], ",", " ", 
     RowBox[{
     "therefore", " ", "their", " ", "difference", " ", "is", " ", "zero"}]}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Simplify", "[", 
    RowBox[{"gamma1", "-", "gamma2"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"x", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
      " ", 
      RowBox[{"x", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
     "-", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"x", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
       "2"], " ", 
      RowBox[{"x", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}],
     ")"}], " ", 
   RowBox[{"w", "\[LeftDoubleBracket]", 
    RowBox[{"1", ",", "1", ",", "2"}], "\[RightDoubleBracket]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"x", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
      "2"], "-", 
     RowBox[{"2", " ", 
      RowBox[{"x", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
      " ", 
      SuperscriptBox[
       RowBox[{"x", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
       "2"]}]}], ")"}], " ", 
   RowBox[{"w", "\[LeftDoubleBracket]", 
    RowBox[{"1", ",", "2", ",", "2"}], 
    "\[RightDoubleBracket]"}]}]}]], "Output",
 CellChangeTimes->{
  3.42270804496875*^9, 3.42276882559375*^9, 3.460966622859375*^9, 
   3.4857515734735947`*^9, 3.4857517006931305`*^9, {3.485752021208596*^9, 
   3.4857520439428253`*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.42270804496875*^9, 3.42276882559375*^9, 3.460966622859375*^9, 
   3.4857515734735947`*^9, 3.4857517006931305`*^9, {3.485752021208596*^9, 
   3.4857520439428253`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "9", 
      RowBox[{"b", ":", " ", 
       RowBox[{
        RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
        "GammaBB", "-", " ", 
        RowBox[{
        "to", " ", "calculate", " ", "a", " ", "numerical", " ", "value", " ",
          "for", " ", "RTln", 
         RowBox[{"(", "gamma", ")"}], "and"}]}]}], " ", "\[IndentingNewLine]", 
      RowBox[{
      "gamma", " ", "of", " ", "the", " ", "grossular", " ", "component", " ",
        "in", " ", "garnet", " ", "from", " ", "sample", " ", "\"\<hs78b\>\"",
        " ", "for", " ", "P"}]}], " ", "=", " ", 
     RowBox[{"5000", " ", "bar"}]}], ",", " ", 
    RowBox[{"T", " ", "=", " ", 
     RowBox[{"500", " ", "C"}]}], ",", " ", 
    RowBox[{
    "using", " ", "the", " ", "formalism", " ", "of", " ", "Berman", " ", 
     "and", " ", "Brown", " ", 
     RowBox[{"(", "1984", ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"copied", " ", "from", " ", 
     RowBox[{"ACTIVITYDAT", ".", "M"}]}], ",", " ", 
    RowBox[{
     RowBox[{"the", " ", "list"}], " ", "<", "marg", ">", " ", 
     RowBox[{"contains", " ", "the", " ", "Berman", " ", 
      RowBox[{"(", "1990", ")"}], " ", "Margules", " ", "parameters", " ", 
      "of", " ", "garnet", " ", "\[IndentingNewLine]", "in", " ", "a", " ", 
      "square", " ", "matrix", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"order", ":", " ", "Ca"}], ",", " ", "Mg", ",", " ", "Fe", 
        ",", " ", "Mn"}], ")"}]}]}]}], "  ", "*)"}], " ", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "w", "]"}], ";", " ", 
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"marg", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"21560", "/", "3"}], ",", 
             RowBox[{"18.79", "/", "3"}], ",", 
             RowBox[{"0.1", "/", "3"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"20320", "/", "3"}], ",", 
             RowBox[{"5.08", "/", "3"}], ",", 
             RowBox[{"0.17", "/", "3"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"69200", "/", "3"}], ",", 
             RowBox[{"18.79", "/", "3"}], ",", 
             RowBox[{"0.1", "/", "3"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"230", "/", "3"}], ",", "0", ",", 
             RowBox[{"0.01", "/", "3"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2620", "/", "3"}], ",", 
             RowBox[{"5.08", "/", "3"}], ",", 
             RowBox[{"0.09", "/", "3"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"3720", "/", "3"}], ",", "0", ",", 
             RowBox[{"0.06", "/", "3"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "}"}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"MatrixForm", "[", 
    RowBox[{"marg", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "display", " ", "Margules", " ", "parameters", " ", "in", " ", 
      "Matrix"}], "-", "form"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CalcFormula", "[", 
     RowBox[{"\"\<hs78b\>\"", ",", 
      RowBox[{"CalcFormulaMode", "\[Rule]", 
       RowBox[{"{", "}"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"w", "=", 
    RowBox[{"MargulesB", "[", 
     RowBox[{"5000", ",", 
      RowBox[{"500", "+", "273"}], ",", "marg", ",", "4"}], "]"}]}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"calculate", " ", "three"}], "-", 
      RowBox[{"dimensional", " ", 
       RowBox[{"W", "'"}], "s", " ", 
       RowBox[{"(", 
        RowBox[{"three", " ", "indices"}], ")"}], " ", "at", " ", "P", " ", 
       "and", " ", "T"}]}], ",", " ", 
     RowBox[{"appropriate", " ", "for", " ", "the", " ", 
      RowBox[{"Berman", " ", "/", " ", "Brown"}], " ", "formalism"}]}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"x", " ", "=", " ", 
    RowBox[{
     RowBox[{"ExtractSampleDatB", "[", 
      RowBox[{"\"\<grt\>\"", ",", "\"\<hs78b\>\""}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"extract", " ", "site", " ", "fractions", " ", "of", " ", "Ca"}],
      ",", " ", "Mg", ",", " ", 
     RowBox[{
     "Fe", " ", "and", " ", "Mn", " ", "in", " ", "garnet", " ", "from", " ", 
      "the", " ", "file", " ", "\"\<hs78b\>\""}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"rtlny", " ", "=", 
    RowBox[{"GammaBB", "[", 
     RowBox[{"1", ",", "4", ",", "w", ",", "x"}], "]"}]}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Ca", " ", "is", " ", "cation", " ", "1", " ", "out", " ", "of", " ", "4",
      " ", "mixing", " ", "cations", " ", "on", " ", "this", " ", "site", " ",
      "of", " ", "garnet"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"gamma", " ", "=", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Exp", "[", 
       RowBox[{"rtlny", "/", 
        RowBox[{"(", 
         RowBox[{"8.3143", "*", "773"}], ")"}]}], "]"}], ")"}], "^", "3"}], 
    "       ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "results", " ", "are", " ", "identical", " ", "to", " ", "example", " ", 
      "8"}], "  ", "*)"}]}]}]}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {"0"},
          {"0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           FractionBox["21560", "3"]},
          {"6.263333333333333`"},
          {"0.03333333333333333`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           FractionBox["20320", "3"]},
          {"1.6933333333333334`"},
          {"0.05666666666666667`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {"0"},
          {"0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           FractionBox["69200", "3"]},
          {"6.263333333333333`"},
          {"0.03333333333333333`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {"0"},
          {"0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           FractionBox["230", "3"]},
          {"0"},
          {"0.003333333333333333`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {"0"},
          {"0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           FractionBox["2620", "3"]},
          {"1.6933333333333334`"},
          {"0.03`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"1240"},
          {"0"},
          {"0.019999999999999997`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {"0"},
          {"0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {"0"},
          {"0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {"0"},
          {"0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {"0"},
          {"0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {"0"},
          {"0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0"},
          {"0"},
          {"0"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.42270805178125*^9, 3.422768827453125*^9, 3.460966624359375*^9, 
   3.485751573536095*^9, 3.4857517028181305`*^9, {3.4857520212398458`*^9, 
   3.4857520439740753`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"hs78b.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "hs78b.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227080518125*^9, 3.42276882746875*^9, 3.460966624375*^9, 
   3.4857515735517206`*^9, 3.4857517028493805`*^9, {3.4857520212398458`*^9, 
   3.4857520439740753`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0", ",", "2511.776666666667`", ",", "5747.719999999999`", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "18391.77666666667`", ",", "13899.49666666667`", ",", 
       "10451.776666666668`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "285.61333333333334`"}], ",", "2731.053333333333`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "93.33333333333334`", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1340.`", ",", "716.6666666666666`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.42270805178125*^9, 3.422768827453125*^9, 3.460966624359375*^9, 
   3.485751573536095*^9, 3.4857517028181305`*^9, {3.4857520212398458`*^9, 
   3.4857520439740753`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.0254`", ",", "0.0934`", ",", "0.7691`", ",", "0.1121`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.42270805178125*^9, 3.422768827453125*^9, 3.460966624359375*^9, 
   3.485751573536095*^9, 3.4857517028181305`*^9, {3.4857520212398458`*^9, 
   3.4857520439740753`*^9}}],

Cell[BoxData["1336.6534346708268`"], "Output",
 CellChangeTimes->{
  3.42270805178125*^9, 3.422768827453125*^9, 3.460966624359375*^9, 
   3.485751573536095*^9, 3.4857517028181305`*^9, {3.4857520212398458`*^9, 
   3.4857520439740753`*^9}}],

Cell[BoxData["1.8662453775184846`"], "Output",
 CellChangeTimes->{
  3.42270805178125*^9, 3.422768827453125*^9, 3.460966624359375*^9, 
   3.485751573536095*^9, 3.4857517028181305`*^9, {3.4857520212398458`*^9, 
   3.4857520439897003`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
     "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
     "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
     "\[IndentingNewLine]", "\t", "Example", " ", "for", " ", "use", " ", 
     "of", " ", "the", " ", "Pet"}], "-", 
    RowBox[{"Functions", ":", " \t\t", 
     RowBox[{
      RowBox[{"-", "MargulesB"}], "-", " ", 
      RowBox[{"in", " ", "combination", " ", "with"}], " ", "-", 
      "GammaSymbolic", "-", "\[IndentingNewLine]", 
      RowBox[{
      "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
       "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
       "___", "___", "___", "___", "___", "___", "___", "___", "___", 
       "_"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "10"}], ":", " ", 
     RowBox[{
      RowBox[{"calculate", " ", "G", 
       RowBox[{"(", "mix", ")"}], " ", "for", " ", "the", " ", "grossular"}], 
      " ", "-", " ", 
      RowBox[{"pyrope", " ", "join", " ", "at", " ", "1", " ", "bar"}]}]}], 
    ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "500", " ", "C", " ", "comparing", " ", "the", " ", "binary", " ", 
       "mixing", " ", "models", " ", "of", " ", "Berman"}], " ", "&"}], " ", 
     "Aranovich", " ", 
     RowBox[{"(", "1996", ")"}]}], ",", " ", 
    RowBox[{
     RowBox[{"Ganguly", " ", "et", " ", 
      RowBox[{"al", ".", " ", 
       RowBox[{"(", "1996", ")"}]}], " ", "and", " ", "Mukhopadhyay", " ", 
      "et", " ", 
      RowBox[{"al", ".", " ", 
       RowBox[{"(", "1997", ")"}]}]}], ";", " ", "\[IndentingNewLine]", 
     RowBox[{"This", " ", "plot", " ", "reproduces", " ", 
      RowBox[{"Fig", ".", " ", "1"}], "a", " ", "of", " ", "Holdaway"}]}], 
    ",", " ", 
    RowBox[{
     RowBox[{"(", "2000", ")"}], ":", " ", 
     RowBox[{
      RowBox[{"Am", " ", "Min", " ", "85"}], ":", " ", 
      RowBox[{"881", "-", "892"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "First", " ", "display", " ", "the", " ", "activity", " ", "models", " ", 
    "of", " ", "garnet"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"ActivityB", "[", 
   RowBox[{"p", ",", "t", ",", "py", ",", "\"\<\>\"", ",", 
    RowBox[{"ActivityMode", "\[Rule]", "DisplayActivityModel"}]}], 
   "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Activity-model for: \"\>", "\[InvisibleSpace]", "\<\"grt\"\>", 
   "\[InvisibleSpace]", "\<\" (one-site basis). Number \"\>", 
   "\[InvisibleSpace]", "1", "\[InvisibleSpace]", "\<\" in data file.\"\>"}],
  SequenceForm[
  "Activity-model for: ", "grt", " (one-site basis). Number ", 1, 
   " in data file."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440053253`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ideal activity: aid(\"\>", "\[InvisibleSpace]", "\<\"py\"\>", 
   "\[InvisibleSpace]", "\<\") = \"\>", "\[InvisibleSpace]", 
   SuperscriptBox["XMgC", "3"]}],
  SequenceForm["Ideal activity: aid(", "py", ") = ", $CellContext`XMgC^3],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440053253`*^9}}],

Cell[BoxData["\<\"___________________________________\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440053253`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Activity-model \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"GrtBerman\"\>"}],
  SequenceForm["Activity-model ", 1, ": ", "GrtBerman"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440053253`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Site \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" {name, occupancy}: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"C\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
       ",", "\<\"Mn\"\>"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" NonIdeal\"\>"}],
  SequenceForm[
  "Site ", 1, " {name, occupancy}: ", {"C", {"Ca", "Mg", "Fe", "Mn"}}, 
   " NonIdeal"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440053253`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Margules parameters displayed as square-matrix: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}], "\[InvisibleSpace]", "\<\" x \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}]}],
  SequenceForm[
  "Margules parameters displayed as square-matrix: ", {
   "Ca", "Mg", "Fe", "Mn"}, " x ", {"Ca", "Mg", "Fe", "Mn"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440053253`*^9}}],

Cell[BoxData["\<\"Each matrix-element is {WH, WS, WV} on a one-site basis. \
Units: J, bar, mol.\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440209503`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"7186.666666666667`"},
          {"6.263333333333333`"},
          {"0.03333333333333333`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"6773.333333333333`"},
          {"1.6933333333333334`"},
          {"0.05666666666666667`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"23066.666666666668`"},
          {"6.263333333333333`"},
          {"0.03333333333333333`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"76.66666666666667`"},
          {"0.`"},
          {"0.003333333333333333`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"873.3333333333334`"},
          {"1.6933333333333334`"},
          {"0.03`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"1240.`"},
          {"0.`"},
          {"0.019999999999999997`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440209503`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ternary parameter(s): \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "}"}]}],
  SequenceForm["Ternary parameter(s): ", {{{1, 2, 3}, {0, 0, 0}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440209503`*^9}}],

Cell[BoxData["\<\"___________________________________\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440209503`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Activity-model \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"GrtHoldaway\"\>"}],
  SequenceForm["Activity-model ", 2, ": ", "GrtHoldaway"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440209503`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Site \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" {name, occupancy}: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"C\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
       ",", "\<\"Mn\"\>"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" NonIdeal\"\>"}],
  SequenceForm[
  "Site ", 1, " {name, occupancy}: ", {"C", {"Ca", "Mg", "Fe", "Mn"}}, 
   " NonIdeal"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044036575*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Margules parameters displayed as square-matrix: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}], "\[InvisibleSpace]", "\<\" x \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}]}],
  SequenceForm[
  "Margules parameters displayed as square-matrix: ", {
   "Ca", "Mg", "Fe", "Mn"}, " x ", {"Ca", "Mg", "Fe", "Mn"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044036575*^9}}],

Cell[BoxData["\<\"Each matrix-element is {WH, WS, WV} on a one-site basis. \
Units: J, bar, mol.\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044036575*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"8586.333333333334`"},
          {"4.289999999999999`"},
          {"0.04666666666666667`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"6644.`"},
          {"3.223333333333333`"},
          {"0.045`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"475.`"},
          {"0.`"},
          {"0.021666666666666667`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"22038.`"},
          {"6.326666666666666`"},
          {"0.02266666666666667`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> 
           {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "1890.6666666666667`"}]},
          {
           RowBox[{"-", "1.9966666666666666`"}]},
          {
           RowBox[{"-", "0.011333333333333334`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"13749.666666666666`"},
          {"7.67`"},
          {"0.013`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "434.6666666666667`"}]},
          {
           RowBox[{"-", "0.11333333333333334`"}]},
          {"0.013333333333333332`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"3874.`"},
          {"1.8333333333333333`"},
          {"0.016666666666666666`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"620.`"},
          {"0.`"},
          {"0.007333333333333332`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"475.`"},
          {"0.`"},
          {"0.021666666666666667`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"13749.666666666666`"},
          {"7.67`"},
          {"0.013`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"620.`"},
          {"0.`"},
          {"0.007333333333333332`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044036575*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ternary parameter(s): \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2466", ",", "0", ",", "0"}], "}"}]}], "}"}], "}"}]}],
  SequenceForm["Ternary parameter(s): ", {{{1, 2, 3}, {2466, 0, 0}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044036575*^9}}],

Cell[BoxData["\<\"___________________________________\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044036575*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Activity-model \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"GrtMukhopadhyay\"\>"}],
  SequenceForm["Activity-model ", 3, ": ", "GrtMukhopadhyay"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440522*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Site \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" {name, occupancy}: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"C\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
       ",", "\<\"Mn\"\>"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" NonIdeal\"\>"}],
  SequenceForm[
  "Site ", 1, " {name, occupancy}: ", {"C", {"Ca", "Mg", "Fe", "Mn"}}, 
   " NonIdeal"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440522*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Margules parameters displayed as square-matrix: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}], "\[InvisibleSpace]", "\<\" x \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}]}],
  SequenceForm[
  "Margules parameters displayed as square-matrix: ", {
   "Ca", "Mg", "Fe", "Mn"}, " x ", {"Ca", "Mg", "Fe", "Mn"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440522*^9}}],

Cell[BoxData["\<\"Each matrix-element is {WH, WS, WV} on a one-site basis. \
Units: J, bar, mol.\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440522*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"4768.666666666667`"},
          {"0.8300000000000001`"},
          {"0.04666666666666667`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"5842.`"},
          {"4.836666666666666`"},
          {"0.045`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"21727.333333333332`"},
          {"6.9399999999999995`"},
          {"0.02266666666666667`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "8055.333333333333`"}]},
          {
           RowBox[{"-", "7.363333333333333`"}]},
          {
           RowBox[{"-", "0.011333333333333334`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "6037.666666666667`"}]},
          {
           RowBox[{"-", "5.17`"}]},
          {"0.013333333333333332`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"7421.666666666667`"},
          {"4.133333333333333`"},
          {"0.016666666666666666`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440522*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ternary parameter(s): \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2466", ",", "0", ",", "0"}], "}"}]}], "}"}], "}"}]}],
  SequenceForm["Ternary parameter(s): ", {{{1, 2, 3}, {2466, 0, 0}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044067825*^9}}],

Cell[BoxData["\<\"___________________________________\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044067825*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Activity-model \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"GrtBermanAranovich\"\>"}],
  SequenceForm["Activity-model ", 4, ": ", "GrtBermanAranovich"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044067825*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Site \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" {name, occupancy}: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"C\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
       ",", "\<\"Mn\"\>"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" NonIdeal\"\>"}],
  SequenceForm[
  "Site ", 1, " {name, occupancy}: ", {"C", {"Ca", "Mg", "Fe", "Mn"}}, 
   " NonIdeal"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044067825*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Margules parameters displayed as square-matrix: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}], "\[InvisibleSpace]", "\<\" x \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}]}],
  SequenceForm[
  "Margules parameters displayed as square-matrix: ", {
   "Ca", "Mg", "Fe", "Mn"}, " x ", {"Ca", "Mg", "Fe", "Mn"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044067825*^9}}],

Cell[BoxData["\<\"Each matrix-element is {WH, WS, WV} on a one-site basis. \
Units: J, bar, mol.\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044067825*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"11156.666666666666`"},
          {"6.263333333333333`"},
          {"0.05766666666666666`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"7317.133333333333`"},
          {"3.143333333333333`"},
          {"0.05666666666666667`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"22760.`"},
          {"6.263333333333333`"},
          {"0.011999999999999999`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"1688.1666666666665`"},
          {"1.37`"},
          {"0.003333333333333333`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"3860.5`"},
          {"3.143333333333333`"},
          {"0.03`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"2083.0333333333333`"},
          {"1.37`"},
          {"0.019999999999999997`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440834494`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ternary parameter(s): \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "}"}]}],
  SequenceForm["Ternary parameter(s): ", {{{1, 2, 3}, {0, 0, 0}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440834494`*^9}}],

Cell[BoxData["\<\"___________________________________\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440834494`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Activity-model \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"GrtGanguly\"\>"}],
  SequenceForm["Activity-model ", 5, ": ", "GrtGanguly"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440834494`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Site \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" {name, occupancy}: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"C\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
       ",", "\<\"Mn\"\>"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" NonIdeal\"\>"}],
  SequenceForm[
  "Site ", 1, " {name, occupancy}: ", {"C", {"Ca", "Mg", "Fe", "Mn"}}, 
   " NonIdeal"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440834494`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Margules parameters displayed as square-matrix: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}], "\[InvisibleSpace]", "\<\" x \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}]}],
  SequenceForm[
  "Margules parameters displayed as square-matrix: ", {
   "Ca", "Mg", "Fe", "Mn"}, " x ", {"Ca", "Mg", "Fe", "Mn"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440834494`*^9}}],

Cell[BoxData["\<\"Each matrix-element is {WH, WS, WV} on a one-site basis. \
Units: J, bar, mol.\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440990744`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"9834.`"},
          {"5.779999999999999`"},
          {"0.057999999999999996`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"6773.`"},
          {"1.69`"},
          {"0.03`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"6773.`"},
          {"1.69`"},
          {"0.03`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"21627.`"},
          {"5.779999999999999`"},
          {"0.011999999999999999`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"695.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"12083.`"},
          {"7.67`"},
          {"0.03`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"873.`"},
          {"1.69`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"2117.`"},
          {"0.`"},
          {"0.06999999999999999`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"539.`"},
          {"0.`"},
          {"0.009999999999999998`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"873.`"},
          {"1.69`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"12083.`"},
          {"7.67`"},
          {"0.039999999999999994`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"539.`"},
          {"0.`"},
          {"0.039999999999999994`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440990744`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ternary parameter(s): \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "}"}]}],
  SequenceForm["Ternary parameter(s): ", {{{1, 2, 3}, {0, 0, 0}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440990744`*^9}}],

Cell[BoxData["\<\"___________________________________\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440990744`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Activity-model \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"GrtDachs\"\>"}],
  SequenceForm["Activity-model ", 6, ": ", "GrtDachs"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520440990744`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Site \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" {name, occupancy}: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"C\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
       ",", "\<\"Mn\"\>"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" NonIdeal\"\>"}],
  SequenceForm[
  "Site ", 1, " {name, occupancy}: ", {"C", {"Ca", "Mg", "Fe", "Mn"}}, 
   " NonIdeal"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520441146994`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Margules parameters displayed as square-matrix: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}], "\[InvisibleSpace]", "\<\" x \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}]}],
  SequenceForm[
  "Margules parameters displayed as square-matrix: ", {
   "Ca", "Mg", "Fe", "Mn"}, " x ", {"Ca", "Mg", "Fe", "Mn"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520441146994`*^9}}],

Cell[BoxData["\<\"Each matrix-element is {WH, WS, WV} on a one-site basis. \
Units: J, bar, mol.\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520441146994`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"2292.0666666666666`"},
          {"2.083333333333333`"},
          {"0.05433333333333333`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"3506.4`"},
          {"0.8933333333333333`"},
          {"0.033166666666666664`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"7327.533333333333`"},
          {"2.083333333333333`"},
          {
           RowBox[{"-", "0.0044333333333333325`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"75.39999999999999`"},
          {"0.`"},
          {
           RowBox[{"-", "0.00002333333333333333`"}]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "945.4666666666667`"}]},
          {"0.15033333333333332`"},
          {"0.020499999999999997`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"379.3`"},
          {"0.`"},
          {"0.007333333333333332`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520441146994`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ternary parameter(s): \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "}"}]}],
  SequenceForm["Ternary parameter(s): ", {{{1, 2, 3}, {0, 0, 0}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520441146994`*^9}}],

Cell[BoxData["\<\"___________________________________\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520441303244`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Activity-model \"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", "\<\"GrtLal\"\>"}],
  SequenceForm["Activity-model ", 7, ": ", "GrtLal"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520441303244`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Site \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" {name, occupancy}: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"C\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
       ",", "\<\"Mn\"\>"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" NonIdeal\"\>"}],
  SequenceForm[
  "Site ", 1, " {name, occupancy}: ", {"C", {"Ca", "Mg", "Fe", "Mn"}}, 
   " NonIdeal"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520441303244`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Margules parameters displayed as square-matrix: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}], "\[InvisibleSpace]", "\<\" x \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}]}],
  SequenceForm[
  "Margules parameters displayed as square-matrix: ", {
   "Ca", "Mg", "Fe", "Mn"}, " x ", {"Ca", "Mg", "Fe", "Mn"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520441303244`*^9}}],

Cell[BoxData["\<\"Each matrix-element is {WH, WS, WV} on a one-site basis. \
Units: J, bar, mol.\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520441303244`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"4184.`"},
          {"6.276`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"4560.56`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"16932.648`"},
          {"6.276`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "5255.104`"}]},
          {
           RowBox[{"-", "4.184`"}]},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "3025.032`"}]},
          {
           RowBox[{"-", "1.389088`"}]},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"12049.92`"},
          {"7.1128`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520441303244`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ternary parameter(s): \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "18819.632`"}], ",", 
        RowBox[{"-", "6.342944`"}], ",", "0"}], "}"}]}], "}"}], "}"}]}],
  SequenceForm[
  "Ternary parameter(s): ", {{{1, 2, 3}, {-18819.632, -6.342944, 0}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520441459494`*^9}}],

Cell[BoxData["\<\"___________________________________\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520441459494`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Activity-model \"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"GrtGangulySaxena\"\>"}],
  SequenceForm["Activity-model ", 8, ": ", "GrtGangulySaxena"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520441459494`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Site \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" {name, occupancy}: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"C\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
       ",", "\<\"Mn\"\>"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" NonIdeal\"\>"}],
  SequenceForm[
  "Site ", 1, " {name, occupancy}: ", {"C", {"Ca", "Mg", "Fe", "Mn"}}, 
   " NonIdeal"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520441459494`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Margules parameters displayed as square-matrix: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}], "\[InvisibleSpace]", "\<\" x \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}]}],
  SequenceForm[
  "Margules parameters displayed as square-matrix: ", {
   "Ca", "Mg", "Fe", "Mn"}, " x ", {"Ca", "Mg", "Fe", "Mn"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520441459494`*^9}}],

Cell[BoxData["\<\"Each matrix-element is {WH, WS, WV} on a one-site basis. \
Units: J, bar, mol.\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.4857520441459494`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"4184.`"},
          {"6.276`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"19330.08`"},
          {"6.276`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"16932.648`"},
          {"6.276`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"836.8000000000001`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"12552.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {
           RowBox[{"-", "2635.92`"}]},
          {"6.276`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"10460.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"12552.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044161574*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ternary parameter(s): \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "22175.2`"}], ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "6372.232`"}], ",", "0", ",", "0"}], "}"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10983.`", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4811.6`"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    "}"}]}],
  SequenceForm[
  "Ternary parameter(s): ", {{{1, 2, 3}, {-22175.2, 0, 0}}, {{1, 2, 
     4}, {-6372.232, 0, 0}}, {{1, 3, 4}, {10983., 0, 0}}, {{2, 3, 
     4}, {-4811.6, 0, 0}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044161574*^9}}],

Cell[BoxData["\<\"___________________________________\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044161574*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Activity-model \"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", 
   "\[InvisibleSpace]", "\<\"GrtNewtonHaselton\"\>"}],
  SequenceForm["Activity-model ", 9, ": ", "GrtNewtonHaselton"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044161574*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Site \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" {name, occupancy}: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"C\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
       ",", "\<\"Mn\"\>"}], "}"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" NonIdeal\"\>"}],
  SequenceForm[
  "Site ", 1, " {name, occupancy}: ", {"C", {"Ca", "Mg", "Fe", "Mn"}}, 
   " NonIdeal"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044161574*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Margules parameters displayed as square-matrix: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}], "\[InvisibleSpace]", "\<\" x \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"\<\"Ca\"\>", ",", "\<\"Mg\"\>", ",", "\<\"Fe\"\>", 
     ",", "\<\"Mn\"\>"}], "}"}]}],
  SequenceForm[
  "Margules parameters displayed as square-matrix: ", {
   "Ca", "Mg", "Fe", "Mn"}, " x ", {"Ca", "Mg", "Fe", "Mn"}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044177199*^9}}],

Cell[BoxData["\<\"Each matrix-element is {WH, WS, WV} on a one-site basis. \
Units: J, bar, mol.\"\>"], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044177199*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"13807.2`"},
          {"6.276`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"13807.2`"},
          {"6.276`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]},
     {
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}], 
      RowBox[{"(", "\[NoBreak]", 
       TagBox[GridBox[{
          {"0.`"},
          {"0.`"},
          {"0.`"}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column], "\[NoBreak]", ")"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044177199*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ternary parameter(s): \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "}"}]}],
  SequenceForm["Ternary parameter(s): ", {{{1, 2, 3}, {0, 0, 0}}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.422708064953125*^9, 3.422768829296875*^9, 3.460966626125*^9, 
   3.485751573661096*^9, 3.4857517056462555`*^9, {3.4857520212710953`*^9, 
   3.485752044177199*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Example", " ", "10", " ", 
    RowBox[{"continued", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "this", " ", "shows", " ", "that", " ", "grt", " ", "is", " ", "number", 
     " ", "1", " ", "in", " ", "the", " ", "data", " ", "file"}], ",", " ", 
    RowBox[{
    "that", " ", "the", " ", "activity", " ", "models", " ", "of", " ", 
     "Mukhopadhyay", " ", "et", " ", 
     RowBox[{"al", ".", " ", 
      RowBox[{"(", "1997", ")"}]}]}], ",", 
    RowBox[{
     RowBox[{"Berman", " ", "&"}], " ", "Aranovich", " ", 
     RowBox[{"(", "1996", ")"}], " ", "and", " ", "Ganguly", " ", "et", " ", 
     RowBox[{"al", ".", " ", 
      RowBox[{"(", "1996", ")"}]}], " ", "are", " ", "models", " ", "3"}], 
    ",", " ", 
    RowBox[{
     RowBox[{
     "4", " ", "and", " ", "5", " ", "and", " ", "that", " ", "there", " ", 
      "are", " ", "four", " ", "components", " ", "in", " ", "the", " ", 
      "order", " ", 
      RowBox[{"{", 
       RowBox[{"Ca", ",", " ", "Mg", ",", " ", "Fe", ",", " ", "Mn"}], 
       "}"}]}], ";", " ", "\[IndentingNewLine]", 
     RowBox[{"Thus", " ", "X", 
      RowBox[{"(", "2", ")"}], " ", "is", " ", "X", 
      RowBox[{"(", "py", ")"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"G", 
       RowBox[{"(", "ex", ")"}], " ", "is", " ", "calculated", " ", "for", 
       " ", "a", " ", "4", " ", "component"}], "-", 
      RowBox[{"mixture", " ", "and", " ", "X", 
       RowBox[{"(", "3", ")"}], " ", "and", " ", "X", 
       RowBox[{"(", "4", ")"}], " ", "are", " ", "then", " ", "set", " ", 
       "to", " ", "0"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
      "run", " ", "2", "nd", " ", "cell", " ", "with", " ", "source"}], "-", 
      RowBox[{"code", " ", "of"}], " ", "-", "GammaSymbolic1", "-", " ", 
      RowBox[{"before", " ", "running", " ", "this", " ", "example"}]}]}]}], 
   " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "w", "]"}], ";", " ", 
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dat", "=", 
     RowBox[{"LoadActivityData", "[", "\"\<ACTIVITYBDAT.m\>\"", "]"}]}], 
    ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"load", " ", "the", " ", "activity"}], "-", "data", "-", 
     RowBox[{
     "file", " ", "containing", " ", "the", " ", "Margules", " ", 
      "parameters"}]}], "  ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"pick", " ", "out", " ", "the", " ", 
     RowBox[{"models", ":", " ", 
      RowBox[{
      "the", " ", "2", "nd", " ", "index", " ", "is", " ", "alway", " ", 
       "3"}]}]}], "  ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"model3", " ", "=", " ", 
     RowBox[{"dat", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "3", ",", "3"}], "]"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"model4", " ", "=", " ", 
     RowBox[{"dat", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "3", ",", "4"}], "]"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"model5", " ", "=", " ", 
     RowBox[{"dat", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "3", ",", "5"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"p", "=", "1"}], ";", " ", 
    RowBox[{"t", "=", 
     RowBox[{"500", "+", "273.15"}]}], ";", " ", 
    RowBox[{"c", " ", "=", " ", "4"}], ";", " ", 
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "calculate", " ", "the", " ", "Margules", " ", "parameters", " ", "for", 
      " ", "P", " ", "and", " ", "T", " ", "for", " ", "the", " ", "1", "st", 
      " ", 
      RowBox[{"model", ":", " ", 
       RowBox[{"the", " ", 
        RowBox[{"index", " ", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "1"}], "]"}], "]"}], " ", "is", " ", 
        RowBox[{"required", ":", " ", 
         RowBox[{
         "the", " ", "first", " ", "index", " ", "is", " ", "alway", " ", 
          "2"}]}]}]}]}], ",", " ", 
     RowBox[{
     "the", " ", "2", "nd", " ", "index", " ", "1", " ", "indicates", " ", 
      "site", " ", "1", " ", 
      RowBox[{"(", 
       RowBox[{
       "the", " ", "only", " ", "site", " ", "on", " ", "which", " ", 
        "mixing", " ", "occurs", " ", "in", " ", "the", " ", "case", " ", 
        "of", " ", 
        RowBox[{"garnet", "."}]}], " "}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "=", 
     RowBox[{"MargulesB", "[", 
      RowBox[{"p", ",", "t", ",", 
       RowBox[{"model3", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", "c"}], "]"}]}], ";"}], 
   "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"gamma1", ",", "gex"}], "}"}], " ", "=", " ", 
     RowBox[{"GammaSymbolic1", "[", 
      RowBox[{"4", ",", "1", ",", "1"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"gex", " ", "is", " ", "assigned", " ", "the", " ", "G", 
     RowBox[{"(", "ex", ")"}], " ", "function", " ", "for", " ", "a", " ", 
     "quaternary", " ", "garnet"}], "  ", "*)"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"replace", " ", "in", " ", "the", " ", "gex"}], "-", 
      RowBox[{"expression", " ", 
       RowBox[{"x", "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "by", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x2"}], ")"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"[", "2", "]"}], "]"}], " ", "by", " ", "x2"}], ",", " ", 
     RowBox[{
      RowBox[{"set", " ", 
       RowBox[{"x", "[", 
        RowBox[{"[", "3", "]"}], "]"}], " ", "and", " ", 
       RowBox[{"x", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], " ", "=", " ", "0"}]}], "  ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gex", " ", "=", " ", 
     RowBox[{"gex", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[Rule]", 
         RowBox[{"(", 
          RowBox[{"1", "-", "x2"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "\[Rule]", "x2"}], ",", 
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "\[Rule]", "0"}]}], "}"}]}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{"p1", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"3", "gex"}], ",", 
       RowBox[{"{", 
        RowBox[{"x2", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], ";"}], 
   " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"create", " ", "the", " ", "1", "st", " ", "plot"}], ",", " ", 
     RowBox[{"but", " ", "supress", " ", "plotting"}]}], "  ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculate", " ", "the", " ", "Margules", " ", "parameters", " ", "for", 
     " ", "P", " ", "and", " ", "T", " ", "for", " ", "the", " ", "2", "nd", 
     " ", 
     RowBox[{"model", ":", " ", 
      RowBox[{"the", " ", 
       RowBox[{"index", " ", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "1"}], "]"}], "]"}], " ", "is", " ", 
       RowBox[{"required", "."}]}]}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"w", "=", 
     RowBox[{"MargulesB", "[", 
      RowBox[{"p", ",", "t", ",", 
       RowBox[{"model4", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", "c"}], "]"}]}], ";"}], 
   "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"gamma1", ",", "gex"}], "}"}], " ", "=", " ", 
     RowBox[{"GammaSymbolic1", "[", 
      RowBox[{"4", ",", "1", ",", "1"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"gex", " ", "is", " ", "assigned", " ", "the", " ", "G", 
     RowBox[{"(", "ex", ")"}], " ", "function", " ", "for", " ", "a", " ", 
     "quaternary", " ", "garnet"}], "  ", "*)"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"replace", " ", "in", " ", "the", " ", "gex"}], "-", 
      RowBox[{"expression", " ", 
       RowBox[{"x", "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "by", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x2"}], ")"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"[", "2", "]"}], "]"}], " ", "by", " ", "x2"}], ",", " ", 
     RowBox[{
      RowBox[{"set", " ", 
       RowBox[{"x", "[", 
        RowBox[{"[", "3", "]"}], "]"}], " ", "and", " ", 
       RowBox[{"x", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], " ", "=", " ", "0"}]}], "  ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gex", " ", "=", " ", 
     RowBox[{"gex", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[Rule]", 
         RowBox[{"(", 
          RowBox[{"1", "-", "x2"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "\[Rule]", "x2"}], ",", 
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "\[Rule]", "0"}]}], "}"}]}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{"p2", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"3", "gex"}], ",", 
       RowBox[{"{", 
        RowBox[{"x2", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], ";"}], 
   " ", 
   RowBox[{"(*", " ", 
    RowBox[{"create", " ", "the", " ", "2", "nd", " ", "plot"}], "  ", "*)"}],
    "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculate", " ", "the", " ", "Margules", " ", "parameters", " ", "for", 
     " ", "P", " ", "and", " ", "T", " ", "for", " ", "the", " ", "3", "rd", 
     " ", 
     RowBox[{"model", ":", " ", 
      RowBox[{"the", " ", 
       RowBox[{"index", " ", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "1"}], "]"}], "]"}], " ", "is", " ", 
       RowBox[{"required", "."}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "=", 
     RowBox[{"MargulesB", "[", 
      RowBox[{"p", ",", "t", ",", 
       RowBox[{"model5", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", "c"}], "]"}]}], ";"}], 
   "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"gamma1", ",", "gex"}], "}"}], " ", "=", " ", 
     RowBox[{"GammaSymbolic1", "[", 
      RowBox[{"4", ",", "1", ",", "1"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"gex", " ", "is", " ", "assigned", " ", "the", " ", "G", 
     RowBox[{"(", "ex", ")"}], " ", "function", " ", "for", " ", "a", " ", 
     "quaternary", " ", "garnet"}], "  ", "*)"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"replace", " ", "in", " ", "the", " ", "gex"}], "-", 
      RowBox[{"expression", " ", 
       RowBox[{"x", "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "by", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x2"}], ")"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"[", "2", "]"}], "]"}], " ", "by", " ", "x2"}], ",", " ", 
     RowBox[{
      RowBox[{"set", " ", 
       RowBox[{"x", "[", 
        RowBox[{"[", "3", "]"}], "]"}], " ", "and", " ", 
       RowBox[{"x", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], " ", "=", " ", "0"}]}], "  ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gex", " ", "=", " ", 
     RowBox[{"gex", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[Rule]", 
         RowBox[{"(", 
          RowBox[{"1", "-", "x2"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "\[Rule]", "x2"}], ",", 
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "\[Rule]", "0"}]}], "}"}]}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{"p3", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"3", "gex"}], ",", 
       RowBox[{"{", 
        RowBox[{"x2", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], ";"}], 
   " ", 
   RowBox[{"(*", " ", 
    RowBox[{"create", " ", "the", " ", "3", "rd", " ", "plot"}], "  ", "*)"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"show", " ", "all", " ", "three", " ", "plots", " ", "together"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"p1", ",", "p2", ",", "p3", ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<X(2)\>\"", ",", "\"\<G(ex)\>\""}], "}"}]}]}], "]"}], 
   " "}]}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VN8bB3BEQgkVoewpe0lKxXNK2UlosQv1lW+LNRShbyhL+bWoRCGl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      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8lV8cB3CS0JDRuki/IllJEUn5nkII2XsmSkJmEiWFIqMkLbJLZrbs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      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nc8lV8YAHBFRkpC4xJlFpGRtD2nX0rmz0zJykqDspLsQsiqaMgski2r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      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"X(2)\"", TraditionalForm], 
    FormBox["\"G(ex)\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.42270808021875*^9, 3.42276883590625*^9, 3.46096662865625*^9, 
   3.4857515738954725`*^9, 3.4857517132087555`*^9, {3.4857520214898443`*^9, 
   3.4857520442240734`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "11"}], ":", " ", 
     RowBox[{
      RowBox[{
      "calculate", " ", "the", " ", "partial", " ", "molar", " ", "volumes", 
       " ", "of", " ", "the", " ", "grossular"}], "-", " ", 
      RowBox[{
      "and", " ", "pyrope", " ", "component", " ", "along", " ", "the", " ", 
       "grossular"}], " ", "-", " ", 
      RowBox[{"pyrope", " ", "join"}]}]}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
       "using", " ", "the", " ", "mixing", " ", "model", " ", "of", " ", 
        "Berman"}], " ", "&"}], " ", "Aranovich", " ", 
      RowBox[{
       RowBox[{"(", "1996", ")"}], ".", "\[IndentingNewLine]", "Note"}], " ", 
      "that", " ", "the", " ", "component", " ", "order", " ", 
      RowBox[{"is", ":", " ", "\[IndentingNewLine]", "1"}]}], " ", "=", " ", 
     "grossular"}], ",", " ", 
    RowBox[{"2", " ", "=", " ", "pyrope"}], ",", " ", 
    RowBox[{"3", " ", "=", " ", "almandine"}], ",", "  ", 
    RowBox[{
     RowBox[{"4", " ", "=", " ", 
      RowBox[{
       RowBox[{"spessartine", ":"}], " ", "\[Rule]", " ", 
       RowBox[{"X", 
        RowBox[{"(", "2", ")"}], " ", "is", " ", "X", 
        RowBox[{"(", "py", ")"}]}]}]}], ";", "\[IndentingNewLine]", "  ", 
     RowBox[{
      RowBox[{"V", 
       RowBox[{"(", "ex", ")"}], " ", "is", " ", "calculated", " ", "for", 
       " ", "a", " ", "4", " ", "component"}], "-", 
      RowBox[{"mixture", " ", "and", " ", "X", 
       RowBox[{"(", "3", ")"}], " ", "and", " ", "X", 
       RowBox[{"(", "4", ")"}], " ", "are", " ", "then", " ", "set", " ", 
       "to", " ", "0"}]}]}]}], "\[IndentingNewLine]", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "w", "]"}], ";", " ", 
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dat", "=", 
     RowBox[{"LoadActivityData", "[", "\"\<ACTIVITYBDAT.m\>\"", "]"}]}], 
    ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"load", " ", "the", " ", "activity"}], "-", "data", "-", 
     RowBox[{
     "file", " ", "containing", " ", "the", " ", "Margules", " ", 
      "parameters"}]}], "  ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"pick", " ", "out", " ", "the", " ", "Berman"}], "-", 
     RowBox[{"Aranovich", " ", "model", " ", 
      RowBox[{"(", 
       RowBox[{"model", " ", "4"}], ")"}]}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"model4", " ", "=", " ", 
     RowBox[{"dat", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "3", ",", "4"}], "]"}], "]"}]}], ";", " ", 
    RowBox[{"c", " ", "=", " ", "4"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"w", "=", 
     RowBox[{"MargulesB", "[", 
      RowBox[{"p", ",", "t", ",", 
       RowBox[{"model4", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", "c", ",", 
       RowBox[{"MargulesMode", "\[Rule]", "WV"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"gamma1", ",", "vex"}], "}"}], " ", "=", " ", 
     RowBox[{"GammaSymbolic1", "[", 
      RowBox[{"4", ",", "1", ",", "1"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"vex", " ", "is", " ", "assigned", " ", "the", " ", "V", 
     RowBox[{"(", "ex", ")"}], " ", "function", " ", "for", " ", "a", " ", 
     "quaternary", " ", "garnet"}], "  ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"replace", " ", "in", " ", "the", " ", "V", 
       RowBox[{"(", "ex", ")"}]}], "-", 
      RowBox[{"expression", " ", 
       RowBox[{"x", "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "by", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x2"}], ")"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"[", "2", "]"}], "]"}], " ", "by", " ", "x2"}], ",", " ", 
     RowBox[{
      RowBox[{"set", " ", 
       RowBox[{"x", "[", 
        RowBox[{"[", "3", "]"}], "]"}], " ", "and", " ", 
       RowBox[{"x", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], " ", "=", " ", "0"}]}], "  ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vex", " ", "=", " ", 
     RowBox[{"vex", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "\[Rule]", 
         RowBox[{"(", 
          RowBox[{"1", "-", "x2"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "\[Rule]", "x2"}], ",", 
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "\[Rule]", "0"}], ",", 
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "4", "]"}], "]"}], "\[Rule]", "0"}]}], "}"}]}]}], 
    ";"}], " ", "\n", 
   RowBox[{
    RowBox[{"vo2", " ", "=", " ", 
     RowBox[{
      RowBox[{"MinDat", "[", "py", "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "5"}], "]"}], "]"}]}], ";", 
    RowBox[{"vo1", " ", "=", " ", 
     RowBox[{
      RowBox[{"MinDat", "[", "gr", "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "5"}], "]"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"volume", " ", "of", " ", "the", " ", "end"}], "-", 
     RowBox[{
     "members", " ", "from", " ", "Berman", " ", "data", " ", "set"}]}], " ", 
    "*)"}], "\n", 
   RowBox[{
    RowBox[{"vmech", " ", "=", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "x2"}], ")"}], "vo1"}], " ", "+", " ", 
      RowBox[{"x2", " ", "vo2"}]}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "molar", " ", "volume", " ", "of", " ", "mechanical", " ", "mixture"}], 
    " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"v", " ", "=", " ", 
     RowBox[{"vmech", " ", "+", " ", "vex"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"total", " ", "molar", " ", "volume", " ", "of", " ", "mixture"}],
     "  ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"vp1", " ", "=", " ", 
     RowBox[{"v", " ", "-", " ", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"v", ",", "x2"}], "]"}], " ", "x2"}]}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "partial", " ", "molar", " ", "volume", " ", "of", " ", "grossular", " ", 
     "component"}], "  ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"vp2", " ", "=", " ", 
     RowBox[{"v", " ", "+", " ", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"v", ",", "x2"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x2"}], ")"}]}]}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "partial", " ", "molar", " ", "volume", " ", "of", " ", "pyrope", " ", 
     "component"}], "  ", "*)"}], "\n", 
   RowBox[{"p1a", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{"vp1", ",", 
      RowBox[{"{", 
       RowBox[{"x2", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<X(Py)\>\"", ",", "\"\<part. mol. volume (grossular)\>\""}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"p1b", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{"vp2", ",", 
      RowBox[{"{", 
       RowBox[{"x2", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<X(Py)\>\"", ",", "\"\<part. mol. volume (pyrope)\>\""}], 
        "}"}]}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.4227080973125*^9, 3.422708098515625*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd13k8lF8XAHDEjxQi+5Ks2aNCSQ5RCik7kSQiSwjZQryWEi0ShSLakC1E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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"X(Py)\"", TraditionalForm], 
    FormBox["\"part. mol. volume (grossular)\"", TraditionalForm]},
  AxesOrigin->{0, 12.540000000000001`},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.422708099703125*^9, 3.4227688414375*^9, 3.46096663071875*^9, 
   3.4857515740048485`*^9, 3.4857517189587555`*^9, {3.4857520215054693`*^9, 
   3.4857520442396984`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd13k8VG8XAHBbkSzZKiQJE1K0KSlnsocUKQolP8lLVKK0oihJSFL2pFT2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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"X(Py)\"", TraditionalForm], 
    FormBox["\"part. mol. volume (pyrope)\"", TraditionalForm]},
  AxesOrigin->{0, 11.32},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.422708099703125*^9, 3.4227688414375*^9, 3.46096663071875*^9, 
   3.4857515740048485`*^9, 3.4857517189587555`*^9, {3.4857520215054693`*^9, 
   3.4857520442396984`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
     "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
     "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
     "___", "\[IndentingNewLine]", "\t\t", "Examples", " ", "for", " ", "use",
      " ", "of", " ", "the", " ", "Pet"}], "-", 
    RowBox[{
     RowBox[{"Function", ":", "\t", 
      RowBox[{
       RowBox[{"-", "ActivityB"}], "-", " ", 
       RowBox[{
       "in", " ", "calculating", " ", "fluid", " ", "properties"}]}]}], 
     "\[IndentingNewLine]", 
     RowBox[{
     "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
      "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
      "___", "___", "___", "___", "___", "___", "___", "___", "___", "___", 
      "__"}]}]}], "  ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Example", " ", "12"}], ":", " ", 
      RowBox[{
       RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
       "ActivityB", "-", " ", 
       RowBox[{
       "to", " ", "calculate", " ", "activities", " ", "in", " ", "H2O"}], 
       "-", 
       RowBox[{"CO2", " ", "fluids", " ", "at", " ", "P", " ", "and", " ", 
        RowBox[{"T", ".", "\[IndentingNewLine]", "This"}], " ", "example", 
        " ", "uses", " ", "the", " ", "Kerrick"}]}]}], " ", "&"}], " ", 
    "Jacobs", " ", 
    RowBox[{"(", "1981", ")"}], " ", "model", " ", "and", " ", "reproduces", 
    " ", "their", " ", "Fig", ".12"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"t", " ", "=", " ", 
     RowBox[{"500", "+", "273.15"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"FluidActivity", ",", 
      RowBox[{"FluidActivityModel", "\[Rule]", "KerrickJacobs81"}], ",", 
      RowBox[{"FluidSystem", "\[Rule]", "H2OCO2"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p1a", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"1000", ",", "t", ",", "h2o", ",", 
          RowBox[{"1", "-", "x"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p1b", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"1000", ",", "t", ",", "co2", ",", "x"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p2a", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"2000", ",", "t", ",", "h2o", ",", 
          RowBox[{"1", "-", "x"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p2b", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"2000", ",", "t", ",", "co2", ",", "x"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p4a", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"4000", ",", "t", ",", "h2o", ",", 
          RowBox[{"1", "-", "x"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p4b", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"4000", ",", "t", ",", "co2", ",", "x"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p6a", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"6000", ",", "t", ",", "h2o", ",", 
          RowBox[{"1", "-", "x"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p6b", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"6000", ",", "t", ",", "co2", ",", "x"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p8a", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"8000", ",", "t", ",", "h2o", ",", 
          RowBox[{"1", "-", "x"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p8b", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"8000", ",", "t", ",", "co2", ",", "x"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p10a", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"10000", ",", "t", ",", "h2o", ",", 
          RowBox[{"1", "-", "x"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p10b", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"10000", ",", "t", ",", "co2", ",", "x"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p20a", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"20000", ",", "t", ",", "h2o", ",", 
          RowBox[{"1", "-", "x"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p20b", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"20000", ",", "t", ",", "co2", ",", "x"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p30a", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"30000", ",", "t", ",", "h2o", ",", 
          RowBox[{"1", "-", "x"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p30b", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"30000", ",", "t", ",", "co2", ",", "x"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plot1", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
     "p1a", ",", "p1b", ",", "p2a", ",", "p2b", ",", "p4a", ",", "p4b", ",", 
      "p6a", ",", "p6b", ",", "p8a", ",", "p8b", ",", "p10a", ",", "p10b", 
      ",", "p20a", ",", "p20b", ",", "p30a", ",", "p30b", ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<X(CO2)\>\"", ",", "\"\<activity\>\""}], "}"}]}]}], 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.422708119671875*^9, 3.422708163671875*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtlHk0FHgAx12lTY0MUztpWEktlS5Z0vat2OTanqOlw7FFuTq3TDZWiooa
Jk+lkDOJzXQ4sq5o1kZyjXGEYaZpDDPmx4s8Ouzse/vH933/+n6/f30/RodO
uAWoqaiouCj1nzsGSNteDO/dVmOoNTk7S6Bhu/TkAN0CtgE3j0R+IdiUkZL2
jG6HO96myz7PEDi96XqaTvcAa3+9y5dJAk//qaokuj/C+s7mUOQE/euu2LLo
Z+AXQxWGdBNk0vZcjqfHwGJ+K0PzKUH0vGer4ujJ0KKVPWAGEnjty+KMjefi
Ke3brJ18BbRmow/aG3DA4iS2bvFUwMRVIX15rRjNdxPsx0SjYDZbI2WiHAkL
WHFjQaNYUqwjUFWtQVjyOd3iT3KUimybWrbWoeFP7vP9sXLUBafr75NzYaOX
Ih9bJMfkyh+1Hx37B8zX5c52OTKoTRcu0jdpRGdQOfWsmQyWs36l7kVN4Lxp
SjpZNoKmGIvmerMWNGiPLNxlNwJDtmz6oaIVN9e0c725w5BNDQj469sxHXCx
Rs9xGLkjFY2UBB4UdkWhG+ukoDAeELG4A83u1sae1lJcDyo5krmiE1Sjz1ZJ
pUP4uL1QHBjVBWme8QUHkyGc2cgtXvyyG42l/p+O3ZVgoIh7rc3oLcqWRbJD
VCT4FNyRavp7L07tFFCyA95j9Q7Nr0cq+rDSSuql1S6GfbbR0SdLBJjYsKr+
hrkYTIbvcuHBAViyakQlSe+wRr5Xq8tlEJPs471DH0XQ1R6bx50ZxFvNBXfi
HEXQqEnlGKcJUa3bGH4jT4gQi4qeb5xE6AwMV4sYH0Shw6HMamXuaDV7zHWr
ske2dJHk1jvcpvh6cL4bQIm7vXqynRh7QpgG5vf7EbU7NqNYIkaic7VW79Y+
GPU7dufEvkfgOFH5zH+LLT/EJNM3SmD+q+KYk2MPDhq0TKvyJDj3hP3LDl4X
JhtZopPRQ+Am9czdZ9mJFA2fM24rpOjgF5j3F3VAV1CSrcaVgrs6QjXOlIc5
kdEe1qeG8UfgfofFkW1QeejDEVFHcF5rwYaJ5hacvsthUetGwLC6nBbq3oSq
1Vfn6RyXwfiwunNG7yvoOJ5ec5EiR9X24N1uyX+jb20rL7xSDuklevy6mVo8
vocVYp9RdFON984YV8GbY6nD+DoKWsOBXa/9SnEhNiu6r0CBE6oB+nqSR3gk
ZaRSnAmW0HbkD5Vn4Gp6rJ/gZwKqb5dti00G/N1GTYpcCbZMejs8rrqHZZWV
j108CZLnPEzyqU1HfOKB+uuHCNQvrTcKfZWKQMs74/PDCcpYtT858W9jeYze
bs08gsXhoTyLjkR8tYpY2JVPcDqLSXw6E9Az+q49r5CgpdVAcr6bBbbnM+9d
TwjC3tP8E/quYdbM7bfYSoIC9bP5NPEV9LUl3lPnKfcexKsdEEbh+eWpwzw+
Qa5qU818cSSSbXxNc5S/nisdtMqUnIfTffPinQICbS9TvwgZE3+de9MQPUyQ
7eHF+DB0ArfWbk50VXKhoUI9tEgWglOiNA8jQuA/I7TaTI7ie+fQgRcTBEGR
HzIdZb7QUO3IZU8RmEXlWzPGPTFYYhPsp+ROwKaEgoWje1AZnLNuvZJLNsIq
PkMB3P6fW2mthmG1+r7b/gXC83GR
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxFz2k81AkAxnFXsSlMtfUZhbRsiY4V3XlExaKE8ek0ylEahaSDUqYMFpXV
rES5j6KMGFR00ERJOYbcM2bczMy/C6vC/r3aF8/n+/b56br5OnoqyMnJ7Sc3
rY3nQP3LQWczi8sRrkfyfMyULDX9hFQT2J9jCB4ssMPa5Pg7hdTtmGNaI7JS
OQTb980Fd6k07KlutJ4h8cZej7FnsVQPbFS2CN/PvYDO1eGW16gBKBdTCkqs
opDyq31YJDUUx89W94adTwBTpXDZX1Q2OOtdSr5O3sMKq78jCvzYWDJbLVLf
9T4aWL6D7VVsGG2yPP7z+X3oKRrlrjr7D6I0nBMTg3NQOZGxqrEhDu8jop5w
RnMx+2ucqU70bYQv8FDPbclDfGeQZdFkEj7Y82/Wri7Avv2pnE+fM1BqLfXW
tikB0U6blaaZCbtl53/u8ClBGF3F08kyE8knKpSdYktQ6O6rWczOxG4ezVC7
rQRqPltZF9ZnwYi/WXzR6zFeX2k9MDM4GybhbcuCQ57A+AFl5mKVHJh1n/rO
SiqF6hTzkJU2B5cOZ535dPsF9B1kA6+iuFiZv/yZ3+5XOPdhI+K/PQFREVce
nVOJhVyKQF7+BUTPPYM8rrxFsdiypnZLBezK59gKXGpQwbi7aL+EByO2tFug
UIuR37eqPzxZhSXXR37Mza+DwniuxiL9augLq0PGpfVYN3W42CmvBqZTBm1v
1PmoCTX5ULmiFu80483WLmuETszw+H1ZHWYVx1alOjZheEwoaFrTAEalPD3+
2EdkDJVWq13nw/QCt2l+bDPUtLKJnp5G2BWrp1OKWxB9vOhoit5HvJt/rfXz
61aMmuf2eF1uxuIafuZrSRsCjHncBa9aEJR+ImCDXAeEebyoet02ZO+DiYVh
J34wGhMNgtrxvirq8T0HAQy3KU8eLe1A0lgvjD2FsErTPfZooQD0h3WB4dZd
OKflulR0SAgXvlIStakLRhJn1eZdXRB/ajvHdBVhnvonFd73LmQoytJdRkVQ
epHI+e2OCG69+bGtV8XwNilt/cVWjO+Pdb9MaHUj90+3lOejYgytschbXtyN
kWFNjb44UmGtbcf2HhQ5WSmySSvePfQM6urBZWtWMrevBwk7KPNu+vdCt9Om
JZ3VC1qKYEacQh82rQ9lU437IAXduTy5D4e0a8fl+X34UQD/bWv7MVJ9TezH
7AfvYOVtzcZ+xCvRAxz1BnCg6EzuWu8BzBMUpSnwBiCf5oU/5AYxI5hJ23hq
EIGlzTG8tEHI3adzxHOHoFaSYMzYPAT/BM61uRVDyC9bdOSjaAjPDCNUKD7D
OJDCopqHDYNi4290RU2CAc9RRuQSCTpW1vEDyySY3eYx0fJGgvwk6PXQpdBw
12bJjkrhwllH0ZqUop+p7PFBQYYQViqzI0eGA3mmGbIHMjwc0EpUsyOg6Opu
k0YacZd1WLCbgNsz2sWT9gQ8HKX6eQ4EdHZyXm5wJLC4rCx/114C3AWpIbWk
kTcOVka7EXDyD+mcIPVad/vzrEAC5qWnVemkS0PnWytnEeiLdt5kRDq54eKc
5nsENOtnPB0nbZV2N2TlEvDVNLCrIo3ZW+iy8xGB1C9vs91Ip1Y4nmaVEQhc
FbwlgbSj/kaSIp+Asrm0fTbp47Axd34T+UP+y5V2UvZmV4P0FgIrbvlsySG1
zVzFtRAQmO9X12dF+vT8+7fMQQIahqCGksatNL3hICFwVTSL5kR6SnyHpksQ
sK7Zk7qUdLndCeHLb2TPSbvT5aRK8o0ZMWMECp8q/DttV9FmxuHvBKIZJjem
LWOkr14zQeDSG9GGaW/pqI5MTf3vf7ci2E8=
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1P8/0wkAx3FKl/Igcl2PKUUpJSItnVzeMX0zrht6qAgnKrvq8i1XRzVR
+a6ok+8hiWKdKbLifCvOdxOJYRs223zkwqFx6/G4H96P91/weup6/urgvUhB
QcFevq9v6y1sqxQdtcxYrzK5sEBAiaJ1sZ9ERqCM4xEiI7AzIym1mGSDVT4e
S77MEqA2df2ZRnJCeoXX5y+TBJy9pl/fJXnBd8c4VVVCoM/4FiWGFAB+o8nE
6W4CmauO3IwkhUHZYqh56jkBhnKxfgQpEZ9o9ImfzhI4dvxh0finHDwtTFZk
dI5BZYHhenBdEep6xuO8j49hE21MWB3FguVs7SptkRRBzeZI+lyGRrukKqsg
KVazNLiKihWYIVfW+K2U4gWP0tjyQxU8/ZzcrJ9IUEVPW3NcUgMnTkThDRsJ
JjfvXfHs/FuIW6n1aSNiLJopUF+zqQF3EhOOzIWKYbbg8cKxsBHsmr0Kdnpi
NIaRm+sMWpAjNanTqRvF+njxzJOxVuTGXlnOOTkK8XQ/t9OkHQy2fv6SWRFy
Rssb1GI7QLsays6LFEFN+zEhEHCwy1d8rJQkQrRPyelMvfewIGcw+54KMbWv
QHD2WheKN6Z7PDMVIsC0hvVddTdSb421RrBH0F9YE9Wm2wNSbQzr4+4RzNE5
KVuvfIR1dWkDkzmMbVZL50+X9+L3boGO5vZhHMzSPfN8NRfO/LVlZ1KGEKTt
vmHQtR+UiHtNaapDMJQcVemyH8C/sepaX0IE0FwxrlwzO4CCb2I7Rnr5UKpI
KdqYOojM8dyX96z4+IVc/mEZlQdVnQfVrxJ4KDjsmflmigdi8yEDH/4gJsVa
6sP3+fDOcIgaMB9EiePBxYk2AlQ93WjsFzyAa4fCM1jDAjCOFugWRfdDt8+2
Ozt8CDpUSW2JNhd7doclkkyHwVu7TUoL64XrupYZxY5huPCoPc1zPZhsiOFd
ZIwguM1wcdWBD0hScgtw0BMif/qlUW12FzS5JVmLaoRQm5gSVc13YkkIw8nc
VwSbGfOryQYcKDxxK+KtHIU9q5TaQ2+HX3JRzMqqUczmzZ5ov9yK19tuK2tc
EKO3+61/mUoTNGz9DEPVJDiWp0lj0OrRa9TacZktwc53zKhTxrVgpkNP4CaF
u8uj5KC9f+FkkZmG9rwUsiDKgRP3XuF6+ENGb/4YRgyNHGM6n+OZUDtFzY6A
egi5NnshC7fTwj24PxK4XxdYGcDKgpeDdFMhjcDETd3N8MnCWjabae8s78wz
wqSy/SEi41zqoj0JzAXS9vk/ysRZswefll8mYDs5F7onIRUbwr49tDSXQKDz
43EFrQTMfx+s2pVH4HWWi5OMcRcfpPz23AIC3PnpCInoDuKdi08ekHeo/3cU
PbssHgsGDv7hbALFd7fIhpjR6G2LS1/cQaD/Um65qf4NlN6cPtXRSeDwpf35
4ZMMJFq4b82Wd33essn8TfV1UB9tZ1lzCbQmlAdWVgTj1W9N9QwRAWEj/1qL
kT/uG+2Ko8ldILtH/9zy7iJ8ealOugSBSDeK0q6357DF7lx/5WcC0q1WMr0d
p6CkyMmJnyawbNn+M7IGVwyUWNA95O6EXPinvs/UEWx6trGJ3CVVwW7r9zsp
+ON/t8weVMbmlnha/gczkYdV
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt0Gs01HkcBnDXsik1aqtRkshuTJTSdXla2iTRcUsXSUVKkkoXYTeOsSqF
zrhshAqZaEa5bTUKTVQkZmTIZRiDMWbm102OLuy/c/bF93zePC+e52u8/5h7
gIaamtpe6n64JUDWXDXkZTeU4/NFlnLSTsvBIFRMX4m7ruW8BJUbVmSnZ5bQ
N8JKk2l9t38fnF+J7l+ne6Ij9MyiDS3H4e0/WnmV7g/9XtcI8b1odFn97XCZ
HgZ+fH5TSkgycn7eFneRHgv7RFF4mDIH0Tolv1ygs+AuGFGEjnNh7pgcfz+U
BXZpVLTwt2IImMeGOupYiDePiF9xrhimmoxCy9MpYGzMFTh8Kkbt91zLFkEq
SBbbhtN/D1M/ptoYJfwDy4qARFJZgvSucw5l41n4Hqn9cdWmCuzYeYP77n0u
At8JOzSfVYJ0eE65aZCHo3/+ubDzQyXifHUCPBzysKQovz1x4WOUHDhmUM7K
Q5odw+9ixGPohdgyI1bnI8riELfJ6gmexbTvmhR1Gxp0l0vSzVWwLqJNmq9z
B/t21AY6ZVVDdyLax3EBF2OnjGxp8/hIP+zty9jEBXtjfyBnKR+mLQw/WggX
AsvIIrsNfNixRQc6KrmYNexTtSaAjwfs1LIKy2IIp219xOLwofRQ8Jwbi1Gh
/UJtzO4ZvArS6k9Ou4/cPBcN0fZaLHZTyZ5eKsUgLa6pKeA5zjSuRfqnByCn
bRLkvg2YU0rrVld/gqpvroa0a69RLnFoeP1bDXQz1Hs7dzejJuj6vJ0KPhqS
/M0WPhZgxMx2+t2jdZBfjxy8TYTQGCucMW/xS1wVlrelmL3Bqgm/cg9OA4oK
VJnh61rRELuysdb8Nf44zzghthPBKGl4jK1qgteb4Dp9tzYMj4q73ywTIGa9
0c4Nzu3IlT96qXdFiMDJk3412f4Weoa3iVTagth6169OOzuQcLjsYI5pKwTG
AS8inDrxeUOh9NBfIuwb3Fa02aULYdb80tlP21B95KBuHboh5vAvNRu/hcL+
YJqZoxhfg1oylpzrgP+/4WeDF/fA4vfJ4wcfdUK1Ne20bXYPHG8aB96b042O
YJ3w1aa9OGO4d1GvjxhOXqXbvG/0gqHw0hW59GA4+061hqEEM6e/0+F/6cGe
8gH7/bkSaD3J4Jpk9sJ/V3a33KQPR1Y+av/JWYLliSQoltuHQqf9OY8/S2Bg
6mKjtU6KkWGDGQOpfZBE5dHjeVKUeThqsjZKkb+iVZHo3I+/NjOzSwekiHMu
qokR9MO4a0vbLWY/jjVm1pvvGMC61bEsuvUAjMvqJ57IB+Cz4PWYunAA11Jn
b/keNoiRl5clodGDaP1Y8Dx8qgzpWr5h7qYyKCsVkrMZMszsLrupwZehr+cW
x2jJELSjoj3XHh/CB/2Sl0H8IaixfbkSfTnm1iVZyLbLceIa97J+jRzxFUUz
d4/KUWkRr0MLGcbtKzHPM1OHQdtyghGjp8CJs8wZDxkKdC5tEobzFAi0iKy3
blagOAumUl8lVIeqD+8KVmIPdxXNcFyJBNFy1qi2CueZN6I776igdJu7y4Oj
wl2ZYYbeVoKHqReStV0I4q8z/bpdCb7OSuO+2kbg765czHEjcLoapkhxJ5jP
4xW7eBN8+JZTY7aD4GLi7tqE/QSRxS96nA4QHFr1z/sp4QS29oXSFMpFsbM2
T84neO+9bNoflONrIqeJCggcnhFtGpugXdknyC8ksMm5aNhFmeRdsmfTPSo3
2ZN9inLC3P0kk0fQeBorCig7mxOzNIUEwW51M2ZS/hs3ekD4hiCqNHC0h5K1
fu+SW20EygVD3ziUznmWpfbdBPNCkvydKR+effUieoiAV3gun0mZutQm0U1B
kKG+NNaT8rgk09OYEIhMn543ofx1a7C46hO1f2VmazWllnpLbtIoQWCz2CqZ
sqdsfZDfF6pXpk7BD3lBt6yWfSfoVc3GD9OMdEcmJqi//u9/I6oQ1g==
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtlH040wkAx4k7ytOkcizhFCVSXTd6Ub53VFzSnZdOPY12kkSK6q50FcvL
9cKR2+QakZckx5Lpyrx0ttR5KJr3l42Z2Wzz47I8dOx2z9Mf3+f79/f5Pp+P
Tchpv2MLdHR0fLT5v/cek7U9lx9wq7c2Ums0BPQ9VkSLyBSsnH8VenmOwJe5
WdmV5F1Ibtxp+u8sAe+Wrsc55ABQgvZQ5tQEAkOnazPIoTjE7dxPUhIY2PiL
Ryr5HE5ZpZhHdhPIM/02+QY5EbN/LN1u+JgA3bBy7XUyAzTzRll2OIGDh+6x
JyYLkS0fndfpGoeRhk71tGJjMTNaxyxoHHa+4zLeTQ5ePuT9Yz2hwvnX25A1
9QwSuVDqnaCCGcdEqKtbj+OpvAamrQpPxB7Nb3Y0wEf5IDOVp0RDRI7FISUf
7jptNYfDlVCv2WlcFvUSFUw72iNTJRbMlC6xsGuCUeW9uCu1CrhoaE/8y5tx
h3JVjxmpQHMi5XWjwxvkMZpVoysUsE5XzJSMt2JQ2N65qWEMimmRsGPTW4wU
XEkrjRpD4Ri3ifSrAC3OW3oSjcdAsiwmJJJ2OHsayt6x5Ug5URWWZ9sJlcrV
75a/HO+/KpWEx3XBXmruRFXIcG4zn/MZrxtl7ChzdZIMonL+zTabXoQ1lvtu
XCbDh4h21rqLfYg2DLj4Rc4oHL82mA/j9uN4h3GfqcMoPPNtjleYCeGx8IUm
vliK85ZHVg1RRTisDnOXrZVivfKAUZfPIIIcqTaeRSNYZjxhyJ8dRLCFYPdq
kxHo17PYq7OHsLzDdqAkXoJICrdnobcYPOMix+UDwyj9JiSv7r0Yc12z0Zud
h6FWrFgizRxGNStox8QtMar8PfUYuyRYO1moF9MzhDivpFyOVAKqpi3FZM0Q
bAb2dhckjSB3oVln6OlBbN+SyCBvloL/glpc7y4C1erNjK5ACuaPnu3hlQNQ
N6WKo+mjoO5fbD8z2Ycs/eBzfrYyaL4jXU9268UyYVX+Ar4Ml+YauVmJ3fjk
Mj1gW4wcMubUvg2MTuiUBLPFS8cgbPL7tIDTjjN32KlLtb+FkEgVBqy3qHW8
ZmhySgHX0a0PBBdaYbL3zPqrJCUkXkaUwI5m9Du1CmJrlAgxjRRluL7Co7uw
lQSrMP+z+i+LFh6C2C4mlvMqVPwwUvykuA7xSffo/Q/HsdKQSntWzEGZzJJF
2kcggd1p9czsPq7lJNGE+wnkVxuUsJ8XIdRPZVfuS+CdJjaMdaIIK2tqHvkE
Eti9wyXWj1uIG2mHG1NCCHiSWRNuwQUId/l9clEsge7cO9wl+XlYlbjcy+A+
AbmXQau9Rybmt15a3PVAy+1L2x5aBhM9quG390sJLCqxdkgYYiA9sDJoTwUB
q1v9uclxv0Hj4Hc2qYZAYVNd/bXqdPS3pd3VExAgpR2ZnjyYjKfJ00cFHQQk
HPrnD6cSwXA9sq5Ay7VXubjaJT0B3kUbOO5C7R7+C9eWxnhUX2j5my4nwOaV
xQiP/oRMJ+c0X60XAlgRUcyss4gRZwfYEAQ+mO10UjdHw37fSdHzKQLVtSOC
oBNh0NdtL0yfJpCx7XKdSSsNg1WuETStd/xv8+w2nPweNREFGzdpvSQoe2f3
Z9Qe3P7ord4+64tPe4+5/QfQYn3u
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxFzGk81IkDx3HXSpF7tx0adjJqk+TK0caXWJQud22FpZZGF5UrKq1Bjmpr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      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1P0/1AcAB3BPjeWVh2J2LuUqJVItT1mtTy11jdRcmse4TDGauOwVLdOV
p4VIl5TnEpU8xGnNcxyNKek8JXe4O+fcg2+tLi+3YfZ67YfP6/MPfD5vSuBp
2gkNNTU1t8X81y4nJL0tU0d3la7WVS4sENDaaxoxSrIDna0dGjtHwLYgO7eG
5AzDeierf1QEXJ8PVueRPHCZsid5TknAM2imMZMUBE3+ygJ9OQHelqS9aaQo
mKXG+EUMESg0Ppx4mRQP25ymALNqAkydmg2/klgIa/Za+1cIAS/vosq374px
9JIjLXpoGroLTD/qqkqo7PqrfenTsHCflrSlsEE//acvT6nA2RdOyP7wO/7o
ef38QqoCJmxDvrp6M5Kv77vf8oUCjwV7u3t2tkLPpmfyWb8craF5ZG85B1I3
k/CDF+RQrv9Kv/zHZ2Cplzhk2cqhMVtmQLboAjktavkvAhkcFuiPj1R0Y9Tr
4Y62GzJ0x9u96LDqgTV/Z2/2IRlWZ8hm70+/REzmb9Zx81LIZkb5/VtfobDV
LSmoWopiaX2X3hUuVNfInexjUuiZlRIiUR+MlikHa7SlSP2h9mThugF4yyyY
IewpfNxdJgqJG8Q5WR7P+rspRG3jsD9rG8K3Mz56ZJUEoxWclF7KMDRbOh1P
XpXg79C+nI3n3kAkcBaut5DAeo/2/Mn6Edz8Oyxxum4S1NuU4EcmfHTUVVWX
75nEWbOANeN+o2gXGvWEdYmxSX5Ud9BtDNQlzC0ph8VYof9Wh6MaA8c8oG13
2wS0mnMq1+aOQ25ibhjnNIEwu/rXn7oK0Ll/bkNErghl3wQWNn0UQDw7fIqs
EkIpMzUQZwlxNs81wMZXiNojVE2Wswg301fG+pYIEHcgoYAtFkGn6AmLrhwH
hecydCdhAhn2nMx5jONLx3gWaZsYffzGaDJjDH6rembVuWLss+WUZNJGoexK
E0QwJ8HrKJosS+EhW8s/irZOgrBP5v0sX77BCn7tbQ2OBM7M95bHdYexJJbp
4RQ5hQeMBs8nukNQu+9fKVguhctSetEl0wEwblWmLW+V4orlzvN9U1w0Wifr
GIbL0GLO0Ol62AtDF8ami3qLOzFe7U7X7MGIzUtuTIMckbYvniooXajKxzqR
vwIGx1UrXgW341ilg6HZvAL7DZ6OTea04EJCEXPkwTSWWdr3l0Y8RrnELEfv
IIEymvcZD/17SM5LoPMPEeiu5UV1V5UiiKawqHAnYOwkLHWglWJlQ0OVmyeB
ANbD/HFWCS6n+3akBhK4GzPAvkq6ixCHm++WxhDgUpOqvM1vY0280QHtEgIx
MRO5WtRszG8/v2zwHgHta6Y+sYk38FohfFVSRiDV3njXcHsWMjxrju1/ROCZ
1QBjt/N1LFjRziQ0EFhTLPZpQiZGetPzNbkE1E2eqs0FJuNJ4sz33H4C9rn8
jEh+Ilg7AjbeWfx1e1/ItgrvBLje3cz+mk+gILLpVtzhi6iLft7JnCLg+L5g
85LIaGTZ2Ke7L7rAPhVyLTzoJ0QKcj0oBIGc0yp+sCcDlgdPjbZ8IBA+LPvc
KDoEWup9xRkzBHzC6ppO+AZirHZHKH3RHWrSenn5z15oCL2zZeuiS3YV3Ob8
2AO48b9bGo0u2/15wbv+BWWydeU=
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt0Hs01AkDxnEibO7J2w7hJdJFEgpLnoREatclkma60Ka0LimptvUSIopK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      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1P0zFHgAx3GkoRN5KN3S6hQ9IT1IuR4+VNcWuY443EnGQ0Upkocazu0d
zkNitBUttaVkSUuIslLZtiF5loRd1mLX7voSMnXHnpu5Hz7z/gs+L1O/c66B
aioqKs7z+6+OgZLWF1L3PZUrtaaVSgL1fUahQooNmmidZ2NnCbbezsopo+yH
/eDZ3f98JXB61/U4l+IG+jWdztlpAo+AmZpMSgACfqa26coJ+qz/2pdGuQAH
RfeaiA8ErGVHElMo8eAYecZsekxA1yxbm0xhoOTxQ+s9QQSeXnc44xP34H2F
R553j0FLSfemmXDQxqDpmPuPwdxlTFKXWo5TNXc2P/yqQFSTHbKmnsLNjLHY
kKHA8nI9gapqLVqLoxeH71LgiWhfY/OuVyjkp3sGiuV4FZxr7CXn4Qc3bjXt
qhzTa3YvKQ55A2p0T6mBkxxqX4p0jc0bYJIRMXFEKYOt0vfJ0UeN4ItLbMaf
ytAYb9PE39CMhfc5LM9IGVZmyL6wx1qwNGr0Rq6lDLIZoaBzUxvsDM36KodH
cW+0ukHnSjtOhI9QVbJHoUN9QMTiDkhWt57TdBzF5aCKEyyz92hkrRwImZXi
s32R+FRcF9bVZxQk50txYQuv3LDuA7xie6u9XaQQPuKltpp+ROggy9BoXIK/
gzuY6y/1gG7Cb16WKoGFg8bciepeGHGJZsxaCWh3TU+WLhdAVy5lbqsYQRT1
+KoBbyHqilizO/aPwFLurtXl3A99NXvrbc3DMFgyrsn72g//AxLVoYPDUK9l
clbnDKBNrbzLiTeE0zbV3YucRPhsFWHgbDmEokN+rOefRUgRq1e5XxFjWmak
O3x9EIVB0dmCT4OoOEpbwNgvRsqhuCx9h0HEHUy4XT4sBjNFaLEuUwTTPscP
eQlDKGg9PbJQMIDvt8czKFuGQWeeeX1ZdwDeJs1fVNuH4e3r77+e1o/phjRR
KH0Ev5V01k3WCZCl7nPB1UwCYeRQz4RaHwwEFXfVeBJc89mYlGjbg4WxdDe7
MClCl252EVt0Q4XtwxHpjyLjanw9z6oL529y0vRfjUJb8/74nKwDNRZJmnpn
Zahlq2kJb7ZBz/G85R86cmS2VCXLvFrQa9XSfpErR21RzMxH5luU3IKZ2EeB
n+zHXr95wMcxjq0edU6BVVVtAytyXuL3hDv03sIx2BmXTtLfV6JYQmXqHCZg
2rOZdTfZSMpN8BX8SBA4p6w8ZstGgKvC/JELwWntkMSR1gKs4HJLnD0Idr38
tLVBswAp6b/yL/sRHChLKnwbkY9TttkT31wkmGznNtYczsOq+KUHNfIJTi6f
3l7Ym425HTHaXQUEcdVBqa+XZKNbMdiWX0RwpC5DWrs3CxkeZccOlBLUL+I/
cym4DuUG1/AELoGNVayfNOwqelvTby1oJ4icXc1unE1GVeKMf3snQWeerobo
eBIYO4+vz5v/9Zq3wu8qXibC6f7G8r0CgqmtvDBG/J94Fv2uni4lKNk51RWi
cwnXrbalu8y7UOx++9vwpkiEiXLcTAmBWXRS1GRaONYdPiN8MUXAfsjiNxgG
Q121417GDAHfP7usONMf/RU7g33n3QlxWaShbfwLuMF51pvmXUrzUMa5UR1x
43+3VjRVWhScD9rzLzEigBQ=
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtz3k01Isbx3HS7U4posUdWZLRRnK60d5HRilyhShCXUoZLQq3LGG6SIXU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      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Ps3FHgABXCiKLtC2ppaLNF6tWLtlF4378JoKUdOSKUHUkQPvZgMSSk5
s3lHSA2rUUZtpbJMKodKQ0Y7zTDGmKdv2iZbibXn7A/33H/g3o/l9v3BO6dp
aWnRpvJf++2UdTXLQ9Y8sTDQTE4S6HouSBBRXOEZYp104ivBz2UFJQ0UL7S6
swLHPxP4d/beKqVsgtW4gjKhIQiNHnuQR4nG7zZOQ8YqgrdOpz1zKMmgce0S
UvgE5XM3ZGZTGPCO9sp2v0VA12/48QyFiaKhU7foMQSbw66w341WIe03Mvz2
zQgMJunhvuZsHD2VlJi3cwQ2QSOy1rMcNFhR3Lsn1Dj83A0FH+6iJ8ZhekGR
GvM4xkJt7UdYV58gz/NW47bYs+PFqhbYL9n/a/s7FVpiSxeGqbioahOYB1Sq
oFm8enZd/BP0FfVQuyJVmPap1mihTTtmuIgn989TgToZdXvjjQ7cm79i5sHX
SnQwXJ+32b/AGXxkxOcrYZGr/MQaeYlHq6O3DgcroRwTCXuWvsLfOm4+c0yU
qFLcbzc8z0OiCF8M2hUwNLtGJJJuSJJdzXlpCpyLadxVbv0a8qE+vXo3BT6u
rZXsSe3F3MdidadMjmQXLue7Vj4am/Z+9S6UQ3SDe7bL8g0WU2+OWqyR40ts
d7Hd0b8wER7GMRTJ4OCuN7HrvgA8ucdsZZoMvhWWu2/OEyI0Q+geZyrDYbOt
VgPhIqy0TvWvuj4MR1WIQS+tH81afScYy4cxZ/Y7fe7nfjhd8bVddkcK3UfF
7EUlA2jWzk4fo0oR53q/b6a/GMEVXlnelUOoXb+9/OFHMZpnVet9M3MIGuUC
I+mlQVRL+bsvJUjQuNFXh+klweYxddvBPweRui6jjCOVoOer3Ya9poOwfOvH
r8wYgns9bTR1mxgrljGYFBcprpcvyrjIHEC4+YtP2jwp2Cx/qrS9H5r2HHEC
fRifuYxrmqciFOhGJgdbyxB/L9KLqyPEHGFjxTSuDIccnF+FOQsw/QR9k1ui
HEFlmw3em72BFiuSLTZRgGPLSI+Yy8eBInaOSYsCrScLk8se9+CBQ5a+8T4l
Rrflu73fwYOx3wHHU4YqSLOfmgiNuiBY8pKX0qRCQWlB7ipBB+ovw1oSqQYt
wL8i884TRLCpxmZTu6RddqaaHWpBWsYVuqBmBC8ZAaoSvbuok5kVGwYQ/LNr
2Oq8qgZZpRlRwkCCSnsPS9v0GkQHq21uBBEwx6sL2ZQafN/UVE8LJTBrth/N
9GEh+8KWtnPbCaQ24XqhZdewh1o4OiuFQKEJdDlGq4IVw3SdXjXB1X0Ui5xl
xZhYfvzb3usEpkb8pPlRRehTD76qriWwqHX3OZlViNzQhgifmwTxszxD+vj5
mLQPTspoImCFUDkdh5kQdF24rMMj2G1at88v4iz+yBzbwesh4AQ921jHOgPm
yq12lVO/Ts+7+ICrOQ3/qz9xPIQEjiUHtY1zGLh3pPMZXU6g0YvQrEo4hktL
frkQNOWC6GJp7HrdI0gUl2yyJARrjeIOPMxPhm3AXlHzB4IZKfTx1pQ46Gp3
V+WOEcQoFz37oTQa/Y0rY6Om3Hk+oJ9VcnILmmIrnZZOuXQukLXame6P/P/d
8ji+wbGkM3bNv3DRc/c=
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxFz3k81AkDx3HXFpFCsRRSpDSktiW1+dpGa5MOjFRyhZRHiJ5yVCLT4Qi7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      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Gs01AkYBnA0NcpdS43CTmi7rm6r2tKjtFIi16U2koQdW4REm0WMSKFW
IoRkpImRS0c10pHKKrcZGXbGDGOamIu/juRoY9aesx/e83x9z3nO86MGhLmf
1FBTU3Oeu//ywMmR7uejXruCzbUmVSoCJHuTcBFlCwY6XibFzRDYXJRbUEvZ
i6ljVte+fiHg1M6rKaR4wtAt20I1ScA7cKrxOiUQNBljobGCwID1JfurlChw
d8vH0/oIFBsdSrlMSQY91JecVEMgUbP2uzRKNp6M95Qk0Qj4HC5hjX+8i0Vu
pa7LRGPQUiUe3WfGgsVZwrjy9Bis3MZGXqTXYUV/nq6L7hjOdWxH7qfHkDBK
jpfXKLGkzkCort6EVs7WPabBSjwS27/t3NmMEPZjbxMzJZpphcsOK1pw5PqM
+MaAApMrbfUqT73GRBrfKpChgMY0U3+ZVRvkZQtmCk8rYKPyf+RR9Rbhzknu
sFXgbfKWjldrOrExz7GLpquAeZZ8umKsC1V/nF96XCCHfEokfLeBgwT9iS+Z
lXLclT1t083g4nVUrF5rrBy6puWERNKDnGfsVzo/yXHl1/qgYsteKLwOacYa
yPHZjikJieeh3WcmbVWvDFGbWuqMX/TBY72L0/QtGURVLend1L8x0Mg0++wl
wz+0nvzV5/kINx9cmaUtw9rd5NmgpwJEV3/7IKx5FPvuUIMfLhFir6O6HkJH
cc702IqhoyLY2MZc7jUcxTqFlxbPeRCOoYIM7foRLNYb12z5MojteqcsGxxG
QGrKZ1kUDMH6awqVyvuA0C1P+xc6iWGUcf0l1fMDmPsDip99FiNMapxX0yrF
pNxEX5ozDIVGE/3ETinqPfbNy94rwdCR+KKg3PeId6QX1UklGE6xqi+ckIA6
cKCvlP4eJ6uF5HQHCX7cmpxN2SSF8cRFhXXcMI6adU6rc6Xod+WEztaKMdl2
VRye+AEknZDfmW1DyCX5RblbjsDcIWKdYGgQi4X1dzRaRlDk815NNSDC/LhE
z+1nRsG5Y1s2v3IAahV+LLGhDEbkmxvNEviIuMW6atgsg2nQ6qUts31oXJuq
aXBajs36jvk43guDAxHrLs71HMBLan34hgvB+i5uLFsBBVNAiuzpQvVtWEr8
lIjcYRiQ3f4GviwbA9NZJfTOkKjBz18igV6SKLg/hgWRPot2lTeicsQ0X/cg
gfsxrp1qmtVILaT7C10ItGW61m37k4VAd6VVlRsBmjZn0sOYheVsdrWzNwGu
p1Rus7wKlzN/eXUlgIAf59LGqpUPEGKT93FRLIH26OXpfjb3sCL5G0cyg0CB
xf6KCrtizG67oMO7R8BfuzuZnVCEfuUwh8EkYK61hqyMv40s71pfh4cEfJVa
/NK4AqjWuEfS2QQ6GNd4wdG5EHRn3p7HJaAvixna7ZuFhpSpE9x3BFrtmYHb
ajKQvePY6tK5XZtsJhWer7gCp7Lv6/YI5/51UWWU56TiSUz7X4mjBBjlDWUl
oQnIWf9DptucC6ca13pebLqAM+ICTypBoPtGajyfEYNVB38TPf9EwIjPaOBH
hIOk3nM3a4qAvbkdeT4rBIP1O2j+c+7YnfuZR4/2B5tWar1hzqWpsLO2kTGu
uPm/W7QlRUxHnfBd/wLDsnBR
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl02k41AsbBnChQzqUpUSlo1THmpyilO5CUchrS0qyVaIsR69KpxjbSUg6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      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtlHk0FHgAx40UZSPH1o6oZcMWSUIx8a1IOaZdUo4VMqNaOqWXDo8p0umY
vFIjudaGmJwV2ohXu54jR2tsGowxjTn8ZI3ZztnZ9/aP7/u+7//fz8c86khA
tKaGhgZdnf/aJ1rc0zyxy71uua5CpSLQ8jA5Okx1hP+i2YzEzwTr7ubk1lA9
EajNb/n0gcC3c6D6DjUQuaYuIpWCIIipfMKmMjHmHmxIlRG8WZPmcY0aD3H9
qNYNHkH+1z9cuExNQUJS9lh1NQFLp8b6EjUbvN2sPMQSBIcUcKfeFWMqcb+V
nWASuipW2LZlXGywoQXhxCQs/SfFrVdqUSUs9TtCncTJLhfkzDwGs+VljKhV
jiW1BnwK5SkiNs4P/yZJjnqBR0f3xmdgh04bHXaX41nMnaUhsjbMXZu62URb
DoWVm37FoRdYV/3E2X9QBs335YuWWrajI6rn5O37MjirIut3VnbA7eO86B8v
yNCR4tj1fFU3sj5rNlAYMizPlL4vnXyJ/usJY9buMkiVw/xX9r3QmKdMppnK
UCxpbNdL74OmNC+CopRCz+xXIhT2w4FmW2jcI8XVn+v25a/4E/88VrRWl0sx
u6lceCBpAF6ZYZctkqWId2irXdzKA+14EePtTimGK9uu9Jj/hUr7DSFey6X4
GNPPWXn6NaasBPELRBLYbNb+sq9xCFa2Pi7KMgm2FZrvr1rCRx23uHOaIcFJ
swiL0bBhuOZetGOYSGAr26U7QB8BfY9fZGf7BIz0p3TaPozAqTYqPSR2AlpP
OdzvckfBzgoso8yfQKxj4+B8XwHoGhXprOtilHtH5f82K8D4i1BXL2MxFFKT
RaIbYzAs8pxxY79F3c5tc7I9hWCcORCpUoqQtD31bq1IvXv/tuoMFcH8jQ+v
KHUcvufTpjNrxuG6PiWb6iCCvZ63ftqkEGHLut9T+kS4aqMXC2shFO3XBEdZ
b5HlffjjIbcx5GiFxwesEMO7p+Fmor8ARvy6Qs02MWaeU8a6gkcxN5EV6HJs
AjSWZ1KB8wg0SsO5AkMJPOWFJNiaj7jb3GuGzyRodIr8qvTcazyxuahjcFiK
nFsl6czHPBj4xNme05PBxNTLdfP0Kwytftl3qkkGD+0GpqihFw/ysEIYLoeF
cc5u3sJu7OE6G5h9Uf8qNsaofu/vSE4tYA2VTYJhuN7BktuMCrEZR8+PwCXz
IVt3aTUu3kmN5O8gKJVryPn9VWAGyC0r/QmYDuu25qdXwbSp6QE9iEDb/KBA
RqnC5Yyfnl+NIuDkcqSh3VwccL71bsEpgrizn4LYEeWwSDHerl1C8MJzv/s9
ZiG+bDi7cOAegbQlcbilrwCD8rHeknKCmvS0+/VbCpAZVLPHq4rAzmnrg7Xf
5kO1KuB4ahOBf9Zr+mA1B0M9GXlz+gjojxZbjl5i49EFJaPvFUH43fVPjzOy
kE2LWFmk5trq/ILhxo2Z8P3FrnYLn6Brr9Ysb+gKGhI6/2BNECTM6ERzcs/h
xmqnDH+1F9zoSwwW+ybjmCA30JyouZfvkCjencH3fgeHm2cIlMeaZ+eWxEGL
0l+cqSQYb1pZePNTLEbqaDGRau+cfihKby+LQlNM0Rp7tZfGhc7Xt1cE4Ob/
3so3P31C3zHO/V9RcXDV
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Hk41PsXB3BaXZWoSZHIVlfZ6pZQeruWKOreREIkW0mkuEVlK9yyx6SR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      "]]}}},
  AspectRatio->1,
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameLabel->{
    FormBox["\"X(CO2)\"", TraditionalForm], 
    FormBox["\"activity\"", TraditionalForm]},
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.42270817225*^9, 3.422768856046875*^9, 3.46096663540625*^9, 
   3.4857515764267387`*^9, 3.4857517377868805`*^9, {3.4857520239117036`*^9, 
   3.485752046614683*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Example", " ", "13"}], ":", " ", 
       RowBox[{
        RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
        "ActivityB", "-", " ", 
        RowBox[{
        "to", " ", "calculate", " ", "activities", " ", "in", " ", "H2O"}], 
        "-", 
        RowBox[{"CO2", " ", "fluids", " ", "at", " ", "P", " ", "and", " ", 
         RowBox[{"T", ".", "\[IndentingNewLine]", "This"}], " ", "example", 
         " ", "uses", " ", "the", " ", "Powell"}]}]}], " ", "&"}], " ", 
     "Holland", " ", 
     RowBox[{"(", "1985", ")"}], " ", "model"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"which", " ", "is", " ", "a", " ", "Margules"}], "-", 
       RowBox[{"fit", " ", "to", " ", "Kerrick"}]}], " ", "&"}], " ", 
     "Jakobs", " ", 
     RowBox[{"(", "1981", ")"}]}], ",", " ", 
    RowBox[{
     RowBox[{
     "and", " ", "compares", " ", "the", " ", "results", " ", "with", " ", 
      "the", " ", "example", " ", "before", " ", "for", " ", "P"}], " ", "=", 
     " ", 
     RowBox[{"10", " ", "kbar"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"p", " ", "=", " ", "10000"}], ";", " ", 
    RowBox[{"t", " ", "=", " ", 
     RowBox[{"500", "+", "273.15"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"FluidActivity", ",", 
      RowBox[{"FluidActivityModel", "\[Rule]", "PowellHolland85"}], ",", 
      RowBox[{"FluidSystem", "\[Rule]", "H2OCO2"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p1", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"p", ",", "t", ",", "h2o", ",", 
          RowBox[{"1", "-", "x"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p2", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"p", ",", "t", ",", "co2", ",", "x"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plot2", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"p1", ",", "p2", ",", "p10a", ",", "p10b", ",", 
      RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<X(CO2)\>\"", ",", "\"\<activity\>\""}], "}"}]}]}], 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.422708185359375*^9, 3.422708196015625*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1GtUzAkcxvFuTqmVKcRI2tSsCCUhwiPjiIhtygkpY5BmYlPaE5bVrGJ0
2Vp1FAqp7bo1qMEq20VbLl1NTLPVlGma5v4vxzQq1c6esy9+53n9e/H9ODAi
aSeMDAwM/PT33/qekHXUyvdvybW30E5PEzChLjzTR/ZA7EnPbZcmCay5l5Vd
Qd4OV2p40sQ4gd0tgsc55EBoaDtIE1oCQcd1L26Qj+Oc0Fs4Q0Wg1/UaNYUc
g6pBobVvF4H78/ZdTSTH4+hkXVziIwJss4ql18kZsOSdyPwQRuDAwVzu8Eg+
Ft3tua1o18Bimn3YZzEXNeNZA5k0DSj+GtnLpEokrigc9xGrEdu6AVmf/0Ra
lOHQzBg15ldaiQwNa3CAfaa1z0aNJ2Jqc9umekysFjf7VKlQz8qxPahqwMUF
76NKmCpov9s8u+x0E0aoTHutowpGY6UkW8obnArXegeIlFg3TX8SUN6MeOeI
3rFcJZrjPVobl7eB822dF42lhH2acqxY047PRha5SjcllLo+0Xu3d1A1JAt3
TSqQr6h6Y/krHyQezzi6UQFLu0JCIumEZO/RlLo0BZKZvLD7Th+gJaXsGw5R
YHRrqST8sgAhcg3VgqJAjHtDpc3LLrh/mpVKV8vRV96Q1OHwD0zqSqa3lskx
weq8s+xCNzj1CyYimHK4eJtOhVX14O01m4xeJzl8HjicfDRfhEsLWrub+DLE
2h1Z8vFwH+TkX4za4mRYodpvIfDrR3yyMLp5qQxzZg+bNYz3YzgolMJ7MQST
mjtcx+yPeOZR81jy/RAiPKqEM3eL8XrXq5/826Qo3cW4/9eoGK7Da1exqFJo
lQtJ0psDKHJwMu+oHAQvwMc4Y7sEaLoe5/bNIC7vTLhXKZWARl+eN0WXwKHX
tysvYRBXGAXUp6UD2Lg+PoPsLkVSq3tEpECMw4vbxgz5Uhhv3u7KMBJD+yZF
fIY9hPZg48jX5h+RZRIaQ3OSwU7m+Ik/px9zRLwHRg0yPJ7wThigiDDjEjtw
Q5Qcj3qO6qSCbhgUh3LF1grYFXFzPdOFiL7NTbGuV4D81PP6oakPeOHCMbP6
QYmxL1+iHIM6YeUbveIXSxWSox271jR0oGdlO/98tQqr5Y1Px2pb8PAunCSh
aujKyhUFq18hhLvOym5KDeediy7GZtcjLiGX3VOigc2oRLJR9AxlMrs7lnsI
GJsGZ7kcKAEnJ4Eu2kuAXLKG70IU4zhNTSn3JzBG+kpyvlqMRdXVD/2CCCge
/F03t7IIianBjckMfUfBg661swsRvu7WiPl5Ak2jm0yZjXlYEj93p2kBgdLu
dO88xm1MeV6cJSgi8GR03lRb6i0I1QPvCkoJnLWmZ+iqs5AWVBGyQ99ht0F6
yfr5mZheTjubUE1gYIbA5Oe36ejpSL1rzCdQ5+1+JTIsEc+u6o7x3xP4jeM8
sqGWgwyvI8vy9F1P2veOfyVfw+7fV1VuExGoWBaYc7rlCp6fa3nNlhMozpzL
+XryAm6uXJvqr3fhhnkAi2IbiyhxdqADQWCWZvjHba1n4bznVF/tZ/2/DC8z
XjgLJoad+Wk6Ao5+xZw/Wo+hn+fFouvdifFT5S9mHkI1K8/VTe/S0lu2qeeY
vsj8363cQuHGT8+ZW/4FOSt/lQ==
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxFzXk81AkDx3E01RQpVz1DkqJWWbqQ7fj2IEeuxZQSQ9KlIqlIqx6tQQaV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      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Ps3FHgABXCiKLtC2ppaLNF6tWLtlF4378JoKUdOSKUHUkQPvZgMSSk5
s3lHSA2rUUZtpbJMKodKQ0Y7zTDGmKdv2iZbibXn7A/33H/g3o/l9v3BO6dp
aWnRpvJf++2UdTXLQ9Y8sTDQTE4S6HouSBBRXOEZYp104ivBz2UFJQ0UL7S6
swLHPxP4d/beKqVsgtW4gjKhIQiNHnuQR4nG7zZOQ8YqgrdOpz1zKMmgce0S
UvgE5XM3ZGZTGPCO9sp2v0VA12/48QyFiaKhU7foMQSbw66w341WIe03Mvz2
zQgMJunhvuZsHD2VlJi3cwQ2QSOy1rMcNFhR3Lsn1Dj83A0FH+6iJ8ZhekGR
GvM4xkJt7UdYV58gz/NW47bYs+PFqhbYL9n/a/s7FVpiSxeGqbioahOYB1Sq
oFm8enZd/BP0FfVQuyJVmPap1mihTTtmuIgn989TgToZdXvjjQ7cm79i5sHX
SnQwXJ+32b/AGXxkxOcrYZGr/MQaeYlHq6O3DgcroRwTCXuWvsLfOm4+c0yU
qFLcbzc8z0OiCF8M2hUwNLtGJJJuSJJdzXlpCpyLadxVbv0a8qE+vXo3BT6u
rZXsSe3F3MdidadMjmQXLue7Vj4am/Z+9S6UQ3SDe7bL8g0WU2+OWqyR40ts
d7Hd0b8wER7GMRTJ4OCuN7HrvgA8ucdsZZoMvhWWu2/OEyI0Q+geZyrDYbOt
VgPhIqy0TvWvuj4MR1WIQS+tH81afScYy4cxZ/Y7fe7nfjhd8bVddkcK3UfF
7EUlA2jWzk4fo0oR53q/b6a/GMEVXlnelUOoXb+9/OFHMZpnVet9M3MIGuUC
I+mlQVRL+bsvJUjQuNFXh+klweYxddvBPweRui6jjCOVoOer3Ya9poOwfOvH
r8wYgns9bTR1mxgrljGYFBcprpcvyrjIHEC4+YtP2jwp2Cx/qrS9H5r2HHEC
fRifuYxrmqciFOhGJgdbyxB/L9KLqyPEHGFjxTSuDIccnF+FOQsw/QR9k1ui
HEFlmw3em72BFiuSLTZRgGPLSI+Yy8eBInaOSYsCrScLk8se9+CBQ5a+8T4l
Rrflu73fwYOx3wHHU4YqSLOfmgiNuiBY8pKX0qRCQWlB7ipBB+ovw1oSqQYt
wL8i884TRLCpxmZTu6RddqaaHWpBWsYVuqBmBC8ZAaoSvbuok5kVGwYQ/LNr
2Oq8qgZZpRlRwkCCSnsPS9v0GkQHq21uBBEwx6sL2ZQafN/UVE8LJTBrth/N
9GEh+8KWtnPbCaQ24XqhZdewh1o4OiuFQKEJdDlGq4IVw3SdXjXB1X0Ui5xl
xZhYfvzb3usEpkb8pPlRRehTD76qriWwqHX3OZlViNzQhgifmwTxszxD+vj5
mLQPTspoImCFUDkdh5kQdF24rMMj2G1at88v4iz+yBzbwesh4AQ921jHOgPm
yq12lVO/Ts+7+ICrOQ3/qz9xPIQEjiUHtY1zGLh3pPMZXU6g0YvQrEo4hktL
frkQNOWC6GJp7HrdI0gUl2yyJARrjeIOPMxPhm3AXlHzB4IZKfTx1pQ46Gp3
V+WOEcQoFz37oTQa/Y0rY6Om3Hk+oJ9VcnILmmIrnZZOuXQukLXame6P/P/d
8ji+wbGkM3bNv3DRc/c=
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxFz3k81AkDx3HXFpFCsRRSpDSktiW1+dpGa5MOjFRyhZRHiJ5yVCLT4Qi7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      "]]}}},
  AspectRatio->1,
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameLabel->{
    FormBox["\"X(CO2)\"", TraditionalForm], 
    FormBox["\"activity\"", TraditionalForm]},
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.422708197109375*^9, 3.42276886278125*^9, 3.460966643390625*^9, 
   3.4857515765673647`*^9, 3.4857517413650055`*^9, {3.4857520240835776`*^9, 
   3.485752048364672*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "14"}], ":", " ", 
    RowBox[{
     RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
     "ActivityB", "-", " ", 
     RowBox[{
     "to", " ", "calculate", " ", "activities", " ", "in", " ", "H2O"}], "-", 
     RowBox[{
     "H2", " ", "fluids", " ", "at", " ", "P", " ", "and", " ", "T"}]}]}], 
   " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"p", " ", "=", " ", "5000"}], ";", " ", 
    RowBox[{"t", " ", "=", " ", 
     RowBox[{"500", "+", "273.15"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"FluidActivity", ",", 
      RowBox[{"FluidSystem", "\[Rule]", "H2OH2"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p1", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"p", ",", "t", ",", "h2o", ",", 
          RowBox[{"1", "-", "x"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p2", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ActivityB", "[", 
         RowBox[{"p", ",", "t", ",", "h2", ",", "x"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plot1", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"p1", ",", "p2", ",", 
      RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<X(H2)\>\"", ",", "\"\<activity\>\""}], "}"}]}]}], 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.42270820528125*^9, 3.422708215125*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw1lmk41Asbxu1EyVIYcoSIpJwUabtzOApFlnKSLSWSsmRJiRRRKuotCQeV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      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtxX1cy3kAB/BK9HSX0tFrdfEadSdhw0gXPlEpFFYx7iIP5WFHRM5z2dXS
oXJuUSnmYZ6icS2hyKsnrlf0sNL0sNqs5/LlbmuX0u7387o/3q83c8ueoAgT
IyOjQAr98oiumufdaxaV7CqPiDJZu8jU22FvK4MD6f7O7UfZHMy5nJaZy/BB
gsTpgC/bByteNfyZxQhBKZd5w5EdAl64/uk5RjgkTXH+3axwtLBOeicxorHo
pY0hlRUN8fhVCacY8Tg64e3aoZnxEJjnfv8bQ4Rf+HdcFDNEWLf+ivTDx+v4
ZBHLfWkqgZVBEOo3UYq6Q2Ma97hL4cJ931VyWga31B0xzzJkOPjaA2naxyib
u7Xs5OgnsJfZKo2Ni+BT66jytivCQ7V3ZdWCYjgXmE2KXFqMYn6W4/q+UshZ
YzSLB0qh+27h2Hu7X6Bo3XZB/sEXMBnMtnF0qcDfxxxaXFkVmGfY9DA4pxIR
p9PyAx9VojKe87p8WhXSgiS8dE4VJp3tHbz9vhrsu+5TDvxTjV59q7KeXYtL
LbNCY+bW4npPQYV1shwvHS0szpyTw9rpJtFo6rA/kblsTncdzuzM2yZ2fgP9
H1fNn099gwGvbM2O2AYIV+cKguMaED27VDahRIHI/Ii1r8sVaM0pPV3DbISo
3Wt4tUsjhvh1F12PNOHhj3Enoo43wW2x2ci2gmaEHNa7HX3WDL+rzO0P7JVI
/bzKItlBiYNOYZNVoa0YLOPlnwprxfS+NVYNgW1oiLHn2q1qg93YD+aln9rA
8/03vGOoDaZFF6VTMlWYH2CZMTNLhZ85BW8tVqhxLghew9TZy7aInw2okW+i
I+l6NXS9DjYd59+hbEBXcvfCO+QF+40S+WiwYDx3t6+vBrH+wsuyDg3CMj1n
B3dqwGxZrrgmbIf/1KYP7IR2/OAeL2LM7kBmzW2FiDp0YtWgsbwDhKWV7qbW
VSSp9wo60e5T31dJnWa6MTrIuQs8dcawmNpOmXfVpLQLjVrxkA/16OOCEI+o
bsiGPCR7qI1ub5Sqx/XggM1elbVdD/ZlSJPGFfdg5I5kmEP91C3R3DayFznj
VPZu1LbL903/1boPm83KYlKpm2dUyw8X9uGRNszoJPX9S3DWbOzHwp2eN/uo
N0jn2TqN9EP8QGA8mfqE8Iqg+c571FgOZyup73U5XbQOIOgcyOKMpU7MEm5S
riTwsPLS0YcH9bvkcAn843R59N8WFt4P5BGUpGe4r6Q+lfJT+ZktBJELX3km
Ue+Yl/7R8jCBcYDcz4p6cvw3/mY3CPjK9ZH0I/OPfd1wi8BzzLZZ9G/739Xe
yCZYwhdq6c/ycjcsfUBwQvX5CL1hWtB+YSGBml+fSN9ck3JplJzgfLXTLfpH
Cfqt8nqCbOcNu+hFnmGu1xQExWIpm36FZKZsiZIg9qvkx/RPDr36S9BNYJTM
rqQ/P2NuCrePQGEw/50+Sp0ZwiQEuSnaNfRTA3a1PtcS3DId3UZvalx3/aye
wLLTVULflufJ3/SJ4IJ685cL+ddY7M8E7bq7X74wyUpnMBDc/P//AFEie7w=

      "]]}}},
  AspectRatio->1,
  Axes->True,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameLabel->{
    FormBox["\"X(H2)\"", TraditionalForm], 
    FormBox["\"activity\"", TraditionalForm]},
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.42270821796875*^9, 3.422768868578125*^9, 3.460966646046875*^9, 
   3.4857515771611185`*^9, 3.4857517461306305`*^9, {3.4857520253804445`*^9, 
   3.485752048989668*^9}}]
}, Open  ]]
},
WindowSize->{1016, 702},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 3043, 74, 312, "Input"],
Cell[CellGroupData[{
Cell[3613, 98, 1852, 41, 172, "Input"],
Cell[5468, 141, 584, 9, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6089, 155, 1792, 41, 152, "Input"],
Cell[7884, 198, 344, 7, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8265, 210, 1443, 32, 112, "Input"],
Cell[9711, 244, 329, 7, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10077, 256, 1969, 50, 132, "Input"],
Cell[12049, 308, 322, 7, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12408, 320, 1502, 34, 112, "Input"],
Cell[13913, 356, 322, 7, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14272, 368, 1071, 26, 92, "Input"],
Cell[CellGroupData[{
Cell[15368, 398, 614, 12, 23, "Print"],
Cell[15985, 412, 650, 14, 23, "Print"],
Cell[16638, 428, 299, 4, 23, "Print"],
Cell[16940, 434, 502, 10, 23, "Print"],
Cell[17445, 446, 641, 13, 23, "Print"],
Cell[18089, 461, 756, 17, 23, "Print"],
Cell[18848, 480, 817, 18, 23, "Print"],
Cell[19668, 500, 342, 5, 23, "Print"],
Cell[20013, 507, 10950, 295, 189, "Print"],
Cell[30966, 804, 636, 15, 23, "Print"],
Cell[31605, 821, 639, 13, 23, "Print"],
Cell[32247, 836, 297, 4, 23, "Print"],
Cell[32547, 842, 498, 10, 23, "Print"],
Cell[33048, 854, 639, 13, 23, "Print"],
Cell[33690, 869, 756, 17, 23, "Print"],
Cell[34449, 888, 817, 18, 23, "Print"],
Cell[35269, 908, 342, 5, 23, "Print"],
Cell[35614, 915, 10962, 297, 189, "Print"],
Cell[46579, 1214, 638, 15, 23, "Print"],
Cell[47220, 1231, 641, 13, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47910, 1250, 7254, 189, 532, "Input"],
Cell[55167, 1441, 28579, 479, 236, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[83783, 1925, 2323, 57, 232, "Input"],
Cell[86109, 1984, 521, 11, 23, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[86667, 2000, 5702, 144, 372, "Input"],
Cell[CellGroupData[{
Cell[92394, 2148, 679, 14, 23, "Print"],
Cell[93076, 2164, 494, 9, 43, "Print"],
Cell[93573, 2175, 786, 14, 23, "Print"],
Cell[94362, 2191, 712, 14, 23, "Print"],
Cell[95077, 2207, 784, 14, 23, "Print"],
Cell[95864, 2223, 710, 14, 23, "Print"],
Cell[96577, 2239, 784, 14, 23, "Print"],
Cell[97364, 2255, 713, 14, 23, "Print"],
Cell[98080, 2271, 782, 14, 23, "Print"],
Cell[98865, 2287, 713, 14, 23, "Print"],
Cell[99581, 2303, 782, 14, 23, "Print"],
Cell[100366, 2319, 707, 14, 23, "Print"],
Cell[101076, 2335, 784, 14, 23, "Print"],
Cell[101863, 2351, 710, 14, 23, "Print"],
Cell[102576, 2367, 782, 14, 23, "Print"],
Cell[103361, 2383, 710, 14, 23, "Print"],
Cell[104074, 2399, 784, 14, 23, "Print"],
Cell[104861, 2415, 707, 14, 23, "Print"],
Cell[105571, 2431, 784, 14, 23, "Print"],
Cell[106358, 2447, 710, 14, 23, "Print"],
Cell[107071, 2463, 784, 14, 23, "Print"],
Cell[107858, 2479, 707, 14, 23, "Print"],
Cell[108568, 2495, 784, 14, 23, "Print"],
Cell[109355, 2511, 713, 14, 23, "Print"],
Cell[110071, 2527, 782, 14, 23, "Print"],
Cell[110856, 2543, 707, 14, 23, "Print"],
Cell[111566, 2559, 782, 14, 23, "Print"],
Cell[112351, 2575, 713, 14, 23, "Print"],
Cell[113067, 2591, 786, 14, 23, "Print"],
Cell[113856, 2607, 712, 14, 23, "Print"],
Cell[114571, 2623, 786, 14, 23, "Print"],
Cell[115360, 2639, 712, 14, 23, "Print"],
Cell[116075, 2655, 784, 14, 23, "Print"],
Cell[116862, 2671, 712, 14, 23, "Print"],
Cell[117577, 2687, 782, 14, 23, "Print"],
Cell[118362, 2703, 710, 14, 23, "Print"],
Cell[119075, 2719, 784, 14, 23, "Print"],
Cell[119862, 2735, 715, 14, 23, "Print"],
Cell[120580, 2751, 786, 14, 23, "Print"],
Cell[121369, 2767, 711, 14, 23, "Print"],
Cell[122083, 2783, 786, 14, 23, "Print"],
Cell[122872, 2799, 712, 14, 23, "Print"],
Cell[123587, 2815, 782, 14, 23, "Print"],
Cell[124372, 2831, 712, 14, 23, "Print"],
Cell[125087, 2847, 784, 14, 23, "Print"],
Cell[125874, 2863, 710, 14, 23, "Print"],
Cell[126587, 2879, 782, 14, 23, "Print"],
Cell[127372, 2895, 713, 14, 23, "Print"],
Cell[128088, 2911, 784, 14, 23, "Print"],
Cell[128875, 2927, 710, 14, 23, "Print"],
Cell[129588, 2943, 784, 14, 23, "Print"],
Cell[130375, 2959, 712, 14, 23, "Print"],
Cell[131090, 2975, 786, 14, 23, "Print"],
Cell[131879, 2991, 708, 14, 23, "Print"],
Cell[132590, 3007, 784, 14, 23, "Print"],
Cell[133377, 3023, 715, 14, 23, "Print"],
Cell[134095, 3039, 783, 14, 23, "Print"],
Cell[134881, 3055, 715, 14, 23, "Print"],
Cell[135599, 3071, 779, 14, 23, "Print"],
Cell[136381, 3087, 710, 14, 23, "Print"],
Cell[137094, 3103, 783, 14, 23, "Print"],
Cell[137880, 3119, 714, 14, 23, "Print"],
Cell[138597, 3135, 782, 14, 23, "Print"],
Cell[139382, 3151, 712, 14, 23, "Print"],
Cell[140097, 3167, 784, 14, 23, "Print"],
Cell[140884, 3183, 717, 14, 23, "Print"],
Cell[141604, 3199, 786, 14, 23, "Print"],
Cell[142393, 3215, 710, 14, 23, "Print"],
Cell[143106, 3231, 784, 14, 23, "Print"],
Cell[143893, 3247, 715, 14, 23, "Print"],
Cell[144611, 3263, 784, 14, 23, "Print"],
Cell[145398, 3279, 712, 14, 23, "Print"],
Cell[146113, 3295, 784, 14, 23, "Print"],
Cell[146900, 3311, 707, 14, 23, "Print"],
Cell[147610, 3327, 784, 14, 23, "Print"],
Cell[148397, 3343, 712, 14, 23, "Print"],
Cell[149112, 3359, 784, 14, 23, "Print"],
Cell[149899, 3375, 717, 14, 23, "Print"],
Cell[150619, 3391, 784, 14, 23, "Print"],
Cell[151406, 3407, 712, 14, 23, "Print"],
Cell[152121, 3423, 784, 14, 23, "Print"],
Cell[152908, 3439, 710, 14, 23, "Print"],
Cell[153621, 3455, 784, 14, 23, "Print"],
Cell[154408, 3471, 712, 14, 23, "Print"],
Cell[155123, 3487, 784, 14, 23, "Print"],
Cell[155910, 3503, 709, 14, 23, "Print"],
Cell[156622, 3519, 786, 14, 23, "Print"],
Cell[157411, 3535, 711, 14, 23, "Print"],
Cell[158125, 3551, 786, 14, 23, "Print"],
Cell[158914, 3567, 716, 14, 23, "Print"],
Cell[159633, 3583, 786, 14, 23, "Print"],
Cell[160422, 3599, 714, 14, 23, "Print"],
Cell[161139, 3615, 782, 14, 23, "Print"],
Cell[161924, 3631, 714, 14, 23, "Print"],
Cell[162641, 3647, 782, 14, 23, "Print"],
Cell[163426, 3663, 710, 14, 23, "Print"],
Cell[164139, 3679, 784, 14, 23, "Print"],
Cell[164926, 3695, 710, 14, 23, "Print"],
Cell[165639, 3711, 786, 14, 23, "Print"],
Cell[166428, 3727, 712, 14, 23, "Print"],
Cell[167143, 3743, 786, 14, 23, "Print"],
Cell[167932, 3759, 715, 14, 23, "Print"],
Cell[168650, 3775, 784, 14, 23, "Print"],
Cell[169437, 3791, 710, 14, 23, "Print"],
Cell[170150, 3807, 784, 14, 23, "Print"],
Cell[170937, 3823, 712, 14, 23, "Print"],
Cell[171652, 3839, 782, 14, 23, "Print"],
Cell[172437, 3855, 710, 14, 23, "Print"],
Cell[173150, 3871, 786, 14, 23, "Print"],
Cell[173939, 3887, 712, 14, 23, "Print"],
Cell[174654, 3903, 786, 14, 23, "Print"],
Cell[175443, 3919, 710, 14, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[176180, 3937, 18277, 433, 1012, "Input"],
Cell[CellGroupData[{
Cell[194482, 4374, 1625, 39, 172, "Input"],
Cell[196110, 4415, 2152, 48, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[198299, 4468, 1380, 33, 152, "Input"],
Cell[199682, 4503, 1334, 36, 33, "Output"],
Cell[201019, 4541, 219, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[201275, 4550, 6827, 175, 372, "Input"],
Cell[208105, 4727, 11080, 300, 240, "Output"],
Cell[219188, 5029, 495, 11, 23, "Print"],
Cell[219686, 5042, 1964, 55, 69, "Output"],
Cell[221653, 5099, 312, 7, 30, "Output"],
Cell[221968, 5108, 238, 4, 30, "Output"],
Cell[222209, 5114, 238, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[222484, 5123, 2553, 60, 192, "Input"],
Cell[CellGroupData[{
Cell[225062, 5187, 578, 12, 23, "Print"],
Cell[225643, 5201, 502, 10, 23, "Print"],
Cell[226148, 5213, 259, 4, 23, "Print"],
Cell[226410, 5219, 460, 10, 23, "Print"],
Cell[226873, 5231, 716, 17, 23, "Print"],
Cell[227592, 5250, 777, 18, 23, "Print"],
Cell[228372, 5270, 302, 5, 23, "Print"],
Cell[228677, 5277, 11062, 295, 189, "Print"],
Cell[239742, 5574, 598, 15, 23, "Print"],
Cell[240343, 5591, 259, 4, 23, "Print"],
Cell[240605, 5597, 464, 10, 23, "Print"],
Cell[241072, 5609, 714, 17, 23, "Print"],
Cell[241789, 5628, 775, 18, 23, "Print"],
Cell[242567, 5648, 300, 5, 23, "Print"],
Cell[242870, 5655, 11340, 301, 189, "Print"],
Cell[254213, 5958, 602, 15, 23, "Print"],
Cell[254818, 5975, 257, 4, 23, "Print"],
Cell[255078, 5981, 468, 10, 23, "Print"],
Cell[255549, 5993, 712, 17, 23, "Print"],
Cell[256264, 6012, 773, 18, 23, "Print"],
Cell[257040, 6032, 298, 5, 23, "Print"],
Cell[257341, 6039, 11212, 300, 189, "Print"],
Cell[268556, 6341, 602, 15, 23, "Print"],
Cell[269161, 6358, 257, 4, 23, "Print"],
Cell[269421, 6364, 476, 10, 23, "Print"],
Cell[269900, 6376, 714, 17, 23, "Print"],
Cell[270617, 6395, 775, 18, 23, "Print"],
Cell[271395, 6415, 300, 5, 23, "Print"],
Cell[271698, 6422, 11057, 295, 189, "Print"],
Cell[282758, 6719, 598, 15, 23, "Print"],
Cell[283359, 6736, 259, 4, 23, "Print"],
Cell[283621, 6742, 462, 10, 23, "Print"],
Cell[284086, 6754, 716, 17, 23, "Print"],
Cell[284805, 6773, 777, 18, 23, "Print"],
Cell[285585, 6793, 302, 5, 23, "Print"],
Cell[285890, 6800, 11021, 295, 189, "Print"],
Cell[296914, 7097, 598, 15, 23, "Print"],
Cell[297515, 7114, 259, 4, 23, "Print"],
Cell[297777, 7120, 458, 10, 23, "Print"],
Cell[298238, 7132, 716, 17, 23, "Print"],
Cell[298957, 7151, 777, 18, 23, "Print"],
Cell[299737, 7171, 302, 5, 23, "Print"],
Cell[300042, 7178, 11154, 298, 189, "Print"],
Cell[311199, 7478, 598, 15, 23, "Print"],
Cell[311800, 7495, 259, 4, 23, "Print"],
Cell[312062, 7501, 450, 9, 23, "Print"],
Cell[312515, 7512, 716, 17, 23, "Print"],
Cell[313234, 7531, 777, 18, 23, "Print"],
Cell[314014, 7551, 302, 5, 23, "Print"],
Cell[314319, 7558, 10992, 299, 189, "Print"],
Cell[325314, 7859, 683, 18, 23, "Print"],
Cell[326000, 7879, 259, 4, 23, "Print"],
Cell[326262, 7885, 474, 10, 23, "Print"],
Cell[326739, 7897, 716, 17, 23, "Print"],
Cell[327458, 7916, 777, 18, 23, "Print"],
Cell[328238, 7936, 302, 5, 23, "Print"],
Cell[328543, 7943, 10917, 296, 189, "Print"],
Cell[339463, 8241, 1434, 42, 43, "Print"],
Cell[340900, 8285, 257, 4, 23, "Print"],
Cell[341160, 8291, 474, 10, 23, "Print"],
Cell[341637, 8303, 714, 17, 23, "Print"],
Cell[342354, 8322, 775, 18, 23, "Print"],
Cell[343132, 8342, 300, 5, 23, "Print"],
Cell[343435, 8349, 10846, 295, 189, "Print"],
Cell[354284, 8646, 596, 15, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[354929, 8667, 13331, 354, 852, "Input"],
Cell[368263, 9023, 17195, 293, 240, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[385495, 9321, 7657, 205, 452, "Input"],
Cell[393155, 9528, 6694, 116, 202, "Output"],
Cell[399852, 9646, 6518, 113, 204, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[406407, 9764, 9090, 254, 552, "Input"],
Cell[415500, 10020, 35244, 606, 374, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[450781, 10631, 3093, 83, 192, "Input"],
Cell[453877, 10716, 9235, 165, 374, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[463149, 10886, 2216, 62, 152, "Input"],
Cell[465368, 10950, 5836, 107, 374, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
