(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     51147,       1225]
NotebookOptionsPosition[     49587,       1168]
NotebookOutlinePosition[     49931,       1183]
CellTagsIndexPosition[     49888,       1180]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "This", " ", "notebook", " ", "contains", " ", "examples", " ", "for", 
     " ", "the", " ", "PET"}], "-", "functions", "\[IndentingNewLine]", " ", 
    "-", "CalcFormula", "-", "          ", 
    RowBox[{"calculate", " ", "mineral", " ", "formulae", " ", 
     RowBox[{"(", 
      RowBox[{"and", " ", "mole", " ", "fractions"}], ")"}]}], 
    "\[IndentingNewLine]", " ", "-", "TransformDatFile", "-", "     ", 
    RowBox[{"transform", " ", "microprobe", " ", "data"}], "-", 
    RowBox[{"files", " ", 
     RowBox[{"(", 
      RowBox[{"JEOL_JX", " ", "8600"}], ")"}], " ", "to", " ", "PET"}], "-", 
    RowBox[{"readable", " ", "format"}], "\[IndentingNewLine]", " ", "-", 
    "MakeAnalysisTable", "-", "    ", 
    RowBox[{
    "make", " ", "a", " ", "usual", " ", "table", " ", "of", " ", 
     "mineralchemical", " ", "analyses", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"wt", ".", "%"}], " ", "and", " ", "formula", " ", "units"}], 
      ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"This", " ", "top"}], "-", 
    RowBox[{
    "cell", " ", "must", " ", "be", " ", "run", " ", "once", " ", "before", 
     " ", "any", " ", "example", " ", "can", " ", "be", " ", 
     RowBox[{"performed", "."}]}]}], "  ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Define", " ", "the", " ", "directory"}], ",", 
    RowBox[{
     RowBox[{"where", " ", "the", " ", "PET"}], "-", 
     RowBox[{"files", " ", "reside", " ", 
      RowBox[{"(", 
       RowBox[{"e", ".", "g", ".", " ", 
        RowBox[{"C", ":", 
         RowBox[{
          RowBox[{"\\", "Eigene"}], " ", 
          RowBox[{"Dateien", "\\", "Pet"}]}]}]}], ")"}], " ", "and", " ", 
      "load", " ", 
      RowBox[{"PET", "."}]}]}]}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{
    "$PetDirectory", "=", 
     "\"\<C:\\Dokumente und Einstellungen\\dachsedgar\\Eigene \
Dateien\\Pet\\Pet7.0\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "$PetDirectory", "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"DeclarePackage", "[", 
     RowBox[{"\"\<DEFDAT`\>\"", ",", 
      RowBox[{"{", "\"\<Dataset\>\"", "}"}]}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "->", " ", "B88"}], "]"}], ";"}], " "}]}]], "Input",
 CellChangeTimes->{
  3.4227044958125*^9, {3.4857521051143093`*^9, 3.4857521056611805`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "1"}], ":", " ", 
    RowBox[{
     RowBox[{
     "display", " ", "the", " ", "usage", " ", "for", " ", "the", " ", 
      "PET"}], "-", "function", " ", "-", "CalcFormula", "-"}]}], "  ", 
   "*)"}], " ", "\[IndentingNewLine]", 
  RowBox[{"CalcFormula", "::", "usage"}]}]], "Input"],

Cell[BoxData["\<\"CalcFormula[\\\"filename\\\"] calculates formula units of \
minerals and other\\nmineral-chemical parameters (e.g. Al(IV), Al(VI), site \
fractions, etc.) from wt% oxides.\\n\\\"filename\\\" is the name of the data \
file containing the chemical analyses.\\nResults are written to the file \
\\\"filename.fu\\\".\\nAn outputfile in table format, containing weight % and \
formula units\\nfor each analysis can be produced with \
-MakeAnalysisTable-\\n(see MakeAnalysisTable::usage for more details).\\nThe \
function -TransformDatFile- can be used to transform data files generated by \
a\\nJEOL-microprobe to the structure required as input for \
-CalcFormula-\\n(see TransformDatFile::usage for more details).\\n\\nData \
file structure:\\nAs an example, data file \\\"hs78b\\\" is shown \
below\\n(sample 78B, taken from Hodges & Spear (1982) Am Min \
67:1118-1134):\\n\\nLabel Mineral SiO2   Al2O3  TiO2  MgO    FeO    MnO   CaO \
  Na2O    K2O\\n1     bt      36.31  19.74  1.43  10.04  18.35  0.12  0.11   \
0.28   7.9\\n2     wm      47.49  35.84  0.43  0.48   0.74   0     0.07   \
1.78   8.29\\n3r    grt     38.53  21.85  0     2.3    33.77  4.86  0.87   0  \
    0\\n4     plag    65.19  21.21  0     0      0      0     2.65   10.95  \
0.11\\n\\nData may be separated by tabs, spaces or commas.\\nThe first column \
accepts numbers or text as labels for each analysis.\\nIt is recommended to \
combine label-numbers with letters indicating\\nthe textural position of an \
analysis in the mineral assemblage.\\nIf, e.g. the above bt were an inclusion \
in garnet, this could be indicated by\\nadding \\\"ig\\\" as \\\"textural \
label\\\":\\n\\n1ig   bt      36.31  19.74  1.43  10.04  18.35  0.12  0.11   \
0.28   7.9\\n\\nThis requires some work at the beginning, but once you have \
defined and\\nadded your own textural labels, has the enormous advantage that \
you later on\\ncan easily search your data files for minerals belonging to a \
specific\\ntextural position as defined by your textural labels and compare \
them in\\na mineral-chemical plot (see ExtractMinDat::usage for more \
details).\\nThe second column contains the codes required by the program in \
order to use the correct\\noxygen-basis (anhydrous) or cation-basis in the \
formula calculation (see the list below).\\nBy default, -CalcFormula- \
computes formulae on an oxygen basis. Using the \
option\\n\\\"CalcFormulaBasis->CationBasis\\\", -CalcFormula- switches to \
cation-based mineral formulae.\\n\\nmineral          code         oxygen \
basis        cation basis\\n\\nalumosilicate    alsi          5               \
   3\\namphibole        amph         23                 15\\nbiotite          \
bt           11                  8\\ncalcite          cal           1         \
         1\\nchlorite         chl          14                 10\\nchloritoid \
      ctd           6                  4\\nclinopyroxene    cpx           6   \
               4\\ncordierite       crd          18                 \
11\\ndolomite         dol           2                  2\\ngarnet           \
grt          12                  8\\nilmenite         fetiox        3         \
         2\\nkfeldspar        kf            8                  \
5\\northopyroxene    opx           6                  4\\nother mineral    \
min...       defined by user    defined by user\\nolivine          ol         \
   4                  3\\nplagioclase      plag          8                  5\
\\nsapphirine       saph         20                 14\\nsphene           \
sphen         5                  3\\nspinel           spin          4         \
         3\\nstaurolite       stau         46                 \
30\\nstilpnomelane    stilp        23.8125            15.625\\ntalc           \
  ta           11                  7\\nwhite mica       wm           11       \
           7\\nzoisite/epidote  zoep         12.5                8\\n\\nIf \
<other mineral> is used, \\\"min\\\" immediately followed by the numer of \
oxygens or cations\\nto be used as basis in the formula calculation must \
appear as input (e.g. \\\"min4\\\" for zircon\\nanalyses on an oxygen basis). \
Decimal numbers can also be input by using \\\"d\\\" as decimal \
point\\n(\\\"min12d5\\\" would thus calculate the formula for 12.5 \
oxygens/cations).\\nAvailable oxides for usage with - CalcFormula- \
are:\\n\\nAl2O3, BaO, BeO, B2O3, CaO, CeO2, Ce2O3, Cl, CoO, CO2, Cr2O3, Cs2O, \
CuO, Dy2O3,\\nEr2O3, Eu2O3, F, FeO, Fe2O3, Gd2O3, HfO2, H2O, K2O, La2O3, \
Li2O, Lu2O3, MgO, MnO,\\nMnO2, Mn3O4, Na2O, Nb2O5, Nd2O3, NiO, PbO, Pr2O3, \
P2O5, Rb2O, S, Sc2O3, SiO2, Sm2O3,\\nSnO, SO3, SrO, Ta2O5, ThO2, TiO2, UO2, \
V2O3, Y2O3, ZnO, ZrO2\\n\\nThe calculation of formula units is done as \
outlined by Giaramita & Day (1990),\\nAm Min 75:170-182. If F or Cl are \
present in OH-bearing silicates and H2O is not\\nspecified, the formula is \
calculated on the anhydrous O-basis (Leake et al. (1997),\\nEur J Mineral \
9:623-651, p.648). If H2O (or CO2) is given, the formula is calculated \
on\\nthe total number of (O,OH).\\nNomenclature is performed for amphibole \
(following Leake et al. (1997) Eur J Mineral 9:623-651),\\nand for pyroxene \
(according to Morimoto (1988) Min Mag 52:535-550). The filling order of sites\
\\nin amph and px also follows these \
papers.\\n\\nOptions:\\n\\nCalcFormulaBasis->OxygenBasis (default)\\n         \
         CationBasis\\n\\nCalcFormulaMode->PetToTweeq (default)\\n            \
     PetToAx\\n                 TweeqToPet\\n                 AxToPet\\n      \
           Gtb\\n                 {}\\n\\nCalcFormulaMode->PetToTweeq\\nPET \
-> TWEEQ interface:\\nTo ensure compatibility between mineral-formula \
calculation sheme and thermodynamic data base (Berman, 1988),\\n-CalcFormula- \
creates a \\\"filename.oxi\\\"-file by default, for analyses of amphibole, \
clinopyroxene,\\northopyroxene, plagioclase, white mica, biotite or garnet. \
Use then Cmp.exe to create\\na \\\"filename.cmp\\\"-file for further \
PT-calculations with PET or TWEEQ.\\n\\nCalcFormulaMode->PetToAx\\nPET -> \
THERMOCALC interface:\\nApplying this option, causes -CalcFormula- to create \
a \\\"filename.dat\\\"-file in the format required\\nby the program AX.exe \
(part of THERMOCALC software).\\n\\nCalcFormulaMode->TweeqToPet\\nTWEEQ -> \
PET interface:\\nApplying this option, causes -CalcFormula- to convert an \
input-file for CMP.exe to a PET-readable format.\\nThe file must have the \
extension \\\".oxi\\\" and the corresponding PET-file is then stored under \
the same\\nname without extension. Using this option, one can convert \
CMP-files to PET (e.g. for mineral-chemical plots)\\nand to THERMOCALC \
(CalcFormulaMode->PetToAx).\\n\\nCalcFormulaMode->AxToPet\\nTHERMOCALC -> PET \
interface:\\nApplying this option, causes -CalcFormula- to convert an \
input-file for AX.exe to a PET-readable format.\\nThe file must have the \
extension \\\".dat\\\" and the corresponding PET-file is then stored under \
the same\\nname without extension. Using this option, one can convert \
AX-files to PET (e.g. for mineral-chemical plots)\\nand to TWEEQ \
(CalcFormulaMode->PetToTweeq).\\n\\nCalcFormulaMode->Gtb\\nIf you want to use \
the geothermobarometer package (PET-function -CalcThermoBaro-), \
special\\nmineral-chemical parameters are needed in some calibrations, e.g. \
for cpx to calculate the grt-cpx thermometer.\\nSetting CalcFormulaMode->Gtb \
causes these parameters to be calculated and appended\\nas 3rd sub-element at \
the end of the returned data for that mineral in \
\\\"filename.fu\\\".\\n\\nCalcFormulaMode->{}\\nIn this mode, only a \
\\\"filename.fu\\\" is created by -CalcFormula- (useful e.g. for \
mineral-chemical plots\\nwith the PET-function -XYPlot- or \
-TrianglePlot-).\\n \\nOptions for Fe(3+) \
recalculation:\\n\\nFe3Amph->LeakeFe3Mean           : mean Fe3+    according \
to Leake et al. (1997), Eur J Mineral 9:623-651.\\n         LeakeFe3Min       \
     : minimum Fe3+ according to - \\\" -.\\n         LeakeFe3Max            \
: maximum Fe3+ according to - \\\" -.\\n         HollandBlundy (default): \
Holland & Blundy (1994), Contrib Mineral Petrol 116:433-447,\\n               \
                   corrected Dale et al. (2000),  Contrib Mineral Petrol \
140:353-362,\\n                                  required for the \
amphibole-plagioclase thermometer or the\\n                                  \
hornblende-garnet-plagioclase thermobarometer of Dale et al. \
(2000).\\nFe3Px->Droop     (default): Fe3+ according to Droop (1987), Min Mag \
51:431-435.\\nFe3Grt->Droop    (default): Fe3+ according to - \\\" \
-.\\nFe3Spin->Droop   (default): Fe3+ according to - \\\" -.\\nFe3Ctd->Droop  \
  (default): Fe3+ according to - \\\" -.\\nFe3Saph->Droop   (default): Fe3+ \
according to - \\\" -.\\nFe3Fetiox->Droop (default): Fe3+ according to - \\\" \
-.\\nAll of these options can be set to Fe3Mineral->NoCalculation, which \
suppresses Fe3+ recalculation.\\n\\nOther options:\\n\\nOxygens, \
NumberFormatFu and NumberFormatX.\\n\\nThe option \\\"Oxygens\\\" can be used \
if an analysis is to be calculated to a restricted number of \
oxygens\\nexcluding some oxides (e.g. sodalite, Deer, Howie, Zussman (1993), \
Tab. 44, analysis 2).\\nIn this example only oxygens from SiO2 and Al2O3 are \
relevant, all others are excluded.\\nThis is achieved \
with:\\nCalcformula[\\\"filename\\\",Oxygens->{{Fe2O3,0},{MnO,0},{Na2O,0},{\
K2O,0},{SO3,0},{Cl,0}}].\\nThe options  \\\"NumberFormatFu\\\" and  \
\\\"NumberFormatX\\\" have the default values\\n{5,3} and {8,5}, causing that \
formula units in \\\"outputfile.fu\\\"  are written with 3 digits\\nand \
mineral chemical parameters with 5 digits to the right of the decimal \
point.\\n\\nReturnValue:\\n\\nReturned is a list containing as 1st \
element:\\n{Mineral, Label, list of oxides, Total}\\nthe 2nd element contains \
the analyses, where each list beginns with\\nthe mineral code, followed by \
the analysis label, then the list\\nof formula units in the order specified \
in <list of oxides>,\\nand finally the total of the analysis. The last \
element given is a list of\\nvarious parameters required for calculating \
activities and geothermobarometers:\\n1st element: list of mineral-dependent \
mineral-chemical parameters, e.g.\\n             {Al(IV), Al(VI), SumCat, \
SumM4, etc.}\\n2nd element: site-fractions for (ideal)activities, e.g. for \
garnet:\\n             {{XCa,XMg,XFe,XMn},{XAl,XFe3}}\\n3rd element \
(optional): parameters for geothermobarometers.\\n\\nExample (for the data \
file  \\\"hs78b\\\"):\\n\\nCalcFormula[\\\"hs78b\\\"]\\n\\n{{Mineral, Label, \
SiO2, Al2O3, TiO2, MgO, FeO, MnO, CaO, Na2O, K2O, Total}, \\n{{bt, 1, 2.745, \
1.759, 0.081, 1.131, 1.16, 0.008, 0.009, 0.041, 0.762, 94.28,\\n{{{Al(IV), \
Al(VI), SumCat, SumOk, SumA}, {1.25515, 0.50358, 7.69595, 2.88412, 0.81183}},\
\\n{{{XK}, {XMgM, XFeM, XTiM, XAlM}, {XOH}}, {{0.93847}, {0.39231, 0.40223, \
0.02819, 0.1746}, {1.}}}}},\\n{wm, 2, 3.12, 2.775, 0.021, 0.047, 0.041, 0., \
0.005, 0.227, 0.695, 95.12,\\n{{{Al(IV), Al(VI), SumCat, SumOk, SumA}, \
{0.87958, 1.89589, 6.93144, 2.00482, 0.92661}},\\n{{{XK, XNa, XCa}, {XAlM, \
XFeM, XMgM}, {XOH}, {XAlT, XSiT}}, \\n{{0.75396, 0.24604, 0.00532}, {0.94567, \
0.02028, 0.02345}, {1.}, {0.21989, 0.78011}}}}},\\n{grt, 3, 3.034, 2.028, 0., \
0.27, 2.224, 0.324, 0.073, 0., 0., 102.18,\\n{{{SumCat, Sum(Fe+Mg+Ca+Mn), \
Fe3, Fe3CalcMode}, {7.95248, 2.89116, 0., Droop}},\\n{{{XCa, XMg, XFe, XMn}, \
{XAl, XFe3}}, {{0.02539, 0.09338, 0.76913, 0.11211}, {1., 0.}}}}},\\n{plag, \
4, 2.875, 1.102, 0., 0., 0., 0., 0.125, 0.936,0.006, 100.11,\\n{{{SumCat}, \
{5.04508}}, {{{XNa, XCa, XK}}, {{0.87693, 0.11728, 0.0058}}}}}}}\\n\\nThe \
returned list in this example is stored in the file \
\\\"hs78b.fu\\\".\\nAnother example that modifies the format of the formula \
units to 2 \
digits:\\n\\nCalcFormula[\\\"hs78b\\\",NumberFormatFu->{4,2}]\\n\\nCalled \
from: User.\\nPackage name: FORMEL.m\\nPET: Petrological Elementary Tools, \
(c) Edgar Dachs.\"\>"], "Output",
 CellChangeTimes->{3.422704512453125*^9, 3.4227046739375*^9, 
  3.4227050015625*^9, 3.4227051460625*^9, 3.42270518371875*^9, 
  3.422768983875*^9, 3.4857514004724874`*^9, 3.485752115004981*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "2"}], ":", " ", 
     RowBox[{
      RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
      "TransformDatFile", "-", " ", 
      RowBox[{"to", " ", "transform", " ", "the", " ", "electron"}], "-", 
      RowBox[{"microprobe", " ", "data"}], "-", 
      RowBox[{"file", " ", "\"\<hs78b.emp\>\"", 
       RowBox[{"(", 
        RowBox[{"JEOL_JX", " ", "8600"}], ")"}], " ", "to", " ", "a", " ", 
       "PET"}], "-", 
      RowBox[{"readable", " ", "format"}]}]}], ",", " ", 
    RowBox[{"producing", " ", "the", " ", "file", " ", 
     RowBox[{"\"\<hs78b\>\"", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"TransformDatFile", "[", 
   RowBox[{"\"\<hs78b.emp\>\"", ",", "\"\<hs78b\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.422705192765625*^9, 3.42270519315625*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Error-message from -TransformDatFile-: File \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"hs78b\"\>", 
   "\[InvisibleSpace]", "\<\"\\\" already exists (would be \
overwritten).\"\>"}],
  SequenceForm[
  "Error-message from -TransformDatFile-: File \"", "hs78b", 
   "\" already exists (would be overwritten)."],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270519428125*^9, 3.42276898646875*^9, 
  3.485751400534988*^9, 3.485752115036231*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "3"}], ":", " ", 
    RowBox[{
     RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
     "CalcFormula", "-", " ", 
     RowBox[{
     "to", " ", "calculate", " ", "the", " ", "mineral", " ", "formulae", " ",
       "for", " ", "the", " ", "data"}], "-", 
     RowBox[{"file", " ", "\"\<hs78b\>\""}]}]}], " ", "*)"}], " ", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"CalcFormula", "[", "\"\<hs78b\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.4227052455*^9, 3.422705245828125*^9}, {
  3.422769000171875*^9, 3.42276900140625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula- (PET -> TWEEQ interface): creating \
file \\\"\"\>", "\[InvisibleSpace]", "\<\"hs78b.oxi\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula- (PET -> TWEEQ interface): creating file \"", 
   "hs78b.oxi\"."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227052478125*^9, {3.422768991015625*^9, 3.422769002625*^9}, 
   3.4857514005506134`*^9, 3.4857521150518565`*^9}],

Cell[BoxData["\<\"Use Cmp.exe to create a *.cmp file for further calculations \
with PET or TWEEQ.\"\>"], "Print",
 CellChangeTimes->{
  3.4227052478125*^9, {3.422768991015625*^9, 3.422769002625*^9}, 
   3.4857514005506134`*^9, 3.4857521150674815`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"hs78b.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "hs78b.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4227052478125*^9, {3.422768991015625*^9, 3.422769002625*^9}, 
   3.4857514005506134`*^9, 3.4857521150987315`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Mineral", ",", "\<\"Label\"\>", ",", "SiO2", ",", "Al2O3", ",", "TiO2", 
     ",", "MgO", ",", "FeO", ",", "MnO", ",", "CaO", ",", "Na2O", ",", "K2O", 
     ",", "Total"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "bt", ",", "\<\"1\"\>", ",", "2.745`", ",", "1.759`", ",", "0.081`", 
       ",", "1.131`", ",", "1.16`", ",", "0.008`", ",", "0.009`", ",", 
       "0.041`", ",", "0.762`", ",", "94.28`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"Al(IV)\"\>", ",", "\<\"Al(VI)\"\>", 
             ",", "\<\"SumCat\"\>", ",", "\<\"SumOk\"\>", 
             ",", "\<\"SumA\"\>"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "1.25515`", ",", "0.50358`", ",", "7.69595`", ",", "2.88412`", 
             ",", "0.81183`"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", "\<\"XK\"\>", "}"}], ",", 
             RowBox[{"{", 
              
              RowBox[{"\<\"XMgM\"\>", ",", "\<\"XFeM\"\>", 
               ",", "\<\"XTiM\"\>", ",", "\<\"XAlM\"\>"}], "}"}], ",", 
             RowBox[{"{", "\<\"XOH\"\>", "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", "0.93847`", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "0.39231`", ",", "0.40223`", ",", "0.02819`", ",", "0.1746`"}], 
              "}"}], ",", 
             RowBox[{"{", "1.`", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
      "wm", ",", "\<\"2\"\>", ",", "3.12`", ",", "2.775`", ",", "0.021`", ",",
        "0.047`", ",", "0.041`", ",", "0.`", ",", "0.005`", ",", "0.227`", 
       ",", "0.695`", ",", "95.12`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"Al(IV)\"\>", ",", "\<\"Al(VI)\"\>", 
             ",", "\<\"SumCat\"\>", ",", "\<\"SumOk\"\>", 
             ",", "\<\"SumA\"\>"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "0.87958`", ",", "1.89589`", ",", "6.93144`", ",", "2.00482`", 
             ",", "0.92661`"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"XK\"\>", ",", "\<\"XNa\"\>", ",", "\<\"XCa\"\>"}], 
              "}"}], ",", 
             RowBox[{"{", 
              
              RowBox[{"\<\"XAlM\"\>", ",", "\<\"XFeM\"\>", 
               ",", "\<\"XMgM\"\>"}], "}"}], ",", 
             RowBox[{"{", "\<\"XOH\"\>", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\<\"XAlT\"\>", ",", "\<\"XSiT\"\>"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.75396`", ",", "0.24604`", ",", "0.00532`"}], "}"}], 
             ",", 
             RowBox[{"{", 
              RowBox[{"0.94567`", ",", "0.02028`", ",", "0.02345`"}], "}"}], 
             ",", 
             RowBox[{"{", "1.`", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.21989`", ",", "0.78011`"}], "}"}]}], "}"}]}], 
          "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "grt", ",", "\<\"3r\"\>", ",", "3.034`", ",", "2.028`", ",", "0.`", ",",
        "0.27`", ",", "2.224`", ",", "0.324`", ",", "0.073`", ",", "0.`", ",",
        "0.`", ",", "102.18`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"SumCat\"\>", ",", "\<\"Sum(Fe+Mg+Ca+Mn)\"\>", 
             ",", "\<\"Fe3\"\>", ",", "\<\"Fe3CalcMode\"\>"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "7.95248`", ",", "2.89116`", ",", "0.`", ",", "\<\"Droop\"\>"}], 
            "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              
              RowBox[{"\<\"XCa\"\>", ",", "\<\"XMg\"\>", ",", "\<\"XFe\"\>", 
               ",", "\<\"XMn\"\>"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\<\"XAl\"\>", ",", "\<\"XFe3\"\>"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "0.02539`", ",", "0.09338`", ",", "0.76913`", ",", "0.11211`"}],
               "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1.`", ",", "0.`"}], "}"}]}], "}"}]}], "}"}]}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "plag", ",", "\<\"4\"\>", ",", "2.875`", ",", "1.102`", ",", "0.`", ",",
        "0.`", ",", "0.`", ",", "0.`", ",", "0.125`", ",", "0.936`", ",", 
       "0.006`", ",", "100.11`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "\<\"SumCat\"\>", "}"}], ",", 
           RowBox[{"{", "5.04508`", "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{"\<\"XNa\"\>", ",", "\<\"XCa\"\>", ",", "\<\"XK\"\>"}], 
             "}"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{"0.87693`", ",", "0.11728`", ",", "0.0058`"}], "}"}], 
            "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}], 
   ",", "\<\"OxygenBasis\"\>", ",", "\<\"B88\"\>", 
   ",", "\<\"Date: {2010, 6, 17}\"\>"}], "}"}]], "Output",
 CellChangeTimes->{
  3.422705247828125*^9, {3.422768991046875*^9, 3.42276900265625*^9}, 
   3.4857514005818634`*^9, 3.485752115114357*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "4"}], ":", " ", 
     RowBox[{
      RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
      "CalcFormula", "-", " ", 
      RowBox[{"to", " ", "calculate", " ", "the", " ", "mineral"}], "-", 
      RowBox[{"formulae", " ", "for", " ", "the", " ", "data"}], "-", 
      RowBox[{"file", " ", "\"\<hs78b\>\""}]}]}], ",", " ", 
    RowBox[{"but", " ", 
     RowBox[{"don", "'"}], "t", " ", "create", " ", "other", " ", "files", 
     " ", 
     RowBox[{"(", 
      RowBox[{"for", " ", "TWEEQ", " ", "or", " ", "AX"}], ")"}]}]}], "  ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"recommended", " ", "if", " ", "only", " ", "mineral"}], "-", 
    RowBox[{
    "formulae", " ", "calculations", " ", "and", " ", "plots", " ", "are", 
     " ", "intended", " ", "and", " ", "no", " ", "further", " ", "PT", " ", 
     "calculations"}]}], " ", "*)"}], "\[IndentingNewLine]", " ", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"CalcFormula", "[", 
    RowBox[{"\"\<hs78b\>\"", ",", 
     RowBox[{"CalcFormulaMode", "\[Rule]", 
      RowBox[{"{", "}"}]}]}], "]"}], "\[IndentingNewLine]"}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"hs78b.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "hs78b.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.4227052544375*^9, 3.4227690100625*^9, 
  3.4857514006131134`*^9, 3.485752115145607*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Mineral", ",", "\<\"Label\"\>", ",", "SiO2", ",", "Al2O3", ",", "TiO2", 
     ",", "MgO", ",", "FeO", ",", "MnO", ",", "CaO", ",", "Na2O", ",", "K2O", 
     ",", "Total"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "bt", ",", "\<\"1\"\>", ",", "2.745`", ",", "1.759`", ",", "0.081`", 
       ",", "1.131`", ",", "1.16`", ",", "0.008`", ",", "0.009`", ",", 
       "0.041`", ",", "0.762`", ",", "94.28`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"Al(IV)\"\>", ",", "\<\"Al(VI)\"\>", 
             ",", "\<\"SumCat\"\>", ",", "\<\"SumOk\"\>", 
             ",", "\<\"SumA\"\>"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "1.25515`", ",", "0.50358`", ",", "7.69595`", ",", "2.88412`", 
             ",", "0.81183`"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", "\<\"XK\"\>", "}"}], ",", 
             RowBox[{"{", 
              
              RowBox[{"\<\"XMgM\"\>", ",", "\<\"XFeM\"\>", 
               ",", "\<\"XTiM\"\>", ",", "\<\"XAlM\"\>"}], "}"}], ",", 
             RowBox[{"{", "\<\"XOH\"\>", "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", "0.93847`", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "0.39231`", ",", "0.40223`", ",", "0.02819`", ",", "0.1746`"}], 
              "}"}], ",", 
             RowBox[{"{", "1.`", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
      "wm", ",", "\<\"2\"\>", ",", "3.12`", ",", "2.775`", ",", "0.021`", ",",
        "0.047`", ",", "0.041`", ",", "0.`", ",", "0.005`", ",", "0.227`", 
       ",", "0.695`", ",", "95.12`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"Al(IV)\"\>", ",", "\<\"Al(VI)\"\>", 
             ",", "\<\"SumCat\"\>", ",", "\<\"SumOk\"\>", 
             ",", "\<\"SumA\"\>"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "0.87958`", ",", "1.89589`", ",", "6.93144`", ",", "2.00482`", 
             ",", "0.92661`"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"XK\"\>", ",", "\<\"XNa\"\>", ",", "\<\"XCa\"\>"}], 
              "}"}], ",", 
             RowBox[{"{", 
              
              RowBox[{"\<\"XAlM\"\>", ",", "\<\"XFeM\"\>", 
               ",", "\<\"XMgM\"\>"}], "}"}], ",", 
             RowBox[{"{", "\<\"XOH\"\>", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\<\"XAlT\"\>", ",", "\<\"XSiT\"\>"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.75396`", ",", "0.24604`", ",", "0.00532`"}], "}"}], 
             ",", 
             RowBox[{"{", 
              RowBox[{"0.94567`", ",", "0.02028`", ",", "0.02345`"}], "}"}], 
             ",", 
             RowBox[{"{", "1.`", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.21989`", ",", "0.78011`"}], "}"}]}], "}"}]}], 
          "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "grt", ",", "\<\"3r\"\>", ",", "3.034`", ",", "2.028`", ",", "0.`", ",",
        "0.27`", ",", "2.224`", ",", "0.324`", ",", "0.073`", ",", "0.`", ",",
        "0.`", ",", "102.18`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"SumCat\"\>", ",", "\<\"Sum(Fe+Mg+Ca+Mn)\"\>", 
             ",", "\<\"Fe3\"\>", ",", "\<\"Fe3CalcMode\"\>"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "7.95248`", ",", "2.89116`", ",", "0.`", ",", "\<\"Droop\"\>"}], 
            "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              
              RowBox[{"\<\"XCa\"\>", ",", "\<\"XMg\"\>", ",", "\<\"XFe\"\>", 
               ",", "\<\"XMn\"\>"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\<\"XAl\"\>", ",", "\<\"XFe3\"\>"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "0.02539`", ",", "0.09338`", ",", "0.76913`", ",", "0.11211`"}],
               "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1.`", ",", "0.`"}], "}"}]}], "}"}]}], "}"}]}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "plag", ",", "\<\"4\"\>", ",", "2.875`", ",", "1.102`", ",", "0.`", ",",
        "0.`", ",", "0.`", ",", "0.`", ",", "0.125`", ",", "0.936`", ",", 
       "0.006`", ",", "100.11`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "\<\"SumCat\"\>", "}"}], ",", 
           RowBox[{"{", "5.04508`", "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{"\<\"XNa\"\>", ",", "\<\"XCa\"\>", ",", "\<\"XK\"\>"}], 
             "}"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{"0.87693`", ",", "0.11728`", ",", "0.0058`"}], "}"}], 
            "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}], 
   ",", "\<\"OxygenBasis\"\>", ",", "\<\"B88\"\>", 
   ",", "\<\"Date: {2010, 6, 17}\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.4227052544375*^9, 3.4227690100625*^9, 
  3.4857514006131134`*^9, 3.485752115145607*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{" ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Example", " ", "5"}], ":", " ", 
        RowBox[{
         RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
         "CalcFormula", "-", " ", 
         RowBox[{
         "to", " ", "calculate", " ", "the", " ", "mineral", " ", "formulae", 
          " ", "for", " ", "the"}]}]}], " ", "\[IndentingNewLine]", "data"}], 
      "-", 
      RowBox[{"file", " ", "\"\<ho2468\>\"", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"contains", " ", "amph"}], ",", " ", 
         RowBox[{
          RowBox[{"plag", " ", "and", " ", "grt"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"sample", " ", "2468", " ", "of", " ", "Hoschek", " ", 
           RowBox[{"(", "1998", ")"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{
          "Neues", " ", "Jahrb", " ", "Mineral", " ", "Abh", " ", "173"}], 
          ":", 
          RowBox[{"155", "-", "187"}]}]}], ")"}]}]}], ";"}], " ", ")"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"change", " ", "the", " ", "Fe3"}], "+", " ", 
     RowBox[{"calculation", " ", "mode", " ", "to", " ", "LeakeFe3Max"}]}], 
    ",", " ", 
    RowBox[{
     RowBox[{"creating", " ", "maximum", " ", "Fe", 
      RowBox[{"(", 
       RowBox[{"3", "+"}], ")"}]}], "-", 
     RowBox[{
     "values", " ", "according", " ", "to", " ", "Leake", " ", "et", " ", 
      RowBox[{"al", ".", " ", 
       RowBox[{"(", "1997", ")"}]}]}]}]}], "   ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"CalcFormula", "[", " ", 
   RowBox[{"\"\<ho2468\>\"", ",", 
    RowBox[{"Fe3Amph", "->", "LeakeFe3Max"}]}], "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula- (PET -> TWEEQ interface): creating \
file \\\"\"\>", "\[InvisibleSpace]", "\<\"ho2468.oxi\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula- (PET -> TWEEQ interface): creating file \"", 
   "ho2468.oxi\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422705263375*^9, 3.4227690119375*^9, 
  3.485751400644364*^9, 3.4857521151924825`*^9}],

Cell[BoxData["\<\"Use Cmp.exe to create a *.cmp file for further calculations \
with PET or TWEEQ.\"\>"], "Print",
 CellChangeTimes->{3.422705263375*^9, 3.4227690119375*^9, 
  3.485751400644364*^9, 3.4857521151924825`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"ho2468.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "ho2468.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422705263375*^9, 3.4227690119375*^9, 
  3.485751400644364*^9, 3.4857521152237325`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Mineral", ",", "\<\"Label\"\>", ",", "SiO2", ",", "TiO2", ",", "Al2O3", 
     ",", "FeO", ",", "MnO", ",", "MgO", ",", "CaO", ",", "Na2O", ",", "K2O", 
     ",", "Fe2O3", ",", "Total"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "amph", ",", "\<\"1\"\>", ",", "6.011`", ",", "0.039`", ",", "3.222`", 
       ",", "1.404`", ",", "0.006`", ",", "1.594`", ",", "1.719`", ",", 
       "0.42`", ",", "0.084`", ",", "0.`", ",", "97.68`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"Al(IV)\"\>", ",", "\<\"Al(VI)\"\>", 
             ",", "\<\"Fe3\"\>", ",", "\<\"SumCat\"\>", 
             ",", "\<\"CaB+NaB\"\>", ",", "\<\"NaB\"\>", 
             ",", "\<\"NaA+KA\"\>", ",", "\<\"Mg/(Fe2+Mg)\"\>", 
             ",", "\<\"Fe2/(Fe2+Mg)\"\>", ",", "\<\"Mg/(Mn+Mg)\"\>", 
             ",", "\<\"group\"\>", ",", "\<\"name\"\>", 
             ",", "\<\"Fe3CalcMode\"\>"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "1.98932`", ",", "1.23243`", ",", "0.72901`", ",", "15.22762`", 
             ",", "1.99557`", ",", "0.27686`", ",", "0.22762`", ",", 
             "0.53174`", ",", "0.46826`", ",", "0.99612`", 
             ",", "\<\"calcic-group\"\>", ",", "\<\"aluminotschermakite\"\>", 
             ",", "\<\"LeakeFe3Max\"\>"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              
              RowBox[{"\<\"XNaA\"\>", ",", "\<\"XKA\"\>", 
               ",", "\<\"XVacA\"\>"}], "}"}], ",", 
             RowBox[{"{", 
              
              RowBox[{"\<\"XCaM4\"\>", ",", "\<\"XMgM4\"\>", 
               ",", "\<\"XFeM4\"\>", ",", "\<\"XMnM4\"\>", 
               ",", "\<\"XNaM4\"\>"}], "}"}], ",", 
             RowBox[{"{", 
              
              RowBox[{"\<\"XMgM13\"\>", ",", "\<\"XFeM13\"\>", 
               ",", "\<\"XMnM13\"\>"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\<\"XMgM2\"\>", ",", "\<\"XFeM2\"\>", 
               ",", "\<\"XAlM2\"\>", ",", "\<\"XFe3M2\"\>", 
               ",", "\<\"XTiM2\"\>"}], "}"}], ",", 
             RowBox[{"{", "\<\"XOH\"\>", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\<\"XAlT1\"\>", ",", "\<\"XSiT1\"\>"}], "}"}]}], "}"}],
            ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.14352`", ",", "0.0841`", ",", "0.77238`"}], "}"}], 
             ",", 
             RowBox[{"{", 
              RowBox[{
              "0.85935`", ",", "0.00118`", ",", "0.00104`", ",", 
               "4.578684794561987`*^-6", ",", "0.13843`"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.53064`", ",", "0.46729`", ",", "0.00207`"}], "}"}], 
             ",", 
             RowBox[{"{", 
              RowBox[{
              "9.426065505448232`*^-16", ",", "8.300820895007271`*^-16", ",", 
               "0.61621`", ",", "0.36451`", ",", "0.01928`"}], "}"}], ",", 
             RowBox[{"{", "1.`", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.49733`", ",", "0.50267`"}], "}"}]}], "}"}]}], 
          "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "grt", ",", "\<\"2\"\>", ",", "2.97`", ",", "0.003`", ",", "2.046`", 
       ",", "2.014`", ",", "0.051`", ",", "0.284`", ",", "0.624`", ",", "0.`",
        ",", "0.`", ",", "0.`", ",", "101.16`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"SumCat\"\>", ",", "\<\"Sum(Fe+Mg+Ca+Mn)\"\>", 
             ",", "\<\"Fe3\"\>", ",", "\<\"Fe3CalcMode\"\>"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "8.`", ",", "2.97296`", ",", "0.00803`", ",", "\<\"Droop\"\>"}], 
            "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              
              RowBox[{"\<\"XCa\"\>", ",", "\<\"XMg\"\>", ",", "\<\"XFe\"\>", 
               ",", "\<\"XMn\"\>"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\<\"XAl\"\>", ",", "\<\"XFe3\"\>"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "0.20988`", ",", "0.0955`", ",", "0.67758`", ",", "0.01704`"}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.996`", ",", "0.00402`"}], "}"}]}], "}"}]}], "}"}]}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "plag", ",", "\<\"3\"\>", ",", "2.433`", ",", "0.`", ",", "1.587`", ",",
        "0.`", ",", "0.`", ",", "0.002`", ",", "0.527`", ",", "0.439`", ",", 
       "0.006`", ",", "0.001`", ",", "100.66`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "\<\"SumCat\"\>", "}"}], ",", 
           RowBox[{"{", "4.99494`", "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{"\<\"XNa\"\>", ",", "\<\"XCa\"\>", ",", "\<\"XK\"\>"}], 
             "}"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{"0.45205`", ",", "0.54207`", ",", "0.00588`"}], "}"}], 
            "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}], 
   ",", "\<\"OxygenBasis\"\>", ",", "\<\"B88\"\>", 
   ",", "\<\"Date: {2010, 6, 17}\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.42270526340625*^9, 3.422769012*^9, 
  3.4857514006756144`*^9, 3.485752115239358*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "6"}], ":", " ", 
    RowBox[{
     RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
     "MakeAnalysisTable", "-", " ", 
     RowBox[{"to", " ", "create", " ", "a", " ", "*", 
      RowBox[{".", "tab"}], " ", "file", " ", "that", " ", "contains", " ", 
      "analyses", " ", "in", " ", "tabular", " ", "form"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"MakeAnalysisTable", "[", "\"\<hs78b\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.422769017484375*^9, 3.422769018140625*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -MakeAnalysisTable-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"hs78b.tab\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -MakeAnalysisTable-: creating file \"", "hs78b.tab", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270526928125*^9, 3.4227690193125*^9, 
  3.4857514006912394`*^9, 3.485752115270608*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CalcFormula", "[", 
   RowBox[{"\"\<hs78b\>\"", ",", 
    RowBox[{"CalcFormulaMode", "\[Rule]", "PetToAx"}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.42270527340625*^9, 3.422705273765625*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula- (PET-THERMOCALC interface): \
creating file \\\"\"\>", "\[InvisibleSpace]", "\<\"hs78b.dat\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula- (PET-THERMOCALC interface): creating file \"", 
   "hs78b.dat\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270527515625*^9, 3.42276902325*^9, 
  3.4857514007068644`*^9, 3.485752115286233*^9}],

Cell[BoxData["\<\"Use Ax.exe for further calculations with THERMOCALC.\"\>"], \
"Print",
 CellChangeTimes->{3.42270527515625*^9, 3.42276902325*^9, 
  3.4857514007068644`*^9, 3.485752115286233*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"hs78b.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "hs78b.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270527515625*^9, 3.42276902325*^9, 
  3.4857514007068644`*^9, 3.485752115301858*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Mineral", ",", "\<\"Label\"\>", ",", "SiO2", ",", "Al2O3", ",", "TiO2", 
     ",", "MgO", ",", "FeO", ",", "MnO", ",", "CaO", ",", "Na2O", ",", "K2O", 
     ",", "Total"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "bt", ",", "\<\"1\"\>", ",", "2.745`", ",", "1.759`", ",", "0.081`", 
       ",", "1.131`", ",", "1.16`", ",", "0.008`", ",", "0.009`", ",", 
       "0.041`", ",", "0.762`", ",", "94.28`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"Al(IV)\"\>", ",", "\<\"Al(VI)\"\>", 
             ",", "\<\"SumCat\"\>", ",", "\<\"SumOk\"\>", 
             ",", "\<\"SumA\"\>"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "1.25515`", ",", "0.50358`", ",", "7.69595`", ",", "2.88412`", 
             ",", "0.81183`"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", "\<\"XK\"\>", "}"}], ",", 
             RowBox[{"{", 
              
              RowBox[{"\<\"XMgM\"\>", ",", "\<\"XFeM\"\>", 
               ",", "\<\"XTiM\"\>", ",", "\<\"XAlM\"\>"}], "}"}], ",", 
             RowBox[{"{", "\<\"XOH\"\>", "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", "0.93847`", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "0.39231`", ",", "0.40223`", ",", "0.02819`", ",", "0.1746`"}], 
              "}"}], ",", 
             RowBox[{"{", "1.`", "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
      "wm", ",", "\<\"2\"\>", ",", "3.12`", ",", "2.775`", ",", "0.021`", ",",
        "0.047`", ",", "0.041`", ",", "0.`", ",", "0.005`", ",", "0.227`", 
       ",", "0.695`", ",", "95.12`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"Al(IV)\"\>", ",", "\<\"Al(VI)\"\>", 
             ",", "\<\"SumCat\"\>", ",", "\<\"SumOk\"\>", 
             ",", "\<\"SumA\"\>"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "0.87958`", ",", "1.89589`", ",", "6.93144`", ",", "2.00482`", 
             ",", "0.92661`"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\<\"XK\"\>", ",", "\<\"XNa\"\>", ",", "\<\"XCa\"\>"}], 
              "}"}], ",", 
             RowBox[{"{", 
              
              RowBox[{"\<\"XAlM\"\>", ",", "\<\"XFeM\"\>", 
               ",", "\<\"XMgM\"\>"}], "}"}], ",", 
             RowBox[{"{", "\<\"XOH\"\>", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\<\"XAlT\"\>", ",", "\<\"XSiT\"\>"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.75396`", ",", "0.24604`", ",", "0.00532`"}], "}"}], 
             ",", 
             RowBox[{"{", 
              RowBox[{"0.94567`", ",", "0.02028`", ",", "0.02345`"}], "}"}], 
             ",", 
             RowBox[{"{", "1.`", "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.21989`", ",", "0.78011`"}], "}"}]}], "}"}]}], 
          "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "grt", ",", "\<\"3r\"\>", ",", "3.034`", ",", "2.028`", ",", "0.`", ",",
        "0.27`", ",", "2.224`", ",", "0.324`", ",", "0.073`", ",", "0.`", ",",
        "0.`", ",", "102.18`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            
            RowBox[{"\<\"SumCat\"\>", ",", "\<\"Sum(Fe+Mg+Ca+Mn)\"\>", 
             ",", "\<\"Fe3\"\>", ",", "\<\"Fe3CalcMode\"\>"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
            "7.95248`", ",", "2.89116`", ",", "0.`", ",", "\<\"Droop\"\>"}], 
            "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              
              RowBox[{"\<\"XCa\"\>", ",", "\<\"XMg\"\>", ",", "\<\"XFe\"\>", 
               ",", "\<\"XMn\"\>"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"\<\"XAl\"\>", ",", "\<\"XFe3\"\>"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "0.02539`", ",", "0.09338`", ",", "0.76913`", ",", "0.11211`"}],
               "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1.`", ",", "0.`"}], "}"}]}], "}"}]}], "}"}]}], "}"}]}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "plag", ",", "\<\"4\"\>", ",", "2.875`", ",", "1.102`", ",", "0.`", ",",
        "0.`", ",", "0.`", ",", "0.`", ",", "0.125`", ",", "0.936`", ",", 
       "0.006`", ",", "100.11`", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "\<\"SumCat\"\>", "}"}], ",", 
           RowBox[{"{", "5.04508`", "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{"\<\"XNa\"\>", ",", "\<\"XCa\"\>", ",", "\<\"XK\"\>"}], 
             "}"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{"0.87693`", ",", "0.11728`", ",", "0.0058`"}], "}"}], 
            "}"}]}], "}"}]}], "}"}]}], "}"}]}], "}"}], 
   ",", "\<\"OxygenBasis\"\>", ",", "\<\"B88\"\>", 
   ",", "\<\"Date: {2010, 6, 17}\"\>"}], "}"}]], "Output",
 CellChangeTimes->{3.4227052751875*^9, 3.422769023296875*^9, 
  3.4857514007224894`*^9, 3.485752115301858*^9}]
}, Open  ]]
},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 2567, 64, 252, "Input"],
Cell[CellGroupData[{
Cell[3137, 88, 369, 10, 52, "Input"],
Cell[3509, 100, 12287, 165, 3926, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15833, 270, 929, 21, 92, "Input"],
Cell[16765, 293, 495, 11, 23, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17297, 309, 653, 15, 72, "Input"],
Cell[CellGroupData[{
Cell[17975, 328, 457, 10, 23, "Print"],
Cell[18435, 340, 252, 4, 23, "Print"],
Cell[18690, 346, 444, 10, 23, "Print"]
}, Open  ]],
Cell[19149, 359, 5853, 154, 221, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25039, 518, 1252, 30, 132, "Input"],
Cell[26294, 550, 415, 9, 23, "Print"],
Cell[26712, 561, 5822, 153, 221, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32571, 719, 1801, 48, 132, "Input"],
Cell[CellGroupData[{
Cell[34397, 771, 429, 9, 23, "Print"],
Cell[34829, 782, 222, 3, 23, "Print"],
Cell[35054, 787, 416, 9, 23, "Print"]
}, Open  ]],
Cell[35485, 799, 5789, 141, 277, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41311, 945, 624, 13, 72, "Input"],
Cell[41938, 960, 430, 9, 23, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42405, 974, 255, 6, 52, "Input"],
Cell[CellGroupData[{
Cell[42685, 984, 431, 9, 23, "Print"],
Cell[43119, 995, 196, 3, 23, "Print"],
Cell[43318, 1000, 414, 9, 23, "Print"]
}, Open  ]],
Cell[43747, 1012, 5824, 153, 221, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
