(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    436478,      12572]
NotebookOptionsPosition[    421118,      12128]
NotebookOutlinePosition[    421461,      12143]
CellTagsIndexPosition[    421418,      12140]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
        "This", " ", "notebook", " ", "contains", " ", "examples", " ", "for",
          " ", "the", " ", "PET"}], "-", "functions"}], ";"}], 
      "\[IndentingNewLine]", 
      RowBox[{"-", "CalcRea"}]}], "-", "               ", 
     RowBox[{
     "calculate", " ", "equilibrium", " ", "data", " ", "of", " ", 
      "reactions"}]}], ";", "\[IndentingNewLine]", " ", 
    RowBox[{
     RowBox[{"-", "Dgr"}], "-", "                   ", 
     RowBox[{"calculate", " ", "delta"}], "-", 
     RowBox[{"G", 
      RowBox[{"(", "R", ")"}], " ", "of", " ", "a", " ", "reaction"}]}], ";", 
    "\[IndentingNewLine]", " ", 
    RowBox[{
     RowBox[{"-", "PlotRea"}], "-", "               ", 
     RowBox[{"plot", " ", "calculated", " ", "reactions"}]}], ";", 
    "\[IndentingNewLine]", " ", 
    RowBox[{
     RowBox[{"-", "CalcReaIntersection"}], "-", "   ", 
     RowBox[{
     "calculate", " ", "the", " ", "intersection", " ", "of", " ", 
      "reactions"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"-", "MakeCompositionMatrix"}], "-", "  ", 
     RowBox[{
     "calculate", " ", "the", " ", "composition", " ", "matrix", " ", "of", 
      " ", "a", " ", "list", " ", "of", " ", "phase", " ", "components"}]}], 
    ";", " ", "\[IndentingNewLine]", " ", 
    RowBox[{
     RowBox[{"-", "MakeRea"}], "-", "               ", 
     RowBox[{"calculate", " ", "reaction", " ", "stoichiometries"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"-", "SelectRea"}], "-", "              ", 
     RowBox[{
     "select", " ", "specific", " ", "reactions", " ", "from", " ", "a", " ", 
      "total", " ", "list", " ", "of", " ", "reactions"}]}], ";"}], 
   "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"This", " ", "top"}], "-", 
    RowBox[{
    "cell", " ", "must", " ", "be", " ", "run", " ", "once", " ", "before", 
     " ", "any", " ", "example", " ", "can", " ", "be", " ", 
     RowBox[{"performed", "."}]}]}], "  ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Define", " ", "the", " ", "directory"}], ",", 
    RowBox[{
     RowBox[{"where", " ", "the", " ", "PET"}], "-", 
     RowBox[{"files", " ", "reside", " ", 
      RowBox[{"(", 
       RowBox[{"e", ".", "g", ".", " ", 
        RowBox[{"C", ":", 
         RowBox[{
          RowBox[{"\\", "Eigene"}], " ", 
          RowBox[{"Dateien", "\\", "Pet"}]}]}]}], ")"}], " ", "and", " ", 
      "load", " ", 
      RowBox[{"PET", "."}]}]}]}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{
    "$PetDirectory", "=", 
     "\"\<C:\\Dokumente und Einstellungen\\dachsedgar\\Eigene \
Dateien\\Pet\\Pet7.0\>\""}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "$PetDirectory", "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"DeclarePackage", "[", 
     RowBox[{"\"\<DEFDAT`\>\"", ",", 
      RowBox[{"{", "\"\<Dataset\>\"", "}"}]}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "->", " ", "B88"}], "]"}], ";"}], " "}]}]], "Input",
 CellChangeTimes->{
  3.422701486984375*^9, {3.4857521415989013`*^9, 3.4857521416614017`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "display", " ", "the", " ", "usage", " ", "for", " ", "the", " ", "PET"}],
     "-", "functions", " ", "-", "CalcRea", "-"}], "  ", "*)"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"CalcRea", "::", "usage"}], "\[IndentingNewLine]"}]}]], "Input"],

Cell[BoxData["\<\"CalcRea[rea] calculates equilibrium data of \
reactions.\\n<rea> is produced with -MakeRea- (see examples in PET_CalcRea.nb \
and MakeRea::usage).\\nThe following options are available with -CalcRea-:\\n\
\\nName           value                 meaning\\n\\nCalcReaMode -> PT \
(default)          P-T diagram (find equilibrium-T's of a reaction for given \
P's)\\n               TP                    P-T diagram (find equilibrium-P's \
of a reaction for given T's (in C))\\n               TXCO2                 \
T-X(CO2) diagram (find equilibrium-T's of a reaction for given X(CO2)'s and \
P)\\n               TXH2                  T-X(H2) diagram (find \
equilibrium-T's of a reaction for given X(H2)'s and P)\\n               \
TXH2logfO2            as TXH2, but convert calculated T-X(H2) data to \
corresponding logf(O2)-T data\\n               logfO2T               \
logf(O2)-T diagram (find equilibrium-logf(O2)'s of a reaction for given T's \
and P)\\nCalcReaMin ->  1000 (default)        Minimum value at which \
calculation starts:\\n                                                   in \
PT-mode: P(min) in bars\\n                                                   \
in TP-mode: T(min) in Celsius\\n                                              \
     in TXCO2-mode: X(CO2)min\\n                                              \
     in TXH2-mode: X(H2)min\\n                                                \
   in TXH2logfO2-mode: X(H2)min\\n                                            \
       in logfO2T-mode: T(min) in Celsius\\nCalcReaMax ->  10000 (default)    \
   Maximum value in calculation: in PT-mode: P(max) in bars\\n                \
                                   in TP-mode: T(max) in Celsius\\n           \
                                        in TXCO2-mode: X(CO2)max\\n           \
                                        in TXH2-mode: X(H2)max\\n             \
                                      in TXH2logfO2-mode: X(H2)max\\n         \
                                          in logfO2T-mode: T(max) in \
Celsius\\nSteps ->       10 (default)          number of steps between \
minimum and maximum value (including both) in the calculation\\nScreen ->     \
 ScreenYes (default)   print equilibrium data to the screen during \
calculation\\n               ScreenNo              don't print equilibrium \
data to the screen during calculation\\nSampleFile -> \\\"None\\\" (default)  \
     define a sample file to be used in the calculation\\nOutputFile -> \
\\\"None\\\" (default)       define an output file to which calculated data \
are written\\n\\nIf a sample file is specified, -CalcRea- uses the \
PET-function -Activity- to calculate activities\\nof phase components for \
that sample (see Activity::usage for more details).\\nFor equilibria with \
flat slopes, -CalcRea- in PT-mode may not find a solution in the range Pmin < \
P < Pmax.\\nUse the option CalcReaMode -> TP in this case.\\nData are saved \
to the file \\\"OutputFile.ptx\\\", if an output-file is specified.\\nData \
may be plotted with -PlotRea- and intersections of reactions may be \
calculated with -CalcReaIntersection-.\\nReturnValue:\\n{{{{reaction \
stoichiometry},{activities used},{list of P-T data}}},{info on dataset and \
sample file}}\\nExample:\\nphases = {mu, qz, san, ky, h2o};\\nrea = \
MakeRea[phases]\\nresult = CalcRea[rea]\\nReturnValue:\\n{{{{-1 mu, -1 qz, 1 \
h2o, 1 ky, 1 san},{a(mu)=1, a(qz)=1, a(h2o)=1, a(ky)=1, \
a(san)=1},\\n{{601.111,1000.},{642.39,2000.},{673.724,3000.},{701.018,4000.},{\
725.864,5000.},\\n{748.972,6000.},{770.734,7000.},{791.396,8000.},{811.126,\
9000.},{830.045,10000.}}}},\\n{Dataset -> B,SampleFile->None}}\\nFor further \
examples see PET_CalcRea.nb.\\nCalled from: User.\\nCalls: -Dgr-, -Activity-, \
-SaveRea-.\\nPackage name: DG.m\\nPET: Petrological Elementary Tools, (c) \
Edgar Dachs.\"\>"], "Output",
 CellChangeTimes->{{3.422701497484375*^9, 3.422701526296875*^9}, 
   3.422706370296875*^9, 3.422707065171875*^9, 3.4227690555*^9, 
   3.46096626609375*^9, 3.4854943585143085`*^9, 3.485751357986616*^9, 
   3.4857521512552133`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "  ", 
   RowBox[{
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", "    ", 
                    RowBox[{
                    "-", "CalcRea"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
    "-", "    ", 
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", "-"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], "  ",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "  ", 
   RowBox[{
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "-", "  ", "P"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
    "-", 
    RowBox[{"T", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"equilibria", "  ", "--"}], "--"}], "--"}], 
                    "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], 
               "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], "--"}],
        "--"}], "--"}]}], "-"}], "  ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Example", " ", "1"}], ":", " ", 
       RowBox[{
        RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
        "CalcRea", "-", " ", 
        RowBox[{
        "to", " ", "calculate", " ", "the", " ", "equilibrium", " ", 
         "\[IndentingNewLine]", "Mu"}], " ", "+", " ", "Qz"}]}], " ", "=", 
      " ", 
      RowBox[{"San", " ", "+", " ", "Ky", " ", "+", " ", 
       RowBox[{
       "H2O", " ", "for", " ", "pure", " ", "phase", " ", "components"}]}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
     "Change", " ", "the", " ", "default", " ", "settings", " ", "of", " ", 
      "the", " ", "options", " ", "CalcReaMin"}]}], ",", " ", 
    RowBox[{
     RowBox[{"CalcReaMax", " ", "and", " ", "Step", " ", "in"}], " ", "-", 
     "CalcRea", "-", " ", 
     RowBox[{
     "and", " ", "save", " ", "data", " ", "to", " ", "the", " ", "file", 
      " ", "\"\<test\>\""}]}]}], "  ", "*)"}], "\[IndentingNewLine]", " ", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phases", "=", 
     RowBox[{"{", 
      RowBox[{"mu", ",", "qz", ",", "san", ",", "ky", ",", "h2o"}], "}"}]}], 
    ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "define", " ", "phase", " ", "components", " ", "in", " ", "the", " ", 
     "list", " ", "\"\<phases\>\""}], "  ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"rea", "=", 
     RowBox[{"MakeRea", "[", "phases", "]"}]}], " ", ";"}], 
   "                       ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculate", " ", "the", " ", "reaction", " ", "stoichiometry", " ", 
     "relating", " ", "the", " ", "phase", " ", "components"}], " ", "*)"}], 
   "\n", 
   RowBox[{"result", "=", 
    RowBox[{"CalcRea", "[", 
     RowBox[{"rea", ",", 
      RowBox[{"CalcReaMin", "\[Rule]", "1000"}], ",", 
      RowBox[{"CalcReaMax", "\[Rule]", "3000"}], ",", 
      RowBox[{"Steps", "\[Rule]", "3"}], ",", 
      RowBox[{"OutputFile", "->", "\"\<test\>\""}]}], "]"}]}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422701534421875*^9, 3.4227063774375*^9, 
  3.422707082890625*^9, 3.4227690575625*^9, 3.4609662746875*^9, 
  3.485494360545493*^9, 3.4857513580178676`*^9, 3.4857521512864633`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "mu"}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
   RowBox[{"1.`", " ", "h2o"}], ",", 
   RowBox[{"1.`", " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "san"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422701534421875*^9, 3.4227063774375*^9, 
  3.422707082890625*^9, 3.4227690575625*^9, 3.4609662746875*^9, 
  3.485494360545493*^9, 3.4857513580178676`*^9, 3.4857521512864633`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1000", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "601.1112857310293`"}],
  SequenceForm[1000, " ", 601.1112857310293],
  Editable->False]], "Print",
 CellChangeTimes->{3.422701534421875*^9, 3.4227063774375*^9, 
  3.422707082890625*^9, 3.4227690575625*^9, 3.4609662746875*^9, 
  3.485494360545493*^9, 3.4857513580178676`*^9, 3.4857521513489637`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "642.3903229884412`"}],
  SequenceForm[2000., " ", 642.3903229884412],
  Editable->False]], "Print",
 CellChangeTimes->{3.422701534421875*^9, 3.4227063774375*^9, 
  3.422707082890625*^9, 3.4227690575625*^9, 3.4609662746875*^9, 
  3.485494360545493*^9, 3.4857513580178676`*^9, 3.485752151427089*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "3000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "673.7239813194511`"}],
  SequenceForm[3000., " ", 673.7239813194511],
  Editable->False]], "Print",
 CellChangeTimes->{3.422701534421875*^9, 3.4227063774375*^9, 
  3.422707082890625*^9, 3.4227690575625*^9, 3.4609662746875*^9, 
  3.485494360545493*^9, 3.4857513580178676`*^9, 3.4857521515520897`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Equilibrium data have been stored in the file \"\>", 
   "\[InvisibleSpace]", "\<\"test.ptx\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Equilibrium data have been stored in the file ", "test.ptx", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422701534421875*^9, 3.4227063774375*^9, 
  3.422707082890625*^9, 3.4227690575625*^9, 3.4609662746875*^9, 
  3.485494360545493*^9, 3.4857513580178676`*^9, 3.485752151567715*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1.`"}], " ", "mu"}], ",", 
        RowBox[{
         RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
        RowBox[{"1.`", " ", "h2o"}], ",", 
        RowBox[{"1.`", " ", "ky"}], ",", 
        RowBox[{"1.`", " ", "san"}]}], "}"}], 
      ",", "\<\"{a(mu)=1, a(qz)=1, a(h2o)=1, a(ky)=1, a(san)=1}\"\>", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"601.111`", ",", "1000.`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"642.39`", ",", "2000.`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"673.724`", ",", "3000.`"}], "}"}]}], "}"}]}], "}"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dataset -> B88\"\>", ",", "\<\"SampleFile->None\"\>"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.422701534546875*^9, 3.42270637775*^9, 
  3.42270708321875*^9, 3.42276905796875*^9, 3.460966275296875*^9, 
  3.4854943607642365`*^9, 3.4857513582366257`*^9, 3.485752151567715*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "2"}], ":", " ", 
     RowBox[{
      RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
      "CalcRea", "-", " ", 
      RowBox[{
      "to", " ", "calculate", " ", "the", " ", "equilibrium", " ", 
       "\[IndentingNewLine]", "Mu"}], " ", "+", " ", "Qz"}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{"San", " ", "+", " ", "Ky", " ", "+", " ", 
      RowBox[{"H2O", " ", "for", " ", "X", 
       RowBox[{"(", "H2O", ")"}]}]}], " ", "=", " ", 
     RowBox[{
      RowBox[{"0.9", " ", "assuming", " ", "a", " ", "H2O"}], "-", 
      RowBox[{"CO2", " ", "fluid"}]}]}]}], " ", "*)"}], " ", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phases", "=", 
     RowBox[{"{", 
      RowBox[{"mu", ",", "qz", ",", "san", ",", "ky", ",", "h2o"}], "}"}]}], 
    ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "define", " ", "phase", " ", "components", " ", "in", " ", "the", " ", 
     "list", " ", "\"\<phases\>\""}], "  ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"rea", "=", 
     RowBox[{"MakeRea", "[", "phases", "]"}]}], " ", ";"}], 
   "                       ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculate", " ", "the", " ", "reaction", " ", "stoichiometry", " ", 
     "relating", " ", "the", " ", "phase", " ", "components"}], " ", "*)"}], 
   "\n", 
   RowBox[{
    RowBox[{"rea", "=", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"rea", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "0.9", ",", "1", ",", "1"}], "}"}]}], 
       "}"}], "}"}]}], ";"}], "  ", 
   RowBox[{"(*", " ", 
    RowBox[{"append", " ", "the", " ", "activity", " ", "list", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0.9", ",", "1", ",", "1"}], "}"}], " ", 
     "to", " ", "rea"}], " ", "*)"}], "\n", 
   RowBox[{"result", "=", 
    RowBox[{"CalcRea", "[", "rea", "]"}]}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422701543953125*^9, 3.422706382171875*^9, 
  3.42270708434375*^9, 3.422769060171875*^9, 3.46096627709375*^9, 
  3.4854943628422947`*^9, 3.4857513582366257`*^9, 3.48575215158334*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "mu"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "san"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0.9`", ",", "1", ",", "1"}], "}"}]}], 
  "}"}]], "Print",
 CellChangeTimes->{3.422701543953125*^9, 3.422706382171875*^9, 
  3.42270708434375*^9, 3.422769060171875*^9, 3.46096627709375*^9, 
  3.4854943628422947`*^9, 3.4857513582366257`*^9, 3.485752151598965*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1000", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "591.0576130485683`"}],
  SequenceForm[1000, " ", 591.0576130485683],
  Editable->False]], "Print",
 CellChangeTimes->{3.422701543953125*^9, 3.422706382171875*^9, 
  3.42270708434375*^9, 3.422769060171875*^9, 3.46096627709375*^9, 
  3.4854943628422947`*^9, 3.4857513582366257`*^9, 3.4857521516614656`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "631.0168367460421`"}],
  SequenceForm[2000., " ", 631.0168367460421],
  Editable->False]], "Print",
 CellChangeTimes->{3.422701543953125*^9, 3.422706382171875*^9, 
  3.42270708434375*^9, 3.422769060171875*^9, 3.46096627709375*^9, 
  3.4854943628422947`*^9, 3.4857513582366257`*^9, 3.4857521517239656`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "3000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "661.3630217044288`"}],
  SequenceForm[3000., " ", 661.3630217044288],
  Editable->False]], "Print",
 CellChangeTimes->{3.422701543953125*^9, 3.422706382171875*^9, 
  3.42270708434375*^9, 3.422769060171875*^9, 3.46096627709375*^9, 
  3.4854943628422947`*^9, 3.4857513582366257`*^9, 3.4857521518333416`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "1.`"}], " ", "mu"}], ",", 
          RowBox[{
           RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
          RowBox[{"1.`", " ", "h2o"}], ",", 
          RowBox[{"1.`", " ", "ky"}], ",", 
          RowBox[{"1.`", " ", "san"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "0.9`", ",", "1", ",", "1"}], "}"}]}], 
       "}"}], ",", "\<\"{a(mu)=1, a(qz)=1, a(h2o)={FluidActivityModel -> \
KerrickJacobs81, FluidSystem -> H2OCO2}, a(ky)=1, a(san)=1}\"\>", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"591.058`", ",", "1000.`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"631.017`", ",", "2000.`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"661.363`", ",", "3000.`"}], "}"}]}], "}"}]}], "}"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dataset -> B88\"\>", ",", "\<\"SampleFile->None\"\>"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.422701544125*^9, 3.422706382484375*^9, 
  3.42270708465625*^9, 3.422769060484375*^9, 3.4609662773125*^9, 
  3.485494363076662*^9, 3.48575135847101*^9, 3.4857521518489666`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "3"}], ":", " ", 
     RowBox[{
      RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
      "CalcRea", "-", " ", 
      RowBox[{
      "to", " ", "calculate", " ", "the", " ", "equilibrium", " ", 
       "\[IndentingNewLine]", "Mu"}], " ", "+", " ", "Qz"}]}], " ", "=", " ", 
    RowBox[{"San", " ", "+", " ", "Ky", " ", "+", " ", 
     RowBox[{
     "H2O", " ", "\[IndentingNewLine]", "using", " ", "data", " ", "for", " ",
       "white", " ", "mica", " ", "from", " ", "sample", " ", "file", " ", 
      "\"\<hs78b\>\"", " ", "to", " ", "calculate", " ", "the", " ", 
      "activity", " ", "of", " ", "the", " ", "ms", " ", "phase"}], "-", 
     "component"}]}], "  ", "*)"}], " ", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phases", "=", 
     RowBox[{"{", 
      RowBox[{"mu", ",", "qz", ",", "san", ",", "ky", ",", "h2o"}], "}"}]}], 
    ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "define", " ", "phase", " ", "components", " ", "in", " ", "the", " ", 
     "list", " ", "\"\<phases\>\""}], "  ", "*)"}], "\n", 
   RowBox[{"rea", "=", 
    RowBox[{"MakeRea", "[", "phases", "]"}]}], "                      ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculate", " ", "the", " ", "reaction", " ", "stoichiometry", " ", 
     "relating", " ", "the", " ", "phase", " ", "components"}], " ", "*)"}], 
   "\n", 
   RowBox[{"result", "=", 
    RowBox[{"CalcRea", "[", 
     RowBox[{"rea", ",", 
      RowBox[{"SampleFile", "->", "\"\<hs78b\>\""}], ",", 
      RowBox[{"OutputFile", "->", "\"\<test\>\""}]}], "]"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1.`"}], " ", "mu"}], ",", 
    RowBox[{
     RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
    RowBox[{"1.`", " ", "h2o"}], ",", 
    RowBox[{"1.`", " ", "ky"}], ",", 
    RowBox[{"1.`", " ", "san"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.422701553890625*^9, 3.4227043391875*^9, 
  3.422706384796875*^9, 3.42270708571875*^9, 3.422769062484375*^9, 
  3.460966278921875*^9, 3.4854943652640924`*^9, 3.4857513584866357`*^9, 
  3.4857521518802176`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422701553890625*^9, 3.42270433925*^9, 3.4227063848125*^9,
   3.42270708571875*^9, 3.4227690625*^9, 3.4609662789375*^9, 
  3.4854943652797165`*^9, 3.485751358502261*^9, 3.4857521518958426`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "mu"}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
   RowBox[{"1.`", " ", "h2o"}], ",", 
   RowBox[{"1.`", " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "san"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422701553890625*^9, 3.42270433925*^9, 3.4227063848125*^9,
   3.42270708571875*^9, 3.4227690625*^9, 3.4609662789375*^9, 
  3.4854943652797165`*^9, 3.485751358502261*^9, 3.4857521519114676`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1000", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "635.9682032010318`"}],
  SequenceForm[1000, " ", 635.9682032010318],
  Editable->False]], "Print",
 CellChangeTimes->{3.422701553890625*^9, 3.42270433925*^9, 3.4227063848125*^9,
   3.42270708571875*^9, 3.4227690625*^9, 3.4609662789375*^9, 
  3.4854943652797165`*^9, 3.485751358502261*^9, 3.4857521519739676`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "683.6310893018466`"}],
  SequenceForm[2000., " ", 683.6310893018466],
  Editable->False]], "Print",
 CellChangeTimes->{3.422701553890625*^9, 3.42270433925*^9, 3.4227063848125*^9,
   3.42270708571875*^9, 3.4227690625*^9, 3.4609662789375*^9, 
  3.4854943652797165`*^9, 3.485751358502261*^9, 3.485752152036468*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "3000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "718.716564139044`"}],
  SequenceForm[3000., " ", 718.716564139044],
  Editable->False]], "Print",
 CellChangeTimes->{3.422701553890625*^9, 3.42270433925*^9, 3.4227063848125*^9,
   3.42270708571875*^9, 3.4227690625*^9, 3.4609662789375*^9, 
  3.4854943652797165`*^9, 3.485751358502261*^9, 3.4857521521145935`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Equilibrium data have been stored in the file \"\>", 
   "\[InvisibleSpace]", "\<\"test.ptx\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Equilibrium data have been stored in the file ", "test.ptx", "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422701553890625*^9, 3.42270433925*^9, 3.4227063848125*^9,
   3.42270708571875*^9, 3.4227690625*^9, 3.4609662789375*^9, 
  3.4854943652797165`*^9, 3.485751358502261*^9, 3.4857521521145935`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1.`"}], " ", "mu"}], ",", 
        RowBox[{
         RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
        RowBox[{"1.`", " ", "h2o"}], ",", 
        RowBox[{"1.`", " ", "ky"}], ",", 
        RowBox[{"1.`", " ", "san"}]}], "}"}], 
      ",", "\<\"{a(mu)=WmChatterjeeFroese, a(qz)=1, a(h2o)=1, a(ky)=1, \
a(san)=1}\"\>", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"635.968`", ",", "1000.`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"683.631`", ",", "2000.`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"718.717`", ",", "3000.`"}], "}"}]}], "}"}]}], "}"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dataset -> B88\"\>", ",", "\<\"SampleFile->hs78b\"\>"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.422701553890625*^9, 3.4227043391875*^9, 
  3.422706384796875*^9, 3.42270708571875*^9, 3.422769062484375*^9, 
  3.460966278921875*^9, 3.4854943652640924`*^9, 3.4857513584866357`*^9, 
  3.4857521521302185`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Example", " ", "4"}], ":", " ", 
      RowBox[{
       RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
       "CalcRea", "-", " ", 
       RowBox[{
       "to", " ", "calculate", " ", "the", " ", "equilibrium", " ", 
        "\[IndentingNewLine]", "Mu"}], " ", "+", " ", "Qz"}]}], " ", "=", " ", 
     RowBox[{"San", " ", "+", " ", "Ky", " ", "+", " ", 
      RowBox[{
      "H2O", " ", "\[IndentingNewLine]", "for", " ", "white", " ", "mica", 
       " ", "composition", " ", "from", " ", "sample", " ", "file", " ", 
       "\"\<hs78b\>\""}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Use", " ", "ideal"}], "-", 
     RowBox[{"activities", " ", "of", " ", "the", " ", "ms", " ", "phase"}], 
     "-", 
     RowBox[{"component", "."}]}]}], "  ", "*)"}], " ", "\[IndentingNewLine]",
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phases", "=", 
     RowBox[{"{", 
      RowBox[{"mu", ",", "qz", ",", "san", ",", "ky", ",", "h2o"}], "}"}]}], 
    ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "define", " ", "phase", " ", "components", " ", "in", " ", "the", " ", 
     "list", " ", "\"\<phases\>\""}], "  ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"rea", "=", 
     RowBox[{"MakeRea", "[", "phases", "]"}]}], ";"}], 
   "                        ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculate", " ", "the", " ", "reaction", " ", "stoichiometry", " ", 
     "relating", " ", "the", " ", "phase", " ", "components"}], " ", "*)"}], 
   "\n", 
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"ActivityHP", ",", 
      RowBox[{"ActivityMode", "\[Rule]", "IdealActivity"}]}], "]"}], ";", " ", 
    RowBox[{"SetOptions", "[", 
     RowBox[{"ActivityB", ",", 
      RowBox[{"ActivityMode", "\[Rule]", "IdealActivity"}]}], "]"}], ";"}], 
   " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"-", "ACTIVITB"}], "-", " ", 
     RowBox[{
     "is", " ", "the", " ", "PET", " ", "function", " ", "for", " ", 
      "activities", " ", "in", " ", "combination", " ", "with", " ", "Berman",
       " ", "data", " ", "set"}]}], " ", "*)"}], "\n", 
   RowBox[{"result", "=", 
    RowBox[{"CalcRea", "[", 
     RowBox[{"rea", ",", 
      RowBox[{"SampleFile", "->", "\"\<hs78b\>\""}]}], "]"}]}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422704367734375*^9, 3.42270638671875*^9, 
  3.4227070871875*^9, 3.42276906440625*^9, 3.4609662809375*^9, 
  3.485494367748388*^9, 3.485751358736645*^9, 3.4857521521458435`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "mu"}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
   RowBox[{"1.`", " ", "h2o"}], ",", 
   RowBox[{"1.`", " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "san"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422704367734375*^9, 3.42270638671875*^9, 
  3.4227070871875*^9, 3.42276906440625*^9, 3.4609662809375*^9, 
  3.485494367748388*^9, 3.485751358736645*^9, 3.4857521521614685`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1000", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "645.2728186095304`"}],
  SequenceForm[1000, " ", 645.2728186095304],
  Editable->False]], "Print",
 CellChangeTimes->{3.422704367734375*^9, 3.42270638671875*^9, 
  3.4227070871875*^9, 3.42276906440625*^9, 3.4609662809375*^9, 
  3.485494367748388*^9, 3.485751358736645*^9, 3.4857521522083445`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "695.745328340724`"}],
  SequenceForm[2000., " ", 695.745328340724],
  Editable->False]], "Print",
 CellChangeTimes->{3.422704367734375*^9, 3.42270638671875*^9, 
  3.4227070871875*^9, 3.42276906440625*^9, 3.4609662809375*^9, 
  3.485494367748388*^9, 3.485751358736645*^9, 3.4857521522708445`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "3000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "733.2722184705816`"}],
  SequenceForm[3000., " ", 733.2722184705816],
  Editable->False]], "Print",
 CellChangeTimes->{3.422704367734375*^9, 3.42270638671875*^9, 
  3.4227070871875*^9, 3.42276906440625*^9, 3.4609662809375*^9, 
  3.485494367748388*^9, 3.485751358736645*^9, 3.48575215234897*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1.`"}], " ", "mu"}], ",", 
        RowBox[{
         RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
        RowBox[{"1.`", " ", "h2o"}], ",", 
        RowBox[{"1.`", " ", "ky"}], ",", 
        RowBox[{"1.`", " ", "san"}]}], "}"}], 
      ",", "\<\"{a(mu)=Ideal, a(qz)=1, a(h2o)=1, a(ky)=1, a(san)=1}\"\>", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"645.273`", ",", "1000.`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"695.745`", ",", "2000.`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"733.272`", ",", "3000.`"}], "}"}]}], "}"}]}], "}"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dataset -> B88\"\>", ",", "\<\"SampleFile->hs78b\"\>"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.42270436884375*^9, 3.422706387015625*^9, 
  3.422707087484375*^9, 3.422769064703125*^9, 3.46096628115625*^9, 
  3.4854943679671307`*^9, 3.4857513589554033`*^9, 3.4857521523645954`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Example", " ", "5", 
    RowBox[{"a", ":", " ", 
     RowBox[{
      RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
      "CalcRea", "-", " ", 
      RowBox[{
      "to", " ", "calculate", " ", "the", " ", "Al2SiO5", " ", "phase", " ", 
       "diagram", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"only", " ", "stable", " ", "parts"}], ")"}], "."}]}]}]}]}], 
   " ", "*)"}], " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phases", "=", 
     RowBox[{"{", 
      RowBox[{"ky", ",", "sil", ",", "and"}], "}"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "define", " ", "phase", " ", "components", " ", "in", " ", "the", " ", 
     "list", " ", "\"\<phases\>\""}], "  ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "calculate", " ", "the", " ", "reaction", " ", "stoichiometry", " ", 
      "relating", " ", "the", " ", "phase", " ", 
      RowBox[{"components", ":", " ", 
       RowBox[{"use", " ", "option", " ", "MakeReaMode"}]}]}], "\[Rule]", 
     RowBox[{"1", " ", "to", " ", "find", " ", "all", " ", "reactions"}]}], 
    " ", "*)"}], "\n", "\n", 
   RowBox[{"rea", "=", 
    RowBox[{"MakeRea", "[", 
     RowBox[{"phases", ",", 
      RowBox[{"MakeReaMode", "\[Rule]", "1"}]}], "]"}]}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"result", "=", 
    RowBox[{"CalcRea", "[", 
     RowBox[{"rea", ",", 
      RowBox[{"CalcReaMode", "\[Rule]", "PT"}], ",", 
      RowBox[{"CalcReaMin", "\[Rule]", "1000"}], ",", 
      RowBox[{"CalcReaMax", "\[Rule]", "10000"}], ",", 
      RowBox[{"Steps", "\[Rule]", "10"}], ",", 
      RowBox[{"Screen", "\[Rule]", "ScreenNo"}]}], "]"}]}], 
   "\[IndentingNewLine]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating reactions with \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" phases\"\>"}],
  SequenceForm["Calculating reactions with ", 2, " phases"],
  Editable->False]], "Print",
 CellChangeTimes->{3.4227043748125*^9, 3.422706390234375*^9, 
  3.422707089453125*^9, 3.42276906596875*^9, 3.460966283109375*^9, 
  3.485494370045189*^9, 3.4857513589710293`*^9, 3.4857521523645954`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(degree of freedom =  \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" ): from combinatorics, there are \"\>", 
   "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" possible reactions.\"\>"}],
  SequenceForm[
  "(degree of freedom =  ", 1, " ): from combinatorics, there are ", 3, 
   " possible reactions."],
  Editable->False]], "Print",
 CellChangeTimes->{3.4227043748125*^9, 3.422706390234375*^9, 
  3.422707089453125*^9, 3.42276906596875*^9, 3.460966283109375*^9, 
  3.485494370045189*^9, 3.4857513589710293`*^9, 3.4857521523802204`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "and"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "sil"}], ",", 
     RowBox[{"1.`", " ", "and"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "sil"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.422704374828125*^9, 3.422706390265625*^9, 
  3.422707089484375*^9, 3.422769066*^9, 3.460966283234375*^9, 
  3.4854943700764384`*^9, 3.48575135900228*^9, 3.4857521523958454`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.4227043748125*^9, 3.422706390234375*^9, 
  3.422707089453125*^9, 3.42276906596875*^9, 3.460966283109375*^9, 
  3.485494370045189*^9, 3.4857513589710293`*^9, 3.4857521524114704`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "and"}]}], "}"}]], "Print",
 CellChangeTimes->{3.4227043748125*^9, 3.422706390234375*^9, 
  3.422707089453125*^9, 3.42276906596875*^9, 3.460966283109375*^9, 
  3.485494370045189*^9, 3.4857513589710293`*^9, 3.4857521524114704`*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.4227043748125*^9, 3.422706390234375*^9, 
  3.422707089453125*^9, 3.42276906596875*^9, 3.460966283109375*^9, 
  3.485494370045189*^9, 3.4857513589710293`*^9, 3.485752152473971*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "sil"}], ",", 
   RowBox[{"1.`", " ", "and"}]}], "}"}]], "Print",
 CellChangeTimes->{3.4227043748125*^9, 3.422706390234375*^9, 
  3.422707089453125*^9, 3.42276906596875*^9, 3.460966283109375*^9, 
  3.485494370045189*^9, 3.4857513589710293`*^9, 3.485752152489596*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.4227043748125*^9, 3.422706390234375*^9, 
  3.422707089453125*^9, 3.42276906596875*^9, 3.460966283109375*^9, 
  3.485494370045189*^9, 3.4857513589710293`*^9, 3.4857521525833464`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "sil"}]}], "}"}]], "Print",
 CellChangeTimes->{3.4227043748125*^9, 3.422706390234375*^9, 
  3.422707089453125*^9, 3.42276906596875*^9, 3.460966283109375*^9, 
  3.485494370045189*^9, 3.4857513589710293`*^9, 3.4857521525989714`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
         RowBox[{"1.`", " ", "and"}]}], "}"}], 
       ",", "\<\"{a(ky)=1, a(sil)=1}\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"279.168`", ",", "1000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"361.374`", ",", "2000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"444.225`", ",", "3000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"528.075`", ",", "4000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"613.347`", ",", "5000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"700.509`", ",", "6000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"790.078`", ",", "7000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"882.635`", ",", "8000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"978.848`", ",", "9000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1079.518`", ",", "10000.`"}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1.`"}], " ", "sil"}], ",", 
         RowBox[{"1.`", " ", "and"}]}], "}"}], 
       ",", "\<\"{a(ky)=1, a(sil)=1}\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"684.579`", ",", "1000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"614.832`", ",", "2000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"550.006`", ",", "3000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"489.964`", ",", "4000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"434.433`", ",", "5000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"383.049`", ",", "6000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"335.41`", ",", "7000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"291.102`", ",", "8000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"249.721`", ",", "9000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"210.883`", ",", "10000.`"}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
         RowBox[{"1.`", " ", "sil"}]}], "}"}], 
       ",", "\<\"{a(ky)=1, a(sil)=1}\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"381.636`", ",", "1000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"426.733`", ",", "2000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"472.119`", ",", "3000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"517.775`", ",", "4000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"563.684`", ",", "5000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"609.827`", ",", "6000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"656.188`", ",", "7000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"702.75`", ",", "8000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"749.497`", ",", "9000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"796.415`", ",", "10000.`"}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dataset -> B88\"\>", ",", "\<\"SampleFile->None\"\>"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.422704374828125*^9, 3.422706390265625*^9, 
  3.422707089484375*^9, 3.422769066*^9, 3.460966283234375*^9, 
  3.4854943700764384`*^9, 3.48575135900228*^9, 3.4857521526927223`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Example", " ", "5", "a", " ", 
    RowBox[{"continued", ":", " ", 
     RowBox[{
      RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
      "CalcReaIntersection", "-", 
      RowBox[{"to", " ", "calculate", " ", "the", " ", "intersections"}]}]}], 
    " ", "\[IndentingNewLine]", 
    RowBox[{
    "and", " ", "then", " ", "recalculate", " ", "each", " ", "reaction", " ",
      "and", " ", "plot", " ", "the", " ", 
     RowBox[{"result", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"i", " ", "=", " ", 
    RowBox[{"CalcReaIntersection", "[", "result", "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r1", "=", " ", 
     RowBox[{"CalcRea", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"rea", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", 
       RowBox[{"CalcReaMode", "\[Rule]", "PT"}], ",", 
       RowBox[{"CalcReaMin", "\[Rule]", "500"}], ",", 
       RowBox[{"CalcReaMax", "\[Rule]", 
        RowBox[{"i", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", 
       RowBox[{"Steps", "\[Rule]", "20"}], ",", 
       RowBox[{"Screen", "\[Rule]", "ScreenNo"}], ",", 
       RowBox[{"OutputFile", "->", "\"\<None\>\""}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r2", "=", " ", 
     RowBox[{"CalcRea", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"rea", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "}"}], ",", 
       RowBox[{"CalcReaMode", "\[Rule]", "TP"}], ",", 
       RowBox[{"CalcReaMin", "\[Rule]", 
        RowBox[{"i", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", 
       RowBox[{"CalcReaMax", "\[Rule]", "700"}], ",", 
       RowBox[{"Steps", "\[Rule]", "20"}], ",", 
       RowBox[{"Screen", "\[Rule]", "ScreenNo"}], ",", 
       RowBox[{"OutputFile", "->", "\"\<None\>\""}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r3", "=", " ", 
     RowBox[{"CalcRea", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"rea", "[", 
         RowBox[{"[", "3", "]"}], "]"}], "}"}], ",", 
       RowBox[{"CalcReaMode", "\[Rule]", "TP"}], ",", 
       RowBox[{"CalcReaMin", "\[Rule]", 
        RowBox[{"i", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", 
       RowBox[{"CalcReaMax", "\[Rule]", "700"}], ",", 
       RowBox[{"Steps", "\[Rule]", "20"}], ",", 
       RowBox[{"Screen", "\[Rule]", "ScreenNo"}], ",", 
       RowBox[{"OutputFile", "->", "\"\<None\>\""}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRea", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"r1", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"r2", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"r3", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3732.8080369709187`", ",", "505.5502745394668`", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3732.816309595069`", ",", "505.5509704578291`", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3732.8050013616644`", ",", "505.5504534773003`", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.422704383921875*^9, 3.422706392703125*^9, 
  3.422707091765625*^9, 3.422769068140625*^9, 3.46096628478125*^9, 
  3.4854943722013702`*^9, 3.485751359330418*^9, 3.4857521526927223`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.4227043839375*^9, 3.42270639271875*^9, 
  3.42270709178125*^9, 3.422769068140625*^9, 3.460966284796875*^9, 
  3.4854943722326193`*^9, 3.4857513593460436`*^9, 3.4857521527083473`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "and"}]}], "}"}]], "Print",
 CellChangeTimes->{3.4227043839375*^9, 3.42270639271875*^9, 
  3.42270709178125*^9, 3.422769068140625*^9, 3.460966284796875*^9, 
  3.4854943722326193`*^9, 3.4857513593460436`*^9, 3.4857521527395973`*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.4227043839375*^9, 3.42270639271875*^9, 
  3.42270709178125*^9, 3.422769068140625*^9, 3.460966284796875*^9, 
  3.4854943722326193`*^9, 3.4857513593460436`*^9, 3.4857521529114733`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "sil"}], ",", 
   RowBox[{"1.`", " ", "and"}]}], "}"}]], "Print",
 CellChangeTimes->{3.4227043839375*^9, 3.42270639271875*^9, 
  3.42270709178125*^9, 3.422769068140625*^9, 3.460966284796875*^9, 
  3.4854943722326193`*^9, 3.4857513593460436`*^9, 3.4857521529270988`*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.4227043839375*^9, 3.42270639271875*^9, 
  3.42270709178125*^9, 3.422769068140625*^9, 3.460966284796875*^9, 
  3.4854943722326193`*^9, 3.4857513593460436`*^9, 3.485752153130225*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "sil"}]}], "}"}]], "Print",
 CellChangeTimes->{3.4227043839375*^9, 3.42270639271875*^9, 
  3.42270709178125*^9, 3.422769068140625*^9, 3.460966284796875*^9, 
  3.4854943722326193`*^9, 3.4857513593460436`*^9, 3.48575215314585*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{{{{}, {}, 
      {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQzbFGJirleK4DAwg41Du4bfv890pLvkP5vvlS+h9b
HKJSrO/7LyxweFdjbxrn1OWw6uMl36SGQge2xqnO3ZP7Hc5/D368NL7IAaQ8
tmiSQ+vrwB1y9sUOv+qy9nyRmupw9gwQyJU4mMbt8uw5PN1BHqTgX4lDoS3X
deWcWQ7VIuvcH94rdagFGr9LZK6D+M1z34P3lznskAMq3DvfAShbJbKgHGKe
0UIHp4SnF5QaKxxm5Ak1O7Qvcjj8VSOmP6nSYd775ce6by92MAR5yKXKAejq
3uv6SyHyatUOIGOVW5Y5fFh+zNucswbsv/wbyyH2vKlxADljl85KBz7dTXPf
n691kNa/q8LWuMoha0/JZIktdRB1V1c7dDoCHTCj3iEMpFBzrQMA6MCY6Q==

        "]]}}, {{}, {}, 
      {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQzbFGJirleK4DAwg41Du4bfv890pLvkP5vvlS+h9b
HKJSrO/7LyxweFdjbxrn1OWw6uMl36SGQge2xqnO3ZP7Hc5/D368NL7IAaQ8
tmiSQ+vrwB1y9sUOv+qy9nyRmupw9gwQyJU4mMbt8uw5PN1BHqTgX4lDoS3X
deWcWQ7VIuvcH94rdagFGr9LZK6D+M1z34P3lznskAMq3DvfAShbJbKgHGKe
0UIHp4SnF5QaKxxm5Ak1O7Qvcjj8VSOmP6nSYd775ce6by92MAR5yKXKAejq
3uv6SyHyatUOIGOVW5Y5fFh+zNucswbsv/wbyyH2vKlxADljl85KBz7dTXPf
n691kNa/q8LWuMoha0/JZIktdRB1V1c7dDoCHTCj3iEMpFBzrQMA6MCY6Q==

        "]]}}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQffYMEMyod9hQlDFxreZah+YDpxa6yjU45AsBWRdW
O/y7UvFSraDB4ekFpduVNascpPXvqrAdanBg0m4Xm6mz0sG80zHhqXCjw6a5
75ezPVzuEPJ46ewjqY0OTglPLyyaucyh0Jbr+uLtjQ4ge3zCljq8Cdwh18rZ
BNEntsSBY41MVEp0k8NkCZYwv9uLHFTZGqc6r21yiOk/9DVj8UKwOUr/mxyy
9pRMlshf4BC3y5OHKbDZAeSMxpp5DjfPfQ9+vKjZ4friAtsuxTkO3zSAOr80
O4CkRc/OdAB5Y6FbC9h/b+umQ/TNaHF4V2Nves9sqoMPyCGvWhwOAr297csk
h+PeQAGbVrA/XHZMcAB5R6Gv1cHjYZXIOqZeBwYQeNAKMWd+hwMA+kiXWQ==

       "]]}}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQffYMEMyodyidLMEyTXOtQ/OBUwtd5RocpPXvqrC9
XOfw70rFS7WCBockgQjLL8EbIOKHGhyAWhkUjDc6mHc6JjwVbnTQ3TT3PbvQ
JoeQx0tnH0ltdJBkCeNb+2GTQ6Et1/XF2xsdQJTA+c0ObwJ3yLVyNjmsc39Y
ZbJ2iwPHGpmolOgmBybtdjHJ7q0OqmyNU53XNjnMyBNqPpCxzcEp4ekFpf9N
DiBhbbftDnG7PHmYApsdQMLRyjscbp77Hvx4UTPY/ACGnQ7fNGL6D31pdthQ
lDGR9+5OByGQh9xaHOYcUdgwaecuB5DzG2e0OFSLAF0wdbeDD8gDr1ocau1N
434V7nE47g0UsGl1kI1Ksb7vu9cB5B2FvlaHT5d8kyZo7gP7m+FBqwMf0MP8
rPsdAIfzjJ4=
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{250., 500.},
  DisplayFunction->Identity,
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.422704383921875*^9, 3.422706392703125*^9, 
  3.422707091765625*^9, 3.422769068140625*^9, 3.46096628478125*^9, 
  3.4854943722013702`*^9, 3.485751359330418*^9, 3.485752153302101*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Example", " ", "5", 
    RowBox[{"b", ":", " ", 
     RowBox[{
      RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
      "CalcRea", "-", " ", 
      RowBox[{
      "to", " ", "calculate", " ", "the", " ", "Al2SiO5", " ", "phase", " ", 
       RowBox[{"diagram", ":", " ", 
        RowBox[{
        "Compare", " ", "the", " ", "three", " ", "data", " ", 
         "sets"}]}]}]}]}]}], " ", "*)"}], " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phases", "=", 
     RowBox[{"{", 
      RowBox[{"ky", ",", "sil", ",", "and"}], "}"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "define", " ", "phase", " ", "components", " ", "in", " ", "the", " ", 
     "list", " ", "\"\<phases\>\""}], "  ", "*)"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "calculate", " ", "the", " ", "reaction", " ", "stoichiometry", " ", 
      "relating", " ", "the", " ", "phase", " ", 
      RowBox[{"components", ":", " ", 
       RowBox[{"use", " ", "option", " ", "MakeReaMode"}]}]}], "\[Rule]", 
     RowBox[{"1", " ", "to", " ", "find", " ", "all", " ", "reactions"}]}], 
    " ", "*)"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"rea", "=", 
     RowBox[{"MakeRea", "[", 
      RowBox[{"phases", ",", 
       RowBox[{"MakeReaMode", "\[Rule]", "1"}]}], "]"}]}], " ", ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "\[Rule]", "B88"}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"result1", "=", 
     RowBox[{"CalcRea", "[", 
      RowBox[{"rea", ",", 
       RowBox[{"CalcReaMode", "\[Rule]", "PT"}], ",", 
       RowBox[{"CalcReaMin", "\[Rule]", "1000"}], ",", 
       RowBox[{"CalcReaMax", "\[Rule]", "10000"}], ",", 
       RowBox[{"Steps", "\[Rule]", "10"}], ",", 
       RowBox[{"Screen", "\[Rule]", "ScreenNo"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "\[Rule]", "HP32"}], "]"}], ";"}], "  ", "\n", 
   RowBox[{
    RowBox[{"result2", "=", 
     RowBox[{"CalcRea", "[", 
      RowBox[{"rea", ",", 
       RowBox[{"CalcReaMode", "\[Rule]", "PT"}], ",", 
       RowBox[{"CalcReaMin", "\[Rule]", "1000"}], ",", 
       RowBox[{"CalcReaMax", "\[Rule]", "10000"}], ",", 
       RowBox[{"Steps", "\[Rule]", "10"}], ",", 
       RowBox[{"Screen", "\[Rule]", "ScreenNo"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "\[Rule]", "G97"}], "]"}], ";"}], "  ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"result3", "=", 
     RowBox[{"CalcRea", "[", 
      RowBox[{"rea", ",", 
       RowBox[{"CalcReaMode", "\[Rule]", "PT"}], ",", 
       RowBox[{"CalcReaMin", "\[Rule]", "1000"}], ",", 
       RowBox[{"CalcReaMax", "\[Rule]", "10000"}], ",", 
       RowBox[{"Steps", "\[Rule]", "10"}], ",", 
       RowBox[{"Screen", "\[Rule]", "ScreenNo"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"PlotRea", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"result1", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"result2", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"result3", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating reactions with \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" phases\"\>"}],
  SequenceForm["Calculating reactions with ", 2, " phases"],
  Editable->False]], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752153348976*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(degree of freedom =  \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" ): from combinatorics, there are \"\>", 
   "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" possible reactions.\"\>"}],
  SequenceForm[
  "(degree of freedom =  ", 1, " ): from combinatorics, there are ", 3, 
   " possible reactions."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752153348976*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752153380227*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "and"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752153380227*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752153442727*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "sil"}], ",", 
   RowBox[{"1.`", " ", "and"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752153458352*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752153552103*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "sil"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752153567728*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752153645853*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "and"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752153661478*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752153770854*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "sil"}], ",", 
   RowBox[{"1.`", " ", "and"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752153770854*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752153864605*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "sil"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.48575215388023*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.4857521539739804`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "and"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752153989606*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752154161482*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "sil"}], ",", 
   RowBox[{"1.`", " ", "and"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752154177107*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752154302108*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "sil"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422704426015625*^9, 3.4227071035*^9, 3.42276907121875*^9,
   3.46096628778125*^9, 3.485494378435546*^9, 3.485751359955442*^9, 
  3.485752154317733*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{{{{{{{{{{}, {}, 
            {Hue[0.67, 0.6, 0.6], 
             LineBox[{{279.168, 1000.}, {361.374, 2000.}, {444.225, 3000.}, {
              528.075, 4000.}, {613.347, 5000.}, {700.509, 6000.}, {790.078, 
              7000.}, {882.635, 8000.}, {978.848, 9000.}, {1079.518, 
              10000.}}]}}, {{}, {}, 
            {Hue[0.67, 0.6, 0.6], 
             LineBox[{{279.168, 1000.}, {361.374, 2000.}, {444.225, 3000.}, {
              528.075, 4000.}, {613.347, 5000.}, {700.509, 6000.}, {790.078, 
              7000.}, {882.635, 8000.}, {978.848, 9000.}, {1079.518, 
              10000.}}]}}}, {{}, {}, 
           {Hue[0.67, 0.6, 0.6], 
            LineBox[{{684.579, 1000.}, {614.832, 2000.}, {550.006, 3000.}, {
             489.964, 4000.}, {434.433, 5000.}, {383.049, 6000.}, {335.41, 
             7000.}, {291.102, 8000.}, {249.721, 9000.}, {210.883, 
             10000.}}]}}}, {{}, {}, 
          {Hue[0.67, 0.6, 0.6], 
           LineBox[{{381.636, 1000.}, {426.733, 2000.}, {472.119, 3000.}, {
            517.775, 4000.}, {563.684, 5000.}, {609.827, 6000.}, {656.188, 
            7000.}, {702.75, 8000.}, {749.497, 9000.}, {796.415, 
            10000.}}]}}}, {{}, {}, 
         {Hue[0.67, 0.6, 0.6], 
          LineBox[{{277.582, 1000.}, {357.558, 2000.}, {438.269, 3000.}, {
           519.782, 4000.}, {602.125, 5000.}, {685.305, 6000.}, {769.319, 
           7000.}, {854.156, 8000.}, {939.799, 9000.}, {1026.228, 
           10000.}}]}}}, {{}, {}, 
        {Hue[0.67, 0.6, 0.6], 
         LineBox[{{703.886, 1000.}, {631.435, 2000.}, {562.465, 3000.}, {
          496.941, 4000.}, {434.767, 5000.}, {375.794, 6000.}, {319.823, 
          7000.}, {266.616, 8000.}, {215.885, 9000.}, {167.278, 
          10000.}}]}}}, {{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{372.932, 1000.}, {420.193, 2000.}, {467.331, 3000.}, {
         514.312, 4000.}, {561.098, 5000.}, {607.658, 6000.}, {653.957, 
         7000.}, {699.967, 8000.}, {745.66, 9000.}, {791.014, 
         10000.}}]}}}, {{}, {}, 
      {Hue[0.67, 0.6, 0.6], 
       LineBox[{{269.746, 1000.}, {354.857, 2000.}, {440.755, 3000.}, {527.5, 
        4000.}, {615.107, 5000.}, {703.567, 6000.}, {792.86, 7000.}, {882.956,
         8000.}, {973.825, 9000.}, {1065.434, 10000.}}]}}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{709.598, 1000.}, {644.469, 2000.}, {583.305, 3000.}, {525.762,
        4000.}, {471.535, 5000.}, {420.344, 6000.}, {371.934, 7000.}, {326.07,
        8000.}, {282.531, 9000.}, {241.107, 10000.}}]}}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{390.438, 1000.}, {435.921, 2000.}, {481.447, 3000.}, {526.994, 
      4000.}, {572.54, 5000.}, {618.06, 6000.}, {663.53, 7000.}, {708.927, 
      8000.}, {754.229, 9000.}, {799.416, 10000.}}]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{400., 0},
  DisplayFunction->Identity,
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.422704427375*^9, 3.422707104875*^9, 3.42276907259375*^9, 
  3.460966288875*^9, 3.4854943794823875`*^9, 3.4857513610023575`*^9, 
  3.485752154442734*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "6"}], ":", " ", 
     RowBox[{
      RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
      "CalcRea", "-", " ", 
      RowBox[{"to", " ", "calculate", " ", "the", " ", "grt"}], "-", 
      RowBox[{
      "bt", " ", "and", " ", "GASP", " ", "equilibrium", " ", "for", " ", 
       "sample", " ", "\"\<hs78b\>\""}]}]}], ";", " ", "\[IndentingNewLine]", 
    RowBox[{"Use", " ", "-", "PlotRea", "-", " ", 
     RowBox[{"to", " ", "plot", " ", "the", " ", "reactions", " ", "and"}], 
     " ", "-", "CalcReaIntersection", "-", " ", 
     RowBox[{"to", " ", "calculate", " ", "their", " ", "intersection"}]}], 
    ";", " ", 
    RowBox[{
    "First", " ", "apply", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"CalcFormula", "[", "\"\<hs78b\>\"", "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{
    "to", " ", "calculate", " ", "the", " ", "mineral", " ", "formulae", " ", 
     "for", " ", "\"\<hs78b\>\"", " ", 
     RowBox[{"(", 
      RowBox[{
      "this", " ", "also", " ", "creates", " ", "the", " ", "file", " ", 
       "\"\<hs78b.oxi); \nThen in Windows Explorer run CMP.EXE and use \
hs78b.oxi as data file (this creates the TWEEQ-file \>\"", 
       RowBox[{"hs78b", ".", "cmp"}], 
       "\"\<);\nFor unknown reasons CMP.EXE does not produce mole fractions \
for the plag in \>\"", "hs78b", 
       "\"\<, but writes **** for PLAG:\n\nBIOT \
[xMg-][xFe-][-xTi][-xAl][-xK-][-xOH]\nBIOT .3922 .4022 .0282 .1747 \
0.76181.0000\nMICA [-xK-][-xNa][xAl-][-xOH]\nMICA .7539 .2461 .9457 1.0000\n\
GARN [-Gr-][-Py-][-Alm][-Sp-]\nGARN .0254 .0934 .7691 .1121\nPLAG \
[-An-][-Ab-][-Or-]\nPLAG ************.0000\n\nAs can be seen from the file \>\
\"", 
       RowBox[{"hs78b", ".", "fu"}], 
       "\"\< (formula units created by -CalcFormula-): X(An) = 0.1173, X(Ab) \
= 0.8769.\nCorrect these data manually in the file \>\"", 
       RowBox[{"hs78b", ".", "cmp"}], 
       "\"\< as shown below:\nPLAG [-An-][-Ab-][-Or-]\nPLAG .1173 .8769 .0000\
\n\n-CalcRea- reads these data for activity calculations; \nThe use of \
CMP.EXE helps maintaining consistency between cation recalculation and \
thermodynamic data set;\n\>"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "\[Rule]", "B88"}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"CalcFormula", "[", "\"\<hs78b\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"phases", "=", 
     RowBox[{"{", 
      RowBox[{
      "ann", ",", "phl", ",", "alm", ",", "py", ",", "gr", ",", "an", ",", 
       "ky", ",", "qz"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"rea", "=", 
     RowBox[{"MakeRea", "[", "phases", "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"ActivityB", ",", 
      RowBox[{"ActivityMode", "\[Rule]", "RealActivity"}]}], "]"}], ";", 
    RowBox[{"SetOptions", "[", 
     RowBox[{"ActivityHP", ",", 
      RowBox[{"ActivityMode", "\[Rule]", "RealActivity"}]}], "]"}], ";"}], 
   "\n", 
   RowBox[{"result", "=", 
    RowBox[{"CalcRea", "[", 
     RowBox[{"rea", ",", 
      RowBox[{"CalcReaMin", "\[Rule]", "1000"}], ",", 
      RowBox[{"CalcReaMax", "\[Rule]", "10000"}], ",", 
      RowBox[{"Steps", "\[Rule]", "10"}], ",", 
      RowBox[{"CalcReaMode", "\[Rule]", "PT"}], ",", 
      RowBox[{"SampleFile", "\[Rule]", "\"\<hs78b\>\""}]}], "]"}]}], "\n", 
   RowBox[{"PlotRea", "[", "result", "]"}], "\n", 
   RowBox[{"CalcReaIntersection", "[", "result", "]"}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula- (PET -> TWEEQ interface): creating \
file \\\"\"\>", "\[InvisibleSpace]", "\<\"hs78b.oxi\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula- (PET -> TWEEQ interface): creating file \"", 
   "hs78b.oxi\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.485752154473984*^9}],

Cell[BoxData["\<\"Use Cmp.exe to create a *.cmp file for further calculations \
with PET or TWEEQ.\"\>"], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.485752154489609*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"hs78b.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "hs78b.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.485752154505234*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.485752154505234*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "an"}], ",", 
   RowBox[{"1.`", " ", "gr"}], ",", 
   RowBox[{"2.`", " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "qz"}]}], "}"}]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.485752154520859*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1000", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "328.542872675435`"}],
  SequenceForm[1000, " ", 328.542872675435],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.485752154520859*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "379.69285387233947`"}],
  SequenceForm[2000., " ", 379.69285387233947`],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.4857521545521092`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "3000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "430.7195090800434`"}],
  SequenceForm[3000., " ", 430.7195090800434],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.4857521545833597`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "481.58758481762095`"}],
  SequenceForm[4000., " ", 481.58758481762095`],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.4857521545989847`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "5000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "532.2597766931881`"}],
  SequenceForm[5000., " ", 532.2597766931881],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.4857521546146097`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "6000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "582.7001055909694`"}],
  SequenceForm[6000., " ", 582.7001055909694],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.4857521546302347`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "7000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "632.875725465037`"}],
  SequenceForm[7000., " ", 632.875725465037],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.4857521546458597`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "8000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "682.7577716661019`"}],
  SequenceForm[8000., " ", 682.7577716661019],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.4857521546771097`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "9000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "732.3216281641032`"}],
  SequenceForm[9000., " ", 732.3216281641032],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.485752154692735*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "10000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "781.5468522930834`"}],
  SequenceForm[10000., " ", 781.5468522930834],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.48575215470836*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.485752154723985*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "alm"}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "phl"}], ",", 
   RowBox[{"1.`", " ", "ann"}], ",", 
   RowBox[{"1.`", " ", "py"}]}], "}"}]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.485752154723985*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1000", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "464.9439365532061`"}],
  SequenceForm[1000, " ", 464.9439365532061],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.4857521547552357`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "2000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "469.8231037828241`"}],
  SequenceForm[2000., " ", 469.8231037828241],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.4857521547708607`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "3000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "474.68434775825233`"}],
  SequenceForm[3000., " ", 474.68434775825233`],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.4857521548021107`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "4000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "479.52765077270647`"}],
  SequenceForm[4000., " ", 479.52765077270647`],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.4857521548333607`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "5000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "484.3529970320717`"}],
  SequenceForm[5000., " ", 484.3529970320717],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.4857521548489857`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "6000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "489.1603726465348`"}],
  SequenceForm[6000., " ", 489.1603726465348],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.4857521548802366`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "7000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "493.9497656202842`"}],
  SequenceForm[7000., " ", 493.9497656202842],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.4857521549114866`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "8000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "498.7211658389882`"}],
  SequenceForm[8000., " ", 498.7211658389882],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.4857521549271116`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "9000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "503.4745650558116`"}],
  SequenceForm[9000., " ", 503.4745650558116],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.4857521549583616`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "10000.`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "508.20995687542165`"}],
  SequenceForm[10000., " ", 508.20995687542165`],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270711571875*^9, 3.422769074515625*^9, 
  3.46096629115625*^9, 3.4854943852322035`*^9, 3.4857513610336084`*^9, 
  3.485752154989612*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3.`"}], " ", "an"}], ",", 
         RowBox[{"1.`", " ", "gr"}], ",", 
         RowBox[{"2.`", " ", "ky"}], ",", 
         RowBox[{"1.`", " ", "qz"}]}], "}"}], 
       ",", "\<\"{a(alm)=GrtBerman, a(phl)=BtMcMullin, a(ann)=BtMcMullin, \
a(py)=GrtBerman}\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"328.543`", ",", "1000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"379.693`", ",", "2000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"430.72`", ",", "3000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"481.588`", ",", "4000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"532.26`", ",", "5000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"582.7`", ",", "6000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"632.876`", ",", "7000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"682.758`", ",", "8000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"732.322`", ",", "9000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"781.547`", ",", "10000.`"}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1.`"}], " ", "alm"}], ",", 
         RowBox[{
          RowBox[{"-", "1.`"}], " ", "phl"}], ",", 
         RowBox[{"1.`", " ", "ann"}], ",", 
         RowBox[{"1.`", " ", "py"}]}], "}"}], 
       ",", "\<\"{a(alm)=GrtBerman, a(phl)=BtMcMullin, a(ann)=BtMcMullin, \
a(py)=GrtBerman}\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"464.944`", ",", "1000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"469.823`", ",", "2000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"474.684`", ",", "3000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"479.528`", ",", "4000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"484.353`", ",", "5000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"489.16`", ",", "6000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"493.95`", ",", "7000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"498.721`", ",", "8000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"503.475`", ",", "9000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"508.21`", ",", "10000.`"}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dataset -> B88\"\>", ",", "\<\"SampleFile->hs78b\"\>"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.4227071164375*^9, 3.42276907521875*^9, 
  3.460966291703125*^9, 3.4854943857165627`*^9, 3.4857513615023766`*^9, 
  3.485752154989612*^9}],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{328.543, 1000.}, {379.693, 2000.}, {430.72, 3000.}, {481.588, 
       4000.}, {532.26, 5000.}, {582.7, 6000.}, {632.876, 7000.}, {682.758, 
       8000.}, {732.322, 9000.}, {781.547, 10000.}}]}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{328.543, 1000.}, {379.693, 2000.}, {430.72, 3000.}, {481.588, 
       4000.}, {532.26, 5000.}, {582.7, 6000.}, {632.876, 7000.}, {682.758, 
       8000.}, {732.322, 9000.}, {781.547, 10000.}}]}}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{464.944, 1000.}, {469.823, 2000.}, {474.684, 3000.}, {479.528, 
      4000.}, {484.353, 5000.}, {489.16, 6000.}, {493.95, 7000.}, {498.721, 
      8000.}, {503.475, 9000.}, {508.21, 10000.}}]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{400., 0},
  DisplayFunction->Identity,
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.4227071164375*^9, 3.42276907521875*^9, 
  3.460966291703125*^9, 3.4854943857165627`*^9, 3.4857513615023766`*^9, 
  3.485752155005237*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"3955.1639647760044`", ",", "479.31120646173065`", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.4227071164375*^9, 3.42276907521875*^9, 
  3.460966291703125*^9, 3.4854943857165627`*^9, 3.4857513615023766`*^9, 
  3.485752155005237*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Example", " ", "7"}], ":", " ", 
      RowBox[{
       RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
       "Dgr", "-", " ", 
       RowBox[{"to", " ", "calculate", " ", "delta"}], "-", 
       RowBox[{"G", 
        RowBox[{"(", "R", ")"}], " ", "of", " ", "the", " ", 
        RowBox[{"reaction", ":", "\[IndentingNewLine]", 
         RowBox[{"3", " ", "An"}]}]}]}]}], " ", "=", " ", 
     RowBox[{
      RowBox[{"Gr", " ", "+", " ", 
       RowBox[{"2", " ", "Ky"}], " ", "+", " ", 
       RowBox[{"Qz", " ", "for", " ", "P"}]}], " ", "=", " ", 
      RowBox[{"10", " ", "kbar"}]}]}], ",", " ", 
    RowBox[{"T", " ", "=", " ", 
     RowBox[{"800", " ", 
      RowBox[{"K", "."}]}]}]}], "   ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phases", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"gr", ",", "an", ",", "ky", ",", "qz"}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rea", " ", "=", 
     RowBox[{"MakeRea", "[", "phases", "]"}]}], ";"}], "          ", 
   "\[IndentingNewLine]", 
   RowBox[{"Dgr", "[", 
    RowBox[{
     RowBox[{"rea", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", "10000", ",", "800", ",", 
     "\"\<None\>\""}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1906.649477102561`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3.`"}], " ", "an"}], ",", 
       RowBox[{"1.`", " ", "gr"}], ",", 
       RowBox[{"2.`", " ", "ky"}], ",", 
       RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\<\"a(an)=1\"\>", ",", "\<\"a(gr)=1\"\>", 
       ",", "\<\"a(ky)=1\"\>", ",", "\<\"a(qz)=1\"\>"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.42270713009375*^9, 3.422769077359375*^9, 
  3.460966294078125*^9, 3.485494388028989*^9, 3.4857513615336275`*^9, 
  3.4857521550989876`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "8"}], ":", " ", 
     RowBox[{
      RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
      "Dgr", "-", " ", 
      RowBox[{"to", " ", "plot", " ", "delta"}], "-", 
      RowBox[{"G", 
       RowBox[{"(", "R", ")"}], " ", "of", " ", "the", " ", 
       RowBox[{"reaction", ":", "\[IndentingNewLine]", 
        RowBox[{"3", " ", "An"}]}]}]}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{"Gr", " ", "+", " ", 
      RowBox[{"2", " ", "Ky"}], " ", "+", " ", 
      RowBox[{"Qz", " ", "as", " ", "function", " ", "of", " ", "T", 
       RowBox[{"(", "K", ")"}], " ", "for", " ", "P"}]}], " ", "=", " ", 
     RowBox[{"10", " ", 
      RowBox[{"kbar", "."}]}]}]}], "  ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phases", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"gr", ",", "an", ",", "ky", ",", "qz"}], "}"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "define", " ", "phase", " ", "components", " ", "in", " ", "the", " ", 
     "list", " ", "phases"}], "  ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rea", " ", "=", 
     RowBox[{"MakeRea", "[", "phases", "]"}]}], " ", ";"}], "           ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculate", " ", "the", " ", "reaction", " ", "stoichiometry", " ", 
     "relating", " ", "the", " ", "phase", " ", "components"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Dgr", "[", 
       RowBox[{
        RowBox[{"rea", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", "10000", ",", "t", ",", 
        "\"\<None\>\""}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "500", ",", "1000"}], "}"}]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVkns01GkYx3+kRrHdKDZWJi25hcIg6nErKqnmzOk4iVFrZdfkqI5zHDJj
zIxcZqaShJZx54hmk0tFvXJZpTXjlsX81oxx3M50sW3I1uy++8d7nvM5n+/7
PP98qefjT0frEgQRgt//09qqcQMBbIAa263RfWrkGi/Yc9WPDZaVhi01vWrk
9zTs8FwAG+TB0nOabjWKpBNceTAb0G0v6RWkRnfTQz5L6Gy44XX+J26TGq2f
np31jcF5ntt+SYkaaSrMu9NFbJA4FZiSV9ToobWATSHxPdcnB8PN1SjTPHxP
mT8HOMw3X55ETKH8Fq7QPBdzlPWGV/Uq9DDbZISi4oA8vy40nlAhj9mJV0K3
NJBLO5J5AUpUNOzYHs9LA8l9Mk1gN4ligx+c04xhbhp9/66BRAHLxcoxRy5I
TuXXCLwU6Ku7OdMqhQuQ3ZHOnBxHVG2vkDLABcvGv0adYsbQrjNrWo9YpgNz
ytyHpv8Hcp6v61phpQNStmvCpG9QrS6PHfAC+yzxzaQDI4homHfXbOYBsyXb
/fnkEHqhTL2390ceQADfhxIziG4c506rHvMAxX54FP1JjryPGtkuUvjAGdkn
k3rKEF02ZFYUzgd0aLWi7MRrFDRDNSitwxxFymvzXqIaXkmNr44AYKT9aGdZ
DzIOz95DZwiAY1BGm2/vRBHdepWoXADIkF+01qADGTXXy3pXsE+URbC821CV
x/SSQ1AGEC6mrvd6mlHg39cJ3TsZwNn0M7087lcUSjvXmrCA/Wuz5FqfakQz
fB7n43kdiCDZy5zBuyjr4klZuQgz0VWeVs1AC19DjZOnMMcZ1Bc15IHN9ySj
wTkTCG1t9LvblSAbKghM4WcCh/qYYfGLFBjG0y5Vw9jfdx34wbAZ5oT3CN9d
WcBhHQ02Yj6FGRHvWmJiFsCT0p39uQg6qKtLlO4sfH/7o/eBnUDxLrFw3ZEN
xOTqJ61LD9jPDfi1xWK2mBlK0PRC+O+Xg5tasgGdzrm1u6APVjz9tUGGOYA2
7vfvYfdDgkfpA4+zmPlRvbGFcmA827upU4qZNT8wu2UQDl+zO/VMT4j7d7Ei
gzsE2/obxdvomMdeqyPHh+FEVVwKpUYISrscU6fQNxC9uTGasSwE5nxYLq1u
FDIbY1yMA0VgmWufd4EYA9M/j9WxCkRA7FLZ8C+PA7+wnWo1JwLOYHG9sm8C
hn2oedx5EUimZ1tmBiZgt4qnP7WA8/btHZrRCeiyOf5e8laE+2QwvKKeAN2m
8TaLjyJQ5rt+3PxlAtiy5TM7tNhX5Jr5OiggSW+faIuxGNDiJaPSHAX0Vufp
JGwTA1O5uLH6lgJMj32+Kt8uBon2n/X1dxXQehOdFX8rBtCp1LZWKGDJItT2
m504nxY4JW9TwBXPuC59O7xPt/AW8VYBLxQy2kV7MSjXJQvWfVTAVs7+ut8c
8H+WMsnwswIe9qzeFDjh/Y9pkaZrSfhAz4zUcxODZaDRbufvSIBlzeAFdzHu
41ZjdysSxIUnD3fSMBffXuNtS8JelYkj10sMhAlVdcSNhFReskR1AO8zsJeF
HCCh32bSyNcHe7eWNrovCRZ9fhmSg5hZ3bVhR0hgXapa/fcQzqcy7kSGkPAf
mBRfHw==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{500., 0},
  PlotRange->{{500, 1000}, {-40539.15846712934, 30005.493550656945`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.422707139*^9, 3.422769081078125*^9, 3.46096629640625*^9, 
  3.485494392872584*^9, 3.485751361861765*^9, 3.4857521554114895`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "9"}], ":", " ", 
     RowBox[{
      RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
      "CalcRea", "-", " ", 
      RowBox[{"to", " ", "calculate", " ", "the", " ", 
       RowBox[{"reaction", ":", " ", 
        RowBox[{"3", " ", "An"}]}]}]}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{"Gr", " ", "+", " ", 
      RowBox[{"2", " ", "Ky"}], " ", "+", " ", 
      RowBox[{"Qz", " ", "\[IndentingNewLine]", "using", " ", "th", " ", 
       RowBox[{"option", ":", " ", "CalcReaMode"}]}]}], " ", "\[Rule]", " ", 
     RowBox[{"TP", " ", 
      RowBox[{"(", 
       RowBox[{
       "calculate", " ", "equilibrium", " ", "P", " ", "for", " ", "given", 
        " ", "T", 
        RowBox[{"(", "C", ")"}]}], " ", ")"}]}]}]}], " ", "*)"}], " ", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phases", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"gr", ",", "an", ",", "ky", ",", "qz"}], "}"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "define", " ", "phase", " ", "components", " ", "in", " ", "the", " ", 
     "list", " ", "phases"}], "  ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rea", " ", "=", 
     RowBox[{"MakeRea", "[", "phases", "]"}]}], ";"}], "            ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculate", " ", "the", " ", "reaction", " ", "stoichiometry", " ", 
     "relating", " ", "the", " ", "phase", " ", "components"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"result", " ", "=", " ", 
    RowBox[{"CalcRea", "[", 
     RowBox[{"rea", ",", 
      RowBox[{"CalcReaMode", "\[Rule]", "TP"}], ",", 
      RowBox[{"CalcReaMin", "\[Rule]", "500"}], ",", 
      RowBox[{"CalcReaMax", "\[Rule]", "700"}], ",", 
      RowBox[{"Steps", "\[Rule]", "21"}]}], "]"}]}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.48575215544274*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "an"}], ",", 
   RowBox[{"1.`", " ", "gr"}], ",", 
   RowBox[{"2.`", " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "qz"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.485752155458365*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "9704.617234099458`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "500.`"}],
  SequenceForm[9704.617234099458, " ", 500.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.48575215547399*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "9926.747345378877`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "510.`"}],
  SequenceForm[9926.747345378877, " ", 510.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.4857521554896154`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "10149.089575975457`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "520.`"}],
  SequenceForm[10149.089575975457`, " ", 520.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.4857521555052404`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "10371.650084379587`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "530.`"}],
  SequenceForm[10371.650084379587`, " ", 530.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.4857521555364904`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "10594.434990055812`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "540.`"}],
  SequenceForm[10594.434990055812`, " ", 540.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.4857521555521154`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "10817.450366218703`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "550.`"}],
  SequenceForm[10817.450366218703`, " ", 550.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.485752155583366*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "11040.702233492648`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "560.`"}],
  SequenceForm[11040.702233492648`, " ", 560.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.485752155598991*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "11264.196554385775`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "570.`"}],
  SequenceForm[11264.196554385775`, " ", 570.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.4857521556302414`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "11487.939228476562`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "580.`"}],
  SequenceForm[11487.939228476562`, " ", 580.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.4857521556458664`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "11711.936088256443`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "590.`"}],
  SequenceForm[11711.936088256443`, " ", 590.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.4857521556771164`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "11936.192895564136`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "600.`"}],
  SequenceForm[11936.192895564136`, " ", 600.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.4857521556927414`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "12160.715338542672`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "610.`"}],
  SequenceForm[12160.715338542672`, " ", 610.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.4857521557083664`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "12385.509029077763`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "620.`"}],
  SequenceForm[12385.509029077763`, " ", 620.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.485752155739617*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "12610.579500667975`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "630.`"}],
  SequenceForm[12610.579500667975`, " ", 630.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.4857521557552423`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "12835.932206672765`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "640.`"}],
  SequenceForm[12835.932206672765`, " ", 640.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.4857521557864923`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "13061.572518916648`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "650.`"}],
  SequenceForm[13061.572518916648`, " ", 650.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.4857521558021173`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "13287.505726601132`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "660.`"}],
  SequenceForm[13287.505726601132`, " ", 660.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.4857521558333673`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "13513.737035493596`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "670.`"}],
  SequenceForm[13513.737035493596`, " ", 670.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.4857521558489923`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "13740.271567374473`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "680.`"}],
  SequenceForm[13740.271567374473`, " ", 680.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.485752155880243*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "13967.114359700177`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "690.`"}],
  SequenceForm[13967.114359700177`, " ", 690.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.485752155895868*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "14194.27036547427`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "700.`"}],
  SequenceForm[14194.27036547427, " ", 700.],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707155875*^9, 3.422769082984375*^9, 
  3.460966298265625*^9, 3.4854943949975157`*^9, 3.4854944537770596`*^9, 
  3.4857513618930163`*^9, 3.485752155911493*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3.`"}], " ", "an"}], ",", 
        RowBox[{"1.`", " ", "gr"}], ",", 
        RowBox[{"2.`", " ", "ky"}], ",", 
        RowBox[{"1.`", " ", "qz"}]}], "}"}], 
      ",", "\<\"{a(an)=1, a(gr)=1, a(ky)=1, a(qz)=1}\"\>", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"500.`", ",", "9704.617`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"510.`", ",", "9926.747`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"520.`", ",", "10149.09`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"530.`", ",", "10371.65`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"540.`", ",", "10594.435`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"550.`", ",", "10817.45`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"560.`", ",", "11040.702`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"570.`", ",", "11264.197`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"580.`", ",", "11487.939`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"590.`", ",", "11711.936`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"600.`", ",", "11936.193`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"610.`", ",", "12160.715`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"620.`", ",", "12385.509`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"630.`", ",", "12610.58`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"640.`", ",", "12835.932`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"650.`", ",", "13061.573`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"660.`", ",", "13287.506`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"670.`", ",", "13513.737`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"680.`", ",", "13740.272`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"690.`", ",", "13967.114`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"700.`", ",", "14194.27`"}], "}"}]}], "}"}]}], "}"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dataset -> B88\"\>", ",", "\<\"SampleFile->None\"\>"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.42270715653125*^9, 3.422769083640625*^9, 
  3.460966298765625*^9, 3.4854943954974995`*^9, 3.4854944542770495`*^9, 
  3.48575136237741*^9, 3.4857521559271183`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "10", " ", 
      RowBox[{"(", 
       RowBox[{"for", " ", "Berman", " ", "data", " ", "set", " ", "only"}], 
       ")"}]}], ":", " ", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
      "Calculations", " ", "for", " ", "mafic", " ", "gneiss", " ", "sample", 
       " ", "MG"}], "-", "20"}]}], ",", " ", 
    RowBox[{
     RowBox[{"M\[ADoubleDot]der", " ", "et", " ", 
      RowBox[{"al", ".", " ", 
       RowBox[{"(", "1994", ")"}]}]}], ":", " ", 
     RowBox[{"Can", " ", "J", " ", "Earth", " ", "Sci"}]}], ",", " ", "31", 
    ",", " ", 
    RowBox[{
     RowBox[{"1134", "-", "1145"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
      "This", " ", "example", " ", "calculates", " ", "reactions", " ", 
       RowBox[{"(", "1", ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", "7", ")"}], " ", "cited", " ", "in", " ", "this", " ", 
       "paper", " ", "and", " ", "plots", " ", "Fig", ".3", " ", "of", " ", 
       "this", " ", "paper"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
     "See", " ", "example", " ", "11", " ", "how", " ", "to", " ", "modify", 
      " ", "this", " ", "raw", " ", "plot", " ", "in", " ", "order", " ", 
      "to", " ", "get", " ", "a", " ", "publication", " ", "ready", " ", 
      "figure"}], ";"}]}], "\[IndentingNewLine]", " ", "*)"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"sample", " ", "from", " ", "Percival", " ", 
     RowBox[{"(", "1983", ")"}]}], ":", " ", 
    RowBox[{
     RowBox[{"Am", " ", "Min", " ", "68"}], ":", " ", 
     RowBox[{"667", "-", "686"}]}]}], "  ", "*)"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "below", " ", "are", " ", "the", " ", "mineral", " ", "analyses", " ", 
      "for", " ", "phases", " ", "in", " ", "MG"}], "-", "20"}], ";", " ", 
    RowBox[{
    "copy", " ", "these", " ", "into", " ", "a", " ", "file", 
     "\[IndentingNewLine]", "and", " ", "calculate", " ", "the", " ", 
     "mineral", " ", "formulae", " ", "and", " ", "produce", " ", "a", " ", 
     "*", 
     RowBox[{".", "cmp"}], " ", "file", " ", 
     RowBox[{"(", 
      RowBox[{"see", " ", 
       RowBox[{"CalcFormula", "::", "usage"}]}], ")"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
    "Correct", " ", "the", " ", "plagioclase", " ", "data", " ", "in", " ", 
     "the", " ", "*", 
     RowBox[{".", "cmp"}], " ", "file", " ", "as", " ", "follows", " ", 
     RowBox[{"(", 
      RowBox[{"for", " ", "unknown", " ", "reasons", " ", 
       RowBox[{"CMP", ".", "EXE"}], " ", 
       RowBox[{"produces", " ", "**", "**"}], "*", " ", "for", " ", "plag"}], 
      ")"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"PLAG", " ", "[", 
        RowBox[{
         RowBox[{"-", "An"}], "-"}], "]"}], "[", 
       RowBox[{
        RowBox[{"-", "Ab"}], "-"}], "]"}], "[", 
      RowBox[{
       RowBox[{"-", "Or"}], "-"}], "]"}], "\n", " ", "PLAG", " ", ".3360", 
     " ", ".6640", " ", "0.0000"}]}], "   ", "\[IndentingNewLine]", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", "\[IndentingNewLine]", 
   RowBox[{
   "Label", " ", "Mineral", " ", "SiO2", " ", "TiO2", " ", "Al2O3", " ", 
    "Cr2O3", " ", "FeO", " ", "MnO", " ", "MgO", " ", "CaO", " ", "Na2O", " ",
     "K2O", "\n", "1", " ", "grt", " ", "38.01", " ", "0", " ", "20.99", " ", 
    "0.22", " ", "28.06", " ", "0.7", " ", "4.11", " ", "8.32", " ", "0.27", 
    " ", "0", "\n", "2", " ", "cpx", " ", "51.57", " ", "0.34", " ", "2.92", 
    " ", "0.21", " ", "11.81", " ", "0", " ", "11.34", " ", "22.65", " ", 
    "0.74", " ", "0.08", "\n", "3", " ", "opx", " ", "49.06", " ", "0.03", 
    " ", "4.75", " ", "0.34", " ", "31.2", " ", "0.81", " ", "13.35", " ", 
    "1.39", " ", "0.52", " ", "0", "\n", "4", " ", "amph", " ", "42.29", " ", 
    "2.03", " ", "12.98", " ", "0.08", " ", "18.43", " ", "0.17", " ", "9.28",
     " ", "11.41", " ", "1.95", " ", "0.69", "\n", "5", " ", "plag", " ", 
    "59.82", " ", "0", " ", "25.45", " ", "0", " ", "0", " ", "0", " ", "0", 
    " ", "7.04", " ", "7.69", " ", "0"}], "\[IndentingNewLine]", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "10"}], ":", " ", 
    RowBox[{"formula", " ", "calculation"}]}], "  ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"CalcFormula", "[", 
     RowBox[{"\"\<Pmg20\>\"", ",", 
      RowBox[{"CalcFormulaMode", "\[Rule]", 
       RowBox[{"{", "}"}]}]}], "]"}], ";"}], "\n"}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"Pmg20.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "Pmg20.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707169671875*^9, 3.422769087890625*^9, 
  3.46096630334375*^9, 3.4854944560426407`*^9, 3.485751362424287*^9, 
  3.4857521559896183`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Example", " ", "10", " ", 
    RowBox[{"continued", ":", " ", 
     RowBox[{"reaction", " ", "calculation"}]}]}], "  ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "->", " ", "B88"}], "]"}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"file", " ", "=", " ", "\"\<Pmg20\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"phases1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"ts", ",", "py", ",", "gr", ",", "qz", ",", "tr", ",", "an"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"phases2", "=", " ", 
     RowBox[{"{", 
      RowBox[{
      "tr", ",", "an", ",", "ab", ",", "qz", ",", "gr", ",", "py", ",", 
       "prg"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"phases3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"ts", ",", "di", ",", "qz", ",", "tr", ",", "an"}], "}"}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{"phases4", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"prg", ",", "di", ",", "qz", ",", "tr", ",", "an", ",", "ab"}], 
      "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"phases5", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"alm", ",", "py", ",", "tr", ",", "fact"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"phases6", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"alm", ",", "py", ",", "ts", ",", "fts"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"phases7", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"prg", ",", "fprg", ",", "alm", ",", "py"}], "}"}]}], ";"}], 
   "\n", 
   RowBox[{"rea1", " ", "=", " ", 
    RowBox[{"MakeRea", "[", "phases1", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"rea2", " ", "=", " ", 
    RowBox[{"MakeRea", "[", "phases2", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"rea3", " ", "=", " ", 
    RowBox[{"MakeRea", "[", "phases3", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"rea4", " ", "=", " ", 
    RowBox[{"MakeRea", "[", "phases4", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"rea5", " ", "=", " ", 
    RowBox[{"MakeRea", "[", "phases5", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"rea6", " ", "=", " ", 
    RowBox[{"MakeRea", "[", "phases6", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"rea7", " ", "=", " ", 
    RowBox[{"MakeRea", "[", "phases7", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r1", "=", 
     RowBox[{"CalcRea", "[", 
      RowBox[{"rea1", ",", 
       RowBox[{"CalcReaMode", "\[Rule]", "PT"}], ",", 
       RowBox[{"CalcReaMin", "\[Rule]", "5000"}], ",", 
       RowBox[{"CalcReaMax", "\[Rule]", "12000"}], ",", 
       RowBox[{"Steps", "\[Rule]", "8"}], ",", 
       RowBox[{"Screen", "\[Rule]", "ScreenNo"}], ",", 
       RowBox[{"SampleFile", "\[Rule]", "file"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"r2", "=", 
     RowBox[{"CalcRea", "[", 
      RowBox[{"rea2", ",", 
       RowBox[{"Screen", "\[Rule]", "ScreenNo"}], ",", 
       RowBox[{"SampleFile", "\[Rule]", "file"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"r3", "=", 
     RowBox[{"CalcRea", "[", 
      RowBox[{"rea3", ",", 
       RowBox[{"Screen", "\[Rule]", "ScreenNo"}], ",", 
       RowBox[{"SampleFile", "\[Rule]", "file"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"r4", "=", 
     RowBox[{"CalcRea", "[", 
      RowBox[{"rea4", ",", 
       RowBox[{"Screen", "\[Rule]", "ScreenNo"}], ",", 
       RowBox[{"SampleFile", "\[Rule]", "file"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"r5", "=", 
     RowBox[{"CalcRea", "[", 
      RowBox[{"rea5", ",", 
       RowBox[{"Screen", "\[Rule]", "ScreenNo"}], ",", 
       RowBox[{"SampleFile", "\[Rule]", "file"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"r6", "=", 
     RowBox[{"CalcRea", "[", 
      RowBox[{"rea6", ",", 
       RowBox[{"Screen", "\[Rule]", "ScreenNo"}], ",", 
       RowBox[{"SampleFile", "\[Rule]", "file"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"r7", "=", 
     RowBox[{"CalcRea", "[", 
      RowBox[{"rea7", ",", 
       RowBox[{"Screen", "\[Rule]", "ScreenNo"}], ",", 
       RowBox[{"SampleFile", "\[Rule]", "file"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"plot", "=", 
     RowBox[{"PlotRea", "[", 
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"r1", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{"r2", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{"r3", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{"r4", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{"r5", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{"r6", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{"r7", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"plot", ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"500", ",", "1000"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5000", ",", "12000"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
    RowBox[{
     RowBox[{"-", "2.`"}], " ", "py"}], ",", 
    RowBox[{
     RowBox[{"-", "12.`"}], " ", "qz"}], ",", 
    RowBox[{
     RowBox[{"-", "3.`"}], " ", "ts"}], ",", 
    RowBox[{"12.`", " ", "an"}], ",", 
    RowBox[{"3.`", " ", "tr"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.422707175390625*^9, 3.422769091625*^9, 
  3.460966306484375*^9, 3.485494458464469*^9, 3.485751362455538*^9, 
  3.4857521560208683`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "3.`"}], " ", "ab"}], ",", 
    RowBox[{
     RowBox[{"-", "6.`"}], " ", "an"}], ",", 
    RowBox[{
     RowBox[{"-", "3.`"}], " ", "tr"}], ",", 
    RowBox[{"2.`", " ", "gr"}], ",", 
    RowBox[{"3.`", " ", "prg"}], ",", 
    RowBox[{"1.`", " ", "py"}], ",", 
    RowBox[{"18.`", " ", "qz"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.422707175390625*^9, 3.422769091625*^9, 
  3.460966306484375*^9, 3.485494458464469*^9, 3.485751362455538*^9, 
  3.4857521560364933`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2.`"}], " ", "di"}], ",", 
    RowBox[{
     RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
    RowBox[{
     RowBox[{"-", "1.`"}], " ", "ts"}], ",", 
    RowBox[{"2.`", " ", "an"}], ",", 
    RowBox[{"1.`", " ", "tr"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.422707175390625*^9, 3.422769091625*^9, 
  3.460966306484375*^9, 3.485494458464469*^9, 3.485751362455538*^9, 
  3.485752156052119*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1.`"}], " ", "di"}], ",", 
    RowBox[{
     RowBox[{"-", "1.`"}], " ", "prg"}], ",", 
    RowBox[{
     RowBox[{"-", "5.`"}], " ", "qz"}], ",", 
    RowBox[{"1.`", " ", "ab"}], ",", 
    RowBox[{"1.`", " ", "an"}], ",", 
    RowBox[{"1.`", " ", "tr"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.422707175390625*^9, 3.422769091625*^9, 
  3.460966306484375*^9, 3.485494458464469*^9, 3.485751362455538*^9, 
  3.485752156052119*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "5.`"}], " ", "alm"}], ",", 
    RowBox[{
     RowBox[{"-", "3.`"}], " ", "tr"}], ",", 
    RowBox[{"3.`", " ", "fact"}], ",", 
    RowBox[{"5.`", " ", "py"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.422707175390625*^9, 3.422769091625*^9, 
  3.460966306484375*^9, 3.485494458464469*^9, 3.485751362455538*^9, 
  3.4857521560677443`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1.`"}], " ", "alm"}], ",", 
    RowBox[{
     RowBox[{"-", "1.`"}], " ", "ts"}], ",", 
    RowBox[{"1.`", " ", "fts"}], ",", 
    RowBox[{"1.`", " ", "py"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.422707175390625*^9, 3.422769091625*^9, 
  3.460966306484375*^9, 3.485494458464469*^9, 3.485751362455538*^9, 
  3.4857521560677443`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4.`"}], " ", "alm"}], ",", 
    RowBox[{
     RowBox[{"-", "3.`"}], " ", "prg"}], ",", 
    RowBox[{"3.`", " ", "fprg"}], ",", 
    RowBox[{"4.`", " ", "py"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.422707175390625*^9, 3.422769091625*^9, 
  3.460966306484375*^9, 3.485494458464469*^9, 3.485751362455538*^9, 
  3.4857521560833693`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.42270717546875*^9, 3.4227690916875*^9, 
  3.460966306546875*^9, 3.485494458542593*^9, 3.4857513625180407`*^9, 
  3.4857521560833693`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
   RowBox[{
    RowBox[{"-", "2.`"}], " ", "py"}], ",", 
   RowBox[{
    RowBox[{"-", "12.`"}], " ", "qz"}], ",", 
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "ts"}], ",", 
   RowBox[{"12.`", " ", "an"}], ",", 
   RowBox[{"3.`", " ", "tr"}]}], "}"}]], "Print",
 CellChangeTimes->{3.42270717546875*^9, 3.4227690916875*^9, 
  3.460966306546875*^9, 3.485494458542593*^9, 3.4857513625180407`*^9, 
  3.4857521560989943`*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.42270717546875*^9, 3.4227690916875*^9, 
  3.460966306546875*^9, 3.485494458542593*^9, 3.4857513625180407`*^9, 
  3.4857521563177457`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "ab"}], ",", 
   RowBox[{
    RowBox[{"-", "6.`"}], " ", "an"}], ",", 
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "tr"}], ",", 
   RowBox[{"2.`", " ", "gr"}], ",", 
   RowBox[{"3.`", " ", "prg"}], ",", 
   RowBox[{"1.`", " ", "py"}], ",", 
   RowBox[{"18.`", " ", "qz"}]}], "}"}]], "Print",
 CellChangeTimes->{3.42270717546875*^9, 3.4227690916875*^9, 
  3.460966306546875*^9, 3.485494458542593*^9, 3.4857513625180407`*^9, 
  3.4857521563333707`*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.42270717546875*^9, 3.4227690916875*^9, 
  3.460966306546875*^9, 3.485494458542593*^9, 3.4857513625180407`*^9, 
  3.485752156895874*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2.`"}], " ", "di"}], ",", 
   RowBox[{
    RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "ts"}], ",", 
   RowBox[{"2.`", " ", "an"}], ",", 
   RowBox[{"1.`", " ", "tr"}]}], "}"}]], "Print",
 CellChangeTimes->{3.42270717546875*^9, 3.4227690916875*^9, 
  3.460966306546875*^9, 3.485494458542593*^9, 3.4857513625180407`*^9, 
  3.485752156911499*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.42270717546875*^9, 3.4227690916875*^9, 
  3.460966306546875*^9, 3.485494458542593*^9, 3.4857513625180407`*^9, 
  3.4857521570833755`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "di"}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "prg"}], ",", 
   RowBox[{
    RowBox[{"-", "5.`"}], " ", "qz"}], ",", 
   RowBox[{"1.`", " ", "ab"}], ",", 
   RowBox[{"1.`", " ", "an"}], ",", 
   RowBox[{"1.`", " ", "tr"}]}], "}"}]], "Print",
 CellChangeTimes->{3.42270717546875*^9, 3.4227690916875*^9, 
  3.460966306546875*^9, 3.485494458542593*^9, 3.4857513625180407`*^9, 
  3.4857521570990005`*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.42270717546875*^9, 3.4227690916875*^9, 
  3.460966306546875*^9, 3.485494458542593*^9, 3.4857513625180407`*^9, 
  3.485752157567754*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "5.`"}], " ", "alm"}], ",", 
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "tr"}], ",", 
   RowBox[{"3.`", " ", "fact"}], ",", 
   RowBox[{"5.`", " ", "py"}]}], "}"}]], "Print",
 CellChangeTimes->{3.42270717546875*^9, 3.4227690916875*^9, 
  3.460966306546875*^9, 3.485494458542593*^9, 3.4857513625180407`*^9, 
  3.485752157583379*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.42270717546875*^9, 3.4227690916875*^9, 
  3.460966306546875*^9, 3.485494458542593*^9, 3.4857513625180407`*^9, 
  3.4857521577865047`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "alm"}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "ts"}], ",", 
   RowBox[{"1.`", " ", "fts"}], ",", 
   RowBox[{"1.`", " ", "py"}]}], "}"}]], "Print",
 CellChangeTimes->{3.42270717546875*^9, 3.4227690916875*^9, 
  3.460966306546875*^9, 3.485494458542593*^9, 3.4857513625180407`*^9, 
  3.4857521577865047`*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.42270717546875*^9, 3.4227690916875*^9, 
  3.460966306546875*^9, 3.485494458542593*^9, 3.4857513625180407`*^9, 
  3.4857521579740057`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "4.`"}], " ", "alm"}], ",", 
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "prg"}], ",", 
   RowBox[{"3.`", " ", "fprg"}], ",", 
   RowBox[{"4.`", " ", "py"}]}], "}"}]], "Print",
 CellChangeTimes->{3.42270717546875*^9, 3.4227690916875*^9, 
  3.460966306546875*^9, 3.485494458542593*^9, 3.4857513625180407`*^9, 
  3.485752157989631*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{{{{{{{{}, {}, 
          {Hue[0.67, 0.6, 0.6], 
           LineBox[{{433.448, 5000.}, {488.319, 6000.}, {542.847, 7000.}, {
            596.981, 8000.}, {650.679, 9000.}, {703.904, 10000.}, {756.63, 
            11000.}, {808.835, 12000.}}]}}, {{}, {}, 
          {Hue[0.67, 0.6, 0.6], 
           LineBox[{{433.448, 5000.}, {488.319, 6000.}, {542.847, 7000.}, {
            596.981, 8000.}, {650.679, 9000.}, {703.904, 10000.}, {756.63, 
            11000.}, {808.835, 12000.}}]}}}, {{}, {}, 
         {Hue[0.67, 0.6, 0.6], 
          LineBox[{{404.417, 5000.}, {468.282, 6000.}, {531.857, 7000.}, {
           594.821, 8000.}, {656.571, 9000.}, {716.464, 10000.}, {775.833, 
           11000.}, {835.674, 12000.}}]}}}, {{}, {}, 
        {Hue[0.67, 0.6, 0.6], 
         LineBox[{{538.991, 5000.}, {568.842, 6000.}, {598.486, 7000.}, {
          627.917, 8000.}, {657.128, 9000.}, {686.114, 10000.}, {714.869, 
          11000.}, {743.391, 12000.}}]}}}, {{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{484.123, 5000.}, {530.149, 6000.}, {575.765, 7000.}, {
         620.702, 8000.}, {664.51, 9000.}, {706.93, 10000.}, {748.848, 
         11000.}, {790.941, 12000.}}]}}}, {{}, {}, 
      {Hue[0.67, 0.6, 0.6], 
       LineBox[{{718.268, 5000.}, {724.827, 6000.}, {731.367, 7000.}, {
        737.889, 8000.}, {744.393, 9000.}, {750.88, 10000.}, {757.348, 
        11000.}, {763.798, 12000.}}]}}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{748.993, 5000.}, {750.294, 6000.}, {751.588, 7000.}, {752.876,
        8000.}, {754.157, 9000.}, {755.432, 10000.}, {756.701, 11000.}, {
       757.964, 12000.}}]}}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{727.026, 5000.}, {732.274, 6000.}, {737.51, 7000.}, {742.732, 
      8000.}, {747.941, 9000.}, {753.137, 10000.}, {758.319, 11000.}, {
      763.487, 12000.}}]}}},
  AspectRatio->1,
  Axes->True,
  AxesOrigin->{450., 5000.},
  DisplayFunction->Identity,
  Frame->True,
  PlotRange->{{500, 1000}, {5000, 12000}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.422707175390625*^9, 3.422769091625*^9, 
  3.460966306484375*^9, 3.485494458464469*^9, 3.485751362455538*^9, 
  3.4857521582083826`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "11"}], ":", " ", 
     RowBox[{"same", " ", "example", " ", "as", " ", "10"}]}], ",", " ", 
    RowBox[{
    "but", " ", "now", " ", "only", " ", "linearly", " ", "independent", " ", 
     "reactions", " ", "are", " ", "calculated", " ", "from", " ", "the", " ",
      "set", " ", "of", " ", "phase", " ", "components"}]}], "  ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"The", " ", "PET", " ", "function"}], " ", "-", 
    "CalcReaIntersection", "-", " ", 
    RowBox[{
    "is", " ", "then", " ", "used", " ", "to", " ", "calculate", " ", "all", 
     " ", "intersections", " ", "and", " ", "the", " ", "Mathematica", " ", 
     "built"}], "-", 
    RowBox[{"in", " ", "functions"}], "\[IndentingNewLine]", "-", "Mean", "-",
     " ", "and", " ", "-", "StandardDeviation", "-", "\[IndentingNewLine]", 
    RowBox[{
    "are", " ", "used", " ", "to", " ", "calculate", " ", "mean", " ", "and", 
     " ", "standard", " ", "deviation", " ", "of", " ", "P", " ", "and", " ", 
     "T", " ", "for", " ", "this", " ", "sample", " ", "from", " ", "the", 
     " ", "intersections", " ", "of", " ", "linearly", " ", "independent", 
     " ", 
     RowBox[{"reactions", "."}]}]}], "  ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "->", " ", "B88"}], "]"}], ";", " ", 
    RowBox[{"file", " ", "=", " ", "\"\<Pmg20\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"phases", " ", "=", 
     RowBox[{"{", 
      RowBox[{
      "qz", ",", "alm", ",", "py", ",", "gr", ",", "an", ",", "ab", ",", "di",
        ",", "fprg", ",", "fact", ",", "fts", ",", "prg", ",", "tr", ",", 
       "ts"}], "}"}]}], ";"}], "\n", 
   RowBox[{"rea", " ", "=", " ", 
    RowBox[{"MakeRea", "[", "phases", "]"}]}], "\n", 
   RowBox[{
    RowBox[{"result", "=", 
     RowBox[{"CalcRea", "[", 
      RowBox[{"rea", ",", 
       RowBox[{"CalcReaMin", "\[Rule]", "5000"}], ",", 
       RowBox[{"CalcReaMax", "\[Rule]", "12000"}], ",", 
       RowBox[{"Steps", "\[Rule]", "8"}], ",", 
       RowBox[{"SampleFile", "\[Rule]", "file"}], ",", 
       RowBox[{"Screen", "\[Rule]", "ScreenNo"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{"plot", "=", 
    RowBox[{"PlotRea", "[", "result", "]"}]}], "\n", 
   RowBox[{"Show", "[", 
    RowBox[{"plot", ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"500", ",", "1000"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5000", ",", "12000"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "fprg"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "py"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "ab"}], ",", 
     RowBox[{"4.`", " ", "alm"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "ts"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "fprg"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "py"}], ",", 
     RowBox[{
      RowBox[{"-", "18.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "ab"}], ",", 
     RowBox[{"4.`", " ", "alm"}], ",", 
     RowBox[{"6.`", " ", "an"}], ",", 
     RowBox[{"3.`", " ", "tr"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "fprg"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "py"}], ",", 
     RowBox[{"4.`", " ", "alm"}], ",", 
     RowBox[{"3.`", " ", "prg"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "fprg"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "ab"}], ",", 
     RowBox[{"1.`", " ", "alm"}], ",", 
     RowBox[{"3.`", " ", "fts"}], ",", 
     RowBox[{"2.`", " ", "gr"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "alm"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "fprg"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "18.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "ab"}], ",", 
     RowBox[{"6.`", " ", "an"}], ",", 
     RowBox[{"3.`", " ", "fact"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "py"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "an"}], ",", 
     RowBox[{"3.`", " ", "di"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.422707199890625*^9, 3.422769097890625*^9, 
  3.46096631078125*^9, 3.485494463058131*^9, 3.48575136472125*^9, 
  3.4857521582396326`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422707199890625*^9, 3.42276909790625*^9, 
  3.460966310796875*^9, 3.4854944630737553`*^9, 3.4857513647368755`*^9, 
  3.485752158255258*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "6.`"}], " ", "an"}], ",", 
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "fprg"}], ",", 
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "py"}], ",", 
   RowBox[{
    RowBox[{"-", "6.`"}], " ", "qz"}], ",", 
   RowBox[{"3.`", " ", "ab"}], ",", 
   RowBox[{"4.`", " ", "alm"}], ",", 
   RowBox[{"2.`", " ", "gr"}], ",", 
   RowBox[{"3.`", " ", "ts"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707199890625*^9, 3.42276909790625*^9, 
  3.460966310796875*^9, 3.4854944630737553`*^9, 3.4857513647368755`*^9, 
  3.485752158255258*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422707199890625*^9, 3.42276909790625*^9, 
  3.460966310796875*^9, 3.4854944630737553`*^9, 3.4857513647368755`*^9, 
  3.4857521588490114`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "fprg"}], ",", 
   RowBox[{
    RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
   RowBox[{
    RowBox[{"-", "5.`"}], " ", "py"}], ",", 
   RowBox[{
    RowBox[{"-", "18.`"}], " ", "qz"}], ",", 
   RowBox[{"3.`", " ", "ab"}], ",", 
   RowBox[{"4.`", " ", "alm"}], ",", 
   RowBox[{"6.`", " ", "an"}], ",", 
   RowBox[{"3.`", " ", "tr"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707199890625*^9, 3.42276909790625*^9, 
  3.460966310796875*^9, 3.4854944630737553`*^9, 3.4857513647368755`*^9, 
  3.485752158864637*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422707199890625*^9, 3.42276909790625*^9, 
  3.460966310796875*^9, 3.4854944630737553`*^9, 3.4857513647368755`*^9, 
  3.485752159583391*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "fprg"}], ",", 
   RowBox[{
    RowBox[{"-", "4.`"}], " ", "py"}], ",", 
   RowBox[{"4.`", " ", "alm"}], ",", 
   RowBox[{"3.`", " ", "prg"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707199890625*^9, 3.42276909790625*^9, 
  3.460966310796875*^9, 3.4854944630737553`*^9, 3.4857513647368755`*^9, 
  3.485752159599016*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422707199890625*^9, 3.42276909790625*^9, 
  3.460966310796875*^9, 3.4854944630737553`*^9, 3.4857513647368755`*^9, 
  3.4857521597865176`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "6.`"}], " ", "an"}], ",", 
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "fprg"}], ",", 
   RowBox[{
    RowBox[{"-", "6.`"}], " ", "qz"}], ",", 
   RowBox[{"3.`", " ", "ab"}], ",", 
   RowBox[{"1.`", " ", "alm"}], ",", 
   RowBox[{"3.`", " ", "fts"}], ",", 
   RowBox[{"2.`", " ", "gr"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707199890625*^9, 3.42276909790625*^9, 
  3.460966310796875*^9, 3.4854944630737553`*^9, 3.4857513647368755`*^9, 
  3.4857521597865176`*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422707199890625*^9, 3.42276909790625*^9, 
  3.460966310796875*^9, 3.4854944630737553`*^9, 3.4857513647368755`*^9, 
  3.485752160286521*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "alm"}], ",", 
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "fprg"}], ",", 
   RowBox[{
    RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
   RowBox[{
    RowBox[{"-", "18.`"}], " ", "qz"}], ",", 
   RowBox[{"3.`", " ", "ab"}], ",", 
   RowBox[{"6.`", " ", "an"}], ",", 
   RowBox[{"3.`", " ", "fact"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707199890625*^9, 3.42276909790625*^9, 
  3.460966310796875*^9, 3.4854944630737553`*^9, 3.4857513647368755`*^9, 
  3.485752160302146*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422707199890625*^9, 3.42276909790625*^9, 
  3.460966310796875*^9, 3.4854944630737553`*^9, 3.4857513647368755`*^9, 
  3.4857521608333993`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "py"}], ",", 
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
   RowBox[{"3.`", " ", "an"}], ",", 
   RowBox[{"3.`", " ", "di"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707199890625*^9, 3.42276909790625*^9, 
  3.460966310796875*^9, 3.4854944630737553`*^9, 3.4857513647368755`*^9, 
  3.4857521608490243`*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{{{{{{{}, {}, 
         {Hue[0.67, 0.6, 0.6], 
          LineBox[{{635.299, 5000.}, {654.465, 6000.}, {673.583, 7000.}, {
           692.644, 8000.}, {711.61, 9000.}, {730.441, 10000.}, {749.113, 
           11000.}, {767.611, 12000.}}]}}, {{}, {}, 
         {Hue[0.67, 0.6, 0.6], 
          LineBox[{{635.299, 5000.}, {654.465, 6000.}, {673.583, 7000.}, {
           692.644, 8000.}, {711.61, 9000.}, {730.441, 10000.}, {749.113, 
           11000.}, {767.611, 12000.}}]}}}, {{}, {}, 
        {Hue[0.67, 0.6, 0.6], 
         LineBox[{{1290.137, 5000.}, {1201.263, 6000.}, {1110.945, 7000.}, {
          1018.702, 8000.}, {924.293, 9000.}, {827.566, 10000.}, {718.536, 
          11000.}, {594.813, 12000.}}]}}}, {{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{727.026, 5000.}, {732.274, 6000.}, {737.51, 7000.}, {
         742.732, 8000.}, {747.941, 9000.}, {753.137, 10000.}, {758.319, 
         11000.}, {763.487, 12000.}}]}}}, {{}, {}, 
      {Hue[0.67, 0.6, 0.6], 
       LineBox[{{533.565, 5000.}, {568.375, 6000.}, {603.076, 7000.}, {
        637.753, 8000.}, {672.551, 9000.}, {707.48, 10000.}, {742.173, 
        11000.}, {776.371, 12000.}}]}}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{467.426, 5000.}, {519.626, 6000.}, {571.419, 7000.}, {622.582,
        8000.}, {672.739, 9000.}, {721.791, 10000.}, {770.484, 11000.}, {
       819.196, 12000.}}]}}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{215.649, 5000.}, {322.734, 6000.}, {429.186, 7000.}, {534.337, 
      8000.}, {637.741, 9000.}, {739.295, 10000.}, {839.179, 11000.}, {
      936.239, 12000.}}]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{640., 5000.},
  DisplayFunction->Identity,
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.422707199890625*^9, 3.422769097890625*^9, 
  3.46096631078125*^9, 3.485494463058131*^9, 3.48575136472125*^9, 
  3.4857521610834007`*^9}],

Cell[BoxData[
 GraphicsBox[{{{{{{{{}, {}, 
         {Hue[0.67, 0.6, 0.6], 
          LineBox[{{635.299, 5000.}, {654.465, 6000.}, {673.583, 7000.}, {
           692.644, 8000.}, {711.61, 9000.}, {730.441, 10000.}, {749.113, 
           11000.}, {767.611, 12000.}}]}}, {{}, {}, 
         {Hue[0.67, 0.6, 0.6], 
          LineBox[{{635.299, 5000.}, {654.465, 6000.}, {673.583, 7000.}, {
           692.644, 8000.}, {711.61, 9000.}, {730.441, 10000.}, {749.113, 
           11000.}, {767.611, 12000.}}]}}}, {{}, {}, 
        {Hue[0.67, 0.6, 0.6], 
         LineBox[{{1290.137, 5000.}, {1201.263, 6000.}, {1110.945, 7000.}, {
          1018.702, 8000.}, {924.293, 9000.}, {827.566, 10000.}, {718.536, 
          11000.}, {594.813, 12000.}}]}}}, {{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{{727.026, 5000.}, {732.274, 6000.}, {737.51, 7000.}, {
         742.732, 8000.}, {747.941, 9000.}, {753.137, 10000.}, {758.319, 
         11000.}, {763.487, 12000.}}]}}}, {{}, {}, 
      {Hue[0.67, 0.6, 0.6], 
       LineBox[{{533.565, 5000.}, {568.375, 6000.}, {603.076, 7000.}, {
        637.753, 8000.}, {672.551, 9000.}, {707.48, 10000.}, {742.173, 
        11000.}, {776.371, 12000.}}]}}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{467.426, 5000.}, {519.626, 6000.}, {571.419, 7000.}, {622.582,
        8000.}, {672.739, 9000.}, {721.791, 10000.}, {770.484, 11000.}, {
       819.196, 12000.}}]}}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{215.649, 5000.}, {322.734, 6000.}, {429.186, 7000.}, {534.337, 
      8000.}, {637.741, 9000.}, {739.295, 10000.}, {839.179, 11000.}, {
      936.239, 12000.}}]}}},
  AspectRatio->1,
  Axes->True,
  AxesOrigin->{640., 5000.},
  DisplayFunction->Identity,
  Frame->True,
  PlotRange->{{500, 1000}, {5000, 12000}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.422707199890625*^9, 3.422769097890625*^9, 
  3.46096631078125*^9, 3.485494463058131*^9, 3.48575136472125*^9, 
  3.4857521610990257`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Example", " ", "11", " ", 
    RowBox[{"continued", ":", " ", 
     RowBox[{
     "calculate", " ", "reaction", " ", "intersections", " ", "and", " ", 
      "mean", " ", "and", " ", "std", " ", "of", " ", "P", " ", "and", " ", 
      "T"}]}]}], "  ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"is", "=", 
    RowBox[{"CalcReaIntersection", "[", "result", "]"}]}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"calculate", " ", "reaction", " ", "intersections"}], "  ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", "t", ",", "dummy"}], "}"}], "=", 
     RowBox[{"Transpose", "[", "is", "]"}]}], ";"}], "  ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "p", " ", "is", " ", "now", " ", "a", " ", "list", " ", "of", " ", "all",
       " ", "pressures"}], ",", " ", 
     RowBox[{"t", " ", "of", " ", "all", " ", "temperatures"}]}], "  ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Mean", "[", "p", "]"}], "\[IndentingNewLine]", 
   RowBox[{"StandardDeviation", "[", "p", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Mean", "[", "t", "]"}], "\[IndentingNewLine]", 
   RowBox[{"StandardDeviation", "[", "t", "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10769.973087699142`", ",", "744.8328265661096`", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11689.27413260097`", ",", "761.882667882579`", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10664.978901976172`", ",", "756.5844801753776`", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11438.67156608847`", ",", "757.2497993835315`", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10841.748221310245`", ",", "736.7094270039133`", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11553.609603875322`", ",", "761.1817842525687`", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10288.034798475359`", ",", "735.8361781543816`", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10679.966710138768`", ",", "754.9164071871907`", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10720.123468769643`", ",", "756.8700906630851`", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8987.266979287797`", ",", "672.1071145291592`", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9892.047292314146`", ",", "728.4153886081865`", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10429.08296501707`", ",", "782.4317882555795`", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10144.761960437483`", ",", "753.8880231373525`", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9519.294510458683`", ",", "690.696419221133`", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9664.322536020909`", ",", "705.4002728495974`", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.422707224890625*^9, 3.422769109421875*^9, 
  3.46096631590625*^9, 3.485494469386134*^9, 3.485751367643237*^9, 
  3.4857521611302767`*^9}],

Cell[BoxData["10485.543782298011`"], "Output",
 CellChangeTimes->{3.422707224890625*^9, 3.422769109421875*^9, 
  3.46096631590625*^9, 3.485494469386134*^9, 3.485751367643237*^9, 
  3.4857521611302767`*^9}],

Cell[BoxData["765.0599300337527`"], "Output",
 CellChangeTimes->{3.422707224890625*^9, 3.422769109421875*^9, 
  3.46096631590625*^9, 3.485494469386134*^9, 3.485751367643237*^9, 
  3.4857521611459017`*^9}],

Cell[BoxData["739.9335111913164`"], "Output",
 CellChangeTimes->{3.422707224890625*^9, 3.422769109421875*^9, 
  3.46096631590625*^9, 3.485494469386134*^9, 3.485751367643237*^9, 
  3.4857521611615267`*^9}],

Cell[BoxData["29.789306808915843`"], "Output",
 CellChangeTimes->{3.422707224890625*^9, 3.422769109421875*^9, 
  3.46096631590625*^9, 3.485494469386134*^9, 3.485751367643237*^9, 
  3.4857521611615267`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "12"}], ":", " ", 
    RowBox[{
     RowBox[{"modify", " ", "a", " ", "plot", " ", 
      RowBox[{"(", 
       RowBox[{
       "reactions", " ", "calculated", " ", "before", " ", "in", " ", 
        "example", " ", "10"}], ")"}], " ", "by", " ", "using", " ", 
      "options", " ", "of"}], " ", "-", "PlotRea", "-", " ", "and", " ", "-", 
     "Show", "-"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"create", " ", "the", " ", "raw"}], "-", 
    RowBox[{"plot", ":", " ", 
     RowBox[{
     "change", " ", "thickness", " ", "and", " ", "dashing", " ", "of", " ", 
      "reactions"}]}]}], "  ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"p1", "=", 
     RowBox[{"PlotRea", "[", 
      RowBox[{"r1", ",", 
       RowBox[{"PlotReaStyle", "->", 
        RowBox[{"{", 
         RowBox[{"Thickness", "[", "0.007", "]"}], "}"}]}], ",", 
       RowBox[{"PlotReaMode", "\[Rule]", "1"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"p2", "=", 
     RowBox[{"PlotRea", "[", 
      RowBox[{"r2", ",", 
       RowBox[{"PlotReaStyle", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.007", "]"}], ",", 
          RowBox[{"Dashing", "[", 
           RowBox[{"{", 
            RowBox[{"0.02", ",", "0.02"}], "}"}], "]"}]}], "}"}]}], ",", 
       RowBox[{"PlotReaMode", "\[Rule]", "1"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"p3", "=", 
     RowBox[{"PlotRea", "[", 
      RowBox[{"r3", ",", 
       RowBox[{"PlotReaStyle", "->", 
        RowBox[{"{", 
         RowBox[{"Thickness", "[", "0.007", "]"}], "}"}]}], ",", 
       RowBox[{"PlotReaMode", "\[Rule]", "1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p4", "=", 
     RowBox[{"PlotRea", "[", 
      RowBox[{"r4", ",", 
       RowBox[{"PlotReaStyle", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.007", "]"}], ",", 
          RowBox[{"Dashing", "[", 
           RowBox[{"{", 
            RowBox[{"0.02", ",", "0.02"}], "}"}], "]"}]}], "}"}]}], ",", 
       RowBox[{"PlotReaMode", "\[Rule]", "1"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"p5", "=", 
     RowBox[{"PlotRea", "[", 
      RowBox[{"r5", ",", 
       RowBox[{"PlotReaStyle", "->", 
        RowBox[{"{", 
         RowBox[{"Thickness", "[", "0.005", "]"}], "}"}]}], ",", 
       RowBox[{"PlotReaMode", "\[Rule]", "1"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"p6", "=", 
     RowBox[{"PlotRea", "[", 
      RowBox[{"r6", ",", 
       RowBox[{"PlotReaStyle", "->", 
        RowBox[{"{", 
         RowBox[{"Thickness", "[", "0.005", "]"}], "}"}]}], ",", 
       RowBox[{"PlotReaMode", "\[Rule]", "1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p7", "=", 
     RowBox[{"PlotRea", "[", 
      RowBox[{"r7", ",", 
       RowBox[{"PlotReaStyle", "->", 
        RowBox[{"{", 
         RowBox[{"Thickness", "[", "0.005", "]"}], "}"}]}], ",", 
       RowBox[{"PlotReaMode", "\[Rule]", "1"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{"plot", " ", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{
     "p1", ",", "p2", ",", "p3", ",", "p4", ",", "p5", ",", "p6", ",", "p7", 
      ",", 
      RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\n"}]}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.007], 
      LineBox[{{433.448, 5000.}, {488.319, 6000.}, {542.847, 7000.}, {596.981,
        8000.}, {650.679, 9000.}, {703.904, 10000.}, {756.63, 11000.}, {
       808.835, 12000.}}]}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.007], 
      LineBox[{{433.448, 5000.}, {488.319, 6000.}, {542.847, 7000.}, {596.981,
        8000.}, {650.679, 9000.}, {703.904, 10000.}, {756.63, 11000.}, {
       808.835, 12000.}}]}}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.007], Dashing[{0.02, 0.02}], 
      LineBox[{{404.417, 5000.}, {468.282, 6000.}, {531.857, 7000.}, {594.821,
        8000.}, {656.571, 9000.}, {716.464, 10000.}, {775.833, 11000.}, {
       835.674, 12000.}}]}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.007], Dashing[{0.02, 0.02}], 
      LineBox[{{404.417, 5000.}, {468.282, 6000.}, {531.857, 7000.}, {594.821,
        8000.}, {656.571, 9000.}, {716.464, 10000.}, {775.833, 11000.}, {
       835.674, 12000.}}]}}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.007], 
      LineBox[{{538.991, 5000.}, {568.842, 6000.}, {598.486, 7000.}, {627.917,
        8000.}, {657.128, 9000.}, {686.114, 10000.}, {714.869, 11000.}, {
       743.391, 12000.}}]}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.007], 
      LineBox[{{538.991, 5000.}, {568.842, 6000.}, {598.486, 7000.}, {627.917,
        8000.}, {657.128, 9000.}, {686.114, 10000.}, {714.869, 11000.}, {
       743.391, 12000.}}]}}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.007], Dashing[{0.02, 0.02}], 
      LineBox[{{484.123, 5000.}, {530.149, 6000.}, {575.765, 7000.}, {620.702,
        8000.}, {664.51, 9000.}, {706.93, 10000.}, {748.848, 11000.}, {
       790.941, 12000.}}]}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.007], Dashing[{0.02, 0.02}], 
      LineBox[{{484.123, 5000.}, {530.149, 6000.}, {575.765, 7000.}, {620.702,
        8000.}, {664.51, 9000.}, {706.93, 10000.}, {748.848, 11000.}, {
       790.941, 12000.}}]}}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.005], 
      LineBox[{{718.268, 5000.}, {724.827, 6000.}, {731.367, 7000.}, {737.889,
        8000.}, {744.393, 9000.}, {750.88, 10000.}, {757.348, 11000.}, {
       763.798, 12000.}}]}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.005], 
      LineBox[{{718.268, 5000.}, {724.827, 6000.}, {731.367, 7000.}, {737.889,
        8000.}, {744.393, 9000.}, {750.88, 10000.}, {757.348, 11000.}, {
       763.798, 12000.}}]}}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.005], 
      LineBox[{{748.993, 5000.}, {750.294, 6000.}, {751.588, 7000.}, {752.876,
        8000.}, {754.157, 9000.}, {755.432, 10000.}, {756.701, 11000.}, {
       757.964, 12000.}}]}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.005], 
      LineBox[{{748.993, 5000.}, {750.294, 6000.}, {751.588, 7000.}, {752.876,
        8000.}, {754.157, 9000.}, {755.432, 10000.}, {756.701, 11000.}, {
       757.964, 12000.}}]}}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.005], 
      LineBox[{{727.026, 5000.}, {732.274, 6000.}, {737.51, 7000.}, {742.732, 
       8000.}, {747.941, 9000.}, {753.137, 10000.}, {758.319, 11000.}, {
       763.487, 12000.}}]}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[0.005], 
      LineBox[{{727.026, 5000.}, {732.274, 6000.}, {737.51, 7000.}, {742.732, 
       8000.}, {747.941, 9000.}, {753.137, 10000.}, {758.319, 11000.}, {
       763.487, 12000.}}]}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{450., 5000.},
  DisplayFunction->Identity,
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.42270724690625*^9, 3.422769112890625*^9, 
  3.460966317734375*^9, 3.485494471339222*^9, 3.4857513677526164`*^9, 
  3.4857521612084017`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "  ", 
   RowBox[{
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", "    ", 
                    RowBox[{
                    "-", "CalcRea"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
    "-", "  ", 
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", "-"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], "  ",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "  ", 
   RowBox[{
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "-", "  ", "T"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
    "-", 
    RowBox[{"X", 
     RowBox[{"(", "CO2", ")"}], " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"equilibria", "  ", "--"}], "--"}], "--"}], 
                    "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], 
               "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], "--"}],
        "--"}], "--"}]}], "-"}], "  ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "13"}], ":", " ", 
     RowBox[{
      RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
      "CalcRea", "-", " ", 
      RowBox[{
      "to", " ", "calculate", " ", "the", " ", "equilibrium", " ", 
       "\[IndentingNewLine]", "5", " ", "Dol"}], " ", "+", " ", 
      RowBox[{"8", " ", "Qz"}], " ", "+", " ", 
      RowBox[{"1", " ", "H2O"}]}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{"1", " ", "Tr"}], " ", "+", " ", 
     RowBox[{"3", " ", "Cal"}], " ", "+", " ", 
     RowBox[{
     "7", " ", "CO2", " ", "for", " ", "pure", " ", "phase", " ", 
      "components"}]}]}], " ", "*)"}], " ", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"chose", " ", "your", " ", "data", " ", "set", " ", 
    RowBox[{"(", 
     RowBox[{"uncomment", " ", "the", " ", "corresponding"}], ")"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "->", " ", "B88"}], "]"}], ";"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "\[Rule]", "HP32"}], "]"}], ";"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "\[Rule]", "G97"}], "]"}], ";"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "\[Rule]", "G97"}], "]"}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"phases", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
      "dol", ",", "qz", ",", "tr", ",", "cal", ",", "co2", ",", "h2o"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rea", " ", "=", 
     RowBox[{"MakeRea", "[", "phases", "]"}]}], " ", ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"r1", "=", 
    RowBox[{"CalcRea", "[", 
     RowBox[{"rea", ",", 
      RowBox[{"CalcReaMode", "\[Rule]", "TXCO2"}], ",", 
      RowBox[{"CalcReaMin", "\[Rule]", "0.1"}], ",", 
      RowBox[{"CalcReaMax", "\[Rule]", "0.9"}], ",", 
      RowBox[{"Steps", "\[Rule]", "9"}], ",", 
      RowBox[{"Screen", "\[Rule]", "ScreenYes"}], ",", 
      RowBox[{"SampleFile", "->", "\"\<None\>\""}]}], "]"}]}], 
   "\[IndentingNewLine]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"calculating T-X(CO2) data at \"\>", "\[InvisibleSpace]", 
   "5000", "\[InvisibleSpace]", "\<\" bar of the reaction:\"\>"}],
  SequenceForm["calculating T-X(CO2) data at ", 5000, " bar of the reaction:"],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707304515625*^9, 3.422769119375*^9, 
  3.46096632121875*^9, 3.485494474104794*^9, 3.485751367768242*^9, 
  3.4857521612396517`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "cal"}], ",", 
   RowBox[{
    RowBox[{"-", "7.`"}], " ", "co2"}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "tr"}], ",", 
   RowBox[{"5.`", " ", "dol"}], ",", 
   RowBox[{"1.`", " ", "h2o"}], ",", 
   RowBox[{"8.`", " ", "qz"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707304515625*^9, 3.422769119375*^9, 
  3.46096632121875*^9, 3.485494474104794*^9, 3.485751367768242*^9, 
  3.485752161255277*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "491.141762618621`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "0.1`"}],
  SequenceForm[491.141762618621, " ", 0.1],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707304515625*^9, 3.422769119375*^9, 
  3.46096632121875*^9, 3.485494474104794*^9, 3.485751367768242*^9, 
  3.4857521613490276`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "514.7795251207884`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.2`"}],
  SequenceForm[514.7795251207884, " ", 0.2],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707304515625*^9, 3.422769119375*^9, 
  3.46096632121875*^9, 3.485494474104794*^9, 3.485751367768242*^9, 
  3.4857521614740286`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "529.2999928809878`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.30000000000000004`"}],
  SequenceForm[529.2999928809878, " ", 0.30000000000000004`],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707304515625*^9, 3.422769119375*^9, 
  3.46096632121875*^9, 3.485494474104794*^9, 3.485751367768242*^9, 
  3.4857521615209036`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "541.8762091490722`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.4`"}],
  SequenceForm[541.8762091490722, " ", 0.4],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707304515625*^9, 3.422769119375*^9, 
  3.46096632121875*^9, 3.485494474104794*^9, 3.485751367768242*^9, 
  3.4857521615834045`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "554.3224421253365`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.5`"}],
  SequenceForm[554.3224421253365, " ", 0.5],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707304515625*^9, 3.422769119375*^9, 
  3.46096632121875*^9, 3.485494474104794*^9, 3.485751367768242*^9, 
  3.4857521616459045`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "567.3150889295632`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.6`"}],
  SequenceForm[567.3150889295632, " ", 0.6],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707304515625*^9, 3.422769119375*^9, 
  3.46096632121875*^9, 3.485494474104794*^9, 3.485751367768242*^9, 
  3.4857521617396555`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "582.3021998877217`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.7`"}],
  SequenceForm[582.3021998877217, " ", 0.7],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707304515625*^9, 3.422769119375*^9, 
  3.46096632121875*^9, 3.485494474104794*^9, 3.485751367768242*^9, 
  3.4857521618334055`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "602.3473881897874`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.7999999999999999`"}],
  SequenceForm[602.3473881897874, " ", 0.7999999999999999],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707304515625*^9, 3.422769119375*^9, 
  3.46096632121875*^9, 3.485494474104794*^9, 3.485751367768242*^9, 
  3.4857521618959064`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "628.6222649386856`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.8999999999999999`"}],
  SequenceForm[628.6222649386856, " ", 0.8999999999999999],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707304515625*^9, 3.422769119375*^9, 
  3.46096632121875*^9, 3.485494474104794*^9, 3.485751367768242*^9, 
  3.4857521619896564`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3.`"}], " ", "cal"}], ",", 
        RowBox[{
         RowBox[{"-", "7.`"}], " ", "co2"}], ",", 
        RowBox[{
         RowBox[{"-", "1.`"}], " ", "tr"}], ",", 
        RowBox[{"5.`", " ", "dol"}], ",", 
        RowBox[{"1.`", " ", "h2o"}], ",", 
        RowBox[{"8.`", " ", "qz"}]}], "}"}], 
      ",", "\<\"{a(cal)=1, a(co2)={FluidActivityModel -> KerrickJacobs81, \
FluidSystem -> H2OCO2}, a(tr)=1, a(dol)=1, a(h2o)={FluidActivityModel -> \
KerrickJacobs81, FluidSystem -> H2OCO2}, a(qz)=1}\"\>", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.1`", ",", "491.142`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.2`", ",", "514.78`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.3`", ",", "529.3`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.4`", ",", "541.876`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5`", ",", "554.322`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.6`", ",", "567.315`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.7`", ",", "582.302`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.8`", ",", "602.347`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.9`", ",", "628.622`"}], "}"}]}], "}"}]}], "}"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dataset -> G97\"\>", ",", "\<\"SampleFile->None\"\>", 
     ",", "\<\"PinTX->5000\"\>"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.422707305625*^9, 3.4227691205*^9, 3.460966322*^9, 
  3.485494474886029*^9, 3.4857513685338964`*^9, 3.485752162005282*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "14"}], ":", " ", 
     RowBox[{
      RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
      "CalcRea", "-", " ", 
      RowBox[{
      "to", " ", "calculate", " ", "the", " ", "equilibrium", " ", 
       "\[IndentingNewLine]", "5", " ", "Dol"}], " ", "+", " ", 
      RowBox[{"8", " ", "Qz"}], " ", "+", " ", 
      RowBox[{"1", " ", "H2O"}]}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{"1", " ", "Tr"}], " ", "+", " ", 
     RowBox[{"3", " ", "Cal"}], " ", "+", " ", 
     RowBox[{
     "7", " ", "CO2", " ", "\[IndentingNewLine]", "using", " ", "amphibole", 
      " ", "data", " ", "from", " ", "\"\<ho2468.cmp\>\""}]}]}], " ", "*)"}], 
  " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"CalcFormula", "[", 
     RowBox[{"\"\<ho2468\>\"", ",", 
      RowBox[{"CalcFormulaMode", "\[Rule]", 
       RowBox[{"{", "}"}]}]}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"phases", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
      "dol", ",", "qz", ",", "tr", ",", "cal", ",", "co2", ",", "h2o"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rea", " ", "=", 
     RowBox[{"MakeRea", "[", "phases", "]"}]}], " ", ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"r1", "=", 
    RowBox[{"CalcRea", "[", 
     RowBox[{"rea", ",", 
      RowBox[{"CalcReaMode", "\[Rule]", "TXCO2"}], ",", 
      RowBox[{"CalcReaMin", "\[Rule]", "0.1"}], ",", 
      RowBox[{"CalcReaMax", "\[Rule]", "0.9"}], ",", 
      RowBox[{"Steps", "\[Rule]", "9"}], ",", 
      RowBox[{"Screen", "\[Rule]", "ScreenYes"}], ",", 
      RowBox[{"SampleFile", "->", "\"\<ho2468\>\""}]}], "]"}]}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"ho2468.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "ho2468.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707315046875*^9, 3.4227691229375*^9, 
  3.460966323234375*^9, 3.4854944770578623`*^9, 3.4857513685651474`*^9, 
  3.485752162020907*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"calculating T-X(CO2) data at \"\>", "\[InvisibleSpace]", 
   "5000", "\[InvisibleSpace]", "\<\" bar of the reaction:\"\>"}],
  SequenceForm["calculating T-X(CO2) data at ", 5000, " bar of the reaction:"],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707315046875*^9, 3.4227691229375*^9, 
  3.460966323234375*^9, 3.4854944770578623`*^9, 3.4857513685651474`*^9, 
  3.4857521620521574`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "cal"}], ",", 
   RowBox[{
    RowBox[{"-", "7.`"}], " ", "co2"}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "tr"}], ",", 
   RowBox[{"5.`", " ", "dol"}], ",", 
   RowBox[{"1.`", " ", "h2o"}], ",", 
   RowBox[{"8.`", " ", "qz"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707315046875*^9, 3.4227691229375*^9, 
  3.460966323234375*^9, 3.4854944770578623`*^9, 3.4857513685651474`*^9, 
  3.4857521620521574`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "456.86464592787434`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "0.1`"}],
  SequenceForm[456.86464592787434`, " ", 0.1],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707315046875*^9, 3.4227691229375*^9, 
  3.460966323234375*^9, 3.4854944770578623`*^9, 3.4857513685651474`*^9, 
  3.4857521621771584`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "474.8226566473759`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.2`"}],
  SequenceForm[474.8226566473759, " ", 0.2],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707315046875*^9, 3.4227691229375*^9, 
  3.460966323234375*^9, 3.4854944770578623`*^9, 3.4857513685651474`*^9, 
  3.4857521622865334`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "485.345329426126`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "0.30000000000000004`"}],
  SequenceForm[485.345329426126, " ", 0.30000000000000004`],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707315046875*^9, 3.4227691229375*^9, 
  3.460966323234375*^9, 3.4854944770578623`*^9, 3.4857513685651474`*^9, 
  3.4857521623959093`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "494.52155378935504`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "0.4`"}],
  SequenceForm[494.52155378935504`, " ", 0.4],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707315046875*^9, 3.4227691229375*^9, 
  3.460966323234375*^9, 3.4854944770578623`*^9, 3.4857513685651474`*^9, 
  3.4857521625052853`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "503.8488007150456`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.5`"}],
  SequenceForm[503.8488007150456, " ", 0.5],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707315046875*^9, 3.4227691229375*^9, 
  3.460966323234375*^9, 3.4854944770578623`*^9, 3.4857513685651474`*^9, 
  3.485752162630286*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "513.8444137694541`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.6`"}],
  SequenceForm[513.8444137694541, " ", 0.6],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707315046875*^9, 3.4227691229375*^9, 
  3.460966323234375*^9, 3.4854944770578623`*^9, 3.4857513685651474`*^9, 
  3.4857521627396617`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "524.8713164798658`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.7`"}],
  SequenceForm[524.8713164798658, " ", 0.7],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707315046875*^9, 3.4227691229375*^9, 
  3.460966323234375*^9, 3.4854944770578623`*^9, 3.4857513685651474`*^9, 
  3.485752162833412*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "537.6002089906116`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.7999999999999999`"}],
  SequenceForm[537.6002089906116, " ", 0.7999999999999999],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707315046875*^9, 3.4227691229375*^9, 
  3.460966323234375*^9, 3.4854944770578623`*^9, 3.4857513685651474`*^9, 
  3.4857521628959126`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "554.2566875249079`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.8999999999999999`"}],
  SequenceForm[554.2566875249079, " ", 0.8999999999999999],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707315046875*^9, 3.4227691229375*^9, 
  3.460966323234375*^9, 3.4854944770578623`*^9, 3.4857513685651474`*^9, 
  3.485752162989663*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3.`"}], " ", "cal"}], ",", 
        RowBox[{
         RowBox[{"-", "7.`"}], " ", "co2"}], ",", 
        RowBox[{
         RowBox[{"-", "1.`"}], " ", "tr"}], ",", 
        RowBox[{"5.`", " ", "dol"}], ",", 
        RowBox[{"1.`", " ", "h2o"}], ",", 
        RowBox[{"8.`", " ", "qz"}]}], "}"}], 
      ",", "\<\"{a(cal)=1, a(co2)={FluidActivityModel -> KerrickJacobs81, \
FluidSystem -> H2OCO2}, a(tr)=AmphMaederEtAl, a(dol)=1, \
a(h2o)={FluidActivityModel -> KerrickJacobs81, FluidSystem -> H2OCO2}, \
a(qz)=1}\"\>", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.1`", ",", "456.865`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.2`", ",", "474.823`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.3`", ",", "485.345`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.4`", ",", "494.522`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5`", ",", "503.849`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.6`", ",", "513.844`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.7`", ",", "524.871`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.8`", ",", "537.6`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.9`", ",", "554.257`"}], "}"}]}], "}"}]}], "}"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dataset -> G97\"\>", ",", "\<\"SampleFile->ho2468\"\>", 
     ",", "\<\"PinTX->5000\"\>"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.422707316375*^9, 3.42276912425*^9, 3.46096632421875*^9, 
  3.485494478042218*^9, 3.4857513695495605`*^9, 3.485752162989663*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "15"}], ":", " ", 
     RowBox[{
      RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
      "CalcRea", "-", " ", 
      RowBox[{
      "to", " ", "calculate", " ", "the", " ", "equilibrium", " ", 
       "\[IndentingNewLine]", "5", " ", "Dol"}], " ", "+", " ", 
      RowBox[{"8", " ", "Qz"}], " ", "+", " ", 
      RowBox[{"1", " ", "H2O"}]}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"1", " ", "Tr"}], " ", "+", " ", 
      RowBox[{"3", " ", "Cal"}], " ", "+", " ", 
      RowBox[{"7", " ", 
       RowBox[{"CO2", ":", " ", "\[IndentingNewLine]", 
        RowBox[{
        "calculate", " ", "the", " ", "reaction", " ", "for", " ", "a", 
         RowBox[{"(", "cal", ")"}]}]}]}]}], " ", "=", " ", 
     RowBox[{
     "0.86", " ", "and", " ", "use", " ", "the", " ", "activity", " ", 
      "model", " ", "for", " ", "amphibole"}]}]}], " ", "*)"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "->", " ", "B88"}], "]"}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"phases", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
      "dol", ",", "qz", ",", "tr", ",", "cal", ",", "co2", ",", "h2o"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rea", " ", "=", 
     RowBox[{"MakeRea", "[", "phases", "]"}]}], " ", ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rea", "=", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"rea", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "0.86", ",", "1", ",", "\"\<am\>\"", ",", "1", ",", "1", ",", "1"}], 
         "}"}]}], "}"}], "}"}]}], ";"}], "  ", "\[IndentingNewLine]", 
   RowBox[{"r1", "=", 
    RowBox[{"CalcRea", "[", 
     RowBox[{"rea", ",", 
      RowBox[{"CalcReaMode", "\[Rule]", "TXCO2"}], ",", 
      RowBox[{"CalcReaMin", "\[Rule]", "0.1"}], ",", 
      RowBox[{"CalcReaMax", "\[Rule]", "0.9"}], ",", 
      RowBox[{"Steps", "\[Rule]", "9"}]}], "]"}]}], 
   "\[IndentingNewLine]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"calculating T-X(CO2) data at \"\>", "\[InvisibleSpace]", 
   "5000", "\[InvisibleSpace]", "\<\" bar of the reaction:\"\>"}],
  SequenceForm["calculating T-X(CO2) data at ", 5000, " bar of the reaction:"],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270732903125*^9, 3.422769126484375*^9, 
  3.46096632740625*^9, 3.4854944796359377`*^9, 3.4857513695808115`*^9, 
  3.485752163020913*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "cal"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "co2"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "tr"}], ",", 
     RowBox[{"5.`", " ", "dol"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"8.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.86`", ",", "1", ",", "\<\"am\"\>", ",", "1", ",", "1", ",", "1"}], 
    "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.42270732903125*^9, 3.422769126484375*^9, 
  3.46096632740625*^9, 3.4854944796359377`*^9, 3.4857513695808115`*^9, 
  3.485752163036538*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "467.57136976711854`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "0.1`"}],
  SequenceForm[467.57136976711854`, " ", 0.1],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270732903125*^9, 3.422769126484375*^9, 
  3.46096632740625*^9, 3.4854944796359377`*^9, 3.4857513695808115`*^9, 
  3.485752163177164*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "494.28651336369865`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "0.2`"}],
  SequenceForm[494.28651336369865`, " ", 0.2],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270732903125*^9, 3.422769126484375*^9, 
  3.46096632740625*^9, 3.4854944796359377`*^9, 3.4857513695808115`*^9, 
  3.485752163302165*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "511.2080869977159`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.30000000000000004`"}],
  SequenceForm[511.2080869977159, " ", 0.30000000000000004`],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270732903125*^9, 3.422769126484375*^9, 
  3.46096632740625*^9, 3.4854944796359377`*^9, 3.4857513695808115`*^9, 
  3.485752163442791*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "525.8008602694165`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.4`"}],
  SequenceForm[525.8008602694165, " ", 0.4],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270732903125*^9, 3.422769126484375*^9, 
  3.46096632740625*^9, 3.4854944796359377`*^9, 3.4857513695808115`*^9, 
  3.485752163536542*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "540.0349749828699`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.5`"}],
  SequenceForm[540.0349749828699, " ", 0.5],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270732903125*^9, 3.422769126484375*^9, 
  3.46096632740625*^9, 3.4854944796359377`*^9, 3.4857513695808115`*^9, 
  3.485752163599042*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "554.6661319881143`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.6`"}],
  SequenceForm[554.6661319881143, " ", 0.6],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270732903125*^9, 3.422769126484375*^9, 
  3.46096632740625*^9, 3.4854944796359377`*^9, 3.4857513695808115`*^9, 
  3.4857521636615424`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "570.2384966158032`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.7`"}],
  SequenceForm[570.2384966158032, " ", 0.7],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270732903125*^9, 3.422769126484375*^9, 
  3.46096632740625*^9, 3.4854944796359377`*^9, 3.4857513695808115`*^9, 
  3.485752163739668*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "587.6566529403432`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.7999999999999999`"}],
  SequenceForm[587.6566529403432, " ", 0.7999999999999999],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270732903125*^9, 3.422769126484375*^9, 
  3.46096632740625*^9, 3.4854944796359377`*^9, 3.4857513695808115`*^9, 
  3.4857521638021684`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "609.7306855031651`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.8999999999999999`"}],
  SequenceForm[609.7306855031651, " ", 0.8999999999999999],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270732903125*^9, 3.422769126484375*^9, 
  3.46096632740625*^9, 3.4854944796359377`*^9, 3.4857513695808115`*^9, 
  3.485752163864669*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3.`"}], " ", "cal"}], ",", 
          RowBox[{
           RowBox[{"-", "7.`"}], " ", "co2"}], ",", 
          RowBox[{
           RowBox[{"-", "1.`"}], " ", "tr"}], ",", 
          RowBox[{"5.`", " ", "dol"}], ",", 
          RowBox[{"1.`", " ", "h2o"}], ",", 
          RowBox[{"8.`", " ", "qz"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "0.86`", ",", "1", ",", "\<\"am\"\>", ",", "1", ",", "1", ",", "1"}],
          "}"}]}], "}"}], 
      ",", "\<\"{a(cal)=0.86, a(co2)={FluidActivityModel -> KerrickJacobs81, \
FluidSystem -> H2OCO2}, a(tr)=0.1, a(dol)=1, a(h2o)={FluidActivityModel -> \
KerrickJacobs81, FluidSystem -> H2OCO2}, a(qz)=1}\"\>", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.1`", ",", "467.571`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.2`", ",", "494.287`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.3`", ",", "511.208`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.4`", ",", "525.801`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5`", ",", "540.035`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.6`", ",", "554.666`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.7`", ",", "570.238`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.8`", ",", "587.657`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.9`", ",", "609.731`"}], "}"}]}], "}"}]}], "}"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dataset -> B88\"\>", ",", "\<\"SampleFile->None\"\>", 
     ",", "\<\"PinTX->5000\"\>"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.4227073301875*^9, 3.422769127640625*^9, 
  3.460966328265625*^9, 3.4854944804952965`*^9, 3.48575137044022*^9, 
  3.485752163864669*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "16"}], ":", " ", 
    RowBox[{
     RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
     "CalcRea", "-", " ", 
     RowBox[{"to", " ", "calculate", " ", "a", " ", "T"}], "-", 
     RowBox[{"X", 
      RowBox[{"(", "CO2", ")"}], " ", "diagram", " ", "for", " ", "the", " ", 
      RowBox[{"phases", ":", " ", 
       RowBox[{"{", 
        RowBox[{
        "zo", ",", " ", "an", ",", " ", "ma", ",", " ", "cal", ",", " ", "qz",
          ",", " ", "h2o", ",", " ", "co2"}], "}"}]}]}]}]}], " ", "*)"}], " ",
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phases", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
      "zo", ",", " ", "an", ",", " ", "ma", ",", " ", "cal", ",", " ", "qz", 
       ",", " ", "h2o", ",", " ", "co2"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"rea", " ", "=", 
    RowBox[{"MakeRea", "[", 
     RowBox[{"phases", ",", " ", 
      RowBox[{"MakeReaMode", "\[Rule]", "1"}]}], "]"}]}], "  ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"use", " ", "option", "  ", "MakeReaMode"}], "\[Rule]", 
     RowBox[{
     "1", " ", "to", " ", "find", " ", "all", " ", "possible", " ", 
      "reactions"}]}], "  ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r1", "=", 
     RowBox[{"CalcRea", "[", 
      RowBox[{"rea", ",", 
       RowBox[{"CalcReaMode", "\[Rule]", "TXCO2"}], ",", 
       RowBox[{"CalcReaMin", "\[Rule]", "0.02"}], ",", 
       RowBox[{"CalcReaMax", "\[Rule]", "0.5"}], ",", 
       RowBox[{"Steps", "\[Rule]", "20"}], ",", 
       RowBox[{"Screen", "\[Rule]", "ScreenNo"}], ",", 
       RowBox[{"SampleFile", "->", "\"\<None\>\""}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRea", "[", "r1", "]"}], "\[IndentingNewLine]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating reactions with \"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\" phases\"\>"}],
  SequenceForm["Calculating reactions with ", 6, " phases"],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.485752163880294*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(degree of freedom =  \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" ): from combinatorics, there are \"\>", 
   "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\" possible reactions.\"\>"}],
  SequenceForm[
  "(degree of freedom =  ", 1, " ): from combinatorics, there are ", 7, 
   " possible reactions."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.485752163895919*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating reactions with \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" phases\"\>"}],
  SequenceForm["Calculating reactions with ", 5, " phases"],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.485752163911544*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(degree of freedom =  \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" ): from combinatorics, there are \"\>", 
   "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\" possible reactions.\"\>"}],
  SequenceForm[
  "(degree of freedom =  ", 2, " ): from combinatorics, there are ", 21, 
   " possible reactions."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.485752163927169*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating reactions with \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" phases\"\>"}],
  SequenceForm["Calculating reactions with ", 4, " phases"],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.4857521639427943`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(degree of freedom =  \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" ): from combinatorics, there are \"\>", 
   "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\" possible reactions.\"\>"}],
  SequenceForm[
  "(degree of freedom =  ", 3, " ): from combinatorics, there are ", 35, 
   " possible reactions."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.4857521639427943`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating reactions with \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" phases\"\>"}],
  SequenceForm["Calculating reactions with ", 3, " phases"],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.48575216398967*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(degree of freedom =  \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" ): from combinatorics, there are \"\>", 
   "\[InvisibleSpace]", "35", 
   "\[InvisibleSpace]", "\<\" possible reactions.\"\>"}],
  SequenceForm[
  "(degree of freedom =  ", 4, " ): from combinatorics, there are ", 35, 
   " possible reactions."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.485752164005295*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating reactions with \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" phases\"\>"}],
  SequenceForm["Calculating reactions with ", 2, " phases"],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.48575216402092*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(degree of freedom =  \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" ): from combinatorics, there are \"\>", 
   "\[InvisibleSpace]", "21", 
   "\[InvisibleSpace]", "\<\" possible reactions.\"\>"}],
  SequenceForm[
  "(degree of freedom =  ", 5, " ): from combinatorics, there are ", 21, 
   " possible reactions."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.485752164036545*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "cal"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "co2"}], ",", 
     RowBox[{"1.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"5.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "cal"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "co2"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "cal"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "co2"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "cal"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "qz"}], ",", 
     RowBox[{"5.`", " ", "co2"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.4227073425*^9, 3.422769130046875*^9, 3.4609663301875*^9, 
  3.48549448263588*^9, 3.4857513706121016`*^9, 3.48575216405217*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"calculating T-X(CO2) data at \"\>", "\[InvisibleSpace]", 
   "5000", "\[InvisibleSpace]", "\<\" bar of the reaction:\"\>"}],
  SequenceForm["calculating T-X(CO2) data at ", 5000, " bar of the reaction:"],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.48575216405217*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "cal"}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
   RowBox[{
    RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
   RowBox[{"2.`", " ", "an"}], ",", 
   RowBox[{"1.`", " ", "co2"}], ",", 
   RowBox[{"1.`", " ", "h2o"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.4857521640677953`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"calculating T-X(CO2) data at \"\>", "\[InvisibleSpace]", 
   "5000", "\[InvisibleSpace]", "\<\" bar of the reaction:\"\>"}],
  SequenceForm["calculating T-X(CO2) data at ", 5000, " bar of the reaction:"],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.48575216641156*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
   RowBox[{
    RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
   RowBox[{
    RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
   RowBox[{"5.`", " ", "an"}], ",", 
   RowBox[{"2.`", " ", "h2o"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.48575216641156*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"calculating T-X(CO2) data at \"\>", "\[InvisibleSpace]", 
   "5000", "\[InvisibleSpace]", "\<\" bar of the reaction:\"\>"}],
  SequenceForm["calculating T-X(CO2) data at ", 5000, " bar of the reaction:"],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.485752167849069*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "an"}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "cal"}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
   RowBox[{"1.`", " ", "co2"}], ",", 
   RowBox[{"2.`", " ", "zo"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.4857521678646946`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"calculating T-X(CO2) data at \"\>", "\[InvisibleSpace]", 
   "5000", "\[InvisibleSpace]", "\<\" bar of the reaction:\"\>"}],
  SequenceForm["calculating T-X(CO2) data at ", 5000, " bar of the reaction:"],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.4857521702240844`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "an"}], ",", 
   RowBox[{
    RowBox[{"-", "2.`"}], " ", "cal"}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
   RowBox[{
    RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
   RowBox[{"2.`", " ", "co2"}], ",", 
   RowBox[{"2.`", " ", "zo"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.4857521702240844`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"calculating T-X(CO2) data at \"\>", "\[InvisibleSpace]", 
   "5000", "\[InvisibleSpace]", "\<\" bar of the reaction:\"\>"}],
  SequenceForm["calculating T-X(CO2) data at ", 5000, " bar of the reaction:"],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.4857521713334665`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "5.`"}], " ", "cal"}], ",", 
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
   RowBox[{
    RowBox[{"-", "6.`"}], " ", "qz"}], ",", 
   RowBox[{"5.`", " ", "co2"}], ",", 
   RowBox[{"1.`", " ", "h2o"}], ",", 
   RowBox[{"4.`", " ", "zo"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707342296875*^9, 3.422769129828125*^9, 
  3.460966330015625*^9, 3.4854944824640083`*^9, 3.485751370455845*^9, 
  3.4857521713490915`*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{{{{{{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQXS2yzv1h1RT7N4E75FoP1jhwXV9cYMu13H7b579X
Kl7WOkyWYAnj091kr27IsUamos7hV13WnpLJO+wXuQJVnKtzSHh6Qen2z332
Lt05z39z1js8Xjr7iMKGQ/YbijImvjWpdwCplmA5Zv9NI6b/UGi9w7z3y495
m5+0B+vLr3e4CNRdl3XG/gNIuLXeAWzb3PP2PEza7WLT6x3cwA65aP9n5cdL
vsvqHe77907PE7ps33/oq0bM5nqHypdqQJddsf8RDLR5X72DUPOBUwtdr9mD
/XGi3gFs3Pvr9quA2pMu1DuA7em8ad/6Gujh6/UOnY5gl9jPAbq66E69gzLI
OXvu2AND43Xgg3qHNDC4Zy8P0vCo3oEBDB7Yp1gDXfK43gEAd0miJw==
          "]]}}, {{}, {}, 
        {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQXS2yzv1h1RT7N4E75FoP1jhwXV9cYMu13H7b579X
Kl7WOkyWYAnj091kr27IsUamos7hV13WnpLJO+wXuQJVnKtzSHh6Qen2z332
Lt05z39z1js8Xjr7iMKGQ/YbijImvjWpdwCplmA5Zv9NI6b/UGi9w7z3y495
m5+0B+vLr3e4CNRdl3XG/gNIuLXeAWzb3PP2PEza7WLT6x3cwA65aP9n5cdL
vsvqHe77907PE7ps33/oq0bM5nqHypdqQJddsf8RDLR5X72DUPOBUwtdr9mD
/XGi3gFs3Pvr9quA2pMu1DuA7em8ad/6Gujh6/UOnY5gl9jPAbq66E69gzLI
OXvu2AND43Xgg3qHNDC4Zy8P0vCo3oEBDB7Yp1gDXfK43gEAd0miJw==
          "]]}}}, {{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQXS2yzv1h1RR7H/NOx4SZ9Q5c1xcX2HItt/fiYdJu
b6t3mCzBEsanu8n+m0ZM/6HSeodfdVl7SibvsN9yomzf/LR6h4SnF5Ru/9xn
L9/6OnBHRL3D46WzjyhsOGR/8NRC123e9Q4g1RIsx+znvV9+zNu+3gFMm5+0
XyMTlWJtXO9wEai7LuuMvSpb41Rn9XoHsG1zz0Pkpesd3LZ9/nul4qL9hqKM
iW/56h3u+/dOzxO6bD/xbY29KVO9Q+VLNUOONVfswf74Uucg1HwAaPM1e7C+
Z3UOYOPeX7ef5tyd8/x6ncMHkPWdN+3bxW6e+368zgHoa5AP7PfNl9K/u63O
QRnknD137MHBsqTOIQ0M7tkX2gJDZkKdAwMYPLAvB2mornMAAIbZmPw=
         "]]}}}, {{}, {}, 
      {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQXS2yzv1h1RT7mP5DXzWedDpwXV9cYMu13N680zHh
aVuLw2QJljA+3U32YOH0JodfdVl7SibvsAdrM2x0SHh6Qen2z332894vP+ad
3uDweOnsIwobDtmDVElsqncA0yzH7G1BBt+vcwCrMz9p77bt898rNnUOF4G6
67LO2PdOzxNq3lXrALZt7nn7NBDwq3UAq6u4aG+55UTZvo81Dvf9QSov259e
6Lrt8/wah8qXaoYca67YLwE673pojYNQ84FTC12v2QeAlAnWOICNe3/d3qU7
5/nv89UOH0DWd960F7957nvwxGoHkDeBPoD4P6TaQRnknD137A8CTdkmXu0A
dkfaPXuONTJRKberHBjA4IH9MpA351U5AABE9pyw
        "]]}}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQXS2yzv1h1RT7gN7peUJbKx24ri8usOVabm9vGrfL
81m1w2QJljA+3U32IOlmhVqHX3VZe0om77D/sPyYt/nXWoeEpxeUbv/cZ59i
fd+/d3Kdw+Ols48obDhk/7AKaLBgvQNItQTLMfsFUvp3VarqHea9B2k8aV++
b76U/tV6h4tA3XVZZ+yPKmwoyhBucADbNve8/SLXbZ//WjQ4uAGpKxUX7S/7
JglExDQ4AG0BuuQyxLy6BofKl2qGHGuu2Jt3OiY8ndfgINR84NRC12v2uc9/
r/y4r8EBbNz76/YrgLZ23mtwALu786Y9k3a72M2/DQ4gbUAf2AN9y8Mk2+ig
DHLOnjv2J8uADrRpdEgDg3v2xiAQ3ejAAAYP7MVvnvseXNXoAACICpYx
       "]]}}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQXS2yzv1h1RR7ljA+3U1bqxy4ri8usOVabl+ftadk
8pwah8kSYBn7GXlCzQfm1Tr8qgNJ7LB/WAXU6F7nkPD0gtLtn/vsweoO1jk8
Xjr7iMKGQ/bGICBf7wBSLcFyzN5yy4myfdn1DvPeLz/mbX7S/vBXjZj+NfUO
F4G667LO2IPFn9Y7gG2be95+gZT+XRWeBge3bZ//Xqm4aK+4oShjonKDw33/
3ul5Qpftwe6wbHCofKlmyLHmiv0uTx4mbb8GB6ArTy10vWbfLnbz3PfEBgew
ce+v20sDjWMrbXD4ALK+8yZEf3uDQ6cj2Af2l32TBCJmNjgog5yz5459rb1p
3K5VDQ5pYHDPHmzu7gYHBjB4AJL15DnT4AAAZQ2UOg==
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 460.},
  DisplayFunction->Identity,
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.4227073425*^9, 3.422769130046875*^9, 3.4609663301875*^9, 
  3.48549448263588*^9, 3.4857513706121016`*^9, 3.485752173536606*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "  ", 
   RowBox[{
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", "   ", 
                    RowBox[{
                    "-", "CalcRea"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
    "-", "    ", 
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", "-"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], "  ",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "  ", 
   RowBox[{
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", " ", "Redox"}]}]}]}]}]}]}]}]}]}]}]}]}], " ", 
    RowBox[{"reactions", ":", "  ", 
     RowBox[{"T", "-", 
      RowBox[{"X", 
       RowBox[{"(", "H2", ")"}], " ", "and", " ", "logf", 
       RowBox[{"(", "O2", ")"}]}], "-", 
      RowBox[{"T", " ", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"equilibria", "  ", "--"}], "--"}], "--"}], 
                    "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], 
                 "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], 
          "--"}], "--"}], "--"}]}], "-"}]}]}], "  ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "17"}], ":", " ", 
     RowBox[{
      RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
      "CalcRea", "-", " ", 
      RowBox[{"to", " ", "calculate", " ", "a", " ", "redox", " ", 
       RowBox[{"reaction", ":", " ", "Ann"}]}]}]}], " ", "=", " ", 
    RowBox[{"San", " ", "+", " ", "Mag", " ", "+", " ", "H2"}]}], " ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"In", " ", "this", " ", "example", " ", "T"}], "-", 
    RowBox[{"X", 
     RowBox[{"(", "H2", ")"}], " ", "data", " ", "are", " ", "calculated"}]}],
    " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phases", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"ann", ",", "san", ",", "mt", ",", "h2"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"rea", " ", "=", 
     RowBox[{"MakeRea", "[", "phases", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"r1", "=", 
    RowBox[{"CalcRea", "[", 
     RowBox[{"rea", ",", 
      RowBox[{"CalcReaMode", "\[Rule]", "TXH2"}], ",", 
      RowBox[{"CalcReaMin", "\[Rule]", "0.00005"}], ",", 
      RowBox[{"CalcReaMax", "\[Rule]", "0.005"}], ",", 
      RowBox[{"Steps", "\[Rule]", "10"}], ",", 
      RowBox[{"Screen", "\[Rule]", "ScreenYes"}], ",", 
      RowBox[{"SampleFile", "->", "\"\<None\>\""}]}], "]"}]}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"calculating T-X(H2) data at \"\>", "\[InvisibleSpace]", "5000",
    "\[InvisibleSpace]", "\<\" bar of the reaction:\"\>"}],
  SequenceForm["calculating T-X(H2) data at ", 5000, " bar of the reaction:"],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707367046875*^9, 3.42276915084375*^9, 
  3.42277482046875*^9, 3.422775065921875*^9, 3.46096634240625*^9, 
  3.4854944987605705`*^9, 3.4857513801749687`*^9, 3.485752173552231*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "ann"}], ",", 
   RowBox[{"1.`", " ", "h2"}], ",", 
   RowBox[{"1.`", " ", "mt"}], ",", 
   RowBox[{"1.`", " ", "san"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707367046875*^9, 3.42276915084375*^9, 
  3.42277482046875*^9, 3.422775065921875*^9, 3.46096634240625*^9, 
  3.4854944987605705`*^9, 3.4857513801749687`*^9, 3.485752173567856*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "471.10951946494083`", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "0.00005`"}],
  SequenceForm[471.10951946494083`, " ", 0.00005],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707367046875*^9, 3.42276915084375*^9, 
  3.42277482046875*^9, 3.422775065921875*^9, 3.46096634240625*^9, 
  3.4854944987605705`*^9, 3.4857513801749687`*^9, 3.485752173599106*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "648.8988489518968`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.0006000000000000001`"}],
  SequenceForm[648.8988489518968, " ", 0.0006000000000000001],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707367046875*^9, 3.42276915084375*^9, 
  3.42277482046875*^9, 3.422775065921875*^9, 3.46096634240625*^9, 
  3.4854944987605705`*^9, 3.4857513801749687`*^9, 3.4857521736147313`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "709.4764647417754`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.00115`"}],
  SequenceForm[709.4764647417754, " ", 0.00115],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707367046875*^9, 3.42276915084375*^9, 
  3.42277482046875*^9, 3.422775065921875*^9, 3.46096634240625*^9, 
  3.4854944987605705`*^9, 3.4857513801749687`*^9, 3.4857521736459813`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "750.468127306493`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "0.0017000000000000001`"}],
  SequenceForm[750.468127306493, " ", 0.0017000000000000001`],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707367046875*^9, 3.42276915084375*^9, 
  3.42277482046875*^9, 3.422775065921875*^9, 3.46096634240625*^9, 
  3.4854944987605705`*^9, 3.4857513801749687`*^9, 3.485752173677232*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "782.4006946467194`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.0022500000000000003`"}],
  SequenceForm[782.4006946467194, " ", 0.0022500000000000003`],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707367046875*^9, 3.42276915084375*^9, 
  3.42277482046875*^9, 3.422775065921875*^9, 3.46096634240625*^9, 
  3.4854944987605705`*^9, 3.4857513801749687`*^9, 3.485752173708482*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "808.988384917396`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "0.0028000000000000004`"}],
  SequenceForm[808.988384917396, " ", 0.0028000000000000004`],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707367046875*^9, 3.42276915084375*^9, 
  3.42277482046875*^9, 3.422775065921875*^9, 3.46096634240625*^9, 
  3.4854944987605705`*^9, 3.4857513801749687`*^9, 3.485752173739732*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "832.0081249458689`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.0033500000000000005`"}],
  SequenceForm[832.0081249458689, " ", 0.0033500000000000005`],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707367046875*^9, 3.42276915084375*^9, 
  3.42277482046875*^9, 3.422775065921875*^9, 3.46096634240625*^9, 
  3.4854944987605705`*^9, 3.4857513801749687`*^9, 3.4857521737709823`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "852.4584553496976`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.0039000000000000007`"}],
  SequenceForm[852.4584553496976, " ", 0.0039000000000000007`],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707367046875*^9, 3.42276915084375*^9, 
  3.42277482046875*^9, 3.422775065921875*^9, 3.46096634240625*^9, 
  3.4854944987605705`*^9, 3.4857513801749687`*^9, 3.4857521738022327`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "870.9605578882694`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.004450000000000001`"}],
  SequenceForm[870.9605578882694, " ", 0.004450000000000001],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707367046875*^9, 3.42276915084375*^9, 
  3.42277482046875*^9, 3.422775065921875*^9, 3.46096634240625*^9, 
  3.4854944987605705`*^9, 3.4857513801749687`*^9, 3.4857521738334827`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "887.9291326187052`", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]",
    "0.005000000000000001`"}],
  SequenceForm[887.9291326187052, " ", 0.005000000000000001],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707367046875*^9, 3.42276915084375*^9, 
  3.42277482046875*^9, 3.422775065921875*^9, 3.46096634240625*^9, 
  3.4854944987605705`*^9, 3.4857513801749687`*^9, 3.4857521738647327`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1.`"}], " ", "ann"}], ",", 
        RowBox[{"1.`", " ", "h2"}], ",", 
        RowBox[{"1.`", " ", "mt"}], ",", 
        RowBox[{"1.`", " ", "san"}]}], "}"}], 
      ",", "\<\"{a(ann)=1, a(h2)={FluidActivityModel -> Holloway77, \
FluidSystem -> H2OH2}, a(mt)=1, a(san)=1}\"\>", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.`", ",", "471.11`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.001`", ",", "648.899`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.001`", ",", "709.476`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.002`", ",", "750.468`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.002`", ",", "782.401`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.003`", ",", "808.988`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.003`", ",", "832.008`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.004`", ",", "852.458`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.004`", ",", "870.961`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.005`", ",", "887.929`"}], "}"}]}], "}"}]}], "}"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dataset -> B88\"\>", ",", "\<\"SampleFile->None\"\>", 
     ",", "\<\"PinTX->5000\"\>"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.422707367515625*^9, 3.4227691513125*^9, 
  3.42277482084375*^9, 3.42277506628125*^9, 3.460966342765625*^9, 
  3.485494499104314*^9, 3.4857513805187316`*^9, 3.4857521738803577`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "18"}], ":", " ", 
     RowBox[{
      RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
      "CalcRea", "-", " ", 
      RowBox[{"to", " ", "calculate", " ", "the", " ", "redox", " ", 
       RowBox[{"reactions", ":", " ", "\[IndentingNewLine]", "Ann"}]}]}]}], 
    " ", "=", " ", 
    RowBox[{
     RowBox[{"San", " ", "+", " ", "Mag", " ", "+", " ", 
      RowBox[{"H2", " ", "and", " ", "the", " ", 
       RowBox[{"Hem", "/", "Mag"}], " ", 
       RowBox[{"buffer", ".", " ", "Use"}], " ", "a", 
       RowBox[{"(", "ann", ")"}]}]}], " ", "=", " ", 
     RowBox[{"0.8", " ", "in", " ", "the", " ", "calculation"}]}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"In", " ", "this", " ", "example", " ", "logf", 
      RowBox[{"(", "O2", ")"}]}], "-", 
     RowBox[{
     "T", " ", "data", " ", "are", " ", "calculated", " ", "for", " ", 
      "Ann"}]}], " ", "=", " ", 
    RowBox[{"San", " ", "+", " ", "Mag", " ", "+", " ", "H2"}]}], " ", "*)"}],
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phases", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"ann", ",", "san", ",", "mt", ",", "h2"}], "}"}]}], ";"}], "\n", 
   RowBox[{"rea", " ", "=", 
    RowBox[{"MakeRea", "[", "phases", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"rea", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"rea", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}], 
     "}"}]}], "\n", 
   RowBox[{
    RowBox[{"r1", "=", 
     RowBox[{"CalcRea", "[", 
      RowBox[{"rea", ",", 
       RowBox[{"CalcReaMode", "\[Rule]", "TXH2logfO2"}], ",", 
       RowBox[{"CalcReaMin", "\[Rule]", "0.00005"}], ",", 
       RowBox[{"CalcReaMax", "\[Rule]", "0.005"}], ",", 
       RowBox[{"Steps", "\[Rule]", "2"}], ",", 
       RowBox[{"Screen", "\[Rule]", "ScreenNo"}], ",", 
       RowBox[{"SampleFile", "->", "\"\<None\>\""}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"phases", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"hem", ",", "mt", ",", "o2"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"rea", " ", "=", 
     RowBox[{"MakeRea", "[", "phases", "]"}]}], ";"}], "\n", 
   RowBox[{"r2", "=", 
    RowBox[{"CalcRea", "[", 
     RowBox[{"rea", ",", 
      RowBox[{"CalcReaMode", "\[Rule]", "logfO2T"}], ",", 
      RowBox[{"CalcReaMin", "\[Rule]", "400"}], ",", 
      RowBox[{"CalcReaMax", "\[Rule]", "600"}], ",", 
      RowBox[{"Steps", "\[Rule]", "10"}], ",", 
      RowBox[{"Screen", "\[Rule]", "ScreenNo"}], ",", 
      RowBox[{"SampleFile", "->", "\"\<None\>\""}]}], "]"}]}], "\n", 
   RowBox[{"PlotRea", "[", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"r1", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"r2", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.422774721328125*^9, {3.422775417171875*^9, 3.422775417546875*^9}, {
   3.4227764838125*^9, 3.422776495*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1.`"}], " ", "ann"}], ",", 
    RowBox[{"1.`", " ", "h2"}], ",", 
    RowBox[{"1.`", " ", "mt"}], ",", 
    RowBox[{"1.`", " ", "san"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.422707373578125*^9, 3.422769154375*^9, 3.422775524625*^9,
   3.42277625034375*^9, 3.422776504234375*^9, 3.460966344640625*^9, 
  3.4854945011042757`*^9, 3.485751380534357*^9, 3.4857521738959827`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1.`"}], " ", "ann"}], ",", 
      RowBox[{"1.`", " ", "h2"}], ",", 
      RowBox[{"1.`", " ", "mt"}], ",", 
      RowBox[{"1.`", " ", "san"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.8`", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.422707373578125*^9, 3.422769154375*^9, 3.422775524625*^9,
   3.42277625034375*^9, 3.422776504234375*^9, 3.460966344640625*^9, 
  3.4854945011042757`*^9, 3.485751380534357*^9, 3.4857521739116077`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"calculating logf(O2)-T data at \"\>", "\[InvisibleSpace]", 
   "5000", "\[InvisibleSpace]", "\<\" bar of the reaction:\"\>"}],
  SequenceForm[
  "calculating logf(O2)-T data at ", 5000, " bar of the reaction:"],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707373578125*^9, 3.42276915440625*^9, 
  3.4227755245625*^9, 3.422776250296875*^9, 3.422776504234375*^9, 
  3.46096634465625*^9, 3.4854945011199*^9, 3.485751380549983*^9, 
  3.4857521739116077`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ann"}], ",", 
     RowBox[{"1.`", " ", "h2"}], ",", 
     RowBox[{"1.`", " ", "mt"}], ",", 
     RowBox[{"1.`", " ", "san"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8`", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707373578125*^9, 3.42276915440625*^9, 
  3.4227755245625*^9, 3.422776250296875*^9, 3.422776504234375*^9, 
  3.46096634465625*^9, 3.4854945011199*^9, 3.485751380549983*^9, 
  3.485752173927233*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"calculating logfO2-T data at \"\>", "\[InvisibleSpace]", 
   "5000", "\[InvisibleSpace]", "\<\" bar of the reaction:\"\>"}],
  SequenceForm["calculating logfO2-T data at ", 5000, " bar of the reaction:"],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707373578125*^9, 3.42276915440625*^9, 
  3.4227755245625*^9, 3.422776250296875*^9, 3.422776504234375*^9, 
  3.46096634465625*^9, 3.4854945011199*^9, 3.485751380549983*^9, 
  3.4857521739897337`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "6.`"}], " ", "hem"}], ",", 
   RowBox[{"4.`", " ", "mt"}], ",", 
   RowBox[{"1.`", " ", "o2"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707373578125*^9, 3.42276915440625*^9, 
  3.4227755245625*^9, 3.422776250296875*^9, 3.422776504234375*^9, 
  3.46096634465625*^9, 3.4854945011199*^9, 3.485751380549983*^9, 
  3.4857521739897337`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "6.`"}], " ", "hem"}], ",", 
        RowBox[{"4.`", " ", "mt"}], ",", 
        RowBox[{"1.`", " ", "o2"}]}], "}"}], 
      ",", "\<\"{a(hem)=1, a(mt)=1, a(o2)=1}\"\>", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"400.`", ",", 
          RowBox[{"-", "23.49`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"422.222`", ",", 
          RowBox[{"-", "22.277`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"444.444`", ",", 
          RowBox[{"-", "21.136`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"466.667`", ",", 
          RowBox[{"-", "20.059`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"488.889`", ",", 
          RowBox[{"-", "19.039`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"511.111`", ",", 
          RowBox[{"-", "18.073`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"533.333`", ",", 
          RowBox[{"-", "17.153`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"555.556`", ",", 
          RowBox[{"-", "16.277`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"577.778`", ",", 
          RowBox[{"-", "15.438`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"600.`", ",", 
          RowBox[{"-", "14.635`"}]}], "}"}]}], "}"}]}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dataset -> B88\"\>", ",", "\<\"SampleFile->None\"\>"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.422707373578125*^9, 3.422769154375*^9, 3.422775524625*^9,
   3.42277625034375*^9, 3.422776504234375*^9, 3.460966344640625*^9, 
  3.4854945011042757`*^9, 3.485751380534357*^9, 3.4857521740209837`*^9}],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{484.839, -30.151}, {922.208, -17.773}}]}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{484.839, -30.151}, {922.208, -17.773}}]}}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{400., -23.49}, {422.222, -22.277}, {444.444, -21.136}, {
      466.667, -20.059}, {488.889, -19.039}, {511.111, -18.073}, {
      533.333, -17.153}, {555.556, -16.277}, {577.778, -15.438}, {
      600., -14.635}}]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{500., -30.},
  DisplayFunction->Identity,
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.422707373578125*^9, 3.422769154375*^9, 3.422775524625*^9,
   3.42277625034375*^9, 3.422776504234375*^9, 3.460966344640625*^9, 
  3.4854945011042757`*^9, 3.485751380534357*^9, 3.4857521740366087`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "19"}], ":", " ", 
    RowBox[{
     RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
     "CalcRea", "-", " ", 
     RowBox[{
     "to", " ", "calculate", " ", "the", " ", "QFM", " ", "buffer", " ", 
      RowBox[{"reaction", ":", " ", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
        "Compare", " ", "this", " ", "to", " ", "results", " ", "from", " ", 
         "the", " ", "PET", " ", "function"}], " ", "-", "O2buffers", 
        "-"}]}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"phases", "=", 
    RowBox[{"{", 
     RowBox[{"qz", ",", "fa", ",", "mt", ",", "o2"}], "}"}]}], ";", " ", 
   RowBox[{"rea", "=", 
    RowBox[{"MakeRea", "[", "phases", "]"}]}], ";", " ", 
   RowBox[{"r1", "=", 
    RowBox[{"CalcRea", "[", 
     RowBox[{"rea", ",", 
      RowBox[{"CalcReaMode", "\[Rule]", "logfO2T"}], ",", 
      RowBox[{"CalcReaMin", "\[Rule]", "800"}], ",", 
      RowBox[{"CalcReaMax", "\[Rule]", "1000"}], ",", 
      RowBox[{"Steps", "\[Rule]", "21"}], ",", 
      RowBox[{"Screen", "\[Rule]", "ScreenNo"}], ",", 
      RowBox[{"SampleFile", "\[Rule]", "\"\<None\>\""}]}], "]"}]}], ";", " ", 
   RowBox[{"plot1", "=", 
    RowBox[{"PlotRea", "[", "r1", "]"}]}], ";", " ", 
   RowBox[{"plot2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"O2buffers", "[", 
        RowBox[{"5000", ",", 
         RowBox[{"t", "+", "273.15`"}], ",", 
         RowBox[{"Buffer", "\[Rule]", "QFM"}]}], "]"}], 
       "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "800", ",", "1000"}], "}"}]}], "]"}]}], ";", " ", 
   RowBox[{"Show", "[", 
    RowBox[{"plot1", ",", "plot2", ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"800", ",", "1000"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "15"}], ",", 
          RowBox[{"-", "10"}]}], "}"}]}], "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.422769214484375*^9, 3.422769259796875*^9}, {
  3.422776516265625*^9, 3.42277658521875*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"calculating logfO2-T data at \"\>", "\[InvisibleSpace]", 
   "5000", "\[InvisibleSpace]", "\<\" bar of the reaction:\"\>"}],
  SequenceForm["calculating logfO2-T data at ", 5000, " bar of the reaction:"],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270741028125*^9, 3.42276922728125*^9, 3.4227692685*^9, 
  3.422776270484375*^9, 3.422776588375*^9, 3.460966346859375*^9, 
  3.485494502916741*^9, 3.4857513806906133`*^9, 3.4857521740522337`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2.`"}], " ", "mt"}], ",", 
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
   RowBox[{"3.`", " ", "fa"}], ",", 
   RowBox[{"1.`", " ", "o2"}]}], "}"}]], "Print",
 CellChangeTimes->{3.42270741028125*^9, 3.42276922728125*^9, 3.4227692685*^9, 
  3.422776270484375*^9, 3.422776588375*^9, 3.460966346859375*^9, 
  3.485494502916741*^9, 3.4857513806906133`*^9, 3.4857521740522337`*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQGdDgIRlltOmOkcAHMDOh1m5Ak1HzilDeEv6HQI
ebx09pEEKP9Dp4Pbts9/r/zQgvAduhzu+/dOz5sE5U/ocljn/rBKRA/Kf9Dl
sGnu++XHTmtC+AbdDnG7PHmYsqH8hm6IPDeUf6Ebon+dBoSv0AMxPwjKL+hx
0G4Xu3nuuzqEf6DHYY1MVIr1fChfoNfBA6TdHcpP6HWQZAnj0/2kBuFv6HUA
cTfNhfIZ+hy4ri8usPWC8gP6oP5Thfq/z2HOEYUNRSug/A99DjxMQBdEQvkO
/Q6qbI1TnblVDwAARxtsKA==
       "]]}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQBWIQDQGdDgIRlltOmOkcAHMDOh1m5Ak1HzilDeEv6HQI
ebx09pEEKP9Dp4Pbts9/r/zQgvAduhzu+/dOz5sE5U/ocljn/rBKRA/Kf9Dl
sGnu++XHTmtC+AbdDnG7PHmYsqH8hm6IPDeUf6Ebon+dBoSv0AMxPwjKL+hx
0G4Xu3nuuzqEf6DHYY1MVIr1fChfoNfBA6TdHcpP6HWQZAnj0/2kBuFv6HUA
cTfNhfIZ+hy4ri8usPWC8gP6oP5Thfq/z2HOEYUNRSug/A99DjxMQBdEQvkO
/Q6qbI1TnblVDwAARxtsKA==
       "]]}}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0ns4VAkcxvGRZ9NKDZLmcVkrnbmYE5GQMn7dRJJrW6jsKjHpJiqKVmFy
5nZYKSqmhEhNN5faB/1WuyW1JLRGSdmN0tDuhp1Nsmf/eJ/v8/n/tY3aExw9
hcVi+TP7vx3tdkwoWBqXdIKlIrEkpep8KuPSEqcV3xSRmECsWjbOeMhoaKyy
kETTg9vTxvQoKDwo3rXhLIlBFhWftfoUKMz2nVQXkNjyrcO4xoCCy/GKrs0n
SGwach+5yaZgZvEqS6RIrDdY1x9jQwFlQytyE0l065pnnLiMArfcZPGwN4me
5noq0XcUdAW0ny+2IvFw254scRoFjRVn5iZ9EOIagazWvZgCd3FUEnFfiKXD
lX73fqKARUVrzYuEmBOYTOh+p0B1bNOWoXghVjtqwqRfSIE7QWr7vYUYnSL6
0D1PCi9rxWq2jRDLogOftHpL4bYltJAj9phQF2Oevl0KrlP3Re1+ZI/J2SbV
JzOlYCjyUtaX2qOxXmzBuotS6OoJV7FT7HFh792+n+9JobPp60/71tvjQNij
+N43UvAJ+cXjtdAe24NiIsINZbA1vbtzu749+tUaXMoVyCBnckzT3yPA0Nuh
ong/GTQsNGhKrxbgW/5FtxlxMoiJCNoxO1uA7EVlB/wVMrj8MCq0NUaAuxvc
jIfVMkjnp5gpQYAbq1tm+rfIoHOuptzRSoAdPqYhgX/K4EDlnM6po3x85hvx
ycRYDnUua0trH/PRssmV5eIoh4nQUwPhV/io7Wvw/Rgoh3KPinA4zkffuLW6
I3vl4LC3eer7rXx0y5ZoL/4gh2dLOKsHPfm42TlkiVOVHCxsMs9qOHxkLyfe
J7XLoYf7evToGA+Dhy+82TYqh47AOWbpbTy0ncZfzZ6tgF7PmlcuV3koUIlY
Fi4KcKxP5jQreNj4RG+yab0CNsz6u+iumIcDCc1RrvsVIEocfLfFh4eF172M
fE4pYGN5llHsPB72bvrRglOrYP56+8vp+jwMy7yf7vNUAUkpDkepPi5uW3PU
2VqngJK44gdpd7g4ngLe1+YowVqd1aiv4qLd2suqgcVKePX21plpKVxMz78U
8n2EEpybIuMHw7i4J1i9s/OQEkzE70Z8PbioLd/ysPWsEqIPe7JcOVwc3WlG
Z9UpYbR1uiRfR6CbetOV88+UYJ43W/VAQ6ChPMgkckIJqZncsJxbBIp/8+vu
tqJhaHLGhcYCAus43btjrGn4Z+n11MWMjcNj9UcYfx4di7iWT2DN8wxyhg0N
j53FdkWnCJzSV3/Ey5aGR4v+6EnOI/C01tGuhKBhfiRbzzmHwGY9s527HGjI
u2I6WZJFoPWKYtZHxoWym/5WjPdmLMiTONJgp/pLlXucQHMD/wbVAhrWN6wM
OCYhMMpIYvzEmYaalcs1kRkEjpvrqlzdaIi4uf+0ZRqB6zZKfO8ydnF/Ojf3
ewKLC8xeBLjT8DK4TW3I2MfKyUC8mAZO8cm2f1MJPGG7I+zMEhryZ4Ut7zpM
4ECUboi3lIa4G9RAAGOPEsmxKsbz80Oy7x8i8CX3QuWvnjSY5NzQ1iQTuDDW
CcJFNJwLXH3OgbGk4k5HP+MXVxM3lCURqBn0Fyd40aDL8DD9ijFJPp+YZCwq
y3+cd5DA/wBoQEBl
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{800., -14.},
  DisplayFunction->Identity,
  PlotRange->{{800, 1000}, {-15, -10}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.42270741153125*^9, 3.4227692285*^9, 3.422769268640625*^9,
   3.4227762706875*^9, 3.42277658853125*^9, 3.46096634696875*^9, 
  3.4854945030261135`*^9, 3.4857513807999926`*^9, 3.4857521741616096`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "  ", 
   RowBox[{
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"-", "   ", 
                    RowBox[{
                    "-", "MakeRea"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
    "-", "     ", 
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{
                    "--", "-"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], "  ",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "display", " ", "the", " ", "usage", " ", "for", " ", "the", " ", "PET"}],
     "-", "functions", " ", "-", "MakeRea", "-"}], "  ", "*)"}], 
  "\[IndentingNewLine]", " ", "\[IndentingNewLine]", 
  RowBox[{"MakeRea", "::", "usage"}]}]], "Input"],

Cell[BoxData["\<\"MakeRea[{list_of_phase_components}]\\ncalculates for a \
user-defined list of phase components the reactions that can be\\nwritten \
among them (abbreviations as shown by MinList[] must be used).\\nThe \
following option is available with -MakeRea-:\\n\\nName           value       \
   meaning\\n\\nMakeReaMode -> 0 (default)    calculate a set of linearly \
independent reactions\\n               1              calculate all possible \
reactions (search algorithm)\\n               2              calculate all \
possible reactions (algorithm of\\n                              Powell \
(1990), Contrib Mineral Petrol 106:61-65)\\n\\nCalculating all possible \
reactions: The search algorithm (MakeReaMode -> 1) works somewhat\\nslowlier \
than the algorithm of Powell (1990) (MakeReaMode -> 2), but the latter may \
not find\\nall reactions in cases where colinearities exists between phase \
components.\\nReturnValue: {reaction 1, reaction 2,...},\\nwhere each \
reaction is a list of the form: {sc1*pc1, sc2*pc2, sc3*pc3, ...}\\n(sc = \
stoichiometric coefficient in the reaction, pc = phase \
component-abbreviation).\\n\\nExample:\\nphases = {ann, phl, alm, py, gr, an, \
qz, sil};\\nrea = MakeRea[phases]\\n{{-3. an, 1. gr, 1. qz, 2. sil}, {-1. \
alm, -1. phl, 1. ann, 1. py}}\\n\\nThis returns the GASP-reaction and the \
grt-bt thermometer as linearly independent reactions.\\nSee PET_CalcRea.nb \
for more examples.\\nCalled from: User.\\nCalls: -MakeCompositionMatrix-, \
-NullSpace-.\\nPackage name: UTILITY.m\\nPET: Petrological Elementary Tools, \
(c) Edgar Dachs.\"\>"], "Output",
 CellChangeTimes->{3.422707467953125*^9, 3.42277460421875*^9, 
  3.46096634865625*^9, 3.4854945051823225`*^9, 3.485751380815618*^9, 
  3.4857521741772346`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "20"}], ":", " ", 
     RowBox[{
      RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
      "MakeCompositionMatrix", "-", " ", 
      RowBox[{
      "to", " ", "calculate", " ", "the", " ", "composition", " ", "matrix", 
       " ", "of", " ", "the", "\[IndentingNewLine]", "phases", " ", 
       "mu"}]}]}], ",", " ", "qz", ",", " ", "san", ",", " ", 
    RowBox[{"ky", " ", "and", " ", 
     RowBox[{"h2o", "."}]}]}], " ", "*)"}], " ", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phases", "=", 
     RowBox[{"{", 
      RowBox[{"mu", ",", "qz", ",", "san", ",", "ky", ",", "h2o"}], "}"}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"matrix", ",", " ", "elements"}], "}"}], " ", "=", " ", 
    RowBox[{"MakeCompositionMatrix", "[", "phases", "]"}]}], "\n", 
   RowBox[{"MatrixForm", "[", "matrix", "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "1", ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0", ",", "0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "2", ",", "8", ",", "5", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "3", ",", "1", ",", "0"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"AL\"\>", ",", "\<\"H\"\>", ",", "\<\"K\"\>", 
     ",", "\<\"O\"\>", ",", "\<\"SI\"\>"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.42270747096875*^9, 3.42277460753125*^9, 
  3.46096635053125*^9, 3.485494506807291*^9, 3.4857513808312435`*^9, 
  3.4857521741928596`*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"3", "0", "1", "2", "0"},
     {"2", "0", "0", "0", "2"},
     {"1", "0", "1", "0", "0"},
     {"12", "2", "8", "5", "1"},
     {"3", "1", "3", "1", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.42270747096875*^9, 3.42277460753125*^9, 
  3.46096635053125*^9, 3.485494506807291*^9, 3.4857513808312435`*^9, 
  3.485752174239735*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "21"}], ":", " ", 
    RowBox[{
     RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
     "MakeRea", "-", " ", 
     RowBox[{
     "to", " ", "calculate", " ", "a", " ", "linearly", " ", "independent", 
      " ", "set", " ", "of", " ", "reactions", " ", "for", " ", "the", " ", 
      "phase", " ", 
      RowBox[{"components", ":", " ", 
       RowBox[{"{", 
        RowBox[{
        "ann", ",", "phl", ",", "alm", ",", "py", ",", "gr", ",", "an", ",", 
         "qz", ",", "sil"}], "}"}]}]}]}]}], "  ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phases", "=", 
     RowBox[{"{", 
      RowBox[{
      "ann", ",", "phl", ",", "alm", ",", "py", ",", "gr", ",", "an", ",", 
       "qz", ",", "sil"}], "}"}]}], ";"}], "\n", 
   RowBox[{"rea", "=", 
    RowBox[{"MakeRea", "[", "phases", "]"}]}], "\n"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "sil"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "alm"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "phl"}], ",", 
     RowBox[{"1.`", " ", "ann"}], ",", 
     RowBox[{"1.`", " ", "py"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.4227074826875*^9, 3.42277462396875*^9, 
  3.460966352203125*^9, 3.485494509822858*^9, 3.4857513809093714`*^9, 
  3.4857521742553606`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "22"}], ":", " ", 
    RowBox[{
     RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
     "MakeRea", "-", " ", 
     RowBox[{
     "to", " ", "calculate", " ", "all", " ", "possible", " ", "reactions", 
      " ", "for", " ", "the", " ", "phase", " ", 
      RowBox[{"components", ":", " ", 
       RowBox[{"{", 
        RowBox[{
        "dsp", ",", "qz", ",", "ky", ",", "kao", ",", "pyp", ",", "zo", ",", 
         "ma", ",", "gr", ",", "an", ",", "h2o", ",", "law"}], "}"}]}]}]}]}], 
   "  ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phases", " ", "=", 
     RowBox[{"{", 
      RowBox[{
      "dsp", ",", "qz", ",", "ky", ",", "kao", ",", "pyp", ",", "zo", ",", 
       "ma", ",", "gr", ",", "an", ",", "h2o", ",", "law"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"r1", "=", 
    RowBox[{"MakeRea", "[", 
     RowBox[{"phases", ",", 
      RowBox[{"MakeReaMode", "\[Rule]", "1"}]}], "]"}]}], "\n"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating reactions with \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\" phases\"\>"}],
  SequenceForm["Calculating reactions with ", 5, " phases"],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270748609375*^9, 3.42277462546875*^9, 
  3.46096635378125*^9, 3.4854945115415754`*^9, 3.4857513809249973`*^9, 
  3.4857521742709856`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(degree of freedom =  \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" ): from combinatorics, there are \"\>", 
   "\[InvisibleSpace]", "462", 
   "\[InvisibleSpace]", "\<\" possible reactions.\"\>"}],
  SequenceForm[
  "(degree of freedom =  ", 1, " ): from combinatorics, there are ", 462, 
   " possible reactions."],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270748609375*^9, 3.42277462546875*^9, 
  3.46096635378125*^9, 3.4854945115415754`*^9, 3.4857513809249973`*^9, 
  3.4857521743334856`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating reactions with \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" phases\"\>"}],
  SequenceForm["Calculating reactions with ", 4, " phases"],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270748609375*^9, 3.42277462546875*^9, 
  3.46096635378125*^9, 3.4854945115415754`*^9, 3.4857513809249973`*^9, 
  3.4857521751928663`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(degree of freedom =  \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" ): from combinatorics, there are \"\>", 
   "\[InvisibleSpace]", "330", 
   "\[InvisibleSpace]", "\<\" possible reactions.\"\>"}],
  SequenceForm[
  "(degree of freedom =  ", 2, " ): from combinatorics, there are ", 330, 
   " possible reactions."],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270748609375*^9, 3.42277462546875*^9, 
  3.46096635378125*^9, 3.4854945115415754`*^9, 3.4857513809249973`*^9, 
  3.4857521751928663`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating reactions with \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" phases\"\>"}],
  SequenceForm["Calculating reactions with ", 3, " phases"],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270748609375*^9, 3.42277462546875*^9, 
  3.46096635378125*^9, 3.4854945115415754`*^9, 3.4857513809249973`*^9, 
  3.485752175677244*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(degree of freedom =  \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" ): from combinatorics, there are \"\>", 
   "\[InvisibleSpace]", "165", 
   "\[InvisibleSpace]", "\<\" possible reactions.\"\>"}],
  SequenceForm[
  "(degree of freedom =  ", 3, " ): from combinatorics, there are ", 165, 
   " possible reactions."],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270748609375*^9, 3.42277462546875*^9, 
  3.46096635378125*^9, 3.4854945115415754`*^9, 3.4857513809249973`*^9, 
  3.4857521756928697`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Calculating reactions with \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" phases\"\>"}],
  SequenceForm["Calculating reactions with ", 2, " phases"],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270748609375*^9, 3.42277462546875*^9, 
  3.46096635378125*^9, 3.4854945115415754`*^9, 3.4857513809249973`*^9, 
  3.4857521758647456`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(degree of freedom =  \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\" ): from combinatorics, there are \"\>", 
   "\[InvisibleSpace]", "55", 
   "\[InvisibleSpace]", "\<\" possible reactions.\"\>"}],
  SequenceForm[
  "(degree of freedom =  ", 4, " ): from combinatorics, there are ", 55, 
   " possible reactions."],
  Editable->False]], "Print",
 CellChangeTimes->{3.42270748609375*^9, 3.42277462546875*^9, 
  3.46096635378125*^9, 3.4854945115415754`*^9, 3.4857513809249973`*^9, 
  3.485752175880371*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{"6.`", " ", "an"}], ",", 
     RowBox[{"7.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "ky"}], ",", 
     RowBox[{"9.`", " ", "an"}], ",", 
     RowBox[{"4.`", " ", "dsp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{"3.`", " ", "h2o"}], ",", 
     RowBox[{"2.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"3.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"6.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{"6.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "kao"}], ",", 
     RowBox[{"5.`", " ", "an"}], ",", 
     RowBox[{"7.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "kao"}], ",", 
     RowBox[{"5.`", " ", "ky"}], ",", 
     RowBox[{"9.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "ma"}], ",", 
     RowBox[{"14.`", " ", "dsp"}], ",", 
     RowBox[{"3.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "ma"}], ",", 
     RowBox[{"10.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"6.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "ky"}], ",", 
     RowBox[{"7.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{"4.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"3.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"7.`", " ", "h2o"}], ",", 
     RowBox[{"7.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"6.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "an"}], ",", 
     RowBox[{"7.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "dsp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "an"}], ",", 
     RowBox[{"7.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"3.`", " ", "h2o"}], ",", 
     RowBox[{"2.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"3.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "ky"}], ",", 
     RowBox[{"7.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "14.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "14.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "h2o"}], ",", 
     RowBox[{"6.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "18.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "pyp"}], ",", 
     RowBox[{"12.`", " ", "an"}], ",", 
     RowBox[{"8.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "34.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "pyp"}], ",", 
     RowBox[{"16.`", " ", "ky"}], ",", 
     RowBox[{"12.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "15.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "pyp"}], ",", 
     RowBox[{"5.`", " ", "gr"}], ",", 
     RowBox[{"11.`", " ", "kao"}], ",", 
     RowBox[{"21.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "pyp"}], ",", 
     RowBox[{"21.`", " ", "an"}], ",", 
     RowBox[{"8.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "17.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"26.`", " ", "ky"}], ",", 
     RowBox[{"11.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"12.`", " ", "an"}], ",", 
     RowBox[{"8.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"8.`", " ", "an"}], ",", 
     RowBox[{"4.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "16.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"12.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"17.`", " ", "an"}], ",", 
     RowBox[{"8.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"5.`", " ", "an"}], ",", 
     RowBox[{"4.`", " ", "kao"}], ",", 
     RowBox[{"4.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"13.`", " ", "an"}], ",", 
     RowBox[{"4.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "26.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"17.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "26.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "law"}], ",", 
     RowBox[{"8.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "34.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"8.`", " ", "h2o"}], ",", 
     RowBox[{"12.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "pyp"}], ",", 
     RowBox[{"15.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "pyp"}], ",", 
     RowBox[{"17.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "pyp"}], ",", 
     RowBox[{"3.`", " ", "gr"}], ",", 
     RowBox[{"11.`", " ", "h2o"}], ",", 
     RowBox[{"17.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"12.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "dsp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"9.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "h2o"}], ",", 
     RowBox[{"4.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "17.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"9.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"8.`", " ", "ky"}], ",", 
     RowBox[{"5.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"3.`", " ", "an"}], ",", 
     RowBox[{"4.`", " ", "h2o"}], ",", 
     RowBox[{"4.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"11.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "kao"}], ",", 
     RowBox[{"6.`", " ", "an"}], ",", 
     RowBox[{"9.`", " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{"5.`", " ", "h2o"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "kao"}], ",", 
     RowBox[{"6.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "ma"}], ",", 
     RowBox[{"22.`", " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"8.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"4.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"2.`", " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "kao"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"5.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "kao"}], ",", 
     RowBox[{"3.`", " ", "an"}], ",", 
     RowBox[{"9.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ky"}], ",", 
     RowBox[{"10.`", " ", "dsp"}], ",", 
     RowBox[{"3.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "17.`"}], " ", "kao"}], ",", 
     RowBox[{"3.`", " ", "ky"}], ",", 
     RowBox[{"15.`", " ", "law"}], ",", 
     RowBox[{"4.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "16.`"}], " ", "kao"}], ",", 
     RowBox[{"6.`", " ", "dsp"}], ",", 
     RowBox[{"12.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "ma"}], ",", 
     RowBox[{"42.`", " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"7.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "26.`"}], " ", "kao"}], ",", 
     RowBox[{"21.`", " ", "law"}], ",", 
     RowBox[{"3.`", " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "17.`"}], " ", "kao"}], ",", 
     RowBox[{"21.`", " ", "h2o"}], ",", 
     RowBox[{"6.`", " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "21.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"7.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "11.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"3.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "qz"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "qz"}], ",", 
     RowBox[{"7.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"8.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{"5.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{"4.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{"5.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "h2o"}], ",", 
     RowBox[{"3.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "h2o"}], ",", 
     RowBox[{"5.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "an"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"3.`", " ", "an"}], ",", 
     RowBox[{"4.`", " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{"2.`", " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{"6.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"2.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "ma"}], ",", 
     RowBox[{"2.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"4.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"4.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"6.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"4.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "ma"}], ",", 
     RowBox[{"4.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "kao"}], ",", 
     RowBox[{"4.`", " ", "dsp"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "pyp"}], ",", 
     RowBox[{"3.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "h2o"}], ",", 
     RowBox[{"5.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "pyp"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"6.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{"14.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"7.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "h2o"}], ",", 
     RowBox[{"3.`", " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "pyp"}], ",", 
     RowBox[{"3.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "kao"}], ",", 
     RowBox[{"9.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "pyp"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "ma"}], ",", 
     RowBox[{"13.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"17.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "h2o"}], ",", 
     RowBox[{"3.`", " ", "ma"}], ",", 
     RowBox[{"17.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "42.`"}], " ", "zo"}], ",", 
     RowBox[{"22.`", " ", "gr"}], ",", 
     RowBox[{"18.`", " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "34.`"}], " ", "zo"}], ",", 
     RowBox[{"20.`", " ", "gr"}], ",", 
     RowBox[{"22.`", " ", "ky"}], ",", 
     RowBox[{"8.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "30.`"}], " ", "zo"}], ",", 
     RowBox[{"20.`", " ", "gr"}], ",", 
     RowBox[{"8.`", " ", "kao"}], ",", 
     RowBox[{"18.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "22.`"}], " ", "zo"}], ",", 
     RowBox[{"12.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"8.`", " ", "ma"}], ",", 
     RowBox[{"3.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "18.`"}], " ", "zo"}], ",", 
     RowBox[{"12.`", " ", "gr"}], ",", 
     RowBox[{"8.`", " ", "h2o"}], ",", 
     RowBox[{"14.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "14.`"}], " ", "zo"}], ",", 
     RowBox[{"9.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "14.`"}], " ", "zo"}], ",", 
     RowBox[{"7.`", " ", "an"}], ",", 
     RowBox[{"6.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "kao"}], ",", 
     RowBox[{"3.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "zo"}], ",", 
     RowBox[{"18.`", " ", "dsp"}], ",", 
     RowBox[{"8.`", " ", "gr"}], ",", 
     RowBox[{"5.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "zo"}], ",", 
     RowBox[{"8.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "zo"}], ",", 
     RowBox[{"7.`", " ", "gr"}], ",", 
     RowBox[{"8.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "zo"}], ",", 
     RowBox[{"6.`", " ", "gr"}], ",", 
     RowBox[{"8.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "zo"}], ",", 
     RowBox[{"20.`", " ", "an"}], ",", 
     RowBox[{"4.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "zo"}], ",", 
     RowBox[{"14.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"6.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "zo"}], ",", 
     RowBox[{"11.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "22.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"14.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "22.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "zo"}], ",", 
     RowBox[{"20.`", " ", "ma"}], ",", 
     RowBox[{"9.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "dsp"}], ",", 
     RowBox[{"6.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "kao"}], ",", 
     RowBox[{"5.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "zo"}], ",", 
     RowBox[{"5.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"5.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "an"}], ",", 
     RowBox[{"6.`", " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"4.`", " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "14.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "zo"}], ",", 
     RowBox[{"11.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "ma"}], ",", 
     RowBox[{"5.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "zo"}], ",", 
     RowBox[{"7.`", " ", "an"}], ",", 
     RowBox[{"3.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "zo"}], ",", 
     RowBox[{"5.`", " ", "an"}], ",", 
     RowBox[{"3.`", " ", "dsp"}], ",", 
     RowBox[{"3.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"5.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "zo"}], ",", 
     RowBox[{"3.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"5.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"4.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"5.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"5.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"5.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"6.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"12.`", " ", "an"}], ",", 
     RowBox[{"4.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"10.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "20.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"12.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "18.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"7.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "h2o"}], ",", 
     RowBox[{"5.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"7.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "ma"}], ",", 
     RowBox[{"10.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"5.`", " ", "an"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"3.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "h2o"}], ",", 
     RowBox[{"5.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"8.`", " ", "an"}], ",", 
     RowBox[{"4.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"11.`", " ", "an"}], ",", 
     RowBox[{"4.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "22.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "kao"}], ",", 
     RowBox[{"8.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"8.`", " ", "an"}], ",", 
     RowBox[{"4.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"6.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"8.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"9.`", " ", "an"}], ",", 
     RowBox[{"4.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"7.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "14.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"9.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "14.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "law"}], ",", 
     RowBox[{"6.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "18.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "h2o"}], ",", 
     RowBox[{"8.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"10.`", " ", "dsp"}], ",", 
     RowBox[{"8.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"8.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"7.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"5.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"5.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"5.`", " ", "ky"}], ",", 
     RowBox[{"8.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"8.`", " ", "ma"}], ",", 
     RowBox[{"9.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "zo"}], ",", 
     RowBox[{"3.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "h2o"}], ",", 
     RowBox[{"3.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "zo"}], ",", 
     RowBox[{"5.`", " ", "ky"}], ",", 
     RowBox[{"6.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"3.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "zo"}], ",", 
     RowBox[{"3.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "zo"}], ",", 
     RowBox[{"7.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"5.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "an"}], ",", 
     RowBox[{"3.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"10.`", " ", "ky"}], ",", 
     RowBox[{"9.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"3.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"3.`", " ", "h2o"}], ",", 
     RowBox[{"4.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"4.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"11.`", " ", "h2o"}], ",", 
     RowBox[{"4.`", " ", "ma"}], ",", 
     RowBox[{"4.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"7.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"3.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"5.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"5.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"3.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "h2o"}], ",", 
     RowBox[{"2.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"3.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "kao"}], ",", 
     RowBox[{"6.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"7.`", " ", "h2o"}], ",", 
     RowBox[{"4.`", " ", "ma"}], ",", 
     RowBox[{"8.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "ma"}], ",", 
     RowBox[{"12.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"3.`", " ", "ma"}], ",", 
     RowBox[{"14.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "h2o"}], ",", 
     RowBox[{"4.`", " ", "ma"}], ",", 
     RowBox[{"18.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"6.`", " ", "ky"}], ",", 
     RowBox[{"4.`", " ", "law"}], ",", 
     RowBox[{"20.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "kao"}], ",", 
     RowBox[{"4.`", " ", "ma"}], ",", 
     RowBox[{"22.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "dsp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "zo"}], ",", 
     RowBox[{"3.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "zo"}], ",", 
     RowBox[{"3.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"2.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "h2o"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"2.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "zo"}], ",", 
     RowBox[{"5.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ma"}], ",", 
     RowBox[{"9.`", " ", "h2o"}], ",", 
     RowBox[{"8.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"14.`", " ", "ky"}], ",", 
     RowBox[{"6.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"8.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "h2o"}], ",", 
     RowBox[{"6.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "qz"}], ",", 
     RowBox[{"8.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "h2o"}], ",", 
     RowBox[{"5.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"3.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "qz"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "pyp"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"11.`", " ", "qz"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{"5.`", " ", "h2o"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "kao"}], ",", 
     RowBox[{"9.`", " ", "h2o"}], ",", 
     RowBox[{"2.`", " ", "pyp"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "22.`"}], " ", "kao"}], ",", 
     RowBox[{"18.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "pyp"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "h2o"}], ",", 
     RowBox[{"4.`", " ", "qz"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "h2o"}], ",", 
     RowBox[{"14.`", " ", "qz"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "14.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "h2o"}], ",", 
     RowBox[{"12.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "law"}], ",", 
     RowBox[{"14.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "h2o"}], ",", 
     RowBox[{"14.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "22.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "law"}], ",", 
     RowBox[{"16.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "14.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "11.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "pyp"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"26.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "18.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "14.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "h2o"}], ",", 
     RowBox[{"34.`", " ", "zo"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.42270748834375*^9, 3.42277462771875*^9, 
  3.46096635559375*^9, 3.485494513400914*^9, 3.485751382721941*^9, 
  3.4857521760366216`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "23"}], ":", " ", 
    RowBox[{
     RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
     "MakeRea", "-", " ", 
     RowBox[{
     "to", " ", "calculate", " ", "all", " ", "possible", " ", "reactions", 
      " ", "for", " ", "the", " ", "phase", " ", "components", " ", 
      RowBox[{"{", 
       RowBox[{
       "dsp", ",", "qz", ",", "ky", ",", "kao", ",", "pyp", ",", "zo", ",", 
        "ma", ",", "gr", ",", "an", ",", "h2o", ",", "law"}], "}"}], " ", 
      "using", " ", "the", " ", "algorithm", " ", "of", " ", "Powell", " ", 
      RowBox[{"(", "1990", ")"}]}]}]}], "  ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phases", " ", "=", 
     RowBox[{"{", 
      RowBox[{
      "dsp", ",", "qz", ",", "ky", ",", "kao", ",", "pyp", ",", "zo", ",", 
       "ma", ",", "gr", ",", "an", ",", "h2o", ",", "law"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"r2", "=", 
    RowBox[{"MakeRea", "[", 
     RowBox[{"phases", ",", 
      RowBox[{"MakeReaMode", "\[Rule]", "2"}]}], "]"}]}], "\n"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Warning from -MakeRea-: singular matrix occurred during \
calculation. Not all reactions may have been found.\"\>"], "Print",
 CellChangeTimes->{3.422707497765625*^9, 3.422774631578125*^9, 
  3.460966357484375*^9, 3.485494516197736*^9, 3.485751382846946*^9, 
  3.485752176130372*^9}],

Cell[BoxData["\<\"Use option MakeReaMode -> 1 to find all reactions.\"\>"], \
"Print",
 CellChangeTimes->{3.422707497765625*^9, 3.422774631578125*^9, 
  3.460966357484375*^9, 3.485494516197736*^9, 3.485751382846946*^9, 
  3.485752176145997*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "34.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "pyp"}], ",", 
     RowBox[{"16.`", " ", "ky"}], ",", 
     RowBox[{"12.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "22.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "law"}], ",", 
     RowBox[{"16.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "18.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "kao"}], ",", 
     RowBox[{"12.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "14.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "kao"}], ",", 
     RowBox[{"5.`", " ", "ky"}], ",", 
     RowBox[{"9.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "h2o"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"8.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "pyp"}], ",", 
     RowBox[{"6.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "zo"}], ",", 
     RowBox[{"5.`", " ", "ky"}], ",", 
     RowBox[{"6.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "kao"}], ",", 
     RowBox[{"5.`", " ", "an"}], ",", 
     RowBox[{"7.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"6.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "dsp"}], ",", 
     RowBox[{"3.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{"6.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"8.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "law"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"8.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ky"}], ",", 
     RowBox[{"9.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{"3.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "26.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "dsp"}], ",", 
     RowBox[{
      RowBox[{"-", "28.`"}], " ", "h2o"}], ",", 
     RowBox[{"4.`", " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"8.`", " ", "law"}], ",", 
     RowBox[{"9.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "ky"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "qz"}], ",", 
     RowBox[{"5.`", " ", "kao"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"5.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "qz"}], ",", 
     RowBox[{"8.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"8.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "qz"}], ",", 
     RowBox[{"5.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"5.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "law"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "law"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{"12.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"5.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "qz"}], ",", 
     RowBox[{"3.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "20.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "22.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "law"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"34.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "20.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "18.`"}], " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "pyp"}], ",", 
     RowBox[{"30.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "11.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "17.`"}], " ", "ky"}], ",", 
     RowBox[{"9.`", " ", "ma"}], ",", 
     RowBox[{"2.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "14.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"18.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "law"}], ",", 
     RowBox[{"1.`", " ", "ma"}], ",", 
     RowBox[{"10.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"3.`", " ", "kao"}], ",", 
     RowBox[{"4.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"14.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "kao"}], ",", 
     RowBox[{"3.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "law"}], ",", 
     RowBox[{"8.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "17.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"9.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "ma"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ky"}], ",", 
     RowBox[{"5.`", " ", "ma"}], ",", 
     RowBox[{"3.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ky"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"22.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "20.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"12.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "law"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"3.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "26.`"}], " ", "kao"}], ",", 
     RowBox[{"21.`", " ", "law"}], ",", 
     RowBox[{"3.`", " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "22.`"}], " ", "kao"}], ",", 
     RowBox[{"18.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "pyp"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "14.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "zo"}], ",", 
     RowBox[{"11.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "ma"}], ",", 
     RowBox[{"5.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "kao"}], ",", 
     RowBox[{"3.`", " ", "an"}], ",", 
     RowBox[{"9.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "law"}], ",", 
     RowBox[{"14.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "21.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "kao"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"9.`", " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "an"}], ",", 
     RowBox[{"7.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "h2o"}], ",", 
     RowBox[{"14.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "kao"}], ",", 
     RowBox[{"6.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "11.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "kao"}], ",", 
     RowBox[{"3.`", " ", "ma"}], ",", 
     RowBox[{"3.`", " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{"14.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "pyp"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "18.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "14.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "h2o"}], ",", 
     RowBox[{"34.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "14.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "11.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "pyp"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"26.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "26.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"17.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "22.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"14.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "14.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"9.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"8.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"5.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "law"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "law"}], ",", 
     RowBox[{"1.`", " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "14.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "pyp"}], ",", 
     RowBox[{"10.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "11.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "law"}], ",", 
     RowBox[{"1.`", " ", "pyp"}], ",", 
     RowBox[{"10.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "17.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "h2o"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"5.`", " ", "ma"}], ",", 
     RowBox[{"3.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "13.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "law"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"5.`", " ", "ma"}], ",", 
     RowBox[{"3.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "11.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "pyp"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"21.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "law"}], ",", 
     RowBox[{"2.`", " ", "kao"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "h2o"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "ma"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"5.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"7.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "11.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "pyp"}], ",", 
     RowBox[{"9.`", " ", "kao"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "21.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"17.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"4.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "h2o"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "pyp"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "law"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "pyp"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "17.`"}], " ", "kao"}], ",", 
     RowBox[{"3.`", " ", "ky"}], ",", 
     RowBox[{"15.`", " ", "law"}], ",", 
     RowBox[{"4.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "kao"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"5.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{"3.`", " ", "gr"}], ",", 
     RowBox[{"5.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "20.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "kao"}], ",", 
     RowBox[{"6.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "pyp"}], ",", 
     RowBox[{"10.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"6.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"6.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "ky"}], ",", 
     RowBox[{"7.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{"3.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"8.`", " ", "ky"}], ",", 
     RowBox[{"5.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "11.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"8.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "15.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{"5.`", " ", "gr"}], ",", 
     RowBox[{"9.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"10.`", " ", "ky"}], ",", 
     RowBox[{"9.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "17.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "law"}], ",", 
     RowBox[{"6.`", " ", "gr"}], ",", 
     RowBox[{"10.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "10.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"14.`", " ", "ky"}], ",", 
     RowBox[{"6.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "15.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "pyp"}], ",", 
     RowBox[{"5.`", " ", "gr"}], ",", 
     RowBox[{"11.`", " ", "kao"}], ",", 
     RowBox[{"21.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "20.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "pyp"}], ",", 
     RowBox[{"12.`", " ", "kao"}], ",", 
     RowBox[{"22.`", " ", "ky"}], ",", 
     RowBox[{"10.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "17.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"26.`", " ", "ky"}], ",", 
     RowBox[{"11.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "qz"}], ",", 
     RowBox[{"12.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "qz"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "law"}], ",", 
     RowBox[{"1.`", " ", "qz"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "ma"}], ",", 
     RowBox[{"2.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "ma"}], ",", 
     RowBox[{"2.`", " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "law"}], ",", 
     RowBox[{"1.`", " ", "ma"}], ",", 
     RowBox[{"2.`", " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"2.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "law"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "qz"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"4.`", " ", "ma"}], ",", 
     RowBox[{"3.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "ma"}], ",", 
     RowBox[{"3.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"3.`", " ", "qz"}], ",", 
     RowBox[{"8.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"3.`", " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "ma"}], ",", 
     RowBox[{"3.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "law"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "ma"}], ",", 
     RowBox[{"3.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{"3.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "qz"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "h2o"}], ",", 
     RowBox[{"4.`", " ", "qz"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "ma"}], ",", 
     RowBox[{"4.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"1.`", " ", "ma"}], ",", 
     RowBox[{"4.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"4.`", " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "qz"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "pyp"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "an"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "law"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"3.`", " ", "kao"}], ",", 
     RowBox[{"5.`", " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "pyp"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"5.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "zo"}], ",", 
     RowBox[{"5.`", " ", "ky"}], ",", 
     RowBox[{"8.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "ma"}], ",", 
     RowBox[{"6.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"3.`", " ", "ma"}], ",", 
     RowBox[{"6.`", " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"6.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "ky"}], ",", 
     RowBox[{"6.`", " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"4.`", " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"8.`", " ", "qz"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "law"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "kao"}], ",", 
     RowBox[{"1.`", " ", "ma"}], ",", 
     RowBox[{"8.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "pyp"}], ",", 
     RowBox[{"3.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "kao"}], ",", 
     RowBox[{"9.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "zo"}], ",", 
     RowBox[{"7.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "ma"}], ",", 
     RowBox[{"10.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "pyp"}], ",", 
     RowBox[{"3.`", " ", "ma"}], ",", 
     RowBox[{"11.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "pyp"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"11.`", " ", "qz"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "pyp"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"2.`", " ", "ma"}], ",", 
     RowBox[{"13.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "h2o"}], ",", 
     RowBox[{"14.`", " ", "qz"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"3.`", " ", "ma"}], ",", 
     RowBox[{"14.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "h2o"}], ",", 
     RowBox[{"3.`", " ", "ma"}], ",", 
     RowBox[{"17.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"17.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "h2o"}], ",", 
     RowBox[{"4.`", " ", "ma"}], ",", 
     RowBox[{"18.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "kao"}], ",", 
     RowBox[{"18.`", " ", "qz"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"6.`", " ", "ky"}], ",", 
     RowBox[{"4.`", " ", "law"}], ",", 
     RowBox[{"20.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "kao"}], ",", 
     RowBox[{"3.`", " ", "ma"}], ",", 
     RowBox[{"21.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "pyp"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"2.`", " ", "kao"}], ",", 
     RowBox[{"4.`", " ", "ma"}], ",", 
     RowBox[{"22.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "law"}], ",", 
     RowBox[{"1.`", " ", "dsp"}], ",", 
     RowBox[{"7.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "dsp"}], ",", 
     RowBox[{"3.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "zo"}], ",", 
     RowBox[{"1.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{"1.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ma"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"8.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "dsp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "law"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "h2o"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "ky"}], ",", 
     RowBox[{"3.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "law"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"3.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "pyp"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{"3.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{"3.`", " ", "dsp"}], ",", 
     RowBox[{"3.`", " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"4.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ky"}], ",", 
     RowBox[{"4.`", " ", "dsp"}], ",", 
     RowBox[{"3.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{"4.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "law"}], ",", 
     RowBox[{"4.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"4.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"4.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "kao"}], ",", 
     RowBox[{"4.`", " ", "dsp"}], ",", 
     RowBox[{"3.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "zo"}], ",", 
     RowBox[{"5.`", " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "law"}], ",", 
     RowBox[{"3.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{"5.`", " ", "dsp"}], ",", 
     RowBox[{"3.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{"5.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "zo"}], ",", 
     RowBox[{"5.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ky"}], ",", 
     RowBox[{"6.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "16.`"}], " ", "kao"}], ",", 
     RowBox[{"6.`", " ", "dsp"}], ",", 
     RowBox[{"12.`", " ", "law"}], ",", 
     RowBox[{"5.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{"6.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"6.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "law"}], ",", 
     RowBox[{"4.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "dsp"}], ",", 
     RowBox[{"7.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{"7.`", " ", "dsp"}], ",", 
     RowBox[{"3.`", " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "law"}], ",", 
     RowBox[{"7.`", " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "gr"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "law"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ma"}], ",", 
     RowBox[{"8.`", " ", "dsp"}], ",", 
     RowBox[{"6.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ma"}], ",", 
     RowBox[{"8.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "law"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{"8.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "qz"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "law"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{"8.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{"8.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"7.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ky"}], ",", 
     RowBox[{"10.`", " ", "dsp"}], ",", 
     RowBox[{"3.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "h2o"}], ",", 
     RowBox[{"10.`", " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "law"}], ",", 
     RowBox[{"10.`", " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "law"}], ",", 
     RowBox[{
      RowBox[{"-", "5.`"}], " ", "ma"}], ",", 
     RowBox[{"10.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "kao"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "ma"}], ",", 
     RowBox[{"10.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"6.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{"10.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ky"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "law"}], ",", 
     RowBox[{"12.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"7.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "law"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "ma"}], ",", 
     RowBox[{"14.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "ma"}], ",", 
     RowBox[{"14.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "ma"}], ",", 
     RowBox[{"14.`", " ", "dsp"}], ",", 
     RowBox[{"3.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{"14.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"7.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "an"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "kao"}], ",", 
     RowBox[{"18.`", " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"7.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "ma"}], ",", 
     RowBox[{"18.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "ma"}], ",", 
     RowBox[{"21.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"4.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "kao"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "ma"}], ",", 
     RowBox[{"22.`", " ", "dsp"}], ",", 
     RowBox[{"3.`", " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "ma"}], ",", 
     RowBox[{"22.`", " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"8.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "law"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "ma"}], ",", 
     RowBox[{"26.`", " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "pyp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "ma"}], ",", 
     RowBox[{"34.`", " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "pyp"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.422707497890625*^9, 3.42277463171875*^9, 
  3.46096635759375*^9, 3.485494516307109*^9, 3.4857513829563255`*^9, 
  3.485752176255373*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "24"}], ":", " ", 
    RowBox[{
     RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
     "SelectRea", "-", " ", 
     RowBox[{
     "to", " ", "select", " ", "from", " ", "the", " ", "reactions", " ", 
      "calculated", " ", "in", " ", "example", " ", "15", " ", "all", " ", 
      "those", " ", "with", " ", "margarite", " ", "and", " ", "margarite"}], 
     " ", "+", " ", "H2O"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"rea1", "=", 
    RowBox[{"SelectRea", "[", 
     RowBox[{"r2", ",", 
      RowBox[{"{", "ma", "}"}], ",", 
      RowBox[{"SelectReaMode", "\[Rule]", "1"}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"rea2", "=", 
    RowBox[{"SelectRea", "[", 
     RowBox[{"r2", ",", 
      RowBox[{"{", 
       RowBox[{"ma", ",", "h2o"}], "}"}], ",", 
      RowBox[{"SelectReaMode", "\[Rule]", "1"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"1.`", " ", "an"}], ",", 
     RowBox[{"2.`", " ", "dsp"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{"3.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{"6.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"2.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "ma"}], ",", 
     RowBox[{"10.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"6.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "9.`"}], " ", "ma"}], ",", 
     RowBox[{"14.`", " ", "dsp"}], ",", 
     RowBox[{"3.`", " ", "gr"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"7.`", " ", "ky"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "ma"}], ",", 
     RowBox[{"22.`", " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"8.`", " ", "ky"}], ",", 
     RowBox[{"1.`", " ", "pyp"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.42270750446875*^9, 3.422774633359375*^9, 
  3.460966359265625*^9, 3.4854945180102005`*^9, 3.485751383003202*^9, 
  3.4857521763022485`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "ma"}], ",", 
     RowBox[{"2.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "law"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "ma"}], ",", 
     RowBox[{"5.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "qz"}], ",", 
     RowBox[{"1.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "ma"}], ",", 
     RowBox[{"8.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "kao"}], ",", 
     RowBox[{"2.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "3.`"}], " ", "ma"}], ",", 
     RowBox[{"10.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "qz"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "7.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "6.`"}], " ", "ma"}], ",", 
     RowBox[{"14.`", " ", "dsp"}], ",", 
     RowBox[{"2.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "kao"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "ma"}], ",", 
     RowBox[{"18.`", " ", "dsp"}], ",", 
     RowBox[{"1.`", " ", "pyp"}], ",", 
     RowBox[{"4.`", " ", "zo"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8.`"}], " ", "h2o"}], ",", 
     RowBox[{
      RowBox[{"-", "12.`"}], " ", "ma"}], ",", 
     RowBox[{"34.`", " ", "dsp"}], ",", 
     RowBox[{"4.`", " ", "gr"}], ",", 
     RowBox[{"3.`", " ", "pyp"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.42270750446875*^9, 3.422774633359375*^9, 
  3.460966359265625*^9, 3.4854945180102005`*^9, 3.485751383003202*^9, 
  3.485752176349124*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Example", " ", "25"}], ":", " ", 
      RowBox[{
       RowBox[{"Use", " ", "the", " ", "PET", " ", "function"}], " ", "-", 
       "CalcRea", "-", " ", 
       RowBox[{"to", " ", "calculate", " ", "the", " ", "grt"}], "-", 
       RowBox[{
       "bt", " ", "and", " ", "GASP", " ", "equilibrium", " ", "for", " ", 
        "sample", " ", "\"\<hs78b\>\"", " ", "comparing", " ", 
        "results"}]}]}], " ", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"for", " ", "the", " ", "Berman", " ", "and", " ", "Holland"}], 
      " ", "&"}], " ", "Powell", " ", "data", " ", "sets"}], ";", 
    "\[IndentingNewLine]", " ", 
    RowBox[{"Use", " ", "-", "PlotRea", "-", " ", 
     RowBox[{"to", " ", "plot", " ", "the", " ", "reactions", " ", "and"}], 
     " ", "-", "CalcReaIntersection", "-", " ", 
     RowBox[{"to", " ", "calculate", " ", "their", " ", "intersection"}]}], 
    ";"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "->", " ", "B88"}], "]"}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CalcFormula", "[", "\"\<hs78b\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"phases", "=", 
     RowBox[{"{", 
      RowBox[{
      "ann", ",", "phl", ",", "alm", ",", "py", ",", "gr", ",", "an", ",", 
       "ky", ",", "qz"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"rea", "=", 
     RowBox[{"MakeRea", "[", "phases", "]"}]}], ";"}], "\n", 
   RowBox[{"result", "=", 
    RowBox[{"CalcRea", "[", 
     RowBox[{"rea", ",", 
      RowBox[{"CalcReaMin", "\[Rule]", "1000"}], ",", 
      RowBox[{"CalcReaMax", "\[Rule]", "10000"}], ",", 
      RowBox[{"Steps", "\[Rule]", "10"}], ",", 
      RowBox[{"CalcReaMode", "\[Rule]", "PT"}], ",", 
      RowBox[{"SampleFile", "\[Rule]", "\"\<hs78b\>\""}], ",", 
      RowBox[{"Screen", "\[Rule]", "ScreenNo"}]}], "]"}]}], "\n", 
   RowBox[{"PlotRea", "[", "result", "]"}], "\n", 
   RowBox[{"CalcReaIntersection", "[", "result", "]"}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula- (PET -> TWEEQ interface): creating \
file \\\"\"\>", "\[InvisibleSpace]", "\<\"hs78b.oxi\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula- (PET -> TWEEQ interface): creating file \"", 
   "hs78b.oxi\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707521375*^9, 3.422774634953125*^9, 3.46096636125*^9, 
  3.485494519619545*^9, 3.4857513830813303`*^9, 3.485752176380374*^9}],

Cell[BoxData["\<\"Use Cmp.exe to create a *.cmp file for further calculations \
with PET or TWEEQ.\"\>"], "Print",
 CellChangeTimes->{3.422707521375*^9, 3.422774634953125*^9, 3.46096636125*^9, 
  3.485494519619545*^9, 3.4857513830813303`*^9, 3.485752176380374*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"hs78b.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "hs78b.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707521375*^9, 3.422774634953125*^9, 3.46096636125*^9, 
  3.485494519619545*^9, 3.4857513830813303`*^9, 3.485752176395999*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422707521375*^9, 3.422774634953125*^9, 3.46096636125*^9, 
  3.485494519619545*^9, 3.4857513830813303`*^9, 3.485752176411624*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "an"}], ",", 
   RowBox[{"1.`", " ", "gr"}], ",", 
   RowBox[{"2.`", " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "qz"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707521375*^9, 3.422774634953125*^9, 3.46096636125*^9, 
  3.485494519619545*^9, 3.4857513830813303`*^9, 3.485752176411624*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422707521375*^9, 3.422774634953125*^9, 3.46096636125*^9, 
  3.485494519619545*^9, 3.4857513830813303`*^9, 3.4857521765835*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "alm"}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "phl"}], ",", 
   RowBox[{"1.`", " ", "ann"}], ",", 
   RowBox[{"1.`", " ", "py"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707521375*^9, 3.422774634953125*^9, 3.46096636125*^9, 
  3.485494519619545*^9, 3.4857513830813303`*^9, 3.485752176599125*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3.`"}], " ", "an"}], ",", 
         RowBox[{"1.`", " ", "gr"}], ",", 
         RowBox[{"2.`", " ", "ky"}], ",", 
         RowBox[{"1.`", " ", "qz"}]}], "}"}], 
       ",", "\<\"{a(alm)=GrtBerman, a(phl)=BtMcMullin, a(ann)=BtMcMullin, \
a(py)=GrtBerman}\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"328.543`", ",", "1000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"379.693`", ",", "2000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"430.72`", ",", "3000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"481.588`", ",", "4000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"532.26`", ",", "5000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"582.7`", ",", "6000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"632.876`", ",", "7000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"682.758`", ",", "8000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"732.322`", ",", "9000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"781.547`", ",", "10000.`"}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1.`"}], " ", "alm"}], ",", 
         RowBox[{
          RowBox[{"-", "1.`"}], " ", "phl"}], ",", 
         RowBox[{"1.`", " ", "ann"}], ",", 
         RowBox[{"1.`", " ", "py"}]}], "}"}], 
       ",", "\<\"{a(alm)=GrtBerman, a(phl)=BtMcMullin, a(ann)=BtMcMullin, \
a(py)=GrtBerman}\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"464.944`", ",", "1000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"469.823`", ",", "2000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"474.684`", ",", "3000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"479.528`", ",", "4000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"484.353`", ",", "5000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"489.16`", ",", "6000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"493.95`", ",", "7000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"498.721`", ",", "8000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"503.475`", ",", "9000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"508.21`", ",", "10000.`"}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dataset -> B88\"\>", ",", "\<\"SampleFile->hs78b\"\>"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.422707521984375*^9, 3.422774635546875*^9, 
  3.46096636171875*^9, 3.485494520088286*^9, 3.4857513835344725`*^9, 
  3.485752176833502*^9}],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{328.543, 1000.}, {379.693, 2000.}, {430.72, 3000.}, {481.588, 
       4000.}, {532.26, 5000.}, {582.7, 6000.}, {632.876, 7000.}, {682.758, 
       8000.}, {732.322, 9000.}, {781.547, 10000.}}]}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{328.543, 1000.}, {379.693, 2000.}, {430.72, 3000.}, {481.588, 
       4000.}, {532.26, 5000.}, {582.7, 6000.}, {632.876, 7000.}, {682.758, 
       8000.}, {732.322, 9000.}, {781.547, 10000.}}]}}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{464.944, 1000.}, {469.823, 2000.}, {474.684, 3000.}, {479.528, 
      4000.}, {484.353, 5000.}, {489.16, 6000.}, {493.95, 7000.}, {498.721, 
      8000.}, {503.475, 9000.}, {508.21, 10000.}}]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{400., 0},
  DisplayFunction->Identity,
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.422707521984375*^9, 3.422774635546875*^9, 
  3.46096636171875*^9, 3.485494520088286*^9, 3.4857513835344725`*^9, 
  3.485752176833502*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"3955.1639647760044`", ",", "479.31120646173065`", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.422707521984375*^9, 3.422774635546875*^9, 
  3.46096636171875*^9, 3.485494520088286*^9, 3.4857513835344725`*^9, 
  3.485752176849127*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Dataset", "[", 
    RowBox[{"Dataset", "\[Rule]", "HP32"}], "]"}], ";"}], 
  "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CalcFormula", "[", "\"\<hs78b\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"phases", "=", 
   RowBox[{"{", 
    RowBox[{
    "ann", ",", "phl", ",", "alm", ",", "py", ",", "gr", ",", "an", ",", "ky",
      ",", "qz"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"rea", "=", 
   RowBox[{"MakeRea", "[", "phases", "]"}]}], ";"}], "\n", 
 RowBox[{"result", "=", 
  RowBox[{"CalcRea", "[", 
   RowBox[{"rea", ",", 
    RowBox[{"CalcReaMin", "\[Rule]", "1000"}], ",", 
    RowBox[{"CalcReaMax", "\[Rule]", "10000"}], ",", 
    RowBox[{"Steps", "\[Rule]", "10"}], ",", 
    RowBox[{"CalcReaMode", "\[Rule]", "PT"}], ",", 
    RowBox[{"SampleFile", "\[Rule]", "\"\<hs78b\>\""}], ",", 
    RowBox[{"Screen", "\[Rule]", "ScreenNo"}]}], "]"}]}], "\n", 
 RowBox[{"PlotRea", "[", "result", "]"}], "\n", 
 RowBox[{"CalcReaIntersection", "[", "result", "]"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"hs78b.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "hs78b.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422707528671875*^9, 3.422774637125*^9, 
  3.460966363515625*^9, 3.485494521885126*^9, 3.4857513835813494`*^9, 
  3.485752176864752*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422707528671875*^9, 3.422774637125*^9, 
  3.460966363515625*^9, 3.485494521885126*^9, 3.4857513835813494`*^9, 
  3.4857521768803773`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "an"}], ",", 
   RowBox[{"1.`", " ", "gr"}], ",", 
   RowBox[{"2.`", " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "qz"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707528671875*^9, 3.422774637125*^9, 
  3.460966363515625*^9, 3.485494521885126*^9, 3.4857513835813494`*^9, 
  3.4857521768803773`*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422707528671875*^9, 3.422774637125*^9, 
  3.460966363515625*^9, 3.485494521885126*^9, 3.4857513835813494`*^9, 
  3.4857521771303787`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "alm"}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "phl"}], ",", 
   RowBox[{"1.`", " ", "ann"}], ",", 
   RowBox[{"1.`", " ", "py"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422707528671875*^9, 3.422774637125*^9, 
  3.460966363515625*^9, 3.485494521885126*^9, 3.4857513835813494`*^9, 
  3.4857521771303787`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3.`"}], " ", "an"}], ",", 
         RowBox[{"1.`", " ", "gr"}], ",", 
         RowBox[{"2.`", " ", "ky"}], ",", 
         RowBox[{"1.`", " ", "qz"}]}], "}"}], 
       ",", "\<\"{a(alm)=GrtHP, a(phl)=BtHP, a(ann)=BtHP, a(py)=GrtHP}\"\>", 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"293.783`", ",", "1000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"351.542`", ",", "2000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"409.231`", ",", "3000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"466.896`", ",", "4000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"524.552`", ",", "5000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"582.196`", ",", "6000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"639.815`", ",", "7000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"697.386`", ",", "8000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"754.89`", ",", "9000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"812.329`", ",", "10000.`"}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1.`"}], " ", "alm"}], ",", 
         RowBox[{
          RowBox[{"-", "1.`"}], " ", "phl"}], ",", 
         RowBox[{"1.`", " ", "ann"}], ",", 
         RowBox[{"1.`", " ", "py"}]}], "}"}], 
       ",", "\<\"{a(alm)=GrtHP, a(phl)=BtHP, a(ann)=BtHP, a(py)=GrtHP}\"\>", 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"469.555`", ",", "1000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"473.459`", ",", "2000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"477.361`", ",", "3000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"481.261`", ",", "4000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"485.159`", ",", "5000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"489.056`", ",", "6000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"492.951`", ",", "7000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"496.844`", ",", "8000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"500.737`", ",", "9000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"504.628`", ",", "10000.`"}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dataset -> HP32\"\>", ",", "\<\"SampleFile->hs78b\"\>"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.422707531359375*^9, 3.422774639765625*^9, 
  3.4609663655*^9, 3.485494523853839*^9, 3.4857513855189238`*^9, 
  3.485752178802264*^9}],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{293.783, 1000.}, {351.542, 2000.}, {409.231, 3000.}, {466.896,
        4000.}, {524.552, 5000.}, {582.196, 6000.}, {639.815, 7000.}, {
       697.386, 8000.}, {754.89, 9000.}, {812.329, 10000.}}]}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{293.783, 1000.}, {351.542, 2000.}, {409.231, 3000.}, {466.896,
        4000.}, {524.552, 5000.}, {582.196, 6000.}, {639.815, 7000.}, {
       697.386, 8000.}, {754.89, 9000.}, {812.329, 10000.}}]}}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{469.555, 1000.}, {473.459, 2000.}, {477.361, 3000.}, {481.261, 
      4000.}, {485.159, 5000.}, {489.056, 6000.}, {492.951, 7000.}, {496.844, 
      8000.}, {500.737, 9000.}, {504.628, 10000.}}]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{300., 0},
  DisplayFunction->Identity,
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.422707531359375*^9, 3.422774639765625*^9, 
  3.4609663655*^9, 3.485494523853839*^9, 3.4857513855189238`*^9, 
  3.4857521788178897`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"4267.200213957752`", ",", "482.3027008133909`", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.422707531359375*^9, 3.422774639765625*^9, 
  3.4609663655*^9, 3.485494523853839*^9, 3.4857513855189238`*^9, 
  3.4857521788178897`*^9}]
}, Open  ]]
},
WindowSize->{990, 595},
WindowMargins->{{5, Automatic}, {Automatic, 2}},
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 3335, 85, 352, "Input"],
Cell[CellGroupData[{
Cell[3905, 109, 333, 9, 72, "Input"],
Cell[4241, 120, 4133, 55, 1019, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8411, 180, 4912, 149, 212, "Input"],
Cell[CellGroupData[{
Cell[13348, 333, 270, 3, 23, "Print"],
Cell[13621, 338, 479, 12, 23, "Print"],
Cell[14103, 352, 413, 9, 23, "Print"],
Cell[14519, 363, 414, 9, 23, "Print"],
Cell[14936, 374, 416, 9, 23, "Print"],
Cell[15355, 385, 496, 9, 23, "Print"]
}, Open  ]],
Cell[15866, 397, 1095, 30, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16998, 432, 2041, 55, 152, "Input"],
Cell[CellGroupData[{
Cell[19064, 491, 273, 3, 23, "Print"],
Cell[19340, 496, 631, 17, 23, "Print"],
Cell[19974, 515, 419, 9, 23, "Print"],
Cell[20396, 526, 422, 9, 23, "Print"],
Cell[20821, 537, 422, 9, 23, "Print"]
}, Open  ]],
Cell[21258, 549, 1322, 35, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22617, 589, 1706, 41, 152, "Input"],
Cell[24326, 632, 541, 14, 30, "Output"],
Cell[CellGroupData[{
Cell[24892, 650, 284, 3, 23, "Print"],
Cell[25179, 655, 493, 12, 23, "Print"],
Cell[25675, 669, 427, 9, 23, "Print"],
Cell[26105, 680, 428, 9, 23, "Print"],
Cell[26536, 691, 428, 9, 23, "Print"],
Cell[26967, 702, 512, 9, 23, "Print"]
}, Open  ]],
Cell[27494, 714, 1146, 32, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28677, 751, 2372, 61, 212, "Input"],
Cell[CellGroupData[{
Cell[31074, 816, 268, 3, 23, "Print"],
Cell[31345, 821, 477, 12, 23, "Print"],
Cell[31825, 835, 411, 9, 23, "Print"],
Cell[32239, 846, 412, 9, 23, "Print"],
Cell[32654, 857, 411, 9, 23, "Print"]
}, Open  ]],
Cell[33080, 869, 1107, 30, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34224, 904, 1793, 46, 152, "Input"],
Cell[CellGroupData[{
Cell[36042, 954, 448, 8, 23, "Print"],
Cell[36493, 964, 613, 12, 23, "Print"]
}, Open  ]],
Cell[37121, 979, 673, 20, 30, "Output"],
Cell[CellGroupData[{
Cell[37819, 1003, 273, 3, 23, "Print"],
Cell[38095, 1008, 350, 8, 23, "Print"],
Cell[38448, 1018, 271, 3, 23, "Print"],
Cell[38722, 1023, 349, 8, 23, "Print"],
Cell[39074, 1033, 273, 3, 23, "Print"],
Cell[39350, 1038, 350, 8, 23, "Print"]
}, Open  ]],
Cell[39715, 1049, 3779, 101, 145, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43531, 1155, 2984, 78, 232, "Input"],
Cell[46518, 1235, 728, 17, 30, "Output"],
Cell[CellGroupData[{
Cell[47271, 1256, 274, 3, 23, "Print"],
Cell[47548, 1261, 351, 8, 23, "Print"],
Cell[47902, 1271, 274, 3, 23, "Print"],
Cell[48179, 1276, 352, 8, 23, "Print"],
Cell[48534, 1286, 272, 3, 23, "Print"],
Cell[48809, 1291, 348, 8, 23, "Print"]
}, Open  ]],
Cell[49172, 1302, 2522, 53, 247, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51731, 1360, 3378, 87, 292, "Input"],
Cell[CellGroupData[{
Cell[55134, 1451, 418, 8, 23, "Print"],
Cell[55555, 1461, 583, 12, 23, "Print"],
Cell[56141, 1475, 243, 3, 23, "Print"],
Cell[56387, 1480, 320, 8, 23, "Print"],
Cell[56710, 1490, 243, 3, 23, "Print"],
Cell[56956, 1495, 321, 8, 23, "Print"],
Cell[57280, 1505, 243, 3, 23, "Print"],
Cell[57526, 1510, 320, 8, 23, "Print"],
Cell[57849, 1520, 243, 3, 23, "Print"],
Cell[58095, 1525, 320, 8, 23, "Print"],
Cell[58418, 1535, 243, 3, 23, "Print"],
Cell[58664, 1540, 321, 8, 23, "Print"],
Cell[58988, 1550, 243, 3, 23, "Print"],
Cell[59234, 1555, 319, 8, 23, "Print"],
Cell[59556, 1565, 245, 3, 23, "Print"],
Cell[59804, 1570, 320, 8, 23, "Print"],
Cell[60127, 1580, 243, 3, 23, "Print"],
Cell[60373, 1585, 321, 8, 23, "Print"],
Cell[60697, 1595, 243, 3, 23, "Print"],
Cell[60943, 1600, 320, 8, 23, "Print"]
}, Open  ]],
Cell[61278, 1611, 3224, 60, 250, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64539, 1676, 3688, 81, 732, "Input"],
Cell[CellGroupData[{
Cell[68252, 1761, 479, 10, 23, "Print"],
Cell[68734, 1773, 274, 4, 23, "Print"],
Cell[69011, 1779, 466, 10, 23, "Print"],
Cell[69480, 1791, 230, 3, 23, "Print"],
Cell[69713, 1796, 380, 10, 23, "Print"],
Cell[70096, 1808, 371, 9, 23, "Print"],
Cell[70470, 1819, 381, 9, 23, "Print"],
Cell[70854, 1830, 378, 9, 23, "Print"],
Cell[71235, 1841, 381, 9, 23, "Print"],
Cell[71619, 1852, 378, 9, 23, "Print"],
Cell[72000, 1863, 378, 9, 23, "Print"],
Cell[72381, 1874, 376, 9, 23, "Print"],
Cell[72760, 1885, 378, 9, 23, "Print"],
Cell[73141, 1896, 376, 9, 23, "Print"],
Cell[73520, 1907, 377, 9, 23, "Print"],
Cell[73900, 1918, 230, 3, 23, "Print"],
Cell[74133, 1923, 403, 11, 23, "Print"],
Cell[74539, 1936, 375, 9, 23, "Print"],
Cell[74917, 1947, 378, 9, 23, "Print"],
Cell[75298, 1958, 381, 9, 23, "Print"],
Cell[75682, 1969, 381, 9, 23, "Print"],
Cell[76066, 1980, 378, 9, 23, "Print"],
Cell[76447, 1991, 378, 9, 23, "Print"],
Cell[76828, 2002, 378, 9, 23, "Print"],
Cell[77209, 2013, 378, 9, 23, "Print"],
Cell[77590, 2024, 378, 9, 23, "Print"],
Cell[77971, 2035, 381, 9, 23, "Print"]
}, Open  ]],
Cell[78367, 2047, 2919, 78, 126, "Output"],
Cell[81289, 2127, 1182, 25, 250, "Output"],
Cell[82474, 2154, 353, 8, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82864, 2167, 1376, 38, 132, "Input"],
Cell[84243, 2207, 661, 18, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[84941, 2230, 1887, 49, 132, "Input"],
Cell[86831, 2281, 2176, 41, 219, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89044, 2327, 1899, 47, 132, "Input"],
Cell[CellGroupData[{
Cell[90968, 2378, 252, 3, 23, "Print"],
Cell[91223, 2383, 403, 10, 23, "Print"],
Cell[91629, 2395, 396, 9, 23, "Print"],
Cell[92028, 2406, 399, 9, 23, "Print"],
Cell[92430, 2417, 402, 9, 23, "Print"],
Cell[92835, 2428, 402, 9, 23, "Print"],
Cell[93240, 2439, 402, 9, 23, "Print"],
Cell[93645, 2450, 400, 9, 23, "Print"],
Cell[94048, 2461, 400, 9, 23, "Print"],
Cell[94451, 2472, 402, 9, 23, "Print"],
Cell[94856, 2483, 402, 9, 23, "Print"],
Cell[95261, 2494, 402, 9, 23, "Print"],
Cell[95666, 2505, 402, 9, 23, "Print"],
Cell[96071, 2516, 402, 9, 23, "Print"],
Cell[96476, 2527, 400, 9, 23, "Print"],
Cell[96879, 2538, 402, 9, 23, "Print"],
Cell[97284, 2549, 402, 9, 23, "Print"],
Cell[97689, 2560, 402, 9, 23, "Print"],
Cell[98094, 2571, 402, 9, 23, "Print"],
Cell[98499, 2582, 402, 9, 23, "Print"],
Cell[98904, 2593, 400, 9, 23, "Print"],
Cell[99307, 2604, 400, 9, 23, "Print"],
Cell[99710, 2615, 397, 9, 23, "Print"]
}, Open  ]],
Cell[100122, 2627, 2472, 64, 107, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102631, 2696, 4639, 106, 472, "Input"],
Cell[107273, 2804, 467, 10, 23, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[107777, 2819, 5311, 141, 532, "Input"],
Cell[113091, 2962, 548, 16, 30, "Output"],
Cell[113642, 2980, 565, 16, 30, "Output"],
Cell[114210, 2998, 485, 14, 30, "Output"],
Cell[114698, 3014, 524, 15, 30, "Output"],
Cell[115225, 3031, 431, 12, 30, "Output"],
Cell[115659, 3045, 430, 12, 30, "Output"],
Cell[116092, 3059, 432, 12, 30, "Output"],
Cell[CellGroupData[{
Cell[116549, 3075, 229, 3, 23, "Print"],
Cell[116781, 3080, 515, 15, 23, "Print"],
Cell[117299, 3097, 229, 3, 23, "Print"],
Cell[117531, 3102, 532, 15, 23, "Print"],
Cell[118066, 3119, 227, 3, 23, "Print"],
Cell[118296, 3124, 454, 13, 23, "Print"],
Cell[118753, 3139, 229, 3, 23, "Print"],
Cell[118985, 3144, 494, 14, 23, "Print"],
Cell[119482, 3160, 227, 3, 23, "Print"],
Cell[119712, 3165, 400, 11, 23, "Print"],
Cell[120115, 3178, 229, 3, 23, "Print"],
Cell[120347, 3183, 401, 11, 23, "Print"],
Cell[120751, 3196, 229, 3, 23, "Print"],
Cell[120983, 3201, 401, 11, 23, "Print"]
}, Open  ]],
Cell[121399, 3215, 2274, 46, 357, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[123710, 3266, 2770, 65, 272, "Input"],
Cell[126483, 3333, 2427, 76, 69, "Output"],
Cell[CellGroupData[{
Cell[128935, 3413, 231, 3, 23, "Print"],
Cell[129169, 3418, 592, 17, 23, "Print"],
Cell[129764, 3437, 233, 3, 23, "Print"],
Cell[130000, 3442, 593, 17, 23, "Print"],
Cell[130596, 3461, 231, 3, 23, "Print"],
Cell[130830, 3466, 405, 11, 23, "Print"],
Cell[131238, 3479, 233, 3, 23, "Print"],
Cell[131474, 3484, 538, 15, 23, "Print"],
Cell[132015, 3501, 231, 3, 23, "Print"],
Cell[132249, 3506, 558, 16, 23, "Print"],
Cell[132810, 3524, 233, 3, 23, "Print"],
Cell[133046, 3529, 460, 13, 23, "Print"]
}, Open  ]],
Cell[133521, 3545, 2038, 41, 247, "Output"],
Cell[135562, 3588, 2035, 42, 357, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[137634, 3635, 1266, 30, 152, "Input"],
Cell[138903, 3667, 2558, 65, 88, "Output"],
Cell[141464, 3734, 205, 3, 30, "Output"],
Cell[141672, 3739, 204, 3, 30, "Output"],
Cell[141879, 3744, 204, 3, 30, "Output"],
Cell[142086, 3749, 205, 3, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[142328, 3757, 3448, 93, 272, "Input"],
Cell[145779, 3852, 3867, 69, 248, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[149683, 3926, 5266, 160, 292, "Input"],
Cell[CellGroupData[{
Cell[154974, 4090, 439, 8, 23, "Print"],
Cell[155416, 4100, 492, 14, 23, "Print"],
Cell[155911, 4116, 366, 9, 23, "Print"],
Cell[156280, 4127, 368, 9, 23, "Print"],
Cell[156651, 4138, 401, 9, 23, "Print"],
Cell[157055, 4149, 368, 9, 23, "Print"],
Cell[157426, 4160, 368, 9, 23, "Print"],
Cell[157797, 4171, 368, 9, 23, "Print"],
Cell[158168, 4182, 368, 9, 23, "Print"],
Cell[158539, 4193, 398, 9, 23, "Print"],
Cell[158940, 4204, 398, 9, 23, "Print"]
}, Open  ]],
Cell[159353, 4216, 1739, 45, 107, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[161129, 4266, 1771, 45, 172, "Input"],
Cell[CellGroupData[{
Cell[162925, 4315, 468, 10, 23, "Print"],
Cell[163396, 4327, 445, 8, 23, "Print"],
Cell[163844, 4337, 500, 14, 23, "Print"],
Cell[164347, 4353, 377, 9, 23, "Print"],
Cell[164727, 4364, 374, 9, 23, "Print"],
Cell[165104, 4375, 405, 9, 23, "Print"],
Cell[165512, 4386, 377, 9, 23, "Print"],
Cell[165892, 4397, 372, 9, 23, "Print"],
Cell[166267, 4408, 374, 9, 23, "Print"],
Cell[166644, 4419, 372, 9, 23, "Print"],
Cell[167019, 4430, 404, 9, 23, "Print"],
Cell[167426, 4441, 402, 9, 23, "Print"]
}, Open  ]],
Cell[167843, 4453, 1763, 46, 107, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[169643, 4504, 2197, 60, 192, "Input"],
Cell[CellGroupData[{
Cell[171865, 4568, 443, 8, 23, "Print"],
Cell[172311, 4578, 677, 20, 23, "Print"],
Cell[172991, 4600, 375, 9, 23, "Print"],
Cell[173369, 4611, 375, 9, 23, "Print"],
Cell[173747, 4622, 405, 9, 23, "Print"],
Cell[174155, 4633, 372, 9, 23, "Print"],
Cell[174530, 4644, 372, 9, 23, "Print"],
Cell[174905, 4655, 374, 9, 23, "Print"],
Cell[175282, 4666, 372, 9, 23, "Print"],
Cell[175657, 4677, 404, 9, 23, "Print"],
Cell[176064, 4688, 402, 9, 23, "Print"]
}, Open  ]],
Cell[176481, 4700, 1970, 52, 107, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[178488, 4757, 1872, 46, 172, "Input"],
Cell[CellGroupData[{
Cell[180385, 4807, 405, 8, 23, "Print"],
Cell[180793, 4817, 570, 12, 23, "Print"],
Cell[181366, 4831, 405, 8, 23, "Print"],
Cell[181774, 4841, 572, 12, 23, "Print"],
Cell[182349, 4855, 407, 8, 23, "Print"],
Cell[182759, 4865, 574, 12, 23, "Print"],
Cell[183336, 4879, 404, 8, 23, "Print"],
Cell[183743, 4889, 572, 12, 23, "Print"],
Cell[184318, 4903, 404, 8, 23, "Print"],
Cell[184725, 4913, 572, 12, 23, "Print"]
}, Open  ]],
Cell[185312, 4928, 1852, 58, 50, "Output"],
Cell[CellGroupData[{
Cell[187189, 4990, 442, 8, 23, "Print"],
Cell[187634, 5000, 499, 14, 23, "Print"],
Cell[188136, 5016, 442, 8, 23, "Print"],
Cell[188581, 5026, 457, 13, 23, "Print"],
Cell[189041, 5041, 443, 8, 23, "Print"],
Cell[189487, 5051, 462, 13, 23, "Print"],
Cell[189952, 5066, 445, 8, 23, "Print"],
Cell[190400, 5076, 518, 15, 23, "Print"],
Cell[190921, 5093, 445, 8, 23, "Print"],
Cell[191369, 5103, 499, 14, 23, "Print"]
}, Open  ]],
Cell[191883, 5120, 3425, 66, 231, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[195345, 5191, 4234, 127, 212, "Input"],
Cell[CellGroupData[{
Cell[199604, 5322, 484, 8, 23, "Print"],
Cell[200091, 5332, 425, 10, 23, "Print"],
Cell[200519, 5344, 426, 9, 23, "Print"],
Cell[200948, 5355, 453, 9, 23, "Print"],
Cell[201404, 5366, 425, 9, 23, "Print"],
Cell[201832, 5377, 450, 9, 23, "Print"],
Cell[202285, 5388, 452, 9, 23, "Print"],
Cell[202740, 5399, 450, 9, 23, "Print"],
Cell[203193, 5410, 454, 9, 23, "Print"],
Cell[203650, 5421, 454, 9, 23, "Print"],
Cell[204107, 5432, 451, 9, 23, "Print"],
Cell[204561, 5443, 451, 9, 23, "Print"]
}, Open  ]],
Cell[205027, 5455, 1671, 43, 88, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[206735, 5503, 3195, 81, 272, "Input"],
Cell[209933, 5586, 473, 11, 30, "Output"],
Cell[210409, 5599, 611, 16, 30, "Output"],
Cell[CellGroupData[{
Cell[211045, 5619, 513, 10, 23, "Print"],
Cell[211561, 5631, 574, 15, 23, "Print"],
Cell[212138, 5648, 506, 9, 23, "Print"],
Cell[212647, 5659, 407, 10, 23, "Print"]
}, Open  ]],
Cell[213069, 5672, 1814, 50, 69, "Output"],
Cell[214886, 5724, 963, 22, 246, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[215886, 5751, 2220, 56, 132, "Input"],
Cell[CellGroupData[{
Cell[218131, 5811, 501, 8, 23, "Print"],
Cell[218635, 5821, 458, 11, 23, "Print"]
}, Open  ]],
Cell[219108, 5835, 7454, 132, 231, 2857, 56, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[226599, 5972, 1724, 55, 92, "Input"],
Cell[228326, 6029, 1776, 24, 582, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[230139, 6058, 1004, 26, 132, "Input"],
Cell[231146, 6086, 858, 21, 30, "Output"],
Cell[232007, 6109, 869, 23, 101, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[232913, 6137, 972, 26, 132, "Input"],
Cell[233888, 6165, 672, 20, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[234597, 6190, 1087, 28, 132, "Input"],
Cell[CellGroupData[{
Cell[235709, 6222, 406, 8, 23, "Print"],
Cell[236118, 6232, 575, 12, 23, "Print"],
Cell[236696, 6246, 406, 8, 23, "Print"],
Cell[237105, 6256, 575, 12, 23, "Print"],
Cell[237683, 6270, 404, 8, 23, "Print"],
Cell[238090, 6280, 575, 12, 23, "Print"],
Cell[238668, 6294, 406, 8, 23, "Print"],
Cell[239077, 6304, 571, 12, 23, "Print"]
}, Open  ]],
Cell[239663, 6319, 80119, 2607, 1779, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[319819, 8931, 1177, 29, 152, "Input"],
Cell[CellGroupData[{
Cell[321021, 8964, 301, 4, 23, "Print"],
Cell[321325, 8970, 244, 4, 23, "Print"]
}, Open  ]],
Cell[321584, 8977, 78264, 2561, 1722, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[399885, 11543, 1049, 27, 152, "Input"],
Cell[400937, 11572, 1646, 50, 50, "Output"],
Cell[402586, 11624, 2143, 67, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[404766, 11696, 2143, 51, 272, "Input"],
Cell[CellGroupData[{
Cell[406934, 11751, 469, 9, 23, "Print"],
Cell[407406, 11762, 264, 3, 23, "Print"],
Cell[407673, 11767, 456, 9, 23, "Print"],
Cell[408132, 11778, 220, 2, 23, "Print"],
Cell[408355, 11782, 370, 9, 23, "Print"],
Cell[408728, 11793, 218, 2, 23, "Print"],
Cell[408949, 11797, 393, 10, 23, "Print"]
}, Open  ]],
Cell[409357, 11810, 2919, 78, 126, "Output"],
Cell[412279, 11890, 1182, 25, 250, "Output"],
Cell[413464, 11917, 353, 8, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[413854, 11930, 1056, 28, 172, "Input"],
Cell[CellGroupData[{
Cell[414935, 11962, 463, 10, 23, "Print"],
Cell[415401, 11974, 229, 3, 23, "Print"],
Cell[415633, 11979, 379, 10, 23, "Print"],
Cell[416015, 11991, 229, 3, 23, "Print"],
Cell[416247, 11996, 402, 11, 23, "Print"]
}, Open  ]],
Cell[416664, 12010, 2894, 78, 126, "Output"],
Cell[419561, 12090, 1189, 25, 238, "Output"],
Cell[420753, 12117, 349, 8, 30, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
