(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     74720,       2005]
NotebookOptionsPosition[     71204,       1897]
NotebookOutlinePosition[     71548,       1912]
CellTagsIndexPosition[     71505,       1909]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "This", " ", "notebook", " ", "contains", " ", "examples", " ", "for", 
     " ", "the", " ", "PET"}], "-", "functions", "\[IndentingNewLine]", " ", 
    "-", "CalcThermoBaro", "-", "          ", 
    RowBox[{
    "calculate", " ", "various", " ", "geothermometers", " ", "and", " ", 
     "geobarometers", "\[IndentingNewLine]", "Most", " ", "examples", " ", 
     "are", " ", "performed", " ", "with", " ", "mineral", " ", "analyses", 
     " ", "from", " ", "the", " ", "file", " ", "\"\<gtb\>\""}]}], 
   "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"This", " ", "top"}], "-", 
    RowBox[{
    "cell", " ", "must", " ", "be", " ", "run", " ", "once", " ", "before", 
     " ", "any", " ", "example", " ", "can", " ", "be", " ", 
     RowBox[{"performed", "."}]}]}], "  ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Define", " ", "the", " ", "directory"}], ",", 
    RowBox[{
     RowBox[{"where", " ", "the", " ", "PET"}], "-", 
     RowBox[{"files", " ", "reside", " ", 
      RowBox[{"(", 
       RowBox[{"e", ".", "g", ".", " ", 
        RowBox[{"C", ":", 
         RowBox[{
          RowBox[{"\\", "Eigene"}], " ", 
          RowBox[{"Dateien", "\\", "Pet"}]}]}]}], ")"}], " ", "and", " ", 
      "load", " ", 
      RowBox[{"PET", "."}]}]}]}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{
    "$PetDirectory", "=", 
     "\"\<C:\\Dokumente und Einstellungen\\dachsedgar\\Eigene \
Dateien\\Pet\\Pet7.0\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "$PetDirectory", "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"DeclarePackage", "[", 
     RowBox[{"\"\<DEFDAT`\>\"", ",", 
      RowBox[{"{", "\"\<Dataset\>\"", "}"}]}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "->", " ", "B88"}], "]"}], ";"}], " "}]}]], "Input",
 CellChangeTimes->{
  3.422776616875*^9, {3.485752194192988*^9, 3.4857521947711163`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "1"}], ":", " ", 
    RowBox[{
     RowBox[{
     "display", " ", "the", " ", "usage", " ", "for", " ", "the", " ", 
      "PET"}], "-", "function", " ", "-", "CalcThermoBaro", "-"}]}], "  ", 
   "*)"}], " ", "\[IndentingNewLine]", 
  RowBox[{"CalcThermoBaro", "::", "usage"}]}]], "Input"],

Cell[BoxData["\<\"CalcThermoBaro[{gtb1, gtb2, \
...},\\\"inputfile\\\",\\\"outputfile\\\"] \\ncalculates various \
geothermobarometers (gtb's).\\nEach gtb in the list {gtb1, gtb2, ...} has the \
form:\\n{gtb_specification,{min,max,step}}:\\n<gtb_specification> is either \
gt+number for the installed geothermometers (see the list below),\\nor \
gb+number for the geobarometers. gt1 e.g. represents the garnet-biotite \
thermometer (FunctionName: GT1).\\n{min, max, step} define the pressure range \
(in bar) and interval, for which temperatures are calculated\\nin the case of \
a geothermometer, and vice versa for geobarometers (T in C). \\nSome gtb's \
require a third parameter after {min, max, step}, e.g. specifiying an \
Al2SiO5-polymorph).\\n\\\"inputfile\\\" must have been created earlier with \
\\n\\nCalcFormula[\\\"inputfile\\\",CalcFormulaMode->Gtb]\\n\\n(the option \
CalcFormulaMode->Gtb is required to calculate specific \
mineral-chemical\\nparameters e.g. for clinopyroxene and garnet in the \
grt-cpx thermometer, etc.).\\nIf \\\"inputfile\\\" contains more than one \
pair of e.g. grt and bt, the analyses are grouped together\\nin order of \
their appearance, 1. grt with 1. bt, 2. grt with 2. bt, etc. The data are \
written to\\n\\\"outputfile.ptx\\\" for later use and are also returned to \
the screen and have the form:\\n\\n1.element: specification of the gtb (e.g. \
gt1),\\n2.element: name of \\\"inputfile\\\",\\n3.element: lnKD for that \
geothermobarometer,\\n4.element: calibration that has been used\\n5.element: \
list of PT-data.\\n\\nThe user is responsible for not applying the various \
calibrations beyond the range of their\\ncompositional \
applicability.\\n\\nThe following geothermometers (gt's) are available in \
PET:\\nspeci-    explanation                               \
FunctionName\\nfication\\n\\ngt1       garnet - biotite          FeMg-1       \
   GT1\\ngt2       garnet - phengite         FeMg-1          GT2\\ngt3       \
garnet - chlorite         FeMg-1          GT3\\ngt4       biotite - chlorite  \
      FeMg-1          GT4\\ngt5       phengite - biotite        FeMg-1        \
  GT5\\ngt6       garnet - ilmenite         FeMn-1          GT6\\ngt7       \
garnet - clinopyroxene    FeMg-1          GT7\\ngt8       plagioclase - \
muscovite   NaK-1           GT8\\ngt9       garnet - orthopyroxene    FeMg-1  \
        GT9\\ngt10      ortho-/clinopyoxene       CaMg-1          GT10\\ngt11 \
     orthopyroxene - biotite   FeMg-1          GT11\\ngt12      garnet - \
olivine          FeMg-1          GT12\\ngt13      clinopyroxene - olivine   \
FeMg-1          GT13\\ngt14      garnet - hornblende       FeMg-1          \
GT14\\ngt15      garnet - cordierite       FeMg-1          GT15\\ngt16      \
garnet - staurolite       FeMg-1          GT16\\ngt17      garnet - \
chloritoid       FeMg-1          GT17\\ngt18      chlorite - chloritoid     \
FeMg-1          GT18\\ngt19      biotite - chloritoid      FeMg-1          \
GT19\\ngt20      garnet - spinel           FeMg-1          GT20\\ngt21      \
olivine - spinel          FeMg-1          GT21\\ngt22      cordierite - \
spinel       FeMg-1          GT22\\ngt23      amphibole - plagioclase   \
exchange        GT23\\ngt24      calcite - dolomite        solvus          \
GT24\\ngt25      plagioclase - Kfeldspar   solvus          GT25\\n\\nThe \
following geobarometers (gb's) are available in PET:\\nspeci-    explanation  \
                             FunctionName\\nfication\\n\\ngb1       GASP      \
                                GB1\\ngb2       garnet-plagioclase-white \
mica-biotite     GB2\\ngb3       garnet-plagioclase-white mica             \
GB3\\ngb4       garnet-plagioclase-biotite                GB4\\ngb5       \
garnet-white mica-Al2SiO5-quartz          GB5\\ngb6       garnet-white \
mica-biotite-Al2SiO5-quartz  GB6\\ngb7       GRAIL                            \
         GB7\\ngb8       chlorite-biotite-white mica               GB8\\ngb9  \
     garnet-amphibole-plagioclase              GB9\\ngb10      albite = \
jadeite + quartz                 GB10\\ngb11      garnet-phengite-omphacite   \
              GB11\\ngb12      amphibole - chlorite                      GB12\
\\ngb13      Al-in-hornblende                          GB13\\ngb14      \
Al-in-orthopyroxene                       GB14\\ngb15      \
garnet-orthopyroxene-plagioclase-quartz   GB15\\ngb16      \
garnet-clinopyroxene-plagioclase-quartz   GB16\\n\\nFor most gtb's there are \
several calibrations available. The program returns the latest version\\nby \
default, but the user can choose the calibration most appropriate for his/her \
purpose.\\nType\\n\\nFunctionName::usage (e.g. GT1::usage)\\n\\nto see the \
available calibrations for each gtb (examples are also given for each gtb, \
using data from the file\\n\\\"gtb.fu\\\". This file is an arbitrary \
collection of analyses, so results are in no way meaningful !).\\n\\nTo \
change the default calibration use:\\n\\nSetOptions[FunctionName, \
FunctionNameCalibration->YourChoice(Number: 0,1,2,etc.)];\\n\\nbefore calling \
-CalcThermoBaro-.\\n(Number=0 is the default, otherwise number must be 1, 2, \
3, etc., depending on how many calibrations there are).\\n\\nExample: \
\\n\\nSetOptions[GT1,GT1Calibration->16];\\nresult = \
CalcThermoBaro[{{gt1,{2000,6000,2000}},\\n{gb1,{400,600,25},sillimanite}},\\\"\
gtb\\\",\\\"test\\\"]\\n\\nThis calculates the garnet-biotite thermometer and \
the GASP barometer from mineralchemical data of the file\\n\\\"gtb.fu\\\" \
(created with CalcFormula[\\\"gtb\\\", CalcFormulaMode -> Gtb]), storing \
results in\\nthe file \\\"test.ptx\\\", using the Hodges & Spear calibration \
for the garnet-biotite geothermometer.\\nReturnValue:\\n\\n{{{grt-bt FeMg-1}, \
{gtb, {lnKD = -2.08361, GT1Calibration = Hodges & Spear (1982), \
eq.(9)}},\\n{{472.31, 2000.}, {478.94, 4000.}, {485.56, 6000.}}},\\n{{GASP \
barometer}, {gtb, {lnK = -1.62754, GB1Calibration = Koziol (1989), \
sillimanite}},\\n{{400., 3142.22}, {425., 3681.78}, {450., 4221.1}, {475., \
4760.2}, {500., 5299.06}, {525., 5837.68},\\n{550., 6376.07}, {575., \
6914.23}, {600., 7452.15}}}}\\n\\nData can be plotted with PlotRea[result], \
and the intersection of grt/bt and GASP can be calculated \
with\\nCalcReaIntersection[result].\\nPackage name: GTB.m\\nPET: Petrological \
Elementary Tools, (c) Edgar Dachs.\"\>"], "Output",
 CellChangeTimes->{3.422776630625*^9, 3.460966434625*^9, 3.485494248720947*^9,
   3.4857513346575956`*^9, 3.485752226505695*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "2"}], ":", " ", 
    RowBox[{
     RowBox[{
     "display", " ", "the", " ", "available", " ", "calibrations", " ", "for",
       " ", "the", " ", "garnet"}], "-", 
     RowBox[{"biotite", " ", "geothermometer", " ", 
      RowBox[{"(", "GT1", ")"}]}]}]}], "  ", "*)"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{"GT1", "::", "usage"}]}]], "Input"],

Cell[BoxData["\<\"\\nGarnet - biotite FeMg-1 exchange \
geothermometer.\\n\\nOption for selecting a specific calibration:\\nName      \
        Value        Reference\\n\\nGT1Calibration -> 0 (default)  Holdaway \
(2000), Am Min 85:881-892\\n                  1            Gessmann et al. \
(1997), Am Min 82:1225-1240\\n                  2            Holdaway et al. \
(1997), Am Min 82:582-595\\n                  3            Kleemann & \
Reinhardt (1994), Eur J Mineral 6:925-941,\\n                               \
with Berman (1990) garnet model\\n                  4            Bhattacharya \
et al. (1992), Contrib Mineral Petrol 111:87-93,\\n                           \
    with Ganguly & Saxena (1984) garnet model\\n                  5           \
 Bhattacharya et al. (1992), Contrib Mineral Petrol 111:87-93,\\n             \
                  with Hackler & Wood (1984) garnet model\\n                  \
6            Dasgupta et al. (1991), Contrib Mineral Petrol 109:130-137\\n    \
              7            Williams & Grambling (1990), Am Min 75:886-908\\n  \
                8            Aranovich et al. (1988), Geokhimiya 5:668-676\\n \
                 9            Hoinkes (1986), Contrib Mineral Petrol \
92:393-399\\n                  10           Indares & Martignole (1985), \
Model B, Am Min 70:272-278\\n                  11           Indares & \
Martignole (1985), Model A, Am Min 70:272-278\\n                  12          \
 Ganguly & Saxena (1984), asymmetric garnet model, Am Min 69:88-97\\n         \
         13           Ganguly & Saxena (1984), symmetric garnet model, Am Min \
69:88-97\\n                  14           Perchuk & Lavrent'eva (1983), In: \
Saxena, SK ed., Kinetics and\\n                               Equilibrium in \
Mineral Reactions. Springer Verlag, pp.199-240\\n                  15         \
  Pigage & Greenwood (1982), Am J Sci 282:943-969\\n                  16      \
     Hodges & Spear (1982), Am Min 67:1118-1134\\n                  17        \
   Lavrent'yeva & Perchuk (1981), Dokl Akad Nauk SSSR 260:731-734\\n          \
        18           Ferry & Spear (1978), Contrib Mineral Petrol \
66:113-117\\n                  19           Holdaway & Lee (1977), Contrib \
Mineral Petrol 63:175-198\\n                  20           Goldman & Albee \
(1977), Am J Sci 277:750-767,\\n                               with \
1000ln(alfa) according to Matthews et al. (1983)\\n                  21       \
    Goldman & Albee (1977), Am J Sci 277:750-767,\\n                          \
     with 1000ln(alfa) according to Bottinga & Javoy (1973)\\n                \
  22           Thompson (1976), Am J Sci 276:425-454\\n\\nExample (using \
default calibration): \\n\\nresult = CalcThermoBaro[{{gt1,{3000,6000,3000}}},\
\\\"gtb\\\",\\\"test\\\"]\\n\\nReturnValue:\\n{{{grt-bt FeMg-1}, {gtb, {lnKD \
= -2.08361, GrtBtCalibration = Holdaway (2000)}},\\n{{559.52, 3000}, {567.22, \
6000}}}}\\n\\nExample (using calibration No. 18): \\n\\nSetOptions[GT1, \
GT1Calibration->18];\\nresult = \
CalcThermoBaro[{{gt1,{3000,6000,3000}}},\\\"gtb\\\",\\\"test\\\"]\\n\\\
nReturnValue:\\n{{{grt-bt FeMg-1}, {gtb, {lnKD = -2.08361, GT1Calibration = \
Ferry and Spear (1978), eq. (7)}},\\n{{465.91, 3000}, {475.92, \
6000}}}}\\n\\nPackage name: GTB.m\\nPET: Petrological Elementary Tools, (c) \
Edgar Dachs.\"\>"], "Output",
 CellChangeTimes->{3.42277663296875*^9, 3.460966437328125*^9, 
  3.4854942508771276`*^9, 3.485751334673221*^9, 3.48575222652132*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "3"}], ":", " ", 
     RowBox[{
      RowBox[{
      "calculate", " ", "the", " ", "formulae", " ", "for", " ", "analyses", 
       " ", "in", " ", "the", " ", "file", " ", "\"\<gtb\>\"", " ", 
       RowBox[{"(", 
        RowBox[{"PET", "-", "function", " ", "-", "CalcFormula", "-"}], ")"}],
        " ", "and", "\[IndentingNewLine]", "then", " ", "use", " ", "the", 
       " ", "PET"}], "-", "function", " ", "-", "CalcThermoBaro", "-", " ", 
      RowBox[{"to", " ", "compute", " ", "the", " ", "garnet"}], "-", 
      RowBox[{"biotite", " ", "geothermometer", " ", 
       RowBox[{"(", "gt1", ")"}], " ", "for", " ", "pressures", " ", "from", 
       " ", "1", " ", "to", " ", "10", " ", "kb", " ", "in", " ", "1", "kb"}],
       "-", "steps"}]}], ",", " ", 
    RowBox[{
    "saving", " ", "data", " ", "to", " ", "the", " ", "file", " ", 
     "\"\<test\>\""}]}], " ", "*)"}], " ", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"file", " ", "=", " ", "\"\<gtb\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CalcFormula", "[", 
     RowBox[{"file", ",", " ", 
      RowBox[{"CalcFormulaMode", " ", "->", " ", "Gtb"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"result", "=", 
    RowBox[{"CalcThermoBaro", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"gt1", ",", 
         RowBox[{"{", 
          RowBox[{"1000", ",", "10000", ",", "1000"}], "}"}]}], "}"}], "}"}], 
      ",", "file", ",", "\"\<test\>\""}], "]"}], " "}]}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"gtb.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "gtb.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422776639296875*^9, 3.460966438734375*^9, 
  3.4854942526114473`*^9, 3.4857513347357235`*^9, 3.4857522265994453`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-bt FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = -2.08361\"\>", 
        ",", "\<\"GT1Calibration = Holdaway (2000)\"\>"}], "}"}]}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"554.39`", ",", "1000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"556.95`", ",", "2000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"559.52`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"562.09`", ",", "4000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"564.66`", ",", "5000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"567.22`", ",", "6000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"569.79`", ",", "7000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"572.36`", ",", "8000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"574.93`", ",", "9000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"577.49`", ",", "10000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.422776639375*^9, 3.46096643878125*^9, 
  3.4854942526739454`*^9, 3.4857513347982264`*^9, 3.4857522266619453`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "4"}], ":", " ", 
     RowBox[{
      RowBox[{"Use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
      "CalcThermoBaro", "-", " ", 
      RowBox[{"to", " ", "compute", " ", "the", " ", "garnet"}], "-", 
      RowBox[{"biotite", " ", "geothermometer", " ", 
       RowBox[{"(", "gt1", ")"}], " ", "for", " ", "pressures", " ", "from", 
       " ", "1", " ", "to", " ", "10", " ", "kb", " ", "in", " ", "1", "kb"}],
       "-", "steps"}]}], ",", " ", 
    RowBox[{"saving", " ", "data", " ", "to", " ", "the", " ", "file", " ", 
     RowBox[{"\"\<test\>\"", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Change", " ", "the", " ", "default", " ", "calibration", " ", "to", " ", 
     "number", " ", "16"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"which", " ", "is", " ", "the", " ", "Hodges"}], " ", "&"}], 
     " ", "Spear", " ", 
     RowBox[{"(", "1982", ")"}], " ", "calibration", " ", 
     RowBox[{"(", 
      RowBox[{"see", " ", 
       RowBox[{"GT1", "::", "usage"}]}], ")"}]}]}], " ", "*)"}], " ", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"GT1", ",", 
      RowBox[{"GT1Calibration", "\[Rule]", "22"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"result", "=", 
    RowBox[{"CalcThermoBaro", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"gt1", ",", 
         RowBox[{"{", 
          RowBox[{"1000", ",", "10000", ",", "1000"}], "}"}]}], "}"}], "}"}], 
      ",", "file", ",", "\"\<test\>\""}], "]"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-bt FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = -2.08361\"\>", 
        ",", "\<\"GT1Calibration = Thompson (1976), Table 1\"\>"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"485.17`", ",", "1000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"491.59`", ",", "2000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"498.01`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"504.44`", ",", "4000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"510.86`", ",", "5000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"517.28`", ",", "6000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"523.7`", ",", "7000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"530.13`", ",", "8000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"536.55`", ",", "9000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"542.97`", ",", "10000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.422776641875*^9, 3.460966440765625*^9, 
  3.4854942547520037`*^9, 3.485751334954482*^9, 3.4857522266931963`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "5"}], ":", " ", 
     RowBox[{
      RowBox[{"Use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
      "CalcThermoBaro", "-", " ", 
      RowBox[{"to", " ", "compute", " ", "the", " ", "garnet"}], "-", 
      RowBox[{"biotite", " ", "geothermometer", " ", 
       RowBox[{"(", "gt1", ")"}], " ", "for", " ", "pressures", " ", "from", 
       " ", "1", " ", "to", " ", "10", " ", "kb", " ", "in", " ", "1", "kb"}],
       "-", "steps"}]}], ",", " ", 
    RowBox[{"and", " ", "the", " ", "GASP", " ", "barometer", " ", 
     RowBox[{"(", "gb1", ")"}]}], ",", " ", 
    RowBox[{
    "for", " ", "temperatures", " ", "between", " ", "400", " ", "and", " ", 
     "700", " ", "C"}], ",", " ", 
    RowBox[{
     RowBox[{"in", " ", "50", "C"}], "-", 
     RowBox[{"steps", " ", "for", " ", "the", " ", "data", " ", "file", " ", 
      RowBox[{"\"\<hs78b\>\"", ".", " ", "Save"}], " ", "data", " ", "to", 
      " ", "the", " ", "file", " ", "\"\<test\>\""}]}], ",", " ", 
    RowBox[{
    "plot", " ", "the", " ", "results", " ", "and", " ", "calculate", " ", 
     "the", " ", "intersection"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"file", " ", "=", " ", "\"\<hs78b\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CalcFormula", "[", 
     RowBox[{"file", ",", 
      RowBox[{"CalcFormulaMode", "\[Rule]", "Gtb"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"result", "=", 
    RowBox[{"CalcThermoBaro", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"gt1", ",", 
          RowBox[{"{", 
           RowBox[{"1000", ",", "10000", ",", "1000"}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"gb1", ",", 
          RowBox[{"{", 
           RowBox[{"400", ",", "700", ",", "50"}], "}"}], ",", "kyanite"}], 
         "}"}]}], "}"}], ",", "file", ",", "\"\<test\>\""}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plot1", "=", 
     RowBox[{"PlotRea", "[", "result", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"CalcReaIntersection", "[", "result", "]"}]}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"hs78b.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "hs78b.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.42277664465625*^9, 3.4609664429375*^9, 
  3.485494259486227*^9, 3.485751334985733*^9, 3.4857522267244463`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"{grt-bt FeMg-1}\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"hs78b\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"\<\"lnKD = -2.08361\"\>", 
         ",", "\<\"GT1Calibration = Thompson (1976), Table 1\"\>"}], "}"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"485.17`", ",", "1000.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"491.59`", ",", "2000.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"498.01`", ",", "3000.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"504.44`", ",", "4000.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"510.86`", ",", "5000.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"517.28`", ",", "6000.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"523.7`", ",", "7000.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"530.13`", ",", "8000.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"536.55`", ",", "9000.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"542.97`", ",", "10000.`"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"{GASP barometer}\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"hs78b\"\>", ",", 
       RowBox[{"{", 
        RowBox[{"\<\"lnK = -1.49787\"\>", 
         ",", "\<\"GB1Calibration = Koziol (1989)\"\>", 
         ",", "\<\"kyanite\"\>"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"400.`", ",", "2928.187`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"450.`", ",", "3999.02`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"500.`", ",", "5069.852`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"550.`", ",", "6140.684`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"600.`", ",", "7211.516`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"650.`", ",", "8282.349`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"700.`", ",", "9353.181`"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.422776644671875*^9, 3.460966442953125*^9, 
  3.485494259501852*^9, 3.485751335001359*^9, 3.4857522267400713`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"5350.649156084738`", ",", "513.111167582064`", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.422776644671875*^9, 3.460966442953125*^9, 
  3.485494259501852*^9, 3.485751335001359*^9, 3.4857522267713213`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Example", " ", "5", " ", 
    RowBox[{"continued", ":", " ", 
     RowBox[{
     "compare", " ", "the", " ", "results", " ", "with", " ", "those", " ", 
      "using", " ", "a", " ", "thermodynamic", " ", "data", " ", "set", " ", 
      "in", " ", "the", " ", "reaction", " ", "calculation", " ", 
      RowBox[{"(", 
       RowBox[{"example", " ", "6", " ", "in", " ", 
        RowBox[{"CalcRea", ".", "nb"}]}], ")"}]}]}]}], "  ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phases", "=", 
     RowBox[{"{", 
      RowBox[{
      "ann", ",", "phl", ",", "alm", ",", "py", ",", "gr", ",", "an", ",", 
       "ky", ",", "qz"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"rea", "=", 
     RowBox[{"MakeRea", "[", "phases", "]"}]}], ";"}], "\n", 
   RowBox[{"result", "=", 
    RowBox[{"CalcRea", "[", 
     RowBox[{"rea", ",", 
      RowBox[{"CalcReaMin", "\[Rule]", "1000"}], ",", 
      RowBox[{"CalcReaMax", "\[Rule]", "10000"}], ",", 
      RowBox[{"Steps", "\[Rule]", "10"}], ",", 
      RowBox[{"CalcReaMode", "\[Rule]", "PT"}], ",", 
      RowBox[{"SampleFile", "\[Rule]", "\"\<hs78b\>\""}], ",", 
      RowBox[{"Screen", "\[Rule]", "ScreenNo"}]}], "]"}]}], "\n", 
   RowBox[{"plot2", "=", 
    RowBox[{"PlotRea", "[", "result", "]"}]}], "\n", 
   RowBox[{"CalcReaIntersection", "[", "result", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"plot1", ",", "plot2"}], "]"}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422776652171875*^9, 3.460966444296875*^9, 
  3.4854942702202587`*^9, 3.4857513350951123`*^9, 3.4857522268025713`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3.`"}], " ", "an"}], ",", 
   RowBox[{"1.`", " ", "gr"}], ",", 
   RowBox[{"2.`", " ", "ky"}], ",", 
   RowBox[{"1.`", " ", "qz"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422776652171875*^9, 3.460966444296875*^9, 
  3.4854942702202587`*^9, 3.4857513350951123`*^9, 3.485752226833822*^9}],

Cell[BoxData["\<\"calculating PT data of the reaction:\"\>"], "Print",
 CellChangeTimes->{3.422776652171875*^9, 3.460966444296875*^9, 
  3.4854942702202587`*^9, 3.4857513350951123`*^9, 3.485752227083823*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "alm"}], ",", 
   RowBox[{
    RowBox[{"-", "1.`"}], " ", "phl"}], ",", 
   RowBox[{"1.`", " ", "ann"}], ",", 
   RowBox[{"1.`", " ", "py"}]}], "}"}]], "Print",
 CellChangeTimes->{3.422776652171875*^9, 3.460966444296875*^9, 
  3.4854942702202587`*^9, 3.4857513350951123`*^9, 3.485752227099448*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3.`"}], " ", "an"}], ",", 
         RowBox[{"1.`", " ", "gr"}], ",", 
         RowBox[{"2.`", " ", "ky"}], ",", 
         RowBox[{"1.`", " ", "qz"}]}], "}"}], 
       ",", "\<\"{a(alm)=GrtBerman, a(phl)=BtMcMullin, a(ann)=BtMcMullin, \
a(py)=GrtBerman}\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"328.543`", ",", "1000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"379.693`", ",", "2000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"430.72`", ",", "3000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"481.588`", ",", "4000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"532.26`", ",", "5000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"582.7`", ",", "6000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"632.876`", ",", "7000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"682.758`", ",", "8000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"732.322`", ",", "9000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"781.547`", ",", "10000.`"}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1.`"}], " ", "alm"}], ",", 
         RowBox[{
          RowBox[{"-", "1.`"}], " ", "phl"}], ",", 
         RowBox[{"1.`", " ", "ann"}], ",", 
         RowBox[{"1.`", " ", "py"}]}], "}"}], 
       ",", "\<\"{a(alm)=GrtBerman, a(phl)=BtMcMullin, a(ann)=BtMcMullin, \
a(py)=GrtBerman}\"\>", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"464.944`", ",", "1000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"469.823`", ",", "2000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"474.684`", ",", "3000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"479.528`", ",", "4000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"484.353`", ",", "5000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"489.16`", ",", "6000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"493.95`", ",", "7000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"498.721`", ",", "8000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"503.475`", ",", "9000.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"508.21`", ",", "10000.`"}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Dataset -> B88\"\>", ",", "\<\"SampleFile->hs78b\"\>"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.422776652859375*^9, 3.460966444734375*^9, 
  3.4854942707514915`*^9, 3.485751335626383*^9, 3.485752227365075*^9}],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{328.543, 1000.}, {379.693, 2000.}, {430.72, 3000.}, {481.588, 
       4000.}, {532.26, 5000.}, {582.7, 6000.}, {632.876, 7000.}, {682.758, 
       8000.}, {732.322, 9000.}, {781.547, 10000.}}]}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{328.543, 1000.}, {379.693, 2000.}, {430.72, 3000.}, {481.588, 
       4000.}, {532.26, 5000.}, {582.7, 6000.}, {632.876, 7000.}, {682.758, 
       8000.}, {732.322, 9000.}, {781.547, 10000.}}]}}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{464.944, 1000.}, {469.823, 2000.}, {474.684, 3000.}, {479.528, 
      4000.}, {484.353, 5000.}, {489.16, 6000.}, {493.95, 7000.}, {498.721, 
      8000.}, {503.475, 9000.}, {508.21, 10000.}}]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{400., 0},
  DisplayFunction->Identity,
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.422776652859375*^9, 3.460966444734375*^9, 
  3.4854942707514915`*^9, 3.485751335626383*^9, 3.4857522273807*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"3955.1639647760044`", ",", "479.31120646173065`", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.422776652859375*^9, 3.460966444734375*^9, 
  3.4854942707514915`*^9, 3.485751335626383*^9, 3.485752227396325*^9}],

Cell[BoxData[
 GraphicsBox[{{{{{}, {}, 
      {Hue[0.67, 0.6, 0.6], 
       LineBox[{{485.17, 1000.}, {491.59, 2000.}, {498.01, 3000.}, {504.44, 
        4000.}, {510.86, 5000.}, {517.28, 6000.}, {523.7, 7000.}, {530.13, 
        8000.}, {536.55, 9000.}, {542.97, 10000.}}]}}, {{}, {}, 
      {Hue[0.67, 0.6, 0.6], 
       LineBox[{{485.17, 1000.}, {491.59, 2000.}, {498.01, 3000.}, {504.44, 
        4000.}, {510.86, 5000.}, {517.28, 6000.}, {523.7, 7000.}, {530.13, 
        8000.}, {536.55, 9000.}, {542.97, 10000.}}]}}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{400., 2928.187}, {450., 3999.02}, {500., 5069.852}, {550., 
       6140.684}, {600., 7211.516}, {650., 8282.349}, {700., 
       9353.181}}]}}}, {{{{}, {}, 
      {Hue[0.67, 0.6, 0.6], 
       LineBox[{{328.543, 1000.}, {379.693, 2000.}, {430.72, 3000.}, {481.588,
         4000.}, {532.26, 5000.}, {582.7, 6000.}, {632.876, 7000.}, {682.758, 
        8000.}, {732.322, 9000.}, {781.547, 10000.}}]}}, {{}, {}, 
      {Hue[0.67, 0.6, 0.6], 
       LineBox[{{328.543, 1000.}, {379.693, 2000.}, {430.72, 3000.}, {481.588,
         4000.}, {532.26, 5000.}, {582.7, 6000.}, {632.876, 7000.}, {682.758, 
        8000.}, {732.322, 9000.}, {781.547, 10000.}}]}}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{464.944, 1000.}, {469.823, 2000.}, {474.684, 3000.}, {479.528,
        4000.}, {484.353, 5000.}, {489.16, 6000.}, {493.95, 7000.}, {498.721, 
       8000.}, {503.475, 9000.}, {508.21, 10000.}}]}}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{490., 0},
  DisplayFunction->Identity,
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.422776652859375*^9, 3.460966444734375*^9, 
  3.4854942707514915`*^9, 3.485751335626383*^9, 3.485752227396325*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "6"}], ":", " ", 
     RowBox[{"Test", " ", "through", " ", "all", " ", "geothermometers", " ", 
      RowBox[{"(", 
       RowBox[{"except", " ", "GT25"}], ")"}]}]}], ",", " ", 
    RowBox[{
    "using", " ", "data", " ", "from", " ", "the", " ", "file", " ", 
     "\"\<gtb\>\""}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"CalcFormula", "[", 
     RowBox[{"\"\<gtb\>\"", ",", 
      RowBox[{"Fe3Amph", "->", "HollandBlundy"}], ",", 
      RowBox[{"CalcFormulaMode", " ", "->", " ", "Gtb"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", " ", 
     RowBox[{"i", "\[LessEqual]", " ", "25"}], ",", 
     RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"CalcThermoBaro", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ToExpression", "[", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"\"\<gt\>\"", ",", 
              RowBox[{"ToString", "[", "i", "]"}]}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"3000", ",", "6000", ",", "3000"}], "}"}]}], "}"}], "}"}],
         ",", "\"\<gtb\>\"", ",", "\"\<test\>\""}], "]"}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"gtb.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "gtb.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.485752227474451*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-bt FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = -2.08361\"\>", 
        ",", "\<\"GT1Calibration = Thompson (1976), Table 1\"\>"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"498.01`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"517.28`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.485752227490076*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-wm FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = 2.25382\"\>", 
        ",", "\<\"GT2Calibration = Hynes & Forest (1988)\"\>"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"491.091`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"491.091`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.485752227505701*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-chl FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = -1.97069\"\>", 
        ",", "\<\"GT3Calibration = Perchuk (1991), eq.(18)\"\>"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"564.383`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"564.383`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.485752227521326*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{bt-chl FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = -0.112917\"\>", 
        ",", "\<\"GT4Calibration = Dickensen & Hewitt (1986)\"\>"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"144.635`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"158.398`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.485752227521326*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{wm-bt FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = -1.21074\"\>", 
        ",", "\<\"GT5Calibration = Hoisch (1989)\"\>"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"467.107`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"525.416`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.485752227536951*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-fetiox FeMn-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = 2.34926\"\>", 
        ",", "\<\"GT6Calibration = Pownceby et al. (1991)\"\>"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"422.246`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"422.246`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.485752227552576*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-cpx FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = 2.99809\"\>", 
        ",", "\<\"GT7Calibration = Krogh (2000)\"\>"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"314.695`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"326.735`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.485752227552576*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{plag-wm NaK-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = 5.95517\"\>", 
        ",", "\<\"GT8Calibration = Green & Usdansky (1986)\"\>"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"498.695`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"529.739`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.4857522275682015`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-opx FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = -6.20737\"\>", 
        ",", "\<\"GT9Calibration = Aranovich & Berman (1997): Alm = 3Fs + \
Al2O3\"\>"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"585.883`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"669.539`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.4857522275838265`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{opx-cpx solvus}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = -6.09805\"\>", 
        ",", "\<\"GT10Calibration = Brey & Koehler (1990): En(opx) = \
En(cpx)\"\>"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"162.174`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"165.551`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.4857522275838265`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{opx-bt FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = -0.583165\"\>", 
        ",", "\<\"GT11Calibration = Sengupta et al. (1990)\"\>"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1426.762`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1450.918`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.4857522275994515`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-ol FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = 2.59536\"\>", 
        ",", "\<\"GT12Calibration = O'Neill & Wood (1979), corrected (1980)\"\
\>"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3.425`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"15.547`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.485752227615077*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{cpx-ol FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = -0.402721\"\>", 
        ",", "\<\"GT13Calibration = Powell & Powell (1974)\"\>"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1016.684`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1033.652`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.485752227630702*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-amph FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = 11.8265\"\>", 
        ",", "\<\"GT14Calibration = Dale et al. (2000)\"\>"}], "}"}]}], "}"}],
     ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"402.596`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"416.469`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.485752227630702*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-crd FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = -3.58328\"\>", 
        ",", "\<\"GT15Calibration = Bhattacharya et al. (1988)\"\>"}], 
       "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"438.767`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"448.656`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.485752227646327*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-stau FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = 0.455363\"\>", 
        ",", "\<\"GT16Calibration = Perchuk (1991), eq.(19)\"\>"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"555.737`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"562.651`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.485752227661952*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-ctd FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = 0.572602\"\>", 
        ",", "\<\"GT17Calibration = Perchuk (1991), eq.(20)\"\>"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"643.672`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"643.672`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.485752227677577*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{chl-ctd FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = 1.39809\"\>", 
        ",", "\<\"GT18Calibration = Vidal et al. (1999), eq.(4)\"\>"}], 
       "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"561.642`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"561.642`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.4857522276932025`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{bt-ctd FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = 1.51101\"\>", 
        ",", "\<\"GT19Calibration = Perchuk (1991), eq.(22)\"\>"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"416.295`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"416.295`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.4857522276932025`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-spin FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = 1.09385\"\>", 
        ",", "\<\"GT20Calibration = Perchuk (1991), eq.(29)\"\>"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"648.369`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"653.559`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.4857522277088275`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{ol-spin FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = 1.50151\"\>", 
        ",", "\<\"GT21Calibration = Ballhaus et al. (1991)\"\>"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"285.501`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"290.841`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.4857522277244525`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{crd-spin FeMg-1}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = -2.48943\"\>", 
        ",", "\<\"GT22Calibration = Perchuk (1991), eq.(29)\"\>"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"510.975`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"529.999`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.4857522277400775`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{amph-plag exchange}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnK = -1.55132\"\>", 
        ",", "\<\"GT23Calibration = Holland & Blundy (1994), \
edenite-tremolite\"\>"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"615.867`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"619.262`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.485752227755703*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{cal-dol solvus}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"X-Mg(Dol)= 0.991219\"\>", 
        ",", "\<\"GT24Calibration = Gottschalk (1990) for pure Ca-Mg system\"\
\>"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"427.098`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"417.073`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.485752227771328*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{plag-kf solvus}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = -1.70132\"\>", 
        ",", "\<\"GT25Calibration = Perchuk et al. (1991), eq.(64, 68)\"\>"}],
        "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"411.582`", ",", "3000.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"373.597`", ",", "6000.`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.42277665853125*^9, 3.460966446796875*^9, {3.485494293563262*^9, 
   3.485494317796861*^9}, 3.4857513357201366`*^9, 3.485752227786953*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "8"}], ":", " ", 
     RowBox[{"Test", " ", "through", " ", "all", " ", "geobarometers"}]}], 
    ",", " ", 
    RowBox[{
    "using", " ", "data", " ", "from", " ", "the", " ", "file", " ", 
     "\"\<gtb\>\""}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"i", "=", "1"}], ",", " ", 
    RowBox[{"i", "\[LessEqual]", " ", "9"}], ",", 
    RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"CalcThermoBaro", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ToExpression", "[", 
           RowBox[{"StringJoin", "[", 
            RowBox[{"\"\<gb\>\"", ",", 
             RowBox[{"ToString", "[", "i", "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"500", ",", "800", ",", "100"}], "}"}], ",", "kyanite"}], 
         "}"}], "}"}], ",", "\"\<gtb\>\"", ",", "\"\<test\>\""}], "]"}], 
     "]"}]}], "\[IndentingNewLine]", "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{GASP barometer}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnK = -1.39237\"\>", 
        ",", "\<\"GB1Calibration = Koziol (1989)\"\>", 
        ",", "\<\"kyanite\"\>"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"500.`", ",", "5069.852`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600.`", ",", "7211.516`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"700.`", ",", "9353.181`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800.`", ",", "11494.846`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.4227766663125*^9, 3.460966453453125*^9, 
  3.4854943229685707`*^9, 3.485751336048274*^9, 3.485752227802578*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-plag-wm-bt barometer}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnK = 8.69863\"\>", 
        ",", "\<\"GB2Calibration = Hoisch (1990), Mg-reaction (R5)\"\>"}], 
       "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"500.`", ",", "4049.157`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600.`", ",", "5146.708`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"700.`", ",", "6244.26`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800.`", ",", "7341.811`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.4227766663125*^9, 3.460966453453125*^9, 
  3.4854943229685707`*^9, 3.485751336048274*^9, 3.485752227818203*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-plag-wm barometer}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnK = 2.93245\"\>", 
        ",", "\<\"GB3Calibration = Hoisch (1990), Mg-reaction (R3)\"\>"}], 
       "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"500.`", ",", "4131.586`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600.`", ",", "5545.843`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"700.`", ",", "6960.1`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800.`", ",", "8374.358`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.4227766663125*^9, 3.460966453453125*^9, 
  3.4854943229685707`*^9, 3.485751336048274*^9, 3.485752227833828*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-plag-bt barometer}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnK = 4.14319\"\>", 
        ",", "\<\"GB4Calibration = Hoisch (1990), Mg-reaction (R1)\"\>"}], 
       "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"500.`", ",", "4444.935`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600.`", ",", "5963.923`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"700.`", ",", "7482.91`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800.`", ",", "9001.897`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.4227766663125*^9, 3.460966453453125*^9, 
  3.4854943229685707`*^9, 3.485751336048274*^9, 3.485752227833828*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-wm-Al2SiO5-qz barometer}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnK = -8.47671\"\>", 
        ",", "\<\"GB5Calibration = Hodges & Crowley (1985), (R7), \
kyanite\"\>"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"500.`", ",", "2133.16`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600.`", ",", "8312.111`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"700.`", ",", "14491.062`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800.`", ",", "20670.013`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.4227766663125*^9, 3.460966453453125*^9, 
  3.4854943229685707`*^9, 3.485751336048274*^9, 3.485752227849453*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-wm-bt-Al2SiO5-qz barometer}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnK = -1.64606\"\>", 
        ",", "\<\"GB6Calibration = Holdaway et al. (1988), sillimanite\"\>"}],
        "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"500.`", ",", "2133.871`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600.`", ",", "4299.777`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"700.`", ",", "6465.682`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800.`", ",", "8631.588`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.4227766663125*^9, 3.460966453453125*^9, 
  3.4854943229685707`*^9, 3.485751336048274*^9, 3.4857522278650784`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{GRAIL barometer}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnK = -0.4478\"\>", 
        ",", "\<\"GB7Calibration = Bohlen et al. (1983), GRAIL, \
kyanite\"\>"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"500.`", ",", "9360.644`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600.`", ",", "9401.877`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"700.`", ",", "9443.111`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800.`", ",", "9484.345`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.4227766663125*^9, 3.460966453453125*^9, 
  3.4854943229685707`*^9, 3.485751336048274*^9, 3.485752227880704*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{chl-bt-wm barometer}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnK = 10.6526\"\>", 
        ",", "\<\"GB8Calibration = Bucher-Nurminen (1987)\"\>"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"500.`", ",", 
        RowBox[{"-", "716.535`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600.`", ",", "5142.25`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"700.`", ",", "9253.923`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800.`", ",", "13873.427`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.4227766663125*^9, 3.460966453453125*^9, 
  3.4854943229685707`*^9, 3.485751336048274*^9, 3.485752227880704*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-amph-plag barometer}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnK = 10.1735\"\>", 
        ",", "\<\"GB9Calibration = Dale et al. (2000), reaction (1): \
Tschermakite-tremolite\"\>"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"500.`", ",", "533.328`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600.`", ",", "1287.819`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"700.`", ",", "2027.629`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800.`", ",", "2752.758`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.4227766663125*^9, 3.460966453453125*^9, 
  3.4854943229685707`*^9, 3.485751336048274*^9, 3.485752227896329*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "8"}], ":", " ", "continued"}], "  ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "->", " ", "HP32"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"file", " ", "=", " ", "\"\<grtwmcpx\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CalcFormula", "[", 
     RowBox[{"file", ",", " ", 
      RowBox[{"CalcFormulaMode", " ", "->", " ", "Gtb"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"CalcThermoBaro", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"gb10", ",", 
        RowBox[{"{", 
         RowBox[{"500", ",", "800", ",", "100"}], "}"}]}], "}"}], "}"}], ",", 
     "file", ",", "\"\<test\>\""}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"CalcThermoBaro", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"gb11", ",", 
        RowBox[{"{", 
         RowBox[{"500", ",", "800", ",", "100"}], "}"}]}], "}"}], "}"}], ",", 
     "file", ",", "\"\<test\>\""}], "]"}], "\[IndentingNewLine]"}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"grtwmcpx.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "grtwmcpx.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.4227766693125*^9, 3.460966456046875*^9, 
  3.4854943282027783`*^9, 3.4857513362201557`*^9, 3.485752227927579*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{Ab = Jd+Qz barometer}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"grtwmcpx\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnK = 0.742611\"\>", 
        ",", "\<\"GB10Calibration = Holland (1980), a(jd) as in \
THERMOCALC\"\>"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"500.`", ",", "10847.03`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600.`", ",", "13140.958`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"700.`", ",", "15434.886`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800.`", ",", "17728.814`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.422776669359375*^9, 3.4609664560625*^9, 
  3.485494328234027*^9, 3.4857513362514067`*^9, 3.485752227958829*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-phe-omph barometer}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"grtwmcpx\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnK = 5.6654\"\>", 
        ",", "\<\"GB11Calibration = Waters & Martin (1996): ordered P2/n omph\
\"\>"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"500.`", ",", "30331.07`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600.`", ",", "29368.081`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"700.`", ",", "28707.856`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800.`", ",", "28468.69`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.422776669359375*^9, 3.4609664560625*^9, 
  3.485494328234027*^9, 3.4857513362514067`*^9, 3.485752227974454*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "8"}], ":", " ", "continued"}], "  ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"CalcThermoBaro", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"gb12", ",", 
        RowBox[{"{", 
         RowBox[{"500", ",", "800", ",", "100"}], "}"}]}], "}"}], "}"}], ",", 
     "\"\<gtb\>\"", ",", "\"\<test\>\""}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"CalcThermoBaro", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"gb13", ",", 
        RowBox[{"{", 
         RowBox[{"500", ",", "800", ",", "100"}], "}"}]}], "}"}], "}"}], ",", 
     "\"\<gtb\>\"", ",", "\"\<test\>\""}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"CalcThermoBaro", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"gb14", ",", 
        RowBox[{"{", 
         RowBox[{"500", ",", "800", ",", "100"}], "}"}]}], "}"}], "}"}], ",", 
     "\"\<gtb\>\"", ",", "\"\<test\>\""}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"CalcThermoBaro", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"gb15", ",", 
        RowBox[{"{", 
         RowBox[{"500", ",", "800", ",", "100"}], "}"}]}], "}"}], "}"}], ",", 
     "\"\<gtb\>\"", ",", "\"\<test\>\""}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"CalcThermoBaro", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"gb16", ",", 
        RowBox[{"{", 
         RowBox[{"500", ",", "800", ",", "100"}], "}"}]}], "}"}], "}"}], ",", 
     "\"\<gtb\>\"", ",", "\"\<test\>\""}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{amph-chl barometer}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = 0.394609\"\>", 
        ",", "\<\"GB12Calibration = Cho, M. (cited in Laird, 1988)\"\>"}], 
       "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"500.`", ",", "4643.398`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600.`", ",", "4643.398`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"700.`", ",", "4643.398`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800.`", ",", "4643.398`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.42277667596875*^9, 3.4609664578125*^9, 
  3.4854943318901606`*^9, 3.485751336282658*^9, 3.485752227990079*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{Al-in-hornblende barometer}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = {}\"\>", 
        ",", "\<\"GB13Calibration = Anderson & Smith (1995)\"\>"}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"500.`", ",", "6453.896`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600.`", ",", "6799.176`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"700.`", ",", "5898.808`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800.`", ",", "3752.793`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.42277667596875*^9, 3.4609664578125*^9, 
  3.4854943318901606`*^9, 3.485751336282658*^9, 3.485752227990079*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{Al-in-opx barometer}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnKD = 3.96187\"\>", 
        ",", "\<\"GB14Calibration = Brey & K\[ODoubleDot]hler (1990)\"\>"}], 
       "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"500.`", ",", "11349.255`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600.`", ",", "16136.927`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"700.`", ",", "21163.482`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800.`", ",", "26414.987`"}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.42277667596875*^9, 3.4609664578125*^9, 
  3.4854943318901606`*^9, 3.485751336282658*^9, 3.4857522280057044`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-opx-plag-qz barometer}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnK = -4.83697\"\>", 
        ",", "\<\"GB15Calibration = Lal (1993), Mg-reaction (C)\"\>"}], 
       "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"500.`", ",", "1251.016`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600.`", ",", "501.927`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"700.`", ",", 
        RowBox[{"-", "247.163`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800.`", ",", 
        RowBox[{"-", "996.253`"}]}], "}"}]}], "}"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.42277667596875*^9, 3.4609664578125*^9, 
  3.4854943318901606`*^9, 3.485751336282658*^9, 3.4857522280057044`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"{grt-cpx-plag-qz barometer}\"\>", ",", 
    RowBox[{"{", 
     RowBox[{"\<\"gtb\"\>", ",", 
      RowBox[{"{", 
       RowBox[{"\<\"lnK = -6.82397\"\>", 
        ",", "\<\"GB16Calibration = Eckert et al. (1991), Mg-reaction \
(B)\"\>"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"500.`", ",", 
        RowBox[{"-", "4023.693`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"600.`", ",", 
        RowBox[{"-", "4449.08`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"700.`", ",", 
        RowBox[{"-", "4874.468`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"800.`", ",", 
        RowBox[{"-", "5299.855`"}]}], "}"}]}], "}"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.42277667596875*^9, 3.4609664578125*^9, 
  3.4854943318901606`*^9, 3.485751336282658*^9, 3.4857522280057044`*^9}]
}, Open  ]]
},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 2119, 53, 252, "Input"],
Cell[CellGroupData[{
Cell[2689, 77, 375, 10, 52, "Input"],
Cell[3067, 89, 6532, 87, 2216, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9636, 181, 435, 12, 52, "Input"],
Cell[10074, 195, 3503, 46, 1057, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13614, 246, 1647, 40, 152, "Input"],
Cell[15264, 288, 441, 9, 23, "Print"],
Cell[15708, 299, 1250, 34, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16995, 338, 1721, 44, 132, "Input"],
Cell[18719, 384, 1258, 34, 69, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20014, 423, 2251, 55, 212, "Input"],
Cell[22268, 480, 438, 9, 23, "Print"],
Cell[22709, 491, 2205, 59, 107, "Output"],
Cell[24917, 552, 326, 7, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25280, 564, 1525, 36, 212, "Input"],
Cell[CellGroupData[{
Cell[26830, 604, 209, 2, 23, "Print"],
Cell[27042, 608, 357, 9, 23, "Print"],
Cell[27402, 619, 207, 2, 23, "Print"],
Cell[27612, 623, 380, 10, 23, "Print"]
}, Open  ]],
Cell[28007, 636, 2895, 77, 126, "Output"],
Cell[30905, 715, 1156, 24, 250, "Output"],
Cell[32064, 741, 329, 7, 30, "Output"],
Cell[32396, 750, 1868, 36, 250, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34301, 791, 1418, 37, 112, "Input"],
Cell[CellGroupData[{
Cell[35744, 832, 464, 10, 23, "Print"],
Cell[36211, 844, 677, 19, 23, "Print"],
Cell[36891, 865, 675, 19, 23, "Print"],
Cell[37569, 886, 679, 19, 23, "Print"],
Cell[38251, 907, 681, 19, 23, "Print"],
Cell[38935, 928, 661, 18, 23, "Print"],
Cell[39599, 948, 680, 19, 23, "Print"],
Cell[40282, 969, 661, 18, 23, "Print"],
Cell[40946, 989, 679, 19, 23, "Print"],
Cell[41628, 1010, 698, 19, 43, "Print"],
Cell[42329, 1031, 695, 19, 43, "Print"],
Cell[43027, 1052, 683, 19, 23, "Print"],
Cell[43713, 1073, 687, 19, 43, "Print"],
Cell[44403, 1094, 681, 19, 23, "Print"],
Cell[45087, 1115, 674, 19, 23, "Print"],
Cell[45764, 1136, 685, 19, 23, "Print"],
Cell[46452, 1157, 681, 19, 23, "Print"],
Cell[47136, 1178, 680, 19, 23, "Print"],
Cell[47819, 1199, 687, 19, 23, "Print"],
Cell[48509, 1220, 680, 19, 23, "Print"],
Cell[49192, 1241, 682, 19, 23, "Print"],
Cell[49877, 1262, 680, 19, 23, "Print"],
Cell[50560, 1283, 683, 19, 23, "Print"],
Cell[51246, 1304, 698, 19, 43, "Print"],
Cell[51947, 1325, 696, 19, 43, "Print"],
Cell[52646, 1346, 693, 19, 43, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53388, 1371, 1095, 29, 92, "Input"],
Cell[CellGroupData[{
Cell[54508, 1404, 821, 22, 43, "Print"],
Cell[55332, 1428, 821, 22, 43, "Print"],
Cell[56156, 1452, 817, 22, 43, "Print"],
Cell[56976, 1476, 818, 22, 43, "Print"],
Cell[57797, 1500, 828, 22, 43, "Print"],
Cell[58628, 1524, 835, 22, 43, "Print"],
Cell[59466, 1548, 812, 22, 43, "Print"],
Cell[60281, 1572, 829, 23, 43, "Print"],
Cell[61113, 1597, 839, 22, 43, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[62001, 1625, 1161, 34, 152, "Input"],
Cell[63165, 1661, 447, 9, 23, "Print"],
Cell[63615, 1672, 830, 22, 50, "Output"],
Cell[64448, 1696, 832, 22, 50, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65317, 1723, 1614, 46, 132, "Input"],
Cell[66934, 1771, 818, 22, 50, "Output"],
Cell[67755, 1795, 811, 22, 50, "Output"],
Cell[68569, 1819, 826, 22, 50, "Output"],
Cell[69398, 1843, 865, 23, 50, "Output"],
Cell[70266, 1868, 922, 26, 50, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
