(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    255023,       5285]
NotebookOptionsPosition[    252790,       5207]
NotebookOutlinePosition[    253134,       5222]
CellTagsIndexPosition[    253091,       5219]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "This", " ", "notebook", " ", "contains", " ", "examples", " ", "for", 
     " ", "the", " ", "PET"}], "-", "functions", "\[IndentingNewLine]", " ", 
    "-", "ExtractMinDat", "-", "        ", 
    RowBox[{"extract", " ", "mineral"}], "-", 
    RowBox[{"chemical", " ", "parameters"}], "\[IndentingNewLine]", " ", "-", 
    "DataSymbols", "-", "          ", 
    RowBox[{
    "chose", " ", "various", " ", "plot", " ", "symbols", " ", "for", " ", 
     "data", " ", "points", " ", "and", " ", "their", " ", "size"}], 
    "\[IndentingNewLine]", " ", "-", "TrianglePlot", "-", "         ", 
    RowBox[{"plot", " ", "mineral"}], "-", 
    RowBox[{
    "chemical", " ", "data", " ", "in", " ", "a", " ", "triangular", " ", 
     "diagram"}], "\[IndentingNewLine]", " ", "-", "XYPlot", "-", 
    "               ", 
    RowBox[{"create", " ", "a", " ", "xy"}], "-", 
    RowBox[{"plot", " ", "of", " ", "mineral"}], "-", 
    RowBox[{"chemical", " ", "data"}]}], "               ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"This", " ", "top"}], "-", 
    RowBox[{
    "cell", " ", "must", " ", "be", " ", "run", " ", "once", " ", "before", 
     " ", "any", " ", "example", " ", "can", " ", "be", " ", 
     RowBox[{"performed", "."}]}]}], "  ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Define", " ", "the", " ", "directory"}], ",", 
    RowBox[{
     RowBox[{"where", " ", "the", " ", "PET"}], "-", 
     RowBox[{"files", " ", "reside", " ", 
      RowBox[{"(", 
       RowBox[{"e", ".", "g", ".", " ", 
        RowBox[{"C", ":", 
         RowBox[{
          RowBox[{"\\", "Eigene"}], " ", 
          RowBox[{"Dateien", "\\", "Pet"}]}]}]}], ")"}], " ", "and", " ", 
      "load", " ", 
      RowBox[{"PET", "."}]}]}]}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{
    "$PetDirectory", "=", 
     "\"\<C:\\Dokumente und Einstellungen\\dachsedgar\\Eigene \
Dateien\\Pet\\Pet7.0\>\""}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"SetDirectory", "[", "$PetDirectory", "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"DeclarePackage", "[", 
     RowBox[{"\"\<DEFDAT`\>\"", ",", 
      RowBox[{"{", "\"\<Dataset\>\"", "}"}]}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Dataset", "[", 
     RowBox[{"Dataset", "->", " ", "B88"}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.422778293546875*^9, {3.460967477140625*^9, 3.460967479375*^9}, {
   3.485581497220562*^9, 3.4855815017049084`*^9}, {3.485675271694747*^9, 
   3.485675271929122*^9}, {3.485752266818453*^9, 3.4857522672872057`*^9}, {
   3.4857566846087484`*^9, 3.4857566857181377`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "1"}], ":", " ", 
    RowBox[{
     RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
     "ExtractMinDat", "-", " ", 
     RowBox[{"to", " ", "extract", " ", "Al", 
      RowBox[{"(", "VI", ")"}], " ", "for", " ", "white", " ", "mica", " ", 
      "from", " ", "the", " ", "data", " ", "file", "  ", 
      "\"\<hs78b\>\""}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"dat", "=", 
   RowBox[{"ExtractMinDat", "[", 
    RowBox[{"wm", ",", "\"\<Al(VI)\>\"", ",", "\"\<hs78b\>\""}], 
    "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "1.89589`", "}"}], "}"}]], "Output",
 CellChangeTimes->{3.42277830240625*^9, 3.46096673915625*^9, 
  3.460967498609375*^9, 3.4854947260936527`*^9, 3.485514469596735*^9, 
  3.485581511673791*^9, 3.4855816243343673`*^9, 3.485590856317862*^9, 
  3.485591313533928*^9, 3.4855917533285217`*^9, 3.485675278288497*^9, 
  3.485689284806107*^9, 3.485747258410309*^9, 3.4857482332017784`*^9, 
  3.485751203199423*^9, 3.485752279631035*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "2"}], ":", " ", 
    RowBox[{
     RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
     "ExtractMinDat", "-", " ", 
     RowBox[{"to", " ", "extract", " ", "Al", 
      RowBox[{"(", "IV", ")"}], " ", "and", " ", "Al", 
      RowBox[{"(", "VI", ")"}], " ", "for", " ", "white", " ", "mica", " ", 
      "from", " ", "the", " ", "data", " ", "files", "  ", "\"\<hs78b\>\"", 
      " ", "and", " ", "\"\<pet1\>\"", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
         "containing", " ", "an", " ", "identical", " ", "analsis", " ", "of",
           " ", "wm"}], ",", " ", 
         RowBox[{
         "therefore", " ", "two", " ", "identical", " ", "valus", " ", "are", 
          " ", "extracted", " ", "and", " ", "plotted", " ", "as", " ", "one",
           " ", "point"}]}], ")"}], ".", "\[IndentingNewLine]", "Use"}], " ", 
      "the", " ", "Mathematica"}], "-", "function", " ", "-", "ListPlot", "-",
      " ", 
     RowBox[{"to", " ", "plot", " ", "the", " ", 
      RowBox[{"data", "."}]}]}]}], "   ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"CalcFormula", "[", 
     RowBox[{"\"\<hs78b\>\"", ",", 
      RowBox[{"CalcFormulaMode", "\[Rule]", 
       RowBox[{"{", "}"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CalcFormula", "[", 
     RowBox[{"\"\<pet1\>\"", ",", 
      RowBox[{"CalcFormulaMode", "\[Rule]", 
       RowBox[{"{", "}"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"dat", "=", 
    RowBox[{"ExtractMinDat", "[", 
     RowBox[{"wm", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Al(IV)\>\"", ",", "\"\<Al(VI)\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<hs78b\>\"", ",", "\"\<pet1\>\""}], "}"}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", "dat", "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}]}], "]"}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"hs78b.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "hs78b.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.42277830696875*^9, 3.46096674090625*^9, 
  3.460967500203125*^9, 3.485494728015602*^9, 3.4854947835021076`*^9, 
  3.4855144713468137`*^9, 3.485581516017708*^9, 3.485689288102982*^9, 
  3.4857472596041813`*^9, 3.485751203261925*^9, 3.48575227967791*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"pet1.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "pet1.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.42277830696875*^9, 3.46096674090625*^9, 
  3.460967500203125*^9, 3.485494728015602*^9, 3.4854947835021076`*^9, 
  3.4855144713468137`*^9, 3.485581516017708*^9, 3.485689288102982*^9, 
  3.4857472596041813`*^9, 3.485751203261925*^9, 3.485752279724785*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.87958`", ",", "0.87958`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.89589`", ",", "1.89589`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.422778307046875*^9, 3.460966740953125*^9, 
  3.46096750025*^9, 3.485494728078104*^9, 3.4854947835489845`*^9, 
  3.485514471409316*^9, 3.4855815161114616`*^9, 3.485689288181107*^9, 
  3.4857472596761007`*^9, 3.4857512033088017`*^9, 3.4857522797404103`*^9}],

Cell[BoxData[
 GraphicsBox[
  {Hue[0.67, 0.6, 0.6], PointBox[{{0.87958, 1.89589}, {0.87958, 1.89589}}]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0, 1}, {1, 2}},
  PlotRangeClipping->True]], "Output",
 CellChangeTimes->{3.422778307046875*^9, 3.460966740953125*^9, 
  3.46096750025*^9, 3.485494728078104*^9, 3.4854947835489845`*^9, 
  3.485514471409316*^9, 3.4855815161114616`*^9, 3.485689288181107*^9, 
  3.4857472596761007`*^9, 3.4857512033088017`*^9, 3.485752279756036*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "3"}], ":", " ", 
    RowBox[{
     RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
     "ExtractMinDat", "-", " ", 
     RowBox[{
     "to", " ", "extract", " ", "XFe", " ", "for", " ", "garnet", " ", "from",
       " ", "the", " ", "data", " ", "file", "\[IndentingNewLine]", 
      "\"\<pet1\>\"", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"containing", " ", "two", " ", "grt"}], "-", 
          RowBox[{
          "analyses", " ", "with", " ", "the", " ", "labels", " ", 
           "\"\<3c\>\"", " ", "and", " ", "\"\<4r\>\""}]}], ",", " ", 
         RowBox[{
         "where", " ", "c", " ", "and", " ", "r", " ", "at", " ", "the", " ", 
          "end", " ", "indicate", " ", "core", " ", "and", " ", "rim"}]}], 
        ")"}], ".", "\[IndentingNewLine]", "Use"}], " ", "the", " ", "option",
       " ", "ExtractMinDatTexture", " ", "to", " ", "extract", " ", "only", 
      " ", "the", " ", "rim", " ", 
      RowBox[{"composition", "."}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"dat", " ", "=", " ", 
   RowBox[{"ExtractMinDat", "[", 
    RowBox[{"grt", ",", "\"\<XFe\>\"", ",", "\"\<pet1\>\"", ",", 
     RowBox[{"ExtractMinDatTexture", "\[Rule]", "\"\<r\>\""}], ",", " ", 
     RowBox[{"ExtractMinDatTextureRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "0.66343`", "}"}], "}"}]], "Output",
 CellChangeTimes->{3.422778313578125*^9, 3.460966743078125*^9, 
  3.460967502609375*^9, 3.4854947337033205`*^9, 3.485494817581541*^9, 
  3.485514493972827*^9, 3.485689294399857*^9, 3.485751203340053*^9, 
  3.485752279771661*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "4"}], ":", " ", 
    RowBox[{
     RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
     "ExtractMinDat", "-", " ", 
     RowBox[{
     "to", " ", "extract", " ", "SiO2", " ", "for", " ", "amphibole", " ", 
      "from", " ", "the", " ", "data", " ", "files", "\[IndentingNewLine]", 
      "\"\<pet1\>\"", " ", "and", " ", "\"\<pet2\>\"", " ", "for", " ", 
      "those", " ", "analyses", " ", "whose", " ", "label", " ", "ends", " ", 
      "with", " ", "\"\<mar\>\"", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"for", " ", "matrix"}], "-", "rim"}], ")"}]}]}]}], " ", 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"CalcFormula", "[", 
     RowBox[{"\"\<pet2\>\"", ",", 
      RowBox[{"CalcFormulaMode", "\[Rule]", 
       RowBox[{"{", "}"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"file", "=", 
     RowBox[{"{", 
      RowBox[{"\"\<pet1\>\"", ",", "\"\<pet2\>\""}], "}"}]}], ";"}], "\n", 
   RowBox[{"ExtractMinDat", "[", 
    RowBox[{"amph", ",", "\"\<SiO2\>\"", ",", "file", ",", " ", 
     RowBox[{"ExtractMinDatTexture", "\[Rule]", "\"\<mar\>\""}], ",", 
     "\[IndentingNewLine]", "\t\t\t\t\t\t\t\t ", 
     RowBox[{"ExtractMinDatTextureRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", 
        RowBox[{"-", "1"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
     "\t\t\t\t\t\t\t\t", 
     RowBox[{"ExtractMinDatFile", "\[Rule]", "\"\<NewFile\>\""}], ",", 
     "\[IndentingNewLine]", "\t\t\t\t\t\t\t\t", 
     RowBox[{"ExtractMinDatMode", "\[Rule]", "SearchFiles"}]}], "]"}], 
   "\n"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -CalcFormula-: creating file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"pet2.fu\"\>", 
   "\[InvisibleSpace]", "\<\"\\\".\"\>"}],
  SequenceForm[
  "Message from -CalcFormula-: creating file \"", "pet2.fu", "\"."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422778317234375*^9, 3.460966746109375*^9, 
  3.46096750528125*^9, 3.485494745875663*^9, 3.4854948256912274`*^9, 
  3.4855145044107947`*^9, 3.485689302149857*^9, 3.4857512044182196`*^9, 
  3.485752280756042*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -ExtractMinDat-: The file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"NewFile_amph_mar\"\>", 
   "\[InvisibleSpace]", "\<\"\\\" has been created.\"\>"}],
  SequenceForm[
  "Message from -ExtractMinDat-: The file \"", "NewFile_amph_mar", 
   "\" has been created."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422778317234375*^9, 3.460966746109375*^9, 
  3.46096750528125*^9, 3.485494745875663*^9, 3.4854948256912274`*^9, 
  3.4855145044107947`*^9, 3.485689302149857*^9, 3.4857512044182196`*^9, 
  3.485752280771667*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "5"}], ":", " ", 
     RowBox[{
      RowBox[{"use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
      "ExtractMinDat", "-", " ", 
      RowBox[{
      "to", " ", "combine", " ", "all", " ", "analyses", " ", "from", " ", 
       "the", " ", "data", " ", "files", "\[IndentingNewLine]", 
       "\"\<hs78b\>\""}]}]}], ",", 
    RowBox[{
    "\"\<pet1\>\"", " ", "and", " ", "\"\<pet2\>\"", " ", "in", " ", "one", 
     " ", "file", " ", "named", " ", "\"\<NewFile\>\""}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"file", "=", 
     RowBox[{"{", 
      RowBox[{"\"\<hs78b\>\"", ",", "\"\<pet1\>\"", ",", "\"\<pet2\>\""}], 
      "}"}]}], ";"}], "\n", 
   RowBox[{"ExtractMinDat", "[", 
    RowBox[{"all", ",", "\"\<SiO2\>\"", ",", "file", ",", 
     RowBox[{"ExtractMinDatFile", "\[Rule]", "\"\<NewFile\>\""}], ",", 
     "\[IndentingNewLine]", "\t\t\t\t\t\t\t\t", 
     RowBox[{"ExtractMinDatMode", "\[Rule]", "SearchFiles"}]}], 
    "]"}]}]}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Message from -ExtractMinDat-: The file \\\"\"\>", 
   "\[InvisibleSpace]", "\<\"NewFile_all\"\>", 
   "\[InvisibleSpace]", "\<\"\\\" has been created.\"\>"}],
  SequenceForm[
  "Message from -ExtractMinDat-: The file \"", "NewFile_all", 
   "\" has been created."],
  Editable->False]], "Print",
 CellChangeTimes->{3.422778319453125*^9, 3.460966752515625*^9, 3.460967507*^9,
   3.4854949244278536`*^9, 3.4855145190051985`*^9, 3.485689305649857*^9, 
  3.485689345431107*^9, 3.4857512046057267`*^9, 3.4857522809122925`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "7"}], ":", " ", 
    RowBox[{
     RowBox[{"Use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
     "TrianglePlot", "-", " ", 
     RowBox[{
     "to", " ", "plot", " ", "some", " ", "data", " ", "into", " ", "the", 
      " ", "concentration", " ", "triangle", " ", "A"}], "-", "B", "-", 
     "C"}]}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"data", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"100", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"50", ",", "50", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "3"}], ",", 
         RowBox[{"1", "/", "3"}], ",", 
         RowBox[{"1", "/", "3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"30", ",", "50", ",", "20"}], "}"}]}], "}"}]}], ";"}], "\n", 
   RowBox[{"t1", "=", 
    RowBox[{"TrianglePlot", "[", 
     RowBox[{"data", ",", 
      RowBox[{"TrianglePlotSymbolShape", "\[Rule]", "SymbolShapeDot"}], ",", 
      " ", 
      RowBox[{"TrianglePlotSymbolSize", "\[Rule]", "0.02"}], ",", " ", 
      RowBox[{"TrianglePlotGrid", "\[Rule]", "TrianglePlotGridMesh"}], ",", 
      RowBox[{"TrianglePlotAxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\""}], "}"}]}]}], 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.422778388375*^9, 3.422778401578125*^9}, {
  3.485689396181107*^9, 3.485689396681107*^9}}],

Cell[BoxData[
 GraphicsBox[{{
    {Thickness[0.006], 
     LineBox[{{0, 0}, {115.47005383792516`, 0}, {57.73502691896258, 100}, {0, 
       0}}]}, {
     {Thickness[0.004], 
      LineBox[{{5.773502691896258, 10}, {109.69655114602891`, 10}}]}, 
     {Thickness[0.004], 
      LineBox[{{11.547005383792516`, 20}, {103.92304845413264`, 20}}]}, 
     {Thickness[0.004], 
      LineBox[{{17.320508075688775`, 30}, {98.1495457622364, 30}}]}, 
     {Thickness[0.004], 
      LineBox[{{23.094010767585033`, 40}, {92.37604307034013, 40}}]}, 
     {Thickness[0.004], 
      LineBox[{{28.86751345948129, 50}, {86.60254037844388, 50}}]}, 
     {Thickness[0.004], 
      LineBox[{{34.64101615137755, 60}, {80.82903768654762, 60}}]}, 
     {Thickness[0.004], 
      LineBox[{{40.41451884327381, 70}, {75.05553499465137, 70}}]}, 
     {Thickness[0.004], 
      LineBox[{{46.188021535170066`, 80}, {69.2820323027551, 80}}]}, 
     {Thickness[0.004], 
      LineBox[{{51.96152422706633, 90}, {63.508529610858844`, 90}}]}, 
     {Thickness[0.004], 
      LineBox[{{11.547005383792516`, 0}, {63.508529610858844`, 90}}]}, 
     {Thickness[0.004], 
      LineBox[{{23.094010767585033`, 0}, {69.2820323027551, 80}}]}, 
     {Thickness[0.004], 
      LineBox[{{34.64101615137755, 0}, {75.05553499465137, 70}}]}, 
     {Thickness[0.004], 
      LineBox[{{46.188021535170066`, 0}, {80.82903768654762, 60}}]}, 
     {Thickness[0.004], 
      LineBox[{{57.73502691896258, 0}, {86.60254037844388, 50}}]}, 
     {Thickness[0.004], 
      LineBox[{{69.2820323027551, 0}, {92.37604307034013, 40}}]}, 
     {Thickness[0.004], 
      LineBox[{{80.82903768654762, 0}, {98.1495457622364, 30}}]}, 
     {Thickness[0.004], 
      LineBox[{{92.37604307034013, 0}, {103.92304845413264`, 20}}]}, 
     {Thickness[0.004], 
      LineBox[{{103.92304845413265`, 0}, {109.69655114602891`, 10}}]}, 
     {Thickness[0.004], 
      LineBox[{{103.92304845413265`, 0}, {51.96152422706633, 90}}]}, 
     {Thickness[0.004], 
      LineBox[{{92.37604307034013, 0}, {46.188021535170066`, 80}}]}, 
     {Thickness[0.004], 
      LineBox[{{80.82903768654762, 0}, {40.41451884327381, 70}}]}, 
     {Thickness[0.004], 
      LineBox[{{69.2820323027551, 0}, {34.64101615137755, 60}}]}, 
     {Thickness[0.004], 
      LineBox[{{57.73502691896258, 0}, {28.86751345948129, 50}}]}, 
     {Thickness[0.004], 
      LineBox[{{46.188021535170066`, 0}, {23.094010767585033`, 40}}]}, 
     {Thickness[0.004], 
      LineBox[{{34.64101615137755, 0}, {17.320508075688775`, 30}}]}, 
     {Thickness[0.004], 
      LineBox[{{23.094010767585033`, 0}, {11.547005383792516`, 20}}]}, 
     {Thickness[0.004], 
      LineBox[{{11.547005383792516`, 0}, {5.773502691896258, 10}}]}}}, {
    {PointSize[0.042426406871192854`], PointBox[{0, 0}]}, 
    {PointSize[0.042426406871192854`], PointBox[{57.73502691896258, 0}]}, 
    {PointSize[0.042426406871192854`], 
     PointBox[NCache[{57.73502691896259, Rational[100, 3]}, {
       57.73502691896259, 33.333333333333336`}]]}, 
    {PointSize[0.042426406871192854`], PointBox[{69.2820323027551, 20}]}}, {
    InsetBox["\<\"A\"\>", Scaled[{0, -0.03}], {0, 0}, Automatic, {1, 0}], 
    InsetBox["\<\"B\"\>", Scaled[{1, -0.03}], {0, 0}, Automatic, {1, 0}], 
    InsetBox["\<\"C\"\>", Scaled[{0.5, 1.02}], {0, 0}, Automatic, {1, 
     0}]}, {}},
  AspectRatio->0.89,
  PlotRange->All]], "Output",
 CellChangeTimes->{
  3.42277840225*^9, 3.4609667805625*^9, 3.460967520359375*^9, 
   3.48549504410126*^9, {3.485689376134232*^9, 3.485689396993607*^9}, 
   3.4857472664365807`*^9, 3.4857512046526036`*^9, 3.4857522809591684`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "8"}], ":", " ", 
     RowBox[{
      RowBox[{"Use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
      "TrianglePlot", "-", " ", 
      RowBox[{
      "to", " ", "plot", " ", "pyroxenes", " ", "from", " ", "file", " ", 
       "\"\<pet2\>\"", " ", "into", " ", "the", " ", "\[IndentingNewLine]", 
       "triangle", " ", "Jd"}], "-", "Ae", "-", 
      RowBox[{
       RowBox[{"Q", ".", " ", "\"\<pet2\>\""}], " ", "contains", " ", "20", 
       " ", "analyses", " ", "of", " ", "zoned", " ", "omphacites"}]}]}], ",", 
    RowBox[{
    "10", " ", "with", " ", "analyses", " ", "labels", "\n", "ending", " ", 
     "in", " ", "\"\<mar\>\"", " ", 
     RowBox[{"(", 
      RowBox[{
      "indicating", " ", "\"\<ma\>\"", "trix", " ", "\"\<r\>\"", "im", " ", 
       "compositions"}], ")"}]}], ",", 
    RowBox[{"10", " ", "ending", " ", "in", " ", "\"\<mac\>\"", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"indicating", " ", "\"\<ma\>\"", "trix", " ", "\"\<c\>\""}], 
        "-", 
        RowBox[{"ore", " ", "compositions"}]}], ")"}], ".", "\n", "Use"}], 
     " ", "triangles", " ", "and", " ", "dots", " ", "as", " ", "plot", " ", 
     "symbols"}], ",", 
    RowBox[{"draw", " ", "tick", " ", "marks"}], ",", 
    RowBox[{
     RowBox[{"use", " ", "the", "\\n", "\n", "Na"}], "-", 
     RowBox[{
     "pyroxene", " ", "nomenclature", " ", "grid", " ", "and", " ", "plot", 
      " ", "two", " ", "text"}], "-", 
     RowBox[{"labels", " ", "into", " ", "the", " ", "triangle"}]}]}], " ", 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "first", " ", "you", " ", "must", " ", "use", " ", "the", " ", "PET"}], 
    "-", "function", " ", "-", "ExtractMinDat", "-", " ", 
    RowBox[{
    "to", " ", "extract", " ", "the", " ", "data", " ", "with", " ", "the", 
     " ", "specific", " ", "textural", " ", "position"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"d1", "=", 
     RowBox[{"ExtractMinDat", "[", 
      RowBox[{"cpx", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<MolJd\>\"", ",", "\"\<MolAe\>\"", ",", "\"\<MolQ\>\""}], 
        "}"}], ",", "\"\<pet2\>\"", ",", 
       RowBox[{"ExtractMinDatTexture", "\[Rule]", "\"\<mar\>\""}], ",", 
       RowBox[{"ExtractMinDatTextureRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"d2", "=", 
     RowBox[{"ExtractMinDat", "[", 
      RowBox[{"cpx", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<MolJd\>\"", ",", "\"\<MolAe\>\"", ",", "\"\<MolQ\>\""}], 
        "}"}], ",", "\"\<pet2\>\"", ",", 
       RowBox[{"ExtractMinDatTexture", "\[Rule]", "\"\<mac\>\""}], ",", 
       RowBox[{"ExtractMinDatTextureRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t1", "=", 
     RowBox[{"TrianglePlot", "[", 
      RowBox[{
       RowBox[{"Transpose", "[", "d1", "]"}], ",", 
       RowBox[{"TrianglePlotSymbolShape", "\[Rule]", "SymbolShapeSquare"}], 
       ",", 
       RowBox[{"TrianglePlotSymbolSize", "\[Rule]", "0.02"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t2", "=", 
     RowBox[{"TrianglePlot", "[", 
      RowBox[{
       RowBox[{"Transpose", "[", "d2", "]"}], ",", 
       RowBox[{"TrianglePlotSymbolShape", "\[Rule]", "SymbolShapeDot"}], ",", 
       RowBox[{"TrianglePlotSymbolSize", "\[Rule]", "0.008"}], ",", 
       RowBox[{"TrianglePlotText", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Text", "[", 
           RowBox[{"\"\<text1\>\"", ",", 
            RowBox[{"Scaled", "[", 
             RowBox[{"{", 
              RowBox[{"0.67`", ",", "0.5`"}], "}"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{"\"\<text2\>\"", ",", 
            RowBox[{"Scaled", "[", 
             RowBox[{"{", 
              RowBox[{"0.4`", ",", "0.19`"}], "}"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}]}], "]"}]}], "}"}]}], ",", 
       RowBox[{"TrianglePlotTicks", "\[Rule]", "TrianglePlotTicksYes"}], ",", 
       RowBox[{"TrianglePlotGrid", "\[Rule]", "TrianglePlotGridPx"}], ",", 
       RowBox[{"TrianglePlotAxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Jd\>\"", ",", "\"\<Ae\>\"", ",", "\"\<Q\>\""}], 
         "}"}]}]}], "]"}]}], ";", 
    RowBox[{"Show", "[", 
     RowBox[{"t1", ",", "t2"}], "]"}]}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.485495078242322*^9, 3.485495078632952*^9}, {
  3.485689428915482*^9, 3.485689443071732*^9}, {3.485689509165482*^9, 
  3.485689615977982*^9}, {3.485749759662878*^9, 3.485749773162446*^9}}],

Cell[BoxData[
 GraphicsBox[{{
    {Thickness[0.006], 
     LineBox[{{0, 0}, {115.47005383792516`, 0}, {57.73502691896258, 100}, {0, 
       0}}]}, GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQrWdfut282M3h1rnvwY9bPRy6CplUUkNdHYIvvFXt
bXV1+P75UN1KRneHkw8EHjcdcXWoOfJHlKPX0+HiOqdT/mnODid8nu3kuuzm
ILD+tfibf84Onz/7T+e/5uZwv+W4/6KtLg47rOJcZWZ7Ojg2PTo+w9vDYfZO
L4/Q3x4O3hss5vwsdHbI7LmyfgKQf+vf1KlqC90crIRvrj7g4Omw3yPj9E4N
F4fB7j4AMeaa6A==
     "], {
      {Hue[0.67, 0.6, 0.6], InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 11, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 12, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 13, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 14, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 15, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 16, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 17, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 18, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 19, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 20, Automatic, 
        Scaled[{0.02, 0.02}]]}, {}}], {
     InsetBox["\<\"\"\>", Scaled[{0, -0.03}], {0, 0}, Automatic, {1, 0}], 
     InsetBox["\<\"\"\>", Scaled[{1, -0.03}], {0, 0}, Automatic, {1, 0}], 
     InsetBox["\<\"\"\>", Scaled[{0.5, 1.02}], {0, 0}, Automatic, {1, 
      0}]}, {}}, {{
     {Thickness[0.006], 
      LineBox[{{0, 0}, {115.47005383792516`, 0}, {57.73502691896258, 100}, {0,
         0}}]}, {
      {Thickness[0.006], 
       LineBox[{{5.773502691896258, 10}, {4.0414518843273814`, 11.}}]}, 
      {Thickness[0.006], 
       LineBox[{{11.547005383792516`, 20}, {9.81495457622364, 21.}}]}, 
      {Thickness[0.006], 
       LineBox[{{17.320508075688775`, 30}, {15.588457268119898`, 31.}}]}, 
      {Thickness[0.006], 
       LineBox[{{23.094010767585033`, 40}, {21.361959960016154`, 41.}}]}, 
      {Thickness[0.006], 
       LineBox[{{28.86751345948129, 50}, {27.135462651912412`, 51.}}]}, 
      {Thickness[0.006], 
       LineBox[{{34.64101615137755, 60}, {32.908965343808674`, 61.}}]}, 
      {Thickness[0.006], 
       LineBox[{{40.41451884327381, 70}, {38.682468035704936`, 71.}}]}, 
      {Thickness[0.006], 
       LineBox[{{46.188021535170066`, 80}, {44.45597072760119, 81.}}]}, 
      {Thickness[0.006], 
       LineBox[{{51.96152422706633, 90}, {50.22947341949745, 91.}}]}, 
      {Thickness[0.006], 
       LineBox[{{109.69655114602891`, 10}, {111.42860195359779`, 11.}}]}, 
      {Thickness[0.006], 
       LineBox[{{103.92304845413264`, 20}, {105.65509926170152`, 21.}}]}, 
      {Thickness[0.006], 
       LineBox[{{98.1495457622364, 30}, {99.88159656980528, 31.}}]}, 
      {Thickness[0.006], 
       LineBox[{{92.37604307034013, 40}, {94.10809387790901, 41.}}]}, 
      {Thickness[0.006], 
       LineBox[{{86.60254037844388, 50}, {88.33459118601276, 51.}}]}, 
      {Thickness[0.006], 
       LineBox[{{80.82903768654762, 60}, {82.5610884941165, 61.}}]}, 
      {Thickness[0.006], 
       LineBox[{{75.05553499465137, 70}, {76.78758580222025, 71.}}]}, 
      {Thickness[0.006], 
       LineBox[{{69.2820323027551, 80}, {71.01408311032398, 81.}}]}, 
      {Thickness[0.006], 
       LineBox[{{63.508529610858844`, 90}, {65.24058041842773, 91.}}]}, 
      {Thickness[0.006], 
       LineBox[{{11.547005383792516`, 0}, {11.547005383792516`, -2}}]}, 
      {Thickness[0.006], 
       LineBox[{{23.094010767585033`, 0}, {23.094010767585033`, -2}}]}, 
      {Thickness[0.006], 
       LineBox[{{34.64101615137755, 0}, {34.64101615137755, -2}}]}, 
      {Thickness[0.006], 
       LineBox[{{46.188021535170066`, 0}, {46.188021535170066`, -2}}]}, 
      {Thickness[0.006], 
       LineBox[{{57.73502691896258, 0}, {57.73502691896258, -2}}]}, 
      {Thickness[0.006], 
       LineBox[{{69.2820323027551, 0}, {69.2820323027551, -2}}]}, 
      {Thickness[0.006], 
       LineBox[{{80.82903768654762, 0}, {80.82903768654762, -2}}]}, 
      {Thickness[0.006], 
       LineBox[{{92.37604307034013, 0}, {92.37604307034013, -2}}]}, 
      {Thickness[0.006], 
       LineBox[{{103.92304845413265`, 0}, {103.92304845413265`, -2}}]}}, {
      {Thickness[0.004], 
       LineBox[{{5.773502691896258, 10}, {109.69655114602891`, 10}}]}, 
      {Thickness[0.004], 
       LineBox[{{11.547005383792516`, 20}, {103.92304845413264`, 20}}]}, 
      {Thickness[0.004], 
       LineBox[{{46.188021535170066`, 80}, {69.2820323027551, 80}}]}, 
      {Thickness[0.004], 
       LineBox[{{57.73502691896258, 0}, {57.73502691896258, 80}}]}, 
      {Thickness[0.004], 
       LineBox[{{11.547005383792516`, 0}, {48.49742261192857, 80}}]}, 
      {Thickness[0.004], 
       LineBox[{{103.92304845413265`, 0}, {66.9726312259966, 80}}]}}}, {
     {PointSize[0.016970562748477143`], 
      PointBox[{29.667446771193582`, 45.901344590134464`}]}, 
     {PointSize[0.016970562748477143`], 
      PointBox[{33.757433525907054`, 46.54415}]}, 
     {PointSize[0.016970562748477143`], 
      PointBox[{29.164632371474898`, 45.61992456199246}]}, 
     {PointSize[0.016970562748477143`], 
      PointBox[{31.195632231966925`, 46.66926}]}, 
     {PointSize[0.016970562748477143`], 
      PointBox[{36.22296528475635, 43.67539436753943}]}, 
     {PointSize[0.016970562748477143`], 
      PointBox[{33.27098705660134, 41.57048000000001}]}, 
     {PointSize[0.016970562748477143`], 
      PointBox[{33.115887680286235`, 47.19396}]}, 
     {PointSize[0.016970562748477143`], 
      PointBox[{31.834077706642198`, 42.34544000000001}]}, 
     {PointSize[0.016970562748477143`], 
      PointBox[{35.41043353461849, 45.47931}]}, 
     {PointSize[0.016970562748477143`], 
      PointBox[{29.170169161110106`, 45.17963451796346}]}}, {
     InsetBox["\<\"Jd\"\>", Scaled[{0, -0.03}], {0, 0}, Automatic, {1, 0}], 
     InsetBox["\<\"Ae\"\>", Scaled[{1, -0.03}], {0, 0}, Automatic, {1, 0}], 
     InsetBox["\<\"Q\"\>", Scaled[{0.5, 1.02}], {0, 0}, Automatic, {1, 0}]}, {
     InsetBox["\<\"text1\"\>", Scaled[{0.67, 0.5}], {1, 0}, Automatic, {1, 
      0}], InsetBox["\<\"text2\"\>", Scaled[{0.4, 0.19}], {1, 0}, Automatic, {
      1, 0}]}}},
  AspectRatio->0.89,
  PlotRange->All]], "Output",
 CellChangeTimes->{
  3.4854950807423544`*^9, 3.485689586868607*^9, 3.485749252302251*^9, 
   3.4857494744141626`*^9, {3.4857495277850633`*^9, 3.48574954208084*^9}, 
   3.485749790599388*^9, 3.4857512048713617`*^9, 3.485752281193545*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "9"}], ":", "  ", 
    RowBox[{"Triangle", "-", 
     RowBox[{"plot", " ", "for", " ", "garnets"}]}]}], "  ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xfe", ",", "xmg", ",", "xca", ",", "xmn"}], "}"}], "=", 
     RowBox[{"ExtractMinDat", "[", 
      RowBox[{"grt", ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<XFe\>\"", ",", "\"\<XMg\>\"", ",", "\"\<XCa\>\"", ",", 
         "\"\<XMn\>\""}], "}"}], ",", "\"\<pet2\>\""}], "]"}]}], ";"}], "\n", 
   RowBox[{"t1", "=", 
    RowBox[{"TrianglePlot", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{"xfe", ",", "xmg", ",", 
         RowBox[{"xca", "+", "xmn"}]}], "}"}], "]"}], ",", 
      RowBox[{"TrianglePlotSymbolShape", "\[Rule]", "SymbolShapeDot"}], ",", 
      " ", 
      RowBox[{"TrianglePlotSymbolSize", "\[Rule]", "0.01"}], ",", 
      RowBox[{"TrianglePlotText", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Text", "[", 
          RowBox[{"\"\<core\>\"", ",", 
           RowBox[{"Scaled", "[", 
            RowBox[{"{", 
             RowBox[{"0.4", ",", "0.55"}], "}"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", " ", 
         RowBox[{"Text", "[", 
          RowBox[{"\"\<rim\>\"", ",", 
           RowBox[{"Scaled", "[", 
            RowBox[{"{", 
             RowBox[{"0.3", ",", "0.21"}], "}"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}]}], "]"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"TrianglePlotTicks", "\[Rule]", "TrianglePlotTicksYes"}], ",", 
      RowBox[{"TrianglePlotAxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<XFe\>\"", ",", "\"\<XMg\>\"", ",", " ", "\"\<XCa+XMn\>\""}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.4857495805935073`*^9, 3.485749682509097*^9}, {
  3.4857498028958693`*^9, 3.485749813020545*^9}}],

Cell[BoxData[
 GraphicsBox[{{
    {Thickness[0.006], 
     LineBox[{{0, 0}, {115.47005383792516`, 0}, {57.73502691896258, 100}, {0, 
       0}}]}, {
     {Thickness[0.006], 
      LineBox[{{5.773502691896258, 10}, {4.0414518843273814`, 11.}}]}, 
     {Thickness[0.006], 
      LineBox[{{11.547005383792516`, 20}, {9.81495457622364, 21.}}]}, 
     {Thickness[0.006], 
      LineBox[{{17.320508075688775`, 30}, {15.588457268119898`, 31.}}]}, 
     {Thickness[0.006], 
      LineBox[{{23.094010767585033`, 40}, {21.361959960016154`, 41.}}]}, 
     {Thickness[0.006], 
      LineBox[{{28.86751345948129, 50}, {27.135462651912412`, 51.}}]}, 
     {Thickness[0.006], 
      LineBox[{{34.64101615137755, 60}, {32.908965343808674`, 61.}}]}, 
     {Thickness[0.006], 
      LineBox[{{40.41451884327381, 70}, {38.682468035704936`, 71.}}]}, 
     {Thickness[0.006], 
      LineBox[{{46.188021535170066`, 80}, {44.45597072760119, 81.}}]}, 
     {Thickness[0.006], 
      LineBox[{{51.96152422706633, 90}, {50.22947341949745, 91.}}]}, 
     {Thickness[0.006], 
      LineBox[{{109.69655114602891`, 10}, {111.42860195359779`, 11.}}]}, 
     {Thickness[0.006], 
      LineBox[{{103.92304845413264`, 20}, {105.65509926170152`, 21.}}]}, 
     {Thickness[0.006], 
      LineBox[{{98.1495457622364, 30}, {99.88159656980528, 31.}}]}, 
     {Thickness[0.006], 
      LineBox[{{92.37604307034013, 40}, {94.10809387790901, 41.}}]}, 
     {Thickness[0.006], 
      LineBox[{{86.60254037844388, 50}, {88.33459118601276, 51.}}]}, 
     {Thickness[0.006], 
      LineBox[{{80.82903768654762, 60}, {82.5610884941165, 61.}}]}, 
     {Thickness[0.006], 
      LineBox[{{75.05553499465137, 70}, {76.78758580222025, 71.}}]}, 
     {Thickness[0.006], 
      LineBox[{{69.2820323027551, 80}, {71.01408311032398, 81.}}]}, 
     {Thickness[0.006], 
      LineBox[{{63.508529610858844`, 90}, {65.24058041842773, 91.}}]}, 
     {Thickness[0.006], 
      LineBox[{{11.547005383792516`, 0}, {11.547005383792516`, -2}}]}, 
     {Thickness[0.006], 
      LineBox[{{23.094010767585033`, 0}, {23.094010767585033`, -2}}]}, 
     {Thickness[0.006], 
      LineBox[{{34.64101615137755, 0}, {34.64101615137755, -2}}]}, 
     {Thickness[0.006], 
      LineBox[{{46.188021535170066`, 0}, {46.188021535170066`, -2}}]}, 
     {Thickness[0.006], 
      LineBox[{{57.73502691896258, 0}, {57.73502691896258, -2}}]}, 
     {Thickness[0.006], 
      LineBox[{{69.2820323027551, 0}, {69.2820323027551, -2}}]}, 
     {Thickness[0.006], 
      LineBox[{{80.82903768654762, 0}, {80.82903768654762, -2}}]}, 
     {Thickness[0.006], 
      LineBox[{{92.37604307034013, 0}, {92.37604307034013, -2}}]}, 
     {Thickness[0.006], 
      LineBox[{{103.92304845413265`, 0}, {103.92304845413265`, -2}}]}}}, {
    {PointSize[0.021213203435596427`], 
     PointBox[{28.152753826224536`, 25.259999999999998`}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{27.195507079908133`, 24.15}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{27.314745438176004`, 25.776742232577675`}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{26.890088787506826`, 25.995}]}, 
    {PointSize[0.021213203435596427`], PointBox[{26.66492218252287, 27.425}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{26.077179608487832`, 27.615000000000002`}]}, 
    {PointSize[0.021213203435596427`], PointBox[{25.22096915927962, 27.736}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{24.810473117885792`, 28.407}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{24.51165079495351, 27.649276492764926`}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{24.58852472926968, 28.42471575284247}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{24.17423312123882, 27.860999999999997`}]}, 
    {PointSize[0.021213203435596427`], PointBox[{24.69096161216354, 28.526}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{23.93901217155693, 26.397736022639773`}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{24.72815931098478, 28.306283062830623`}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{26.561576484337927`, 33.455999999999996`}]}, 
    {PointSize[0.021213203435596427`], PointBox[{34.47416192358175, 52.339}]}, 
    {PointSize[0.021213203435596427`], PointBox[{34.16181542795016, 51.146}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{34.5769302714975, 52.495000000000005`}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{33.77499074759311, 51.13799999999999}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{34.07521288757172, 50.87200000000001}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{33.70431370761985, 50.74750747507474}]}, 
    {PointSize[0.021213203435596427`], PointBox[{34.02267401307546, 49.259}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{32.441888976034264`, 47.150999999999996`}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{33.14370099010956, 50.25050250502504}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{32.83795126069835, 49.446999999999996`}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{33.137596050407765`, 49.71}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{33.22914968443657, 50.260502605026055`}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{33.16069006117535, 49.858000000000004`}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{33.71321426878983, 51.007000000000005`}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{34.10085264115884, 51.40648593514065}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{33.37810754346608, 50.79650796507965}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{34.36215597135896, 52.16499999999999}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{33.70306228359076, 49.69950300496995}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{34.43143800366172, 51.605000000000004`}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{34.7218451890641, 52.77799999999999}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{34.79228192190523, 52.70399999999999}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{34.914331035663075`, 52.737472625273746`}]}, 
    {PointSize[0.021213203435596427`], PointBox[{34.78997252082847, 52.696}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{35.581519739887455`, 54.205000000000005`}]}, 
    {PointSize[0.021213203435596427`], PointBox[{34.28479103528755, 51.535}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{33.231459108607574`, 49.114491144911455`}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{33.585042509029726`, 50.361}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{28.358867872325234`, 40.335}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{25.91578069092164, 35.36535365353653}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{25.36851714302073, 34.42765572344276}]}, 
    {PointSize[0.021213203435596427`], PointBox[{25.26253837866127, 33.456}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{24.838763281076083`, 30.908}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{24.388430071108175`, 29.799999999999997`}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{24.744325280181787`, 29.514295142951433`}]}, 
    {PointSize[0.021213203435596427`], PointBox[{24.76255304554305, 29.066}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{24.3499911029835, 28.919289192891927`}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{24.648815042512695`, 29.057}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{24.907218890920742`, 28.960710392896075`}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{25.54807128119732, 26.88073119268807}]}, 
    {PointSize[0.021213203435596427`], 
     PointBox[{26.622775612872026`, 27.106}]}}, {
    InsetBox["\<\"XFe\"\>", Scaled[{0, -0.03}], {0, 0}, Automatic, {1, 0}], 
    InsetBox["\<\"XMg\"\>", Scaled[{1, -0.03}], {0, 0}, Automatic, {1, 0}], 
    InsetBox["\<\"XCa+XMn\"\>", Scaled[{0.5, 1.02}], {0, 0}, Automatic, {1, 
     0}]}, {InsetBox["\<\"core\"\>", Scaled[{0.4, 0.55}], {1, 0}, Automatic, {
     1, 0}], InsetBox["\<\"rim\"\>", Scaled[{0.3, 0.21}], {1, 0}, Automatic, {
     1, 0}]}},
  AspectRatio->0.89,
  PlotRange->All]], "Output",
 CellChangeTimes->{{3.4857496616660137`*^9, 3.4857496833684444`*^9}, 
   3.4857498245514264`*^9, 3.485751205136997*^9, 3.4857522814747963`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "10"}], ":", " ", 
    RowBox[{
     RowBox[{"Use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
     "XYPlot", "-", " ", 
     RowBox[{"to", " ", "plot", " ", "mineral"}], "-", 
     RowBox[{"chemical", " ", "data"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Example", " ", "10", 
    RowBox[{"a", ":", " ", 
     RowBox[{
      RowBox[{
      "calling", " ", "XYPlot", " ", "just", " ", "specifying", " ", "a", " ",
        "file"}], "-", 
      RowBox[{"name", " ", "creates", " ", "a", " ", "xy"}], "-", 
      RowBox[{"plot", " ", "using", " ", "default", " ", "settings"}]}]}]}], 
   " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"XYPlot", "[", "\"\<pet2\>\"", "]"}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJwtzl0og3EUx/Hx4HIsPWVp3rIpS1KSsotpaam1ZYrkQikMT2kly1ttmRYX
pCbRSGrmJVfKSylrs6TJDZKsZ2ilTdRcrF3a+f+ei9On7zk3p3pwwjqUL5PJ
anNDmgKekpFsst0U6FTAywoYgXUGs2QXWe51vJAar5s5zCdF2BBnrkfzbExV
AUypmLyrEt1tRGfMaKUAnZD/nYP8PHmcKDwjzxOlTOdC+IvJ1aTQa/JRZhRy
Pzz8k1RX4d4CuYNetLUf3WhDG8fR+im0AXJ9HrSLKe7NbpOt/q0d8jl2EyQz
ojlMaoSiR7JZKGNupqflY8zDYqbd0YEOSmoHsG+D6YcZ9CdM633oE8nVXeyv
JS0h6IP2t1uYlXTEYYzZFDnlBfovcsHc0L+ql3L2TCrqSYvyw02K2pVF0vkU
95P3d/J9MqR71y3nPLr6Zv4D/oZFUw==
  "]],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJztVvtbFOcV3iDihUgoFfY6M7tGkEoBiaGCKEezIHKxVkzQEJ8WBdQCiooC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    "], {
     {Hue[0.67, 0.6, 0.6], InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 144, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 145, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 146, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 147, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 148, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 149, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 150, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 151, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 152, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 153, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 154, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 155, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 156, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 157, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 158, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 159, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 160, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 161, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 162, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 163, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 164, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 165, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 166, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 167, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 168, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 169, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 170, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 171, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 172, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 173, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 174, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 175, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 176, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 177, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 178, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 179, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 180, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 181, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 182, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 183, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 184, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 185, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 186, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 187, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 188, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 189, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 190, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 191, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 192, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 193, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 194, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 195, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 196, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 197, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 198, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 199, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 200, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 201, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 202, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 203, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 204, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 205, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 206, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 207, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 208, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 209, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 210, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 211, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 212, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 213, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 214, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 215, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 216, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 217, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 218, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 219, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 220, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 221, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 222, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 223, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 224, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 225, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 226, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 227, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 228, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 229, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 230, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 231, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 232, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 233, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 234, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 235, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 236, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 237, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 238, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 239, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 240, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 241, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 242, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 243, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 244, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 245, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 246, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 247, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 248, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 249, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 250, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 251, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 252, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 253, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 254, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 255, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 256, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 257, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 258, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 259, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 260, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 261, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 262, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 263, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 264, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 265, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 266, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 267, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 268, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 269, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 270, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 271, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 272, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 273, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 274, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 275, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 276, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 277, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 278, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 279, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 280, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 281, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 282, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 283, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 284, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 285, Automatic, Scaled[{0.02, 0.02}]], 
      InsetBox[
       GraphicsBox[DiskBox[{0, 0}]], 286, Automatic, 
       Scaled[{0.02, 0.02}]]}, {}}], {
    {Thickness[0.002], LineBox[{{-7.5, 0}, {-7.5, 1}}]}, 
    {Thickness[0.002], LineBox[{{-6.5, 0}, {-6.5, 1}}]}, 
    {Thickness[0.002], LineBox[{{-8, 0.5}, {0, 0.5}}]}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->None,
  AxesOrigin->{-8., 0},
  Frame->True,
  FrameLabel->{
    FormBox["\"Si\"", TraditionalForm], 
    FormBox[
    "\"Mg/(Mg+\\!\\(\\*SuperscriptBox[\\\"Fe\\\", RowBox[{\\\"2\\\", \
\\\"+\\\"}]]\\))\"", TraditionalForm]},
  FrameStyle->Thickness[0.006],
  FrameTicks->{{{-8., 
      FormBox["\"8.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {-7.9, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-7.8, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-7.7, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-7.6, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-7.5, 
      FormBox["\"7.5\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {-7.4, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-7.3, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-7.2, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-7.1, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-7., 
      FormBox["\"7.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {-6.9, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-6.8, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-6.7, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-6.6, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-6.5, 
      FormBox["\"6.5\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {-6.4, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-6.3, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-6.2, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-6.1, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-6., 
      FormBox["\"6.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {-5.9, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-5.8, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-5.7, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-5.6, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-5.5, 
      FormBox["\"5.5\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}}, {{0, 
      FormBox["\"0.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {0.1, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.2, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.3, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.4, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.5, 
      FormBox["\"0.5\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {0.6, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.7, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.8, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.9, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {1, 
      FormBox["\"1.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}}},
  ImageSize->{500., Automatic},
  LabelStyle->{
   FontSize -> 14, FontSlant -> "Plain", FontWeight -> "Bold", FontFamily -> 
    "Helvetica"},
  PlotRange->{{-8, -5.5}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.460967552328125*^9, 3.4855815417999477`*^9, 3.485675324522872*^9, 
   3.485675719100997*^9, 3.48567690891315*^9, 3.4856769882925353`*^9, {
   3.485677702879797*^9, 3.485677707442297*^9}, 3.485677814817297*^9, {
   3.485678191145422*^9, 3.485678219614172*^9}, 3.485679296174386*^9, 
   3.485679354893237*^9, {3.485679633002612*^9, 3.485679649986987*^9}, {
   3.485679856580737*^9, 3.485679869377612*^9}, {3.485680188674487*^9, 
   3.485680249986987*^9}, 3.485680486033862*^9, {3.485680612815112*^9, 
   3.485680617955737*^9}, {3.4856810663090887`*^9, 3.4856810738873105`*^9}, {
   3.4856814760941772`*^9, 3.4856814907816772`*^9}, 3.4856817836254272`*^9, 
   3.4856818407504272`*^9, {3.4856819186410522`*^9, 3.4856819230004272`*^9}, {
   3.4856823695941772`*^9, 3.4856823952348022`*^9}, {3.4856824985473022`*^9, 
   3.4856825229066772`*^9}, 3.4856825651723022`*^9, 3.4856826112973022`*^9, {
   3.4856827384066772`*^9, 3.4856827490785522`*^9}, {3.4856829267699747`*^9, 
   3.485682934004581*^9}, {3.48568320871449*^9, 3.4856832274334793`*^9}, 
   3.485683353575719*^9, {3.485683829576367*^9, 3.485683838341992*^9}, 
   3.485684273263867*^9, 3.485684474748242*^9, {3.485684696341992*^9, 
   3.485684720045117*^9}, 3.485684967388867*^9, 3.485684998810742*^9, 
   3.485685272248242*^9, 3.485685313091992*^9, 3.485685398748242*^9, 
   3.485685504185742*^9, 3.4856872525735397`*^9, 3.4856879830397053`*^9, {
   3.485747516191485*^9, 3.4857475373498955`*^9}, {3.4857482407456446`*^9, 
   3.485748269627429*^9}, 3.485748418653656*^9, {3.4857485236695256`*^9, 
   3.485748529804688*^9}, 3.4857490378904886`*^9, 3.485749736585491*^9, 
   3.485749839519697*^9, 3.4857512053870068`*^9, 3.485752281740423*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "10"}], ":", " ", 
    RowBox[{
     RowBox[{"Use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
     "XYPlot", "-", " ", 
     RowBox[{"to", " ", "plot", " ", "mineral"}], "-", 
     RowBox[{"chemical", " ", "data"}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "10", 
     RowBox[{"b", ":", " ", 
      RowBox[{
       RowBox[{"change", " ", "the", " ", "plot"}], "-", 
       RowBox[{"type", " ", "to", " ", 
        RowBox[{"zoisite", "/", "epidote"}]}]}]}]}], ",", " ", 
    RowBox[{
    "use", " ", "squares", " ", "as", " ", "data", " ", "symbols", " ", 
     "enlarging", " ", "their", " ", "size"}]}], "  ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"XYPlot", "[", 
   RowBox[{"\"\<pet2\>\"", ",", 
    RowBox[{"XYPlotType", "\[Rule]", "XYPlotTypeZoEp1"}], ",", 
    RowBox[{"XYPlotSymbolShape", "\[Rule]", "SymbolShapeSquare"}], ",", 
    RowBox[{"XYPlotSymbolSize", "\[Rule]", "0.02"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.48558157428557*^9, 3.4855815750512247`*^9}, {
   3.48558272669624*^9, 3.4855827335871296`*^9}, {3.4855828024960256`*^9, 
   3.4855828108557215`*^9}, {3.485590991707863*^9, 3.4855909977703238`*^9}, {
   3.485675419335372*^9, 3.485675419647872*^9}, {3.485675561397872*^9, 
   3.485675625929122*^9}, {3.485675657397872*^9, 3.485675670616622*^9}, {
   3.485675864819747*^9, 3.485675867788497*^9}, {3.485675969757247*^9, 
   3.485675971225997*^9}, {3.485676081475997*^9, 3.485676083147872*^9}, {
   3.485676565241622*^9, 3.485676567382247*^9}, {3.485677832489172*^9, 
   3.485677834379797*^9}, {3.485678243270422*^9, 3.485678254317297*^9}, 
   3.4856880114773874`*^9, {3.4856880426807117`*^9, 3.4856880657121096`*^9}}],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGDQAWIQ/a7G3jRuF6uD9X3/3ul5l+z3lEyWYAljcZCNSgEK
3bWvBUl7sjpI699VYWu8iiF/+KtGTP8hFofW14E75Fpv2++bLwVUye7gxcOk
3S620x5I3Dz3ndkhCCj7OvCBPQMYsDssKbDlur74gP3DKpF17g/ZHDYUZUx8
W7PfftXHS75JAiwOB08tdN32+a492JibCP0JTy8o3f7J5sCxRgbogv32J8tA
NrI4gHTbm96z90sSiLDcwuagbghSccQe4m4WB1W2xqnO3Xfsj3ubdzomsDjk
Pv+98uOlu/ab5r5ffsyb3QGk60TZPqh72Rw+AEXNOw/aQ9zBDHXvAwz1YOXB
LA7nvwc/Xjr7jn0x2CHsDp9A3ojYaT8avrQNXwCIYDQx
    "], {
     {Hue[0.67, 0.6, 0.6], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 23, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 24, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 25, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 26, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 27, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 28, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 29, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 30, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 31, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 32, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 33, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 34, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 35, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 36, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 37, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 38, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 39, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 40, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 41, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 42, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 43, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
       GraphicsBox[
        PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
         0.5}, {-0.5, -0.5}}]], 44, Automatic, Scaled[{0.02, 0.02}]]}, {}}], 
   {Thickness[0.002], LineBox[{{1.9, 1.1}, {3, 0}}]}, {}},
  AspectRatio->1,
  Axes->None,
  AxesOrigin->{2., 0},
  Frame->True,
  FrameLabel->{
    FormBox["\"Al\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SuperscriptBox[\\\"Fe\\\", RowBox[{\\\"3\\\", \\\"+\\\"}]]\\)\
\"", TraditionalForm]},
  FrameStyle->Thickness[0.006],
  FrameTicks->{{{2, 
      FormBox["\"2.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {2.1, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {2.2, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {2.3, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {2.4, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {2.5, 
      FormBox["\"2.5\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {2.6, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {2.7, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {2.8, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {2.9, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {3, 
      FormBox["\"3.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}}, {{0, 
      FormBox["\"0.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {0.1, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.2, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.3, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.4, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.5, 
      FormBox["\"0.5\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {0.6, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.7, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.8, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.9, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {1, 
      FormBox["\"1.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}}},
  LabelStyle->{
   FontSize -> 14, FontSlant -> "Plain", FontWeight -> "Bold", FontFamily -> 
    "Helvetica"},
  PlotRange->{{1.9, 3}, {0, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.485582707633008*^9, 3.4855827353528223`*^9}, {
   3.4855828043242207`*^9, 3.4855828113557405`*^9}, 3.4855841074675026`*^9, 
   3.4855906423647366`*^9, 3.485590863599112*^9, {3.485590976692334*^9, 
   3.485590998317196*^9}, 3.4855913181120243`*^9, 3.485591759454032*^9, 
   3.4855918300536547`*^9, 3.485596057695501*^9, 3.4856020613431215`*^9, 
   3.4856021882984943`*^9, 3.4856022411809387`*^9, 3.485675292382247*^9, 
   3.485675420929122*^9, {3.485675563569747*^9, 3.485675627038497*^9}, {
   3.485675660632247*^9, 3.485675671272872*^9}, 3.485675869085372*^9, 
   3.485675972804122*^9, 3.485676084022872*^9, 3.485676130054122*^9, 
   3.485676256913497*^9, 3.485676365319747*^9, {3.485676553819747*^9, 
   3.485676569350997*^9}, 3.4856767523093777`*^9, 3.4856768228607683`*^9, 
   3.485676898099958*^9, 3.4856769950114574`*^9, {3.485677828442297*^9, 
   3.485677835754797*^9}, 3.485678256348547*^9, 3.4856880134930253`*^9, {
   3.485688043586968*^9, 3.4856880665871153`*^9}, 3.485747492801879*^9, 
   3.485748538968404*^9, 3.485748898095764*^9, 3.485749039640343*^9, 
   3.485749843785186*^9, 3.485751205574514*^9, 3.485752281927924*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "10"}], ":", " ", 
    RowBox[{
     RowBox[{"Use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
     "XYPlot", "-", " ", 
     RowBox[{"to", " ", "plot", " ", "mineral"}], "-", 
     RowBox[{"chemical", " ", "data"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "10", 
     RowBox[{"c", ":", " ", 
      RowBox[{
       RowBox[{"create", " ", "a", " ", "garnet"}], "-", 
       RowBox[{"zoning", " ", 
        RowBox[{"profile", ":", " ", 
         RowBox[{"use", " ", "squares"}]}]}]}]}]}], ",", " ", "dots", ",", 
    " ", 
    RowBox[{
    "triangles", " ", "and", " ", "diamonds", " ", "as", " ", "data", " ", 
     "symbols"}], ",", "\[IndentingNewLine]", "\t", 
    RowBox[{
     RowBox[{"increase", " ", "the", " ", "x"}], "-", 
     RowBox[{
     "spacing", " ", "of", " ", "the", " ", "data", " ", "points", " ", "to", 
      " ", "5", " ", "microns"}]}]}], "  ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"p1", "=", 
     RowBox[{"XYPlot", "[", 
      RowBox[{"\"\<pet2\>\"", ",", 
       RowBox[{"XYPlotType", "\[Rule]", "XYPlotTypeGrtProfileXFe"}], ",", 
       RowBox[{"XYPlotSymbolShape", "\[Rule]", "SymbolShapeSquare"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"XYPlotTypeGrtProfileFactor", "\[Rule]", "5"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p2", "=", 
     RowBox[{"XYPlot", "[", 
      RowBox[{"\"\<pet2\>\"", ",", 
       RowBox[{"XYPlotType", "\[Rule]", "XYPlotTypeGrtProfileXMg"}], ",", 
       RowBox[{"XYPlotSymbolShape", "\[Rule]", "SymbolShapeDot"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"XYPlotTypeGrtProfileFactor", "\[Rule]", "5"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p3", "=", 
     RowBox[{"XYPlot", "[", 
      RowBox[{"\"\<pet2\>\"", ",", 
       RowBox[{"XYPlotType", "\[Rule]", "XYPlotTypeGrtProfileXCa"}], ",", 
       RowBox[{"XYPlotSymbolShape", "\[Rule]", "SymbolShapeTriangle"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"XYPlotTypeGrtProfileFactor", "\[Rule]", "5"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p4", "=", 
     RowBox[{"XYPlot", "[", 
      RowBox[{"\"\<pet2\>\"", ",", 
       RowBox[{"XYPlotType", "\[Rule]", "XYPlotTypeGrtProfileXMn"}], ",", 
       RowBox[{"XYPlotSymbolShape", "\[Rule]", "SymbolShapeDiamond"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"XYPlotTypeGrtProfileFactor", "\[Rule]", "5"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"p1", ",", "p2", ",", "p3", ",", "p4"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.485686132998242*^9, 3.485686146670117*^9}, {
   3.485686937704356*^9, 3.485686938595061*^9}, {3.4856871427852297`*^9, 
   3.4856871551769648`*^9}, {3.4856872723554225`*^9, 3.485687423782143*^9}, 
   3.485687828132464*^9, 3.4856878901016107`*^9, {3.485688151040482*^9, 
   3.485688219602982*^9}}],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGDIA2IQDQEiDslVh4T4NZ7YQ/gqDpfb9Vbkz4Tx9Rzkdy3Y
l+oH45s4+K+fktqRDONbOiQtvGby3gLGt3NQY8zKuhkF5Tc4OkioBbMungST
d3G4c72x2G0KTN7NYUepuX/pCZi8p4O/9R/TyMUweW+Ha8WXfh+7DpP3c/gU
t9Xo4XQo3yHAwfdzX3CJylOo+kCHyG5/RoN5UPkDQQ4aXF86bTwfQ/WHOOyb
L6V/V+UOVH+og/iV7WdeboLyG8IceNidNjVwQvkHwh3i4xpqS15B+QyRDnt7
knYuvQrTH+VgqDrpRarIXaj+aIeCbTsNbROh/AMxDjbf5fQs392D6o9zsJft
l1zRA5V3iHdwyWuT/vATxk9wmOn+L+HBTij/QYLDkwUtM7fVw8xPdJhxYO3u
ylVQvkKSw+mFrts+/4W5N8nBq7pZ32cZlJ+Q7DCRv8pstR1UPUOKw9I0/i1M
zlD5BSkOW1ZP+DQ5C2Z/qkPTWiEdvnSo/INUh/U1054fvHsban+aA/elHtfL
N6F8hXQH78g2i2tHofwD6Q5bbPjfnbsF5SdkOITbnf784N0tqP2ZDkFvL3+c
0QizP9Mhyj1U2OUuzP4sh9tHTv7lc4X5P8tBdorB5W/rH0Ltz3ZI8lK5eFoD
Gp8KOQ5fBXrfKZRB+QdyHFqBoZW6FMpPyHVwEE48fFkbln7yHC7fPPlAoxLK
X5DnECsmPLs/G5ae8h3YbrgvX1cD5T/Id2A4ZpzxYj5MvsCh9XXgDrlWKH9C
gYNAhOWWE2Uw9QUOz9apPmmGpT+DQoe6/Mvz/3rA7B/Nb6P5bTS/0SO/AQCe
aTY2
     "], {
      {Hue[0.67, 0.6, 0.6], InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 56, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 57, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 58, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 59, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 60, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 61, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 62, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 63, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 64, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 65, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 66, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 67, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 68, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 69, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 70, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 71, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 72, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 73, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 74, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 75, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 76, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 77, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 78, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 79, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 80, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 81, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 82, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 83, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 84, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 85, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 86, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 87, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 88, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 89, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 90, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 91, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 92, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 93, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 94, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 95, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 96, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 97, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 98, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 99, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 100, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 101, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 102, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 103, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 104, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 105, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 106, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 107, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 108, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 109, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 110, Automatic, 
        Scaled[{0.02, 0.02}]]}, {}}], {}, {
     InsetBox["\<\"XFe\"\>", Scaled[{0.1, 0.7}], {0, 0}, Automatic, {1, 0},
      BaseStyle->{FontSize -> Scaled[0.05]}], 
     StyleBox[{},
      FontFamily->"Helvetica",
      FontWeight->"Bold"]}}, {GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGDIA2IQDQEiDgZfPy9TEt1nD+GrOPy92S8yMXEvlK/nELrk
0A2nCbuhfBOHRrVDbcvDd0H5lg4dybF33Jh3QPl2Djrzn1YWlG+D8BscHbbd
1jO5nrkFKu/iIPJWa8mfJZug8m4Odx3f+Cz8DOUzeDqskHie76QIk/d2KNkq
+vv0u41QeT+Hrcsqj2taQeUdAhy2x2asu+yxGao+0OG6OGeu5XSo/IEgh1Uf
L/kmCWyA6g9x6F/KHxtwfxFUf6gD1/4r52d3LYHqD3N4cfBu5O63UPkD4Q71
90KAIQDlM0Q6OBi499+/DVXvEOXA579+SmrHYqj+aIf8D60nQw6ugOqPcfD9
3BdcorIcqj/OoXvZ5skHA2H2xzvsOyiuFswK1e+Q4MB6N+6SxFoo/0GCg8Pv
iUpGa6DqGxIdmu9uyA1Mg8orJDnwdlbr1L6AuTfJgVOs3Xj/LKh8QrLDgsM1
lYzfFkLtT3HIE5/12uQSVP2CFIeWGzOdnpsug9qf6vDkuxkwCUD99yAV1f8N
aQ6J/tZ/TCNh9qc7RB5gybt7Fso/kO5wPvuN0NVomP0ZDlLifC0pjFA+Q6aD
x53kl87iUPMXZDqcTq+UuzN3KdT+LAcbv4sTY/7B/J/lwHbDffm6Gqj7GrId
Vl150xiWAA1fhRyHmbxGJ09EwsI7x2Hi2xp707hVUPtzHe6dsPnEzrwean+e
w6XHIA9C+QvyHH6AvCsCTV8O+Q7dD+q1b26E8h/kO3j8S3iw8zs0/TgUOLQf
sZ1mVwKVn1Dg0BzoObdBDZreHhQ4VEasMD1rDU3/BoUOS3qVrz0KhuWP0fw2
mt9G8xs98hsAS4Eqxg==
     "], {
      {Hue[0.67, 0.6, 0.6], InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 56, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 57, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 58, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 59, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 60, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 61, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 62, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 63, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 64, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 65, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 66, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 67, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 68, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 69, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 70, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 71, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 72, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 73, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 74, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 75, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 76, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 77, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 78, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 79, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 80, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 81, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 82, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 83, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 84, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 85, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 86, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 87, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 88, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 89, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 90, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 91, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 92, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 93, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 94, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 95, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 96, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 97, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 98, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 99, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 100, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 101, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 102, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 103, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 104, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 105, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 106, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 107, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 108, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 109, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 110, Automatic, 
        Scaled[{0.02, 0.02}]]}, {}}], {}, {
     InsetBox["\<\"XMg\"\>", Scaled[{0.1, 0.15}], {0, 0}, Automatic, {1, 0},
      BaseStyle->{FontSize -> Scaled[0.05]}], 
     StyleBox[{},
      FontFamily->"Helvetica",
      FontWeight->"Bold"]}}, {GraphicsComplexBox[CompressedData["
1:eJztk+1Lk2EUxpemLVsIvYFROSnUrJY4CTVZl6bCaMQ2t2wabr7M6bRtgh8y
Sha+jQJ1UlTGcmWZFUZiyBLLQTJJcNp0mwbZPohIoZmQhX1J8dz/Qp984Obh
x3UurnNz7hNVaJRrgzgcjmHtrP83vj04FelvuFnpPrPBRxCeeUNkjRklFsDX
4hj2NDI9EdPcoe+rIWPEydBE2vqXVePEIuxUuAbHHMTmNJRPnk3sr2V6Bryi
g80RXUzPwt3uX5npeUwX44mF9/LK4U+kn4Nf8n56zsX08wir5ybVxZEOKf5W
Z1vDiqgfswzdkj9Pa2ao3imHx6je5o6YIL8CJWJzW27fFPmVMLktnpmAn/wX
sMzbvxrjIN2ZgxpXfXCUipijQnGrtff1M6pHLvwy71bZb+bPQ9Fibrponth5
CVMPVbvsnT7y56O9aZincDG/GktCwQHuR9KhQdbtlVD1PeKABrUysc0cTfnm
AvSdGKloERPzCyE19TwOnWD9FqL/ePTaSIk1RfiWN1elkrD+i6GMj3u+e5zY
XgyuUr+CYyxfi73yGvnCBPUX0GJ+wCWQvWP3K8H2fY3CwTZivg59ddfGe1Xs
vjroHFvaI7NYfimCtNmvlgSkc8rwJjV80f2Z5mEvQ6gk4PuSSgw9rq6Pc4eX
8vVICL7z84dwkvLL0aAcsFbPUj2/ArqY2o5ZL7GzAiG3PtxXjxJrLqMrZyRh
qMdD+QY8SHr79VEssd2A5vVxDLL3ZERybEHngpo4YESqxXa0Kp/pJthsvKbW
HOIWE9LaekpTTrN6E6QvrqccEtL7i69EnDXjZMdF9n43921z3zb37X/s2z/v
tyEu
     "], {
      {Hue[0.67, 0.6, 0.6], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        56, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        57, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        58, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        59, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        60, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        61, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        62, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        63, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        64, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        65, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        66, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        67, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        68, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        69, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        70, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        71, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        72, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        73, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        74, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        75, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        76, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        77, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        78, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        79, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        80, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        81, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        82, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        83, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        84, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        85, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        86, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        87, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        88, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        89, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        90, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        91, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        92, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        93, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        94, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        95, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        96, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        97, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        98, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        99, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        100, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        101, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        102, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        103, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        104, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        105, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        106, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        107, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        108, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        109, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        110, Automatic, Scaled[{0.02, 0.02}]]}, {}}], {}, {
     InsetBox["\<\"XCa\"\>", Scaled[{0.85, 0.35}], {0, 0}, Automatic, {1, 0},
      BaseStyle->{FontSize -> Scaled[0.05]}], 
     StyleBox[{},
      FontFamily->"Helvetica",
      FontWeight->"Bold"]}}, {GraphicsComplexBox[CompressedData["
1:eJztk+tLU3EYx09LpQZKaq+ExMSCCekyNTXJ79QpXvAyplGLnPMyL2ubopHU
dGhk5W3mpRuR01qU4ItQiTA93tqaLCSUrNBmZXeJlF6kdFntOf9CrzxwOHx4
zvf5HH7neXYqNJICHsMwasf99+m8tiPOmn5XF9Uc4+QAVHyyKqt8G4mDUMda
jeLBNuJQSMNEMzrmInEkutLfJj0N4+oH0XPg3HVBBfXTi1BT340bFq4ej0WF
2N2Ue5nqCbiXItW4qzqonoRLkxPv3rwwUD0FLq8rf9bOEzNpyAhf4n8tb3Uy
MuDIyssiqL8+E5lp/b2GFWJWgvb1HRd4um7KSyGJP5s11DpK+SwEN5y3mQeI
9dloVE5Px4wSs4dgql6Q3hxjKX8Yfd/FsbInXP4IunyC5wPcuLwM1f8OcJjy
R8EPyp6R+xAzx+B9raU0bpL6IQeCqW3mB/e5fnIwrdXrUdoxJ9vlmD35cffe
LfS+Phduc4m3+05TPz8FPFaXXOcSR8inAM/DmGzzpffleeiY2Vrkr+K+Px/C
VBM/YRf5uvKx2hsJYeI4+QvwPNZQ51XI+QsQkiUMvOM9Qf5C/JY9bm4CsZ8S
J/anV1psxKwSz9b8jXveU15ehPp9I1c3u5jJX4zFfrs4R2QlfzFYmZ/oW56F
/CWwnJq1nsl5RP4SZBbWpYaUD5K/FFPJbZLp5VvkV8EzPPqhpNNIfhV+xa0t
f2avkP84RhuGa0PzaF4YNXQfatc6I5vIr4b/eOCCJZrmGRrU/1jhfemh+bFr
MGCqMguiuLoW6p5NQ65e7U42aOE4vJZXL4ntWkxG1HjzPWlehWXwdPzdJjdu
fjf2bWPfNvbtf+zbHyAGEeA=
     "], {
      {Hue[0.67, 0.6, 0.6], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 56, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 57, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 58, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 59, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 60, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 61, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 62, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 63, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 64, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 65, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 66, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 67, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 68, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 69, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 70, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 71, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 72, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 73, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 74, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 75, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 76, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 77, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 78, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 79, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 80, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 81, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 82, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 83, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 84, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 85, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 86, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 87, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 88, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 89, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 90, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 91, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 92, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 93, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 94, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 95, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 96, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 97, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 98, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 99, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 100, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 101, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 102, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 103, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 104, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 105, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 106, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 107, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 108, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 109, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 110, 
        Automatic, Scaled[{0.02, 0.02}]]}, {}}], {}, {
     InsetBox["\<\"XMn\"\>", Scaled[{0.5, 0.2}], {0, 0}, Automatic, {1, 0},
      BaseStyle->{FontSize -> Scaled[0.05]}], 
     StyleBox[{},
      FontFamily->"Helvetica",
      FontWeight->"Bold"]}}},
  AspectRatio->1,
  Axes->None,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameLabel->{
    FormBox["\"distance (microns)\"", TraditionalForm], 
    FormBox["\"mole fraction\"", TraditionalForm]},
  FrameStyle->Thickness[0.006],
  FrameTicks->{Automatic, {{0, 
      FormBox["\"0.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {0.1, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.2, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.3, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.4, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.5, 
      FormBox["\"0.5\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {0.6, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.7, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.8, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.9, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {1, 
      FormBox["\"1.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}}},
  LabelStyle->{
   FontSize -> 14, FontSlant -> "Plain", FontWeight -> "Bold", FontFamily -> 
    "Helvetica"},
  PlotRange->{{0, 276}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.485688745009232*^9, 3.485748545493843*^9, 
  3.485748885302984*^9, 3.485749043624387*^9, 3.4857498521130447`*^9, 
  3.4857512059807796`*^9, 3.485752282334177*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "10"}], ":", " ", 
    RowBox[{
     RowBox[{"Use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
     "XYPlot", "-", " ", 
     RowBox[{"to", " ", "plot", " ", "mineral"}], "-", 
     RowBox[{"chemical", " ", "data"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Example", " ", "10", 
      RowBox[{"c", ":", " ", 
       RowBox[{
       "as", " ", "in", " ", "10", "b", " ", "and", " ", "change", " ", "the",
         " ", "positions", " ", "of", " ", "the", " ", "XFe", " ", "label", 
        " ", "by", " ", "changing", " ", "its", " ", "coordinates", " ", "in",
         " ", "the", " ", "option", " ", "\"\<XYPlotLabelPosition\>\""}]}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Note", ":", " ", "XYPlotLabelPosition"}], "\[Rule]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.1", ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.1", ",", "0.15"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.85", ",", "0.35"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5", ",", "0.2"}], "}"}]}], "}"}], " ", "are", " ", "the",
        " ", "default", " ", "settings", " ", "for", " ", "labels", " ", 
       "XFe"}]}]}], ",", " ", "XMg", ",", " ", "XCa", ",", " ", "XMn"}], " ", 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"p1", "=", 
     RowBox[{"XYPlot", "[", 
      RowBox[{"\"\<pet2\>\"", ",", 
       RowBox[{"XYPlotType", "\[Rule]", "XYPlotTypeGrtProfileXFe"}], ",", 
       RowBox[{"XYPlotSymbolShape", "\[Rule]", "SymbolShapeSquare"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"XYPlotTypeGrtProfileFactor", "\[Rule]", "5"}], ",", 
       RowBox[{"XYPlotLabelPosition", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.9", ",", "0.7"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.1", ",", "0.15"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.85", ",", "0.35"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.5", ",", "0.2"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p2", "=", 
     RowBox[{"XYPlot", "[", 
      RowBox[{"\"\<pet2\>\"", ",", 
       RowBox[{"XYPlotType", "\[Rule]", "XYPlotTypeGrtProfileXMg"}], ",", 
       RowBox[{"XYPlotSymbolShape", "\[Rule]", "SymbolShapeDot"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"XYPlotTypeGrtProfileFactor", "\[Rule]", "5"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p3", "=", 
     RowBox[{"XYPlot", "[", 
      RowBox[{"\"\<pet2\>\"", ",", 
       RowBox[{"XYPlotType", "\[Rule]", "XYPlotTypeGrtProfileXCa"}], ",", 
       RowBox[{"XYPlotSymbolShape", "\[Rule]", "SymbolShapeTriangle"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"XYPlotTypeGrtProfileFactor", "\[Rule]", "5"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p4", "=", 
     RowBox[{"XYPlot", "[", 
      RowBox[{"\"\<pet2\>\"", ",", 
       RowBox[{"XYPlotType", "\[Rule]", "XYPlotTypeGrtProfileXMn"}], ",", 
       RowBox[{"XYPlotSymbolShape", "\[Rule]", "SymbolShapeDiamond"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"XYPlotTypeGrtProfileFactor", "\[Rule]", "5"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"p1", ",", "p2", ",", "p3", ",", "p4"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.485686132998242*^9, 3.485686146670117*^9}, {
   3.485686937704356*^9, 3.485686938595061*^9}, {3.4856871427852297`*^9, 
   3.4856871551769648`*^9}, {3.4856872723554225`*^9, 3.485687423782143*^9}, 
   3.485687828132464*^9, 3.4856878901016107`*^9, {3.485688151040482*^9, 
   3.485688341071732*^9}, {3.485688765884232*^9, 3.485688869493607*^9}}],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGDIA2IQDQEiDslVh4T4NZ7YQ/gqDpfb9Vbkz4Tx9Rzkdy3Y
l+oH45s4+K+fktqRDONbOiQtvGby3gLGt3NQY8zKuhkF5Tc4OkioBbMungST
d3G4c72x2G0KTN7NYUepuX/pCZi8p4O/9R/TyMUweW+Ha8WXfh+7DpP3c/gU
t9Xo4XQo3yHAwfdzX3CJylOo+kCHyG5/RoN5UPkDQQ4aXF86bTwfQ/WHOOyb
L6V/V+UOVH+og/iV7WdeboLyG8IceNidNjVwQvkHwh3i4xpqS15B+QyRDnt7
knYuvQrTH+VgqDrpRarIXaj+aIeCbTsNbROh/AMxDjbf5fQs392D6o9zsJft
l1zRA5V3iHdwyWuT/vATxk9wmOn+L+HBTij/QYLDkwUtM7fVw8xPdJhxYO3u
ylVQvkKSw+mFrts+/4W5N8nBq7pZ32cZlJ+Q7DCRv8pstR1UPUOKw9I0/i1M
zlD5BSkOW1ZP+DQ5C2Z/qkPTWiEdvnSo/INUh/U1054fvHsban+aA/elHtfL
N6F8hXQH78g2i2tHofwD6Q5bbPjfnbsF5SdkOITbnf784N0tqP2ZDkFvL3+c
0QizP9Mhyj1U2OUuzP4sh9tHTv7lc4X5P8tBdorB5W/rH0Ltz3ZI8lK5eFoD
Gp8KOQ5fBXrfKZRB+QdyHFqBoZW6FMpPyHVwEE48fFkbln7yHC7fPPlAoxLK
X5DnECsmPLs/G5ae8h3YbrgvX1cD5T/Id2A4ZpzxYj5MvsCh9XXgDrlWKH9C
gYNAhOWWE2Uw9QUOz9apPmmGpT+DQoe6/Mvz/3rA7B/Nb6P5bTS/0SO/AQCe
aTY2
     "], {
      {Hue[0.67, 0.6, 0.6], InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 56, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 57, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 58, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 59, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 60, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 61, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 62, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 63, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 64, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 65, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 66, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 67, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 68, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 69, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 70, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 71, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 72, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 73, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 74, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 75, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 76, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 77, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 78, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 79, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 80, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 81, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 82, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 83, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 84, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 85, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 86, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 87, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 88, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 89, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 90, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 91, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 92, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 93, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 94, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 95, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 96, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 97, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 98, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 99, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 100, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 101, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 102, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 103, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 104, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 105, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 106, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 107, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 108, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 109, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 110, Automatic, 
        Scaled[{0.02, 0.02}]]}, {}}], {}, {
     InsetBox["\<\"XFe\"\>", Scaled[{0.9, 0.7}], {0, 0}, Automatic, {1, 0},
      BaseStyle->{FontSize -> Scaled[0.05]}], 
     StyleBox[{},
      FontFamily->"Helvetica",
      FontWeight->"Bold"]}}, {GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGDIA2IQDQEiDgZfPy9TEt1nD+GrOPy92S8yMXEvlK/nELrk
0A2nCbuhfBOHRrVDbcvDd0H5lg4dybF33Jh3QPl2Djrzn1YWlG+D8BscHbbd
1jO5nrkFKu/iIPJWa8mfJZug8m4Odx3f+Cz8DOUzeDqskHie76QIk/d2KNkq
+vv0u41QeT+Hrcsqj2taQeUdAhy2x2asu+yxGao+0OG6OGeu5XSo/IEgh1Uf
L/kmCWyA6g9x6F/KHxtwfxFUf6gD1/4r52d3LYHqD3N4cfBu5O63UPkD4Q71
90KAIQDlM0Q6OBi499+/DVXvEOXA579+SmrHYqj+aIf8D60nQw6ugOqPcfD9
3BdcorIcqj/OoXvZ5skHA2H2xzvsOyiuFswK1e+Q4MB6N+6SxFoo/0GCg8Pv
iUpGa6DqGxIdmu9uyA1Mg8orJDnwdlbr1L6AuTfJgVOs3Xj/LKh8QrLDgsM1
lYzfFkLtT3HIE5/12uQSVP2CFIeWGzOdnpsug9qf6vDkuxkwCUD99yAV1f8N
aQ6J/tZ/TCNh9qc7RB5gybt7Fso/kO5wPvuN0NVomP0ZDlLifC0pjFA+Q6aD
x53kl87iUPMXZDqcTq+UuzN3KdT+LAcbv4sTY/7B/J/lwHbDffm6Gqj7GrId
Vl150xiWAA1fhRyHmbxGJ09EwsI7x2Hi2xp707hVUPtzHe6dsPnEzrwean+e
w6XHIA9C+QvyHH6AvCsCTV8O+Q7dD+q1b26E8h/kO3j8S3iw8zs0/TgUOLQf
sZ1mVwKVn1Dg0BzoObdBDZreHhQ4VEasMD1rDU3/BoUOS3qVrz0KhuWP0fw2
mt9G8xs98hsAS4Eqxg==
     "], {
      {Hue[0.67, 0.6, 0.6], InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 56, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 57, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 58, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 59, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 60, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 61, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 62, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 63, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 64, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 65, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 66, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 67, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 68, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 69, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 70, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 71, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 72, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 73, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 74, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 75, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 76, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 77, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 78, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 79, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 80, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 81, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 82, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 83, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 84, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 85, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 86, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 87, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 88, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 89, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 90, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 91, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 92, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 93, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 94, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 95, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 96, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 97, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 98, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 99, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 100, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 101, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 102, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 103, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 104, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 105, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 106, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 107, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 108, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 109, Automatic, Scaled[{0.02, 0.02}]], 
       InsetBox[
        GraphicsBox[DiskBox[{0, 0}]], 110, Automatic, 
        Scaled[{0.02, 0.02}]]}, {}}], {}, {
     InsetBox["\<\"XMg\"\>", Scaled[{0.1, 0.15}], {0, 0}, Automatic, {1, 0},
      BaseStyle->{FontSize -> Scaled[0.05]}], 
     StyleBox[{},
      FontFamily->"Helvetica",
      FontWeight->"Bold"]}}, {GraphicsComplexBox[CompressedData["
1:eJztk+1Lk2EUxpemLVsIvYFROSnUrJY4CTVZl6bCaMQ2t2wabr7M6bRtgh8y
Sha+jQJ1UlTGcmWZFUZiyBLLQTJJcNp0mwbZPohIoZmQhX1J8dz/Qp984Obh
x3UurnNz7hNVaJRrgzgcjmHtrP83vj04FelvuFnpPrPBRxCeeUNkjRklFsDX
4hj2NDI9EdPcoe+rIWPEydBE2vqXVePEIuxUuAbHHMTmNJRPnk3sr2V6Bryi
g80RXUzPwt3uX5npeUwX44mF9/LK4U+kn4Nf8n56zsX08wir5ybVxZEOKf5W
Z1vDiqgfswzdkj9Pa2ao3imHx6je5o6YIL8CJWJzW27fFPmVMLktnpmAn/wX
sMzbvxrjIN2ZgxpXfXCUipijQnGrtff1M6pHLvwy71bZb+bPQ9Fibrponth5
CVMPVbvsnT7y56O9aZincDG/GktCwQHuR9KhQdbtlVD1PeKABrUysc0cTfnm
AvSdGKloERPzCyE19TwOnWD9FqL/ePTaSIk1RfiWN1elkrD+i6GMj3u+e5zY
XgyuUr+CYyxfi73yGvnCBPUX0GJ+wCWQvWP3K8H2fY3CwTZivg59ddfGe1Xs
vjroHFvaI7NYfimCtNmvlgSkc8rwJjV80f2Z5mEvQ6gk4PuSSgw9rq6Pc4eX
8vVICL7z84dwkvLL0aAcsFbPUj2/ArqY2o5ZL7GzAiG3PtxXjxJrLqMrZyRh
qMdD+QY8SHr79VEssd2A5vVxDLL3ZERybEHngpo4YESqxXa0Kp/pJthsvKbW
HOIWE9LaekpTTrN6E6QvrqccEtL7i69EnDXjZMdF9n43921z3zb37X/s2z/v
tyEu
     "], {
      {Hue[0.67, 0.6, 0.6], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        56, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        57, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        58, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        59, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        60, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        61, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        62, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        63, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        64, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        65, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        66, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        67, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        68, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        69, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        70, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        71, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        72, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        73, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        74, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        75, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        76, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        77, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        78, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        79, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        80, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        81, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        82, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        83, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        84, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        85, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        86, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        87, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        88, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        89, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        90, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        91, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        92, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        93, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        94, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        95, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        96, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        97, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        98, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        99, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        100, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        101, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        102, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        103, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        104, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        105, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        106, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        107, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        108, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        109, Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        110, Automatic, Scaled[{0.02, 0.02}]]}, {}}], {}, {
     InsetBox["\<\"XCa\"\>", Scaled[{0.85, 0.35}], {0, 0}, Automatic, {1, 0},
      BaseStyle->{FontSize -> Scaled[0.05]}], 
     StyleBox[{},
      FontFamily->"Helvetica",
      FontWeight->"Bold"]}}, {GraphicsComplexBox[CompressedData["
1:eJztk+tLU3EYx09LpQZKaq+ExMSCCekyNTXJ79QpXvAyplGLnPMyL2ubopHU
dGhk5W3mpRuR01qU4ItQiTA93tqaLCSUrNBmZXeJlF6kdFntOf9CrzxwOHx4
zvf5HH7neXYqNJICHsMwasf99+m8tiPOmn5XF9Uc4+QAVHyyKqt8G4mDUMda
jeLBNuJQSMNEMzrmInEkutLfJj0N4+oH0XPg3HVBBfXTi1BT340bFq4ej0WF
2N2Ue5nqCbiXItW4qzqonoRLkxPv3rwwUD0FLq8rf9bOEzNpyAhf4n8tb3Uy
MuDIyssiqL8+E5lp/b2GFWJWgvb1HRd4um7KSyGJP5s11DpK+SwEN5y3mQeI
9dloVE5Px4wSs4dgql6Q3hxjKX8Yfd/FsbInXP4IunyC5wPcuLwM1f8OcJjy
R8EPyp6R+xAzx+B9raU0bpL6IQeCqW3mB/e5fnIwrdXrUdoxJ9vlmD35cffe
LfS+Phduc4m3+05TPz8FPFaXXOcSR8inAM/DmGzzpffleeiY2Vrkr+K+Px/C
VBM/YRf5uvKx2hsJYeI4+QvwPNZQ51XI+QsQkiUMvOM9Qf5C/JY9bm4CsZ8S
J/anV1psxKwSz9b8jXveU15ehPp9I1c3u5jJX4zFfrs4R2QlfzFYmZ/oW56F
/CWwnJq1nsl5RP4SZBbWpYaUD5K/FFPJbZLp5VvkV8EzPPqhpNNIfhV+xa0t
f2avkP84RhuGa0PzaF4YNXQfatc6I5vIr4b/eOCCJZrmGRrU/1jhfemh+bFr
MGCqMguiuLoW6p5NQ65e7U42aOE4vJZXL4ntWkxG1HjzPWlehWXwdPzdJjdu
fjf2bWPfNvbtf+zbHyAGEeA=
     "], {
      {Hue[0.67, 0.6, 0.6], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 56, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 57, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 58, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 59, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 60, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 61, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 62, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 63, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 64, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 65, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 66, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 67, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 68, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 69, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 70, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 71, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 72, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 73, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 74, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 75, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 76, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 77, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 78, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 79, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 80, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 81, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 82, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 83, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 84, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 85, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 86, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 87, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 88, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 89, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 90, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 91, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 92, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 93, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 94, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 95, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 96, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 97, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 98, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 99, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 100, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 101, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 102, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 103, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 104, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 105, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 106, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 107, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 108, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 109, 
        Automatic, Scaled[{0.02, 0.02}]], InsetBox[
        GraphicsBox[
         PolygonBox[{{0, 1.4142135623730951`}, {1.4142135623730951`, 0}, {
           0, -1.4142135623730951`}, {-1.4142135623730951`, 0}}]], 110, 
        Automatic, Scaled[{0.02, 0.02}]]}, {}}], {}, {
     InsetBox["\<\"XMn\"\>", Scaled[{0.5, 0.2}], {0, 0}, Automatic, {1, 0},
      BaseStyle->{FontSize -> Scaled[0.05]}], 
     StyleBox[{},
      FontFamily->"Helvetica",
      FontWeight->"Bold"]}}},
  AspectRatio->1,
  Axes->None,
  AxesOrigin->{0, 0},
  Frame->True,
  FrameLabel->{
    FormBox["\"distance (microns)\"", TraditionalForm], 
    FormBox["\"mole fraction\"", TraditionalForm]},
  FrameStyle->Thickness[0.006],
  FrameTicks->{Automatic, {{0, 
      FormBox["\"0.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {0.1, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.2, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.3, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.4, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.5, 
      FormBox["\"0.5\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {0.6, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.7, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.8, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.9, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {1, 
      FormBox["\"1.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}}},
  LabelStyle->{
   FontSize -> 14, FontSlant -> "Plain", FontWeight -> "Bold", FontFamily -> 
    "Helvetica"},
  PlotRange->{{0, 276}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.485688825681107*^9, 3.485688871790482*^9, 
  3.4857485490843964`*^9, 3.485749856800394*^9, 3.4857512064807987`*^9, 
  3.4857522828654304`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "10"}], ":", " ", 
    RowBox[{
     RowBox[{"Use", " ", "the", " ", "PET"}], "-", "function", " ", "-", 
     "XYPlot", "-", " ", 
     RowBox[{"to", " ", "plot", " ", "mineral"}], "-", 
     RowBox[{"chemical", " ", "data"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Example", " ", "10", 
     RowBox[{"d", ":", " ", 
      RowBox[{"draw", " ", "a", " ", 
       RowBox[{"Na", "[", "B", "]"}], " ", "versus", " ", "Si", " ", 
       "diagram", " ", "for", " ", "amphibole", " ", "and", " ", 
       "differentiate", " ", "amphiboles", " ", "by", " ", "their", " ", 
       "analyses", " ", "labels"}]}]}], ";", "\[IndentingNewLine]", "\t", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
       "amphiboles", " ", "in", " ", "\"\<pet2\>\"", " ", "with", " ", 
        "labels", " ", "ending", " ", "in", " ", "\"\<sgu\>\"", " ", "are", 
        " ", "rims", " ", "around", " ", "eclogite"}], "-", "garnet"}], ",", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{
       "those", " ", "with", " ", "labels", " ", "ending", " ", "in", " ", 
        "\"\<syu\>\"", " ", "are", " ", "symplectite"}], "-", 
       "amphiboles"}]}], " "}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"p1", " ", "=", " ", 
     RowBox[{"XYPlot", "[", 
      RowBox[{"\"\<pet2\>\"", ",", 
       RowBox[{"XYPlotType", "\[Rule]", "XYPlotTypeAmph2"}], ",", 
       RowBox[{"XYPlotTexture", "->", "\"\<sgu\>\""}], ",", 
       RowBox[{"XYPlotSymbolShape", "\[Rule]", "SymbolShapeTriangle"}], ",", 
       RowBox[{"XYPlotSymbolSize", "\[Rule]", "0.03"}]}], "]"}]}], ";"}], 
   "\n", 
   RowBox[{
    RowBox[{"p2", " ", "=", " ", 
     RowBox[{"XYPlot", "[", 
      RowBox[{"\"\<pet2\>\"", ",", 
       RowBox[{"XYPlotType", "\[Rule]", "XYPlotTypeAmph2"}], ",", 
       RowBox[{"XYPlotTexture", "->", "\"\<syu\>\""}], ",", 
       RowBox[{"XYPlotSymbolShape", "\[Rule]", "SymbolShapeSquare"}], ",", 
       RowBox[{"XYPlotSymbolSize", "\[Rule]", "0.025"}]}], "]"}]}], ";"}], 
   "\n", 
   RowBox[{"Show", "[", 
    RowBox[{"p1", ",", "p2"}], "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.485688492837357*^9, {3.485688571837357*^9, 3.485688609274857*^9}, {
   3.485688650384232*^9, 3.485688698196732*^9}, 3.4857498678625402`*^9}],

Cell[BoxData[
 GraphicsBox[{{GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGBQA2IQ7dKd8/z3SvEDPboslhqJV+z7D33ViOkXP7Bnc9nt
1mc37Ne5P6wSWSd2YKHXWbkM1iv22u1iN8+Vix/o1Jzoor/4nn0uUPfHS5IH
ovTbihbFPrB/E7hDrjVb8kBmENeuvUue2CtuKMqYmCt24JPKy1knzS/az8gT
aj7gJXZA++CjgmfhV+2nOQMdUC1+wO4CF0/k3Vv2HiDrjosd0FopfMHlxhX7
MD7dTXPfix34uu/j1vRpN+DqGQ3mOTr/v2BvyLFGJuqJ+IHa03P0ujuv2rOA
NYgd2GN/b3WY2hn7OUcUgC4QP+B9gt12duh1e7Bxy8UP2OwNmqbYd93+y98r
FS+XiR3o9geZeNn+w/Jj3uacEgeWfSprudx01d6LhwnoZfEDz05zb+j3u2o/
Gl6khRcAq4Qrhw==
     "], {
      {Hue[0.67, 0.6, 0.6], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        20, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        21, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        22, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        23, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        24, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        25, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        26, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        27, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        28, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        29, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        30, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        31, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        32, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        33, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        34, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        35, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        36, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        37, Automatic, Scaled[{0.03, 0.03}]], InsetBox[
        GraphicsBox[
         PolygonBox[
          NCache[{{0, 1}, {
            Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}}, {{0, 
            1}, {-0.8660254037844386, -0.5}, {0.8660254037844386, -0.5}}]]], 
        38, Automatic, Scaled[{0.03, 0.03}]]}, {}}], {
     {Thickness[0.002], LineBox[{{-7.5, 0}, {-7.5, 2.1}}]}, 
     {Thickness[0.002], LineBox[{{-6.5, 0}, {-6.5, 2.1}}]}, 
     {Thickness[0.002], LineBox[{{-8, 0.5}, {0, 0.5}}]}, 
     {Thickness[0.002], LineBox[{{-8, 1.5}, {0, 1.5}}]}}, {}}, {
    GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGDQAmIQzcOk3S4WKXPgb/uX29cbH9pvOVG2b76U3AHteyds
PrE/sBdqPnBqoavMAetVsxRe2b20P/xVI6bfSfpAF1Otkv+kWxD5o/IHwjx+
em71v2j/DSh96Kv0AdUzW/5qa9+13+UJtIFd5kA4p1i78f4uey+QhdMkDzB+
u7hSe/5Fe5D1N89JH3DcPt3E7fUN+22f/16peClz4ExS0ufC3Af2jVOdu3Oe
yx5Yvq5m2vOD9+0zJr6tsd8qf8Dzus++m88u2X9YfszbvFP+gFyuzEax+Xfs
N819DxSRPxDqK1Aq3/DUHqj598pC2QO+P5bW3Qu5ZM8GNlD+AGvmsUUv31yz
1wVrkDvQteHhy6mbHtjbm8YBnSx/oOTS72PX5z2wf1glss79ocyBHQ5Nj47P
uGsPdu53mQP2E9WBToDJyx7YUARy2XX70fCkbngCAJKrWoc=
     "], {
      {Hue[0.67, 0.6, 0.6], InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 22, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 23, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 24, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 25, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 26, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 27, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 28, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 29, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 30, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 31, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 32, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 33, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 34, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 35, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 36, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 37, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 38, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 39, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 40, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 41, Automatic, Scaled[{0.025, 0.025}]], 
       InsetBox[
        GraphicsBox[
         PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
          0.5}, {-0.5, -0.5}}]], 42, Automatic, 
        Scaled[{0.025, 0.025}]]}, {}}], {
     {Thickness[0.002], LineBox[{{-7.5, 0}, {-7.5, 2.1}}]}, 
     {Thickness[0.002], LineBox[{{-6.5, 0}, {-6.5, 2.1}}]}, 
     {Thickness[0.002], LineBox[{{-8, 0.5}, {0, 0.5}}]}, 
     {Thickness[0.002], LineBox[{{-8, 1.5}, {0, 1.5}}]}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->None,
  AxesOrigin->{-8., 0},
  Frame->True,
  FrameLabel->{
    FormBox["\"Si\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\\"Na\\\", \\\"B\\\"]\\)\"", TraditionalForm]},
  FrameStyle->Thickness[0.006],
  FrameTicks->{{{-8., 
      FormBox["\"8.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {-7.9, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-7.8, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-7.7, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-7.6, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-7.5, 
      FormBox["\"7.5\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {-7.4, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-7.3, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-7.2, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-7.1, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-7., 
      FormBox["\"7.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {-6.9, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-6.8, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-6.7, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-6.6, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-6.5, 
      FormBox["\"6.5\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {-6.4, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-6.3, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-6.2, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-6.1, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-6., 
      FormBox["\"6.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {-5.9, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-5.8, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-5.7, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-5.6, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {-5.5, 
      FormBox["\"5.5\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}}, {{0., 
      FormBox["\"0.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {0.1, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.2, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.3, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.4, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.5, 
      FormBox["\"0.5\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {0.6, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.7, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.8, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {0.9, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {1., 
      FormBox["\"1.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {1.1, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {1.2, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {1.3, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {1.4, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {1.5, 
      FormBox["\"1.5\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}, {1.6, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {1.7, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {1.8, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {1.9, 
      FormBox["\"\"", TraditionalForm], {0.015, 0}, {
       Thickness[0.003]}}, {2., 
      FormBox["\"2.0\"", TraditionalForm], {0.02, 0}, {
       Thickness[0.003]}}}},
  ImageSize->{500., Automatic},
  LabelStyle->{
   FontSize -> 14, FontSlant -> "Plain", FontWeight -> "Bold", FontFamily -> 
    "Helvetica"},
  PlotRange->{{-8, -5.5}, {0, 2.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.4609675916875*^9, 3.485688389540482*^9, 3.485688441259232*^9, 
   3.485688576290482*^9, 3.485688611931107*^9, {3.485688662618607*^9, 
   3.485688698571732*^9}, 3.485688887415482*^9, 3.4857485586071672`*^9, 
   3.485749871596796*^9, 3.4857512067620597`*^9, 3.4857522831623073`*^9}]
}, Open  ]]
},
WindowSize->{994, 620},
WindowMargins->{{Automatic, 0}, {Automatic, 13}},
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 2772, 66, 292, "Input"],
Cell[CellGroupData[{
Cell[3342, 90, 646, 16, 72, "Input"],
Cell[3991, 108, 473, 8, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4501, 121, 2230, 56, 192, "Input"],
Cell[CellGroupData[{
Cell[6756, 181, 580, 11, 23, "Print"],
Cell[7339, 194, 579, 11, 23, "Print"]
}, Open  ]],
Cell[7933, 208, 476, 10, 30, "Output"],
Cell[8412, 220, 524, 10, 245, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8973, 235, 1569, 36, 112, "Input"],
Cell[10545, 273, 309, 6, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10891, 284, 1741, 41, 212, "Input"],
Cell[CellGroupData[{
Cell[12657, 329, 536, 11, 23, "Print"],
Cell[13196, 342, 586, 12, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13831, 360, 1122, 28, 132, "Input"],
Cell[14956, 390, 570, 11, 23, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15563, 406, 1590, 40, 112, "Input"],
Cell[17156, 448, 17481, 303, 357, 3362, 70, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34674, 756, 5218, 124, 312, "Input"],
Cell[39895, 882, 16964, 312, 354, 7294, 152, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56896, 1199, 2247, 58, 132, "Input"],
Cell[59146, 1259, 15000, 276, 346, 8340, 166, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74183, 1540, 1344, 31, 92, "Input"],
Cell[75530, 1573, 21781, 451, 341, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[97348, 2029, 1817, 36, 92, "Input"],
Cell[99168, 2067, 12147, 226, 364, 6719, 138, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[111352, 2298, 3115, 74, 292, "Input"],
Cell[114470, 2374, 62778, 1240, 356, 51930, 1061, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[177285, 3619, 4018, 93, 352, "Input"],
Cell[181306, 3714, 52094, 1064, 356, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[233437, 4783, 2419, 56, 212, "Input"],
Cell[235859, 4841, 16915, 363, 342, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
