#ifndef __canbasic__
#define __canbasic__
//-----------------------------------------------------------------------------
// File:        Canbasic.h
// Project:     CanOpen Protocol Stack
// Date:        Sept 2000, June 2009
// Author:      Peter Hintenaus, Gernot Kvas
//-----------------------------------------------------------------------------

#include <stdint.h>

#define MOBTABLESZ 2048

// must be 32 bits, even for 11 bit identifiers!!!
typedef uint32_t CobIdTy; 
typedef enum {
   hrdxmit, hrdrcv, sftxmit, sftrcv, unused, deleted
} modeTy;

typedef struct MobSt {
   CobIdTy cobId;
   modeTy mode;
   unsigned char datalen;
   union {
      uint64_t i;
      unsigned char c[8];
   } data;
   int usrData;
   struct MobSt *nxt;      // for FIFO queues to queue for xmit and remote frame xmit	
   void (*CallBack)(struct MobSt *);
} MobType;

typedef struct MobSt *MobIdTy;
#define noMob NULL

typedef enum {
   busoff = 1, 
   warn = 2,
   rxovrrn = 3, 
   ok = 0
} reasonTy;

typedef void (*errorCallbackTy)(reasonTy reason);

// prototypes
void InitCan(unsigned baudrate, errorCallbackTy);
void ChipOff();
void ChkNRestartChip();
void XmitMsg(MobIdTy mobId);
void XmitRmtFrm(MobIdTy mobId);
void SetData(MobIdTy mobid, unsigned char datalen, unsigned char *data);
MobIdTy InitMob(CobIdTy cobid, modeTy mode, int UsrData, void (*)(struct MobSt *));
void DeleteMob(CobIdTy cobid);

#endif
