#ifndef __EVENT__
#define __EVENT__

//	CanOpen
//	Peter Hintenaus
//	June 2009
//	Timekeeping based on POSIX clocks
//
//	Change history:
//

#include <pthread.h>
#include <signal.h>
#include <time.h>
#include <stdint.h>

typedef struct EventSt {
   int inited;
   timer_t tid;
   struct sigevent evp;
} EventTy;

void initEvents(void);

void setupEvent(EventTy *, void (*action)(union sigval p), int par);

// the unit of the delay and the period is 1/f s.

void reSchedule(EventTy *event, uint32_t delay, uint32_t f);

void schedulePeriodic(EventTy *event, uint32_t delay, uint32_t period, uint32_t f);

void cancel(EventTy *event);

#endif
