//   CanOpen
//   Peter Hintenaus
//   December 2000, July 2010
//
//   The Object Dicionary according to DS301 V4.0, DSP302 V3.0.
//   This file is application specific!!
//
//   Change history:
//

#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include "ObjDict.h"
#include "nmt.h"
#include "size.h"
#include "error.h"

uint32_t const DeviceType = 0x12E;
uint32_t ManufStatReg = 0;
uint32_t const VendorId = 0xFFFFFFFF;
uint32_t const ProductCode = 0x00020000;
uint32_t const RevisionNo = 0x00000000;
char const ManufDevName[] = "i-RED FtIr";
char const ManufHwVers[] = "1.00";
char const ManufSwVers[] = "1.00";

ProcessOD *mappedOD;

static unsigned const char no2 = 2;
static unsigned const char no3 = 3;
static unsigned const char no5 = 5;
static unsigned const char no127 = 127;

extern uint8_t errorRegister;
extern uint32_t comCycleTime;
extern uint32_t syncWindowLen;
extern uint16_t GrdTime;
extern uint8_t lifetime;
extern CobIdTy timeCobid; 
extern CobIdTy emcyCob;
extern uint16_t emcyInhibit;
extern consumedEmcyTy consumedEmcy[];

static OdEntry dummy;
static OdEntry no254 = {0, 254};

void GetGuardingParams(uint8_t nodeid, uint8_t *retry, uint16_t *guardtime) {
   uint32_t sa = SlaveAssignment[nodeid - 1];
   *retry = (sa >> 8) & 0xff;
   *guardtime = sa >> 16;
}

void GetProcEntry(uint16_t i, uint8_t si, uint8_t *st, int *dl, OdEntry **d, int *sgnxtnd) {
   // check for process data, this should be fast!

   *d = NULL;
   if (0xA000 <= i && i <= 0xA243) {
      if (si == 0) {
         *st = READ; *dl = 8; *d = &no254;  *sgnxtnd = 0; return;
      }
      *st = READ | PDOMAPABLE; *dl = 8; *sgnxtnd = 0; si--;
      if ( 0xA000 <= i && i <= 0xA003) {
         *d = &(mappedOD->EntryA000i8[i - 0xA000][si]); *sgnxtnd = 1; return;
      }
      if (0xA040 <= i && i <= 0xA043) {
         *d = &(mappedOD->EntryA040u8[i - 0xA040][si]); return;
      }
      if (0xA080 <= i && i <= 0xA083) {
         *d = &(mappedOD->EntryA080b[i - 0xA080][si]); *dl = 1; return;
      }
      if (0xA0C0 <= i && i <= 0xA0C3) {
         *d = &(mappedOD->EntryA0C0i16[i - 0xA0C0][si]); *dl = 16; *sgnxtnd = 1; return;
      }
      if (0xA100 <= i && i <= 0xA103) {
         *d = &(mappedOD->EntryA100u16[i - 0xA100][si]); *dl = 16; return;
      }
      if (0xA140 <= i && i <= 0xA143) {
         *d = &(mappedOD->EntryA140i24[i - 0xA140][si]); *dl = 24; *sgnxtnd = 1; return;
      }
      if (0xA180 <= i && i <= 0xA183) {
         *d = &(mappedOD->EntryA180u24[i - 0xA180][si]); *dl = 24; return;
      }
      if (0xA1C0 <= i && i <= 0xA1C3) {
         *d = &(mappedOD->EntryA1C0i32[i - 0xA1C0][si]); *dl = 32; return;
      }
      if (0xA240 <= i && i <= 0xA243) {
         *d = &(mappedOD->EntryA240f[i - 0xA240][si]); *dl = 32; return;
      }
   }
   if (0xA480 <= i && i <= 0xA6C3) {
      if (si == 0) {
         *st = READ; *dl = 8; *d = &no254;  *sgnxtnd = 0; return;
      }
      *st = WRITE | PDOMAPABLE; *dl = 8; *sgnxtnd = 0; si--;
      if ( 0xA480 <= i && i <= 0xA483) {
         *d = &(mappedOD->EntryA480i8[i - 0xA480][si]); *sgnxtnd = 1; return;
      }
      if (0xA4C0 <= i && i <= 0xA4C3) {
         *d = &(mappedOD->EntryA4C0u8[i - 0xA4C0][si]); return;
      }
      if (0xA500 <= i && i <= 0xA503) {
         *d = &(mappedOD->EntryA500b[i - 0xA500][si]); *dl = 1; return;
      }
      if (0xA540 <= i && i <= 0xA543) {
         *d = &(mappedOD->EntryA540i16[i - 0xA540][si]); *dl = 16; *sgnxtnd = 1; return;
      }
      if (0xA580 <= i && i <= 0xA583) {
         *d = &(mappedOD->EntryA580u16[i - 0xA580][si]); *dl = 16; return;
      }
      if (0xA5C0 <= i && i <= 0xA5C3) {
         *d = &(mappedOD->EntryA5C0i24[i - 0xA5C0][si]); *dl = 24; *sgnxtnd = 1; return;
      }
      if (0xA600 <= i && i <= 0xA603) {
         *d = &(mappedOD->EntryA600u24[i - 0xA600][si]); *dl = 24; return;
      }
      if (0xA640 <= i && i <= 0xA643) {
         *d = &(mappedOD->EntryA640i32[i - 0xA640][si]); *dl = 32; return;
      }
      if (0xA6C0 <= i && i <= 0xA6C3) {
         *d = &(mappedOD->EntryA6C0f[i - 0xA6C0][si]); *dl = 32; return;
      }
   }
   // datatypes
   if (i == 0x0001 && si == 0x0) {*dl = 1; *st = PDOMAPABLE | WRITE | READ; *d = &dummy; return;}
   if (i == 0x0002 && si == 0x0) {*dl = 8; *st = PDOMAPABLE | WRITE | READ; *d = &dummy; return;}
   if (i == 0x0003 && si == 0x0) {*dl = 16; *st = PDOMAPABLE | WRITE | READ; *d = &dummy; return;}
   if (i == 0x0010 && si == 0x0) {*dl = 24; *st = PDOMAPABLE | WRITE | READ; *d = &dummy; return;}
   if (i == 0x0004 && si == 0x0) {*dl = 32; *st = PDOMAPABLE | WRITE | READ; *d = &dummy; return;}
   if (i == 0x0005 && si == 0x0) {*dl = 8; *st = PDOMAPABLE | WRITE | READ; *d = &dummy; return;}
   if (i == 0x0006 && si == 0x0) {*dl = 16; *st = PDOMAPABLE | WRITE | READ; *d = &dummy; return;}
   if (i == 0x0016 && si == 0x0) {*dl = 24; *st = PDOMAPABLE | WRITE | READ; *d = &dummy; return;}
   if (i == 0x0008 && si == 0x0) {*dl = 32; *st = PDOMAPABLE | WRITE | READ; *d = &dummy; return;}
}

void initProcessOD(void) {
   int32_t i;

   for (i = 0; i < 254; i++) {
      mappedOD->EntryA000i8[0][i].TransferTime =  mappedOD->EntryA000i8[1][i].TransferTime =  mappedOD->EntryA000i8[2][i].TransferTime =  mappedOD->EntryA000i8[3][i].TransferTime =  INT32_MIN;
      mappedOD->EntryA040u8[0][i].TransferTime =  mappedOD->EntryA040u8[1][i].TransferTime =  mappedOD->EntryA040u8[2][i].TransferTime =  mappedOD->EntryA040u8[3][i].TransferTime =  INT32_MIN;
      mappedOD->EntryA080b[0][i].TransferTime =   mappedOD->EntryA080b[1][i].TransferTime =   mappedOD->EntryA080b[2][i].TransferTime =   mappedOD->EntryA080b[3][i].TransferTime =   INT32_MIN;
      mappedOD->EntryA0C0i16[0][i].TransferTime = mappedOD->EntryA0C0i16[1][i].TransferTime = mappedOD->EntryA0C0i16[2][i].TransferTime = mappedOD->EntryA0C0i16[3][i].TransferTime = INT32_MIN;
      mappedOD->EntryA100u16[0][i].TransferTime = mappedOD->EntryA100u16[1][i].TransferTime = mappedOD->EntryA100u16[2][i].TransferTime = mappedOD->EntryA100u16[3][i].TransferTime = INT32_MIN;
      mappedOD->EntryA140i24[0][i].TransferTime = mappedOD->EntryA140i24[1][i].TransferTime = mappedOD->EntryA140i24[2][i].TransferTime = mappedOD->EntryA140i24[3][i].TransferTime = INT32_MIN;
      mappedOD->EntryA180u24[0][i].TransferTime = mappedOD->EntryA180u24[1][i].TransferTime = mappedOD->EntryA180u24[2][i].TransferTime = mappedOD->EntryA180u24[3][i].TransferTime = INT32_MIN;
      mappedOD->EntryA1C0i32[0][i].TransferTime = mappedOD->EntryA1C0i32[1][i].TransferTime = mappedOD->EntryA1C0i32[2][i].TransferTime = mappedOD->EntryA1C0i32[3][i].TransferTime = INT32_MIN;
      mappedOD->EntryA240f[0][i].TransferTime =   mappedOD->EntryA240f[1][i].TransferTime =   mappedOD->EntryA240f[2][i].TransferTime =   mappedOD->EntryA240f[3][i].TransferTime =   INT32_MIN;
      mappedOD->EntryA480i8[0][i].TransferTime =  mappedOD->EntryA480i8[1][i].TransferTime =  mappedOD->EntryA480i8[2][i].TransferTime =  mappedOD->EntryA480i8[3][i].TransferTime =  INT32_MIN;
      mappedOD->EntryA4C0u8[0][i].TransferTime =  mappedOD->EntryA4C0u8[1][i].TransferTime =  mappedOD->EntryA4C0u8[2][i].TransferTime =  mappedOD->EntryA4C0u8[3][i].TransferTime =  INT32_MIN;
      mappedOD->EntryA500b[0][i].TransferTime =   mappedOD->EntryA500b[1][i].TransferTime =   mappedOD->EntryA500b[2][i].TransferTime =   mappedOD->EntryA500b[3][i].TransferTime =   INT32_MIN;
      mappedOD->EntryA540i16[0][i].TransferTime = mappedOD->EntryA540i16[1][i].TransferTime = mappedOD->EntryA540i16[2][i].TransferTime = mappedOD->EntryA540i16[3][i].TransferTime = INT32_MIN;
      mappedOD->EntryA580u16[0][i].TransferTime = mappedOD->EntryA580u16[1][i].TransferTime = mappedOD->EntryA580u16[2][i].TransferTime = mappedOD->EntryA580u16[3][i].TransferTime = INT32_MIN;
      mappedOD->EntryA5C0i24[0][i].TransferTime = mappedOD->EntryA5C0i24[1][i].TransferTime = mappedOD->EntryA5C0i24[2][i].TransferTime = mappedOD->EntryA5C0i24[3][i].TransferTime = INT32_MIN;
      mappedOD->EntryA600u24[0][i].TransferTime = mappedOD->EntryA600u24[1][i].TransferTime = mappedOD->EntryA600u24[2][i].TransferTime = mappedOD->EntryA600u24[3][i].TransferTime = INT32_MIN;
      mappedOD->EntryA640i32[0][i].TransferTime = mappedOD->EntryA640i32[1][i].TransferTime = mappedOD->EntryA640i32[2][i].TransferTime = mappedOD->EntryA640i32[3][i].TransferTime = INT32_MIN;
      mappedOD->EntryA6C0f[0][i].TransferTime =   mappedOD->EntryA6C0f[1][i].TransferTime =   mappedOD->EntryA6C0f[2][i].TransferTime =   mappedOD->EntryA6C0f[3][i].TransferTime =   INT32_MIN;
   }
}


void GetEntry(uint16_t i, uint8_t si, uint8_t *st, int *dl, char **d) {
   OdEntry *Ode;
   int se;

   GetProcEntry(i, si, st, dl, &Ode, &se);
   if (Ode != NULL) {
      *d = (char *)(&(Ode->Data));
      return;
   }
   // communication profile
   *d = NULL;
   if (i == 0x1000 && si == 0x0) {*dl = 32; *st = READ; *d = (char *)&DeviceType; return;}
   if (i == 0x1001 && si == 0x0) {*dl = 8; *st = READ; *d = &errorRegister; return;}
   if (i == 0x1002 && si == 0x0) {*dl = 32; *st = READ; *d = (char *)&ManufStatReg; return;}
   if (i == 0x1003 && si == 0x0) {*dl = 8; *st = READ | WRITE ; *d = (char *)&PreDefErrorNo; return;}
   if (i == 0x1003 && si <= PreDefErrorNo) 
      {*dl = 32; *st = READ; *d = (char *)&(PreDefError[(si - 1 + emcyin) % 254]); return;}
   if (i == 0x1005 && si == 0x0) {*dl = 32; *st = READ | WRITE; *d = (char *)&syncCob; return;}
   if (i == 0x1006 && si == 0x0) {*dl = 32; *st = READ | WRITE; *d = (char *)&comCycleTime; return;}
   if (i == 0x1007 && si == 0x0) {*dl = 32; *st = READ; *d = (char *)&syncWindowLen; return;}

   if (i == 0x1008 && si == 0x0) {*dl = strlen(ManufDevName) * 8; *st = READ; *d = (char *)ManufDevName; return;}
   if (i == 0x1009 && si == 0x0) {*dl = strlen(ManufHwVers) * 8; *st = READ; *d = (char *)ManufHwVers; return;}
   if (i == 0x100A && si == 0x0) {*dl = strlen(ManufSwVers) * 8; *st = READ; *d = (char *)ManufSwVers; return;}

   if (i == 0x100C && si == 0x0) {*dl = 16; *st = READ | WRITE; *d = (char *)&GrdTime; return;}
   if (i == 0x100D && si == 0x0) {*dl = 8; *st = READ | WRITE; *d = (char *)&lifetime; return;}

   if (i == 0x1012 && si == 0x0) {*dl = 32; *st = READ | WRITE; *d = (char *)&timeCobid; return;}
   if (i == 0x1014 && si == 0x0) {*dl = 32; *st = READ | WRITE; *d = (char *)&emcyCob; return;}
   if (i == 0x1015 && si == 0x0) {*dl = 16; *st = READ | WRITE; *d = (char *)&emcyInhibit; return;}
   if (i == 0x1016 && si == 0x0) {*dl = 8; *st = READ; *d = (char *)&no127; return;}
   if (i == 0x1016 && si <= 127) {*dl = 32; *st = READ | WRITE; *d = (char *)&(ConsumerHBtime[si-1]); return;}
   if (i == 0x1017 && si == 0x0) {*dl = 16; *st = READ | WRITE; *d = (char *)&HBtime; return;}

   if (i == 0x1018 && si == 0x0) {*dl = 8; *st = READ; *d = (char *)&no3; return;}
   if (i == 0x1018 && si == 0x1) {*dl = 32; *st = READ; *d = (char *)&VendorId; return;}
   if (i == 0x1018 && si == 0x2) {*dl = 32; *st = READ; *d = (char *)&ProductCode; return;}
   if (i == 0x1018 && si == 0x3) {*dl = 32; *st = READ; *d = (char *)&RevisionNo; return;}

   if (0x1200 <= i && i < 0x1200 + SSDONO) {
      if (si == 0) {*dl = 8; *st = READ; *d = (char *)&no2; return;}
      if (si == 1) {
         *dl = 32; *st = (i == 0x1200) ? READ : (READ | WRITE); 
         *d = (char *)&(ServerSdo[i - 0x1200].Client2Server); return;
      }
      if (si == 2) {
         *dl = 32; *st = (i == 0x1200) ? READ : (READ | WRITE); 
         *d = (char *)&(ServerSdo[i - 0x1200].Server2Client); return;
      }
   }

   if (0x1280 <= i && i < 0x1280 + CSDONO) {
      if (si == 0) {*dl = 8; *st = READ; *d = (char *)&no3; return;}
      if (si == 1) {*dl = 32; *st = READ | WRITE; *d = (char *)&(ClientSdo[i - 0x1280].Client2Server); return;}
      if (si == 2) {*dl = 32; *st = READ | WRITE; *d = (char *)&(ClientSdo[i - 0x1280].Server2Client); return;}
      if (si == 3) {*dl = 8; *st = READ | WRITE; *d = &(ClientSdo[i - 0x1280].nodeId); return;}
   }

   if (0x1400 <= i && i < 0x1400 + RPDONO) {
      if (si == 0) {*dl = 8; *st = READ; *d = (char *)&no2; return;}
      if (si == 1) {*dl = 32; *st = READ | WRITE; *d = (char *)&(RPDO[i - 0x1400].cobid); return;}
      if (si == 2) {*dl = 8; *st = READ | WRITE; *d = (char *)&(RPDO[i - 0x1400].xmitTy); return;}
   }

   if (0x1600 <= i && i <= 0x1600 + RPDONO) {
      if (si == 0) {*dl = 8; *st = READ | WRITE; *d = (char *)&(RPdoMapping[i - 0x1600].no); return;}
      if (si <= 0x40) {
         *dl = 32; *st = READ | WRITE; *d = (char *)&(RPdoMapping[i - 0x1600].entry[si - 1]); return;
      }
   }

   if (0x1800 <= i && i < 0x1800 + TPDONO) {
      if (si == 0) {*dl = 8; *st = READ; *d = (char *)&no5; return;}
      if (si == 1) {*dl = 32; *st = READ | WRITE; *d = (char *)&(TPDO[i - 0x1800].cobid); return;}
      if (si == 2) {*dl = 8; *st = READ | WRITE; *d = (char *)&(TPDO[i - 0x1800].xmitTy); return;}
      if (si == 3) {*dl = 16; *st = READ | WRITE; *d = (char *)&(TPDO[i - 0x1800].inhibitTime); return;}
      if (si == 5) {*dl = 16; *st = READ | WRITE; *d = (char *)&(TPDO[i - 0x1800].eventTimer); return;}
   }

   if (0x1A00 <= i && i <= 0x1A00 + TPDONO) {
      if (si == 0) {*dl = 8; *st = READ | WRITE; *d = (char *)&(TPdoMapping[i - 0x1A00].no); return;}
      if (si <= 0x40) {
         *dl = 32; *st = READ | WRITE; *d = (char *) &(TPdoMapping[i - 0x1A00].entry[si - 1]); return;
      }
   }

   if (i == 0x1028 && si == 0x0) {*dl = 8; *st = READ; *d = (char *)&no127; return;}
   if (i == 0x1028 && si <= 127) {
      *dl = 32; *st = READ | WRITE; *d = (char *)&(consumedEmcy[si-1].emcyCob); return;
   }
   
   // DSP302 entries
   if (i == 0x1F22 && si == 0x0) {*dl = 8; *st = READ; *d = (char *)&no127; return;}
   if (i == 0x1F22 && si <= 127) {*dl = -1; *st = READ; *d = SlaveOd[si - 1]; return;}
   if (i == 0x1F53 && si == 0x0) {*dl = 8; *st = READ; *d = (char *)&no127; return;}
   if (i == 0x1F53 && si <= 127) {*dl = 32; *st = READ; *d = (char *) &(ExpAppSwDate[si - 1]); return;}
   if (i == 0x1F54 && si == 0x0) {*dl = 8; *st = READ; *d = (char *)&no127; return;}
   if (i == 0x1F54 && si <= 127) {*dl = 32; *st = READ; *d = (char *) &(ExpAppSwTime[si - 1]); return;}

   if (i == 0x1F80 && si == 0x0) {*dl = 32; *st = READ | WRITE;  *d = (char *) &NMTStartup; return;}
   if (i == 0x1F81 && si == 0x0) {*dl = 8; *st = READ; *d = (char *)&no127; return;}
   if (i == 0x1F81 && si <= 127) {*dl = 32; *st = READ; *d = (char *) &(SlaveAssignment[si - 1]); return;}
   if (i == 0x1F84 && si == 0x0) {*dl = 8; *st = READ; *d = (char *)&no127; return;}
   if (i == 0x1F84 && si <= 127) {*dl = 32; *st = READ; *d = (char *) &(DevTypeId[si - 1]); return;}
   if (i == 0x1F85 && si == 0x0) {*dl = 8; *st = READ; *d = (char *)&no127; return;}
   if (i == 0x1F85 && si <= 127) {*dl = 32; *st = READ; *d = (char *) &(Entry1F85_1F88[0][si - 1]); return;}
   if (i == 0x1F86 && si == 0x0) {*dl = 8; *st = READ; *d = (char *)&no127; return;}
   if (i == 0x1F86 && si <= 127) {*dl = 32; *st = READ; *d = (char *) &(Entry1F85_1F88[1][si - 1]); return;}
   if (i == 0x1F87 && si == 0x0) {*dl = 8; *st = READ; *d = (char *)&no127; return;}
   if (i == 0x1F87 && si <= 127) {*dl = 32; *st = READ; *d = (char *) &(Entry1F85_1F88[2][si - 1]); return;}
   if (i == 0x1F88 && si == 0x0) {*dl = 8; *st = READ; *d = (char *)&no127; return;}
   if (i == 0x1F88 && si <= 127) {*dl = 32; *st = READ; *d = (char *) &(Entry1F85_1F88[3][si - 1]); return;}
   if (i == 0x1F89 && si == 0x0) {*dl = 32; *st = READ | WRITE; *d = (char *)&BootTime; return;}
}

uint32_t CheckSdoDwnld(SdoTy *sdo) {
   uint8_t st;
   int datalen;
   char *data;

   GetEntry(sdo->idx, sdo->subidx, &st, &datalen, &data);
   if (NmtState != preop && (sdo->idx != 0x1003 || sdo->subidx != 0)) return SDONOSTORSTATE;
   if (data == NULL) return SDONOOBJECT;
   if (sdo->datalen != (datalen + 7) / 8) return SDOLENERR;

   sdo->data = data;

   if (sdo->idx == 0x1003 && sdo->subidx == 0) {   // predefined error field
      if (emcyin != emcyout) return SDONOSTORELOC;   // there are still unreported EMCYs, don't delete them!

      emcyin = emcyout = PreDefErrorNo = 0;
      sdo->data = (char *)&dummy;
      return 0;
   }

   if (sdo->idx == 0x1005) DeleteMob(syncCob);
   else if (sdo->idx == 0x1012) DeleteMob(timeCobid);
   else if (sdo->idx == 0x1014) StopEmcy();
   else if (sdo->idx == 0x1016 && sdo->subidx > 0 && ConsumerHBtime[sdo->subidx - 1].id != 0) {
      take_lock();
      ConsumerHBtime[sdo->subidx - 1].HBtime = 0;
      DeleteMob(1792 + ConsumerHBtime[sdo->subidx - 1].id);
      RemoteNode[ConsumerHBtime[sdo->subidx - 1].id - 1].CHBtimeIdx = 128;
      RemoteNode[ConsumerHBtime[sdo->subidx - 1].id - 1].errorctrl &= ~errorctrlon;
      release_lock();
   } else if (0x1200 <= sdo->idx && sdo->idx < 0x1200 + SSDONO && sdo->subidx == 1) 
      DeleteMob(ServerSdo[sdo->idx - 0x1200].Client2Server);
   else if (0x1200 <= sdo->idx && sdo->idx < 0x1200 + SSDONO && sdo->subidx == 2) 
      DeleteMob(ServerSdo[sdo->idx - 0x1200].Server2Client);
//   else if (0x1280 <= sdo->idx && sdo->idx < 0x1280 + CSDONO && sdo->subidx == 1)    // ClientSdo's are inactive for NMT clients 
//      DeleteMob(ClientSdo[sdo->idx - 0x1280].Client2Server);
//   else if (0x1280 <= sdo->idx && sdo->idx < 0x1280 + CSDONO && sdo->subidx == 2) 
//      DeleteMob(ClientSdo[sdo->idx - 0x1280].Server2Client);
   else if (0x1400 <= sdo->idx && sdo->idx < 0x1400 + RPDONO && sdo->subidx == 1)
       DeleteMob(RPDO[sdo->idx - 0x1400].cobid);
   else if (0x1800 <= sdo->idx && sdo->idx < 0x1800 + TPDONO && sdo->subidx == 1)
       DeleteMob(TPDO[sdo->idx - 0x1800].cobid);
   else if (sdo->idx == 0x1028 && sdo->subidx <= 127) return SDONOWRITE;

   return 0;
}

uint32_t CheckSdoUpld(SdoTy *sdo) {   // enters datalength and data
   uint8_t st;
   int datalen;
   char *data;

   GetEntry(sdo->idx, sdo->subidx, &st, &datalen, &data);
   if (data == NULL) return SDONOOBJECT;
   sdo->data = data;
   sdo->datalen = (datalen + 7) / 8; // convert to length in bytes
   return 0;
}

static uint32_t VerifyPdoMapping(PdoMapping  *m, uint8_t subidx) {
   int no;
   if (subidx == 0) {
      if ((no = m->no) != 0) {
         int i, l = 0;
         for (i = 0; i < no; i++) l += m->entry[i].length;
         if (l > 64) return SDOMAPTOOLNG;
         m->bitsize = l;
      }
      return 0;
   } else {
      uint8_t st;
      int datalen;
      char *data;

      GetEntry(m->entry[subidx-1].index, m->entry[subidx-1].subindex, &st, &datalen, &data);

      if (data == NULL) return SDONOOBJECT;
      if (!(st & PDOMAPABLE)) return SDONOMAPPDO;
      if (datalen != m->entry[subidx-1].length) return SDONOMAPPDO;
      return 0;
   }
}

uint32_t ServerSdoIndication(struct SdoStruct *sdo, uint32_t result) {
   if (result != 0) return result;

   if (sdo->idx == 0x1012) StartTimeApplication();
   if (sdo->idx == 0x1005) {
      syncCob &= 0x7FFFFFFF;
      if (syncCob & 0x40000000) {
         StartSyncProducer();
      } else {
          StartSyncConsumer(); 
      }
   }

   if (sdo->idx == 0x1016) {
      if (ConsumerHBtime[sdo->subidx - 1].id == 0) return 0;   // no node configured
      if (RemoteNode[ConsumerHBtime[sdo->subidx - 1].id - 1].CHBtimeIdx != 128) return 0x06040043;
      RemoteNode[ConsumerHBtime[sdo->subidx - 1].id - 1].CHBtimeIdx = sdo->subidx - 1;
      ConsumeHeartBeat(&(ConsumerHBtime[sdo->subidx - 1]));
      return 0;      
   }
   if (0x1600 <= sdo->idx && sdo->idx < 0x1600 + RPDONO)
      return VerifyPdoMapping(&(RPdoMapping[sdo->idx - 0x1600]), sdo->subidx);
   if (0x1A00 <= sdo->idx && sdo->idx < 0x1A00 + TPDONO)
      return VerifyPdoMapping(&(TPdoMapping[sdo->idx - 0x1A00]), sdo->subidx);
   if (sdo->idx == 0x1017 && HBtime != 0) StartHeartBeat();
   else if (sdo->idx == 0x1014) SetupEmcy();

   return 0;
}

void SetupCommParameters() {
   int i;

   syncCob = 0x80; 
   comCycleTime = 1; 
   syncWindowLen = 1; 
   GrdTime = 0;
   lifetime = 0;
   timeCobid = 0x100;
   emcyCob = 0x80 + NmtId;
   emcyInhibit = 0;

   for (i = 0; i < 127; i++) {ConsumerHBtime[i].HBtime = 0; ConsumerHBtime[i].id = 0;}
   HBtime = 0;
   for (i = 0; i < 127; i++) RemoteNode[i].CHBtimeIdx = 128;

   ServerSdo[0].Client2Server = 0x600 + NmtId; 
   ServerSdo[0].Server2Client = 0x580 + NmtId;
   SetupServerSdo(0);

   for (i = 1; i < SSDONO; i++) {
      ServerSdo[i].Client2Server = 0x80000000;
      ServerSdo[i].Server2Client = 0x80000000;
      SetupServerSdo(i);
   }
   
   for (i = 0; i < CSDONO; i++) {
      ClientSdo[i].Client2Server = 0x601 + i;
      ClientSdo[i].Server2Client = 0x581 + i;
      ClientSdo[i].nodeId = i + 1;
      RemoteNode[i].clSdo = ClientSdo + i;
   }

   for (i = 0; i < RPDONO; i++) {
      // RPDO Communication Parameters
      RPDO[i].cobid = (i < 4) ? (i * 0x100) + 0x200 + NmtId  : 0x80000000; 
      RPDO[i].xmitTy = 0xff;
      RPdoMapping[i].no = 0;
   }

   for (i = 0; i < TPDONO; i++) {
      TPDO[i].cobid = (i < 4) ? (i * 0x100) + 0x180 + NmtId  : 0x80000000; 
      TPDO[i].xmitTy = 0xfe;
      TPDO[i].inhibitTime = 0;
      TPDO[i].eventTimer = 0;
      TPdoMapping[i].no = 0;
   }

   for (i = 0; i < 127; i++) consumedEmcy[i].emcyCob = (i != NmtId - 1) ? 0x81 + i : 0x80000000;

   // DSP302 entries
   NMTStartup = 0;

   for (i = 0; i < 127; i++) {
      SlaveOd[i] = NULL;
      SlaveAssignment[i] = 0;
      DevTypeId[i] = 0;
      Entry1F85_1F88[0][i] = Entry1F85_1F88[1][i] = Entry1F85_1F88[2][i] = Entry1F85_1F88[3][i] = 0; 
   }
}

void InitObjectDictionary(int32_t nmtId, uint8_t *concise) {
   uint32_t no, i, j, lngth;
   uint16_t idx;
   uint8_t subidx, st;
   uint32_t size;
   char  *data;
   int dl, k;

   while(concise[0] == 'M' && concise[1] == 'A') {
      // printf("node\n");   
      concise += 2;
      lngth = (uint16_t)(concise[0]) | ((uint16_t)(concise[1]) << 8);
      subidx = concise[4];

      concise += 6;
      if (subidx == nmtId) {
         no = (uint32_t)(concise[0]) | ((uint32_t)(concise[1]) << 8) |
             ((uint32_t)(concise[2]) << 16) | ((uint32_t)(concise[2]) << 24);
         concise += 4;
         for (i = 0; i < no; i++) {
            idx = (uint16_t)(concise[0]) | ((uint16_t)(concise[1]) << 8);
            subidx = concise[2];
            concise += 3;
            size = (uint32_t)(concise[0]) | ((uint32_t)(concise[1]) << 8) |
                  (uint32_t)(concise[2]  << 16) | (uint32_t)(concise[3] << 24);
            concise += 4;
            // printf("index = %x, subindex = %x, size = %d\n", idx, subidx, size); 
            if (idx == 0x1F22) 
               SlaveOd[subidx - 1] = concise;
            else {
               GetEntry(idx, subidx, &st, &dl, &data);
               if (data != NULL) for (j = 0; j < size; j++) data[j] = concise[j];
            }
            concise += size;
         }
      } else {
         SlaveOd[subidx - 1] = concise;
         concise += lngth;
      }
   }

   for (k = 0; k < 127; k++) {
      if (ConsumerHBtime[k].HBtime != 0 && ConsumerHBtime[k].id != 0 && ConsumerHBtime[k].id <= 0x7F) 
         RemoteNode[ConsumerHBtime[k].id - 1].CHBtimeIdx = k;
   }
}

