// CanOpen, Technikum Joanneum GmbH
// Peter Hintenaus
// December 2000
// Definitions for the Object dicitonary.
//
//	Change history:

#ifndef __objdict__
#define __objdict__

#include <stdio.h>
#include <stdint.h>
#include "ComObj.h"

#define PDOMAPABLE   0x10
#define WRITE  		0x20
#define READ	   	0x40

typedef struct {
   int32_t MilliSeconds, Days;
} TimeOfDay;

typedef struct {
   int32_t TransferTime, Data;
} OdEntry; 

typedef struct {
   // to be mapped to TPDO's
   OdEntry EntryA000i8[4][254];
   OdEntry EntryA040u8[4][254];
   OdEntry EntryA080b[4][254];
   OdEntry EntryA0C0i16[4][254];
   OdEntry EntryA100u16[4][254];
   OdEntry EntryA140i24[4][254];
   OdEntry EntryA180u24[4][254];
   OdEntry EntryA1C0i32[4][254];
   OdEntry EntryA240f[4][254];
   // to be mapped to RPOD's
   OdEntry EntryA480i8[4][254];
   OdEntry EntryA4C0u8[4][254];
   OdEntry EntryA500b[4][254];
   OdEntry EntryA540i16[4][254];
   OdEntry EntryA580u16[4][254];
   OdEntry EntryA5C0i24[4][254];
   OdEntry EntryA600u24[4][254];
   OdEntry EntryA640i32[4][254];
   OdEntry EntryA6C0f[4][254];
} ProcessOD;

extern ProcessOD *mappedOD;

void initProcessOD(void);

void GetGuardingParams(uint8_t nodeid, uint8_t *retry, uint16_t *guardtime);

void GetProcEntry(uint16_t i, uint8_t si, uint8_t *st, int *dl, OdEntry **d, int *sgnxtnd);

void GetEntry(uint16_t idx, uint8_t subidx, uint8_t *state, int *datalen, char **dat);

uint32_t CheckSdoDwnld(SdoTy *sdo);

uint32_t CheckSdoUpld(SdoTy *sdo);	// enters datalength and data

uint32_t ServerSdoIndication(struct SdoStruct *sdo, uint32_t result);

void SetupCommParameters();

void InitObjectDictionary(int32_t, uint8_t *);

#endif
