#ifndef __NMT__
#define __NMT__

#include <stdint.h>
#include <pthread.h>
#include "../vm/vm.h"
#include "ComObj.h"
#include "Event.h"

typedef enum {
   dead = -2,
   unknown = -1,
   boot = 0, 
   stopped = 4,
   operational = 5,
   preop = 127
} NmtStateTy;

typedef enum {
   keepWrkng,
   resetAppl,
   resetApplNStp,
   resetCom,
   enterPreop
} StateCngCmdTy;
   

extern NmtStateTy NmtState;
extern uint8_t NmtId;

typedef struct {
   uint16_t HBtime;
   uint8_t id;
   uint8_t dummy;
} ConsumerHBtimeTy;

typedef struct {
   uint16_t CHBtimeIdx;
   uint8_t errorctrl;
   uint8_t guardretry;   
   NmtStateTy state;
   MobIdTy errorctrlMob;
   EventTy event;
   SdoTy *clSdo;
   int inBoot;
} RemoteNodeTy;

#define togglemsk 0x80
#define usrmsk 0x40
#define statechngdmsk 0x20
#define guardrcvd 0x10
#define bootedmsk 0x08
#define errorindmsk 0x04
#define guardingmsk 0x02
#define errorctrlon 0x01

extern RemoteNodeTy RemoteNode[127];
extern ConsumerHBtimeTy ConsumerHBtime[127];

// DSP 302 Entries

extern uint32_t NMTStartup, BootTime;
extern uint8_t *SlaveOd[127];
extern uint32_t ExpAppSwDate[127], ExpAppSwTime[127], SlaveAssignment[127];
extern uint32_t DevTypeId[127], Entry1F85_1F88[4][127];

extern pthread_attr_t nmtAttrs;

void initNmtEvents();

void InitNmt(int master, void (*)(NmtStateTy, StateCngCmdTy));

int IsNmtMaster();

void Bootup();

extern uint16_t HBtime;

void StartHeartBeat();

extern vm *LifeTimeTask;
extern vm *RemoteErrorControlTask;
extern vm *bootedTask;

void SetupGuarding(void);

void StopErrorControl();

void StopECConsumer();

// master procedures

void StartRemoteNode(uint8_t nodeId);

void StopRemoteNode(uint8_t nodeId);

void EnterPreOp(uint8_t nodeId);

void ResetNode(uint8_t nodeId);

void ResetCom(uint8_t nodeId);

void StartGuarding(uint8_t nodeId);

void ConsumeHeartBeat(ConsumerHBtimeTy *CHBtime);

NmtStateTy GetRemoteNodeState(uint8_t nodeId);

void BootNetwork(void);


#endif
