#ifndef __MCP2515__
#define __MCP2515__

#include <pthread.h>
#include <stdint.h>
#include <sys/ioctl.h>

#define SPICAN_IOC_MAGIC 'k'

#define SPICAN_IOCRESET _IO(SPICAN_IOC_MAGIC, 0)
#define SPICAN_SETBAUD _IOR(SPICAN_IOC_MAGIC, 3, char)

typedef struct mcp2515_chip_st {
   int can_fd;
   pthread_t isr_thread;
   pthread_attr_t isr_attr;
} mcp2515_chip;

extern mcp2515_chip *hw;

int mcp_init(const char* can_dev);
void mcp_setbaud(uint32_t baud);
int mcp_start(void* (*isr)(void*));
void mcp_close(void);

#endif
