package app;

public class ComplexNumber {

	private float realPart, imagPart;
	
	public ComplexNumber(float real, float imag){
		realPart = real;
		imagPart = imag;
	}
	
	public ComplexNumber multiply(ComplexNumber anotherNumber){
		return new ComplexNumber((this.realPart*anotherNumber.realPart - this.imagPart*anotherNumber.imagPart),
				(this.realPart*anotherNumber.imagPart + this.imagPart*anotherNumber.realPart));
	}
	
	public ComplexNumber add(ComplexNumber anotherNumber){
		return new ComplexNumber((this.realPart + anotherNumber.realPart),(anotherNumber.imagPart + this.imagPart));
	}
	
	public boolean equals (ComplexNumber number){
		return ((this.realPart == number.realPart) && (this.imagPart == number.imagPart));
	}
	
	public String toString(){
		return new String ("(" + this.realPart + ", " + this.imagPart + ")");
	}
}
