package test;

import java.util.Arrays;
import java.util.Collection;

import app.ComplexNumber;
import org.junit.*;
import static org.junit.Assert.*;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;
import org.junit.runner.RunWith;

@RunWith(Parameterized.class) 
public class ComplexTestParam {

	private ComplexNumber fZeroOne;   
	private ComplexNumber expectedResult;
	private ComplexNumber secondTerm;
	
	public ComplexTestParam(ComplexNumber expected, ComplexNumber secondTerm) {
		this.expectedResult = expected;
		this.secondTerm = secondTerm;
		fZeroOne = new ComplexNumber(0, 1);
	}
	@Parameters
    public static Collection<Object[]> generateInputs() {
		return Arrays.asList(new Object[][]{
		{new ComplexNumber(-1,0), new ComplexNumber(0,1)},
		{new ComplexNumber(1,0), new ComplexNumber(1,0)}	// wrong
		});
	    }
	@Test
    public void testMultiply() {
        ComplexNumber result = fZeroOne.multiply(secondTerm);
        assertTrue("Multiplying " + fZeroOne.toString() + " with " + secondTerm.toString() + " failed with result " + result.toString(), result.equals(expectedResult));
    }
}
