import java.util.*;

public class SimpleSortedList<E extends Comparable<E>> implements SimpleCollection<E> {

	private class Node {

		E data;
		Node next;

		Node() {
		}
		
		Node(E data, Node next) {
			this.data = data;
			this.next = next;
		}
	}

	private Node start = null;
	private int size = 0;

	public SimpleSortedList() {
		start = new Node();
	}

	/* returns the node before the position where e should be inserted. */
	private Node getPrevNode(E element) {
		Node current = start;
		while (current.next != null && current.next.data.compareTo(element) < 0)
			current = current.next;

		return current;
	}

	public boolean add(E element) {
		Node insert = getPrevNode(element);
		insert.next = new Node(element, insert.next);
		size++;
		return true;
	}

	public boolean remove(E element) {
		Node remove = getPrevNode(element);
		if (remove.next != null && remove.next.data.compareTo(element) == 0) {
			size--;
			remove.next = remove.next.next;
			return true;
		}
		return false;
	}
	
	public Iterator<E> iterator() {
		return new SimpleSortedListIterator();
	}
	
	private class SimpleSortedListIterator implements Iterator<E> {
		private Node n = start;

		public boolean hasNext() {
			return n.next != null;
		}

		public E next() {
		    if (hasNext()){
				n = n.next;
				return n.data;
			} else {
				throw new NoSuchElementException();
			}
		}

		public void remove() {
		  throw new UnsupportedOperationException();
		}
	}
}
