import java.util.*;

public class SimpleSortedList implements SimpleCollection {

	private class Node {

		Object data;
		Node next;

		Node() {
		}
		
		Node(Object data, Node next) {
			this.data = data;
			this.next = next;
		}
	}

	private Node start = null;
	private int size = 0;

	public SimpleSortedList() {
		start = new Node();
	}

	/* returns the node before the position where e should be inserted. */
	private Node getPrevNode(Object element) {
		Node current = start;
		while (current.next != null && ((Comparable)current.next.data).compareTo((Comparable)element) < 0)
			current = current.next;

		return current;
	}

	public boolean add(Object element) {
		Node insert = getPrevNode(element);
		insert.next = new Node(element, insert.next);
		size++;
		return true;
	}

	public boolean remove(Object element) {
		Node remove = getPrevNode(element);
		if (remove.next != null && ((Comparable)remove.next.data).compareTo((Comparable)element) == 0) {
			size--;
			remove.next = remove.next.next;
			return true;
		}
		return false;
	}
	
	public Iterator iterator() {
		return new SimpleSortedListIterator();
	}
	
	private class SimpleSortedListIterator implements Iterator {
		private Node n = start;

		public boolean hasNext() {
			return n.next != null;
		}

		public Object next() {
		    if (hasNext()){
				n = n.next;
				return n.data;
			} else {
				throw new NoSuchElementException();
			}
		}

		public void remove() {
		  throw new UnsupportedOperationException();
		}
	}
}
