import java.util.*;

public class SimpleSortedList<T> implements SimpleCollection<T> {

	private class Node {

		T data;
		Node next;

		Node() {
		}
		
		Node(T data, Node next) {
			this.data = data;
			this.next = next;
		}
	}

	private Node start = null;
	private int size = 0;

	public SimpleSortedList() {
		start = new Node();
	}

	/* returns the node before the position where e should be inserted. */
	private Node getPrevNode(T element) {
		Node current = start;
		while (current.next != null && ((Comparable)current.next.data).compareTo((Comparable)element) < 0)
			current = current.next;

		return current;
	}

	public boolean add(T element) {
		Node insert = getPrevNode(element);
		insert.next = new Node(element, insert.next);
		size++;
		return true;
	}

	public boolean remove(T element) {
		Node remove = getPrevNode(element);
		if (remove.next != null && ((Comparable)remove.next.data).compareTo((Comparable)element) == 0) {
			size--;
			remove.next = remove.next.next;
			return true;
		}
		return false;
	}
	
	public Iterator<T> iterator() {
		return new SimpleSortedListIterator();
	}
	
	private class SimpleSortedListIterator implements Iterator<T> {
		private Node n = start;

		public boolean hasNext() {
			return n.next != null;
		}

		public T next() {
		    if (hasNext()){
				n = n.next;
				return n.data;
			} else {
				throw new NoSuchElementException();
			}
		}

		public void remove() {
		  throw new UnsupportedOperationException();
		}
	}
}
