package roboscannerparser;

/**
 *
 * @author wolfgang pree
 */
public class Main {
    private static RoboScanner rScanner;
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        
        rScanner= new RoboScanner(".../TestFile.txt");
        while (!rScanner.eof()) {
            int sym= rScanner.getSym();
            System.out.println("symbol: "+printSym(sym));
        }
        System.out.println("-------------------------------");
        RoboParser rParser= new RoboParser(".../TestFile.txt");
        rParser.checkSyntax();
        System.out.println(rParser.isOK() ? "syntax OK" : "syntax NOT OK");
    }
    public static String printSym(int sym) {
        switch (sym) {
            case 0:
                return "number "+rScanner.getNo();
            case 1:
                return "line";
            case 2:
                return "circle";
            case 3:
                return "end";
            case 4:
                return "(";
            case 5:
                return ")";
            case 6:
                return ",";
            case 7:
                return "+";
            case 8:
                return "-";
            default:
                return "X";
        }
     }
}

