package roboscannerparser;

/**
 *
 * @author wolfgang pree
 */
public class RoboParser {
    private RoboScanner rScanner;
    int sym;
    boolean isOK;

    public RoboParser(String fName) {
        rScanner = new RoboScanner(fName);
        isOK = true;
    }
    private void Robo() {
        Position();
        nextSym();
        while (sym == RoboScanner.number) {
            Move();
            nextSym();
        }
        if (sym != RoboScanner.end)     // E
            error("end marker missing");
    }
    private void Move() {
       if (sym != RoboScanner.number)
            error("Move: no coordinate");
       nextSym();
       switch (sym) {
           case RoboScanner.line:
               nextSym();
               Position();
               break;
           case RoboScanner.circle:
               nextSym();
               Position();
               nextSym();
               Position();
               break;
           default:
               error("Move: neither Line nor Circle specified"); // L or C expected
       }
    }
    private void Position() {
        if (sym != RoboScanner.lparen)     // (
            error("no ( in Position");
        nextSym(); Coordinate();
        nextSym();
        if (sym != RoboScanner.comma)     // ,
            error("no comma in Position");
        nextSym(); Coordinate();
        nextSym();
        if (sym != RoboScanner.comma)     // ,
            error("no comma in Position");
        nextSym(); Coordinate();
        nextSym();
        if (sym != RoboScanner.rparen)     // )
            error("no ) in Position");
    }
    private void Coordinate() {
        if (sym == RoboScanner.plus || sym == RoboScanner.minus) {
            nextSym();
        }   // no error otherwise as +/- is optional
        if (sym != RoboScanner.number)
            error("no coordinate");
    }
    private void nextSym() {
        sym= rScanner.getSym();
    }
    private void error(String msg) {
        isOK = false;
        System.out.println("ERROR: "+msg);
    }
    public void checkSyntax() {
        isOK = true;
        nextSym();
        Robo();
    }
    public boolean isOK() {
        return isOK;
    }
}

