package roboscannerparser;
import java.io.*;
/**
 *
 * @author wolfgang pree
 */
public class RoboScanner {
    private String fileName;
    private FileReader fileReader;
    private char[] charBuf;
    private int noOfCharsInBuf;
    private static final int bufSize = 4096;
    private int nextCharPos;
    public static final int
            number  = 0,
            line    = 1,
            circle  = 2,
            end     = 3,
            lparen  = 4,
            rparen  = 5,
            comma   = 6,
            plus    = 7,
            minus   = 8,
            other   = 9;
    private long numberVal= 0;
    private String numberValStr;
    private char nxtCh;     // scanRestOfNo reads char after number ends
                            //   => nxtChar stores that next char
    private int sym;

    public RoboScanner(String fName) {
        fileName = fName;
        charBuf = new char[bufSize];
        noOfCharsInBuf = 0;
        nxtCh = '@';
        try {
            fileReader = new FileReader(fileName);
            loadCharBuf();
        } catch (Exception e) {
            System.out.println(e);
        }
    }
    public int getSym() {
        char ch;
        if (!eof())
            ch = nextCh();
        else
            return -1;
        switch (ch) {
            case 'L':
                sym = line;
                break;
            case 'C':
                sym = circle;
                break;
            case 'E':
                sym = end;
                break;
            case '(':
                sym = lparen;
                break;
            case ')':
                sym = rparen;
                break;
            case ',':
                sym = comma;
                break;
            case '+':
                sym = plus;
                break;
            case '-':
                sym = minus;
                break;
            default:
                sym = other;
                break;
        }
        if (isDigit(ch)) {
                sym = number;
                numberValStr = Character.toString(ch);
                scanRestOfNo();  // scans for subsequent digits and sets numberVal
        }
        return sym;
    }
    private void scanRestOfNo() {
        char ch = nextCh();
        while (!eof() && isDigit(ch)) {
            numberValStr = numberValStr + ch; // TODO: avoid generation of new string
            ch = nextCh();
        }
        // character after end of number was also read => store that char in nxtCh
        nxtCh = ch;
        numberVal = Long.parseLong(numberValStr);
    }
    private boolean isDigit(char ch) {
        switch (ch) {
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
                return true;
            default:
                return false;
        }
    }
    public long getNo() {
        return numberVal;
    }
    private char nextCh() {
        /*
         If a number is read, the next character after the number is also
         read and stored in nxtCh. If a character different from '@' is
         stored in nxtCh, that one is returned and the value of nxtCh is
         reset to '@'.
         character '@' is not allowed in the text
         */
        if (nxtCh != '@') {
            char c = nxtCh;
            nxtCh = '@';
            return c;
        }
        // skip blanks, as well as LF, NL, and tab characters
        while (!eof() &&
               (charBuf[nextCharPos]==' '  ||
                charBuf[nextCharPos]=='\t' ||
                charBuf[nextCharPos]=='\n' ||
                charBuf[nextCharPos]=='\r'
               ) )
            nextCharPos++;
        if (!eof()) {
            char c= charBuf[nextCharPos];
            nextCharPos++;
            return c;
        } else
            return '$';
    }
    private void loadCharBuf() {
        try {
            noOfCharsInBuf = fileReader.read(charBuf);
        } catch (Exception e) {
            System.out.println(e);
        }
        //System.out.println("noOfChars in buffer "+noOfCharsInBuf);
        nextCharPos = 0;
    }
    public boolean eof() {
        if (noOfCharsInBuf == -1)
            return true;
        if (nxtCh != '@')
            return false;
        boolean endOfBufReached= (nextCharPos > noOfCharsInBuf-1);
        if (endOfBufReached) {
            loadCharBuf();
            if (noOfCharsInBuf == -1)
                return true;
            nextCharPos = 0;
        }
        return false;
    }
}


