#include <stdio.h>
#include "lock.h"

/* These are all placeholders for now */
static pthread_mutexattr_t mta;
static pthread_mutex_t global_mutex;

void init_lock() {
   int r;
   if (r = pthread_mutexattr_init(&mta)) fprintf(stderr, "error %d initing mutexattr\n", r);      
   if (r = pthread_mutexattr_settype(&mta, PTHREAD_MUTEX_RECURSIVE)) fprintf(stderr, "error %d setting mutexattr RECURSIVE\n", r);
   if (r = pthread_mutex_init(&global_mutex, &mta)) fprintf(stderr, "error %d initing global mutex\n", r);
}

void take_lock() {
   pthread_mutex_lock (&global_mutex);     
   // printf("got lock %x\n", pthread_self());
}

int test_take_lock() {
   return pthread_mutex_lock (&global_mutex);
}

void release_lock() {
   // printf("releasing lock %x\n", pthread_self());
   pthread_mutex_unlock (&global_mutex);   
}

void destroy_lock() {
   pthread_mutex_destroy(&global_mutex);
}

