#ifndef __MCP2515__
#define __MCP2515__

#include <pthread.h>
#include <sched.h>
#include <stdint.h>
#include <sys/ioctl.h>

#define SPICAN_IOC_MAGIC 'k'

#define SPICAN_IOCRESET _IO(SPICAN_IOC_MAGIC, 0)
#define SPICAN_SETBAUD _IOR(SPICAN_IOC_MAGIC, 3, char)

// definitions for msg status, byte 0 in a msg.
#define REMOTE_FRAME 0x1
#define RX_OVR_RN 0x2
#define WARN 0x4
#define BUS_OFF 0x8
#define OK 0x10
#define TX_ACK 0x20
#define NO_MSG 0x80

typedef struct mcp2515_chip_st {
   int can_fd;
   pthread_t isr_thread;
   pthread_attr_t isr_attr;
   struct sched_param sp;
} mcp2515_chip;

extern mcp2515_chip *hw;

int mcp_init(const char* can_dev);
void mcp_setbaud(uint32_t baud);
int mcp_start(void* (*isr)(void*));
void mcp_close(void);
void mcp_reset(void);

#endif
