#include <stdint.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/types.h>
#include <pthread.h>
#include <sched.h>

#include "mcp2515.h"
#include "Priorities.h"

// #define DEBUG

static void pabort(const char *s) {
   perror(s);
   abort();
}

mcp2515_chip *hw = NULL;

int mcp_init(const char* can_dev) {
   int ret = 0;

   if(hw != NULL) pabort("mcp2515_chip already malloced");
   hw = malloc(sizeof(mcp2515_chip));
   if(hw == NULL) pabort("can't malloc mcp2515_chip");

   hw->can_fd = open(can_dev, O_RDWR);
   if (hw->can_fd < 0) pabort("can't open can device");

   ioctl(hw->can_fd, SPICAN_IOCRESET);
   return ret;
}

void mcp_setbaud(uint32_t baud) {
   uint8_t cnf[3];

   // Default setting for Fosc = 20 MHz
   // Tosc = 50 ns
   // Baudrate = 125 kHz
   // BRP = 500 ns = 2 * (0x4 + 1) * Tosc
   // Tq = 16 * BRP
   // SJW = 0x1 * TQ
   // PRSEG = (0x1 + 1) * TQ 
   // PS1 = 7 * TQ
   // PS2 = 6 * TQ
   // Baudrate = 1000 kHz
   // BRP = 100 ns = 2 * (0 + 1) * Tosc
   // Tq = 10 * BRP
   // SJW = 1 * TQ
   // PRSEG = (1 + 1) * TQ
   // PS1 = (3 + 1) * TQ
   // PS2 = (2 + 1) * TQ
   if (baud == 1000) {
      cnf[2] = 0x82;
      cnf[1] = 0x99;
      cnf[0] = 0x00;

   } else if (baud == 125) {
      cnf[2] = 0x85;
      cnf[1] = 0xB1;
      cnf[0] = 0x04;
   }
   ioctl(hw->can_fd, SPICAN_SETBAUD, cnf);
}

int mcp_start(void* (*isr)(void*)) {
   uint8_t my_buf[2];   
   int iret;
   struct sched_param sp;   

   sp.sched_priority = CANOPENISRP;
   iret = pthread_attr_init(&hw->isr_attr);
   iret = pthread_attr_setschedpolicy(&hw->isr_attr, SCHED_FIFO);   
   iret = pthread_attr_setschedparam(&hw->isr_attr, &sp);
   iret = pthread_attr_setinheritsched(&hw->isr_attr, PTHREAD_EXPLICIT_SCHED);

   iret = pthread_create(&hw->isr_thread, &hw->isr_attr, isr, NULL);

   return iret;
}

void mcp_close() {
   int ret;

   pthread_join(hw->isr_thread, NULL);

   // More error handling here
   ret = close(hw->can_fd);

   free(hw);
}

