#ifndef __MCP2515__
#define __MCP2515__

#include <stdint.h>
#include <pthread.h>

#define MCP_WRITE       0x02
#define MCP_READ        0x03
#define MCP_READ_RX(X)  (0x90 |X << 2)
#define MCP_BITMOD      0x05
#define MCP_RTS(X)      (0x80 | 1 << X)
#define MCP_READ_STAT   0xA0
#define MCP_LOAD_TX(X)  (0x40 | X << 1)     

#define MCP_TXBXCTRL(X) 0x30 + (0x10 * X) 
#define MCP_RXBXCTRL(X) 0x60 + (0x10 * X) 
#define MCP_TXBXSIDH(X) 0x31 + (0x10 * X) 
#define MCP_RXBXSIDH(X) 0x61 + (0x10 * X) 
#define MCP_TXBXSIDL(X) 0x32 + (0x10 * X) 
#define MCP_RXBXSIDL(X) 0x62 + (0x10 * X) 
#define MCP_TXBXEID8(X) 0x33 + (0x10 * X) 
#define MCP_RXBXEID8(X) 0x63 + (0x10 * X) 
#define MCP_TXBXEID0(X) 0x34 + (0x10 * X) 
#define MCP_RXBXEID0(X) 0x64 + (0x10 * X) 
#define MCP_TXBXDLC(X)  0x35 + (0x10 * X) 
#define MCP_RXBXDLC(X)  0x65 + (0x10 * X) 
#define MCP_TXBXD0(X)   0x36 + (0x10 * X) 
#define MCP_RXBXD0(X)   0x66 + (0x10 * X) 
#define MCP_TXBXD1(X)   0x37 + (0x10 * X) 
#define MCP_RXBXD1(X)   0x67 + (0x10 * X) 
#define MCP_TXBXD2(X)   0x38 + (0x10 * X) 
#define MCP_RXBXD2(X)   0x68 + (0x10 * X) 
#define MCP_TXBXD3(X)   0x39 + (0x10 * X) 
#define MCP_RXBXD3(X)   0x69 + (0x10 * X) 
#define MCP_TXBXD4(X)   0x3A + (0x10 * X) 
#define MCP_RXBXD4(X)   0x6A + (0x10 * X) 
#define MCP_TXBXD5(X)   0x3B + (0x10 * X) 
#define MCP_RXBXD5(X)   0x6B + (0x10 * X) 
#define MCP_TXBXD6(X)   0x3C + (0x10 * X) 
#define MCP_RXBXD6(X)   0x6C + (0x10 * X) 
#define MCP_TXBXD7(X)   0x3D + (0x10 * X) 
#define MCP_RXBXD7(X)   0x6D + (0x10 * X) 
#define MCP_CNF3        0x28
#define MCP_CNF2        0x29
#define MCP_CNF1        0x2A
#define MCP_CANINTE     0x2B
#define MCP_CANINTF     0x2C
#define MCP_EFLG        0x2D
#define MCP_CANSTAT     0x2E
#define MCP_CANCTRL     0x2F

#define Rx0Int (1 << 0)
#define Rx1Int (1 << 1)
#define Tx0Int (1 << 2)
#define Tx1Int (1 << 3)
#define Tx2Int (1 << 4)
#define ErrInt (1 << 5)
#define WakInt (1 << 6)
#define MErrInt (1 << 7)

#define Rx0Int_Stat (1 << 0)
#define Rx1Int_Stat (1 << 1)
#define Tx0Req_Stat (1 << 2)
#define Tx0Int_Stat (1 << 3)
#define Tx1Req_Stat (1 << 4)
#define Tx1Int_Stat (1 << 5)
#define Tx2Req_Stat (1 << 6)
#define Tx2Int_Stat (1 << 7)

typedef struct {
	int spi_fd, uio_fd;
	pthread_attr_t isr_attr;
	pthread_t isr_thread;
} mcp2515_chip; 

extern mcp2515_chip *hw;

void mcp_write(uint8_t reg, uint8_t* data, uint8_t length);
void mcp_load_tx(uint8_t buf, uint8_t *msg);
void mcp_read(uint8_t reg, uint8_t* data, uint8_t length);


#endif
