#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include "componentdefs.h"
#include "vm.h"
// Components
#include "spectrometer.h"
#include "chemometry.h"
#include "textfile.h"
#include "tcpsocket.h"
#include "../CANopen/CANopen.h"
#include "datastore.h"
#include "configuration.h"
#include "realtimeclock.h"
#include "visualization.h"

static int initDebugOut(ComponentInst *inst) {
   if (strcmp(inst->instName, "DebugOut")) return 0;
   inst->instSpecific = NULL;
   return 1;
}

static void armDebugOut(vm *task) {}

static int doDebugOut(int32_t procNo, ComponentInst *inst, int32_t **PC, int32_t **SP, int32_t **FP, int32_t *excSP, int32_t **excHndlrPC, int32_t **excHndlrSP, int32_t **excHndlrFP) {
   switch (procNo) {
      case 0: 
         printf("%s", (char *)(Memory[**SP])); (*SP)++;
         break;
      case 1:
         printf("%d", **SP); (*SP)++;
         break;
      case 2:
         printf("%f", *((float *)(*SP))); (*SP)++;
         break;
      case 3: {
         int32_t v = **SP;
         (*SP)++;
         if (v) printf("true");
         else printf("false");
         break;
      }   
      case 4:
         printf("$T$%d", **SP); (*SP)++;
         break;
      case 5:
         printf("\n");
         break;
      case 6: {
         printf("$Blob$%x ", **SP);
         float *d = (float *)(**SP);
         if (d != NULL) { 
            int i;
            for (i = 0; i < 6; i++) printf("%f ", d[i+3]);
         }
         WRITELOCK;
         dwnRefCnt(*SP);
         UNLOCK;
         (*SP)++;
         break;
      }
   }
   return 1;
}

static int initErrorLog(ComponentInst *inst) {
   if (strcmp(inst->instName, "FtIrLog")) return 0;
   inst->instSpecific = NULL;
   return 1;
}

static void armErrorLog(vm *task) {}

static int doErrorLog(int32_t procNo, ComponentInst *inst, int32_t **PC, int32_t **SP, int32_t **FP, int32_t *excSP, int32_t **excHndlrPC, int32_t **excHndlrSP, int32_t **excHndlrFP) {
   switch (procNo) {
      case 0: 
         logError(0xFF, (char *)(Memory[**SP])); (*SP)++;
         break;
   }
   return 1;
}


static char *CompDefNames[] = {
   "Console", "Spectrometer", "TimeStampClock", "Chemometry", "TextFile", "CANopen", "TcpSocket", "LogBook", "DataStore", "ChemometryEngine", "Configuration", "RealTimeClock", "Visualization", NULL
};  

static int (*(initFuns[]))(ComponentInst *inst) = {
   initDebugOut, initSpectrometer, initTimeStampClock, initChemometry, initTextFile, initCANopen, initTcpSocket, initErrorLog, initDataStore, initChemometryEngine, initConfiguration,
   initRealTimeClock, initVisualization
};

static void (*(armFuns[]))(vm *task) = {
   armDebugOut, armSpectrometer, armTimeStampClock, armChemometry, armTextFile, armCANopen, armTcpSocket, armErrorLog, armDataStore, armChemometryEngine, armConfiguration,
   armRealTimeClock, armVisualization
};

static int (*(doFuns[]))(int32_t, ComponentInst *, int32_t **, int32_t **, int32_t **, int32_t *, int32_t **, int32_t **, int32_t **) = {
   doDebugOut, doSpectrometer, doTimeStampClock, doChemometry, doTextFile, doCANopen, doTcpSocket, doErrorLog, doDataStore, doChemometryEngine, doConfiguration,
   doRealTimeClock, doVisualization
};
 
int initCompDef(ComponentDef *def) {
   int i;

   for (i = 0; CompDefNames[i] != NULL && strcmp(CompDefNames[i], def->name) != 0; i++);
   if (CompDefNames[i] == NULL) return 0;
   def->initComp = initFuns[i];
   def->CompProc = doFuns[i];
   def->armEvents = armFuns[i];

   return 1;
}    

int initCompInst(ComponentInst *inst, ComponentDef *defs) {
   while (strcmp(inst->defName, defs->name) != 0)
      defs++;
   inst->definition = defs;
   return inst->definition->initComp(inst);
}          

