#include "configuration.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define DICTSIZE (4 * 256)

int initConfiguration(ComponentInst *inst) {
   return 1;
}

void armConfiguration(vm *task) {
}

static int matchIdent(FILE *cnffile, char **in, char **id, int *len, char *buffer) {
   for (;;) {
      while (**in == '\0') {
         if (fgets(buffer, 1024, cnffile) == NULL) {
            *id = NULL; *len = 0;
            return 1;
         }
         *in = buffer;
         if (buffer[0] == '/' && buffer[1] == '/') buffer[0] = '\0';
      }
      if (isalpha(**in) || **in == '_') break;
      if (!isspace(**in)) return 0;
      (*in)++;
   }
   *len = 1; *id = *in; (*in)++;
   while (isalnum(**in) || **in == '_') {
      (*in)++; (*len)++;
   }
   return 1;
}

static int match(char *pattern, FILE *cnffile, char **in, char *buffer) {
   int l = strlen(pattern);
   for (;;) {
      while (**in == '\0') {
         if (fgets(buffer, 1024, cnffile) == NULL) return 0;
         *in = buffer;
         if (buffer[0] == '/' && buffer[1] == '/') buffer[0] = '\0';
      }
      if (!isspace(**in)) break;
      (*in)++;
   }
   if (strncmp(pattern, *in, l) == 0) {
      (*in) += l;
      return 1;
   }
   return 0;
}

static int matchBool(FILE *cnffile, char **in, char *buffer, int32_t *target) {
   for (;;) {
      while (**in == '\0') {
         if (fgets(buffer, 1024, cnffile) == NULL) return 0;
         *in = buffer;
         if (buffer[0] == '/' && buffer[1] == '/') buffer[0] = '\0';
      }
      if (!isspace(**in)) break;
      (*in)++;
   }
   if (strncmp("TRUE", *in, 4) == 0) {
      (*in) += 4;
      *target = 1;
      return 1;
   } else if (strncmp("FALSE", *in, 5) == 0) {
      (*in) += 5;
      *target = 0;
      return 1;
   }
   return 0;
}

static int matchInt(FILE *cnffile, char **in, char *buffer, int32_t *target) {
   char *st;
   int32_t v;
   for (;;) {
      while (**in == '\0') {
         if (fgets(buffer, 1024, cnffile) == NULL) return 0;
         *in = buffer;
         if (buffer[0] == '/' && buffer[1] == '/') buffer[0] = '\0';
      }
      if (!isspace(**in)) break;
      (*in)++;
   }
   st = *in;
   v = strtol(st, in, 10);
   *target = v;
   return st != *in;
}

static int matchFloat(FILE *cnffile, char **in, char *buffer, float *target) {
   char *st;
   for (;;) {
      while (**in == '\0') {
         if (fgets(buffer, 1024, cnffile) == NULL) return 0;
         *in = buffer;
         if (buffer[0] == '/' && buffer[1] == '/') buffer[0] = '\0';
      }
      if (!isspace(**in)) break;
      (*in)++;
   }
   st = *in;
   *target = strtof(st, in);   
   return st != *in;
}

static int matchString(FILE *cnffile, char **in, char *buffer, int32_t *target) {
   char *t;
   int l, i;
   for (;;) {
      while (**in == '\0') {
         if (fgets(buffer, 1024, cnffile) == NULL) return 0;
         *in = buffer;
         if (buffer[0] == '/' && buffer[1] == '/') buffer[0] = '\0';
      }
      if (!isspace(**in)) break;
      (*in)++;
   }
   if (**in != '"') return 0;
   (*in)++;
   l = 10; t = malloc(10); i = 0;
   if (t == NULL) return 0;
   while (**in != '"') {
      char c;
      if (**in == '\0') return 0;
      if (**in == '\\') {
         (*in)++;
         if (**in == '\0') return 0; 
         c = **in;
         if (c == 'n') c = '\n';
         else if (c == 't') c = '\t';
       } else c = **in;
      t[i++] = c;
      if (i == l) {
         l += 10; t = realloc(t, l);
         if (t == NULL) return 0;
      }
      (*in)++;
   }
   t[i] = '\0'; (*in)++;
   *target = stringVars;
   Memory[stringVars] = (int32_t)t;
   stringVars--;
   return 1;
}

static int readDataList(ComponentVar *var, FILE *cnffile, char **in, char *buffer) {
   int i, c;
   TypeDef *ty;
   if (var->ty.tag == ARRAY) {
      c = var->ty.par;
      ty = var->ty.subs;
      if (!match("[", cnffile, in, buffer)) return 0;
   } else {
      c = 1;
      ty = &(var->ty);
   }
   i = var->addr;
   for (;;) {
      if (ty->tag == BOOL) {
         if (!matchBool(cnffile, in, buffer, Memory + i)) return 0;
      } else if (ty->tag == INTEGER) {
         if (!matchInt(cnffile, in, buffer, Memory + i)) return 0;
      } else if (ty->tag == FLOAT) {
         if (!matchFloat(cnffile, in, buffer, (float *)(Memory + i))) return 0;
      } else if (ty->tag == STRING) {
         if (!matchString(cnffile, in, buffer, Memory + i)) return 0;
      }
      if (i == var->eaddr) break;
      if (!match(",", cnffile, in, buffer)) break;
      i++;
   }
   if (var->ty.tag == ARRAY && !match("]", cnffile, in, buffer)) return 0;
   return 1;
}

int doConfiguration(int32_t procNo, ComponentInst *inst, int32_t **PC, int32_t **SP, int32_t **FP, int32_t *excSP, int32_t **excHndlrPC, int32_t **excHndlrSP, int32_t **excHndlrFP) {
   if (procNo == 0) {   // PROCEDURE configure()
      char fileName[256];
      char line[1024] = {'\0'};
      char *id, *in = line;
      int l;
      FILE *cnffile;
      strcpy(fileName, projDir);
      strcat(fileName, inst->instName);
      strcat(fileName, ".cnf");
      if ((cnffile = fopen(fileName, "r")) == NULL) 
         return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0xff, "Configuration, no such file");
      for (;;) {
         ComponentVar *var;
         int i;
         if (!matchIdent(cnffile, &in, &id, &l, line)) {
            fclose(cnffile);
            return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0xff, "Configuration, input error");
         }
         if (id == NULL) break;
         i = 0; var = compVars;
         for (;;) {
            if (i == compVarCnt) break;
            if (inst->objDict <= Memory + var->addr && Memory + var->eaddr < inst->objDict + DICTSIZE && strncmp(var->name, id, l) == 0 && var->name[l] == '\0') break;
            i++; var++;
         }
         if (i == compVarCnt) {
            char varname[100], msg[200];
            strncpy(varname, id, l);
            varname[l] = '\0';
            fclose(cnffile);
            sprintf(msg, "Configuratuion, variable %s not found", varname);
            return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0xff, msg);
         }
         if (!match(":=", cnffile, &in, line)) {
            fclose(cnffile);
            return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0xff, "Configuration, input error");
         }
         if (!readDataList(var, cnffile, &in, line)) {
            fclose(cnffile);
            return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0xff, "Configuration, input error");
         }
         if (!match(";", cnffile, &in, line)) {
            fclose(cnffile);
            return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0xff, "Configuration, input error");
         }          
      }
      fclose(cnffile);
   }
}

