#include <string.h>
#include "dynamicdefs.h"

char *addEntry2Set(int32_t *dataAddr, struct dataSet *set) {
   int i;
   ComponentVar *var;

   if (set->setSize >= MAXSETSIZ) return "Dataset: set too big";	
   // printf("addEntry2Set: dataAddr: %x\n", dataAddr);
   for (i = 0, var = compVars; i < compVarCnt; i++, var++) {
      if (Memory + var->addr <= dataAddr && dataAddr <= Memory + var->eaddr) {
         struct dataSetEntry *e = &(set->entry[set->setSize]);
         struct iovec *iov = &(set->ioVector[set->setSize + 1]);
         // printf("var->name: %s, var->addr: %x, var->eaddr: %x\n", var->name, Memory + var->addr, Memory + var->eaddr);
         if (var->addr == var-> eaddr) {
            e->meta.name = var->name;
            e->meta.type = &(var->ty);
         } else {
            // must be an array, only word-sized entries are supported...
            if (var->ty.tag != ARRAY) return "Dataset: internal error, not an array";
            e->meta.name = malloc(strlen(var->name) + 10);
            snprintf(e->meta.name, strlen(var->name) + 10,  "%s[%d]", var->name, dataAddr - Memory - var->addr);
            e->meta.type = var->ty.subs;
         } 
         e->data = dataAddr;
         // printf("name: %x, type: %x, data:%x\n", e->meta.name, e->meta.type, e->data); 
         iov->iov_base = dataAddr;
         iov->iov_len = sizeof(int32_t);
         (set->setSize)++;
         return NULL;
      }
   }
   return "Dataset: unknown variable";
}

char *doOutput(struct dataSet *set, void *par, char *(*writer)(struct iovec *iov, int32_t, void *)) {
   char *r;
   int i, l;
   BlobHeader *b;
   int32_t *p;
   struct timeval tv;
   for (i = 0, l = 0; i < set->setSize; i++) {
      if (set->entry[i].meta.type->tag == BLOB) {
         // no parameter is passed explicitly, so we up the refcnt, to keep the object alive until we are done.
         WRITELOCK;
         p = set->entry[i].data;
         upRefCnt(p);
         b = (BlobHeader *)(*p);
         UNLOCK;
         l += (b->dataCnt + 2);
         set->ioVector[i+1].iov_base = &(b->tag);
         set->ioVector[i+1].iov_len = (b->dataCnt + 2) * sizeof(int32_t);
      } else
         l++;
   }
   set->header.len = l; set->header.TimeStamp = now();
   gettimeofday(&tv, NULL); gmtime_r(&(tv.tv_sec), &(set->header.tt)); set->header.usecs = tv.tv_usec;
   set->ioVector[0].iov_base = &(set->header);
   set->ioVector[0].iov_len = sizeof(set->header);
   // printf("id = %d, len = %d, ", set->header.id, set->header.len);
   // for (i = 0; i < set->setSize + 1; i++) {
   //    printf("%d: %d, ", i, set->ioVector[i].iov_len);
   // }
   // printf("\n");
   r = writer(set->ioVector, set->setSize+1, par);
   for (i = 0; i < set->setSize; i++) {
      if (set->entry[i].meta.type->tag == BLOB) {
         WRITELOCK;
         dwnRefCnt(p);
         UNLOCK;
      }
   }   	
   return r;
}

int doInput(struct dataSet *set, void *par, int (*reader)(char *data, int len, void *, char **ex), char **exception) {
   struct dataSetHeader header;
   BlobHeader blHd, *b;
   int32_t *p;
   int r, i, eof;

   eof = reader((char *)(&header), sizeof(struct dataSetHeader), par, exception);
   if (eof) return -1;
   if (*exception != NULL) return 0;
   if (header.id != set->header.id) {
      eof = reader(NULL, header.len * sizeof(int32_t), par, exception);
      if (eof) return -1;
      else return 0;
   }
   WRITELOCK;
   r = 1;
   for (i = 0; i < set->setSize; i++) {
      if (set->entry[i].meta.type->tag == BLOB) {
         p = set->entry[i].data;
         dwnRefCnt(p);
         eof = reader((char*)(&(blHd.tag)), sizeof(BlobHeader) - sizeof(int32_t), par, exception);
         if (eof) {
            r = -1; break;
         }
         if (*exception != NULL) {
            r = 0; break;
         }
         // printf("doInput, allocating Blob, size = %d\n", blHd.dataCnt);
         b = allocBlob(blHd.dataCnt);
         if (b == NULL) {
            *exception = "DataSet: cannot allocate memory for read";
            r = 0; break;
         }
         b->tag = blHd.tag;
         eof = reader(((char *)b) + sizeof(BlobHeader), blHd.dataCnt * sizeof(int32_t), par, exception);
         if (eof) {
            r = -1; break;
         }
         if (*exception != NULL) {
            r = 0; break;
         }
         *p = (int32_t)b;
      } else {
         eof = reader((char *)(set->entry[i].data), sizeof(int32_t), par, exception);
         if (eof) {
            r = -1; break;
         }
         if (*exception != NULL) {
            r = 0; break;
         }
      }
   }
   UNLOCK;
   return r;
}

static void writeInt32(char *o, int32_t d) {
   memcpy(o, &d, 4);
}

static int readInt32(char *i) {
   int32_t r;
   memcpy(&r, i, 4);
   return r;
}

static void writeType(char **o, TypeDef *ty) {
   writeInt32(*o, ty->tag); *o += 4;
   if (ty->tag == ARRAY) {
      writeInt32(*o, ty->par); *o += 4;
      writeType(o, ty->subs);
   } else if (ty->tag == RECORD || ty->tag == TUPPLE) {
      int32_t i;
      writeInt32(*o, ty->par); *o += 4;
      for (i = 0; i < ty->par; i++) {
         writeType(o, ty->subs + i);
      }
   } 
}

static void checkType(int *matches, char **o, TypeDef *ty) {
   int32_t tag;
   *matches = 1;
   tag = readInt32(*o); *o += 4;
   if (ty->tag != tag) {
      *matches = 0;
      return;
   }
   if (ty->tag == ARRAY) {
      int32_t par = readInt32(*o);
      *o += 4;
      if (ty->par != par) {
         *matches = 0;
         return;
      }
      checkType(matches, o, ty->subs);
   } else if (ty->tag == RECORD || ty->tag == TUPPLE) {
      int32_t par = readInt32(*o), i;
      *o += 4;
      if (ty->par != par) {
         *matches = 0;
         return;
      }
      for (i = 0; i < par; i++) {
         checkType(matches, o, ty->subs + i);
         if (!matches) return;
      }
   }
}

char *doOutputMetaData(struct dataSet *set, void *par, char *(*writer)(char *data, int len, void *)) {
   char *r = NULL;
   char d[10000], *o = d + 8; 
   int32_t i;

   // printf("doOutputMetaData, id: %d, size: %d\n", set->header.id, set->setSize);
   writeInt32(d, set->header.id);
   writeInt32(o, set->setSize); o += 4;
   for (i = 0; i < set->setSize; i++) {
      int32_t l = strlen(set->entry[i].meta.name);
      // printf("name: %x, type: %x, data:%x\n", set->entry[i].meta.name, set->entry[i].meta.type, set->entry[i].data);
      // printf("name: %s\n", set->entry[i].meta.name);
      writeInt32(o, l); o += 4;
      strncpy(o, set->entry[i].meta.name, l); o += l;
      writeType(&o, set->entry[i].meta.type);
   }
   writeInt32(d + 4, o - d - 8);	// length in bytes
   if (r == NULL) r = writer(d, o - d, par);
   return r;
}

int MetaDataValid(struct dataSet *set, void *par, int (*reader)(char *data, int len, void *, char **ex)) {
   char d[10000];
   char *in = d + 8;
   int32_t l, setSize, j;
   int eof;
   char *ex;

   // printf("MetaDataValid, id: %d, size: %d\n", set->header.id, set->setSize);
   eof = reader(d, 8, par, &ex);
   if (eof || ex != NULL) return -1;
   l = readInt32(d + 4);
   eof = reader(d + 8, l, par, &ex);
   if (eof || ex != NULL) return -1;
   if (set->header.id != readInt32(d)) return 0;
   setSize = readInt32(in); in += 4;
   if (setSize != set->setSize) return 0;
   for (j = 0; j < setSize; j++) {
      int32_t nl = readInt32(in); in += 4 + nl;		// skip name
      int matches;
      // printf("name: %x, type: %x, data:%x\n", set->entry[j].meta.name, set->entry[j].meta.type, set->entry[j].data);
      checkType(&matches, &in, set->entry[j].meta.type);
      if (!matches) return 0;
   }
   return 1;
}
