#ifndef __DYNAMICDEFS__
#define __DYNAMICDEFS__

#include <limits.h>
#include <sys/uio.h>
#include <sys/time.h>
#include "vm.h"
#include "spectrometer.h"

#define MAXSETSIZ (_XOPEN_IOV_MAX - 1)

struct metaData {
   char *name;
   TypeDef *type;
};

struct dataSetEntry {
   struct metaData meta;
   int32_t *data;
};

struct dataSetHeader {
   int32_t id;
   int32_t len;
   int32_t TimeStamp;
   struct tm tt;
   suseconds_t usecs;
};

struct dataSet {
   int32_t setSize;
   struct dataSetHeader header;
   struct dataSetEntry entry[MAXSETSIZ];
   struct iovec ioVector[MAXSETSIZ + 1];
};

char* addEntry2Set(int32_t *dataAddr, struct dataSet *set);

char *doOutput(struct dataSet *set, void *par, char *(*writer)(struct iovec *iov, int32_t, void *));

int doInput(struct dataSet *set, void *par, int (*reader)(char *data, int len, void *, char **ex), char **exception);

char *doOutputMetaData(struct dataSet *set, void *par, char *(*writer)(char *data, int len, void *));

int MetaDataValid(struct dataSet *set, void *par, int (*reader)(char *data, int len, void *, char **ex));



#endif
