#include "configuration.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <time.h>

static int timeStringAddr;
static int windowsTimeStringAddr;
static char ts[26];
static char wts[26];

int initRealTimeClock(ComponentInst *inst) {
   if (strcmp(inst->instName, "RtClock")) return 0;
   timeStringAddr = stringVars;
   Memory[timeStringAddr] = (int32_t)ts;
   ts[0] = '\0';
   stringVars--;
   windowsTimeStringAddr = stringVars;
   Memory[windowsTimeStringAddr] = (int32_t)wts;
   wts[0] = '\0';
   stringVars--;
   return 1;
}

void armRealTimeClock(vm *task) {
}

int doRealTimeClock(int32_t procNo, ComponentInst *inst, int32_t **PC, int32_t **SP, int32_t **FP, int32_t *excSP, int32_t **excHndlrPC, int32_t **excHndlrSP, int32_t **excHndlrFP) {
   switch (procNo) {   
      case 0: {	// PROCEDURE getTimeString(): STRING;
         time_t t = time(NULL);
         struct tm tt;
         asctime_r(gmtime_r(&t, &tt), ts);
         ts[24] = '\0';
         (*SP)--;
         **SP = timeStringAddr;
         break;
      }
      case 1: { // PROCEDURE getWindowsTimeString(): STRING;
         time_t t = time(NULL);
         struct tm tt;
         gmtime_r(&t, &tt);
         sprintf(wts, "%02d.%02d.%04d %02d:%02d:%02d", tt.tm_mday, tt.tm_mon + 1, tt.tm_year + 1900, tt.tm_hour, tt.tm_min, tt.tm_sec);
         (*SP)--;
         **SP = windowsTimeStringAddr;
         break;
      }
      case 2: { // PROCEDURE getTime(): [INTEGER, INTEGER, INTEGER, INTEGER, INTEGER, INTEGER, INTEGER, INTEGER, BOOL]
         struct timeval tv;
         struct tm tt;
         gettimeofday(&tv, NULL); gmtime_r(&(tv.tv_sec), &tt);
         *(--(*SP)) = tt.tm_sec; *(--(*SP)) = tt.tm_min; *(--(*SP)) = tt.tm_hour; *(--(*SP)) = tt.tm_mday;
         *(--(*SP)) = tt.tm_mon; *(--(*SP)) = tt.tm_year; *(--(*SP)) = tt.tm_wday; *(--(*SP)) = tt.tm_yday;
         *(--(*SP)) = (tt.tm_isdst > 0) ? 1 : 0;
         break;
      }
   }
}

