#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include "textfile.h"

int initTextFile(ComponentInst *inst) {
   inst->instSpecific = NULL;
   return 1;
}

void armTextFile(vm *task) {}

int doTextFile(int32_t procNo, ComponentInst *inst, int32_t **PC, int32_t **SP, int32_t **FP, int32_t *excSP, int32_t **excHndlrPC, int32_t **excHndlrSP, int32_t **excHndlrFP) {
   if (procNo != 0 && procNo != 7 && inst->instSpecific == NULL) return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0x20, "file not open");
   switch (procNo) {
      case 0: {   // PROCEDURE openWrite(STRING FileName);
         char filename[128];
         strcpy(filename, storeRoot);
         strcat(filename, (char *)Memory[**SP]); 
         if (inst->instSpecific != NULL) return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0x20, "file already open");
         inst->instSpecific = (void *)(fopen(filename, "a")); (*SP)++;
         if (inst->instSpecific == NULL) return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0x20, "unable to open text file for writing");
         break;
      }
      case 1: {   // PROCEDURE writeString(STRING Text);
         fprintf((FILE *)(inst->instSpecific), "%s", (char *)Memory[**SP]); (*SP)++;
         break;
      }
      case 2: {   // PROCEDURE writeInteger(INTEGER i);
         fprintf((FILE *)(inst->instSpecific), "%d", **SP); (*SP)++;
         break;
      }
      case 3: {   // PROCEDURE writeFloat(FLOAT f);
         fprintf((FILE *)(inst->instSpecific), "%f", *((float *)(*SP))); (*SP)++;
         break;
      }
      case 4: {   // PROCEDURE writeBool(BOOL b);
         fprintf((FILE *)(inst->instSpecific), "%s", (**SP) ? "$B$1" : "$B$0"); (*SP)++;
         break;
      }
      case 5: {   // PROCEDURE writeTimeStamp(TIMESTAMP t);
         fprintf((FILE *)(inst->instSpecific), "$T$%d", **SP); (*SP)++;
         break;
      }
      case 6: {   // PROCEDURE writeln();
         fprintf((FILE *)(inst->instSpecific), "\n");
         fflush((FILE *)(inst->instSpecific));
         break;
      }
      case 7: {   // PROCEDURE openRead(String FileName);
         char filename[128];
         strcpy(filename, projDir);
         strcat(filename, (char *)Memory[**SP]); 
         inst->instSpecific = (void *)(fopen(filename, "r")); (*SP)++;
         if (inst->instSpecific == NULL) return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0x20, "unable to open text file for reading");
         break;
      }
      case 8: {   // PROCEDURE readInteger(): INTEGER;
         int32_t i;
         if (fscanf((FILE *)(inst->instSpecific), "%d", &i) != 1)
            return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0x20, "unable to read INTEGER from text file");
         (*SP)--;
         **SP = i;
         break;
      }
      case 9: {   // PROCEDURE readFloat(): FLOAT;
         float f;
         if (fscanf((FILE *)(inst->instSpecific), "%f", &f) != 1)
            return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0x20, "unable to read FLOAT from text file");
         (*SP)--;
         **SP = *((int32_t *)(&f));
         break;
      }
      case 10: {  // PROCEDURE readBool(): BOOL;
         int32_t i;
         if (fscanf((FILE *)(inst->instSpecific), "$B$%1d", &i) != 1)
            return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0x20, "unable to read BOOL from text file");
         (*SP)--;
         **SP = i;
         break;
      }
      case 11: {  // PROCEDURE readTimeStamp(): TIMESTAMP;
         int32_t i;
         if (fscanf((FILE *)(inst->instSpecific), "$T$%d", &i) != 1)
            return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0x20, "unable to read TIMESTAMP from text file");
         (*SP)--;
         **SP = i;
         break;
      }
      case 12: {  // PROCEDURE close()
         fclose((FILE *)(inst->instSpecific));
         inst->instSpecific = NULL;
         break;
      }
   }
   return 1;
}


