#include <stdio.h>
#include <fcntl.h>
#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <unistd.h>
#include "visualization.h"
#include "dynamicdefs.h"
#include "vm.h"

#define DICTSIZE (256 * 5)

struct VisSpec {
   ComponentInst *inst;
   int32_t xmlSize;
   char *xml;
   pthread_t thread;
   pthread_mutex_t mutex;
   int32_t setNo;
   struct dataSet *set;
   int regSocket;
   int port;
   int32_t cliNo, cliTabSiz;
   int *clientSockets;
}; 

static int writeTimeout(int s, char *data, int len) {
   fd_set out;
   struct timeval tv;
   int l, l1 = len;

   while (l1 > 0) {
      tv.tv_sec = 2; tv.tv_usec = 0;
      FD_ZERO(&out);
      FD_SET(s, &out);
      if (select(s + 1, NULL, &out, NULL, &tv) == -1 || !FD_ISSET(s, &out) || (l = write(s, data, len)) <= 0) return -1;
      l1 -= l; data += l;
   }
   return len;
}

static char *writeMeta(char *data, int len, void *spec) {
   struct VisSpec *v = (struct VisSpec *)spec;
   int i, s = v->clientSockets[v->cliNo - 1];
   
   while (len > 0) {
      int l = writeTimeout(s, data, len);
      if (l <= 0) return "Visualization: cannot write metadata";
      len -= l; data += l;
   }
   return NULL;
}

static void* visRegistration(void *p) {
   struct VisSpec *vis = (struct VisSpec *)p;
   int s, l, slen, flag = 1;
   struct sockaddr_in remote;
   for (;;) {
      if (listen(vis->regSocket, 1) < 0) {
         logError(20, "visualization thread died");
         return NULL;
      }
      slen = sizeof(struct sockaddr_in);
      if ((s = accept(vis->regSocket, (struct sockaddr *)&remote, &slen)) < 0) {
         continue;
      }
      pthread_mutex_lock(&(vis->mutex));
      if (vis->cliNo == vis->cliTabSiz) {
         int *t = realloc(vis->clientSockets, 2 * vis->cliTabSiz);
         if (t != NULL) {
            vis->clientSockets = t;
            vis->cliTabSiz *= 2;
         } else {
            close(s);
            continue;
         }
      }
      vis->clientSockets[vis->cliNo] = s;
      vis->cliNo++;
      l = writeTimeout(s, vis->xml, vis->xmlSize);
      if (l != vis->xmlSize) {
         close(s);
         vis->cliNo--;
      } else {
         int i, setCnt, c;
         for (i = 0, setCnt = 0; i < vis->setNo; i++)
            if (vis->set[i].setSize > 0) setCnt++;
         c = writeTimeout(s, (char *)(&setCnt), sizeof(int32_t));
         if (c != sizeof(int32_t)) {
            close(s);
            vis->cliNo--;
         } else {
            for (i = 0; i < vis->setNo; i++) {
               if (vis->set[i].setSize > 0) {
                  char *r = doOutputMetaData(vis->set + i, vis, writeMeta);
                  if (r != NULL) {
                     close(s);
                     vis->cliNo--;
                     break;
                  }
               }
            }
         }
      }
      if (setsockopt(s, IPPROTO_TCP, TCP_NODELAY, (char *) &flag, sizeof(int)) < 0) {
         close(s);
         vis->cliNo--;
      }
      pthread_mutex_unlock(&(vis->mutex));   
   }
}

int initVisualization(ComponentInst *inst) {
   struct VisSpec *v = malloc(sizeof(struct VisSpec));
   char xmlFileName[256];
   int rc, l, xmlFile, s;

   if (v == NULL) return 0;
   v->inst = inst;
   v->setNo = 0;
   v->set = NULL;
   inst->instSpecific = v;

   strcpy(xmlFileName, projDir); 
   strcat(xmlFileName, inst->instName);
   strcat(xmlFileName, ".ui");
   xmlFile = open(xmlFileName, O_RDONLY);
   if (xmlFile < 0) {
      fprintf(stderr, "initVisualization, error opening definition\n");
      exit(EXIT_FAILURE);
   }
   v->xmlSize = sizeof(int32_t);
   v->xml = NULL; s = 0;
   for(;;) {
      if (v->xmlSize + 1 >= s) {
         s += 1024;
         v->xml = realloc(v->xml, s);
         if (v->xml == NULL) {
            fprintf(stderr, "initVisualization, error reading definition\n");
            exit(EXIT_FAILURE);
         }
      }
      l = read(xmlFile, v->xml + v->xmlSize, s - 1 - v->xmlSize);
      if (l == 0) break;
      if (l < 0) {
         fprintf(stderr, "initVisualization, error reading definition\n");
         exit(EXIT_FAILURE);
      }
      v->xmlSize += l;
   }
   close(xmlFile);
   *((int *)v->xml) = v->xmlSize - sizeof(int32_t);
   if (pthread_mutex_init(&(v->mutex), NULL)) {
      fprintf(stderr, "initVisualization, pthread_mutex_init\n");
      exit(EXIT_FAILURE);
   }
   if ((v->clientSockets = malloc(10 * sizeof(int))) == NULL) {
      fprintf(stderr, "initVisualization, client table\n");
      exit(EXIT_FAILURE);
   }
   v->cliNo = 0; v->cliTabSiz = 10;
   return 1;
}

void armVisualization(vm *task) {}

static char *writeSockets(struct iovec *iov, int32_t cnt, void *spec) {
   struct VisSpec *v = (struct VisSpec *)spec;
   int i, c, j, l;

   i = 0; 
   while (i < v->cliNo) {
      int lost_conn = 0;
      pthread_mutex_lock(&v->mutex);

      for (j = 0; (j < cnt) && (!lost_conn); j++) {
         if ((c = writeTimeout(v->clientSockets[i], iov[j].iov_base, iov[j].iov_len)) < 0) {
            int k;
            close(v->clientSockets[i]);
            for (k = i; k <  v->cliNo; k++) v->clientSockets[k] = v->clientSockets[k + 1];
            v->cliNo--;
            i--;
            lost_conn = 1;
            break;
         }
      }
      if (!lost_conn) fsync(v->clientSockets[i]);
      i++;
      pthread_mutex_unlock(&v->mutex);
   }
   return NULL;
}

static int readSocket(char *buffer, int len, void *par, char **ex) {
   int f = *((int*)par);
   char *b = NULL;
   if (buffer == NULL) buffer = b = malloc(len);
   while (len > 0) {
      int l = read(f, buffer, len);
      if (l <= 0 && b != NULL) free(b);
      if (l == 0) return 1;
      if (l < 0) {
         *ex = "Visualization: cannot read";
         return 0;
      }
      buffer += l; len -= l;
   }
   return 0;
}

int doVisualization(int32_t procNo, ComponentInst *inst, int32_t **PC, int32_t **SP, int32_t **FP, int32_t *excSP, int32_t **excHndlrPC, int32_t **excHndlrSP, int32_t **excHndlrFP) {
   switch (procNo) {
      case 0: {  //  PROCEDURE offerService(INTEGER port);
         struct VisSpec *spec = (struct VisSpec *)inst->instSpecific;
         struct sockaddr_in addr;
         spec->port = **SP; (*SP)++;         
         spec->regSocket = socket(PF_INET, SOCK_STREAM, 0);
         addr.sin_family = AF_INET;
         addr.sin_port = htons(spec->port);
         addr.sin_addr.s_addr = INADDR_ANY;
         if(bind(spec->regSocket, (struct sockaddr *)&addr, sizeof(struct sockaddr_in)) < 0) {
            return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0x20, "Visualization: cannot setup socket");
         }
         if (pthread_create(&(spec->thread), &vmAttrs, visRegistration, (void *)spec)) {
            return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0x20, "Visualization: cannot start registration thread");
         }
         break;
      }
      case 1:    // PROCEDURE addBoolToDataset(VAR BOOL data, INTEGER SetId);
      case 2:    // PROCEDURE addIntegerToDataset(VAR INTEGER data, INTEGER SetId);
      case 3:    // PROCEDURE addTimestampToDataset(VAR TIMESTAMP data, INTEGER SetId);
      case 4:    // PROCEDURE addFloatToDataset(VAR FLOAT data, INTEGER SetId);
      case 5:    // PROCEDURE addBlobToDataset(VAR BLOB data, INTEGER SetId);
      {
         int32_t SetId, *dataAddr;
         char *errtxt;
         struct VisSpec *spec = (struct VisSpec *)inst->instSpecific;
         SetId = **SP; (*SP)++;
         dataAddr = Memory + **SP; (*SP)++;
         if (SetId < 0) return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0x20, "Visualization: invalid SetId");
         if (dataAddr < spec->inst->objDict || spec->inst->objDict + DICTSIZE <= dataAddr) 
            return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0x20, "Visualizatiopn: variable not in OBJECTDICTIONARY");
         if (spec->setNo - 1 < SetId) {
            struct dataSet *s = realloc(spec->set, (SetId + 1) * sizeof(struct dataSet));
            int32_t i;
            if (s == NULL) return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0x20, "Visualization: cannot allocate dataSet definitions");
            for (i = spec->setNo; i <= SetId; i++) {
               s[i].setSize = 0; s[i].header.id = i;
            }
            spec->setNo = SetId + 1;
            spec->set = s;
         }
         if ((errtxt = addEntry2Set(dataAddr, &(spec->set[SetId]))) != NULL) {
            return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0x20, errtxt);
         }			
         break;
      }
      case 6: {   // PROCEDURE visualize(INTEGER SetId);
         int32_t SetId;
         char *errtxt;
         struct VisSpec *spec = (struct VisSpec *)inst->instSpecific;
         // dumpDefs(spec);
         SetId = **SP; (*SP)++;
         errtxt = doOutput(spec->set + SetId, spec, writeSockets);
         if (errtxt != NULL) return doThrow(PC, SP, FP, excSP, excHndlrPC, excHndlrSP, excHndlrFP, 0x20, errtxt);
         // dumpDefs(spec);
         break;
      }
   }
   return 1;
}


