#ifndef _VM_H
#define _VM_H
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <pthread.h>
#include <signal.h>
#include <time.h>
#include <pthread.h>
#define SPETARGET

// project directory

extern char *projDir, *storeRoot;

// memory

extern int32_t Memory[], *Code, stringVars;

// threads, locking

typedef struct vm {
   char *name;
   int32_t period;
   struct ComponentInst *triggerInst;
   int32_t triggerIdx;
   int32_t *pc;
   int32_t *sp;
   int32_t running;
   int32_t *statics;
   void (*triggerFun)(struct vm *task);
   pthread_t thread;
   pthread_cond_t cond;    // Condition we are waiting for
   pthread_mutex_t mutex;  // Mutex for condition
   timer_t tid;
   struct sigevent evp;
} vm;

void stdWakeup(vm *task);

void stdTriggerFun(vm *task);

int doThrow(int32_t **PC, int32_t **SP, int32_t **FP, int32_t *excSP, int32_t **excHndlrPC, int32_t **excHndlrSP, int32_t **excHndlrFP, int level, char *reason);

void logError(int32_t level, char *reason);

extern pthread_rwlock_t rw_global;

extern pthread_attr_t vmAttrs;

#define READLOCK do {pthread_rwlock_rdlock(&rw_global);} while (0)
#define WRITELOCK do {pthread_rwlock_wrlock(&rw_global);} while (0)
#define UNLOCK do {pthread_rwlock_unlock(&rw_global);} while (0)

// components
typedef enum {
   NOTYPE = 0x4000,
   PROCEDURE = 0x4001,
   ARRAY = 0x4002,
   RECORD = 0x4003,
   TUPPLE = 0x4004,
   BOOL = 0x4005,
   INTEGER = 0x4006,
   FLOAT = 0x4007,
   STRING = 0x4008,
   TIMESTAMP = 0x4009,
   BLOB = 0x400A,
} TypeTag;

typedef vm *Event;

typedef struct ComponentInst {
   struct ComponentDef *definition;
   char *instName;
   char *defName;
   int32_t *objDict;
   Event *events;
   void *instSpecific;
} ComponentInst;

typedef struct TypeDef {
   int32_t tag, par;
   struct TypeDef *subs;
} TypeDef;

typedef struct {
   int32_t tag, parcnt;
   TypeDef *params;
   TypeDef ret;
} ProcInterfaceDef;

typedef struct ComponentDef {
   char *name;
   int (*initComp)(ComponentInst *inst);
   void (*armEvents) (vm *task);
   int (*CompProc)(int32_t procNo, ComponentInst *inst, int32_t **PC, int32_t **SP, int32_t **FP, int32_t *excSP, int32_t **excHndlrPC, int32_t **excHndlrSP, int32_t **excHndlrFP);
   int CompProcCnt;
   ProcInterfaceDef *interfaces;
} ComponentDef;

void releaseParameter(TypeDef *ty, int32_t **SP);

typedef struct ComponentVar {
   char *name;
   TypeDef ty;
   int addr, eaddr;
} ComponentVar;

extern ComponentVar *compVars;
extern int compVarCnt;

/*-----------------------------------------------------------------------

A variable of type BLOB is represented by a pointer to a stucture
on the heap consisting of:
1. one word reference count,
2. one word tag, taken from the type DataType,
3. the length of the following data in words,
4. the data itself.

-----------------------------------------------------------------------*/
typedef struct {
   int32_t refCnt;
   int32_t tag;
   int32_t dataCnt;
   int32_t data[0];
} BlobHeader;

BlobHeader *allocBlob(int dataSize);

void freeBlob(BlobHeader *b);

// reference counting

#define upRefCnt(p)                                                                             \
   do {                                                                                         \
      int32_t *loc = p;                                                                         \
      if (*loc != 0) {                                                                          \
         (*((unsigned *)(*loc)))++;                                                             \
      }                                                                                         \
   } while (0)

#define dwnRefCnt(p)                                                                            \
   do {                                                                                         \
      int32_t *loc = p;                                                                         \
      if (*loc != 0) {                                                                          \
         if (--(*((unsigned *)(*loc))) == 0) {                                                  \
            freeBlob((BlobHeader *)(*loc));                                                     \
         }                                                                                      \
      }                                                                                         \
   } while (0)

// instructions

#define IS_BLOB(i) (i & 0x800000)
#define IS_LOCAL(i) (i & 0x800000)
#define IS_LOCKED(i) (i & 0x400000)
#define IS_ADDR_LOCKED(a) (a & 0x80000000)

#define ADDRESS(i) (i & 0xFFFFF)
#define OFFSET(i) ((((int)(i & 0xFFFF)) << 16) >> 16)
#define TARGET(i) ((((int)(i & 0xFFFFF)) << 12) >> 12)

#define SIZE(i) (i & 0xFFFF)
#define BLOB_LST(i) ((i >> 16) & 0x3F)
#define LEFT(i) ((i & 0xFFc000) >> 14)
#define RIGHT(i) (i & 0x3FFF) 
#define FIELD_SIZE(i) (i & 0xFFFF)
#define BASE_SIZE(i) ((i >> 16) & 0xFFFF)

typedef enum {
   LOAD = 0x0,
   LOADA = 0x1,
   LOADL = 0x2,
   LOADAL = 0x3,
   LOADV = 0x4,
   LOADM = 0x5,
   LOADMV = 0x6,
   
   STORE = 0x10,
   STOREA = 0x11,
   STOREL = 0x12,
   STOREAL = 0x13,
   STOREM = 0x14,
   STOREMV = 0x15,
   STOREP = 0x16,

   ADDFP = 0x20,
   CHECK = 0x21,
   XTRACT = 0x22,
   STKAREF = 0x23,

   ADD = 0x30,
   SUB = 0x31,
   MUL = 0x32,
   DIV = 0x33,
   MOD = 0x34,
   NEG = 0x35,
   AND = 0x36,
   OR = 0x37,
   XOR = 0x38,
   NOT = 0x39,
   DURATION = 0x3A,
   EARLIEST = 0x3B,
   LATEST = 0x3C,

   LT = 0x40,
   LE = 0x41,
   EQ = 0x42,
   GE = 0x43,
   GT = 0x44,
   NEQ = 0x45,

   FADD = 0x50,
   FSUB = 0x51,
   FMUL = 0x52,
   FDIV = 0x53,
   FNEG = 0x54,

   FLT = 0x60,
   FLE = 0x61,
   FEQ = 0x62,
   FGE = 0x63,
   FGT = 0x64,
   FNEQ = 0x65,

   TOFLOAT = 0x70,
   TOINT = 0x71,

   JMP = 0x80,
   ANDJMP = 0x81,
   ORJMP = 0x82,
   FALSEJMP = 0x83,
   TRUEJMP = 0x84,
   CALL = 0x85,
   ENTER = 0x86,
   RETURN = 0x87,
   FRETURN = 0x88,
   COMPCALL = 0x89,

   UPFORTST = 0x90,
   DWNFORTST = 0x91,
   FOREND = 0x92,
   TRY = 0x93,
   THROW = 0x94,
   TRYEND = 0x95,
   STOP = 0xA0,      
} Instructions;

#endif
