/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package poker;

/**
 *
 * @author pree
 */
public class Card {
    public Suit suit;
    public Rank rank;
    public Card() {
        suit= Suit.CLUB;
        rank= Rank.ACE;
    }
    public Card(Suit s, Rank r) {
        suit= s;
        rank= r;
    }
    /**
    string format: rank as single character, followed by suit as single character
            rank characters: 2, 3, 4, 5, 6, 7, 8, 8, T (for ten), J (for Jack), Q (for Queen), K (for King), A (for Ace)
            suit characters: S (for Spade), H (for Heart), D (for Diamond), C (for Club)
    * */
    public Card(String sC) {
        setCard(sC);
    }
    public final void setCard(String sC) {     //  example: "2C"   rank: 2,  suit: Club
                                               //  example: "TH"   rank: 10, suit: Heart
        switch (sC.charAt(0)) {  //  first character <=> rank
            case '2': rank= Rank.TWO; break;
            case '3': rank= Rank.THREE; break;
            case '4': rank= Rank.FOUR; break;
            case '5': rank= Rank.FIVE; break;
            case '6': rank= Rank.SIX; break;
            case '7': rank= Rank.SEVEN; break;
            case '8': rank= Rank.EIGHT; break;
            case '9': rank= Rank.NINE; break;
            case 'T': rank= Rank.TEN; break;
            case 'J': rank= Rank.JACK; break;
            case 'Q': rank= Rank.QUEEN; break;
            case 'K': rank= Rank.KING; break;
            case 'A': rank= Rank.ACE; break;
            default: 
                System.out.println("NO VALID rank "+sC.charAt(0));               
                rank= Rank.TWO;            
        }
        switch (sC.charAt(1)) { // second character <=> suit
            case 'S': suit= Suit.SPADE; break;
            case 'H': suit= Suit.HEART; break;
            case 'D': suit= Suit.DIAMOND; break;
            case 'C': suit= Suit.CLUB; break;
            default: 
                System.out.println("NO VALID suit "+sC.charAt(1));               
                suit= Suit.HEART;            
        }       
    }
}
