/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package poker;

/**
 *
 * @author pree
 */
public class Hand implements Comparable<Hand>{
    public Card[] cards;
    public HandVal handVal;
    public Hand() {
        createCards();    
    }
    public Hand(String cardsAsStr) {
        setHand(cardsAsStr);
    }
    /**
     * 
     * @param cardsAsStr  is consisting of five two-character descriptions of cards; card descriptions separated by blank
     */
    public void setHand(String cardsAsStr) {   // example: "3C TH 8K JC AC" 
        createCards();    
        String cardStr[] = cardsAsStr.split(" ");
        for (int i= 0; i < cardStr.length; i++)
            cards[i].setCard(cardStr[i]);    
    }
    private void createCards() {
        if (cards == null) {
            cards= new Card[5];
            for (int i= 0; i < 5; i++)
                cards[i]= new Card();   // default card: Ace-Club
            handVal= HandVal.POKER;
        }        
    }
    @Override
    public int compareTo(Hand h) {
        if (this.handVal.ordinal() < h.handVal.ordinal())
            return -1;
        if (this.handVal.ordinal() > h.handVal.ordinal())
            return 1;
        if (this.handVal.ordinal() == h.handVal.ordinal()) {
            for (int i= 0; i < 5; i++) {
                if (this.cards[i].rank.ordinal() < h.cards[i].rank.ordinal())
                    return -1;
                if (this.cards[i].rank.ordinal() > h.cards[i].rank.ordinal())
                    return 1;
            }
        }
        return 0; // the two hands are equal
    }
    public void show() {
        for (int i= 0; i < 5; i++) {
            System.out.print(cards[i].suit);
            // print appropriate number of space characters so that the 2-column printout is aligned
            switch(cards[i].suit) {
                case SPADE:
                    System.out.print("        ");
                    break;
                case HEART:
                    System.out.print("        ");
                    break;
                case DIAMOND:
                    System.out.print("      ");
                    break;
                case CLUB:
                    System.out.print("         ");
                    break;
             }
            System.out.println(cards[i].rank);
        }
        System.out.println();
        System.out.println();
    }
}
