/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package poker;
import java.util.*;

/**
 *
 * @author pree
 */
public class Poker {
    public static void main(String[] args) {
        Hand h= new Hand("KH QH 2H 4H KH");
        printHandVal(HandRanker.assessAndSort(h)); h.show(); // expected: Flush
        h.setHand("2D QD JD 4D 2D");
        printHandVal(HandRanker.assessAndSort(h)); h.show(); // expected: Flush
        h.setHand("KH QH JH TH AH");
        printHandVal(HandRanker.assessAndSort(h)); h.show(); // expected: StraightFlush
        h.setHand("3H 7S 5H 6D 4H");
        printHandVal(HandRanker.assessAndSort(h)); h.show(); // expected: Straight
        h.setHand("4H 5S AH 3D 2H");
        printHandVal(HandRanker.assessAndSort(h)); h.show(); // expected: Straight (according to special rule: ace also counts as 'ONE')
        h.setHand("TH QS TH TD TC");
        printHandVal(HandRanker.assessAndSort(h)); h.show(); // expected: Poker
        h.setHand("2H QS 2H 2D QC");
        printHandVal(HandRanker.assessAndSort(h)); h.show(); // expected: Full House
        h.setHand("2H QS 2H 2D KC");
        printHandVal(HandRanker.assessAndSort(h)); h.show(); // expected: Three of a Kind
        h.setHand("5H QS 5H TD TC");
        printHandVal(HandRanker.assessAndSort(h)); h.show(); // expected: Two Pairs
        h.setHand("3H 8S 5H 8D AC");
        printHandVal(HandRanker.assessAndSort(h)); h.show(); // expected: One Pair
        h.setHand("3H 8S 5H KD AC");
        printHandVal(HandRanker.assessAndSort(h)); h.show(); // expected: High Card
        h.setHand("4H 8S AH 3D 2H");
        printHandVal(HandRanker.assessAndSort(h)); h.show(); // expected: High Card; but almost a Straight with special rule that ace also counts as 'ONE'
        // comparisons ---------------------------------------------------------
        // High Card h1
        Hand h1= new Hand("3H 8S 5H KD AC");
        printHandVal(HandRanker.assessAndSort(h1)); h1.show();// expected: High Card 
        System.out.println();
        // High Card h2
        Hand h2= new Hand("4H 8S AH 3D 2H");
        printHandVal(HandRanker.assessAndSort(h2)); h2.show();// expected: High Card 
        System.out.println("comparison result former :: latter: "+h1.compareTo(h2));   // expected: 1
        System.out.println();
        // Full House h3
        Hand h3= new Hand("2H QS 2H 2D QC");
        printHandVal(HandRanker.assessAndSort(h3));  h3.show();// expected: Full House
        // Full House h4
        Hand h4= new Hand("2C 2S QS 2D QC");
        printHandVal(HandRanker.assessAndSort(h4));  h4.show();// expected: Full House        
        System.out.println("comparison result former :: latter: "+h3.compareTo(h4));   // expected: 0
        System.out.println(); System.out.println(); 
        System.out.println("sorted list of previous four hands:");
        // sorting a hand collection based on Comparable interface implementation ---
        List<Hand> list= new ArrayList<>();
        list.add(h3);
        list.add(h2);
        list.add(h1);
        list.add(h4);
        Collections.sort(list); // sort the array list based on Comparable interface
        for(Hand handElem: list)//printing the sorted list of names
            handElem.show();
    }
    public static void printHandVal(HandVal v) {
        switch (v){
            case STRAIGHTFLUSH:
                System.out.print("Straight Flush"); System.out.println(); System.out.println();
                break;
            case POKER:
                System.out.print("Poker"); System.out.println(); System.out.println();
                break;
            case FULLHOUSE:
                System.out.print("Full House"); System.out.println(); System.out.println();
                break;
            case FLUSH:
                System.out.print("Flush"); System.out.println(); System.out.println();
                break;
            case STRAIGHT:
                System.out.print("Straight"); System.out.println(); System.out.println();
                break;
            case THREEOFAKIND:
                System.out.print("Three of a Kind"); System.out.println(); System.out.println();
                break;
            case TWOPAIRS:
                System.out.print("Two Pairs"); System.out.println(); System.out.println();
                break;
            case ONEPAIR:
                System.out.print("One Pair"); System.out.println(); System.out.println();
                break;
            case HIGHCARD:
                System.out.print("High Card"); System.out.println(); System.out.println();
                break;
            case NOTVALID:
                System.out.print("NO valid hand!?"); System.out.println(); System.out.println();
                break;
            default:
                System.out.print("NONE of the predefined enum constants!?"); System.out.println(); System.out.println();
        }
    }
}
