using System;
using System.Text;
using System.IO;
using NUnit.Framework;


/*
********************************************************************************************
*** Aufgabenstellung: Transformation eines Textes, sodass die Buchstaben jedes 2. Wortes 
*** in umgekehrter Reihenfolge erscheinen. 
*** (siehe http://www.softwareresearch.net/site/teaching/SS2007/se2/assignment1.html):
********************************************************************************************

Gegeben sei ein Zeichensatz bestehend aus:

    * Buchstaben
    * Leerzeichen
    * Punkt

Wrter bestehen aus max. 20 Buchstaben und werden durch beliebig viele Leerzeichen getrennt. 
Die Eingabe besteht aus beliebig vielen Wrtern und wird durch einen Punkt abgeschlossen.

Die Ausgabe soll wie folgt aussehen:

   1. Wrter sollen durch ein einziges Leerzeichen getrennt sein.
   2. Das letzte Wort soll durch einen Punkt abgeschlossen werden.
   3. Die Buchstaben jedes 2. Wortes sollen in umgekehrter Reihenfolge sein. 
      Genauer: Gegeben sei eine Ordnung der Wrter in Leserichtung 
      (d.h. von links nach rechts), sodass jedem Wort eine eindeutige Zahl 0,1,2,... 
      zugeordnet werden kann. Wrter denen eine gerade Zahl zugeordnet ist sind exakt 
      wiederzugeben. Bei Wrtern denen eine ungerade Zahl zugeordnet ist sind die Buchstaben 
      in umgekehrter Reihenfolge wiederzugeben.

Beispiel: "???this?is?a???silly???text???." wird transformiert in "this?si?a?yllis?text." 
          (? entspricht den Leerzeichen)
********************************************************************************************
*/

public class SimpleTextTransformation
    {
        public const char SPACE = ' ';
        public const char PERIOD = '.';

        static void Main(string[] args)
        {
            foreach (string s in args)
            {
                Console.WriteLine(s + "  ->  " + transform(s));
            }
        }

        public static string transform(string input)
        {

            StringReader instr = new StringReader(input);
            StringBuilder outstr = new StringBuilder();

            SkipBlanks(instr,outstr);
            while (!IsEndOfLine(instr.Peek()))
            {
                PrintWord(instr, outstr);
                SkipAndPrintBlanks(instr, outstr);
                PrintWordInReverseOrder(instr, outstr);
                SkipAndPrintBlanks(instr, outstr);
            }
            PrintEndOfLine(outstr);
            

            return outstr.ToString();
        }

        private static void PrintWord(StringReader instr, StringBuilder outstr)
        {
            while (IsLetter(instr.Peek()))
            {
                outstr.Append(i2c(instr.Read()));
            }
        }

        private static void PrintWordInReverseOrder(StringReader instr, StringBuilder outstr)
        {
            if (IsLetter(instr.Peek()))
            {
                char c = i2c(instr.Read());
                PrintWordInReverseOrder(instr, outstr);
                outstr.Append(c);
            }
        }

        private static void SkipAndPrintBlanks(StringReader instr, StringBuilder outstr)
        {
            bool bSpace = false;
            if (IsSpace(instr.Peek())) bSpace = true;
            SkipBlanks(instr, outstr);
            if (!IsEndOfLine(instr.Peek()) && bSpace) outstr.Append(SPACE);
        }


        private static void PrintEndOfLine(StringBuilder outstr)
        {
            outstr.Append(PERIOD);
        }

        private static void SkipBlanks(StringReader instr, StringBuilder outstr)
        {
            while (IsSpace(instr.Peek())) instr.Read();
        }

        private static bool IsEndOfLine(int p)
        {
            return i2c(p) == PERIOD;
        }

        private static bool IsSpace(int p)
        {
            return i2c(p) == SPACE;
        }

        private static bool IsLetter(int p)
        {
            return !IsSpace(p) && !IsEndOfLine(p);
        }

        private static char i2c(int i)
        {
            return Convert.ToChar(i);
        }

    }

    [TestFixture]
    public class TestTransformation
    {
        private static void checkTransform(string expected, string input)
        {
            Assert.AreEqual(expected,SimpleTextTransformation.transform(input));
        }

        [Test]
        public void TestMinimal()
        {
            checkTransform(".",".");
        }

        [Test]
        public void Test1Word()
        {
            checkTransform("this.", "this.");
        }

        [Test]
        public void Test2Words()
        {
            checkTransform("this si.", "this is.");
        }

        [Test]
        public void TestSentences()
        {
            checkTransform("this si a.", "this is a.");
            checkTransform("this si a yllis.", "this is a silly.");
            checkTransform("this si a yllis text.", "this is a silly text.");
            checkTransform("this si a yllis text doog.", "this is a silly text good.");
            checkTransform("this si a yllis text doog for.", "this is a silly text good for .");
            checkTransform("this si a yllis text doog for gnihton.", "this is a silly text good for nothing.");
        }

        [Test]
        public void TestSpaces()
        {
            checkTransform(".", "   .  ");
            checkTransform("this si a.","this is  a.");
            checkTransform("this si a yllis.", "this    is    a   silly.");
            checkTransform("this si a yllis text.", " this is a silly text .");
            checkTransform("this si a yllis text doog.", "  this  is  a    silly  text good    .");
        }

    }
