package IRed.spectro.stamped;

public abstract class AST {
   int line, col;

   public AST(int line, int col) {
      this.line = line;
      this.col = col;
   }

   public void SemErr(String s) {
      Compiler.parser.errors.SemErr(line, col, s);
   }

   public void Warning(String s) {
      Compiler.parser.errors.Warning(line, col, s);
   }

   public boolean distributeTypes() {
      return distributeTypes(false);
   }

   // isFunBody is used in SequenceAST to complain about missing RETURN
   public abstract boolean distributeTypes(boolean isFunBody);

   public void setEnclosingProc(ProcType proc) {}

   public void generateCode() {
      generateCode(false);
   }

   public abstract void generateCode(boolean isTry);

   public abstract void dump(String left);

}
