package IRed.spectro.stamped;

import java.util.LinkedList;
import java.util.ListIterator;

public class ActParsAST extends AST {
   LinkedList<TypedAST> params;

	public ActParsAST(int line, int col, TypedAST p) {
      super(line, col);
      params = new LinkedList<TypedAST>();
      params.add(p);
	}

   public void append(TypedAST p) {
      params.add(p);
   }

   public boolean distributeTypes(boolean isFunBody) {
      for (TypedAST p: params) if (!p.distributeTypes()) return false;
      return true;
   }

	public void generateCode(boolean isTry) {
   }

   public void move2Stack(int parcnt, SymbolTable locals) {
      ListIterator<TypedAST> aIter = params.listIterator(0);
      int i = 0;
      for (Symbol form: locals.table.values()) {
         if (i == parcnt) break;
         TypedAST act = aIter.next();
         i++;
         if (form.kind == Kind.VARPAR) {
            act.forceAddr2Stack();
            if (act.place != Place.ADDRONSTACK) SemErr("VAR parameter has no address");
         } else {
            act = act.moveVal2Stack();
            act.forceVal2Stack();
            if (act.place != Place.VALONSTACK) SemErr("parameter has no value");
         }
      }
   }


	public void dump(String left) {
		System.out.println(left + "ActParsAST:");
      if (params != null) {
         for (TypedAST p: params) p.dump(left + "   ");
      }
	}

   // call by reference vs. call by value is not checked here, has to be posponed until code generation
   public boolean checkTypes(int parcnt, SymbolTable locals) {
      ListIterator<TypedAST> aIter = params.listIterator(0);
      int i = 0;
      for (Symbol form: locals.table.values()) {
         if (i == parcnt) break;
         if (!aIter.hasNext()) {
            SemErr("wrong number of arguments in call");
            return false;
         }
         TypedAST act = aIter.next();
         i++;
         // System.out.println("formal Parameter");
         // form.type.dump("   ");
         // System.out.println("actual Parameter");
         // act.getType().dump("   ");
         if (!form.type.assignable(act.getType())) {
            SemErr("type missmatch in parameter list");
            return false;
         }
         if ((form.type instanceof FloatType) && (act.getType() instanceof IntegerType)) {
            aIter.set(new toFloatAST(act));             
         }
      }
      if (aIter.hasNext()) {
         SemErr("wrong number of arguments in call");
         return false;
      } 
      return true;
   }

}
