package IRed.spectro.stamped;

import java.util.List;

public class ArrayRefAST extends TypedAST {
	TypedAST arrayVarAst;
	TypedAST indexAst;

	public ArrayRefAST(int line, int col, TypedAST ref, TypedAST iAst) {
		super(line, col, ref.type);
		arrayVarAst = ref;
		indexAst = iAst;
	}

	public TypedAST resolveConst() {return this;}

   public boolean distributeTypes(boolean isFunBody) {
      if (!indexAst.distributeTypes()) return false;
      if (!(indexAst.getType() instanceof IntegerType)) {
         SemErr("index must be an INTEGER");
         return false;
      }
      if (!arrayVarAst.distributeTypes()) return false;
      if (!(arrayVarAst.getType() instanceof ArrayType)) {
         SemErr("not an ARRAY");
         return false;
      }
      type =  ((ArrayType)(arrayVarAst.getType())).getBasicType();
      kind = arrayVarAst.kind;
      return true;
   }

   public TypedAST moveVal2Stack() {
      // System.out.println("in ArrayRefAST.moveVal22Stack");
      moveAddr2Stack();
      int s = type.size;
      if (place == Place.CONSTADDR) {
         if (kind == Kind.STATICVAR) {
            if (s == 1) Compiler.code.Emit(Instruction.LOAD, offset, isBlob(), "static variable");
            else Compiler.code.Emit(Instruction.LOADM, offset, s, false, false, type.getBlobOffsets(0), "static variable");
            place = Place.VALONSTACK;
         } else if (kind == Kind.SHAREDVAR || kind == Kind.COMPVAR) {
            if (s == 1) Compiler.code.Emit(Instruction.LOAD, offset, isBlob(), "shared or component variable");
            else Compiler.code.Emit(Instruction.LOADM, offset, s, false, true, type.getBlobOffsets(0), "shared or component variable");
            place = Place.VALONSTACK;
         } else if (kind == Kind.LOCALVAR) {
            if (s == 1) Compiler.code.Emit(Instruction.LOADL, offset, isBlob(), "local variable");
            else Compiler.code.Emit(Instruction.LOADM, offset, s, true, false, type.getBlobOffsets(0), "local variable");
            place = Place.VALONSTACK;
         }
      } else if (place == Place.INDEXONSTACK) {
         if (kind == Kind.STATICVAR || kind == Kind.SHAREDVAR || kind == Kind.COMPVAR) {
            if (s == 1) {
               Compiler.code.Emit(Instruction.LOADA, offset, ((ArrayType)arrayVarAst.getType()).no, isBlob(), "static, shared or component variable");
            } else {
               int o = offset;
               if (kind == Kind.SHAREDVAR || kind == Kind.COMPVAR) o |= 0x80000000;
               Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(offset), false, "static, shared or component variable, offset: " + offset + " locked");
               Compiler.code.Emit(Instruction.ADD, "");
               Compiler.code.Emit(Instruction.LOADMV, s, type.getBlobOffsets(0), "");
            }
            place = Place.VALONSTACK;
         } else if (kind == Kind.LOCALVAR) {
            if (s == 1) {
               Compiler.code.Emit(Instruction.LOADAL, offset, ((ArrayType)arrayVarAst.getType()).no, isBlob(), "local variable");
            } else {
               Compiler.code.Emit(Instruction.ADDFP, offset, "local variable");
               Compiler.code.Emit(Instruction.ADD, "");
               Compiler.code.Emit(Instruction.LOADMV, s, type.getBlobOffsets(0), "");
            }
            place = Place.VALONSTACK;
         }
      } else if (place == Place.ADDRONSTACK) {
         if (s == 1) {
            Compiler.code.Emit(Instruction.LOADV, isBlob(), "absolute address on stack");
         } else {
            Compiler.code.Emit(Instruction.LOADMV, s, type.getBlobOffsets(0), "absolute address on stack");
         }
         place = Place.VALONSTACK;
      }
      // System.out.println("out ArrayRefAST.moveVal22Stack, place = " + place);
      return this;
   }

   public void forceVal2Stack() {
   }

   public void qualifyOnStack(int baseSize, List<Integer> blobLst) {
      // System.out.println("in ArrayRefAST.qualifyOn2Stack");
      // type.dump("ArrayRefAST.type = ");
      // arrayVarAst.type.dump("ArrayRefAST.arrayVarAst.type = ");      
      int o = arrayVarAst.offset, s = arrayVarAst.getType().size;
      if (baseSize <= s) {
         baseSize = s;
      }   
      indexAst = indexAst.moveVal2Stack();
      int es = ((ArrayType)arrayVarAst.getType()).basicTy.size;
      if (indexAst.place == Place.CONSTVAL) {
         int i = ((ConstIntAST)indexAst).val;
         if (i >= ((ArrayType)arrayVarAst.getType()).no) SemErr("constant index out of bounds");
         int idx = o + i * es;
         List<Integer> arrayBlobLst = ((ArrayType)arrayVarAst.getType()).getBlobOffsets(0);
         Compiler.code.Emit(Instruction.XTRACT, baseSize, idx, es, arrayBlobLst, "stucture member is array, constant index");
      } else {
         indexAst.forceVal2Stack();
         Compiler.code.Emit(Instruction.CHECK, ((ArrayType)arrayVarAst.getType()).no, "");
         if (es > 1) {
            Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(es), false, "element size " + es);
            Compiler.code.Emit(Instruction.MUL, "");
         }
         if (o != 0) {
            Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(o), false, "offset " + o);
            Compiler.code.Emit(Instruction.ADD, "");
         }            
         List<Integer> arrayBlobLst = ((ArrayType)arrayVarAst.getType()).getBlobOffsets(0);
         Compiler.code.Emit(Instruction.STKAREF, baseSize, es, arrayBlobLst, "");
      }
      place = Place.VALONSTACK;
      // System.out.println("out ArrayRefAST.qualifyOn2Stack, place = " + place);
   }

   public void moveAddr2Stack(boolean check) {
      // System.out.println("in ArrayRefAST.moveAddr2Stack");
      if (place == Place.VALONSTACK || place == Place.ADDRONSTACK) return;
      arrayVarAst.moveAddr2Stack();
      // System.out.println("ArrayRefAST.moveAddr2Stack, arrayVarAst.place = " + arrayVarAst.place);
      if (arrayVarAst.place == Place.VALONSTACK) {
         qualifyOnStack(0, type.getBlobOffsets(0));
         // System.out.println("out ArrayRefAST.moveAddr2Stack, place = " + place);
         return;
      }
      indexAst = indexAst.moveVal2Stack();
      // System.out.println("ArrayRefAST.moveAddr2Stack, indexAst.place = " + indexAst.place);
      if (arrayVarAst.place == Place.CONSTADDR && indexAst.place == Place.CONSTVAL) {
         int o = arrayVarAst.offset;
         int i = ((ConstIntAST)indexAst).val;
         if (i >= ((ArrayType)arrayVarAst.getType()).no) SemErr("constant index out of bounds");
         offset = o + i * type.size;
         place = Place.CONSTADDR;
      } else if (arrayVarAst.place == Place.CONSTADDR && indexAst.place == Place.VALONSTACK) {
         if (type.size > 1 || check) {
            // for size > 1 checking is necessary as the LOADMV instruction does not check adresses
            Compiler.code.Emit(Instruction.CHECK, ((ArrayType)arrayVarAst.getType()).no, "");
            if (type.size > 1) {
               Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(type.size), false, "size of data: " + type.size);
               Compiler.code.Emit(Instruction.MUL, "");
            }
         }
         offset = arrayVarAst.offset;
         place = Place.INDEXONSTACK;
      } else if (arrayVarAst.place == Place.ADDRONSTACK && indexAst.place == Place.CONSTVAL) {
         int i = ((ConstIntAST)indexAst).val;
         if (i >= ((ArrayType)arrayVarAst.getType()).no) SemErr("constant index out of bounds");
         i *= type.size;
         Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(i), false, "constant index");
         Compiler.code.Emit(Instruction.ADD, "");
         place = Place.ADDRONSTACK;         
      } else if (arrayVarAst.place == Place.ADDRONSTACK && indexAst.place == Place.VALONSTACK) {
         Compiler.code.Emit(Instruction.CHECK, ((ArrayType)arrayVarAst.getType()).no, "");
         if (type.size > 1) {
            Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(type.size), false, "size of data: " + type.size);
            Compiler.code.Emit(Instruction.MUL, "");
         }
         Compiler.code.Emit(Instruction.ADD, "");
         place = Place.ADDRONSTACK;
      }
      // System.out.println("out ArrayRefAST.moveAddr2Stack, place = " + place);
   }

   public void forceAddr2Stack() {
      // System.out.println("in ArrayRefAST.forceAddr2Stack");
      moveAddr2Stack();
      if (place == Place.CONSTADDR || place == Place.INDEXONSTACK) {
         int o = offset;
         if (kind == Kind.STATICVAR) {
            Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(o), false, "static address");
         } else if (kind == Kind.SHAREDVAR || kind == Kind.COMPVAR) {
            Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(o | 0x80000000), false, "static address" + o + " locked");
         } else if (kind == Kind.LOCALVAR) {
            Compiler.code.Emit(Instruction.ADDFP, o, "local address");
         }
      }
      if (place == Place.INDEXONSTACK) {
         Compiler.code.Emit(Instruction.ADD, "");   
      }
      place = Place.ADDRONSTACK;
      // System.out.println("out ArrayRefAST.forceAddr2Stack, place = " + place);
   }

   public void dump(String left) {
      System.out.println(left + "ArrayRefAST");
      arrayVarAst.dump(left + "   ");
      indexAst.dump(left + "   ");
   }

}
