package IRed.spectro.stamped;

import java.util.List;
import java.util.ArrayList;
import java.io.DataOutputStream;
import java.io.IOException;

class ArrayType extends DataType {
	DataType basicTy;
	int no;

	public ArrayType(int n, DataType b) {
		super(0);
		basicTy = b;
		no = n;
      if (basicTy.size != 0) size = basicTy.size * no;
	}

	private ArrayType(ArrayType orig) {
		super(orig);
		basicTy = orig.basicTy;
		no = orig.no;
	}

	public boolean assignable(DataType rhs) {
		return rhs instanceof ArrayType && ((ArrayType)rhs).basicTy.equals(basicTy) && ((ArrayType)rhs).no == no;
	}

	public DataType clone() {
		return new ArrayType(this);
	}

   public boolean equals(Object o) {
      return o instanceof ArrayType && no == ((ArrayType)o).no && basicTy.equals(((ArrayType)o).basicTy);
   }

	public DataType resolveType() {
		if (!resolved) {
			resolved = true;
			basicTy = basicTy.resolveType();
         size = basicTy.size * no;
		}
		return this;
	}

   public List<Integer> getBlobOffsets(int strt) {
      List<Integer> basicOffs = basicTy.getBlobOffsets(0);
      if (basicOffs == null) return null;
      ArrayList<Integer> Offs = new ArrayList<Integer>();
      for (int i = 0, eo = 0; i < no; i++, eo += basicTy.size) {
         for (int o: basicOffs) Offs.add(strt + eo + o);
      }
      return Offs;
   }


	public void dump(String left) {
		System.out.println(left + "Array: " + no);
		basicTy.dump(left + "   ");
	}

   public DataType getBasicType() {
      return basicTy;
   }

   public void dumpBinary(DataOutputStream out) throws IOException {
      out.writeInt(Tag.ARRAY);
      out.writeInt(no);
      basicTy.dumpBinary(out);
  }

}
