package IRed.spectro.stamped;

public class AssignmentAST extends AST {
   TypedAST lhs, rhs;

   public AssignmentAST(int line, int col, TypedAST lhs, TypedAST rhs) {
      super(line, col);
      this.lhs = lhs;
      this.rhs = rhs;
   }

   public boolean distributeTypes(boolean isFunBody) {
      if (!lhs.distributeTypes()) return false;
      // lhs.dump("in AssignmentAST distributeTypes: lhs = ");
      if (lhs.readOnly) {
         SemErr("attempt to modify read-only variable");
         return false;
      }
      if (lhs.kind == Kind.COMPNAME || lhs.kind == Kind.TYPENAME || lhs.kind == Kind.CONSTNAME) { 
         SemErr("assignment to COMPONENT, TYPE or CONST"); 
         return false;
      }
      if (!rhs.distributeTypes()) return false;
      if (!lhs.getType().assignable(rhs.getType())) {
         SemErr("type missmatch in assignment");
         return false;
      }
      if (lhs.getType() instanceof FloatType && rhs.getType() instanceof IntegerType) rhs = new toFloatAST(rhs);
      return true;
   }

   public void generateCode(boolean isTry) {
      if (lhs instanceof LhsTuppleAST) {
         lhs.moveAddr2Stack(false);
         rhs = rhs.moveVal2Stack();
         Compiler.code.Emit(Instruction.STOREP, ((LhsTuppleAST)lhs).wrdCnt, rhs.type.size, "");
      } else {
         lhs.moveAddr2Stack(false);
         // System.out.println("in AssignmentAST generateCode: lhs.place = " + lhs.place);
         if (lhs.place == Place.INDEXESONSTACK || (lhs.type.size > 1 && lhs.place != Place.CONSTADDR)) lhs.forceAddr2Stack();
      
         rhs = rhs.moveVal2Stack();
         rhs.forceVal2Stack();

         // lhs.dump("in AssignmentAST generateCode: ");
         if (lhs.place == Place.CONSTADDR) {
            if (lhs.kind == Kind.STATICVAR || lhs.kind == Kind.SHAREDVAR || lhs.kind == Kind.COMPVAR) {
               if (lhs.type.size == 1) Compiler.code.Emit(Instruction.STORE, lhs.offset, lhs.isBlob(), "static variable");
               else Compiler.code.Emit(Instruction.STOREM, lhs.offset, lhs.type.size, false, lhs.kind != Kind.STATICVAR, lhs.type.getBlobOffsets(0), "");
            } else if (lhs.kind == Kind.LOCALVAR) {
               if (lhs.type.size == 1) Compiler.code.Emit(Instruction.STOREL, lhs.offset, lhs.isBlob(), "");
               else Compiler.code.Emit(Instruction.STOREM, lhs.offset, lhs.type.size, true, false, lhs.type.getBlobOffsets(0), "");         
            } else throw new FatalError("internal error in assignment, lhs.kind = " + lhs.kind + " lhs.place = " + lhs.place); 
         } else if (lhs.place == Place.INDEXONSTACK) {
            int no = ((lhs instanceof LhsAST) ? ((LhsAST)lhs).atype.no : ((LhsQualAST)lhs).atype.no);
            if (lhs.kind == Kind.STATICVAR || lhs.kind == Kind.SHAREDVAR || lhs.kind == Kind.COMPVAR) {
               if (lhs.type.size == 1) Compiler.code.Emit(Instruction.STOREA, lhs.offset, no, lhs.isBlob(), "");
               else throw new FatalError("Internal error in assignment, size > 1 for STOREA");
            } else if (lhs.kind == Kind.LOCALVAR) {
               if (lhs.type.size == 1) Compiler.code.Emit(Instruction.STOREAL, lhs.offset, no, lhs.isBlob(), "");
               else throw new FatalError("Internal error in assignment, size > 1 for STOREAL");
            } else throw new FatalError("internal error in assignment, lhs.kind = " +  lhs.kind + " lhs.place = " + lhs.place); 
         } else if (lhs.place == Place.ADDRONSTACK) {
            if (lhs.kind == Kind.STATICVAR || lhs.kind == Kind.SHAREDVAR || lhs.kind == Kind.COMPVAR || lhs.kind == Kind.LOCALVAR || lhs.kind == Kind.VARPAR) {
               Compiler.code.Emit(Instruction.STOREMV, lhs.type.size, lhs.type.getBlobOffsets(0), "");
            } else throw new FatalError("internal error in assignment, lhs.kind = " + lhs.kind + " lhs.place = " + lhs.place); 
         } else throw new FatalError("internal error in assignment, unknown place");
      }
   }

   public void dump(String left) {
      System.out.println(left + "assignment");
      lhs.dump(left + "   ");
      rhs.dump(left + "   ");
   }

}
