package IRed.spectro.stamped;

import java.util.List;

public class BinaryOpAST extends TypedAST {
	TypedAST sub1, sub2;
	Operators op;

	public BinaryOpAST(int line, int col, Operators o, TypedAST s1, TypedAST s2) {
		super(line, col);
		sub1 = s1; sub2 = s2;
		op = o;
	}

	public TypedAST resolveConst() {
		sub1 = sub1.resolveConst();
		sub2 = sub2.resolveConst();

		if (op == Operators.OR && (sub1 instanceof ConstBoolAST) && (sub2 instanceof ConstBoolAST))
			return new ConstBoolAST(((ConstBoolAST)sub1).val || ((ConstBoolAST)sub2).val);
		if (op == Operators.AND && (sub1 instanceof ConstBoolAST) && (sub2 instanceof ConstBoolAST))
			return new ConstBoolAST(((ConstBoolAST)sub1).val && ((ConstBoolAST)sub2).val);
		if (op == Operators.EQUAL && (sub1 instanceof ConstBoolAST) && (sub2 instanceof ConstBoolAST))
			return new ConstBoolAST(((ConstBoolAST)sub1).val == ((ConstBoolAST)sub2).val);
		if (op == Operators.UNEQUAL && (sub1 instanceof ConstBoolAST) && (sub2 instanceof ConstBoolAST))
			return new ConstBoolAST(((ConstBoolAST)sub1).val != ((ConstBoolAST)sub2).val);
		if ((sub1 instanceof ConstIntAST) && (sub2 instanceof ConstIntAST)) {
			int i1 = ((ConstIntAST)sub1).val, i2 = ((ConstIntAST)sub2).val;

			if (op == Operators.BITOR) return new ConstIntAST(i1 | i2);
			if (op == Operators.BITXOR) return new ConstIntAST(i1 ^ i2);
			if (op == Operators.BITAND) return new ConstIntAST(i1 & i2);

			if (op == Operators.LESS) return new ConstBoolAST(i1 < i2);
			if (op == Operators.LESSEQUAL) return new ConstBoolAST(i1 <= i2);
			if (op == Operators.EQUAL) return new ConstBoolAST(i1 == i2);
			if (op == Operators.GREATEREQUAL) return new ConstBoolAST (i1 >= i2);
			if (op == Operators.GREATER) return new ConstBoolAST(i1 > i2);
			if (op == Operators.UNEQUAL) return new ConstBoolAST(i1 != i2);

			if (op == Operators.ADD) return new ConstIntAST(i1 + i2);
			if (op == Operators.SUB) return new ConstIntAST(i1 - i2);
			if (op == Operators.MUL) return new ConstIntAST(i1 * i2);
			if (op == Operators.IDIV) return new ConstIntAST(i1 / i2);
			if (op == Operators.MOD) return new ConstIntAST(i1 % i2);
		} else if (sub1.isConstNumber() && sub2.isConstNumber()) {
			float f1, f2;

			if (sub1 instanceof ConstIntAST) f1 = ((ConstIntAST)sub1).val;
			else f1 = ((ConstFloatAST)sub1).val;
	
			if (sub2 instanceof ConstIntAST) f2 = ((ConstIntAST)sub2).val;
			else f2 = ((ConstFloatAST)sub2).val;

			if (op == Operators.LESS) return new ConstBoolAST(f1 < f2);
			if (op == Operators.LESSEQUAL) return new ConstBoolAST(f1 <= f2);
			if (op == Operators.EQUAL) return new ConstBoolAST(f1 == f2);
			if (op == Operators.GREATEREQUAL) return new ConstBoolAST (f1 >= f2);
			if (op == Operators.GREATER) return new ConstBoolAST(f1 > f2);
			if (op == Operators.UNEQUAL) return new ConstBoolAST(f1 != f2);

			if (op == Operators.ADD) return new ConstFloatAST(f1 + f2);
			if (op == Operators.SUB) return new ConstFloatAST(f1 - f2);
			if (op == Operators.MUL) return new ConstFloatAST(f1 * f2);
			if (op == Operators.DIV) return new ConstFloatAST(f1 / f2);
		} else if (sub1 instanceof ConstTsAST && sub2 instanceof ConstTsAST) {
			int ts1 = ((ConstTsAST)sub1).val, ts2 = ((ConstTsAST)sub2).val;
         if (op == Operators.LESS) return new ConstBoolAST(ts1 < ts2);
         if (op == Operators.GREATER) return new ConstBoolAST(ts1 > ts2);
         if (op == Operators.DURATION) {
            int d = ts1 - ts2;         // will probably overflow...
            if (d < 0) d = -d;
            d++;
            return new ConstIntAST(d);
         }
      }
		return this;
	}

   public boolean distributeTypes(boolean isFunBody) {
      if (!sub1.distributeTypes()) return false;
      if (!sub2.distributeTypes()) return false;      
      if (sub1.place == Place.CONSTVAL && sub2.place == Place.CONSTVAL) place = Place.CONSTVAL;

      if (sub1.isBool() && sub2.isBool()) {
         if (op == Operators.OR || op == Operators.AND || op == Operators.EQUAL || op == Operators.UNEQUAL)
            type = new BoolType();
         else {
            SemErr("invalid operator for BOOLEAN");
            return false;
         }
      } else if (sub1.isInteger() && sub2.isInteger()) {
			if (op == Operators.BITOR || op == Operators.BITXOR || op == Operators.BITAND || 
             op == Operators.ADD || op == Operators.SUB || op == Operators.MUL || op == Operators.IDIV || op == Operators.MOD)
         {
            type = new IntegerType();
         } else if (op == Operators.LESS || op == Operators.LESSEQUAL || op == Operators.EQUAL || op == Operators.GREATEREQUAL || op == Operators.GREATER || op == Operators.UNEQUAL) {
            type = new BoolType();
         } else {
            SemErr("invalid operator for INTEGER");
            return false;
         }
      } else if (sub1.isNumber() && sub2.isNumber()) {
         if (!sub1.isFloat()) sub1 = new toFloatAST(sub1);
         if (!sub2.isFloat()) sub2 = new toFloatAST(sub2);

			if (op == Operators.LESS || op == Operators.LESSEQUAL || op == Operators.EQUAL || op == Operators.GREATEREQUAL || op == Operators.GREATER || op == Operators.UNEQUAL)
            type = new BoolType();
         else if (op == Operators.ADD || op == Operators.SUB || op == Operators.MUL || op == Operators.DIV)
            type = new FloatType();
         else {
            SemErr("invalid operator for FLOAT");
            return false;
         }
      } else if (sub1.isTimeStamp() && sub2.isTimeStamp()) {
         if (op == Operators.LESS || op == Operators. GREATER) 
            type = new BoolType();
         else if (op == Operators.DURATION)
            type = new IntegerType();
         else {
            SemErr("invalid operator for TIMESTAMP");
            return false;
         }
      } else {
         SemErr("type mismatch");
         return false;
      }
      return true;
   }

   public TypedAST moveVal2Stack() {
      // System.out.println("in BinaryOpAST moveVal2Stack, op = " + op + " sub1.place = " + sub1.place + " sub2.place = " + sub2.place);
      if (place == Place.CONSTVAL) return resolveConst();
      if (sub1.place == Place.CONSTVAL && isBool() && (op == Operators.OR || op == Operators.AND)) {
         sub1 = sub1.moveVal2Stack();
         boolean v = ((ConstBoolAST)sub1).val;
         if (op == Operators.OR) {
            return (v) ? sub1 : sub2.moveVal2Stack();
         } else {
            return (v) ? sub2.moveVal2Stack() : sub1;
         }
      } else if (sub2.place == Place.CONSTVAL && isBool() && (op == Operators. OR || op == Operators.AND)) {
         sub2 = sub2.moveVal2Stack();
         boolean v = ((ConstBoolAST)sub2).val;
         if (op == Operators.OR) {
            return (v) ? sub2 : sub1.moveVal2Stack();
         } else {
            return (v) ? sub1.moveVal2Stack() : sub2;
         }
      }
      sub1 = sub1.moveVal2Stack();
      // System.out.println("in BinaryOpAST, moveVal2Stack, sub1.place = " + sub1.place);
      if (sub1.place == Place.VALONSTACK && isBool() && (op == Operators.OR || op == Operators.AND)) {
         if (sub2.place != Place.CONSTVAL) {
            Code.Label End = Compiler.code.genLabel();
            Compiler.code.Emit(((op == Operators.OR) ? Instruction.ORJMP : Instruction.ANDJMP), End, "");
            sub2 = sub2.moveVal2Stack();
            sub2.forceVal2Stack();
            Compiler.code.setLabel(End);
            place = Place.VALONSTACK;
         }
      } else {
         sub1.forceVal2Stack();
         if (sub1.place != Place.VALONSTACK) {
            throw new FatalError("cannot force value to stack");
         }
         sub2 = sub2.moveVal2Stack();
         // System.out.println("in BinaryOpAST, move Val2Stack, sub2.place  = " + sub2.place);
         sub2.forceVal2Stack();
         // sub2.dump("BinaryOpAST sub2 = ");
         // System.out.println("in BinaryOpAST, move Val2Stack, sub2.place  = " + sub2.place);
         if (sub2.place != Place.VALONSTACK) {
            throw new FatalError("cannot force value to stack");
         }
         if (isBool()) {
            if (sub1.isBool() && op == Operators.EQUAL) {
               Compiler.code.Emit(Instruction.EQ, "");
            } else if (sub1.isBool() && op == Operators.UNEQUAL) {
               Compiler.code.Emit(Instruction.NEQ, "");
            } else if (sub1.isInteger() || sub1.isTimeStamp()) {
			      if (op == Operators.LESS) {
                  Compiler.code.Emit(Instruction.LT, "");
               } else if (op == Operators.LESSEQUAL) {
                  Compiler.code.Emit(Instruction.LE, "");
               } else if (op == Operators.EQUAL) {
                  Compiler.code.Emit(Instruction.EQ, "");
               } else if (op == Operators.GREATEREQUAL) {
                  Compiler.code.Emit(Instruction.GE, "");
               } else if (op == Operators.GREATER) {
                  Compiler.code.Emit(Instruction.GT, "");
               } else if (op == Operators.UNEQUAL) {
                  Compiler.code.Emit(Instruction.NEQ, "");
               } else {
                  throw new FatalError("invalid operator");
               }
            } else if (sub1.isFloat()) {
			      if (op == Operators.LESS) {
                  Compiler.code.Emit(Instruction.FLT, "");
               } else if (op == Operators.LESSEQUAL) {
                  Compiler.code.Emit(Instruction.FLE, "");
               } else if (op == Operators.EQUAL) {
                  Compiler.code.Emit(Instruction.FEQ, "");
               } else if (op == Operators.GREATEREQUAL) {
                  Compiler.code.Emit(Instruction.FGE, "");
               } else if (op == Operators.GREATER) {
                  Compiler.code.Emit(Instruction.FGT, "");
               } else if (op == Operators.UNEQUAL) {
                  Compiler.code.Emit(Instruction.FNEQ, "");
               } else {
                  throw new FatalError("invalid operator");
               }
            }
            place = Place.VALONSTACK;
         } else if (isInteger()) {
			   if (op == Operators.BITOR) {
                  Compiler.code.Emit(Instruction.OR, "");
            } else if (op == Operators.BITXOR) {
                  Compiler.code.Emit(Instruction.XOR, "");
            } else if (op == Operators.BITAND) {
                  Compiler.code.Emit(Instruction.AND, "");
            } else if (op == Operators.ADD) {
                  Compiler.code.Emit(Instruction.ADD, "");
            } else if (op == Operators.SUB) {
                  Compiler.code.Emit(Instruction.SUB, "");
            } else if (op == Operators.MUL) {
                  Compiler.code.Emit(Instruction.MUL, "");
            } else if (op == Operators.IDIV) {
                  Compiler.code.Emit(Instruction.DIV, "");
            } else if (op == Operators.MOD) {
                  Compiler.code.Emit(Instruction.MOD, "");
            } else if (op == Operators.DURATION) {
                  Compiler.code.Emit(Instruction.DURATION, "");
            } else {
               throw new FatalError("invalid operator");
            }
            place = Place.VALONSTACK;
         } else if (isFloat()) {
            if (op == Operators.ADD) {
                  Compiler.code.Emit(Instruction.FADD, "");
            } else if (op == Operators.SUB) {
                  Compiler.code.Emit(Instruction.FSUB, "");
            } else if (op == Operators.MUL) {
                  Compiler.code.Emit(Instruction.FMUL, "");
            } else if (op == Operators.DIV) {
                  Compiler.code.Emit(Instruction.FDIV, "");
            } else {
               throw new FatalError("invalid operator");
            }
            place = Place.VALONSTACK;
         }
      }
      return this;
   }

   public void forceVal2Stack() {
      if (place != Place.VALONSTACK) {
         throw new FatalError("cannot force value to stack");
      }
   }

   public void qualifyOnStack(int baseSize, List<Integer> blobLst) {
      throw new FatalError("internal error, invalid qualification");
   }

   public void moveAddr2Stack(boolean check) {}

   public void forceAddr2Stack() {}

	public void dump(String left) {
		System.out.println(left + op);
		sub1.dump(left + "   ");
		sub2.dump(left + "   ");
	}

}

