package IRed.spectro.stamped;

import java.util.List;
import java.util.ArrayList;
import java.io.DataOutputStream;
import java.io.IOException;

public class BlobType extends DataType {

	public BlobType () {
		super(1);
	}

	private BlobType(BlobType orig) {
		super(orig);
	}

	public boolean assignable(DataType rhs) {
		return rhs instanceof BlobType;
	}

	public DataType clone() {
		return new BlobType(this);
	}

   public boolean equals(Object o) {
      return o instanceof BlobType;
   }

	public DataType resolveType() {return this;}

   public boolean distributeTypes() {
      return true;
   }

   public List<Integer> getBlobOffsets(int strt) {
      ArrayList<Integer> os = new ArrayList<Integer>();
      os.add(strt);
      return os;
   }

	public void dump(String left) {
		System.out.println(left + "Blob");
	}

   public void dumpBinary(DataOutputStream out) throws IOException {
      out.writeInt(Tag.BLOB);
   }

}
