package IRed.spectro.stamped;

import java.util.LinkedList;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

class Compiler {
   
   public static Parser parser;
   public static Code code;
   public static LinkedList<TaskAST> tasks;
   public static SymbolTable sharedSyms;
   public static String LibraryPath;
   public static String compName;
   public static SymbolTable compSyms;


   public static void main(String[] args) {
      Scanner scanner = new Scanner(args[0]);
      parser = new Parser(scanner);
      code = new Code();
      LibraryPath = args[1];
      compName = null; compSyms = null;
      parser.Parse();
      System.out.println(parser.errors.count + " errors detected");
      if (parser.errors.count == 0 && args.length > 1) {
         try {
            FileOutputStream fos = new FileOutputStream(args[2]);
            DataOutputStream dos = new DataOutputStream(fos);
            code.dumpBinary(dos, sharedSyms, tasks);
            dos.close();
         } catch (IOException e) {
            System.out.println("Cannot open " + args[2]);
         }
      }
   }

}

