package IRed.spectro.stamped;

public class ComponentCallAST extends AST {
   SymbolTable scope;
   String name, qual;
   ActParsAST params;
   private Symbol compSym;
   private Symbol compProc;

   public ComponentCallAST(int line, int col, SymbolTable scope,  String name, String qual, ActParsAST params) {
      super(line, col);
      this.scope = scope;
      this.name = name;
      this.qual = qual;
      this.params = params;
      compProc = compSym = null;
   }

   public boolean distributeTypes(boolean isFunBody) {
      compSym = scope.find(name);
      if (compSym == null || !(compSym.type instanceof ComponentTy)) {
         System.out.println("in ComponentCallAst DistributeTypes");
         SemErr("not declared as COMPONENT");
         return false;
      }
      compProc = ((ComponentTy)compSym.type).syms.find(qual);
      if (compProc == null || !(compProc.type instanceof ProcType)) {
         SemErr("not declared as PROCEDURE");
         return false;
      }        
      ProcType ptype = (ProcType)compProc.type;
      if (params == null) {
         if (ptype.parcnt != 0) {
            SemErr("wrong number of arguments in call");
            return false;
         }
         return true;
      } else {
         if (!params.distributeTypes()) return false;   
         if (!params.checkTypes(ptype.parcnt, ptype.locals)) return false;
      }
      if (ptype.retType != null) {
         SemErr("COMPONENT PROCEDURE returns value");
         return false;
      }
      return true;
   }

	public void generateCode(boolean isTry) {
      ProcType ty = (ProcType)compProc.type;
      if (params != null) params.move2Stack(ty.parcnt, ty.locals);
      Compiler.code.Emit(Instruction.LOAD, compSym.offset, false, "");
      Compiler.code.Emit(Instruction.COMPCALL, ty.procNo, "");
   }

	public void dump(String left) {
      System.out.println(left + "component call");
      if (params != null) params.dump(left + "   ");
   }

}

