package IRed.spectro.stamped;

import java.util.List;

public class ConstBoolAST extends TypedAST {
	boolean val;

	public ConstBoolAST(int line, int col, boolean v) {
		super(line, col, new BoolType());
		val = v;
      place = Place.CONSTVAL;
	}

	public ConstBoolAST(boolean v) {
		super(-1, -1, new BoolType());
		val = v;
      place = Place.CONSTVAL;
	}

	public TypedAST resolveConst() {return this;}

   public boolean distributeTypes(boolean isFunBody) {return true;}

   public void moveAddr2Stack(boolean check) {}

   public void forceAddr2Stack() {}

   public void qualifyOnStack(int baseSize, List<Integer> blobLst) {
      throw new FatalError("internal error, invalid qualification");
   }

   public TypedAST moveVal2Stack() {
      return this;
   }

   public void forceVal2Stack() {
      int ival = ((val) ? 1 : 0);
      Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(ival), false, "constant " + val);
      place = Place.VALONSTACK;
   }

	public void dump(String left) {
		System.out.println(left + "ConstBool: " + val);
	}

}
