package IRed.spectro.stamped;

import java.util.List;

public class ConstStringAST extends TypedAST {

   static final long serialVersionUID = 0;

	int val;

	public ConstStringAST(int line, int col, String v) {
		super(line, col, new StringType());
		val = Compiler.code.EmitConst(v);
      place = Place.CONSTVAL;
	}

	public ConstStringAST(String v) {
		super(-1, -1, new StringType());
		val = Compiler.code.EmitConst(v);
      place = Place.CONSTVAL;
	}

	public TypedAST resolveConst() {return this;}

   public boolean distributeTypes(boolean isFunBody) {return true;}

   public void moveAddr2Stack(boolean check) {}

   public void forceAddr2Stack() {}

   public void qualifyOnStack(int baseSize, List<Integer> blobLst) {
      throw new FatalError("internal error, invalid qualification");
   }

   public TypedAST moveVal2Stack() {
      return this;
   }

   public void forceVal2Stack() {
      Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(val), false, "constant " + val);
      place = Place.VALONSTACK;
   }

	public void dump(String left) {
		System.out.println(left + "ConstString: " + val);
	}


}
