package IRed.spectro.stamped;

import java.util.List;

public class ConstTsAST extends TypedAST {
	int val;

	public ConstTsAST(int line, int col, int v) {
		super(line, col, new TimeStampType());
		val = v;
      place = Place.CONSTVAL;
	}

	public ConstTsAST(int v) {
		super(-1, -1, new IntegerType());
		val = v;
      place = Place.CONSTVAL;
	}

	public TypedAST resolveConst() {return this;}

   public boolean distributeTypes(boolean isFunBody) {return true;}

   public void moveAddr2Stack(boolean check) {}

   public void forceAddr2Stack() {}

   public void qualifyOnStack(int baseSize, List<Integer> blobLst) {
      throw new FatalError("internal error, invalid qualification");
   }

   public TypedAST moveVal2Stack() {
      return this;
   }

   public void forceVal2Stack() {
      Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(val), false, "constant " + val);
      place = Place.VALONSTACK;
   }

	public void dump(String left) {
		System.out.println(left + "ConstTs: " + val);
	}

}
