package IRed.spectro.stamped;

import java.util.List;
import java.io.DataOutputStream;
import java.io.IOException;

abstract class DataType implements Cloneable {
	int size;
	boolean resolved;

   protected DataType() {
      size = 0;
      resolved = false;
   }

	public DataType(int s) {
		size = s;
		resolved = false;
	}

	protected DataType(DataType orig) {
		size = orig.size;
		resolved = false;
	}

	public abstract DataType clone();

   public abstract boolean equals(Object o);

	public abstract boolean assignable(DataType rhs);

	public abstract DataType resolveType();

   public List<Integer> getBlobOffsets(int strt) {
      return null;
   }

	public abstract void dump(String left);

   public abstract void dumpBinary(DataOutputStream out) throws IOException;

}
