package IRed.spectro.stamped;

import java.io.DataOutputStream;
import java.io.IOException;

public class EventType extends DataType {
   SymbolTable syms;
   int no;

	public EventType (SymbolTable syms, TypedAST siz) {
		super(0);
      this.syms = syms;
      siz = siz.resolveConst();
      if (!(siz instanceof ConstIntAST)) no = 0;
      else no = ((ConstIntAST) siz).val;
	}

	public boolean assignable(DataType rhs) {
		return false;
	}

	public DataType clone() {
		return this;               // pointless to clone
	}

   public boolean equals(Object o) {
      return false;
   }

	public DataType resolveType() {
      // System.out.println("resolving EventType, resolved = " + resolved);
      if (!resolved) {
         // System.out.println("resolving EventType");
         if (!syms.resolveTypes()) Compiler.parser.SemErr("Unable to resolve types");
         resolved = true;
      }
      return this;
   }

	public void dump(String left) {
		System.out.println(left + "Event");
	}

   public void dumpBinary(DataOutputStream out) throws IOException {
   }

}
