package IRed.spectro.stamped;

import java.util.List;

public class ExtremeTsAST extends TypedAST {
   boolean earliest;
   List<TypedAST> TStamps;

   public ExtremeTsAST(int line, int col, boolean earliest, List<TypedAST> TStamps) {
      super(line, col);
      this.earliest = earliest;
      this.TStamps = TStamps;
   }

	public TypedAST resolveConst() {
      return this;
   }

   public boolean distributeTypes(boolean isFunBody) {
      for (TypedAST ast: TStamps) {
         if (!ast.distributeTypes()) return false; 
         if (!(ast.getType() instanceof TimeStampType)) {
            SemErr("type missmatch, not a TIMESTAMP");
            return false;
         }
      }
      type = new TimeStampType();
      return true;
   }

   public void moveAddr2Stack(boolean check) {
      moveVal2Stack();
   }

   public void forceAddr2Stack() {
      moveVal2Stack();
   }

   public void qualifyOnStack(int baseSize, List<Integer> blobLst) {
      throw new FatalError("internal error, invalid qualification");
   }

   public TypedAST moveVal2Stack() {
      int l = 0;
      for (TypedAST ast: TStamps) {
         ast = ast.moveVal2Stack();
         ast.forceVal2Stack();
         l++;
      }
      Compiler.code.Emit(((earliest) ? Instruction.EARLIEST : Instruction.LATEST), l, "");   
      place = Place.VALONSTACK;
      return this;
   }

   public void forceVal2Stack() {
   }

	public void dump(String left) {
		System.out.println(left + "Extreme TS");
		for (TypedAST ast: TStamps) {
         ast.dump(left + "   ");
      }
	}

}
